/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.add.area;

import au.org.ala.legend.Facet;
import au.org.ala.spatial.composer.add.area.AreaToolComposer;
import au.org.ala.spatial.composer.layer.EnvLayersCombobox;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.LayersUtil;
import au.org.ala.spatial.util.SPLFilter;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.menu.MapLayer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Button;
import org.zkoss.zul.Div;
import org.zkoss.zul.Doublebox;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.SimpleListModel;
import org.zkoss.zul.Slider;
import org.zkoss.zul.Textbox;

public class AreaEnvironmentalEnvelope
extends AreaToolComposer {
    public static final String LAYER_PREFIX = "working envelope: ";
    private static final Logger LOGGER = Logger.getLogger(AreaEnvironmentalEnvelope.class);
    private static final long serialVersionUID = -26560838825366347L;
    private static final String[] FILTER_COLOURS = new String[]{"0x0000FF", "0x000FF00", "0x00FFFF", "0xFF00FF"};
    private Div popupContinous;
    private Slider popupSliderMin;
    private Slider popupSliderMax;
    private Label popupRange;
    private Doublebox popupMinimum;
    private Doublebox popupMaximum;
    private Textbox popupIdx;
    private Button removeContinous;
    private Label labelContinous;
    private Button applyContinous;
    private Listbox lbSelLayers;
    private EnvLayersCombobox cbEnvLayers;
    private Button filterDone;
    private SPLFilter popupFilter;
    private Listcell popupCell;
    private Listitem popupItem;
    private Textbox txtLayerName;
    private int speciescount = 0;
    private boolean isDirtyCount = true;
    private boolean cancelling = false;
    private List<JSONObject> selectedLayers;
    private Map<String, SPLFilter> selectedSPLFilterLayers;
    private MapComposer mc;
    private String activeAreaSize = null;

    public void afterCompose() {
        super.afterCompose();
        this.mc = this.getMapComposer();
        this.selectedLayers = new ArrayList();
        this.selectedSPLFilterLayers = new HashMap();
        this.txtLayerName.setValue(this.getMapComposer().getNextAreaLayerName(CommonData.lang((String)"default_area_layer_name")));
        this.cbEnvLayers.setIncludeLayers("environmental");
    }

    public String getAreaSize() {
        if (this.activeAreaSize != null) {
            return this.activeAreaSize;
        }
        return null;
    }

    public void onChange$cbEnvLayers(Event event) {
        this.applyFilter(true);
    }

    public void onChange$popupMinimum(Event event) {
        this.isDirtyCount = true;
        LOGGER.debug((Object)("popupMinimum=" + this.popupMinimum.getValue() + " " + event.getData()));
        this.popupFilter.setMinimumValue(this.popupMinimum.getValue().doubleValue());
        this.serverFilter();
    }

    public void onChange$popupMaximum(Event event) {
        this.isDirtyCount = true;
        this.popupFilter.setMaximumValue(this.popupMaximum.getValue().doubleValue());
        this.serverFilter();
    }

    public void doAdd(String newValue) {
        String nv = newValue;
        try {
            JSONObject layer = null;
            if (nv.length() == 0 && this.cbEnvLayers.getItemCount() > 0 && this.cbEnvLayers.getSelectedItem() != null) {
                layer = (JSONObject)this.cbEnvLayers.getSelectedItem().getValue();
                nv = layer.get((Object)"name").toString();
                this.cbEnvLayers.setValue("");
            }
            if (nv.isEmpty()) {
                return;
            }
            if (!this.selectedLayers.contains(layer)) {
                this.selectedLayers.add(layer);
            }
            this.lbSelLayers.setItemRenderer((ListitemRenderer)new /* Unavailable Anonymous Inner Class!! */);
            this.lbSelLayers.setModel((ListModel)new SimpleListModel(this.selectedLayers));
            Listitem li = this.lbSelLayers.getItemAtIndex(this.lbSelLayers.getItemCount() - 1);
            Listcell lc = (Listcell)li.getFirstChild();
            lc = (Listcell)lc.getNextSibling();
            this.listFix();
            this.showAdjustPopup(layer, lc, li);
            this.filterDone.setDisabled(false);
        }
        catch (Exception e) {
            LOGGER.error((Object)("error adding layer to EE : " + nv), (Throwable)e);
        }
        this.activeAreaSize = null;
    }

    private SPLFilter getSPLFilter(JSONObject layer) {
        SPLFilter splf = (SPLFilter)this.selectedSPLFilterLayers.get(layer.get((Object)"name").toString());
        if (splf == null) {
            splf = new SPLFilter();
            splf.setCount(0);
            splf.setLayername(layer.get((Object)"name").toString());
            splf.setLayer(layer);
            splf.setMinimumValue(Double.parseDouble(layer.get((Object)"environmentalvaluemin").toString()));
            splf.setMaximumValue(Double.parseDouble(layer.get((Object)"environmentalvaluemax").toString()));
            splf.setMinimumInitial(Double.parseDouble(layer.get((Object)"environmentalvaluemin").toString()));
            splf.setMaximumInitial(Double.parseDouble(layer.get((Object)"environmentalvaluemax").toString()));
            splf.setChanged(false);
            this.selectedSPLFilterLayers.put(layer.get((Object)"name").toString(), splf);
        }
        return splf;
    }

    public void deleteSelectedFilters(Object o) {
        Listitem li;
        this.popupContinous.setVisible(false);
        if (o == null) {
            int count = this.lbSelLayers.getItemCount();
            li = this.lbSelLayers.getItemAtIndex(count - 1);
        } else {
            li = (Listitem)((Listcell)o).getParent();
        }
        int idx = li.getIndex();
        JSONObject layer = (JSONObject)this.selectedLayers.get(idx);
        Events.echoEvent((String)"removeLayer", (Component)this, (String)layer.get((Object)"name").toString());
        this.selectedLayers.remove(layer);
        li.detach();
        this.showAdjustPopup(null);
        this.filterDone.setDisabled(this.selectedLayers.isEmpty());
        this.listFix();
        this.activeAreaSize = null;
    }

    public void onClick$btnClearSelection(Event event) {
        this.popupContinous.setVisible(false);
        this.filterDone.setDisabled(true);
        int count = this.lbSelLayers.getItemCount();
        if (count == 0) {
            return;
        }
        Listitem li = this.lbSelLayers.getItemAtIndex(count - 1);
        int idx = li.getIndex();
        JSONObject layer = (JSONObject)this.selectedLayers.get(idx);
        Events.echoEvent((String)"removeLayerClearSelected", (Component)this, (String)layer.get((Object)"displayname").toString());
        this.selectedLayers.remove(layer);
        li.detach();
        if (this.selectedLayers.isEmpty()) {
            this.showAdjustPopup(null);
            this.listFix();
        }
    }

    public void removeLayerClearSelected(Event event) {
        String layername = (String)event.getData();
        if (!this.selectedLayers.isEmpty()) {
            Events.echoEvent((String)"onClick$btnClearSelection", (Component)this, null);
        }
        if (this.mc.getMapLayer(LAYER_PREFIX + layername) != null) {
            this.mc.removeLayer(LAYER_PREFIX + layername);
        }
    }

    public void removeLayers(Event event) {
        String all = (String)event.getData();
        String layername = all;
        int p = layername.indexOf(124);
        if (p > 0) {
            Events.echoEvent((String)"removeLayers", (Component)this, (String)layername.substring(p + 1));
            layername = layername.substring(0, p);
        }
        if (this.mc.getMapLayer(LAYER_PREFIX + layername) != null) {
            this.mc.removeLayer(LAYER_PREFIX + layername);
        }
        if (p <= 0) {
            this.detach();
        }
    }

    public void removeLayer(Event event) {
        String layername = (String)event.getData();
        if (this.mc.getMapLayer(LAYER_PREFIX + layername) != null) {
            this.mc.removeLayer(LAYER_PREFIX + layername);
        }
    }

    public void listFix() {
        Listitem li;
        int i;
        List list = this.lbSelLayers.getItems();
        for (i = 0; list != null && i < list.size() - 1; ++i) {
            li = (Listitem)list.get(i);
            li.setDisabled(true);
        }
        if (list != null && !list.isEmpty()) {
            li = (Listitem)list.get(i);
            li.setDisabled(false);
        }
    }

    public void onScroll$popupSliderMin(Event event) {
        LOGGER.debug((Object)"Changing min slider");
        try {
            int curpos = this.popupSliderMin.getCurpos();
            double range = this.popupFilter.getMaximumInitial() - this.popupFilter.getMinimumInitial();
            this.popupMinimum.setValue((double)((float)((double)curpos / 100.0 * range + this.popupFilter.getMinimumInitial())));
            this.popupFilter.setMinimumValue(this.popupMinimum.getValue().doubleValue());
            ((Listcell)this.popupItem.getChildren().get(1)).setLabel(this.popupFilter.getFilterString());
            this.serverFilter();
        }
        catch (Exception e) {
            LOGGER.error((Object)"slider change min", (Throwable)e);
        }
    }

    public void onScroll$popupSliderMax(Event event) {
        LOGGER.debug((Object)"Changing max slider");
        try {
            int curpos = this.popupSliderMax.getCurpos();
            double range = this.popupFilter.getMaximumInitial() - this.popupFilter.getMinimumInitial();
            this.popupMaximum.setValue((double)((float)((double)curpos / 100.0 * range + this.popupFilter.getMinimumInitial())));
            this.popupFilter.setMaximumValue(this.popupMaximum.getValue().doubleValue());
            ((Listcell)this.popupItem.getChildren().get(1)).setLabel(this.popupFilter.getFilterString());
            this.serverFilter();
        }
        catch (Exception e) {
            LOGGER.error((Object)"slider change max", (Throwable)e);
        }
    }

    private void showAdjustPopup(Object obj) {
        Listitem li;
        Object o = obj;
        if (o == null) {
            int i = this.lbSelLayers.getItemCount();
            if (i < 1) {
                this.popupContinous.setVisible(false);
                return;
            }
            li = this.lbSelLayers.getItemAtIndex(i - 1);
            List list = li.getChildren();
            o = list.get(list.size() - 2);
        }
        Listcell lc = (Listcell)o;
        li = (Listitem)lc.getParent();
        JSONObject layer = (JSONObject)li.getValue();
        this.popupFilter = this.getSPLFilter(layer);
        this.popupIdx.setValue(layer.get((Object)"displayname").toString());
        this.popupCell = lc;
        this.popupItem = li;
        this.labelContinous.setValue("edit envelope for: " + layer.get((Object)"displayname").toString());
        String csv = String.format("%.4f", Float.valueOf((float)this.popupFilter.getMinimumInitial())) + " - " + String.format("%.4f", Float.valueOf((float)this.popupFilter.getMaximumInitial()));
        this.popupRange.setValue(csv);
        this.popupMinimum.setValue((double)((float)this.popupFilter.getMinimumValue()));
        this.popupMaximum.setValue((double)((float)this.popupFilter.getMaximumValue()));
        double range = this.popupFilter.getMaximumInitial() - this.popupFilter.getMinimumInitial();
        int maxcursor = (int)((this.popupFilter.getMinimumValue() - this.popupFilter.getMinimumInitial()) / range * 100.0);
        int mincursor = (int)((this.popupFilter.getMinimumValue() - this.popupFilter.getMinimumInitial()) / range * 100.0);
        this.doApplyFilter(layer, Double.toString(this.popupFilter.getMinimumValue()), Double.toString(this.popupFilter.getMaximumValue()));
        this.popupSliderMin.setCurpos(mincursor);
        this.popupSliderMax.setCurpos(maxcursor);
        lc.focus();
        LOGGER.debug((Object)("attaching: " + lc + lc.getValue()));
        this.popupContinous.setVisible(true);
    }

    private void showAdjustPopup(JSONObject layer, Listcell lc, Listitem li) {
        this.popupFilter = this.getSPLFilter(layer);
        this.popupIdx.setValue(layer.get((Object)"displayname").toString());
        this.popupCell = lc;
        this.popupItem = li;
        this.labelContinous.setValue("edit envelope for: " + layer.get((Object)"displayname"));
        String csv = String.format("%.4f", Float.valueOf((float)this.popupFilter.getMinimumValue())) + " - " + String.format("%.4f", Float.valueOf((float)this.popupFilter.getMaximumValue()));
        this.popupRange.setValue(csv);
        this.popupMinimum.setValue((double)((float)this.popupFilter.getMinimumValue()));
        this.popupMaximum.setValue((double)((float)this.popupFilter.getMaximumValue()));
        double range = this.popupFilter.getMaximumValue() - this.popupFilter.getMinimumValue();
        int maxcursor = (int)((this.popupFilter.getMaximumValue() - this.popupFilter.getMinimumValue()) / range * 100.0);
        int mincursor = (int)((this.popupFilter.getMinimumValue() - this.popupFilter.getMinimumValue()) / range * 100.0);
        this.doApplyFilter(layer, Double.toString(this.popupFilter.getMinimumValue()), Double.toString(this.popupFilter.getMaximumValue()));
        this.popupSliderMin.setCurpos(mincursor);
        this.popupSliderMax.setCurpos(maxcursor);
        this.popupContinous.setVisible(true);
    }

    private void serverFilter() {
        this.doApplyFilter(this.popupFilter.getLayer(), Double.toString(this.popupFilter.getMinimumValue()), Double.toString(this.popupFilter.getMaximumValue()));
    }

    private void doApplyFilter(JSONObject layer, String val1, String val2) {
        if (layer == null) {
            LOGGER.error((Object)("error adding new filtered layer=null, min/max: " + val1 + "/" + val2));
        } else {
            this.loadMap(layer, this.lbSelLayers.getItemCount() - 1, Double.parseDouble(val1), Double.parseDouble(val2), false);
        }
    }

    public void onClick$filterDone(Event event) {
        this.ok = true;
        try {
            StringBuilder sbProcessUrl = new StringBuilder();
            sbProcessUrl.append(CommonData.getSatServer()).append("/ws/envelope?area=").append(this.getWkt());
            HttpClient client = new HttpClient();
            PostMethod post = new PostMethod(sbProcessUrl.toString());
            LOGGER.debug((Object)sbProcessUrl.toString());
            post.addRequestHeader("Accept", "text/plain");
            client.executeMethod((HttpMethod)post);
            String slist = post.getResponseBodyAsString();
            String[] list = slist.split("\n");
            String pid = list[0];
            String url = CommonData.getGeoServer() + "/wms?service=WMS&version=1.1.0&request=GetMap&layers=ALA:envelope_" + pid + "&FORMAT=image%2Fpng";
            String activeAreaExtent = list[1];
            this.activeAreaSize = list[2];
            MapLayer ml = this.mc.addWMSLayer(pid, this.txtLayerName.getText(), url, 0.75f, null, null, 22, null, null);
            int colour = Util.nextColour();
            int r = colour >> 16 & 0xFF;
            int g = colour >> 8 & 0xFF;
            int b = colour & 0xFF;
            ml.setRedVal(r);
            ml.setGreenVal(g);
            ml.setBlueVal(b);
            ml.setDynamicStyle(true);
            ml.setPolygonLayer(true);
            this.getMapComposer().applyChange(ml);
            this.getMapComposer().updateLayerControls();
            StringBuilder sb = new StringBuilder();
            StringBuilder sbLayerList = new StringBuilder();
            sb.append("Environmental Envelope<br>");
            for (int i = 0; i < this.selectedLayers.size(); ++i) {
                JSONObject layer = (JSONObject)this.selectedLayers.get(i);
                SPLFilter f = this.getSPLFilter(layer);
                sb.append(f.getLayername()).append(": ").append(f.getFilterString()).append("<br>");
                sbLayerList.append(f.getLayername());
                if (i >= this.selectedLayers.size() - 1) continue;
                sbLayerList.append(":");
            }
            String activeAreaMetadata = LayersUtil.getMetadata((String)sb.toString());
            this.getMapComposer().setAttribute("activeLayerName", (Object)sbLayerList.toString());
            this.getMapComposer().setAttribute("mappolygonlayer", (Object)sb.toString());
            String finalWkt = null;
            try {
                finalWkt = this.getWkt();
            }
            catch (Exception e) {
                LOGGER.error((Object)"failed to get WKT", (Throwable)e);
            }
            this.layerName = ml.getName();
            ArrayList<Double> bb = new ArrayList<Double>(4);
            String[] bs = activeAreaExtent.split(",");
            for (int i = 0; i < 4; ++i) {
                bb.add(Double.parseDouble(bs[i]));
            }
            ml.getMapLayerMetadata().setBbox(bb);
            ml.getMapLayerMetadata().setMoreInfo(activeAreaMetadata);
            ml.setWKT("ENVELOPE(" + finalWkt + ")");
            ml.setEnvelope(finalWkt);
            try {
                double area = Double.parseDouble(this.activeAreaSize.replace(",", ""));
                this.activeAreaSize = String.format("%,.2f", area);
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)("failed to parse environmental envelope area for: " + this.activeAreaSize));
            }
            ml.setAreaSqKm(this.activeAreaSize);
            ml.setFacets(this.getFacets());
            this.removeAllSelectedLayers(true);
        }
        catch (Exception e) {
            LOGGER.error((Object)"unable to create envelope layer: ", (Throwable)e);
        }
        this.mc.updateLayerControls();
    }

    public void onClick$applyContinous(Event event) {
        this.applyFilter();
        this.isDirtyCount = false;
    }

    public void onClick$removeContinous(Event event) {
        this.deleteSelectedFilters(null);
        this.isDirtyCount = false;
    }

    private int getSpeciesCount() {
        BiocacheQuery q = new BiocacheQuery(null, null, null, this.getFacets(), false, null);
        return q.getSpeciesCount();
    }

    public void onLater(Event event) throws Exception {
        this.applyFilterEvented();
        this.speciescount = this.getSpeciesCount();
        this.popupFilter.setCount(this.speciescount);
        ((Listcell)this.popupItem.getChildren().get(2)).setLabel(this.speciescount + "");
        Clients.clearBusy();
    }

    public void onLateron(Event event) throws Exception {
        this.applyFilterEvented();
        this.doAdd("");
    }

    public void applyFilter() {
        if (this.lbSelLayers.getItemCount() == 0) {
            return;
        }
        Clients.showBusy((String)CommonData.lang((String)"updating_count"));
        Events.echoEvent((String)"onLater", (Component)this, null);
    }

    public void applyFilter(boolean doAdd) {
        if (this.lbSelLayers.getItemCount() == 0) {
            if (doAdd) {
                this.doAdd("");
            }
            return;
        }
        if (doAdd) {
            Events.echoEvent((String)"onLateron", (Component)this, null);
        } else {
            this.applyFilter();
        }
    }

    private void applyFilterEvented() {
        this.popupFilter.setMinimumValue(this.popupMinimum.getValue().doubleValue());
        this.popupFilter.setMaximumValue(this.popupMaximum.getValue().doubleValue());
        ((Listcell)this.popupItem.getChildren().get(1)).setLabel(this.popupFilter.getFilterString());
        this.serverFilter();
        String strCount = this.speciescount + "";
        if (this.isDirtyCount) {
            Clients.showBusy((String)CommonData.lang((String)"updating_count"));
            strCount = this.getSpeciesCount() + "";
            Clients.clearBusy();
        }
        try {
            this.popupFilter.setCount(Integer.parseInt(strCount.split("\n")[0]));
            ((Listcell)this.popupItem.getChildren().get(2)).setLabel(strCount.split("\n")[0]);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("error parsing species count from:" + strCount), (Throwable)e);
        }
    }

    private MapLayer loadMap(JSONObject layer, int depth, double min, double max, boolean finalLayer) {
        String colour = finalLayer ? "0xFF0000" : FILTER_COLOURS[depth % FILTER_COLOURS.length];
        String filter = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\"><NamedLayer><Name>ALA:" + layer.get((Object)"name") + "</Name>" + "<UserStyle><FeatureTypeStyle><Rule><RasterSymbolizer><Geometry></Geometry>" + "<ColorMap>" + "<ColorMapEntry color=\"" + colour + "\" opacity=\"1\" quantity=\"" + (min - Math.abs(min * 0.01)) + "\"/>" + "<ColorMapEntry color=\"" + colour + "\" opacity=\"0\" quantity=\"" + min + "\"/>" + "<ColorMapEntry color=\"" + colour + "\" opacity=\"0\" quantity=\"" + max + "\"/>" + "<ColorMapEntry color=\"" + colour + "\" opacity=\"1\" quantity=\"" + (max + Math.abs(max * 0.01)) + "\"/>" + "</ColorMap></RasterSymbolizer></Rule></FeatureTypeStyle></UserStyle></NamedLayer></StyledLayerDescriptor>";
        try {
            filter = URLEncoder.encode(filter, "UTF-8");
        }
        catch (Exception e) {
            LOGGER.error((Object)("cannot encode filter sld: " + filter), (Throwable)e);
        }
        MapLayer ml = this.mc.getMapLayer(LAYER_PREFIX + layer.get((Object)"name"));
        if (ml == null) {
            ml = this.getMapComposer().addWMSLayer(LAYER_PREFIX + layer.get((Object)"name"), LAYER_PREFIX + layer.get((Object)"displayname"), layer.get((Object)"displaypath").toString().replace("/gwc/service", "") + "&sld_body=" + filter, 0.75f, CommonData.getLayersServer() + "/layers/view/more/" + layer.get((Object)"id"), CommonData.getGeoServer() + "/wms?REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=20&HEIGHT=9&LAYER=" + layer.get((Object)"name"), 22, null, null, null);
        } else {
            ml.setUri(layer.get((Object)"displaypath").toString().replace("/gwc/service", "") + "&sld_body=" + filter);
            this.mc.reloadMapLayerNowAndIndexes(ml);
        }
        return ml;
    }

    List<Facet> getFacets() {
        ArrayList<Facet> facets = new ArrayList<Facet>();
        for (int i = 0; i < this.selectedLayers.size(); ++i) {
            SPLFilter splf = (SPLFilter)this.selectedSPLFilterLayers.get(((JSONObject)this.selectedLayers.get(i)).get((Object)"name"));
            Facet f = new Facet(CommonData.getLayerFacetName((String)splf.getLayername()), splf.getMinimumValue(), splf.getMaximumValue(), true);
            facets.add(f);
        }
        return facets;
    }

    String getWkt() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.selectedLayers.size(); ++i) {
            SPLFilter splf = (SPLFilter)this.selectedSPLFilterLayers.get(((JSONObject)this.selectedLayers.get(i)).get((Object)"name"));
            if (sb.length() > 0) {
                sb.append(":");
            }
            sb.append(CommonData.getLayerFacetName((String)splf.getLayername())).append(",").append(splf.getMinimumValue()).append(",").append(splf.getMaximumValue());
        }
        return sb.toString();
    }

    public void removeAllSelectedLayers(boolean showActiveArea) {
        StringBuilder sb = new StringBuilder();
        if (showActiveArea) {
            sb.append("Active Area");
            if (!this.selectedLayers.isEmpty()) {
                sb.append("|");
            }
        }
        for (int i = 0; i < this.selectedLayers.size(); ++i) {
            JSONObject layer = (JSONObject)this.selectedLayers.get(i);
            sb.append(layer.get((Object)"name"));
            if (i >= this.selectedLayers.size() - 1) continue;
            sb.append("|");
        }
        if (!this.selectedLayers.isEmpty()) {
            Events.echoEvent((String)"removeLayers", (Component)this, (String)sb.toString());
        } else if (this.cancelling) {
            this.detach();
        }
    }

    public void onClick$btnCancel(Event event) {
        this.cancelling = true;
        this.removeAllSelectedLayers(false);
    }

    static /* synthetic */ SPLFilter access$000(AreaEnvironmentalEnvelope x0, JSONObject x1) {
        return x0.getSPLFilter(x1);
    }
}

