/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.add.area;

import au.org.ala.spatial.composer.add.area.AreaToolComposer;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.LayersUtil;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.menu.MapLayer;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Button;
import org.zkoss.zul.Textbox;

public class AreaBoundingBox
extends AreaToolComposer {
    private static final Logger LOGGER = Logger.getLogger(AreaBoundingBox.class);
    private Textbox txtLayerName;
    private Button btnNext;
    private Button btnClear;
    private Textbox displayGeom;

    public void afterCompose() {
        super.afterCompose();
        this.txtLayerName.setValue(this.getMapComposer().getNextAreaLayerName(CommonData.lang((String)"default_area_layer_name")));
    }

    public void onClick$btnNext(Event event) {
        this.getMapComposer().getMapLayer(this.layerName).setDisplayName(this.txtLayerName.getValue());
        this.getMapComposer().redrawLayersList();
        this.ok = true;
        this.detach();
    }

    public void onClick$btnClear(Event event) {
        MapComposer mc = this.getMapComposer();
        if (this.layerName != null && mc.getMapLayer(this.layerName) != null) {
            mc.removeLayer(this.layerName);
        }
        String script = mc.getOpenLayersJavascript().addBoxDrawingTool();
        mc.getOpenLayersJavascript().execute(mc.getOpenLayersJavascript().getIFrameReferences() + script);
        this.displayGeom.setValue("");
        this.btnNext.setDisabled(true);
        this.btnClear.setDisabled(true);
    }

    public void onClick$btnCancel(Event event) {
        MapComposer mc = this.getMapComposer();
        if (this.layerName != null && mc.getMapLayer(this.layerName) != null) {
            mc.removeLayer(this.layerName);
        }
        this.detach();
    }

    public void onBoxGeom(Event event) {
        String boxGeom = (String)event.getData();
        try {
            if (boxGeom.contains("NaN NaN")) {
                this.displayGeom.setValue("");
            } else {
                this.displayGeom.setValue(boxGeom);
            }
            MapComposer mc = this.getMapComposer();
            this.layerName = mc.getMapLayer(this.txtLayerName.getValue()) == null ? this.txtLayerName.getValue() : mc.getNextAreaLayerName(this.txtLayerName.getValue());
            MapLayer mapLayer = mc.addWKTLayer(boxGeom, this.layerName, this.txtLayerName.getValue());
            mapLayer.getMapLayerMetadata().setMoreInfo(LayersUtil.getMetadataForWKT((String)CommonData.lang((String)"metadata_user_bounding_box"), (String)boxGeom));
            this.btnNext.setDisabled(false);
            this.btnClear.setDisabled(false);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error adding user bounding box area", (Throwable)e);
        }
    }
}

