/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.add.area;

import au.org.ala.spatial.composer.add.area.AreaToolComposer;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.LayersUtil;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.menu.MapLayer;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Button;
import org.zkoss.zul.Doublebox;
import org.zkoss.zul.Label;
import org.zkoss.zul.Textbox;

public class AreaAddressRadiusSelection
extends AreaToolComposer {
    private static final Logger LOGGER = Logger.getLogger(AreaAddressRadiusSelection.class);
    private Doublebox dRadius;
    private Label addressLabel;
    private Textbox txtLayerName;
    private Button btnOk;
    private Button btnClear;
    private Textbox addressBox;
    private Textbox displayGeom;
    private double longitude;
    private double latitude;

    public void afterCompose() {
        super.afterCompose();
        this.dRadius.setDisabled(true);
        this.btnOk.setDisabled(true);
        this.txtLayerName.setValue(this.getMapComposer().getNextAreaLayerName(CommonData.lang((String)"default_area_layer_name")));
    }

    public void onClick$btnOk(Event event) {
        if (!this.validate()) {
            return;
        }
        this.createRadiusFromAddress();
        this.ok = true;
        this.detach();
    }

    public void onClick$btnCreate(Event event) {
        this.createRadiusFromAddress();
    }

    public void onClick$btnCancel(Event event) {
        this.detach();
    }

    public void createRadiusFromAddress() {
        String wkt = this.radiusFromAddress(this.addressBox.getText());
        if (!"none".equalsIgnoreCase(wkt)) {
            try {
                MapComposer mc = this.getMapComposer();
                this.layerName = mc.getMapLayer(this.txtLayerName.getValue()) == null ? this.txtLayerName.getValue() : mc.getNextAreaLayerName(this.txtLayerName.getValue());
                MapLayer mapLayer = mc.addWKTLayer(wkt, this.layerName, this.txtLayerName.getValue());
                mapLayer.getMapLayerMetadata().setMoreInfo(LayersUtil.getMetadata((String)(this.dRadius.getText() + "km radius around " + this.addressLabel.getValue() + " (" + this.longitude + ", " + this.latitude + ")")));
                this.displayGeom.setText(wkt);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error adding WKT layer");
            }
        }
    }

    public String findAddressLine(String text) throws Exception {
        String url = "http://maps.google.com/maps/api/geocode/json?components=locality&sensor=false&address=" + URLEncoder.encode(text, "UTF-8");
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(new URL(url).openStream());
        return node.get("results").get(0).get("formatted_address").getTextValue();
    }

    public double[] findAddressLatLng(String text) throws Exception {
        String url = "http://maps.google.com/maps/api/geocode/json?components=locality&sensor=false&address=" + URLEncoder.encode(text, "UTF-8");
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(new URL(url).openStream());
        JsonNode latLngNode = node.get("results").get(0).get("geometry").get("location");
        return new double[]{latLngNode.get("lat").getDoubleValue(), latLngNode.get("lng").getDoubleValue()};
    }

    public void onClick$btnFindAddress(Event event) {
        String address = "";
        try {
            address = this.findAddressLine(this.addressBox.getText());
            this.addressLabel.setValue(address);
            this.dRadius.setDisabled(false);
            this.btnOk.setDisabled(false);
        }
        catch (Exception e) {
            LOGGER.error((Object)("error finding address: " + address), (Throwable)e);
        }
    }

    private String radiusFromAddress(String address) {
        try {
            double[] latlng = this.findAddressLatLng(address);
            double radius = this.dRadius.getValue() * 1000.0;
            return Util.createCircleJs((double)latlng[1], (double)latlng[0], (double)radius);
        }
        catch (Exception ge) {
            return "none";
        }
    }

    private boolean validate() {
        StringBuilder sb = new StringBuilder();
        double radius = this.dRadius.getValue();
        if (radius <= 0.0) {
            sb.append("\n").append(CommonData.lang((String)"error_msg_radius_0"));
        }
        if (sb.length() > 0) {
            this.getMapComposer().showMessage(sb.toString());
        }
        return sb.length() == 0;
    }
}

