/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.add;

import au.org.ala.spatial.util.CommonData;
import au.org.emii.portal.composer.UtilityComposer;
import au.org.emii.portal.lang.LanguagePack;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.menu.MapLayerMetadata;
import au.org.emii.portal.util.LayerUtilities;
import au.org.emii.portal.util.Validate;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.wms.WebMapServer;
import org.geotools.data.wms.request.GetMapRequest;
import org.geotools.data.wms.xml.MetadataURL;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Button;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Div;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Slider;
import org.zkoss.zul.Textbox;

public class AddWMSLayerComposer
extends UtilityComposer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(AddWMSLayerComposer.class);
    private Label linkall1;
    private Label linkall2;
    private Label linkall3;
    private Label linkall4;
    private Label linksingle1;
    private WMSCapabilities discoveredLayer = null;
    private List<String[]> availableLayers = null;
    private WebMapServer wmsServer = null;
    private Checkbox nameAutomatically;
    private Div labelDiv;
    private Textbox label;
    private Label invalidLabel;
    private Div discoveryAutomatic;
    private Textbox uri;
    private Label invalidUri;
    private Div selectLayers;
    private Listbox layerName;
    private Label invalidLayerName;
    private Div discoveryAutomaticOpacity;
    private Button selectLayersButton;
    private Div discoveryManual;
    private Textbox getMapUri;
    private Label invalidGetMapUri;
    private Div discoveryManualOpacity;
    private Div opacityControl;
    private Slider opacitySlider;
    private Label opacityLabel;
    private Label resultLabel;
    private Button addManualLayerButton;
    private Button addDiscoveredLayerButton;
    private LanguagePack languagePack = null;
    private LayerUtilities layerUtilities = null;

    public void onCheck$nameAutomatically() {
        LOGGER.debug((Object)"onNameAutomaticallyChanged()");
        this.labelDiv.setVisible(!this.nameAutomatically.isChecked());
    }

    public void onCheck$manual() {
        LOGGER.debug((Object)"onManual()");
        this.toggleAutomaticMode(false);
        if (this.getMapUri.getValue().isEmpty() && !this.uri.getValue().isEmpty()) {
            this.getMapUri.setValue(this.uri.getValue());
        }
        this.opacityControl.setParent((Component)this.discoveryManualOpacity);
        this.opacityControl.setVisible(true);
    }

    public void onCheck$automatic() {
        LOGGER.debug((Object)"onAutomatic()");
        this.toggleAutomaticMode(true);
        if (this.uri.getValue().isEmpty() && !this.getMapUri.getValue().isEmpty()) {
            this.uri.setValue(this.getMapUri.getValue());
        }
        this.opacityControl.setParent((Component)this.discoveryAutomaticOpacity);
        this.opacityControl.setVisible(true);
    }

    public void toggleAutomaticMode(boolean autoMode) {
        this.discoveryManual.setVisible(!autoMode);
        this.addManualLayerButton.setVisible(!autoMode);
        this.discoveryAutomatic.setVisible(autoMode);
        this.addDiscoveredLayerButton.setVisible(autoMode);
    }

    public void onChange$uri() {
        LOGGER.debug((Object)"onChange$uri()");
        if (this.selectLayers.isVisible()) {
            this.discoveredLayer = null;
            this.availableLayers = null;
            this.layerName.setModel((ListModel)null);
            this.selectLayers.setVisible(false);
            this.selectLayersButton.setDisabled(false);
            this.addDiscoveredLayerButton.setVisible(false);
        }
    }

    public void onClick$addAllLayersButton() {
        LOGGER.debug((Object)"onClick$addAllLayersButton()");
        this.resultLabel.setVisible(false);
        boolean amc = this.validateAutomaticModeCommon();
        boolean c = this.validateCommon();
        if (c && amc) {
            try {
                this.wmsServer = new WebMapServer(new URL(this.uri.getValue()));
                this.discoveredLayer = this.wmsServer.getCapabilities();
                MapLayer mapLayer = new MapLayer();
                mapLayer.setName(Validate.escapeHtmlAndTrim((String)this.label.getValue()));
                String ur = this.uri.getValue();
                mapLayer.setUri(ur);
                mapLayer.setLayer(this.layerUtilities.getLayers(ur));
                mapLayer.setOpacity((float)this.opacitySlider.getCurpos() / 100.0f);
                mapLayer.setImageFormat(this.layerUtilities.getImageFormat(ur));
                List bbox = this.layerUtilities.getBBox(ur);
                if (bbox != null) {
                    MapLayerMetadata md = new MapLayerMetadata();
                    md.setBbox(bbox);
                    md.setMoreInfo(ur);
                    mapLayer.setMapLayerMetadata(md);
                }
                String name = this.nameAutomatically.isChecked() ? "" : Validate.escapeHtmlAndTrim((String)this.label.getValue());
                mapLayer.setId(this.uri + name.replaceAll("\\s+", ""));
                mapLayer.setDescription(name);
                String version = this.layerUtilities.getVersionValue(ur);
                mapLayer.setType(this.layerUtilities.internalVersion(version));
                this.getMapComposer().addUserDefinedLayerToMenu(mapLayer, true);
                this.updateResult("wms_server_added");
            }
            catch (Exception e) {
                LOGGER.error((Object)"failed to get layer from url", (Throwable)e);
            }
        }
    }

    public void onClick$selectLayersButton() {
        LOGGER.debug((Object)"onClick$selectLayersButton");
        if (this.validateAutomaticModeCommon()) {
            try {
                this.wmsServer = new WebMapServer(new URL(this.uri.getValue()));
                this.discoveredLayer = this.wmsServer.getCapabilities();
                if (this.discoveredLayer != null) {
                    this.availableLayers = new ArrayList();
                    for (int i = 1; i < this.discoveredLayer.getLayerList().size(); ++i) {
                        this.availableLayers.add(new String[]{String.valueOf(i), ((Layer)this.discoveredLayer.getLayerList().get(i)).getName() + "," + ((Layer)this.discoveredLayer.getLayerList().get(i)).getTitle()});
                    }
                    this.updateAvailableLayers();
                    this.selectLayers.setVisible(true);
                    this.selectLayersButton.setDisabled(true);
                    this.addDiscoveredLayerButton.setVisible(true);
                } else {
                    this.getMapComposer().showMessage(CommonData.lang((String)"error_adding_layer"));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"map request", (Throwable)e);
            }
        }
    }

    private void updateAvailableLayers() {
        if (!this.availableLayers.isEmpty()) {
            this.layerName.setModel((ListModel)new ListModelList((Collection)this.availableLayers));
            this.layerName.setDisabled(false);
            this.layerName.setSelectedIndex(0);
        } else {
            this.layerName.setModel((ListModel)new ListModelList((Object[])new String[][]{{this.languagePack.getLang("ext_layer_no_layers_available"), null}}));
            this.layerName.setDisabled(true);
        }
    }

    public void onClick$addDiscoveredLayerButton() {
        LOGGER.debug((Object)"onAddDiscoveredLayer()");
        boolean acm = this.validateAutomaticModeCommon();
        boolean ams = this.validiateAutomaticModeSelectLayer();
        boolean c = this.validateCommon();
        if (acm && ams && c) {
            String discoveredLayerId = ((String[])this.layerName.getSelectedItem().getValue())[0];
            Layer targetLayer = (Layer)this.discoveredLayer.getLayerList().get(Integer.parseInt(discoveredLayerId));
            if (targetLayer != null) {
                MapLayer mapLayer = new MapLayer();
                mapLayer.setName(targetLayer.getName());
                GetMapRequest mapRequest = this.wmsServer.createGetMapRequest();
                mapRequest.addLayer(targetLayer);
                LOGGER.debug((Object)mapRequest.getFinalURL());
                mapRequest.setFormat("image/png");
                String url = mapRequest.getFinalURL().toString();
                mapLayer.setUri(url);
                mapLayer.setLayer(targetLayer.getName());
                mapLayer.setOpacity((float)this.opacitySlider.getCurpos() / 100.0f);
                mapLayer.setImageFormat(this.layerUtilities.getImageFormat(url));
                List bbox = this.layerUtilities.getBBox(url);
                if (bbox != null) {
                    CRSEnvelope e = targetLayer.getLatLonBoundingBox();
                    bbox.set(0, e.getMinX());
                    bbox.set(1, e.getMinY());
                    bbox.set(2, e.getMaxX());
                    bbox.set(3, e.getMaxY());
                    MapLayerMetadata md = new MapLayerMetadata();
                    md.setBbox(bbox);
                    md.setMoreInfo(targetLayer.getName() + "\n" + this.makeMetadataHtml(targetLayer));
                    mapLayer.setMapLayerMetadata(md);
                }
                String name = this.nameAutomatically.isChecked() ? targetLayer.getName() + ", " + targetLayer.getTitle() : Validate.escapeHtmlAndTrim((String)this.label.getValue());
                mapLayer.setId(url + name.replaceAll("\\s+", ""));
                mapLayer.setDescription(name);
                String version = this.layerUtilities.getVersionValue(url);
                mapLayer.setType(this.layerUtilities.internalVersion(version));
                this.getMapComposer().addUserDefinedLayerToMenu(mapLayer, true);
                this.updateResult("wms_layer_added");
                this.removeLayer(discoveredLayerId);
                this.updateAvailableLayers();
            } else {
                this.getMapComposer().showMessage(CommonData.lang((String)"error_selecting_layer") + ": '" + discoveredLayerId + "'");
            }
        }
    }

    private void removeLayer(String layerId) {
        if (this.availableLayers != null) {
            boolean found = false;
            for (int i = 0; !found && i < this.availableLayers.size(); ++i) {
                if (!((String[])this.availableLayers.get(i))[0].equals(layerId)) continue;
                found = true;
                this.availableLayers.remove(i);
            }
        }
    }

    public void onClick$addManualLayerButton() {
        LOGGER.debug((Object)"onAddManualLayer()");
        boolean mm = this.validateManualMode();
        boolean c = this.validateCommon();
        if (mm && c) {
            LOGGER.debug((Object)("adding" + this.getMapUri.getValue()));
            if (this.getMapComposer().addWMSLayer("wmslayer", this.nameAutomatically.isChecked() ? this.layerUtilities.getLayers(this.getMapUri.getValue()) : Validate.escapeHtmlAndTrim((String)this.label.getValue()), this.getMapUri.getValue(), 0.75f, "", "", 2, "", "") != null) {
                this.updateResult("wms_layer_added");
            }
        }
    }

    public void updateResult(String messageKey) {
        this.resultLabel.setVisible(true);
        this.resultLabel.setValue(this.languagePack.getLang(messageKey));
    }

    public float getOpacity() {
        return (float)this.opacitySlider.getCurpos() / 100.0f;
    }

    private boolean validateCommon() {
        boolean valid = this.nameAutomatically.isChecked();
        if (!valid) {
            valid = !Validate.empty((String)this.label.getValue());
            this.invalidLabel.setVisible(!valid);
        }
        return valid;
    }

    private boolean validateAutomaticModeCommon() {
        boolean valid = !Validate.invalidHttpUri((String)Validate.prefixUri((String)this.uri.getValue()));
        this.invalidUri.setVisible(!valid);
        return valid;
    }

    private boolean validiateAutomaticModeSelectLayer() {
        boolean valid = this.layerName.getSelectedItem() != null && !Validate.empty((String)((String[])this.layerName.getSelectedItem().getValue())[0]);
        this.invalidLayerName.setVisible(!valid);
        return valid;
    }

    private boolean validateManualMode() {
        boolean valid = !Validate.invalidHttpUri((String)Validate.prefixUri((String)this.getMapUri.getValue()));
        this.invalidGetMapUri.setVisible(!valid);
        return valid;
    }

    public void onScroll$opacitySlider() {
        this.opacityLabel.setValue(this.opacitySlider.getCurpos() + "%");
    }

    public LanguagePack getLanguagePack() {
        return this.languagePack;
    }

    public void setLanguagePack(LanguagePack languagePack) {
        this.languagePack = languagePack;
    }

    public LayerUtilities getLayerUtilities() {
        return this.layerUtilities;
    }

    public void setLayerUtilities(LayerUtilities layerUtilities) {
        this.layerUtilities = layerUtilities;
    }

    String makeMetadataHtml(Layer layer) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<br>name: ").append(layer.getName());
        sb.append("<br>");
        sb.append("title: ").append(layer.getTitle());
        sb.append("<br>");
        sb.append("abstract: ").append(layer.get_abstract());
        sb.append("<br>");
        sb.append("keywords: ");
        if (layer.getKeywords() != null) {
            for (String s : layer.getKeywords()) {
                sb.append(s).append(", ");
            }
        }
        if (layer.getMetadataURL() != null && !layer.getMetadataURL().isEmpty()) {
            sb.append("<br>");
            sb.append("metadata URL: ");
            for (MetadataURL url : layer.getMetadataURL()) {
                sb.append("<a target='_blank' href='").append(url.getUrl().toString().replace("'", "''")).append("'>").append(StringEscapeUtils.escapeHtml((String)url.getUrl().toString())).append("</a>, ");
            }
        }
        sb.append("<br>");
        String bbox = layer.getLatLonBoundingBox().getMinX() + " " + layer.getLatLonBoundingBox().getMinY() + "," + layer.getLatLonBoundingBox().getMaxX() + " " + layer.getLatLonBoundingBox().getMaxY();
        sb.append("bounding box: ").append(bbox);
        sb.append("</html>");
        return sb.toString();
    }

    public void onClick$useAllLink1() {
        this.uri.setText(this.linkall1.getValue());
    }

    public void onClick$useAllLink2() {
        this.uri.setText(this.linkall2.getValue());
    }

    public void onClick$useAllLink3() {
        this.uri.setText(this.linkall3.getValue());
    }

    public void onClick$useAllLink4() {
        this.uri.setText(this.linkall4.getValue());
    }

    public void onClick$useSingleLink1() {
        this.getMapUri.setText(this.linksingle1.getValue());
    }
}

