/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.add;

import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.QueryUtil;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.UtilityComposer;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.menu.SelectedArea;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.ForwardEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Button;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.Window;

public class AddSpeciesInArea
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(AddSpeciesInArea.class);
    private Radiogroup rgArea;
    private Radio rAreaWorld;
    private Radio rAreaCustom;
    private Radio rAreaSelected;
    private Radio rAreaAustralia;
    private Button btnOk;
    private Query query;
    private String rank;
    private String taxon;
    private boolean filterGrid = false;
    private boolean filter = false;
    private boolean byLsid = false;
    private String multipleSpeciesUploadName = null;
    private Radio rAreaCurrent;
    private String name;
    private String s;
    private int type;
    private int featureCount;
    private String metadata;
    private boolean allSpecies = false;
    private boolean[] geospatialKosher = null;
    private boolean expertDistributions;

    public void loadAreaLayers() {
        block7: {
            try {
                int i;
                List layers = null;
                Map m = this.args;
                if (m != null) {
                    for (Map.Entry o : m.entrySet()) {
                        if (!(o.getKey() instanceof String) || !o.getKey().equals("polygon_layers")) continue;
                        layers = (List)o.getValue();
                    }
                }
                for (i = 0; layers != null && i < layers.size(); ++i) {
                    MapLayer lyr = (MapLayer)layers.get(i);
                    Radio rAr = new Radio(lyr.getDisplayName());
                    rAr.setId(lyr.getDisplayName().replaceAll(" ", ""));
                    rAr.setValue((Object)lyr.getName());
                    rAr.setParent((Component)this.rgArea);
                    this.rgArea.insertBefore((Component)rAr, (Component)this.rAreaCurrent);
                }
                if (!this.allSpecies) {
                    this.rAreaSelected = this.rAreaWorld;
                    break block7;
                }
                this.rAreaWorld.setVisible(false);
                this.rAreaAustralia.setVisible(false);
                for (i = 0; i < this.rgArea.getItemCount(); ++i) {
                    if (!this.rgArea.getItemAtIndex(i).isVisible()) continue;
                    this.rAreaSelected = this.rgArea.getItemAtIndex(i);
                    this.rgArea.setSelectedItem(this.rAreaSelected);
                    Clients.evalJavaScript((String)("jq('#" + this.rAreaSelected.getUuid() + "-real').attr('checked', true);"));
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Unable to load active area layers", (Throwable)e);
            }
        }
    }

    public void onCheck$rgArea(Event event) {
        if (this.rgArea == null) {
            return;
        }
        this.rAreaSelected = (Radio)((ForwardEvent)event).getOrigin().getTarget();
    }

    public void onClick$btnCancel(Event event) {
        this.detach();
    }

    public void onClick$btnOk(Event event) {
        if (this.btnOk.isDisabled()) {
            return;
        }
        try {
            if (this.rAreaSelected == this.rAreaCustom) {
                HashMap<String, Object> winProps = new HashMap<String, Object>();
                winProps.put("parent", this);
                winProps.put("parentname", "AddSpeciesInArea");
                winProps.put("query", this.query);
                winProps.put("rank", this.rank);
                winProps.put("taxon", this.taxon);
                winProps.put("name", this.name);
                winProps.put("s", this.s);
                winProps.put("featureCount", this.featureCount);
                winProps.put("filter", this.filter);
                winProps.put("filterGrid", this.filterGrid);
                winProps.put("byLsid", this.byLsid);
                winProps.put("metadata", this.metadata);
                winProps.put("type", this.type);
                Window window = (Window)Executions.createComponents((String)"WEB-INF/zul/add/AddArea.zul", (Component)this.getParent(), winProps);
                window.setAttribute("winProps", winProps, true);
                window.setParent(this.getParent());
                window.doModal();
            } else {
                this.onFinish();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error finishing Add species in area request", (Throwable)e);
        }
        this.detach();
    }

    public void onFinish() {
        try {
            SelectedArea sa = this.getSelectedArea();
            boolean setupMetadata = true;
            MapLayer ml = null;
            Query q = QueryUtil.queryFromSelectedArea((Query)this.query, (SelectedArea)sa, (boolean)true, (boolean[])this.geospatialKosher);
            if (this.byLsid) {
                ml = this.getMapComposer().mapSpecies(q, this.name, this.s, this.featureCount, this.type, null, -1, 3, 0.6f, Util.nextColour(), this.expertDistributions);
            } else if (this.filter) {
                ml = this.getMapComposer().mapSpecies(q, this.name, this.s, this.featureCount, this.type, null, -1, 3, 0.6f, Util.nextColour(), this.expertDistributions);
            } else if (this.filterGrid) {
                ml = this.getMapComposer().mapSpecies(q, this.name, this.s, this.featureCount, this.type, null, -1, 3, 0.6f, Util.nextColour(), this.expertDistributions);
            } else if (this.rank != null && this.taxon != null && q != null) {
                ml = this.getMapComposer().mapSpecies(q, this.taxon, this.rank, -1, 21, null, -1, 3, 0.6f, Util.nextColour(), this.expertDistributions);
                setupMetadata = false;
            } else {
                int resultsCountOccurrences = q.getOccurrenceCount();
                if (resultsCountOccurrences > 0 && resultsCountOccurrences <= Integer.parseInt(CommonData.getSettings().getProperty("max_record_count_map"))) {
                    String lsids;
                    String activeAreaLayerName = this.getSelectedAreaDisplayName();
                    String layerName = CommonData.lang((String)"occurrences_in_area_prefix") + " " + activeAreaLayerName;
                    if (this.multipleSpeciesUploadName != null) {
                        layerName = this.multipleSpeciesUploadName;
                    } else if (q instanceof BiocacheQuery && (lsids = ((BiocacheQuery)q).getLsids()) != null && lsids.length() > 0 && lsids.split(",").length > 1) {
                        layerName = CommonData.lang((String)"species_assemblage_layer_name");
                    }
                    ml = this.getMapComposer().mapSpecies(q, layerName, "species", resultsCountOccurrences, 21, null, -1, 3, 0.6f, Util.nextColour(), this.expertDistributions);
                } else {
                    this.getMapComposer().showMessage(CommonData.lang((String)"error_too_many_occurrences_for_mapping").replace("<counted_occurrences>", resultsCountOccurrences + "").replace("<max_occurrences>", CommonData.getSettings().getProperty("max_record_count_map")));
                }
                setupMetadata = false;
            }
            if (setupMetadata) {
                ml.getMapLayerMetadata().setMoreInfo(this.metadata);
            }
            LOGGER.debug((Object)("metadata: " + this.metadata));
        }
        catch (Exception e) {
            LOGGER.error((Object)"error adding species in area to map", (Throwable)e);
        }
    }

    public SelectedArea getSelectedArea() {
        String area = (String)this.rAreaSelected.getValue();
        SelectedArea sa = null;
        try {
            if ("current".equals(area)) {
                sa = new SelectedArea(null, this.getMapComposer().getViewArea());
            } else if ("australia".equals(area)) {
                sa = new SelectedArea(null, CommonData.getSettings().getProperty("default.wkt"));
            } else if ("world".equals(area)) {
                sa = new SelectedArea(null, "POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))");
            } else {
                List layers = this.getMapComposer().getPolygonLayers();
                for (MapLayer ml : layers) {
                    if (!area.equals(ml.getName())) continue;
                    sa = new SelectedArea(ml, null);
                    break;
                }
                if (sa == null) {
                    sa = new SelectedArea(null, area);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to retrieve selected area", (Throwable)e);
        }
        return sa;
    }

    public String getSelectedAreaName() {
        String area = this.rAreaSelected.getLabel();
        List layers = this.getMapComposer().getPolygonLayers();
        for (MapLayer ml : layers) {
            if (!area.equals(ml.getDisplayName())) continue;
            area = ml.getName();
            break;
        }
        return area;
    }

    public String getSelectedAreaDisplayName() {
        return this.rAreaSelected.getLabel();
    }

    void setSpeciesParams(Query q, String rank, String taxon) {
        this.query = q;
        this.rank = rank;
        this.taxon = taxon;
    }

    public void setSpeciesFilterGridParams(Query q, String name, String s, int featureCount, int type, String metadata, String rank) {
        this.query = q;
        this.name = name;
        this.s = s;
        this.featureCount = featureCount;
        this.type = type;
        this.filterGrid = true;
        this.metadata = metadata;
        this.rank = rank;
    }

    public void setSpeciesFilterParams(Query q, String name, String s, int featureCount, int type, String metadata, String rank) {
        this.query = q;
        this.name = name;
        this.s = s;
        this.featureCount = featureCount;
        this.type = type;
        this.filter = true;
        this.metadata = metadata;
        this.rank = rank;
    }

    void setSpeciesByLsidParams(Query q, String name, String s, int featureCount, int type, String metadata) {
        this.query = q;
        this.name = name;
        this.s = s;
        this.featureCount = featureCount;
        this.type = type;
        this.byLsid = true;
        this.metadata = metadata;
    }

    void setAllSpecies(boolean isAllSpecies) {
        this.allSpecies = isAllSpecies;
    }

    void setGeospatialKosher(boolean[] geospatialKosher) {
        this.geospatialKosher = geospatialKosher == null ? null : (boolean[])geospatialKosher.clone();
    }

    void setMultipleSpeciesUploadName(String multipleSpeciesUploadName) {
        this.multipleSpeciesUploadName = multipleSpeciesUploadName;
    }

    public void setExpertDistributions(boolean expertDistributions) {
        this.expertDistributions = expertDistributions;
    }
}

