/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.add;

import au.org.ala.spatial.composer.add.AddSpeciesInArea;
import au.org.ala.spatial.composer.input.UploadLayerListController;
import au.org.ala.spatial.composer.input.UploadSpeciesController;
import au.org.ala.spatial.composer.input.UploadToSpeciesListController;
import au.org.ala.spatial.composer.sandbox.SandboxPasteController;
import au.org.ala.spatial.composer.species.SpeciesAutoCompleteComponent;
import au.org.ala.spatial.composer.species.SpeciesListListbox;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.UtilityComposer;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.CheckEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.ForwardEvent;
import org.zkoss.zul.A;
import org.zkoss.zul.Button;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Label;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Vbox;

public class AddSpeciesController
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(AddSpeciesController.class);
    private List<String> selectedLists;
    private SpeciesAutoCompleteComponent searchSpeciesACComponent;
    private Button btnOk;
    private Button bMultiple;
    private Button bAssemblageExport;
    private Radio rSearch;
    private Radio rMultiple;
    private Radio rUploadCoordinates;
    private Radio rUploadLSIDs;
    private Radio rAllSpecies;
    private Radiogroup rgAddSpecies;
    private Vbox vboxSearch;
    private Checkbox chkArea;
    private Vbox vboxMultiple;
    private Vbox vboxImportSL;
    private SpeciesAutoCompleteComponent mSearchSpeciesACComponent;
    private Textbox tMultiple;
    private Listbox lMultiple;
    private Event event;
    private Checkbox chkGeoKosherTrue;
    private Checkbox chkGeoKosherFalse;
    private Checkbox chkExpertDistributions;
    private Query query;
    private String rank;
    private String taxon;
    private String multipleSpeciesUploadName = null;
    private boolean prevAreaState = true;
    private boolean loadedAssemblage = false;
    private SpeciesListListbox speciesListListbox;
    private A aMessage;
    private Label lblMessage;
    private boolean listBoxEcho = false;

    public void afterCompose() {
        super.afterCompose();
        this.rSearch.setSelected(true);
        this.chkArea.setChecked(true);
        this.mSearchSpeciesACComponent.getAutoComplete().setBiocacheOnly(true);
        this.vboxImportSL = (Vbox)this.getFellow("splistbox").getFellow("vboxImportSL");
        this.vboxImportSL.getFellow("btnSearchSpeciesListListbox").addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        this.vboxImportSL.getFellow("btnClearSearchSpeciesListListbox").addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        this.speciesListListbox = (SpeciesListListbox)this.getFellow("splistbox").getFellow("speciesListListbox");
        String user = Util.getUserEmail();
        if (user != null && user.length() > 0) {
            this.rMultiple.setDisabled(false);
        } else {
            this.rMultiple.setDisabled(true);
            this.rMultiple.setLabel(this.rMultiple.getLabel() + " " + CommonData.lang((String)"msg_login_required"));
        }
        this.speciesListListbox.addEventListener("onSlCheckBoxChanged", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        Map m = Executions.getCurrent().getArg();
        if (m != null) {
            for (Map.Entry o : m.entrySet()) {
                if (!(o.getKey() instanceof String) || !"enableImportAssemblage".equals(o.getKey())) continue;
                this.enableImportAssemblage();
            }
        }
    }

    public void onClick$btnSearchSpeciesListListbox(Event event) {
        try {
            ((SpeciesListListbox)event.getTarget().getParent().getParent().getFellowIfAny("speciesListListbox")).onClick$btnSearchSpeciesListListbox(event);
        }
        catch (Exception e) {
            LOGGER.error((Object)"addspeciescontroller is missing speciesListListbox for refreshing", (Throwable)e);
        }
    }

    public void onClick$btnClearSearchSpeciesListListbox(Event event) {
        try {
            ((SpeciesListListbox)event.getTarget().getParent().getParent().getFellowIfAny("speciesListListbox")).onClick$btnClearSearchSpeciesListListbox(event);
        }
        catch (Exception e) {
            LOGGER.error((Object)"addspeciescontroller is missing speciesListListbox for refreshing", (Throwable)e);
        }
    }

    public void onValueSelected$searchSpeciesACComponent(Event event) {
        this.onChange$searchSpeciesAuto(event);
    }

    public void onClick$btnOk(Event event) {
        HashMap<String, List> params = new HashMap<String, List>();
        params.put("polygon_layers", this.getMapComposer().getPolygonLayers());
        if (this.btnOk.isDisabled()) {
            return;
        }
        this.loadedAssemblage = false;
        if (this.rAllSpecies.isSelected()) {
            AddSpeciesInArea window = (AddSpeciesInArea)Executions.createComponents((String)"WEB-INF/zul/add/AddSpeciesInArea.zul", (Component)this.getMapComposer(), params);
            window.setGeospatialKosher(this.getGeospatialKosher());
            window.setExpertDistributions(this.chkExpertDistributions.isChecked());
            window.setAllSpecies(true);
            window.loadAreaLayers();
            try {
                window.setParent((Component)this.getMapComposer());
                window.doModal();
            }
            catch (Exception e) {
                LOGGER.error((Object)"error opening AddSpeciesInArea.zul", (Throwable)e);
            }
        } else if (this.chkArea.isChecked()) {
            this.getFromAutocomplete();
            if (this.rSearch.isSelected()) {
                AddSpeciesInArea window = (AddSpeciesInArea)Executions.createComponents((String)"WEB-INF/zul/add/AddSpeciesInArea.zul", (Component)this.getMapComposer(), params);
                window.setSpeciesParams(this.query, this.rank, this.taxon);
                window.setExpertDistributions(this.chkExpertDistributions.isChecked());
                window.loadAreaLayers();
                try {
                    window.setParent((Component)this.getMapComposer());
                    window.doModal();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"error opening AddSpeciesInArea.zul", (Throwable)e);
                }
            } else if (this.rMultiple.isSelected()) {
                if (Util.getUserEmail() != null && !"guest@ala.org.au".equals(Util.getUserEmail())) {
                    this.showExportSpeciesListDialog();
                    this.loadedAssemblage = true;
                } else {
                    AddSpeciesInArea window = (AddSpeciesInArea)Executions.createComponents((String)"WEB-INF/zul/add/AddSpeciesInArea.zul", (Component)this.getMapComposer(), params);
                    window.setExpertDistributions(this.chkExpertDistributions.isChecked());
                    StringBuilder sb = new StringBuilder();
                    for (Listitem li : this.lMultiple.getItems()) {
                        Listcell lsidCell = (Listcell)li.getLastChild();
                        if (lsidCell.getLabel().contains("not found")) continue;
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(lsidCell.getLabel());
                    }
                    this.query = new BiocacheQuery(sb.toString(), null, null, null, null, false, this.getGeospatialKosher());
                    window.setSpeciesParams(this.query, this.rank, this.taxon);
                    window.setMultipleSpeciesUploadName(CommonData.lang((String)"uploaded_species_list_layer_name"));
                    window.loadAreaLayers();
                    try {
                        window.setParent((Component)this.getMapComposer());
                        window.doModal();
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"error opening AddSpeciesInArea.zul", (Throwable)e);
                    }
                }
            } else if (this.rUploadLSIDs.isSelected()) {
                AddSpeciesInArea window = (AddSpeciesInArea)Executions.createComponents((String)"WEB-INF/zul/add/AddSpeciesInArea.zul", (Component)this.getMapComposer(), params);
                this.query = this.speciesListListbox.extractQueryFromSelectedLists(this.getGeospatialKosher());
                window.setSpeciesParams(this.query, this.rank, this.taxon);
                window.setMultipleSpeciesUploadName(CommonData.lang((String)"uploaded_species_list_layer_name"));
                window.loadAreaLayers();
                try {
                    window.setParent((Component)this.getMapComposer());
                    window.doModal();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"error opening AddSpeciesInArea.zul", (Throwable)e);
                }
            } else {
                this.onClick$btnUpload(event);
            }
        } else if (this.rSearch.isSelected()) {
            this.getMapComposer().mapSpeciesFromAutocompleteComponent(this.searchSpeciesACComponent, null, this.getGeospatialKosher(), this.chkExpertDistributions.isChecked());
        } else if (this.rUploadLSIDs.isSelected()) {
            this.loadedAssemblage = true;
        } else {
            this.onClick$btnUpload(event);
        }
        if (!this.loadedAssemblage) {
            this.detach();
        }
    }

    public void enableImportAssemblage() {
        this.rUploadLSIDs.setSelected(true);
        this.onCheck$rgAddSpecies(null);
    }

    public void onClick$btnCancel(Event event) {
        this.detach();
    }

    public void onChange$searchSpeciesAuto(Event event) {
        this.btnOk.setDisabled(true);
        this.refreshBtnOkDisabled();
    }

    public void onValueSelected$mSearchSpeciesACComponent(Event event) {
        Comboitem ci = this.mSearchSpeciesACComponent.getAutoComplete().getSelectedItem();
        if (ci != null && ci.getAnnotatedProperties() != null && ci.getAnnotatedProperties().get(0) != null) {
            String annotatedValue = (String)ci.getAnnotatedProperties().get(0);
            if (this.mSearchSpeciesACComponent.shouldUseRawName()) {
                this.addTolMultiple(null, annotatedValue, null, null, true);
            } else {
                try {
                    String lsid = annotatedValue;
                    Map searchResult = BiocacheQuery.getClassification((String)lsid);
                    String sciname = (String)searchResult.get("scientificName");
                    String family = (String)searchResult.get("family");
                    String kingdom = (String)searchResult.get("kingdom");
                    if (sciname == null) {
                        sciname = "";
                    }
                    if (family == null) {
                        family = "";
                    }
                    if (kingdom == null) {
                        kingdom = "";
                    }
                    if (sciname != null && sciname.length() > 0) {
                        this.addTolMultiple(lsid, sciname, family, kingdom, true);
                        this.mSearchSpeciesACComponent.getAutoComplete().setText("");
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)"error with species search autocomplete", (Throwable)e);
                }
            }
        }
        this.refreshBtnOkDisabled();
    }

    public void onClick$btnUpload(Event event) {
        try {
            if (StringUtils.isNotEmpty((String)CommonData.getSettings().getProperty("sandbox.url", null)) && CommonData.getSettings().getProperty("import.points.layers-service", "false").equals("false")) {
                SandboxPasteController spc = (SandboxPasteController)Executions.createComponents((String)"WEB-INF/zul/sandbox/SandboxPaste.zul", (Component)this.getMapComposer(), null);
                spc.setAddToMap(true);
                spc.setParent((Component)this.getMapComposer());
                spc.doModal();
            } else {
                UploadSpeciesController usc = (UploadSpeciesController)Executions.createComponents((String)"WEB-INF/zul/input/UploadSpecies.zul", (Component)this.getMapComposer(), null);
                if (this.rUploadCoordinates.isSelected()) {
                    usc.setTbInstructions(CommonData.lang((String)"instruction_upload_species_csv"));
                } else if (this.rUploadLSIDs.isSelected()) {
                    usc.setTbInstructions(CommonData.lang((String)"instruction_upload_species_lsids"));
                } else {
                    usc.setTbInstructions(CommonData.lang((String)"instruction_upload_species_other"));
                }
                usc.setAddToMap(true);
                usc.setDefineArea(this.chkArea.isChecked());
                usc.setParent((Component)this.getMapComposer());
                usc.doModal();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error displaying uploadspecies.zul", (Throwable)e);
        }
    }

    public void onCheck$rgAddSpecies(Event event) {
        if (this.rSearch.isSelected()) {
            this.vboxSearch.setVisible(true);
            this.vboxMultiple.setVisible(false);
            this.vboxImportSL.setVisible(false);
        } else if (this.rMultiple.isSelected()) {
            this.vboxSearch.setVisible(false);
            this.vboxMultiple.setVisible(true);
            this.vboxImportSL.setVisible(false);
            this.aMessage.setVisible(false);
            this.lblMessage.setValue("");
        } else if (this.rUploadLSIDs.isSelected()) {
            this.vboxSearch.setVisible(false);
            this.vboxMultiple.setVisible(false);
            this.vboxImportSL.setVisible(true);
        } else {
            this.vboxSearch.setVisible(false);
            this.vboxMultiple.setVisible(false);
            this.vboxImportSL.setVisible(false);
        }
        this.refreshBtnOkDisabled();
        this.setPosition("center,center");
    }

    private void refreshBtnOkDisabled() {
        if (this.rSearch.isSelected()) {
            this.btnOk.setDisabled(!this.searchSpeciesACComponent.hasValidItemSelected());
        } else if (this.rMultiple.isSelected()) {
            this.btnOk.setDisabled(this.getMultipleLsids().length() == 0 && this.getNamesWithoutLsids().length == 0);
        } else if (this.rUploadLSIDs.isSelected()) {
            this.btnOk.setDisabled(this.speciesListListbox.getSelectedLists() == null || this.speciesListListbox.getSelectedLists().isEmpty());
        } else {
            this.btnOk.setDisabled(false);
        }
    }

    void getFromAutocomplete() {
        if (!this.searchSpeciesACComponent.hasValidAnnotatedItemSelected()) {
            return;
        }
        this.taxon = this.searchSpeciesACComponent.getAutoComplete().getValue();
        this.rank = "";
        String spVal = this.searchSpeciesACComponent.getAutoComplete().getSelectedItem().getDescription();
        if (spVal.trim().contains(": ")) {
            this.taxon = spVal.trim().substring(spVal.trim().indexOf(":") + 1, spVal.trim().indexOf("-")).trim() + " (" + this.taxon + ")";
            this.rank = spVal.trim().substring(0, spVal.trim().indexOf(":"));
        } else {
            this.rank = StringUtils.substringBefore((String)spVal, (String)",").toLowerCase();
            LOGGER.debug((Object)("mapping rank and species: " + this.rank + " - " + this.taxon));
        }
        if ("scientific name".equalsIgnoreCase(this.rank) || "scientific".equalsIgnoreCase(this.rank)) {
            this.rank = "taxon";
        }
        this.query = this.searchSpeciesACComponent.getQuery((Map)this.getMapComposer().getSession().getAttribute("userpoints"), true, this.getGeospatialKosher());
    }

    public void onClick$bMultiple(Event event) {
        this.importList(this.tMultiple.getText());
        this.refreshBtnOkDisabled();
    }

    void importList(String list) {
        String[] speciesNames = list.replace("\n", ",").replace("\t", ",").split(",");
        ArrayList<String> notFound = new ArrayList<String>();
        StringBuilder notFoundSb = new StringBuilder();
        for (int i = 0; i < speciesNames.length; ++i) {
            String s = speciesNames[i].trim();
            String lsid = BiocacheQuery.getGuid((String)s);
            String sciname = "";
            String family = "";
            String kingdom = "";
            String classLsid = lsid != null ? lsid : s;
            Map sr = BiocacheQuery.getClassification((String)classLsid);
            if (!sr.isEmpty() && sr.get("scientificName") != null && ((String)sr.get("scientificName")).length() > 0) {
                if (lsid == null) {
                    lsid = s;
                }
                sciname = (String)sr.get("scientificName");
                family = (String)sr.get("family");
                kingdom = (String)sr.get("kingdom");
                if (sciname == null) {
                    sciname = "";
                }
                if (family == null) {
                    family = "";
                }
                if (kingdom == null) {
                    kingdom = "";
                }
            }
            if (lsid != null && lsid.length() > 0) {
                this.addTolMultiple(lsid, sciname, family, kingdom, false);
            } else {
                this.addTolMultiple(null, s, "", "", false);
            }
            if (lsid != null && lsid.length() != 0) continue;
            notFound.add(s);
            notFoundSb.append(s).append("\n");
        }
        if (!notFound.isEmpty()) {
            this.getMapComposer().showMessage(CommonData.lang((String)"names_not_found_continuing") + ":\n" + notFoundSb.toString(), (Component)this);
        }
    }

    private void addTolMultiple(String lsid, String sciname, String family, String kingdom, boolean insertAtBeginning) {
        int count;
        for (Listitem li : this.lMultiple.getItems()) {
            Listcell lsidCell = (Listcell)li.getLastChild();
            Listcell scinameCell = (Listcell)li.getFirstChild().getNextSibling();
            if (!lsidCell.getLabel().equals(lsid) && !scinameCell.getLabel().replace("(not found)", "").trim().equals(sciname)) continue;
            return;
        }
        Listitem li = new Listitem();
        Listcell lc = new Listcell("x");
        lc.setSclass("xRemove");
        lc.addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        lc.setParent((Component)li);
        if (lsid == null) {
            lc = new Listcell(sciname + " (not found)");
            lc.setSclass("notFoundSciname");
        } else {
            lc = new Listcell(sciname);
        }
        lc.setParent((Component)li);
        if (lsid == null && !sciname.matches(".*[0-9].*")) {
            lc = new Listcell("click to search");
            lc.setSclass("notFoundFamily");
            lc.addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            lc = new Listcell(family);
        }
        lc.setParent((Component)li);
        lc = new Listcell(kingdom);
        lc.setParent((Component)li);
        lc = lsid != null ? ((count = new BiocacheQuery(lsid, null, null, null, false, this.getGeospatialKosher()).getOccurrenceCount()) > 0 ? new Listcell(String.valueOf(count)) : new Listcell(kingdom)) : ((count = new BiocacheQuery(null, null, "raw_name:\"" + sciname + "\"", null, false, this.getGeospatialKosher()).getOccurrenceCount()) > 0 ? new Listcell(String.valueOf(count)) : new Listcell(kingdom));
        lc.setParent((Component)li);
        lc = new Listcell(lsid);
        lc.setParent((Component)li);
        if (insertAtBeginning && !this.lMultiple.getChildren().isEmpty()) {
            this.lMultiple.insertBefore((Component)li, this.lMultiple.getFirstChild());
        } else {
            li.setParent((Component)this.lMultiple);
        }
    }

    private String getScientificName() {
        StringBuilder sb = new StringBuilder();
        for (Listitem li : this.lMultiple.getItems()) {
            Listcell sciNameCell = (Listcell)li.getChildren().get(1);
            String name = sciNameCell.getLabel();
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(name.replaceAll("\\(not found\\)", "").trim());
        }
        return sb.toString();
    }

    private String getMultipleLsids() {
        StringBuilder sb = new StringBuilder();
        for (Listitem li : this.lMultiple.getItems()) {
            Listcell lc = (Listcell)li.getLastChild();
            if (lc.getLabel() == null || lc.getLabel().length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(lc.getLabel());
        }
        return sb.toString();
    }

    private String[] getNamesWithoutLsids() {
        StringBuilder sb = new StringBuilder();
        for (Listitem li : this.lMultiple.getItems()) {
            Listcell sciNameCell = (Listcell)li.getChildren().get(1);
            String name = sciNameCell.getLabel();
            if (!name.contains("(not found)")) continue;
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(name.replaceAll("\\(not found\\)", "").trim());
        }
        if (sb.length() > 0) {
            return sb.toString().split("\\|");
        }
        return new String[0];
    }

    public void setMultipleSpecies(String splist, String layername) {
        this.tMultiple.setText(splist);
        this.rSearch.setSelected(false);
        this.rMultiple.setSelected(true);
        this.vboxSearch.setVisible(false);
        this.vboxMultiple.setVisible(true);
        this.vboxImportSL.setVisible(false);
        this.bMultiple.focus();
        this.onClick$bMultiple(this.event);
        this.multipleSpeciesUploadName = layername;
    }

    public boolean[] getGeospatialKosher() {
        return new boolean[]{this.chkGeoKosherTrue.isChecked(), this.chkGeoKosherFalse.isChecked(), false};
    }

    public void onCheck$chkGeoKosherTrue(Event event) {
        Event evt = ((ForwardEvent)event).getOrigin();
        if (!((CheckEvent)evt).isChecked() && !this.chkGeoKosherFalse.isChecked()) {
            this.chkGeoKosherFalse.setChecked(true);
        }
    }

    public void onCheck$chkGeoKosherFalse(Event event) {
        Event evt = ((ForwardEvent)event).getOrigin();
        if (!((CheckEvent)evt).isChecked() && !this.chkGeoKosherTrue.isChecked()) {
            this.chkGeoKosherTrue.setChecked(true);
        }
    }

    private void showExportSpeciesListDialog() {
        String values = this.getScientificName();
        LOGGER.debug((Object)("Creating species list with " + values));
        if (values.length() > 0) {
            UploadToSpeciesListController dialog = (UploadToSpeciesListController)Executions.createComponents((String)"WEB-INF/zul/input/UploadToSpeciesList.zul", (Component)this, null);
            dialog.setSpecies(values);
            dialog.setCallback((EventListener)new /* Unavailable Anonymous Inner Class!! */);
            try {
                dialog.setParent((Component)this);
                dialog.doModal();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Unable to export assemblage", (Throwable)e);
            }
        }
    }

    public void updateSpeciesListMessage(String drUid) {
        LOGGER.debug((Object)("Species list that was created : " + drUid));
        if (drUid != null) {
            this.speciesListListbox.init();
            this.rUploadLSIDs.setSelected(true);
            this.onCheck$rgAddSpecies(null);
        }
    }

    public void onClick$bAssemblageExport(Event event) {
        this.showExportSpeciesListDialog();
    }

    String getLsids() {
        StringBuilder sb = new StringBuilder();
        for (Listitem li : this.lMultiple.getItems()) {
            Listcell lsidCell = (Listcell)li.getLastChild();
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(lsidCell.getLabel());
        }
        return sb.toString();
    }

    public void onClick$bSpeciesListUpload(Event event) {
        UploadLayerListController window = (UploadLayerListController)Executions.createComponents((String)"WEB-INF/zul/input/UploadSpeciesList.zul", (Component)this, null);
        window.setCallback((EventListener)new /* Unavailable Anonymous Inner Class!! */);
        try {
            window.setParent((Component)this);
            window.doModal();
        }
        catch (Exception e) {
            LOGGER.error((Object)"error opening UploadSpeciesList.zul", (Throwable)e);
        }
    }

    String readerToString(Reader reader) throws IOException {
        int size;
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[1000];
        while ((size = reader.read(buffer)) > 0) {
            sb.append(buffer, 0, size);
        }
        return sb.toString();
    }

    static /* synthetic */ boolean access$000(AddSpeciesController x0) {
        return x0.listBoxEcho;
    }

    static /* synthetic */ boolean access$002(AddSpeciesController x0, boolean x1) {
        x0.listBoxEcho = x1;
        return x0.listBoxEcho;
    }

    static /* synthetic */ Vbox access$100(AddSpeciesController x0) {
        return x0.vboxImportSL;
    }

    static /* synthetic */ void access$200(AddSpeciesController x0) {
        x0.refreshBtnOkDisabled();
    }

    static /* synthetic */ String access$300(AddSpeciesController x0) {
        return x0.multipleSpeciesUploadName;
    }

    static /* synthetic */ String access$302(AddSpeciesController x0, String x1) {
        x0.multipleSpeciesUploadName = x1;
        return x0.multipleSpeciesUploadName;
    }

    static /* synthetic */ boolean access$400(AddSpeciesController x0) {
        return x0.loadedAssemblage;
    }

    static /* synthetic */ String access$384(AddSpeciesController x0, Object x1) {
        x0.multipleSpeciesUploadName = x0.multipleSpeciesUploadName + x1;
        return x0.multipleSpeciesUploadName;
    }

    static /* synthetic */ SpeciesAutoCompleteComponent access$500(AddSpeciesController x0) {
        return x0.mSearchSpeciesACComponent;
    }

    static /* synthetic */ Button access$600(AddSpeciesController x0) {
        return x0.btnOk;
    }
}

