/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.add;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.legend.Facet;
import au.org.ala.legend.Legend;
import au.org.ala.legend.LegendObject;
import au.org.ala.legend.QueryField;
import au.org.ala.spatial.composer.add.AddFacetController;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.QueryUtil;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.composer.UtilityComposer;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.menu.SelectedArea;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.SuspendNotAllowedException;
import org.zkoss.zk.ui.event.CheckEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.ForwardEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Button;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Div;
import org.zkoss.zul.Doublebox;
import org.zkoss.zul.Html;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listheader;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.SimpleListModel;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Window;

public class AddFacetController
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(AddFacetController.class);
    private double minValue;
    private double maxValue;
    private double gMinValue;
    private double gMaxValue;
    private Listbox legend;
    private String winTop = "300px";
    private String winLeft = "500px";
    private Map<String, Object> params;
    private int currentStep = 1;
    private int totalSteps = 2;
    private String selectedMethod = "";
    private Button btnCancel;
    private Button btnOk;
    private Button btnBack;
    private Button clearSelection;
    private int sliderMax = 500;
    private Button createInGroup;
    private List<String[]> legendLines;
    private Doublebox dmin;
    private Doublebox dmax;
    private Label dlabel;
    private Div divContinous;
    private Checkbox dunknown;
    private Button dbutton;
    private boolean intContinous = false;
    private boolean disableselection = false;
    private Map<String, String> legendFacets = null;
    private Facet facet;
    private Div dCreateButtons;
    private Listheader lhFirstColumn;
    private Listheader lhSecondColumn;
    private Listheader lhThirdColumn;
    private Listheader lhFourthColumn;
    private Combobox cbColour;
    private boolean hasCustomArea = false;
    private Radiogroup rgArea;
    private Radiogroup rgAreaHighlight;
    private Radiogroup rgSpecies;
    private Radiogroup rgSpeciesBk;
    private SelectedArea sa;
    private Query query;
    private Map map = new HashMap();
    private String colourmode;
    private boolean readonly = true;
    private boolean checkmarks = true;
    private MapComposer mc = this.getMapComposer();
    private Radio rAreaWorld;
    private Radio rAreaCustom;
    private Radio rAreaSelected;
    private Radio rAreaAustralia;
    private MapLayer prevTopArea = null;
    private Checkbox chkGeoKosherTrue;
    private Checkbox chkGeoKosherFalse;
    private LegendObject lo = null;
    private Checkbox cbContinousRange;
    private Label lblOccurrencesSelected;
    private Textbox txtSearch;
    private Label lblSelectedCount;
    private Set selectedList = new HashSet();

    public void afterCompose() {
        super.afterCompose();
        this.winTop = this.getTop();
        this.winLeft = this.getLeft();
        this.setupDefaultParams();
        HashMap tmp = new HashMap();
        Map m = Executions.getCurrent().getArg();
        if (m != null) {
            for (Map.Entry entry : m.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                tmp.put((String)entry.getKey(), entry.getValue());
            }
        }
        this.setParams(tmp);
        this.selectedMethod = "Add facet";
        this.updateWindowTitle();
        this.fixFocus();
        this.loadAreaLayers();
        if (this.rgArea.getSelectedItem() != null) {
            this.btnOk.setDisabled(false);
        } else {
            this.btnOk.setDisabled(true);
        }
        this.getFellow("btnSearch").addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        this.getFellow("btnClear").addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        3 labelComparatorAsc = new /* Unavailable Anonymous Inner Class!! */;
        4 labelComparatorDesc = new /* Unavailable Anonymous Inner Class!! */;
        5 countComparatorAsc = new /* Unavailable Anonymous Inner Class!! */;
        6 countComparatorDesc = new /* Unavailable Anonymous Inner Class!! */;
        this.lhSecondColumn.setSortAscending((Comparator)labelComparatorAsc);
        this.lhSecondColumn.setSortDescending((Comparator)labelComparatorDesc);
        this.lhFourthColumn.setSortAscending((Comparator)countComparatorAsc);
        this.lhFourthColumn.setSortDescending((Comparator)countComparatorDesc);
    }

    public void onSelect$legend(Event event) {
        this.rebuildSelectedList();
    }

    private void rebuildSelectedList() {
        for (Listitem li : this.legend.getItems()) {
            if (li.getFirstChild().getChildren().isEmpty()) continue;
            String v = ((Listcell)li.getChildren().get(1)).getLabel();
            if (((Checkbox)li.getFirstChild().getFirstChild()).isChecked()) {
                this.selectedList.add(v);
                continue;
            }
            this.selectedList.remove(v);
        }
        this.lblSelectedCount.setValue(this.selectedList.size() + " facets selected");
    }

    private void setupDefaultParams() {
        this.btnOk.setDisabled(true);
    }

    public void setParams(Map<String, Object> params) {
        if (this.params == null) {
            this.params = new HashMap();
        }
        if (params != null) {
            this.params.putAll(params);
        }
    }

    public void updateWindowTitle() {
        ((Caption)this.getFellow("cTitle")).setLabel("Step " + this.currentStep + " of " + this.totalSteps + " - " + this.selectedMethod);
    }

    void fixFocus() {
        if (this.currentStep == 1) {
            this.rgArea.setFocus(true);
            this.rgArea.setSelectedItem(this.rAreaWorld);
        } else if (this.currentStep == 2) {
            this.cbColour.setFocus(true);
        }
    }

    public void onCheck$rgArea(Event event) {
        if (this.rgArea == null) {
            return;
        }
        this.hasCustomArea = false;
        this.rAreaSelected = this.rgArea.getSelectedItem();
        if (this.rAreaSelected == this.rAreaCustom) {
            this.hasCustomArea = false;
        }
        this.btnOk.setDisabled(false);
    }

    public SelectedArea getSelectedArea() {
        String area = (String)this.rAreaSelected.getValue();
        SelectedArea selectedarea = null;
        try {
            if ("current".equals(area)) {
                selectedarea = new SelectedArea(null, this.getMapComposer().getViewArea());
            } else if ("australia".equals(area)) {
                selectedarea = new SelectedArea(null, CommonData.getSettings().getProperty("default.wkt"));
            } else if ("world".equals(area)) {
                selectedarea = new SelectedArea(null, "POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))");
            } else {
                List layers = this.getMapComposer().getPolygonLayers();
                for (MapLayer ml : layers) {
                    if (!area.equals(ml.getName())) continue;
                    selectedarea = new SelectedArea(ml, null);
                    break;
                }
                if (selectedarea == null) {
                    selectedarea = new SelectedArea(null, area);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to retrieve selected area", (Throwable)e);
        }
        return selectedarea;
    }

    public void onSelect$cbColour(Event event) {
        this.colourmode = (String)this.cbColour.getSelectedItem().getValue();
        try {
            this.lo = this.query.getLegend(this.colourmode);
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting legend: " + this.query.getFullQ(false) + " colourmode:" + this.colourmode), (Throwable)e);
        }
        this.map.put("colourmode", this.colourmode);
        this.buildLegend();
    }

    void buildLegend() {
        try {
            StringBuilder slist = new StringBuilder();
            if (this.query != null) {
                if ("grid".equals(this.colourmode)) {
                    slist.append("name,red,green,blue,count");
                    for (int i = 0; i < 600; i += 100) {
                        slist.append(">");
                        slist.append("\n").append(i).append(",").append(LegendObject.getRGB((int)Legend.getLinearColour((double)i, (double)0.0, (double)500.0, (int)-256, (int)-65536))).append(",");
                    }
                } else {
                    slist.append(this.query.getLegend(this.colourmode).getTable());
                }
            } else {
                return;
            }
            try {
                this.legendLines = new CSVReader((Reader)new StringReader(slist.toString())).readAll();
                this.uncheckAll();
            }
            catch (Exception e) {
                LOGGER.error((Object)"failed to read legend list as csv", (Throwable)e);
            }
            this.legendLines.remove(0);
            String h = "";
            this.facet = null;
            this.divContinous.setVisible(false);
            if (this.legendLines.size() > 1) {
                String first = ((String[])this.legendLines.get(0))[0];
                if (first == null || first.length() == 0 || first.startsWith("Unknown")) {
                    first = ((String[])this.legendLines.get(1))[0];
                }
                if (!this.checkmarks && this.query.getLegend(this.colourmode) != null && this.query.getLegend(this.colourmode).getNumericLegend() != null) {
                    this.setupForNumericalList(h);
                } else if ("occurrence_year".equals(this.colourmode)) {
                    this.setupForBiocacheNumber(h, this.colourmode, true);
                } else if ("occurrence_year_decade".equals(this.colourmode) || "decade".equals(this.colourmode)) {
                    this.setupForBiocacheDecade();
                } else if ("coordinate_uncertainty".equals(this.colourmode) || "uncertainty".equals(this.colourmode)) {
                    this.setupForBiocacheNumber(h, this.colourmode, false);
                } else if ("month".equals(this.colourmode)) {
                    this.setupForBiocacheMonth();
                }
            }
            this.legend.setItemRenderer((ListitemRenderer)new /* Unavailable Anonymous Inner Class!! */);
            this.legend.setModel((ListModel)new SimpleListModel(this.legendLines));
        }
        catch (Exception e) {
            LOGGER.error((Object)"error rendering legend", (Throwable)e);
        }
    }

    String getSelectionFacet() {
        StringBuilder values = new StringBuilder();
        boolean unknown = false;
        if (!this.divContinous.isVisible() || !this.cbContinousRange.isChecked()) {
            String unknownSearch;
            for (Object selectedItem : this.selectedList) {
                String v = (String)selectedItem;
                v = this.displayToActualLabel(v);
                if (this.legendFacets != null) {
                    if ("Unknown".equals(v) || v.contains("occurrence_year") || v.contains("uncertainty") || v.contains("coordinate_uncertainty")) {
                        this.divContinous.setVisible(true);
                        this.onCheck$cbContinousRange(null);
                    } else {
                        v = (String)this.legendFacets.get(v);
                    }
                }
                if (v.length() == 0 || (this.query instanceof BiocacheQuery || this.divContinous.isVisible()) && "Unknown".equals(v)) {
                    unknown = true;
                    continue;
                }
                if (values.length() > 0) {
                    values.append(" OR ");
                }
                if (this.legendFacets != null) {
                    values.append(v);
                    continue;
                }
                values.append(this.colourmode).append(":\"");
                values.append(v).append("\"");
            }
            String string = unknownSearch = this.divContinous.isVisible() ? ":[* TO *]" : ":*";
            if (unknown) {
                if (values.length() > 0) {
                    String newValues = "-(" + this.colourmode + unknownSearch + " AND -" + values.toString().replace(" OR ", " AND -") + ")";
                    values = new StringBuilder();
                    values.append(newValues);
                } else {
                    values.append("-").append(this.colourmode).append(unknownSearch);
                }
            }
        } else if (this.minValue != this.gMinValue || this.maxValue != this.gMaxValue || !this.dunknown.isChecked()) {
            if (this.dunknown.isChecked()) {
                if (this.intContinous) {
                    values.append(String.format("-(%s:[* TO *] AND -%s:[%d TO %d])", this.colourmode, this.colourmode, (int)this.minValue, (int)this.maxValue));
                } else {
                    values.append(String.format("-(%s:[* TO *] AND -%s:[%f TO %f])", this.colourmode, this.colourmode, this.minValue, this.maxValue));
                }
            } else if (this.intContinous) {
                values.append(String.format("%s:[%d TO %d]", this.colourmode, (int)this.minValue, (int)this.maxValue));
            } else {
                values.append(String.format("%s:[%f TO %f]", this.colourmode, this.minValue, this.maxValue));
            }
        }
        if (values.length() > 0) {
            this.facet = Facet.parseFacet((String)values.toString());
            return values.toString();
        }
        this.facet = null;
        return "";
    }

    public void onOK$dmin(Event event) {
        this.uncheckAll();
        this.minValue = this.dmin.getValue();
    }

    public void onChange$dmin(Event event) {
        this.uncheckAll();
        this.minValue = this.dmin.getValue();
    }

    public void onOK$dmax(Event event) {
        this.uncheckAll();
        this.maxValue = this.dmax.getValue();
    }

    public void onChange$dmax(Event event) {
        this.uncheckAll();
        this.maxValue = this.dmax.getValue();
    }

    public void onClick$dbutton(Event event) {
        this.uncheckAll();
        this.minValue = this.dmin.getValue();
        this.maxValue = this.dmax.getValue();
        Facet f = Facet.parseFacet((String)this.getSelectionFacet());
        Query querynew = this.query.newFacet(f, true);
        this.lblOccurrencesSelected.setValue(querynew.getOccurrenceCount() + " occurrences selected");
    }

    public void onCheck$dunknown(Event event) {
        this.uncheckAll();
    }

    void uncheckAll() {
        for (Listitem li : this.legend.getItems()) {
            if (li.getFirstChild().getChildren().isEmpty() || !((Checkbox)li.getFirstChild().getFirstChild()).isChecked()) continue;
            ((Checkbox)li.getFirstChild().getFirstChild()).setChecked(false);
        }
        this.selectedList = new HashSet();
        this.lblSelectedCount.setValue(this.selectedList.size() + " facets selected");
    }

    private void setupForNumericalList(String facetString) {
        String h = facetString;
        this.legendFacets = new HashMap();
        try {
            this.divContinous.setVisible(!this.disableselection);
            this.onCheck$cbContinousRange(null);
            if (this.lo.getFieldType() == QueryField.FieldType.INT || this.lo.getFieldType() == QueryField.FieldType.LONG) {
                this.intContinous = true;
            }
            this.gMinValue = this.minValue = (double)this.lo.getMinMax()[0];
            this.gMaxValue = this.maxValue = (double)this.lo.getMinMax()[1];
            double rng = this.gMaxValue - this.gMinValue;
            if (this.intContinous && rng < (double)this.sliderMax && rng > 0.0) {
                this.sliderMax = (int)rng;
            }
            this.dmin.setValue(this.gMinValue);
            this.dmax.setValue(this.gMaxValue);
            try {
                if (this.facet != null) {
                    boolean nulls = h.startsWith("-") || h.length() > 1 && h.charAt(1) == '-' || h.length() > 2 && h.charAt(2) == '-';
                    int countOr = h.split(" OR ").length;
                    if (countOr == 1 || nulls && countOr == 2) {
                        this.minValue = this.facet.getMin();
                        this.maxValue = this.facet.getMax();
                        if (Double.isInfinite(this.minValue)) {
                            this.minValue = this.gMinValue;
                        }
                        if (Double.isInfinite(this.maxValue)) {
                            this.maxValue = this.gMaxValue;
                        }
                    }
                    this.dunknown.setChecked(nulls);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"error with numerical legend", (Throwable)e);
            }
            for (int j = 0; j < this.legendLines.size(); ++j) {
                String strFacet;
                String range;
                double nextmin;
                double max;
                double min;
                String label = ((String[])this.legendLines.get(j))[0];
                if (label.charAt(0) == '-') {
                    this.legendFacets.put("Unknown", ((String[])this.legendLines.get(j))[0]);
                    ((String[])this.legendLines.get((int)j))[0] = "Unknown";
                    continue;
                }
                String s = ((String[])this.legendLines.get(j))[0];
                String[] ss = s.replace("[", "").replace("]", "").replace("-12-31T00:00:00Z", "").replace("-01-01T00:00:00Z", "").split(" TO ");
                float[] cutoffs = this.lo.getNumericLegend().getCutoffFloats();
                float[] cutoffMins = this.lo.getNumericLegend().getCutoffMinFloats();
                if (ss.length <= 1) continue;
                if ("*".equals(ss[1])) {
                    min = cutoffMins[0];
                    max = cutoffs[0];
                    nextmin = cutoffMins.length > 1 ? (double)cutoffMins[1] : (double)cutoffMins[0];
                } else if ("*".equals(ss[3])) {
                    min = cutoffMins[cutoffMins.length - 1];
                    max = this.gMaxValue;
                    nextmin = this.gMaxValue;
                } else {
                    double v = Double.parseDouble(ss[1]);
                    int pos = 0;
                    while (v > (double)cutoffs[pos]) {
                        ++pos;
                    }
                    min = cutoffMins[pos];
                    max = cutoffs[pos];
                    double d = nextmin = cutoffMins.length > pos + 1 ? (double)cutoffMins[pos + 1] : (double)cutoffMins[pos];
                }
                if (this.intContinous) {
                    range = min == this.gMinValue && max == this.gMaxValue ? String.format(">= %d and <= %d", (int)min, (int)max) : (min == this.gMinValue ? String.format(">= %d and < %d", (int)min, (int)nextmin) : (max == this.gMaxValue ? String.format("<= %d", (int)max) : String.format("< %d", (int)nextmin)));
                    strFacet = this.colourmode + ":[" + (int)min + " TO " + (int)max + "]";
                } else {
                    range = min == this.gMinValue && max == this.gMaxValue ? String.format(">= %g and <= %g", min, max) : (min == this.gMinValue ? String.format(">= %g and < %g", min, nextmin) : (max == this.gMaxValue ? String.format("<= %g", max) : String.format("< %g", nextmin)));
                    strFacet = this.colourmode + ":[" + min + " TO " + max + "]";
                }
                ((String[])this.legendLines.get((int)j))[0] = range;
                this.legendFacets.put(range, strFacet);
            }
            this.checkmarks = true;
        }
        catch (Exception e) {
            this.divContinous.setVisible(false);
            this.onCheck$cbContinousRange(null);
            LOGGER.error((Object)"error building numerical legend", (Throwable)e);
        }
    }

    private void setupForBiocacheNumber(String facetString, String facetName, boolean integer) {
        this.intContinous = integer;
        this.legendFacets = new HashMap();
        if (this.lo != null) {
            this.divContinous.setVisible(!this.disableselection);
            this.onCheck$cbContinousRange(null);
            this.gMinValue = this.minValue = (double)this.lo.getMinMax()[0];
            this.gMaxValue = this.maxValue = (double)this.lo.getMinMax()[1];
            this.dmin.setValue(this.gMinValue);
            this.dmax.setValue(this.gMaxValue);
            if (this.intContinous) {
                this.sliderMax = Math.min(this.sliderMax, (int)(this.gMaxValue - this.gMinValue));
            }
            try {
                if (this.facet != null) {
                    boolean nulls = facetString.contains("-(" + facetName + ":") || facetString.contains("-" + facetName + ":");
                    int countOr = facetString.split(" OR ").length;
                    if (countOr == 1 || nulls && countOr == 2) {
                        this.minValue = this.facet.getMin();
                        this.maxValue = this.facet.getMax();
                        if (Double.isInfinite(this.minValue)) {
                            this.minValue = this.gMinValue;
                        }
                        if (Double.isInfinite(this.maxValue)) {
                            this.maxValue = this.gMaxValue;
                        }
                    }
                    this.dunknown.setChecked(nulls);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"error building numberical legend", (Throwable)e);
            }
            for (int j = 0; j < this.legendLines.size(); ++j) {
                String strFacet;
                String range;
                String label = ((String[])this.legendLines.get(j))[0];
                if (label.charAt(0) == '-') {
                    this.legendFacets.put("Unknown", ((String[])this.legendLines.get(j))[0]);
                    ((String[])this.legendLines.get((int)j))[0] = "Unknown";
                    continue;
                }
                String s = ((String[])this.legendLines.get(j))[0];
                String[] ss = s.replace("[", "").replace("]", "").replace("-12-31T00:00:00Z", "").replace("-01-01T00:00:00Z", "").split(" TO ");
                float[] cutoffs = this.lo.getNumericLegend().getCutoffFloats();
                float[] cutoffMins = this.lo.getNumericLegend().getCutoffMinFloats();
                if (ss.length <= 1) continue;
                if ("*".equals(ss[0])) {
                    if (this.intContinous) {
                        range = cutoffs.length > 1 ? String.format(">= %d and < %d", (int)cutoffMins[0], (int)cutoffMins[1]) : String.format(">= %d and <= %d", (int)cutoffMins[0], (int)cutoffs[0]);
                        if ("occurrence_year".equals(this.colourmode) || "occurrence_year_decade".equals(this.colourmode) || "decade".equals(this.colourmode)) {
                            String minyear = String.valueOf((int)cutoffMins[0]);
                            while (minyear.length() < 4) {
                                minyear = "0" + minyear;
                            }
                            strFacet = "" + facetName + ":[" + minyear + "-12-31T00:00:00Z" + " TO " + (int)cutoffs[0] + "-12-31T00:00:00Z" + "]";
                        } else {
                            strFacet = "" + facetName + ":[" + (int)cutoffMins[0] + " TO " + (int)cutoffs[0] + "]";
                        }
                    } else {
                        range = cutoffs.length > 1 ? String.format(">= %.2f and < %.2f", Float.valueOf(cutoffMins[0]), Float.valueOf(cutoffMins[1])) : String.format(">= %.2f and <= %.2f", Float.valueOf(cutoffMins[0]), Float.valueOf(cutoffs[0]));
                        strFacet = "" + facetName + ":[" + cutoffMins[0] + " TO " + cutoffs[0] + "]";
                    }
                } else if ("*".equals(ss[1])) {
                    if (this.intContinous) {
                        range = String.format("<= %d", (int)this.gMaxValue);
                        if ("occurrence_year".equals(this.colourmode) || "occurrence_year_decade".equals(this.colourmode) || "decade".equals(this.colourmode)) {
                            String minyear = String.valueOf((int)cutoffMins[cutoffMins.length - 1]);
                            while (minyear.length() < 4) {
                                minyear = "0" + minyear;
                            }
                            strFacet = "" + facetName + ":[" + minyear + "-01-01T00:00:00Z TO " + (int)this.gMaxValue + "-12-31T00:00:00Z]";
                        } else {
                            strFacet = "" + facetName + ":[" + (int)cutoffMins[cutoffMins.length - 1] + " TO " + (int)this.gMaxValue + "]";
                        }
                    } else {
                        range = String.format("<= %.2f", this.gMaxValue);
                        strFacet = "" + facetName + ":[" + cutoffMins[cutoffMins.length - 1] + " TO " + this.gMaxValue + "]";
                    }
                } else {
                    double v = Double.parseDouble(ss[1]);
                    int pos = 0;
                    while (v > (double)cutoffs[pos]) {
                        ++pos;
                    }
                    if (this.intContinous) {
                        range = pos + 1 < cutoffs.length ? String.format("< %d", (int)cutoffMins[pos + 1]) : String.format("<= %d", (int)cutoffs[pos]);
                        if ("occurrence_year".equals(this.colourmode) || "occurrence_year_decade".equals(this.colourmode) || "decade".equals(this.colourmode)) {
                            String minyear = String.valueOf((int)cutoffMins[pos]);
                            while (minyear.length() < 4) {
                                minyear = "0" + minyear;
                            }
                            strFacet = "" + facetName + ":[" + minyear + "-01-01T00:00:00Z TO " + (int)cutoffs[pos] + "-12-31T00:00:00Z]";
                        } else {
                            strFacet = "" + facetName + ":[" + (int)cutoffMins[pos] + " TO " + (int)cutoffs[pos] + "]";
                        }
                    } else {
                        range = pos + 1 < cutoffs.length ? String.format("< %.2f", Float.valueOf(cutoffMins[pos + 1])) : String.format("<= %.2f", Float.valueOf(cutoffs[pos]));
                        strFacet = "" + facetName + ":[" + cutoffMins[pos] + " TO " + cutoffs[pos] + "]";
                    }
                }
                ((String[])this.legendLines.get((int)j))[0] = range;
                this.legendFacets.put(range, strFacet);
            }
        }
    }

    private void setupForBiocacheDecade() {
        this.intContinous = true;
        this.legendFacets = new HashMap();
        if (this.lo != null) {
            for (int j = 0; j < this.legendLines.size(); ++j) {
                String label = ((String[])this.legendLines.get(j))[0];
                if (label.charAt(0) == '-') {
                    this.legendFacets.put("Unknown", ((String[])this.legendLines.get(j))[0]);
                    ((String[])this.legendLines.get((int)j))[0] = "Unknown";
                    continue;
                }
                String[] ss = ((String[])this.legendLines.get(j))[0].split(" TO ");
                if (ss.length <= 1) continue;
                String yr = ss[1].substring(0, ss[1].length() - 2);
                String range = String.format("%s0s", yr);
                String strFacet = "occurrence_year:[" + yr + "0-01-01T00:00:00Z TO " + yr + "9-12-31T00:00:00Z]";
                ((String[])this.legendLines.get((int)j))[0] = range;
                this.legendFacets.put(range, strFacet);
            }
        }
    }

    private void setupForBiocacheMonth() {
        this.legendFacets = new HashMap();
        for (int j = 0; j < this.legendLines.size(); ++j) {
            String label = ((String[])this.legendLines.get(j))[0];
            if (label.charAt(0) == '-') {
                this.legendFacets.put("Unknown", ((String[])this.legendLines.get(j))[0]);
                ((String[])this.legendLines.get((int)j))[0] = "Unknown";
                continue;
            }
            String s = ((String[])this.legendLines.get(j))[0];
            String[] ss = (s = s.substring(s.indexOf(91) + 1, s.indexOf(93))).split(" TO ");
            if (ss.length > 1) {
                if ("01".equals(ss[1])) {
                    s = "January";
                } else if ("02".equals(ss[1])) {
                    s = "February";
                } else if ("03".equals(ss[1])) {
                    s = "March";
                } else if ("04".equals(ss[1])) {
                    s = "April";
                } else if ("05".equals(ss[1])) {
                    s = "May";
                } else if ("06".equals(ss[1])) {
                    s = "June";
                } else if ("07".equals(ss[1])) {
                    s = "July";
                } else if ("08".equals(ss[1])) {
                    s = "August";
                } else if ("09".equals(ss[1])) {
                    s = "September";
                } else if ("10".equals(ss[1])) {
                    s = "October";
                } else if ("11".equals(ss[1])) {
                    s = "November";
                } else if ("12".equals(ss[1])) {
                    s = "December";
                }
            }
            this.legendFacets.put(s, "month:[" + ss[1] + " TO " + ss[1] + "]");
            ((String[])this.legendLines.get((int)j))[0] = s;
        }
    }

    public void onClick$clearSelection(Event e) {
        this.uncheckAll();
        this.btnOk.setDisabled(true);
    }

    public void onClick$selectAll(Event event) {
        if (this.legend != null && this.legend.getItemCount() > 0) {
            for (Listitem li : this.legend.getItems()) {
                if (li.getFirstChild().getChildren().isEmpty() || ((Checkbox)li.getFirstChild().getFirstChild()).isChecked()) continue;
                ((Checkbox)li.getFirstChild().getFirstChild()).setChecked(true);
                String v = ((Listcell)li.getChildren().get(1)).getLabel();
                this.selectedList.add(v);
            }
            this.btnOk.setDisabled(false);
        }
        this.lblSelectedCount.setValue(this.selectedList.size() + " facets selected");
    }

    public void onClick$btnCancel(Event event) {
        this.detach();
    }

    public void onClick$btnOk(Event event) {
        if (this.btnOk.isDisabled()) {
            return;
        }
        try {
            if (!this.hasCustomArea && (this.isAreaCustom() || this.isAreaHighlightCustom())) {
                this.doOverlapped();
                this.setTop("-9999px");
                this.setLeft("-9999px");
                HashMap<String, Object> winProps = new HashMap<String, Object>();
                winProps.put("parent", this);
                winProps.put("parentname", "Tool");
                winProps.put("selectedMethod", this.selectedMethod);
                List layers = this.getMapComposer().getPolygonLayers();
                this.prevTopArea = layers != null && !layers.isEmpty() ? (MapLayer)layers.get(0) : null;
                Window window = (Window)Executions.createComponents((String)"WEB-INF/zul/add/AddArea.zul", (Component)this, winProps);
                window.setAttribute("winProps", winProps, true);
                window.setParent((Component)this);
                window.doModal();
                return;
            }
            Div currentDiv = (Div)this.getFellowIfAny("atstep" + this.currentStep);
            Div nextDiv = (Div)this.getFellowIfAny("atstep" + (this.currentStep + 1));
            if (!currentDiv.getZclass().contains("last")) {
                currentDiv.setVisible(false);
                nextDiv.setVisible(true);
                Html previousStepCompletedImg = (Html)this.getFellowIfAny("imgCompletedStep" + this.currentStep);
                previousStepCompletedImg.setVisible(true);
                Label previousStepLabel = (Label)this.getFellowIfAny("lblStep" + this.currentStep);
                previousStepLabel.setStyle("font-weight:normal");
                Label currentStepLabel = (Label)this.getFellowIfAny("lblStep" + (this.currentStep + 1));
                currentStepLabel.setStyle("font-weight:bold");
                ++this.currentStep;
                this.updateWindowTitle();
                this.fixFocus();
                this.sa = this.getSelectedArea();
                this.query = QueryUtil.queryFromSelectedArea((Query)this.query, (SelectedArea)this.sa, (boolean)false, (boolean[])this.getGeospatialKosher());
                if (this.query != null) {
                    List fields = this.query.getFacetFieldList();
                    Collections.sort(fields, new QueryField.QueryFieldComparator());
                    String lastGroup = null;
                    for (QueryField field : fields) {
                        String newGroup = field.getGroup().getName();
                        if (!newGroup.equals(lastGroup)) {
                            Comboitem sep = new Comboitem("seperator");
                            sep.setLabel("---------------" + StringUtils.center((String)newGroup, (int)19) + "---------------");
                            sep.setParent((Component)this.cbColour);
                            sep.setDisabled(true);
                            lastGroup = newGroup;
                        }
                        Comboitem ci = new Comboitem(field.getDisplayName());
                        ci.setValue((Object)field.getName());
                        ci.setParent((Component)this.cbColour);
                    }
                }
                this.btnBack.setDisabled(false);
                this.btnOk.setDisabled(true);
            } else {
                Facet f;
                Query querynew;
                if (this.selectedList.size() == 0) {
                    this.btnOk.setDisabled(true);
                }
                if ((querynew = this.query.newFacet(f = Facet.parseFacet((String)this.getSelectionFacet()), true)).getOccurrenceCount() <= 0) {
                    this.getMapComposer().showMessage(CommonData.lang((String)"no_occurrences_selected"));
                } else {
                    this.getMapComposer().mapSpecies(querynew, "My facet", "species", -1, 21, null, 0, 3, 0.6f, Util.nextColour(), false);
                    this.detach();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"error adding facet", (Throwable)ex);
        }
        this.fixFocus();
    }

    public void onClick$btnBack(Event event) {
        Div previousDiv;
        Div currentDiv = (Div)this.getFellowIfAny("atstep" + this.currentStep);
        Div div = previousDiv = this.currentStep > 1 ? (Div)this.getFellowIfAny("atstep" + (this.currentStep - 1)) : null;
        if (currentDiv.getZclass().contains("first")) {
            this.btnBack.setDisabled(true);
        } else {
            currentDiv.setVisible(false);
            previousDiv.setVisible(true);
            Html currentStepCompletedImg = (Html)this.getFellowIfAny("imgCompletedStep" + (this.currentStep - 1));
            currentStepCompletedImg.setVisible(false);
            Label nextStepLabel = (Label)this.getFellowIfAny("lblStep" + this.currentStep);
            nextStepLabel.setStyle("font-weight:normal");
            Label currentStepLabel = (Label)this.getFellowIfAny("lblStep" + (this.currentStep - 1));
            currentStepLabel.setStyle("font-weight:bold");
            --this.currentStep;
            this.btnBack.setDisabled(previousDiv.getZclass().contains("first"));
        }
        this.btnOk.setDisabled(false);
        this.updateWindowTitle();
    }

    private boolean isAreaHighlightTab() {
        return this.rgAreaHighlight != null && this.rgAreaHighlight.getParent().isVisible();
    }

    boolean isAreaTab() {
        return this.rgArea != null && this.rgArea.getParent().isVisible();
    }

    boolean isAreaCustom() {
        return this.isAreaTab() && this.rAreaCustom != null && this.rAreaCustom.isSelected();
    }

    boolean isAreaHighlightCustom() {
        return this.isAreaHighlightTab() && this.rgAreaHighlight != null && "rAreaCustomHighlight".equals(this.rgAreaHighlight.getSelectedItem().getId());
    }

    public void onCheck$rgAreaHighlight(Event event) {
        if (this.rgAreaHighlight == null) {
            return;
        }
        if ("rAreaCustomHighlight".equals(this.rgAreaHighlight.getSelectedItem().getId())) {
            this.hasCustomArea = false;
        }
    }

    public void loadAreaLayers() {
        this.loadAreaLayers(null);
    }

    public void loadAreaLayers(String selectedAreaName) {
        try {
            int i;
            Radiogroup rgArealocal = (Radiogroup)this.getFellowIfAny("rgArea");
            for (int i2 = rgArealocal.getItemCount() - 1; i2 >= 0; --i2) {
                String id = ((Radio)rgArealocal.getItems().get(i2)).getId();
                if (id == null || id.length() == 0) {
                    rgArealocal.removeItemAt(i2);
                    continue;
                }
                rgArealocal.getItemAtIndex(i2).setSelected(false);
            }
            Radio rAreaCurrent = (Radio)this.getFellowIfAny("rAreaCurrent");
            String selectedLayerName = (String)this.params.get("polygonLayerName");
            Radio rSelectedLayer = null;
            List layers = this.getMapComposer().getPolygonLayers();
            for (i = 0; i < layers.size(); ++i) {
                MapLayer lyr = (MapLayer)layers.get(i);
                Radio rAr = new Radio(lyr.getDisplayName());
                rAr.setValue((Object)lyr.getName());
                rAr.setParent((Component)rgArealocal);
                rgArealocal.insertBefore((Component)rAr, (Component)rAreaCurrent);
                if (!lyr.getName().equals(selectedLayerName)) continue;
                rSelectedLayer = rAr;
                this.rAreaSelected = rAr;
            }
            if (selectedAreaName != null && !selectedAreaName.isEmpty()) {
                for (i = 0; i < rgArealocal.getItemCount(); ++i) {
                    if (!rgArealocal.getItemAtIndex(i).isVisible() || !rgArealocal.getItemAtIndex(i).getLabel().equals(selectedAreaName)) continue;
                    this.rAreaSelected = rgArealocal.getItemAtIndex(i);
                    LOGGER.debug((Object)("2.resetting indexToSelect = " + i));
                    rgArealocal.setSelectedItem(this.rAreaSelected);
                    break;
                }
            } else if (rSelectedLayer != null) {
                this.rAreaSelected = rSelectedLayer;
                rgArealocal.setSelectedItem(this.rAreaSelected);
            } else if ("none".equals(selectedLayerName)) {
                rgArealocal.setSelectedItem(this.rAreaWorld);
                this.rAreaSelected = this.rAreaWorld;
                rgArealocal.setSelectedItem(this.rAreaSelected);
            } else {
                this.rAreaSelected = this.rAreaWorld;
                rgArealocal.setSelectedItem(this.rAreaSelected);
            }
            Clients.evalJavaScript((String)("jq('#" + this.rAreaSelected.getUuid() + "-real').attr('checked', true);"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to load active area layers", (Throwable)e);
        }
    }

    public void loadAreaHighlightLayers(String selectedAreaName) {
        try {
            int i;
            Radiogroup rgArealocal = (Radiogroup)this.getFellowIfAny("rgAreaHighlight");
            for (int i2 = rgArealocal.getItemCount() - 1; i2 >= 0; --i2) {
                String id = ((Radio)rgArealocal.getItems().get(i2)).getId();
                if (id == null || id.length() == 0) {
                    rgArealocal.removeItemAt(i2);
                    continue;
                }
                rgArealocal.getItemAtIndex(i2).setSelected(false);
            }
            Radio rAreaCurrentHighlight = (Radio)this.getFellowIfAny("rAreaCurrentHighlight");
            String selectedLayerName = (String)this.params.get("polygonLayerName");
            Radio rSelectedLayer = null;
            List layers = this.getMapComposer().getPolygonLayers();
            for (i = 0; i < layers.size(); ++i) {
                MapLayer lyr = (MapLayer)layers.get(i);
                Radio rAr = new Radio(lyr.getDisplayName());
                rAr.setValue((Object)lyr.getName());
                rAr.setParent((Component)rgArealocal);
                rgArealocal.insertBefore((Component)rAr, (Component)rAreaCurrentHighlight);
                if (!lyr.getName().equals(selectedLayerName)) continue;
                rSelectedLayer = rAr;
            }
            if (selectedAreaName != null && !selectedAreaName.isEmpty()) {
                for (i = 0; i < rgArealocal.getItemCount(); ++i) {
                    if (!rgArealocal.getItemAtIndex(i).isVisible() || !rgArealocal.getItemAtIndex(i).getLabel().equals(selectedAreaName)) continue;
                    LOGGER.debug((Object)("2.resetting indexToSelect = " + i));
                    rgArealocal.setSelectedItem(rgArealocal.getItemAtIndex(i));
                    break;
                }
            } else if (rSelectedLayer != null) {
                rgArealocal.setSelectedItem(this.rAreaSelected);
            } else if ("none".equals(selectedLayerName)) {
                rgArealocal.setSelectedItem(this.rAreaWorld);
            } else {
                for (i = 0; i < rgArealocal.getItemCount(); ++i) {
                    if (!rgArealocal.getItemAtIndex(i).isVisible()) continue;
                    rgArealocal.setSelectedItem(rgArealocal.getItemAtIndex(i));
                    break;
                }
            }
            Clients.evalJavaScript((String)("jq('#" + rgArealocal.getSelectedItem().getUuid() + "-real').attr('checked', true);"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to load active area layers", (Throwable)e);
        }
    }

    public void loadAreaLayersHighlight() {
        try {
            Radiogroup rgArealocal = (Radiogroup)this.getFellowIfAny("rgAreaHighlight");
            Radio rAreaCurrent = (Radio)this.getFellowIfAny("rAreaCurrentHighlight");
            Radio rAreaNone = (Radio)this.getFellowIfAny("rAreaNoneHighlight");
            List layers = this.getMapComposer().getPolygonLayers();
            for (int i = 0; i < layers.size(); ++i) {
                MapLayer lyr = (MapLayer)layers.get(i);
                Radio rAr = new Radio(lyr.getDisplayName());
                rAr.setId(lyr.getName().replaceAll(" ", ""));
                rAr.setValue((Object)lyr.getName());
                rAr.setParent((Component)rgArealocal);
                rgArealocal.insertBefore((Component)rAr, (Component)rAreaCurrent);
            }
            rAreaNone.setSelected(true);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to load active area layers", (Throwable)e);
        }
    }

    public void resetWindow(String selectedArea) {
        try {
            List layers;
            MapLayer curTopArea;
            this.hasCustomArea = selectedArea != null && !selectedArea.trim().isEmpty();
            boolean ok = false;
            if (this.hasCustomArea && (curTopArea = (layers = this.getMapComposer().getPolygonLayers()) != null && !layers.isEmpty() ? (MapLayer)layers.get(0) : null) != this.prevTopArea) {
                if (this.isAreaHighlightTab()) {
                    this.loadAreaHighlightLayers(curTopArea.getDisplayName());
                } else if (this.isAreaTab()) {
                    this.loadAreaLayers(curTopArea.getDisplayName());
                }
                ok = true;
            }
            this.setTop(this.winTop);
            this.setLeft(this.winLeft);
            this.doModal();
            if (ok) {
                this.onClick$btnOk(null);
                this.hasCustomArea = false;
            }
            this.fixFocus();
        }
        catch (SuspendNotAllowedException ex) {
            LOGGER.error((Object)"Exception when resetting analysis window", (Throwable)ex);
        }
    }

    public boolean[] getGeospatialKosher() {
        return new boolean[]{this.chkGeoKosherTrue.isChecked(), this.chkGeoKosherFalse.isChecked(), false};
    }

    public void onCheck$chkGeoKosherTrue(Event event) {
        Event evt = ((ForwardEvent)event).getOrigin();
        if (!((CheckEvent)evt).isChecked() && !this.chkGeoKosherFalse.isChecked()) {
            this.chkGeoKosherFalse.setChecked(true);
        }
    }

    public void onCheck$chkGeoKosherFalse(Event event) {
        Event evt = ((ForwardEvent)event).getOrigin();
        if (!((CheckEvent)evt).isChecked() && !this.chkGeoKosherTrue.isChecked()) {
            this.chkGeoKosherTrue.setChecked(true);
        }
    }

    private String displayToActualLabel(String v) {
        String actual = null;
        for (String key : CommonData.getI18nPropertiesList((String)this.colourmode)) {
            String s = CommonData.getI18nProperty((String)key);
            if (!s.equals(v)) continue;
            int pos = key.indexOf(46);
            if (pos > 0) {
                actual = key.substring(pos + 1);
                continue;
            }
            actual = key;
        }
        if (actual == null) {
            actual = v;
        }
        return actual;
    }

    private String actualToDisplayLabel(String v) {
        String s = CommonData.getI18nProperty((String)(this.colourmode + "." + v));
        if (s == null) {
            s = v;
        }
        return s;
    }

    public void onCheck$cbContinousRange(Event c) {
        this.dmin.setDisabled(!this.cbContinousRange.isChecked());
        this.dmax.setDisabled(!this.cbContinousRange.isChecked());
        this.dbutton.setDisabled(!this.cbContinousRange.isChecked());
        this.dunknown.setDisabled(!this.cbContinousRange.isChecked());
        for (Listitem li : this.legend.getItems()) {
            if (li.getFirstChild().getChildren().isEmpty()) continue;
            li.getFirstChild().getFirstChild().setVisible(!this.cbContinousRange.isChecked());
        }
        if (!this.cbContinousRange.isChecked()) {
            this.dlabel.setValue(CommonData.lang((String)"msg_list_selection_enabled"));
        } else {
            this.dlabel.setValue(CommonData.lang((String)"msg_range_selection_enabled"));
        }
    }

    static /* synthetic */ Textbox access$000(AddFacetController x0) {
        return x0.txtSearch;
    }

    static /* synthetic */ List access$100(AddFacetController x0) {
        return x0.legendLines;
    }

    static /* synthetic */ Listbox access$200(AddFacetController x0) {
        return x0.legend;
    }

    static /* synthetic */ boolean access$300(AddFacetController x0) {
        return x0.checkmarks;
    }

    static /* synthetic */ Button access$400(AddFacetController x0) {
        return x0.btnOk;
    }

    static /* synthetic */ void access$500(AddFacetController x0) {
        x0.rebuildSelectedList();
    }

    static /* synthetic */ Checkbox access$600(AddFacetController x0) {
        return x0.cbContinousRange;
    }

    static /* synthetic */ boolean access$700(AddFacetController x0) {
        return x0.disableselection;
    }

    static /* synthetic */ boolean access$800(AddFacetController x0) {
        return x0.readonly;
    }

    static /* synthetic */ String access$900(AddFacetController x0, String x1) {
        return x0.actualToDisplayLabel(x1);
    }

    static /* synthetic */ Set access$1000(AddFacetController x0) {
        return x0.selectedList;
    }

    static /* synthetic */ Logger access$1100() {
        return LOGGER;
    }

    static /* synthetic */ Listheader access$1200(AddFacetController x0) {
        return x0.lhFourthColumn;
    }
}

