/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.add;

import au.org.ala.spatial.composer.add.AddFacetController;
import au.org.ala.spatial.composer.tool.ToolComposer;
import au.org.ala.spatial.logger.RemoteLogger;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.LayersUtil;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.composer.UtilityComposer;
import au.org.emii.portal.menu.MapLayer;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Button;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.Window;

public class AddAreaController
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(AddAreaController.class);
    private RemoteLogger remoteLogger;
    private Radiogroup cbAreaSelection;
    private Radio ciWKT;
    private Radio ciUploadKML;
    private Radio ciRegionSelection;
    private Radio ciBoundingBox;
    private Radio ciPolygon;
    private Radio ciPointAndRadius;
    private Radio ciAddressRadiusSelection;
    private Radio ciMapPolygon;
    private Radio ciEnvironmentalEnvelope;
    private Radio ciUploadShapefile;
    private Radio ciBoxAustralia;
    private Radio ciBoxWorld;
    private Radio ciBoxCurrentView;
    private Radio ciRadiusManualSelection;
    private Radio ciMergeAreas;
    private Button btnOk;
    private Map args;

    public void afterCompose() {
        super.afterCompose();
        this.args = Executions.getCurrent().getArg();
    }

    public void onClick$btnOk(Event event) {
        MapComposer mc;
        block41: {
            ToolComposer analysisParent;
            String layerName;
            String wkt;
            if (this.btnOk.isDisabled()) {
                return;
            }
            String windowName = "";
            mc = this.getMapComposer();
            String script = "";
            boolean overlapped = true;
            if (this.cbAreaSelection.getSelectedItem() == this.ciBoundingBox) {
                windowName = "WEB-INF/zul/add/area/AreaBoundingBox.zul";
                script = mc.getOpenLayersJavascript().addBoxDrawingTool();
            } else if (this.cbAreaSelection.getSelectedItem() == this.ciPolygon) {
                windowName = "WEB-INF/zul/add/area/AreaPolygon.zul";
                script = mc.getOpenLayersJavascript().addPolygonDrawingTool();
            } else if (this.cbAreaSelection.getSelectedItem() == this.ciPointAndRadius) {
                windowName = "WEB-INF/zul/add/area/AreaPointAndRadius.zul";
                script = mc.getOpenLayersJavascript().addRadiusDrawingTool();
            } else if (this.cbAreaSelection.getSelectedItem() == this.ciRegionSelection) {
                overlapped = false;
                windowName = "WEB-INF/zul/add/area/AreaRegionSelection.zul";
            } else if (this.cbAreaSelection.getSelectedItem() == this.ciAddressRadiusSelection) {
                overlapped = false;
                windowName = "WEB-INF/zul/add/area/AreaAddressRadiusSelection.zul";
            } else if (this.cbAreaSelection.getSelectedItem() == this.ciRadiusManualSelection) {
                overlapped = false;
                windowName = "WEB-INF/zul/add/area/AreaRadiusManualSelection.zul";
            } else if (this.cbAreaSelection.getSelectedItem() == this.ciUploadShapefile) {
                windowName = "WEB-INF/zul/add/area/AreaUploadShapefile.zul";
                overlapped = false;
            } else if (this.cbAreaSelection.getSelectedItem() == this.ciUploadKML) {
                windowName = "WEB-INF/zul/add/area/AreaUploadKML.zul";
                overlapped = false;
            } else if (this.cbAreaSelection.getSelectedItem() == this.ciMapPolygon) {
                List layers = this.getMapComposer().getContextualLayers();
                if (layers.isEmpty()) {
                    windowName = "WEB-INF/zul/layer/ContextualLayerSelection.zul";
                    overlapped = false;
                } else {
                    windowName = "WEB-INF/zul/add/area/AreaMapPolygon.zul";
                    script = mc.getOpenLayersJavascript().addFeatureSelectionTool();
                }
            } else if (this.cbAreaSelection.getSelectedItem() == this.ciEnvironmentalEnvelope) {
                windowName = "WEB-INF/zul/add/area/AreaEnvironmentalEnvelope.zul";
            } else if (this.cbAreaSelection.getSelectedItem() == this.ciBoxAustralia) {
                wkt = CommonData.getSettings().getProperty("default.wkt");
                layerName = mc.getNextAreaLayerName(CommonData.lang((String)"australia_bounding_box"));
                MapLayer mapLayer = mc.addWKTLayer(wkt, layerName, layerName);
                mapLayer.getMapLayerMetadata().setMoreInfo(LayersUtil.getMetadata((String)(CommonData.lang((String)"australia_bounding_box") + " " + wkt)));
                this.remoteLogger.logMapArea(layerName, "Area - BoxAustralia", wkt);
            } else if (this.cbAreaSelection.getSelectedItem() == this.ciBoxWorld) {
                wkt = "POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))";
                layerName = mc.getNextAreaLayerName(CommonData.lang((String)"world_bounding_box"));
                MapLayer mapLayer = mc.addWKTLayer(wkt, layerName, layerName);
                mapLayer.getMapLayerMetadata().setMoreInfo(LayersUtil.getMetadata((String)(CommonData.lang((String)"world_bounding_box") + " " + wkt)));
                this.remoteLogger.logMapArea(layerName, "Area - BoxWorld", wkt);
            } else if (this.cbAreaSelection.getSelectedItem() == this.ciBoxCurrentView) {
                wkt = mc.getMapComposer().getViewArea();
                layerName = mc.getNextAreaLayerName(CommonData.lang((String)"current_view_area"));
                MapLayer mapLayer = mc.addWKTLayer(wkt, layerName, layerName);
                mapLayer.getMapLayerMetadata().setMoreInfo(LayersUtil.getMetadata((String)(CommonData.lang((String)"current_view_area") + " " + wkt)));
                this.remoteLogger.logMapArea(layerName, "Area - BoxCurrentView", wkt);
            } else if (this.cbAreaSelection.getSelectedItem() == this.ciWKT) {
                windowName = "WEB-INF/zul/add/area/AreaWKT.zul";
            } else if (this.cbAreaSelection.getSelectedItem() == this.ciMergeAreas) {
                windowName = "WEB-INF/zul/add/area/AreaMerge.zul";
                overlapped = false;
            }
            if (!windowName.isEmpty()) {
                mc.getOpenLayersJavascript().execute(mc.getOpenLayersJavascript().getIFrameReferences() + script);
                Window window = (Window)Executions.createComponents((String)windowName, (Component)this.getParent(), (Map)this.args);
                try {
                    if (overlapped) {
                        window.doOverlapped();
                        break block41;
                    }
                    window.setParent(this.getParent());
                    window.doModal();
                }
                catch (Exception e) {
                    LOGGER.error((Object)("error opening window: " + windowName), (Throwable)e);
                }
            } else if ("addtoolwindow".equals(this.getParent().getId())) {
                analysisParent = (ToolComposer)this.getParent();
                analysisParent.resetWindow(this.getMapComposer().getNextAreaLayerName("My Area"));
            } else if ("addfacetwindow".equals(this.getParent().getId())) {
                analysisParent = (AddFacetController)this.getParent();
                analysisParent.resetWindow(this.getMapComposer().getNextAreaLayerName("My Area"));
            }
        }
        if (this.cbAreaSelection.getSelectedItem() != null) {
            mc.setAttribute("addareawindow", (Object)this.cbAreaSelection.getSelectedItem().getId());
        }
        this.detach();
    }

    public void onClick$btnCancel(Event event) {
        if ("addtoolwindow".equals(this.getParent().getId())) {
            ToolComposer analysisParent = (ToolComposer)this.getParent();
            analysisParent.resetWindow(null);
        }
        this.detach();
    }
}

