/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.legend;

import au.org.ala.legend.Legend;
import au.org.ala.legend.QueryField;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class LegendObject
implements Serializable {
    public static final int[] colours = new int[]{0x3366CC, 14432530, 0xFF9900, 1087000, 0x990099, 39366, 0xDD4477, 0x66AA00, 12070446, 3236757, 0x994499, 0x22AA99, 0xAAAA11, 0x6633CC, 15102720, 9111303, 6623335, 3314274, 5600422, 3882668, 12022562, 1496608, 12129155, 16004510, 10246453, 11125779, 2783117, 6720796, 12493843, 809250, 7615505};
    public static final int DEFAULT_COLOUR = 0xFFFFFF;
    public static final boolean LIMIT_LEGEND = false;
    protected HashMap<String, int[]> categories;
    protected String[] categoryNameOrder;
    Legend numericLegend;
    QueryField.FieldType fieldType;
    String colourMode;

    public LegendObject() {
    }

    public LegendObject(Legend numericLegend, QueryField.FieldType fieldType) {
        this.numericLegend = numericLegend;
        this.fieldType = fieldType;
    }

    public LegendObject(String[] categories, int[] counts) {
        int i;
        Object[] objects = new Object[categories.length];
        for (i = 0; i < objects.length; ++i) {
            Object[] o = new Object[]{categories[i], counts[i]};
            objects[i] = o;
        }
        Arrays.sort(objects, new /* Unavailable Anonymous Inner Class!! */);
        this.categories = new HashMap();
        this.categoryNameOrder = new String[objects.length];
        for (i = 0; i < objects.length; ++i) {
            String category = (String)((Object[])objects[i])[0];
            int[] data = new int[]{colours[i < colours.length ? i : colours.length - 1], (Integer)((Object[])objects[i])[1]};
            this.categories.put(category, data);
            this.categoryNameOrder[i] = category;
        }
    }

    public static String getRGB(int colour) {
        return (colour >> 16 & 0xFF) + "," + (colour >> 8 & 0xFF) + "," + (colour & 0xFF);
    }

    public String getTable() {
        StringBuilder sb;
        block9: {
            block8: {
                sb = new StringBuilder();
                sb.append("name,red,green,blue,count");
                if (this.numericLegend == null) break block8;
                if (this.numericLegend.getMinMax() == null) break block9;
                float[] minmax = this.numericLegend.getMinMax();
                float[] cutoffs = this.numericLegend.getCutoffFloats();
                float[] cutoffMins = this.numericLegend.getCutoffFloats();
                String format = "%.4f";
                if (this.fieldType == QueryField.FieldType.INT || this.fieldType == QueryField.FieldType.LONG) {
                    format = "%.0f";
                }
                if (this.numericLegend.countOfNaN > 0) {
                    sb.append("\nn/a,0,0,0,").append(this.numericLegend.countOfNaN);
                }
                if (minmax[0] == minmax[1]) {
                    String rgb = LegendObject.getRGB((int)this.numericLegend.getColour(minmax[0]));
                    sb.append("\n").append(String.format(format, Float.valueOf(minmax[0]))).append(",").append(rgb).append(",");
                } else {
                    for (int i = 0; i < cutoffs.length; ++i) {
                        if (i != 0 && !(cutoffs[i - 1] < cutoffs[i])) continue;
                        String rgb = LegendObject.getRGB((int)this.numericLegend.getColour(cutoffs[i]));
                        String start = String.valueOf(cutoffMins[i]);
                        String end = String.valueOf(cutoffs[i]);
                        if (i == 0) {
                            start = "*";
                        }
                        if (i == cutoffs.length - 1) {
                            end = "*";
                        }
                        sb.append("\nname:[").append(start).append(" TO ").append(end).append("]");
                        sb.append(",").append(rgb).append(",").append(this.numericLegend.groupSizesArea[i]);
                    }
                }
                break block9;
            }
            for (int i = 0; i < this.categoryNameOrder.length && i < colours.length; ++i) {
                int[] data = (int[])this.categories.get(this.categoryNameOrder[i]);
                String rgb = LegendObject.getRGB((int)data[0]);
                sb.append("\n\"").append(this.categoryNameOrder[i].replace("\"", "\"\"")).append("\",").append(rgb).append(",").append(data[1]);
            }
        }
        return sb.toString();
    }

    public void setTable(String table) {
    }

    public int getColour(String value) {
        if (this.numericLegend != null) {
            try {
                return this.getColour(Float.parseFloat(value));
            }
            catch (Exception e) {
                return 0xFFFFFF;
            }
        }
        int[] data = (int[])this.categories.get(value);
        if (data != null) {
            return data[0];
        }
        return 0xFFFFFF;
    }

    public int getColour(float value) {
        if (this.numericLegend != null) {
            return this.numericLegend.getColour(value);
        }
        int i = (int)value;
        if (i >= 0 && i < this.categoryNameOrder.length) {
            return this.getColour(this.categoryNameOrder[i]);
        }
        return 0xFFFFFF;
    }

    public float[] getMinMax() {
        if (this.numericLegend != null) {
            return this.numericLegend.getMinMax();
        }
        float[] d = new float[]{0.0f, this.categoryNameOrder.length};
        return d;
    }

    public void setMinMax(float[] minmax) {
    }

    public String[] getCategoryNameOrder() {
        return this.categoryNameOrder;
    }

    public void setCategoryNameOrder(String[] cno) {
        this.categoryNameOrder = cno;
    }

    public String getColourMode() {
        return this.colourMode;
    }

    public void setColourMode(String colourMode) {
        this.colourMode = colourMode;
    }

    public Legend getNumericLegend() {
        return this.numericLegend;
    }

    public void setNumericLegend(Legend numericLegend) {
        this.numericLegend = numericLegend;
    }

    public QueryField.FieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(QueryField.FieldType ft) {
        this.fieldType = ft;
    }

    public HashMap<String, int[]> getCategories() {
        return this.categories;
    }

    public void setCategories(HashMap<String, int[]> categories) {
        this.categories = categories;
    }
}

