/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.legend;

import au.org.ala.legend.Legend;

public class LegendEvenIntervalLog
extends Legend {
    public void generate(float[] d, int divisions) {
        this.init(d, divisions);
        if (Float.isNaN(this.max)) {
            return;
        }
        float offset = this.min < 1.0f ? 1.0f - this.min : 0.0f;
        float tmax = this.max + offset;
        float tmin = this.min + offset;
        double lmin = Math.log(tmin);
        double lmax = Math.log(tmax);
        double lrange = lmax - lmin;
        this.cutoffs = new float[divisions];
        for (int i = 0; i < divisions; ++i) {
            this.cutoffs[i] = (float)Math.pow(Math.E, lmin + lrange * ((double)(i + 1) / (double)divisions)) - offset;
        }
        this.cutoffs[divisions - 1] = this.max;
    }

    public String getTypeName() {
        return "Even Interval Log";
    }
}

