/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.legend;

import au.org.ala.legend.Legend;

public class LegendEqualSize
extends Legend {
    public void generate(float[] d, int divisions) {
        this.init(d, divisions);
        if (Float.isNaN(this.max)) {
            return;
        }
        this.cutoffs = new float[divisions];
        int step = (int)Math.ceil((double)this.numberOfUniqueValues / (double)divisions);
        int uniqueCount = 0;
        int uniqueSum = 0;
        int pos = 0;
        for (int i = 0; i < this.lastValue; ++i) {
            if (uniqueCount >= step) {
                uniqueSum += uniqueCount;
                uniqueCount = 0;
                while (i + 1 < this.lastValue && d[i] == d[i + 1]) {
                    ++i;
                }
                if (i >= this.lastValue) {
                    while (pos < this.cutoffs.length) {
                        this.cutoffs[pos] = this.max;
                        ++pos;
                    }
                    break;
                }
                this.cutoffs[pos] = d[i - 1];
                step = (int)Math.ceil((double)(this.numberOfUniqueValues - uniqueSum) / (double)(divisions - ++pos));
            }
            if (i != 0 && d[i - 1] == d[i]) continue;
            ++uniqueCount;
        }
        this.cutoffs[this.cutoffs.length - 1] = this.max;
    }

    public String getTypeName() {
        return "Equal Size";
    }
}

