/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.legend;

import au.org.ala.legend.Legend;
import java.util.ArrayList;

public class LegendEqualArea
extends Legend {
    public void generate(float[] d, int divisions) {
        this.init(d, divisions);
        if (Float.isNaN(this.max)) {
            return;
        }
        this.cutoffs = new float[divisions];
        double scaling = 1.0;
        int direction = 0;
        int pos = 0;
        while (true) {
            int step = (int)(Math.ceil((double)this.numberOfRecords / (double)divisions) * scaling);
            ArrayList highFrequencyValues = this.getValuesByFrequency(d, step);
            int count = 0;
            pos = 0;
            int i = 0;
            for (i = 0; i < this.lastValue && pos < divisions; ++i) {
                if (count >= step || i + 1 < this.lastValue && highFrequencyValues.contains(Float.valueOf(d[i + 1])) || highFrequencyValues.contains(Float.valueOf(d[i])) || i == this.lastValue - 1) {
                    while (i + 1 < this.lastValue && d[i] == d[i + 1]) {
                        ++i;
                        ++count;
                    }
                    if (i >= this.lastValue) break;
                    this.cutoffs[pos] = d[i];
                    step = (int)(Math.ceil((double)(this.numberOfRecords - i) / (double)(divisions - ++pos)) * scaling);
                    count = 0;
                }
                ++count;
            }
            if (i != this.lastValue && direction >= 0) {
                scaling *= 1.2;
                direction = 1;
                continue;
            }
            if (pos >= divisions || this.numberOfUniqueValues <= divisions || direction > 0) break;
            scaling /= 1.2;
            direction = -1;
        }
        this.stretch(this.cutoffs, divisions, pos);
        this.cutoffs[this.cutoffs.length - 1] = this.max;
    }

    public String getTypeName() {
        return "Equal Area";
    }

    private void stretch(float[] cutoffs, int divisions, int pos) {
        if (pos < divisions && pos > 0) {
            int i;
            int j;
            double step = (double)divisions / ((double)(divisions - pos) + 1.0);
            for (int i2 = 1; i2 < divisions - pos + 1; ++i2) {
                int min = (int)Math.round((double)i2 * step);
                for (j = divisions - 1; j >= min; --j) {
                    cutoffs[j] = cutoffs[j - 1];
                }
            }
            int start = 1;
            for (i = 1; i < divisions; ++i) {
                if (cutoffs[i] == cutoffs[i - 1] || i - start <= 1) continue;
                int mid = (i - start) / 2 + start;
                for (int j2 = start; j2 < mid; ++j2) {
                    cutoffs[j2] = cutoffs[j2 - 1];
                }
                start = i;
            }
            if (cutoffs[divisions - 1] == cutoffs[divisions - 2]) {
                for (i = divisions - 1; i > 0; --i) {
                    if (cutoffs[i] == cutoffs[i - 1]) continue;
                    for (j = i; j < divisions - 1; ++j) {
                        cutoffs[j] = cutoffs[j - 1];
                    }
                    break;
                }
            }
        }
    }

    private ArrayList<Float> getValuesByFrequency(float[] d, int step) {
        int[] uniqueValueDistribution = new int[this.numberOfUniqueValues];
        float[] uniqueValues = new float[this.numberOfUniqueValues];
        int p = 0;
        uniqueValues[0] = d[0];
        for (int i = 0; i < this.lastValue; ++i) {
            if (i > 0 && d[i] != d[i - 1]) {
                uniqueValues[++p] = d[i];
            }
            int n = p;
            uniqueValueDistribution[n] = uniqueValueDistribution[n] + 1;
        }
        ArrayList<Float> list = new ArrayList<Float>();
        for (int i = 0; i < this.numberOfUniqueValues; ++i) {
            if (uniqueValueDistribution[i] < step) continue;
            list.add(Float.valueOf(uniqueValues[i]));
        }
        return list;
    }
}

