var process = process || {env: {NODE_ENV: "development"}};
/*! ========================================================================
 * Bootstrap Toggle: bootstrap-toggle.js v2.2.0
 * http://www.bootstraptoggle.com
 * ========================================================================
 * Copyright 2014 Min Hur, The New York Times Company
 * Licensed under MIT
 * ======================================================================== */
+function(a){"use strict";function b(b){return this.each(function(){var d=a(this),e=d.data("bs.toggle"),f="object"==typeof b&&b;e||d.data("bs.toggle",e=new c(this,f)),"string"==typeof b&&e[b]&&e[b]()})}var c=function(b,c){this.$element=a(b),this.options=a.extend({},this.defaults(),c),this.render()};c.VERSION="2.2.0",c.DEFAULTS={on:"On",off:"Off",onstyle:"primary",offstyle:"default",size:"normal",style:"",width:null,height:null},c.prototype.defaults=function(){return{on:this.$element.attr("data-on")||c.DEFAULTS.on,off:this.$element.attr("data-off")||c.DEFAULTS.off,onstyle:this.$element.attr("data-onstyle")||c.DEFAULTS.onstyle,offstyle:this.$element.attr("data-offstyle")||c.DEFAULTS.offstyle,size:this.$element.attr("data-size")||c.DEFAULTS.size,style:this.$element.attr("data-style")||c.DEFAULTS.style,width:this.$element.attr("data-width")||c.DEFAULTS.width,height:this.$element.attr("data-height")||c.DEFAULTS.height}},c.prototype.render=function(){this._onstyle="btn-"+this.options.onstyle,this._offstyle="btn-"+this.options.offstyle;var b="large"===this.options.size?"btn-lg":"small"===this.options.size?"btn-sm":"mini"===this.options.size?"btn-xs":"",c=a('<label class="btn">').html(this.options.on).addClass(this._onstyle+" "+b),d=a('<label class="btn">').html(this.options.off).addClass(this._offstyle+" "+b+" active"),e=a('<span class="toggle-handle btn btn-default">').addClass(b),f=a('<div class="toggle-group">').append(c,d,e),g=a('<div class="toggle btn" data-toggle="toggle">').addClass(this.$element.prop("checked")?this._onstyle:this._offstyle+" off").addClass(b).addClass(this.options.style);this.$element.wrap(g),a.extend(this,{$toggle:this.$element.parent(),$toggleOn:c,$toggleOff:d,$toggleGroup:f}),this.$toggle.append(f);var h=this.options.width||Math.max(c.outerWidth(),d.outerWidth())+e.outerWidth()/2,i=this.options.height||Math.max(c.outerHeight(),d.outerHeight());c.addClass("toggle-on"),d.addClass("toggle-off"),this.$toggle.css({width:h,height:i}),this.options.height&&(c.css("line-height",c.height()+"px"),d.css("line-height",d.height()+"px")),this.update(!0),this.trigger(!0)},c.prototype.toggle=function(){this.$element.prop("checked")?this.off():this.on()},c.prototype.on=function(a){return this.$element.prop("disabled")?!1:(this.$toggle.removeClass(this._offstyle+" off").addClass(this._onstyle),this.$element.prop("checked",!0),void(a||this.trigger()))},c.prototype.off=function(a){return this.$element.prop("disabled")?!1:(this.$toggle.removeClass(this._onstyle).addClass(this._offstyle+" off"),this.$element.prop("checked",!1),void(a||this.trigger()))},c.prototype.enable=function(){this.$toggle.removeAttr("disabled"),this.$element.prop("disabled",!1)},c.prototype.disable=function(){this.$toggle.attr("disabled","disabled"),this.$element.prop("disabled",!0)},c.prototype.update=function(a){this.$element.prop("disabled")?this.disable():this.enable(),this.$element.prop("checked")?this.on(a):this.off(a)},c.prototype.trigger=function(b){this.$element.off("change.bs.toggle"),b||this.$element.change(),this.$element.on("change.bs.toggle",a.proxy(function(){this.update()},this))},c.prototype.destroy=function(){this.$element.off("change.bs.toggle"),this.$toggleGroup.remove(),this.$element.removeData("bs.toggle"),this.$element.unwrap()};var d=a.fn.bootstrapToggle;a.fn.bootstrapToggle=b,a.fn.bootstrapToggle.Constructor=c,a.fn.toggle.noConflict=function(){return a.fn.bootstrapToggle=d,this},a(function(){a("input[type=checkbox][data-toggle^=toggle]").bootstrapToggle()}),a(document).on("click.bs.toggle","div[data-toggle^=toggle]",function(b){var c=a(this).find("input[type=checkbox]");c.bootstrapToggle("toggle"),b.preventDefault()})}(jQuery);
//# sourceMappingURL=bootstrap-toggle.min.js.map
var process = process || {env: {NODE_ENV: "development"}};
/**
 * Bootstrap Multiselect (https://github.com/davidstutz/bootstrap-multiselect)
 *
 * Apache License, Version 2.0:
 * Copyright (c) 2012 - 2015 David Stutz
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a
 * copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * BSD 3-Clause License:
 * Copyright (c) 2012 - 2015 David Stutz
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *    - Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *    - Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *    - Neither the name of David Stutz nor the names of its contributors may be
 *      used to endorse or promote products derived from this software without
 *      specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
!function ($) {
    "use strict";// jshint ;_;

    if (typeof ko !== 'undefined' && ko.bindingHandlers && !ko.bindingHandlers.multiselect) {
        ko.bindingHandlers.multiselect = {
            after: ['options', 'value', 'selectedOptions', 'enable', 'disable'],

            init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
                var $element = $(element);
                var config = ko.toJS(valueAccessor());

                $element.multiselect(config);

                if (allBindings.has('options')) {
                    var options = allBindings.get('options');
                    if (ko.isObservable(options)) {
                        ko.computed({
                            read: function() {
                                options();
                                setTimeout(function() {
                                    var ms = $element.data('multiselect');
                                    if (ms)
                                        ms.updateOriginalOptions();//Not sure how beneficial this is.
                                    $element.multiselect('rebuild');
                                }, 1);
                            },
                            disposeWhenNodeIsRemoved: element
                        });
                    }
                }

                //value and selectedOptions are two-way, so these will be triggered even by our own actions.
                //It needs some way to tell if they are triggered because of us or because of outside change.
                //It doesn't loop but it's a waste of processing.
                if (allBindings.has('value')) {
                    var value = allBindings.get('value');
                    if (ko.isObservable(value)) {
                        ko.computed({
                            read: function() {
                                value();
                                setTimeout(function() {
                                    $element.multiselect('refresh');
                                }, 1);
                            },
                            disposeWhenNodeIsRemoved: element
                        }).extend({ rateLimit: 100, notifyWhenChangesStop: true });
                    }
                }

                //Switched from arrayChange subscription to general subscription using 'refresh'.
                //Not sure performance is any better using 'select' and 'deselect'.
                if (allBindings.has('selectedOptions')) {
                    var selectedOptions = allBindings.get('selectedOptions');
                    if (ko.isObservable(selectedOptions)) {
                        ko.computed({
                            read: function() {
                                selectedOptions();
                                setTimeout(function() {
                                    $element.multiselect('refresh');
                                }, 1);
                            },
                            disposeWhenNodeIsRemoved: element
                        }).extend({ rateLimit: 100, notifyWhenChangesStop: true });
                    }
                }

                var setEnabled = function (enable) {
                    setTimeout(function () {
                        if (enable)
                            $element.multiselect('enable');
                        else
                            $element.multiselect('disable');
                    });
                };

                if (allBindings.has('enable')) {
                    var enable = allBindings.get('enable');
                    if (ko.isObservable(enable)) {
                        ko.computed({
                            read: function () {
                                setEnabled(enable());
                            },
                            disposeWhenNodeIsRemoved: element
                        }).extend({ rateLimit: 100, notifyWhenChangesStop: true });
                    } else {
                        setEnabled(enable);
                    }
                }

                if (allBindings.has('disable')) {
                    var disable = allBindings.get('disable');
                    if (ko.isObservable(disable)) {
                        ko.computed({
                            read: function () {
                                setEnabled(!disable());
                            },
                            disposeWhenNodeIsRemoved: element
                        }).extend({ rateLimit: 100, notifyWhenChangesStop: true });
                    } else {
                        setEnabled(!disable);
                    }
                }

                ko.utils.domNodeDisposal.addDisposeCallback(element, function() {
                    $element.multiselect('destroy');
                });
            },

            update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
                var $element = $(element);
                var config = ko.toJS(valueAccessor());

                $element.multiselect('setOptions', config);
                $element.multiselect('rebuild');
            }
        };
    }

    function forEach(array, callback) {
        for (var index = 0; index < array.length; ++index) {
            callback(array[index], index);
        }
    }

    /**
     * Constructor to create a new multiselect using the given select.
     *
     * @param {jQuery} select
     * @param {Object} options
     * @returns {Multiselect}
     */
    function Multiselect(select, options) {

        this.$select = $(select);
        this.options = this.mergeOptions($.extend({}, options, this.$select.data()));

        // Placeholder via data attributes
        if (this.$select.attr("data-placeholder")) {
            this.options.nonSelectedText = this.$select.data("placeholder");
        }

        // Initialization.
        // We have to clone to create a new reference.
        this.originalOptions = this.$select.clone()[0].options;
        this.query = '';
        this.searchTimeout = null;
        this.lastToggledInput = null;

        this.options.multiple = this.$select.attr('multiple') === "multiple";
        this.options.onChange = $.proxy(this.options.onChange, this);
        this.options.onSelectAll = $.proxy(this.options.onSelectAll, this);
        this.options.onDeselectAll = $.proxy(this.options.onDeselectAll, this);
        this.options.onDropdownShow = $.proxy(this.options.onDropdownShow, this);
        this.options.onDropdownHide = $.proxy(this.options.onDropdownHide, this);
        this.options.onDropdownShown = $.proxy(this.options.onDropdownShown, this);
        this.options.onDropdownHidden = $.proxy(this.options.onDropdownHidden, this);
        this.options.onInitialized = $.proxy(this.options.onInitialized, this);
        this.options.onFiltering = $.proxy(this.options.onFiltering, this);

        // Build select all if enabled.
        this.buildContainer();
        this.buildButton();
        this.buildDropdown();
        this.buildSelectAll();
        this.buildDropdownOptions();
        this.buildFilter();

        this.updateButtonText();
        this.updateSelectAll(true);

        if (this.options.enableClickableOptGroups && this.options.multiple) {
            this.updateOptGroups();
        }

        this.options.wasDisabled = this.$select.prop('disabled');
        if (this.options.disableIfEmpty && $('option', this.$select).length <= 0) {
            this.disable();
        }

        this.$select.wrap('<span class="multiselect-native-select" />').after(this.$container);
        this.options.onInitialized(this.$select, this.$container);
    }

    Multiselect.prototype = {

        defaults: {
            /**
             * Default text function will either print 'None selected' in case no
             * option is selected or a list of the selected options up to a length
             * of 3 selected options.
             *
             * @param {jQuery} options
             * @param {jQuery} select
             * @returns {String}
             */
            buttonText: function(options, select) {
                if (this.disabledText.length > 0
                    && (select.prop('disabled') || (options.length == 0 && this.disableIfEmpty)))  {

                    return this.disabledText;
                }
                else if (options.length === 0) {
                    return this.nonSelectedText;
                }
                else if (this.allSelectedText
                    && options.length === $('option', $(select)).length
                    && $('option', $(select)).length !== 1
                    && this.multiple) {

                    if (this.selectAllNumber) {
                        return this.allSelectedText + ' (' + options.length + ')';
                    }
                    else {
                        return this.allSelectedText;
                    }
                }
                else if (options.length > this.numberDisplayed) {
                    return options.length + ' ' + this.nSelectedText;
                }
                else {
                    var selected = '';
                    var delimiter = this.delimiterText;

                    options.each(function() {
                        var label = ($(this).attr('label') !== undefined) ? $(this).attr('label') : $(this).text();
                        selected += label + delimiter;
                    });

                    return selected.substr(0, selected.length - this.delimiterText.length);
                }
            },
            /**
             * Updates the title of the button similar to the buttonText function.
             *
             * @param {jQuery} options
             * @param {jQuery} select
             * @returns {@exp;selected@call;substr}
             */
            buttonTitle: function(options, select) {
                if (options.length === 0) {
                    return this.nonSelectedText;
                }
                else {
                    var selected = '';
                    var delimiter = this.delimiterText;

                    options.each(function () {
                        var label = ($(this).attr('label') !== undefined) ? $(this).attr('label') : $(this).text();
                        selected += label + delimiter;
                    });
                    return selected.substr(0, selected.length - this.delimiterText.length);
                }
            },
            checkboxName: function(option) {
                return false; // no checkbox name
            },
            /**
             * Create a label.
             *
             * @param {jQuery} element
             * @returns {String}
             */
            optionLabel: function(element){
                return $(element).attr('label') || $(element).text();
            },
            /**
             * Create a class.
             *
             * @param {jQuery} element
             * @returns {String}
             */
            optionClass: function(element) {
                return $(element).attr('class') || '';
            },
            /**
             * Triggered on change of the multiselect.
             *
             * Not triggered when selecting/deselecting options manually.
             *
             * @param {jQuery} option
             * @param {Boolean} checked
             */
            onChange : function(option, checked) {

            },
            /**
             * Triggered when the dropdown is shown.
             *
             * @param {jQuery} event
             */
            onDropdownShow: function(event) {

            },
            /**
             * Triggered when the dropdown is hidden.
             *
             * @param {jQuery} event
             */
            onDropdownHide: function(event) {

            },
            /**
             * Triggered after the dropdown is shown.
             *
             * @param {jQuery} event
             */
            onDropdownShown: function(event) {

            },
            /**
             * Triggered after the dropdown is hidden.
             *
             * @param {jQuery} event
             */
            onDropdownHidden: function(event) {

            },
            /**
             * Triggered on select all.
             */
            onSelectAll: function() {

            },
            /**
             * Triggered on deselect all.
             */
            onDeselectAll: function() {

            },
            /**
             * Triggered after initializing.
             *
             * @param {jQuery} $select
             * @param {jQuery} $container
             */
            onInitialized: function($select, $container) {

            },
            /**
             * Triggered on filtering.
             *
             * @param {jQuery} $filter
             */
            onFiltering: function($filter) {

            },
            enableHTML: false,
            buttonClass: 'btn btn-default',
            inheritClass: false,
            buttonWidth: 'auto',
            buttonContainer: '<div class="btn-group" />',
            dropRight: false,
            dropUp: false,
            selectedClass: 'active',
            // Maximum height of the dropdown menu.
            // If maximum height is exceeded a scrollbar will be displayed.
            maxHeight: false,
            includeSelectAllOption: false,
            includeSelectAllIfMoreThan: 0,
            selectAllText: ' Select all',
            selectAllValue: 'multiselect-all',
            selectAllName: false,
            selectAllNumber: true,
            selectAllJustVisible: true,
            enableFiltering: false,
            enableCaseInsensitiveFiltering: false,
            enableFullValueFiltering: false,
            enableClickableOptGroups: false,
            enableCollapsibleOptGroups: false,
            filterPlaceholder: 'Search',
            // possible options: 'text', 'value', 'both'
            filterBehavior: 'text',
            includeFilterClearBtn: true,
            preventInputChangeEvent: false,
            nonSelectedText: 'None selected',
            nSelectedText: 'selected',
            allSelectedText: 'All selected',
            numberDisplayed: 3,
            disableIfEmpty: false,
            disabledText: '',
            delimiterText: ', ',
            templates: {
                button: '<button type="button" class="multiselect dropdown-toggle" data-toggle="dropdown"><span class="multiselect-selected-text"></span> <b class="caret"></b></button>',
                ul: '<ul class="multiselect-container dropdown-menu"></ul>',
                filter: '<li class="multiselect-item multiselect-filter"><div class="input-group"><span class="input-group-addon"><i class="icon icon-search"></i></span><input class="form-control multiselect-search" type="text"></div></li>',
                filterClearBtn: '<span class="input-group-btn"><button class="btn btn-default multiselect-clear-filter" type="button"><i class="icon icon-remove-circle"></i></button></span>',
                li: '<li><a tabindex="0"><label></label></a></li>',
                divider: '<li class="multiselect-item divider"></li>',
                liGroup: '<li class="multiselect-item multiselect-group"><label></label></li>'
            }
        },

        constructor: Multiselect,

        /**
         * Builds the container of the multiselect.
         */
        buildContainer: function() {
            this.$container = $(this.options.buttonContainer);
            this.$container.on('show.bs.dropdown', this.options.onDropdownShow);
            this.$container.on('hide.bs.dropdown', this.options.onDropdownHide);
            this.$container.on('shown.bs.dropdown', this.options.onDropdownShown);
            this.$container.on('hidden.bs.dropdown', this.options.onDropdownHidden);
        },

        /**
         * Builds the button of the multiselect.
         */
        buildButton: function() {
            this.$button = $(this.options.templates.button).addClass(this.options.buttonClass);
            if (this.$select.attr('class') && this.options.inheritClass) {
                this.$button.addClass(this.$select.attr('class'));
            }
            // Adopt active state.
            if (this.$select.prop('disabled')) {
                this.disable();
            }
            else {
                this.enable();
            }

            // Manually add button width if set.
            if (this.options.buttonWidth && this.options.buttonWidth !== 'auto') {
                this.$button.css({
                    'width' : '100%', //this.options.buttonWidth,
                    'overflow' : 'hidden',
                    'text-overflow' : 'ellipsis'
                });
                this.$container.css({
                    'width': this.options.buttonWidth
                });
            }

            // Keep the tab index from the select.
            var tabindex = this.$select.attr('tabindex');
            if (tabindex) {
                this.$button.attr('tabindex', tabindex);
            }

            this.$container.prepend(this.$button);
        },

        /**
         * Builds the ul representing the dropdown menu.
         */
        buildDropdown: function() {

            // Build ul.
            this.$ul = $(this.options.templates.ul);

            if (this.options.dropRight) {
                this.$ul.addClass('pull-right');
            }

            // Set max height of dropdown menu to activate auto scrollbar.
            if (this.options.maxHeight) {
                // TODO: Add a class for this option to move the css declarations.
                this.$ul.css({
                    'max-height': this.options.maxHeight + 'px',
                    'overflow-y': 'auto',
                    'overflow-x': 'hidden'
                });
            }

            if (this.options.dropUp) {

                var height = Math.min(this.options.maxHeight, $('option[data-role!="divider"]', this.$select).length*26 + $('option[data-role="divider"]', this.$select).length*19 + (this.options.includeSelectAllOption ? 26 : 0) + (this.options.enableFiltering || this.options.enableCaseInsensitiveFiltering ? 44 : 0));
                var moveCalc = height + 34;

                this.$ul.css({
                    'max-height': height + 'px',
                    'overflow-y': 'auto',
                    'overflow-x': 'hidden',
                    'margin-top': "-" + moveCalc + 'px'
                });
            }

            this.$container.append(this.$ul);
        },

        /**
         * Build the dropdown options and binds all necessary events.
         *
         * Uses createDivider and createOptionValue to create the necessary options.
         */
        buildDropdownOptions: function() {

            this.$select.children().each($.proxy(function(index, element) {

                var $element = $(element);
                // Support optgroups and options without a group simultaneously.
                var tag = $element.prop('tagName')
                    .toLowerCase();

                if ($element.prop('value') === this.options.selectAllValue) {
                    return;
                }

                if (tag === 'optgroup') {
                    this.createOptgroup(element);
                }
                else if (tag === 'option') {

                    if ($element.data('role') === 'divider') {
                        this.createDivider();
                    }
                    else {
                        this.createOptionValue(element);
                    }

                }

                // Other illegal tags will be ignored.
            }, this));

            // Bind the change event on the dropdown elements.
            $('li:not(.multiselect-group) input', this.$ul).on('change', $.proxy(function(event) {
                var $target = $(event.target);

                var checked = $target.prop('checked') || false;
                var isSelectAllOption = $target.val() === this.options.selectAllValue;

                // Apply or unapply the configured selected class.
                if (this.options.selectedClass) {
                    if (checked) {
                        $target.closest('li')
                            .addClass(this.options.selectedClass);
                    }
                    else {
                        $target.closest('li')
                            .removeClass(this.options.selectedClass);
                    }
                }

                // Get the corresponding option.
                var value = $target.val();
                var $option = this.getOptionByValue(value);

                var $optionsNotThis = $('option', this.$select).not($option);
                var $checkboxesNotThis = $('input', this.$container).not($target);

                if (isSelectAllOption) {

                    if (checked) {
                        this.selectAll(this.options.selectAllJustVisible, true);
                    }
                    else {
                        this.deselectAll(this.options.selectAllJustVisible, true);
                    }
                }
                else {
                    if (checked) {
                        $option.prop('selected', true);

                        if (this.options.multiple) {
                            // Simply select additional option.
                            $option.prop('selected', true);
                        }
                        else {
                            // Unselect all other options and corresponding checkboxes.
                            if (this.options.selectedClass) {
                                $($checkboxesNotThis).closest('li').removeClass(this.options.selectedClass);
                            }

                            $($checkboxesNotThis).prop('checked', false);
                            $optionsNotThis.prop('selected', false);

                            // It's a single selection, so close.
                            this.$button.click();
                        }

                        if (this.options.selectedClass === "active") {
                            $optionsNotThis.closest("a").css("outline", "");
                        }
                    }
                    else {
                        // Unselect option.
                        $option.prop('selected', false);
                    }

                    // To prevent select all from firing onChange: #575
                    this.options.onChange($option, checked);

                    // Do not update select all or optgroups on select all change!
                    this.updateSelectAll();

                    if (this.options.enableClickableOptGroups && this.options.multiple) {
                        this.updateOptGroups();
                    }
                }

                this.$select.change();
                this.updateButtonText();

                if(this.options.preventInputChangeEvent) {
                    return false;
                }
            }, this));

            $('li a', this.$ul).on('mousedown', function(e) {
                if (e.shiftKey) {
                    // Prevent selecting text by Shift+click
                    return false;
                }
            });

            $('li a', this.$ul).on('touchstart click', $.proxy(function(event) {
                event.stopPropagation();

                var $target = $(event.target);

                if (event.shiftKey && this.options.multiple) {
                    if($target.is("label")){ // Handles checkbox selection manually (see https://github.com/davidstutz/bootstrap-multiselect/issues/431)
                        event.preventDefault();
                        $target = $target.find("input");
                        $target.prop("checked", !$target.prop("checked"));
                    }
                    var checked = $target.prop('checked') || false;

                    if (this.lastToggledInput !== null && this.lastToggledInput !== $target) { // Make sure we actually have a range
                        var from = $target.closest("li").index();
                        var to = this.lastToggledInput.closest("li").index();

                        if (from > to) { // Swap the indices
                            var tmp = to;
                            to = from;
                            from = tmp;
                        }

                        // Make sure we grab all elements since slice excludes the last index
                        ++to;

                        // Change the checkboxes and underlying options
                        var range = this.$ul.find("li").slice(from, to).find("input");

                        range.prop('checked', checked);

                        if (this.options.selectedClass) {
                            range.closest('li')
                                .toggleClass(this.options.selectedClass, checked);
                        }

                        for (var i = 0, j = range.length; i < j; i++) {
                            var $checkbox = $(range[i]);

                            var $option = this.getOptionByValue($checkbox.val());

                            $option.prop('selected', checked);
                        }
                    }

                    // Trigger the select "change" event
                    $target.trigger("change");
                }

                // Remembers last clicked option
                if($target.is("input") && !$target.closest("li").is(".multiselect-item")){
                    this.lastToggledInput = $target;
                }

                $target.blur();
            }, this));

            // Keyboard support.
            this.$container.off('keydown.multiselect').on('keydown.multiselect', $.proxy(function(event) {
                if ($('input[type="text"]', this.$container).is(':focus')) {
                    return;
                }

                if (event.keyCode === 9 && this.$container.hasClass('open')) {
                    this.$button.click();
                }
                else {
                    var $items = $(this.$container).find("li:not(.divider):not(.disabled) a").filter(":visible");

                    if (!$items.length) {
                        return;
                    }

                    var index = $items.index($items.filter(':focus'));

                    // Navigation up.
                    if (event.keyCode === 38 && index > 0) {
                        index--;
                    }
                    // Navigate down.
                    else if (event.keyCode === 40 && index < $items.length - 1) {
                        index++;
                    }
                    else if (!~index) {
                        index = 0;
                    }

                    var $current = $items.eq(index);
                    $current.focus();

                    if (event.keyCode === 32 || event.keyCode === 13) {
                        var $checkbox = $current.find('input');

                        $checkbox.prop("checked", !$checkbox.prop("checked"));
                        $checkbox.change();
                    }

                    event.stopPropagation();
                    event.preventDefault();
                }
            }, this));

            if (this.options.enableClickableOptGroups && this.options.multiple) {
                $("li.multiselect-group input", this.$ul).on("change", $.proxy(function(event) {
                    event.stopPropagation();

                    var $target = $(event.target);
                    var checked = $target.prop('checked') || false;

                    var $li = $(event.target).closest('li');
                    var $group = $li.nextUntil("li.multiselect-group")
                        .not('.multiselect-filter-hidden')
                        .not('.disabled');

                    var $inputs = $group.find("input");

                    var values = [];
                    var $options = [];

                    if (this.options.selectedClass) {
                        if (checked) {
                            $li.addClass(this.options.selectedClass);
                        }
                        else {
                            $li.removeClass(this.options.selectedClass);
                        }
                    }

                    $.each($inputs, $.proxy(function(index, input) {
                        var value = $(input).val();
                        var $option = this.getOptionByValue(value);

                        if (checked) {
                            $(input).prop('checked', true);
                            $(input).closest('li')
                                .addClass(this.options.selectedClass);

                            $option.prop('selected', true);
                        }
                        else {
                            $(input).prop('checked', false);
                            $(input).closest('li')
                                .removeClass(this.options.selectedClass);

                            $option.prop('selected', false);
                        }

                        $options.push(this.getOptionByValue(value));
                    }, this))

                    // Cannot use select or deselect here because it would call updateOptGroups again.

                    this.options.onChange($options, checked);

                    this.updateButtonText();
                    this.updateSelectAll();
                }, this));
            }

            if (this.options.enableCollapsibleOptGroups && this.options.multiple) {
                $("li.multiselect-group .caret-container", this.$ul).on("click", $.proxy(function(event) {
                    var $li = $(event.target).closest('li');
                    var $inputs = $li.nextUntil("li.multiselect-group")
                        .not('.multiselect-filter-hidden');

                    var visible = true;
                    $inputs.each(function() {
                        visible = visible && $(this).is(':visible');
                    });

                    if (visible) {
                        $inputs.hide()
                            .addClass('multiselect-collapsible-hidden');
                    }
                    else {
                        $inputs.show()
                            .removeClass('multiselect-collapsible-hidden');
                    }
                }, this));

                $("li.multiselect-all", this.$ul).css('background', '#f3f3f3').css('border-bottom', '1px solid #eaeaea');
                $("li.multiselect-all > a > label.checkbox", this.$ul).css('padding', '3px 20px 3px 35px');
                $("li.multiselect-group > a > input", this.$ul).css('margin', '4px 0px 5px -20px');
            }
        },

        /**
         * Create an option using the given select option.
         *
         * @param {jQuery} element
         */
        createOptionValue: function(element) {
            var $element = $(element);
            if ($element.is(':selected')) {
                $element.prop('selected', true);
            }

            // Support the label attribute on options.
            var label = this.options.optionLabel(element);
            var classes = this.options.optionClass(element);
            var value = $element.val();
            var inputType = this.options.multiple ? "checkbox" : "radio";

            var $li = $(this.options.templates.li);
            var $label = $('label', $li);
            $label.addClass(inputType);
            $li.addClass(classes);

            if (this.options.enableHTML) {
                $label.html(" " + label);
            }
            else {
                $label.text(" " + label);
            }

            var $checkbox = $('<input/>').attr('type', inputType);

            var name = this.options.checkboxName($element);
            if (name) {
                $checkbox.attr('name', name);
            }

            $label.prepend($checkbox);

            var selected = $element.prop('selected') || false;
            $checkbox.val(value);

            if (value === this.options.selectAllValue) {
                $li.addClass("multiselect-item multiselect-all");
                $checkbox.parent().parent()
                    .addClass('multiselect-all');
            }

            $label.attr('title', $element.attr('title'));

            this.$ul.append($li);

            if ($element.is(':disabled')) {
                $checkbox.attr('disabled', 'disabled')
                    .prop('disabled', true)
                    .closest('a')
                    .attr("tabindex", "-1")
                    .closest('li')
                    .addClass('disabled');
            }

            $checkbox.prop('checked', selected);

            if (selected && this.options.selectedClass) {
                $checkbox.closest('li')
                    .addClass(this.options.selectedClass);
            }
        },

        /**
         * Creates a divider using the given select option.
         *
         * @param {jQuery} element
         */
        createDivider: function(element) {
            var $divider = $(this.options.templates.divider);
            this.$ul.append($divider);
        },

        /**
         * Creates an optgroup.
         *
         * @param {jQuery} group
         */
        createOptgroup: function(group) {
            var label = $(group).attr("label");
            var value = $(group).attr("value");
            var $li = $('<li class="multiselect-item multiselect-group"><a href="javascript:void(0);"><label><b></b></label></a></li>');

            var classes = this.options.optionClass(group);
            $li.addClass(classes);

            if (this.options.enableHTML) {
                $('label b', $li).html(" " + label);
            }
            else {
                $('label b', $li).text(" " + label);
            }

            if (this.options.enableCollapsibleOptGroups && this.options.multiple) {
                $('a', $li).append('<span class="caret-container"><b class="caret"></b></span>');
            }

            if (this.options.enableClickableOptGroups && this.options.multiple) {
                $('a label', $li).prepend('<input type="checkbox" value="' + value + '"/>');
            }

            if ($(group).is(':disabled')) {
                $li.addClass('disabled');
            }

            this.$ul.append($li);

            $("option", group).each($.proxy(function($, group) {
                this.createOptionValue(group);
            }, this))
        },

        /**
         * Build the select all.
         *
         * Checks if a select all has already been created.
         */
        buildSelectAll: function() {
            if (typeof this.options.selectAllValue === 'number') {
                this.options.selectAllValue = this.options.selectAllValue.toString();
            }

            var alreadyHasSelectAll = this.hasSelectAll();

            if (!alreadyHasSelectAll && this.options.includeSelectAllOption && this.options.multiple
                && $('option', this.$select).length > this.options.includeSelectAllIfMoreThan) {

                // Check whether to add a divider after the select all.
                if (this.options.includeSelectAllDivider) {
                    this.$ul.prepend($(this.options.templates.divider));
                }

                var $li = $(this.options.templates.li);
                $('label', $li).addClass("checkbox");

                if (this.options.enableHTML) {
                    $('label', $li).html(" " + this.options.selectAllText);
                }
                else {
                    $('label', $li).text(" " + this.options.selectAllText);
                }

                if (this.options.selectAllName) {
                    $('label', $li).prepend('<input type="checkbox" name="' + this.options.selectAllName + '" />');
                }
                else {
                    $('label', $li).prepend('<input type="checkbox" />');
                }

                var $checkbox = $('input', $li);
                $checkbox.val(this.options.selectAllValue);

                $li.addClass("multiselect-item multiselect-all");
                $checkbox.parent().parent()
                    .addClass('multiselect-all');

                this.$ul.prepend($li);

                $checkbox.prop('checked', false);
            }
        },

        /**
         * Builds the filter.
         */
        buildFilter: function() {

            // Build filter if filtering OR case insensitive filtering is enabled and the number of options exceeds (or equals) enableFilterLength.
            if (this.options.enableFiltering || this.options.enableCaseInsensitiveFiltering) {
                var enableFilterLength = Math.max(this.options.enableFiltering, this.options.enableCaseInsensitiveFiltering);

                if (this.$select.find('option').length >= enableFilterLength) {

                    this.$filter = $(this.options.templates.filter);
                    $('input', this.$filter).attr('placeholder', this.options.filterPlaceholder);

                    // Adds optional filter clear button
                    if(this.options.includeFilterClearBtn) {
                        var clearBtn = $(this.options.templates.filterClearBtn);
                        clearBtn.on('click', $.proxy(function(event){
                            clearTimeout(this.searchTimeout);

                            this.$filter.find('.multiselect-search').val('');
                            $('li', this.$ul).show().removeClass('multiselect-filter-hidden');

                            this.updateSelectAll();

                            if (this.options.enableClickableOptGroups && this.options.multiple) {
                                this.updateOptGroups();
                            }

                        }, this));
                        this.$filter.find('.input-group').append(clearBtn);
                    }

                    this.$ul.prepend(this.$filter);

                    this.$filter.val(this.query).on('click', function(event) {
                        event.stopPropagation();
                    }).on('input keydown', $.proxy(function(event) {
                        // Cancel enter key default behaviour
                        if (event.which === 13) {
                            event.preventDefault();
                        }

                        // This is useful to catch "keydown" events after the browser has updated the control.
                        clearTimeout(this.searchTimeout);

                        this.searchTimeout = this.asyncFunction($.proxy(function() {

                            if (this.query !== event.target.value) {
                                this.query = event.target.value;

                                var currentGroup, currentGroupVisible;
                                $.each($('li', this.$ul), $.proxy(function(index, element) {
                                    var value = $('input', element).length > 0 ? $('input', element).val() : "";
                                    var text = $('label', element).text();

                                    var filterCandidate = '';
                                    if ((this.options.filterBehavior === 'text')) {
                                        filterCandidate = text;
                                    }
                                    else if ((this.options.filterBehavior === 'value')) {
                                        filterCandidate = value;
                                    }
                                    else if (this.options.filterBehavior === 'both') {
                                        filterCandidate = text + '\n' + value;
                                    }

                                    if (value !== this.options.selectAllValue && text) {

                                        // By default lets assume that element is not
                                        // interesting for this search.
                                        var showElement = false;

                                        if (this.options.enableCaseInsensitiveFiltering) {
                                            filterCandidate = filterCandidate.toLowerCase();
                                            this.query = this.query.toLowerCase();
                                        }

                                        if (this.options.enableFullValueFiltering && this.options.filterBehavior !== 'both') {
                                            var valueToMatch = filterCandidate.trim().substring(0, this.query.length);
                                            if (this.query.indexOf(valueToMatch) > -1) {
                                                showElement = true;
                                            }
                                        }
                                        else if (filterCandidate.indexOf(this.query) > -1) {
                                            showElement = true;
                                        }

                                        // Toggle current element (group or group item) according to showElement boolean.
                                        $(element).toggle(showElement)
                                            .toggleClass('multiselect-filter-hidden', !showElement);

                                        // Differentiate groups and group items.
                                        if ($(element).hasClass('multiselect-group')) {
                                            // Remember group status.
                                            currentGroup = element;
                                            currentGroupVisible = showElement;
                                        }
                                        else {
                                            // Show group name when at least one of its items is visible.
                                            if (showElement) {
                                                $(currentGroup).show()
                                                    .removeClass('multiselect-filter-hidden');
                                            }

                                            // Show all group items when group name satisfies filter.
                                            if (!showElement && currentGroupVisible) {
                                                $(element).show()
                                                    .removeClass('multiselect-filter-hidden');
                                            }
                                        }
                                    }
                                }, this));
                            }

                            this.updateSelectAll();

                            if (this.options.enableClickableOptGroups && this.options.multiple) {
                                this.updateOptGroups();
                            }

                            this.options.onFiltering(event.target);

                        }, this), 300, this);
                    }, this));
                }
            }
        },

        /**
         * Unbinds the whole plugin.
         */
        destroy: function() {
            this.$container.remove();
            this.$select.show();

            // reset original state
            this.$select.prop('disabled', this.options.wasDisabled);

            this.$select.data('multiselect', null);
        },

        /**
         * Refreshs the multiselect based on the selected options of the select.
         */
        refresh: function () {
            var inputs = $.map($('li input', this.$ul), $);

            $('option', this.$select).each($.proxy(function (index, element) {
                var $elem = $(element);
                var value = $elem.val();
                var $input;
                for (var i = inputs.length; 0 < i--; /**/) {
                    if (value !== ($input = inputs[i]).val())
                        continue; // wrong li

                    if ($elem.is(':selected')) {
                        $input.prop('checked', true);

                        if (this.options.selectedClass) {
                            $input.closest('li')
                                .addClass(this.options.selectedClass);
                        }
                    }
                    else {
                        $input.prop('checked', false);

                        if (this.options.selectedClass) {
                            $input.closest('li')
                                .removeClass(this.options.selectedClass);
                        }
                    }

                    if ($elem.is(":disabled")) {
                        $input.attr('disabled', 'disabled')
                            .prop('disabled', true)
                            .closest('li')
                            .addClass('disabled');
                    }
                    else {
                        $input.prop('disabled', false)
                            .closest('li')
                            .removeClass('disabled');
                    }
                    break; // assumes unique values
                }
            }, this));

            this.updateButtonText();
            this.updateSelectAll();

            if (this.options.enableClickableOptGroups && this.options.multiple) {
                this.updateOptGroups();
            }
        },

        /**
         * Select all options of the given values.
         *
         * If triggerOnChange is set to true, the on change event is triggered if
         * and only if one value is passed.
         *
         * @param {Array} selectValues
         * @param {Boolean} triggerOnChange
         */
        select: function(selectValues, triggerOnChange) {
            if(!$.isArray(selectValues)) {
                selectValues = [selectValues];
            }

            for (var i = 0; i < selectValues.length; i++) {
                var value = selectValues[i];

                if (value === null || value === undefined) {
                    continue;
                }

                var $option = this.getOptionByValue(value);
                var $checkbox = this.getInputByValue(value);

                if($option === undefined || $checkbox === undefined) {
                    continue;
                }

                if (!this.options.multiple) {
                    this.deselectAll(false);
                }

                if (this.options.selectedClass) {
                    $checkbox.closest('li')
                        .addClass(this.options.selectedClass);
                }

                $checkbox.prop('checked', true);
                $option.prop('selected', true);

                if (triggerOnChange) {
                    this.options.onChange($option, true);
                }
            }

            this.updateButtonText();
            this.updateSelectAll();

            if (this.options.enableClickableOptGroups && this.options.multiple) {
                this.updateOptGroups();
            }
        },

        /**
         * Clears all selected items.
         */
        clearSelection: function () {
            this.deselectAll(false);
            this.updateButtonText();
            this.updateSelectAll();

            if (this.options.enableClickableOptGroups && this.options.multiple) {
                this.updateOptGroups();
            }
        },

        /**
         * Deselects all options of the given values.
         *
         * If triggerOnChange is set to true, the on change event is triggered, if
         * and only if one value is passed.
         *
         * @param {Array} deselectValues
         * @param {Boolean} triggerOnChange
         */
        deselect: function(deselectValues, triggerOnChange) {
            if(!$.isArray(deselectValues)) {
                deselectValues = [deselectValues];
            }

            for (var i = 0; i < deselectValues.length; i++) {
                var value = deselectValues[i];

                if (value === null || value === undefined) {
                    continue;
                }

                var $option = this.getOptionByValue(value);
                var $checkbox = this.getInputByValue(value);

                if($option === undefined || $checkbox === undefined) {
                    continue;
                }

                if (this.options.selectedClass) {
                    $checkbox.closest('li')
                        .removeClass(this.options.selectedClass);
                }

                $checkbox.prop('checked', false);
                $option.prop('selected', false);

                if (triggerOnChange) {
                    this.options.onChange($option, false);
                }
            }

            this.updateButtonText();
            this.updateSelectAll();

            if (this.options.enableClickableOptGroups && this.options.multiple) {
                this.updateOptGroups();
            }
        },

        /**
         * Selects all enabled & visible options.
         *
         * If justVisible is true or not specified, only visible options are selected.
         *
         * @param {Boolean} justVisible
         * @param {Boolean} triggerOnSelectAll
         */
        selectAll: function (justVisible, triggerOnSelectAll) {

            var justVisible = typeof justVisible === 'undefined' ? true : justVisible;
            var allLis = $("li:not(.divider):not(.disabled):not(.multiselect-group)", this.$ul);
            var visibleLis = $("li:not(.divider):not(.disabled):not(.multiselect-group):not(.multiselect-filter-hidden):not(.multiselect-collapisble-hidden)", this.$ul).filter(':visible');

            if(justVisible) {
                $('input:enabled' , visibleLis).prop('checked', true);
                visibleLis.addClass(this.options.selectedClass);

                $('input:enabled' , visibleLis).each($.proxy(function(index, element) {
                    var value = $(element).val();
                    var option = this.getOptionByValue(value);
                    $(option).prop('selected', true);
                }, this));
            }
            else {
                $('input:enabled' , allLis).prop('checked', true);
                allLis.addClass(this.options.selectedClass);

                $('input:enabled' , allLis).each($.proxy(function(index, element) {
                    var value = $(element).val();
                    var option = this.getOptionByValue(value);
                    $(option).prop('selected', true);
                }, this));
            }

            $('li input[value="' + this.options.selectAllValue + '"]', this.$ul).prop('checked', true);

            if (this.options.enableClickableOptGroups && this.options.multiple) {
                this.updateOptGroups();
            }

            if (triggerOnSelectAll) {
                this.options.onSelectAll();
            }
        },

        /**
         * Deselects all options.
         *
         * If justVisible is true or not specified, only visible options are deselected.
         *
         * @param {Boolean} justVisible
         */
        deselectAll: function (justVisible, triggerOnDeselectAll) {

            var justVisible = typeof justVisible === 'undefined' ? true : justVisible;
            var allLis = $("li:not(.divider):not(.disabled):not(.multiselect-group)", this.$ul);
            var visibleLis = $("li:not(.divider):not(.disabled):not(.multiselect-group):not(.multiselect-filter-hidden):not(.multiselect-collapisble-hidden)", this.$ul).filter(':visible');

            if(justVisible) {
                $('input[type="checkbox"]:enabled' , visibleLis).prop('checked', false);
                visibleLis.removeClass(this.options.selectedClass);

                $('input[type="checkbox"]:enabled' , visibleLis).each($.proxy(function(index, element) {
                    var value = $(element).val();
                    var option = this.getOptionByValue(value);
                    $(option).prop('selected', false);
                }, this));
            }
            else {
                $('input[type="checkbox"]:enabled' , allLis).prop('checked', false);
                allLis.removeClass(this.options.selectedClass);

                $('input[type="checkbox"]:enabled' , allLis).each($.proxy(function(index, element) {
                    var value = $(element).val();
                    var option = this.getOptionByValue(value);
                    $(option).prop('selected', false);
                }, this));
            }

            $('li input[value="' + this.options.selectAllValue + '"]', this.$ul).prop('checked', false);

            if (this.options.enableClickableOptGroups && this.options.multiple) {
                this.updateOptGroups();
            }

            if (triggerOnDeselectAll) {
                this.options.onDeselectAll();
            }
        },

        /**
         * Rebuild the plugin.
         *
         * Rebuilds the dropdown, the filter and the select all option.
         */
        rebuild: function() {
            this.$ul.html('');

            // Important to distinguish between radios and checkboxes.
            this.options.multiple = this.$select.attr('multiple') === "multiple";

            this.buildSelectAll();
            this.buildDropdownOptions();
            this.buildFilter();

            this.updateButtonText();
            this.updateSelectAll(true);

            if (this.options.enableClickableOptGroups && this.options.multiple) {
                this.updateOptGroups();
            }

            if (this.options.disableIfEmpty && $('option', this.$select).length <= 0) {
                this.disable();
            }
            else {
                this.enable();
            }

            if (this.options.dropRight) {
                this.$ul.addClass('pull-right');
            }
        },

        /**
         * The provided data will be used to build the dropdown.
         */
        dataprovider: function(dataprovider) {

            var groupCounter = 0;
            var $select = this.$select.empty();

            $.each(dataprovider, function (index, option) {
                var $tag;

                if ($.isArray(option.children)) { // create optiongroup tag
                    groupCounter++;

                    $tag = $('<optgroup/>').attr({
                        label: option.label || 'Group ' + groupCounter,
                        disabled: !!option.disabled
                    });

                    forEach(option.children, function(subOption) { // add children option tags
                        var attributes = {
                            value: subOption.value,
                            label: subOption.label || subOption.value,
                            title: subOption.title,
                            selected: !!subOption.selected,
                            disabled: !!subOption.disabled
                        };

                        //Loop through attributes object and add key-value for each attribute
                        for (var key in subOption.attributes) {
                            attributes['data-' + key] = subOption.attributes[key];
                        }
                        //Append original attributes + new data attributes to option
                        $tag.append($('<option/>').attr(attributes));
                    });
                }
                else {

                    var attributes = {
                        'value': option.value,
                        'label': option.label || option.value,
                        'title': option.title,
                        'class': option.class,
                        'selected': !!option.selected,
                        'disabled': !!option.disabled
                    };
                    //Loop through attributes object and add key-value for each attribute
                    for (var key in option.attributes) {
                        attributes['data-' + key] = option.attributes[key];
                    }
                    //Append original attributes + new data attributes to option
                    $tag = $('<option/>').attr(attributes);

                    $tag.text(option.label || option.value);
                }

                $select.append($tag);
            });

            this.rebuild();
        },

        /**
         * Enable the multiselect.
         */
        enable: function() {
            this.$select.prop('disabled', false);
            this.$button.prop('disabled', false)
                .removeClass('disabled');
        },

        /**
         * Disable the multiselect.
         */
        disable: function() {
            this.$select.prop('disabled', true);
            this.$button.prop('disabled', true)
                .addClass('disabled');
        },

        /**
         * Set the options.
         *
         * @param {Array} options
         */
        setOptions: function(options) {
            this.options = this.mergeOptions(options);
        },

        /**
         * Merges the given options with the default options.
         *
         * @param {Array} options
         * @returns {Array}
         */
        mergeOptions: function(options) {
            return $.extend(true, {}, this.defaults, this.options, options);
        },

        /**
         * Checks whether a select all checkbox is present.
         *
         * @returns {Boolean}
         */
        hasSelectAll: function() {
            return $('li.multiselect-all', this.$ul).length > 0;
        },

        /**
         * Update opt groups.
         */
        updateOptGroups: function() {
            var $groups = $('li.multiselect-group', this.$ul)
            var selectedClass = this.options.selectedClass;

            $groups.each(function() {
                var $options = $(this).nextUntil('li.multiselect-group')
                    .not('.multiselect-filter-hidden')
                    .not('.disabled');

                var checked = true;
                $options.each(function() {
                    var $input = $('input', this);

                    if (!$input.prop('checked')) {
                        checked = false;
                    }
                });

                if (selectedClass) {
                    if (checked) {
                        $(this).addClass(selectedClass);
                    }
                    else {
                        $(this).removeClass(selectedClass);
                    }
                }

                $('input', this).prop('checked', checked);
            });
        },

        /**
         * Updates the select all checkbox based on the currently displayed and selected checkboxes.
         */
        updateSelectAll: function(notTriggerOnSelectAll) {
            if (this.hasSelectAll()) {
                var allBoxes = $("li:not(.multiselect-item):not(.multiselect-filter-hidden):not(.multiselect-group):not(.disabled) input:enabled", this.$ul);
                var allBoxesLength = allBoxes.length;
                var checkedBoxesLength = allBoxes.filter(":checked").length;
                var selectAllLi  = $("li.multiselect-all", this.$ul);
                var selectAllInput = selectAllLi.find("input");

                if (checkedBoxesLength > 0 && checkedBoxesLength === allBoxesLength) {
                    selectAllInput.prop("checked", true);
                    selectAllLi.addClass(this.options.selectedClass);
                }
                else {
                    selectAllInput.prop("checked", false);
                    selectAllLi.removeClass(this.options.selectedClass);
                }
            }
        },

        /**
         * Update the button text and its title based on the currently selected options.
         */
        updateButtonText: function() {
            var options = this.getSelected();

            // First update the displayed button text.
            if (this.options.enableHTML) {
                $('.multiselect .multiselect-selected-text', this.$container).html(this.options.buttonText(options, this.$select));
            }
            else {
                $('.multiselect .multiselect-selected-text', this.$container).text(this.options.buttonText(options, this.$select));
            }

            // Now update the title attribute of the button.
            $('.multiselect', this.$container).attr('title', this.options.buttonTitle(options, this.$select));
        },

        /**
         * Get all selected options.
         *
         * @returns {jQUery}
         */
        getSelected: function() {
            return $('option', this.$select).filter(":selected");
        },

        /**
         * Gets a select option by its value.
         *
         * @param {String} value
         * @returns {jQuery}
         */
        getOptionByValue: function (value) {

            var options = $('option', this.$select);
            var valueToCompare = value.toString();

            for (var i = 0; i < options.length; i = i + 1) {
                var option = options[i];
                if (option.value === valueToCompare) {
                    return $(option);
                }
            }
        },

        /**
         * Get the input (radio/checkbox) by its value.
         *
         * @param {String} value
         * @returns {jQuery}
         */
        getInputByValue: function (value) {

            var checkboxes = $('li input:not(.multiselect-search)', this.$ul);
            var valueToCompare = value.toString();

            for (var i = 0; i < checkboxes.length; i = i + 1) {
                var checkbox = checkboxes[i];
                if (checkbox.value === valueToCompare) {
                    return $(checkbox);
                }
            }
        },

        /**
         * Used for knockout integration.
         */
        updateOriginalOptions: function() {
            this.originalOptions = this.$select.clone()[0].options;
        },

        asyncFunction: function(callback, timeout, self) {
            var args = Array.prototype.slice.call(arguments, 3);
            return setTimeout(function() {
                callback.apply(self || window, args);
            }, timeout);
        },

        setAllSelectedText: function(allSelectedText) {
            this.options.allSelectedText = allSelectedText;
            this.updateButtonText();
        }
    };

    $.fn.multiselect = function(option, parameter, extraOptions) {
        return this.each(function() {
            var data = $(this).data('multiselect');
            var options = typeof option === 'object' && option;

            // Initialize the multiselect.
            if (!data) {
                data = new Multiselect(this, options);
                $(this).data('multiselect', data);
            }

            // Call multiselect method.
            if (typeof option === 'string') {
                data[option](parameter, extraOptions);

                if (option === 'destroy') {
                    $(this).data('multiselect', false);
                }
            }
        });
    };

    $.fn.multiselect.Constructor = Multiselect;

    $(function() {
        $("select[data-role=multiselect]").multiselect();
    });

}(window.jQuery);
var process = process || {env: {NODE_ENV: "development"}};
/*!
 * Chart.js
 * http://chartjs.org/
 * Version: 2.3.0
 *
 * Copyright 2016 Nick Downie
 * Released under the MIT license
 * https://github.com/chartjs/Chart.js/blob/master/LICENSE.md
 */
(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.Chart = f()}})(function(){var define,module,exports;return (function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
    /* MIT license */
    var colorNames = require(5);

    module.exports = {
        getRgba: getRgba,
        getHsla: getHsla,
        getRgb: getRgb,
        getHsl: getHsl,
        getHwb: getHwb,
        getAlpha: getAlpha,

        hexString: hexString,
        rgbString: rgbString,
        rgbaString: rgbaString,
        percentString: percentString,
        percentaString: percentaString,
        hslString: hslString,
        hslaString: hslaString,
        hwbString: hwbString,
        keyword: keyword
    }

    function getRgba(string) {
        if (!string) {
            return;
        }
        var abbr =  /^#([a-fA-F0-9]{3})$/,
            hex =  /^#([a-fA-F0-9]{6})$/,
            rgba = /^rgba?\(\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/,
            per = /^rgba?\(\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/,
            keyword = /(\w+)/;

        var rgb = [0, 0, 0],
            a = 1,
            match = string.match(abbr);
        if (match) {
            match = match[1];
            for (var i = 0; i < rgb.length; i++) {
                rgb[i] = parseInt(match[i] + match[i], 16);
            }
        }
        else if (match = string.match(hex)) {
            match = match[1];
            for (var i = 0; i < rgb.length; i++) {
                rgb[i] = parseInt(match.slice(i * 2, i * 2 + 2), 16);
            }
        }
        else if (match = string.match(rgba)) {
            for (var i = 0; i < rgb.length; i++) {
                rgb[i] = parseInt(match[i + 1]);
            }
            a = parseFloat(match[4]);
        }
        else if (match = string.match(per)) {
            for (var i = 0; i < rgb.length; i++) {
                rgb[i] = Math.round(parseFloat(match[i + 1]) * 2.55);
            }
            a = parseFloat(match[4]);
        }
        else if (match = string.match(keyword)) {
            if (match[1] == "transparent") {
                return [0, 0, 0, 0];
            }
            rgb = colorNames[match[1]];
            if (!rgb) {
                return;
            }
        }

        for (var i = 0; i < rgb.length; i++) {
            rgb[i] = scale(rgb[i], 0, 255);
        }
        if (!a && a != 0) {
            a = 1;
        }
        else {
            a = scale(a, 0, 1);
        }
        rgb[3] = a;
        return rgb;
    }

    function getHsla(string) {
        if (!string) {
            return;
        }
        var hsl = /^hsla?\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/;
        var match = string.match(hsl);
        if (match) {
            var alpha = parseFloat(match[4]);
            var h = scale(parseInt(match[1]), 0, 360),
                s = scale(parseFloat(match[2]), 0, 100),
                l = scale(parseFloat(match[3]), 0, 100),
                a = scale(isNaN(alpha) ? 1 : alpha, 0, 1);
            return [h, s, l, a];
        }
    }

    function getHwb(string) {
        if (!string) {
            return;
        }
        var hwb = /^hwb\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/;
        var match = string.match(hwb);
        if (match) {
            var alpha = parseFloat(match[4]);
            var h = scale(parseInt(match[1]), 0, 360),
                w = scale(parseFloat(match[2]), 0, 100),
                b = scale(parseFloat(match[3]), 0, 100),
                a = scale(isNaN(alpha) ? 1 : alpha, 0, 1);
            return [h, w, b, a];
        }
    }

    function getRgb(string) {
        var rgba = getRgba(string);
        return rgba && rgba.slice(0, 3);
    }

    function getHsl(string) {
        var hsla = getHsla(string);
        return hsla && hsla.slice(0, 3);
    }

    function getAlpha(string) {
        var vals = getRgba(string);
        if (vals) {
            return vals[3];
        }
        else if (vals = getHsla(string)) {
            return vals[3];
        }
        else if (vals = getHwb(string)) {
            return vals[3];
        }
    }

// generators
    function hexString(rgb) {
        return "#" + hexDouble(rgb[0]) + hexDouble(rgb[1])
            + hexDouble(rgb[2]);
    }

    function rgbString(rgba, alpha) {
        if (alpha < 1 || (rgba[3] && rgba[3] < 1)) {
            return rgbaString(rgba, alpha);
        }
        return "rgb(" + rgba[0] + ", " + rgba[1] + ", " + rgba[2] + ")";
    }

    function rgbaString(rgba, alpha) {
        if (alpha === undefined) {
            alpha = (rgba[3] !== undefined ? rgba[3] : 1);
        }
        return "rgba(" + rgba[0] + ", " + rgba[1] + ", " + rgba[2]
            + ", " + alpha + ")";
    }

    function percentString(rgba, alpha) {
        if (alpha < 1 || (rgba[3] && rgba[3] < 1)) {
            return percentaString(rgba, alpha);
        }
        var r = Math.round(rgba[0]/255 * 100),
            g = Math.round(rgba[1]/255 * 100),
            b = Math.round(rgba[2]/255 * 100);

        return "rgb(" + r + "%, " + g + "%, " + b + "%)";
    }

    function percentaString(rgba, alpha) {
        var r = Math.round(rgba[0]/255 * 100),
            g = Math.round(rgba[1]/255 * 100),
            b = Math.round(rgba[2]/255 * 100);
        return "rgba(" + r + "%, " + g + "%, " + b + "%, " + (alpha || rgba[3] || 1) + ")";
    }

    function hslString(hsla, alpha) {
        if (alpha < 1 || (hsla[3] && hsla[3] < 1)) {
            return hslaString(hsla, alpha);
        }
        return "hsl(" + hsla[0] + ", " + hsla[1] + "%, " + hsla[2] + "%)";
    }

    function hslaString(hsla, alpha) {
        if (alpha === undefined) {
            alpha = (hsla[3] !== undefined ? hsla[3] : 1);
        }
        return "hsla(" + hsla[0] + ", " + hsla[1] + "%, " + hsla[2] + "%, "
            + alpha + ")";
    }

// hwb is a bit different than rgb(a) & hsl(a) since there is no alpha specific syntax
// (hwb have alpha optional & 1 is default value)
    function hwbString(hwb, alpha) {
        if (alpha === undefined) {
            alpha = (hwb[3] !== undefined ? hwb[3] : 1);
        }
        return "hwb(" + hwb[0] + ", " + hwb[1] + "%, " + hwb[2] + "%"
            + (alpha !== undefined && alpha !== 1 ? ", " + alpha : "") + ")";
    }

    function keyword(rgb) {
        return reverseNames[rgb.slice(0, 3)];
    }

// helpers
    function scale(num, min, max) {
        return Math.min(Math.max(min, num), max);
    }

    function hexDouble(num) {
        var str = num.toString(16).toUpperCase();
        return (str.length < 2) ? "0" + str : str;
    }


//create a list of reverse color names
    var reverseNames = {};
    for (var name in colorNames) {
        reverseNames[colorNames[name]] = name;
    }

},{"5":5}],2:[function(require,module,exports){
    /* MIT license */
    var convert = require(4);
    var string = require(1);

    var Color = function (obj) {
        if (obj instanceof Color) {
            return obj;
        }
        if (!(this instanceof Color)) {
            return new Color(obj);
        }

        this.values = {
            rgb: [0, 0, 0],
            hsl: [0, 0, 0],
            hsv: [0, 0, 0],
            hwb: [0, 0, 0],
            cmyk: [0, 0, 0, 0],
            alpha: 1
        };

        // parse Color() argument
        var vals;
        if (typeof obj === 'string') {
            vals = string.getRgba(obj);
            if (vals) {
                this.setValues('rgb', vals);
            } else if (vals = string.getHsla(obj)) {
                this.setValues('hsl', vals);
            } else if (vals = string.getHwb(obj)) {
                this.setValues('hwb', vals);
            } else {
                throw new Error('Unable to parse color from string "' + obj + '"');
            }
        } else if (typeof obj === 'object') {
            vals = obj;
            if (vals.r !== undefined || vals.red !== undefined) {
                this.setValues('rgb', vals);
            } else if (vals.l !== undefined || vals.lightness !== undefined) {
                this.setValues('hsl', vals);
            } else if (vals.v !== undefined || vals.value !== undefined) {
                this.setValues('hsv', vals);
            } else if (vals.w !== undefined || vals.whiteness !== undefined) {
                this.setValues('hwb', vals);
            } else if (vals.c !== undefined || vals.cyan !== undefined) {
                this.setValues('cmyk', vals);
            } else {
                throw new Error('Unable to parse color from object ' + JSON.stringify(obj));
            }
        }
    };

    Color.prototype = {
        rgb: function () {
            return this.setSpace('rgb', arguments);
        },
        hsl: function () {
            return this.setSpace('hsl', arguments);
        },
        hsv: function () {
            return this.setSpace('hsv', arguments);
        },
        hwb: function () {
            return this.setSpace('hwb', arguments);
        },
        cmyk: function () {
            return this.setSpace('cmyk', arguments);
        },

        rgbArray: function () {
            return this.values.rgb;
        },
        hslArray: function () {
            return this.values.hsl;
        },
        hsvArray: function () {
            return this.values.hsv;
        },
        hwbArray: function () {
            var values = this.values;
            if (values.alpha !== 1) {
                return values.hwb.concat([values.alpha]);
            }
            return values.hwb;
        },
        cmykArray: function () {
            return this.values.cmyk;
        },
        rgbaArray: function () {
            var values = this.values;
            return values.rgb.concat([values.alpha]);
        },
        hslaArray: function () {
            var values = this.values;
            return values.hsl.concat([values.alpha]);
        },
        alpha: function (val) {
            if (val === undefined) {
                return this.values.alpha;
            }
            this.setValues('alpha', val);
            return this;
        },

        red: function (val) {
            return this.setChannel('rgb', 0, val);
        },
        green: function (val) {
            return this.setChannel('rgb', 1, val);
        },
        blue: function (val) {
            return this.setChannel('rgb', 2, val);
        },
        hue: function (val) {
            if (val) {
                val %= 360;
                val = val < 0 ? 360 + val : val;
            }
            return this.setChannel('hsl', 0, val);
        },
        saturation: function (val) {
            return this.setChannel('hsl', 1, val);
        },
        lightness: function (val) {
            return this.setChannel('hsl', 2, val);
        },
        saturationv: function (val) {
            return this.setChannel('hsv', 1, val);
        },
        whiteness: function (val) {
            return this.setChannel('hwb', 1, val);
        },
        blackness: function (val) {
            return this.setChannel('hwb', 2, val);
        },
        value: function (val) {
            return this.setChannel('hsv', 2, val);
        },
        cyan: function (val) {
            return this.setChannel('cmyk', 0, val);
        },
        magenta: function (val) {
            return this.setChannel('cmyk', 1, val);
        },
        yellow: function (val) {
            return this.setChannel('cmyk', 2, val);
        },
        black: function (val) {
            return this.setChannel('cmyk', 3, val);
        },

        hexString: function () {
            return string.hexString(this.values.rgb);
        },
        rgbString: function () {
            return string.rgbString(this.values.rgb, this.values.alpha);
        },
        rgbaString: function () {
            return string.rgbaString(this.values.rgb, this.values.alpha);
        },
        percentString: function () {
            return string.percentString(this.values.rgb, this.values.alpha);
        },
        hslString: function () {
            return string.hslString(this.values.hsl, this.values.alpha);
        },
        hslaString: function () {
            return string.hslaString(this.values.hsl, this.values.alpha);
        },
        hwbString: function () {
            return string.hwbString(this.values.hwb, this.values.alpha);
        },
        keyword: function () {
            return string.keyword(this.values.rgb, this.values.alpha);
        },

        rgbNumber: function () {
            var rgb = this.values.rgb;
            return (rgb[0] << 16) | (rgb[1] << 8) | rgb[2];
        },

        luminosity: function () {
            // http://www.w3.org/TR/WCAG20/#relativeluminancedef
            var rgb = this.values.rgb;
            var lum = [];
            for (var i = 0; i < rgb.length; i++) {
                var chan = rgb[i] / 255;
                lum[i] = (chan <= 0.03928) ? chan / 12.92 : Math.pow(((chan + 0.055) / 1.055), 2.4);
            }
            return 0.2126 * lum[0] + 0.7152 * lum[1] + 0.0722 * lum[2];
        },

        contrast: function (color2) {
            // http://www.w3.org/TR/WCAG20/#contrast-ratiodef
            var lum1 = this.luminosity();
            var lum2 = color2.luminosity();
            if (lum1 > lum2) {
                return (lum1 + 0.05) / (lum2 + 0.05);
            }
            return (lum2 + 0.05) / (lum1 + 0.05);
        },

        level: function (color2) {
            var contrastRatio = this.contrast(color2);
            if (contrastRatio >= 7.1) {
                return 'AAA';
            }

            return (contrastRatio >= 4.5) ? 'AA' : '';
        },

        dark: function () {
            // YIQ equation from http://24ways.org/2010/calculating-color-contrast
            var rgb = this.values.rgb;
            var yiq = (rgb[0] * 299 + rgb[1] * 587 + rgb[2] * 114) / 1000;
            return yiq < 128;
        },

        light: function () {
            return !this.dark();
        },

        negate: function () {
            var rgb = [];
            for (var i = 0; i < 3; i++) {
                rgb[i] = 255 - this.values.rgb[i];
            }
            this.setValues('rgb', rgb);
            return this;
        },

        lighten: function (ratio) {
            var hsl = this.values.hsl;
            hsl[2] += hsl[2] * ratio;
            this.setValues('hsl', hsl);
            return this;
        },

        darken: function (ratio) {
            var hsl = this.values.hsl;
            hsl[2] -= hsl[2] * ratio;
            this.setValues('hsl', hsl);
            return this;
        },

        saturate: function (ratio) {
            var hsl = this.values.hsl;
            hsl[1] += hsl[1] * ratio;
            this.setValues('hsl', hsl);
            return this;
        },

        desaturate: function (ratio) {
            var hsl = this.values.hsl;
            hsl[1] -= hsl[1] * ratio;
            this.setValues('hsl', hsl);
            return this;
        },

        whiten: function (ratio) {
            var hwb = this.values.hwb;
            hwb[1] += hwb[1] * ratio;
            this.setValues('hwb', hwb);
            return this;
        },

        blacken: function (ratio) {
            var hwb = this.values.hwb;
            hwb[2] += hwb[2] * ratio;
            this.setValues('hwb', hwb);
            return this;
        },

        greyscale: function () {
            var rgb = this.values.rgb;
            // http://en.wikipedia.org/wiki/Grayscale#Converting_color_to_grayscale
            var val = rgb[0] * 0.3 + rgb[1] * 0.59 + rgb[2] * 0.11;
            this.setValues('rgb', [val, val, val]);
            return this;
        },

        clearer: function (ratio) {
            var alpha = this.values.alpha;
            this.setValues('alpha', alpha - (alpha * ratio));
            return this;
        },

        opaquer: function (ratio) {
            var alpha = this.values.alpha;
            this.setValues('alpha', alpha + (alpha * ratio));
            return this;
        },

        rotate: function (degrees) {
            var hsl = this.values.hsl;
            var hue = (hsl[0] + degrees) % 360;
            hsl[0] = hue < 0 ? 360 + hue : hue;
            this.setValues('hsl', hsl);
            return this;
        },

        /**
         * Ported from sass implementation in C
         * https://github.com/sass/libsass/blob/0e6b4a2850092356aa3ece07c6b249f0221caced/functions.cpp#L209
         */
        mix: function (mixinColor, weight) {
            var color1 = this;
            var color2 = mixinColor;
            var p = weight === undefined ? 0.5 : weight;

            var w = 2 * p - 1;
            var a = color1.alpha() - color2.alpha();

            var w1 = (((w * a === -1) ? w : (w + a) / (1 + w * a)) + 1) / 2.0;
            var w2 = 1 - w1;

            return this
                .rgb(
                    w1 * color1.red() + w2 * color2.red(),
                    w1 * color1.green() + w2 * color2.green(),
                    w1 * color1.blue() + w2 * color2.blue()
                )
                .alpha(color1.alpha() * p + color2.alpha() * (1 - p));
        },

        toJSON: function () {
            return this.rgb();
        },

        clone: function () {
            // NOTE(SB): using node-clone creates a dependency to Buffer when using browserify,
            // making the final build way to big to embed in Chart.js. So let's do it manually,
            // assuming that values to clone are 1 dimension arrays containing only numbers,
            // except 'alpha' which is a number.
            var result = new Color();
            var source = this.values;
            var target = result.values;
            var value, type;

            for (var prop in source) {
                if (source.hasOwnProperty(prop)) {
                    value = source[prop];
                    type = ({}).toString.call(value);
                    if (type === '[object Array]') {
                        target[prop] = value.slice(0);
                    } else if (type === '[object Number]') {
                        target[prop] = value;
                    } else {
                        console.error('unexpected color value:', value);
                    }
                }
            }

            return result;
        }
    };

    Color.prototype.spaces = {
        rgb: ['red', 'green', 'blue'],
        hsl: ['hue', 'saturation', 'lightness'],
        hsv: ['hue', 'saturation', 'value'],
        hwb: ['hue', 'whiteness', 'blackness'],
        cmyk: ['cyan', 'magenta', 'yellow', 'black']
    };

    Color.prototype.maxes = {
        rgb: [255, 255, 255],
        hsl: [360, 100, 100],
        hsv: [360, 100, 100],
        hwb: [360, 100, 100],
        cmyk: [100, 100, 100, 100]
    };

    Color.prototype.getValues = function (space) {
        var values = this.values;
        var vals = {};

        for (var i = 0; i < space.length; i++) {
            vals[space.charAt(i)] = values[space][i];
        }

        if (values.alpha !== 1) {
            vals.a = values.alpha;
        }

        // {r: 255, g: 255, b: 255, a: 0.4}
        return vals;
    };

    Color.prototype.setValues = function (space, vals) {
        var values = this.values;
        var spaces = this.spaces;
        var maxes = this.maxes;
        var alpha = 1;
        var i;

        if (space === 'alpha') {
            alpha = vals;
        } else if (vals.length) {
            // [10, 10, 10]
            values[space] = vals.slice(0, space.length);
            alpha = vals[space.length];
        } else if (vals[space.charAt(0)] !== undefined) {
            // {r: 10, g: 10, b: 10}
            for (i = 0; i < space.length; i++) {
                values[space][i] = vals[space.charAt(i)];
            }

            alpha = vals.a;
        } else if (vals[spaces[space][0]] !== undefined) {
            // {red: 10, green: 10, blue: 10}
            var chans = spaces[space];

            for (i = 0; i < space.length; i++) {
                values[space][i] = vals[chans[i]];
            }

            alpha = vals.alpha;
        }

        values.alpha = Math.max(0, Math.min(1, (alpha === undefined ? values.alpha : alpha)));

        if (space === 'alpha') {
            return false;
        }

        var capped;

        // cap values of the space prior converting all values
        for (i = 0; i < space.length; i++) {
            capped = Math.max(0, Math.min(maxes[space][i], values[space][i]));
            values[space][i] = Math.round(capped);
        }

        // convert to all the other color spaces
        for (var sname in spaces) {
            if (sname !== space) {
                values[sname] = convert[space][sname](values[space]);
            }
        }

        return true;
    };

    Color.prototype.setSpace = function (space, args) {
        var vals = args[0];

        if (vals === undefined) {
            // color.rgb()
            return this.getValues(space);
        }

        // color.rgb(10, 10, 10)
        if (typeof vals === 'number') {
            vals = Array.prototype.slice.call(args);
        }

        this.setValues(space, vals);
        return this;
    };

    Color.prototype.setChannel = function (space, index, val) {
        var svalues = this.values[space];
        if (val === undefined) {
            // color.red()
            return svalues[index];
        } else if (val === svalues[index]) {
            // color.red(color.red())
            return this;
        }

        // color.red(100)
        svalues[index] = val;
        this.setValues(space, svalues);

        return this;
    };

    if (typeof window !== 'undefined') {
        window.Color = Color;
    }

    module.exports = Color;

},{"1":1,"4":4}],3:[function(require,module,exports){
    /* MIT license */

    module.exports = {
        rgb2hsl: rgb2hsl,
        rgb2hsv: rgb2hsv,
        rgb2hwb: rgb2hwb,
        rgb2cmyk: rgb2cmyk,
        rgb2keyword: rgb2keyword,
        rgb2xyz: rgb2xyz,
        rgb2lab: rgb2lab,
        rgb2lch: rgb2lch,

        hsl2rgb: hsl2rgb,
        hsl2hsv: hsl2hsv,
        hsl2hwb: hsl2hwb,
        hsl2cmyk: hsl2cmyk,
        hsl2keyword: hsl2keyword,

        hsv2rgb: hsv2rgb,
        hsv2hsl: hsv2hsl,
        hsv2hwb: hsv2hwb,
        hsv2cmyk: hsv2cmyk,
        hsv2keyword: hsv2keyword,

        hwb2rgb: hwb2rgb,
        hwb2hsl: hwb2hsl,
        hwb2hsv: hwb2hsv,
        hwb2cmyk: hwb2cmyk,
        hwb2keyword: hwb2keyword,

        cmyk2rgb: cmyk2rgb,
        cmyk2hsl: cmyk2hsl,
        cmyk2hsv: cmyk2hsv,
        cmyk2hwb: cmyk2hwb,
        cmyk2keyword: cmyk2keyword,

        keyword2rgb: keyword2rgb,
        keyword2hsl: keyword2hsl,
        keyword2hsv: keyword2hsv,
        keyword2hwb: keyword2hwb,
        keyword2cmyk: keyword2cmyk,
        keyword2lab: keyword2lab,
        keyword2xyz: keyword2xyz,

        xyz2rgb: xyz2rgb,
        xyz2lab: xyz2lab,
        xyz2lch: xyz2lch,

        lab2xyz: lab2xyz,
        lab2rgb: lab2rgb,
        lab2lch: lab2lch,

        lch2lab: lch2lab,
        lch2xyz: lch2xyz,
        lch2rgb: lch2rgb
    }


    function rgb2hsl(rgb) {
        var r = rgb[0]/255,
            g = rgb[1]/255,
            b = rgb[2]/255,
            min = Math.min(r, g, b),
            max = Math.max(r, g, b),
            delta = max - min,
            h, s, l;

        if (max == min)
            h = 0;
        else if (r == max)
            h = (g - b) / delta;
        else if (g == max)
            h = 2 + (b - r) / delta;
        else if (b == max)
            h = 4 + (r - g)/ delta;

        h = Math.min(h * 60, 360);

        if (h < 0)
            h += 360;

        l = (min + max) / 2;

        if (max == min)
            s = 0;
        else if (l <= 0.5)
            s = delta / (max + min);
        else
            s = delta / (2 - max - min);

        return [h, s * 100, l * 100];
    }

    function rgb2hsv(rgb) {
        var r = rgb[0],
            g = rgb[1],
            b = rgb[2],
            min = Math.min(r, g, b),
            max = Math.max(r, g, b),
            delta = max - min,
            h, s, v;

        if (max == 0)
            s = 0;
        else
            s = (delta/max * 1000)/10;

        if (max == min)
            h = 0;
        else if (r == max)
            h = (g - b) / delta;
        else if (g == max)
            h = 2 + (b - r) / delta;
        else if (b == max)
            h = 4 + (r - g) / delta;

        h = Math.min(h * 60, 360);

        if (h < 0)
            h += 360;

        v = ((max / 255) * 1000) / 10;

        return [h, s, v];
    }

    function rgb2hwb(rgb) {
        var r = rgb[0],
            g = rgb[1],
            b = rgb[2],
            h = rgb2hsl(rgb)[0],
            w = 1/255 * Math.min(r, Math.min(g, b)),
            b = 1 - 1/255 * Math.max(r, Math.max(g, b));

        return [h, w * 100, b * 100];
    }

    function rgb2cmyk(rgb) {
        var r = rgb[0] / 255,
            g = rgb[1] / 255,
            b = rgb[2] / 255,
            c, m, y, k;

        k = Math.min(1 - r, 1 - g, 1 - b);
        c = (1 - r - k) / (1 - k) || 0;
        m = (1 - g - k) / (1 - k) || 0;
        y = (1 - b - k) / (1 - k) || 0;
        return [c * 100, m * 100, y * 100, k * 100];
    }

    function rgb2keyword(rgb) {
        return reverseKeywords[JSON.stringify(rgb)];
    }

    function rgb2xyz(rgb) {
        var r = rgb[0] / 255,
            g = rgb[1] / 255,
            b = rgb[2] / 255;

        // assume sRGB
        r = r > 0.04045 ? Math.pow(((r + 0.055) / 1.055), 2.4) : (r / 12.92);
        g = g > 0.04045 ? Math.pow(((g + 0.055) / 1.055), 2.4) : (g / 12.92);
        b = b > 0.04045 ? Math.pow(((b + 0.055) / 1.055), 2.4) : (b / 12.92);

        var x = (r * 0.4124) + (g * 0.3576) + (b * 0.1805);
        var y = (r * 0.2126) + (g * 0.7152) + (b * 0.0722);
        var z = (r * 0.0193) + (g * 0.1192) + (b * 0.9505);

        return [x * 100, y *100, z * 100];
    }

    function rgb2lab(rgb) {
        var xyz = rgb2xyz(rgb),
            x = xyz[0],
            y = xyz[1],
            z = xyz[2],
            l, a, b;

        x /= 95.047;
        y /= 100;
        z /= 108.883;

        x = x > 0.008856 ? Math.pow(x, 1/3) : (7.787 * x) + (16 / 116);
        y = y > 0.008856 ? Math.pow(y, 1/3) : (7.787 * y) + (16 / 116);
        z = z > 0.008856 ? Math.pow(z, 1/3) : (7.787 * z) + (16 / 116);

        l = (116 * y) - 16;
        a = 500 * (x - y);
        b = 200 * (y - z);

        return [l, a, b];
    }

    function rgb2lch(args) {
        return lab2lch(rgb2lab(args));
    }

    function hsl2rgb(hsl) {
        var h = hsl[0] / 360,
            s = hsl[1] / 100,
            l = hsl[2] / 100,
            t1, t2, t3, rgb, val;

        if (s == 0) {
            val = l * 255;
            return [val, val, val];
        }

        if (l < 0.5)
            t2 = l * (1 + s);
        else
            t2 = l + s - l * s;
        t1 = 2 * l - t2;

        rgb = [0, 0, 0];
        for (var i = 0; i < 3; i++) {
            t3 = h + 1 / 3 * - (i - 1);
            t3 < 0 && t3++;
            t3 > 1 && t3--;

            if (6 * t3 < 1)
                val = t1 + (t2 - t1) * 6 * t3;
            else if (2 * t3 < 1)
                val = t2;
            else if (3 * t3 < 2)
                val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
            else
                val = t1;

            rgb[i] = val * 255;
        }

        return rgb;
    }

    function hsl2hsv(hsl) {
        var h = hsl[0],
            s = hsl[1] / 100,
            l = hsl[2] / 100,
            sv, v;

        if(l === 0) {
            // no need to do calc on black
            // also avoids divide by 0 error
            return [0, 0, 0];
        }

        l *= 2;
        s *= (l <= 1) ? l : 2 - l;
        v = (l + s) / 2;
        sv = (2 * s) / (l + s);
        return [h, sv * 100, v * 100];
    }

    function hsl2hwb(args) {
        return rgb2hwb(hsl2rgb(args));
    }

    function hsl2cmyk(args) {
        return rgb2cmyk(hsl2rgb(args));
    }

    function hsl2keyword(args) {
        return rgb2keyword(hsl2rgb(args));
    }


    function hsv2rgb(hsv) {
        var h = hsv[0] / 60,
            s = hsv[1] / 100,
            v = hsv[2] / 100,
            hi = Math.floor(h) % 6;

        var f = h - Math.floor(h),
            p = 255 * v * (1 - s),
            q = 255 * v * (1 - (s * f)),
            t = 255 * v * (1 - (s * (1 - f))),
            v = 255 * v;

        switch(hi) {
            case 0:
                return [v, t, p];
            case 1:
                return [q, v, p];
            case 2:
                return [p, v, t];
            case 3:
                return [p, q, v];
            case 4:
                return [t, p, v];
            case 5:
                return [v, p, q];
        }
    }

    function hsv2hsl(hsv) {
        var h = hsv[0],
            s = hsv[1] / 100,
            v = hsv[2] / 100,
            sl, l;

        l = (2 - s) * v;
        sl = s * v;
        sl /= (l <= 1) ? l : 2 - l;
        sl = sl || 0;
        l /= 2;
        return [h, sl * 100, l * 100];
    }

    function hsv2hwb(args) {
        return rgb2hwb(hsv2rgb(args))
    }

    function hsv2cmyk(args) {
        return rgb2cmyk(hsv2rgb(args));
    }

    function hsv2keyword(args) {
        return rgb2keyword(hsv2rgb(args));
    }

// http://dev.w3.org/csswg/css-color/#hwb-to-rgb
    function hwb2rgb(hwb) {
        var h = hwb[0] / 360,
            wh = hwb[1] / 100,
            bl = hwb[2] / 100,
            ratio = wh + bl,
            i, v, f, n;

        // wh + bl cant be > 1
        if (ratio > 1) {
            wh /= ratio;
            bl /= ratio;
        }

        i = Math.floor(6 * h);
        v = 1 - bl;
        f = 6 * h - i;
        if ((i & 0x01) != 0) {
            f = 1 - f;
        }
        n = wh + f * (v - wh);  // linear interpolation

        switch (i) {
            default:
            case 6:
            case 0: r = v; g = n; b = wh; break;
            case 1: r = n; g = v; b = wh; break;
            case 2: r = wh; g = v; b = n; break;
            case 3: r = wh; g = n; b = v; break;
            case 4: r = n; g = wh; b = v; break;
            case 5: r = v; g = wh; b = n; break;
        }

        return [r * 255, g * 255, b * 255];
    }

    function hwb2hsl(args) {
        return rgb2hsl(hwb2rgb(args));
    }

    function hwb2hsv(args) {
        return rgb2hsv(hwb2rgb(args));
    }

    function hwb2cmyk(args) {
        return rgb2cmyk(hwb2rgb(args));
    }

    function hwb2keyword(args) {
        return rgb2keyword(hwb2rgb(args));
    }

    function cmyk2rgb(cmyk) {
        var c = cmyk[0] / 100,
            m = cmyk[1] / 100,
            y = cmyk[2] / 100,
            k = cmyk[3] / 100,
            r, g, b;

        r = 1 - Math.min(1, c * (1 - k) + k);
        g = 1 - Math.min(1, m * (1 - k) + k);
        b = 1 - Math.min(1, y * (1 - k) + k);
        return [r * 255, g * 255, b * 255];
    }

    function cmyk2hsl(args) {
        return rgb2hsl(cmyk2rgb(args));
    }

    function cmyk2hsv(args) {
        return rgb2hsv(cmyk2rgb(args));
    }

    function cmyk2hwb(args) {
        return rgb2hwb(cmyk2rgb(args));
    }

    function cmyk2keyword(args) {
        return rgb2keyword(cmyk2rgb(args));
    }


    function xyz2rgb(xyz) {
        var x = xyz[0] / 100,
            y = xyz[1] / 100,
            z = xyz[2] / 100,
            r, g, b;

        r = (x * 3.2406) + (y * -1.5372) + (z * -0.4986);
        g = (x * -0.9689) + (y * 1.8758) + (z * 0.0415);
        b = (x * 0.0557) + (y * -0.2040) + (z * 1.0570);

        // assume sRGB
        r = r > 0.0031308 ? ((1.055 * Math.pow(r, 1.0 / 2.4)) - 0.055)
            : r = (r * 12.92);

        g = g > 0.0031308 ? ((1.055 * Math.pow(g, 1.0 / 2.4)) - 0.055)
            : g = (g * 12.92);

        b = b > 0.0031308 ? ((1.055 * Math.pow(b, 1.0 / 2.4)) - 0.055)
            : b = (b * 12.92);

        r = Math.min(Math.max(0, r), 1);
        g = Math.min(Math.max(0, g), 1);
        b = Math.min(Math.max(0, b), 1);

        return [r * 255, g * 255, b * 255];
    }

    function xyz2lab(xyz) {
        var x = xyz[0],
            y = xyz[1],
            z = xyz[2],
            l, a, b;

        x /= 95.047;
        y /= 100;
        z /= 108.883;

        x = x > 0.008856 ? Math.pow(x, 1/3) : (7.787 * x) + (16 / 116);
        y = y > 0.008856 ? Math.pow(y, 1/3) : (7.787 * y) + (16 / 116);
        z = z > 0.008856 ? Math.pow(z, 1/3) : (7.787 * z) + (16 / 116);

        l = (116 * y) - 16;
        a = 500 * (x - y);
        b = 200 * (y - z);

        return [l, a, b];
    }

    function xyz2lch(args) {
        return lab2lch(xyz2lab(args));
    }

    function lab2xyz(lab) {
        var l = lab[0],
            a = lab[1],
            b = lab[2],
            x, y, z, y2;

        if (l <= 8) {
            y = (l * 100) / 903.3;
            y2 = (7.787 * (y / 100)) + (16 / 116);
        } else {
            y = 100 * Math.pow((l + 16) / 116, 3);
            y2 = Math.pow(y / 100, 1/3);
        }

        x = x / 95.047 <= 0.008856 ? x = (95.047 * ((a / 500) + y2 - (16 / 116))) / 7.787 : 95.047 * Math.pow((a / 500) + y2, 3);

        z = z / 108.883 <= 0.008859 ? z = (108.883 * (y2 - (b / 200) - (16 / 116))) / 7.787 : 108.883 * Math.pow(y2 - (b / 200), 3);

        return [x, y, z];
    }

    function lab2lch(lab) {
        var l = lab[0],
            a = lab[1],
            b = lab[2],
            hr, h, c;

        hr = Math.atan2(b, a);
        h = hr * 360 / 2 / Math.PI;
        if (h < 0) {
            h += 360;
        }
        c = Math.sqrt(a * a + b * b);
        return [l, c, h];
    }

    function lab2rgb(args) {
        return xyz2rgb(lab2xyz(args));
    }

    function lch2lab(lch) {
        var l = lch[0],
            c = lch[1],
            h = lch[2],
            a, b, hr;

        hr = h / 360 * 2 * Math.PI;
        a = c * Math.cos(hr);
        b = c * Math.sin(hr);
        return [l, a, b];
    }

    function lch2xyz(args) {
        return lab2xyz(lch2lab(args));
    }

    function lch2rgb(args) {
        return lab2rgb(lch2lab(args));
    }

    function keyword2rgb(keyword) {
        return cssKeywords[keyword];
    }

    function keyword2hsl(args) {
        return rgb2hsl(keyword2rgb(args));
    }

    function keyword2hsv(args) {
        return rgb2hsv(keyword2rgb(args));
    }

    function keyword2hwb(args) {
        return rgb2hwb(keyword2rgb(args));
    }

    function keyword2cmyk(args) {
        return rgb2cmyk(keyword2rgb(args));
    }

    function keyword2lab(args) {
        return rgb2lab(keyword2rgb(args));
    }

    function keyword2xyz(args) {
        return rgb2xyz(keyword2rgb(args));
    }

    var cssKeywords = {
        aliceblue:  [240,248,255],
        antiquewhite: [250,235,215],
        aqua: [0,255,255],
        aquamarine: [127,255,212],
        azure:  [240,255,255],
        beige:  [245,245,220],
        bisque: [255,228,196],
        black:  [0,0,0],
        blanchedalmond: [255,235,205],
        blue: [0,0,255],
        blueviolet: [138,43,226],
        brown:  [165,42,42],
        burlywood:  [222,184,135],
        cadetblue:  [95,158,160],
        chartreuse: [127,255,0],
        chocolate:  [210,105,30],
        coral:  [255,127,80],
        cornflowerblue: [100,149,237],
        cornsilk: [255,248,220],
        crimson:  [220,20,60],
        cyan: [0,255,255],
        darkblue: [0,0,139],
        darkcyan: [0,139,139],
        darkgoldenrod:  [184,134,11],
        darkgray: [169,169,169],
        darkgreen:  [0,100,0],
        darkgrey: [169,169,169],
        darkkhaki:  [189,183,107],
        darkmagenta:  [139,0,139],
        darkolivegreen: [85,107,47],
        darkorange: [255,140,0],
        darkorchid: [153,50,204],
        darkred:  [139,0,0],
        darksalmon: [233,150,122],
        darkseagreen: [143,188,143],
        darkslateblue:  [72,61,139],
        darkslategray:  [47,79,79],
        darkslategrey:  [47,79,79],
        darkturquoise:  [0,206,209],
        darkviolet: [148,0,211],
        deeppink: [255,20,147],
        deepskyblue:  [0,191,255],
        dimgray:  [105,105,105],
        dimgrey:  [105,105,105],
        dodgerblue: [30,144,255],
        firebrick:  [178,34,34],
        floralwhite:  [255,250,240],
        forestgreen:  [34,139,34],
        fuchsia:  [255,0,255],
        gainsboro:  [220,220,220],
        ghostwhite: [248,248,255],
        gold: [255,215,0],
        goldenrod:  [218,165,32],
        gray: [128,128,128],
        green:  [0,128,0],
        greenyellow:  [173,255,47],
        grey: [128,128,128],
        honeydew: [240,255,240],
        hotpink:  [255,105,180],
        indianred:  [205,92,92],
        indigo: [75,0,130],
        ivory:  [255,255,240],
        khaki:  [240,230,140],
        lavender: [230,230,250],
        lavenderblush:  [255,240,245],
        lawngreen:  [124,252,0],
        lemonchiffon: [255,250,205],
        lightblue:  [173,216,230],
        lightcoral: [240,128,128],
        lightcyan:  [224,255,255],
        lightgoldenrodyellow: [250,250,210],
        lightgray:  [211,211,211],
        lightgreen: [144,238,144],
        lightgrey:  [211,211,211],
        lightpink:  [255,182,193],
        lightsalmon:  [255,160,122],
        lightseagreen:  [32,178,170],
        lightskyblue: [135,206,250],
        lightslategray: [119,136,153],
        lightslategrey: [119,136,153],
        lightsteelblue: [176,196,222],
        lightyellow:  [255,255,224],
        lime: [0,255,0],
        limegreen:  [50,205,50],
        linen:  [250,240,230],
        magenta:  [255,0,255],
        maroon: [128,0,0],
        mediumaquamarine: [102,205,170],
        mediumblue: [0,0,205],
        mediumorchid: [186,85,211],
        mediumpurple: [147,112,219],
        mediumseagreen: [60,179,113],
        mediumslateblue:  [123,104,238],
        mediumspringgreen:  [0,250,154],
        mediumturquoise:  [72,209,204],
        mediumvioletred:  [199,21,133],
        midnightblue: [25,25,112],
        mintcream:  [245,255,250],
        mistyrose:  [255,228,225],
        moccasin: [255,228,181],
        navajowhite:  [255,222,173],
        navy: [0,0,128],
        oldlace:  [253,245,230],
        olive:  [128,128,0],
        olivedrab:  [107,142,35],
        orange: [255,165,0],
        orangered:  [255,69,0],
        orchid: [218,112,214],
        palegoldenrod:  [238,232,170],
        palegreen:  [152,251,152],
        paleturquoise:  [175,238,238],
        palevioletred:  [219,112,147],
        papayawhip: [255,239,213],
        peachpuff:  [255,218,185],
        peru: [205,133,63],
        pink: [255,192,203],
        plum: [221,160,221],
        powderblue: [176,224,230],
        purple: [128,0,128],
        rebeccapurple: [102, 51, 153],
        red:  [255,0,0],
        rosybrown:  [188,143,143],
        royalblue:  [65,105,225],
        saddlebrown:  [139,69,19],
        salmon: [250,128,114],
        sandybrown: [244,164,96],
        seagreen: [46,139,87],
        seashell: [255,245,238],
        sienna: [160,82,45],
        silver: [192,192,192],
        skyblue:  [135,206,235],
        slateblue:  [106,90,205],
        slategray:  [112,128,144],
        slategrey:  [112,128,144],
        snow: [255,250,250],
        springgreen:  [0,255,127],
        steelblue:  [70,130,180],
        tan:  [210,180,140],
        teal: [0,128,128],
        thistle:  [216,191,216],
        tomato: [255,99,71],
        turquoise:  [64,224,208],
        violet: [238,130,238],
        wheat:  [245,222,179],
        white:  [255,255,255],
        whitesmoke: [245,245,245],
        yellow: [255,255,0],
        yellowgreen:  [154,205,50]
    };

    var reverseKeywords = {};
    for (var key in cssKeywords) {
        reverseKeywords[JSON.stringify(cssKeywords[key])] = key;
    }

},{}],4:[function(require,module,exports){
    var conversions = require(3);

    var convert = function() {
        return new Converter();
    }

    for (var func in conversions) {
        // export Raw versions
        convert[func + "Raw"] =  (function(func) {
            // accept array or plain args
            return function(arg) {
                if (typeof arg == "number")
                    arg = Array.prototype.slice.call(arguments);
                return conversions[func](arg);
            }
        })(func);

        var pair = /(\w+)2(\w+)/.exec(func),
            from = pair[1],
            to = pair[2];

        // export rgb2hsl and ["rgb"]["hsl"]
        convert[from] = convert[from] || {};

        convert[from][to] = convert[func] = (function(func) {
            return function(arg) {
                if (typeof arg == "number")
                    arg = Array.prototype.slice.call(arguments);

                var val = conversions[func](arg);
                if (typeof val == "string" || val === undefined)
                    return val; // keyword

                for (var i = 0; i < val.length; i++)
                    val[i] = Math.round(val[i]);
                return val;
            }
        })(func);
    }


    /* Converter does lazy conversion and caching */
    var Converter = function() {
        this.convs = {};
    };

    /* Either get the values for a space or
     set the values for a space, depending on args */
    Converter.prototype.routeSpace = function(space, args) {
        var values = args[0];
        if (values === undefined) {
            // color.rgb()
            return this.getValues(space);
        }
        // color.rgb(10, 10, 10)
        if (typeof values == "number") {
            values = Array.prototype.slice.call(args);
        }

        return this.setValues(space, values);
    };

    /* Set the values for a space, invalidating cache */
    Converter.prototype.setValues = function(space, values) {
        this.space = space;
        this.convs = {};
        this.convs[space] = values;
        return this;
    };

    /* Get the values for a space. If there's already
     a conversion for the space, fetch it, otherwise
     compute it */
    Converter.prototype.getValues = function(space) {
        var vals = this.convs[space];
        if (!vals) {
            var fspace = this.space,
                from = this.convs[fspace];
            vals = convert[fspace][space](from);

            this.convs[space] = vals;
        }
        return vals;
    };

    ["rgb", "hsl", "hsv", "cmyk", "keyword"].forEach(function(space) {
        Converter.prototype[space] = function(vals) {
            return this.routeSpace(space, arguments);
        }
    });

    module.exports = convert;
},{"3":3}],5:[function(require,module,exports){
    module.exports = {
        "aliceblue": [240, 248, 255],
        "antiquewhite": [250, 235, 215],
        "aqua": [0, 255, 255],
        "aquamarine": [127, 255, 212],
        "azure": [240, 255, 255],
        "beige": [245, 245, 220],
        "bisque": [255, 228, 196],
        "black": [0, 0, 0],
        "blanchedalmond": [255, 235, 205],
        "blue": [0, 0, 255],
        "blueviolet": [138, 43, 226],
        "brown": [165, 42, 42],
        "burlywood": [222, 184, 135],
        "cadetblue": [95, 158, 160],
        "chartreuse": [127, 255, 0],
        "chocolate": [210, 105, 30],
        "coral": [255, 127, 80],
        "cornflowerblue": [100, 149, 237],
        "cornsilk": [255, 248, 220],
        "crimson": [220, 20, 60],
        "cyan": [0, 255, 255],
        "darkblue": [0, 0, 139],
        "darkcyan": [0, 139, 139],
        "darkgoldenrod": [184, 134, 11],
        "darkgray": [169, 169, 169],
        "darkgreen": [0, 100, 0],
        "darkgrey": [169, 169, 169],
        "darkkhaki": [189, 183, 107],
        "darkmagenta": [139, 0, 139],
        "darkolivegreen": [85, 107, 47],
        "darkorange": [255, 140, 0],
        "darkorchid": [153, 50, 204],
        "darkred": [139, 0, 0],
        "darksalmon": [233, 150, 122],
        "darkseagreen": [143, 188, 143],
        "darkslateblue": [72, 61, 139],
        "darkslategray": [47, 79, 79],
        "darkslategrey": [47, 79, 79],
        "darkturquoise": [0, 206, 209],
        "darkviolet": [148, 0, 211],
        "deeppink": [255, 20, 147],
        "deepskyblue": [0, 191, 255],
        "dimgray": [105, 105, 105],
        "dimgrey": [105, 105, 105],
        "dodgerblue": [30, 144, 255],
        "firebrick": [178, 34, 34],
        "floralwhite": [255, 250, 240],
        "forestgreen": [34, 139, 34],
        "fuchsia": [255, 0, 255],
        "gainsboro": [220, 220, 220],
        "ghostwhite": [248, 248, 255],
        "gold": [255, 215, 0],
        "goldenrod": [218, 165, 32],
        "gray": [128, 128, 128],
        "green": [0, 128, 0],
        "greenyellow": [173, 255, 47],
        "grey": [128, 128, 128],
        "honeydew": [240, 255, 240],
        "hotpink": [255, 105, 180],
        "indianred": [205, 92, 92],
        "indigo": [75, 0, 130],
        "ivory": [255, 255, 240],
        "khaki": [240, 230, 140],
        "lavender": [230, 230, 250],
        "lavenderblush": [255, 240, 245],
        "lawngreen": [124, 252, 0],
        "lemonchiffon": [255, 250, 205],
        "lightblue": [173, 216, 230],
        "lightcoral": [240, 128, 128],
        "lightcyan": [224, 255, 255],
        "lightgoldenrodyellow": [250, 250, 210],
        "lightgray": [211, 211, 211],
        "lightgreen": [144, 238, 144],
        "lightgrey": [211, 211, 211],
        "lightpink": [255, 182, 193],
        "lightsalmon": [255, 160, 122],
        "lightseagreen": [32, 178, 170],
        "lightskyblue": [135, 206, 250],
        "lightslategray": [119, 136, 153],
        "lightslategrey": [119, 136, 153],
        "lightsteelblue": [176, 196, 222],
        "lightyellow": [255, 255, 224],
        "lime": [0, 255, 0],
        "limegreen": [50, 205, 50],
        "linen": [250, 240, 230],
        "magenta": [255, 0, 255],
        "maroon": [128, 0, 0],
        "mediumaquamarine": [102, 205, 170],
        "mediumblue": [0, 0, 205],
        "mediumorchid": [186, 85, 211],
        "mediumpurple": [147, 112, 219],
        "mediumseagreen": [60, 179, 113],
        "mediumslateblue": [123, 104, 238],
        "mediumspringgreen": [0, 250, 154],
        "mediumturquoise": [72, 209, 204],
        "mediumvioletred": [199, 21, 133],
        "midnightblue": [25, 25, 112],
        "mintcream": [245, 255, 250],
        "mistyrose": [255, 228, 225],
        "moccasin": [255, 228, 181],
        "navajowhite": [255, 222, 173],
        "navy": [0, 0, 128],
        "oldlace": [253, 245, 230],
        "olive": [128, 128, 0],
        "olivedrab": [107, 142, 35],
        "orange": [255, 165, 0],
        "orangered": [255, 69, 0],
        "orchid": [218, 112, 214],
        "palegoldenrod": [238, 232, 170],
        "palegreen": [152, 251, 152],
        "paleturquoise": [175, 238, 238],
        "palevioletred": [219, 112, 147],
        "papayawhip": [255, 239, 213],
        "peachpuff": [255, 218, 185],
        "peru": [205, 133, 63],
        "pink": [255, 192, 203],
        "plum": [221, 160, 221],
        "powderblue": [176, 224, 230],
        "purple": [128, 0, 128],
        "rebeccapurple": [102, 51, 153],
        "red": [255, 0, 0],
        "rosybrown": [188, 143, 143],
        "royalblue": [65, 105, 225],
        "saddlebrown": [139, 69, 19],
        "salmon": [250, 128, 114],
        "sandybrown": [244, 164, 96],
        "seagreen": [46, 139, 87],
        "seashell": [255, 245, 238],
        "sienna": [160, 82, 45],
        "silver": [192, 192, 192],
        "skyblue": [135, 206, 235],
        "slateblue": [106, 90, 205],
        "slategray": [112, 128, 144],
        "slategrey": [112, 128, 144],
        "snow": [255, 250, 250],
        "springgreen": [0, 255, 127],
        "steelblue": [70, 130, 180],
        "tan": [210, 180, 140],
        "teal": [0, 128, 128],
        "thistle": [216, 191, 216],
        "tomato": [255, 99, 71],
        "turquoise": [64, 224, 208],
        "violet": [238, 130, 238],
        "wheat": [245, 222, 179],
        "white": [255, 255, 255],
        "whitesmoke": [245, 245, 245],
        "yellow": [255, 255, 0],
        "yellowgreen": [154, 205, 50]
    };
},{}],6:[function(require,module,exports){
//! moment.js
//! version : 2.15.1
//! authors : Tim Wood, Iskren Chernev, Moment.js contributors
//! license : MIT
//! momentjs.com

    ;(function (global, factory) {
        typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
            typeof define === 'function' && define.amd ? define(factory) :
                global.moment = factory()
    }(this, function () { 'use strict';

        var hookCallback;

        function utils_hooks__hooks () {
            return hookCallback.apply(null, arguments);
        }

        // This is done to register the method called with moment()
        // without creating circular dependencies.
        function setHookCallback (callback) {
            hookCallback = callback;
        }

        function isArray(input) {
            return input instanceof Array || Object.prototype.toString.call(input) === '[object Array]';
        }

        function isObject(input) {
            // IE8 will treat undefined and null as object if it wasn't for
            // input != null
            return input != null && Object.prototype.toString.call(input) === '[object Object]';
        }

        function isObjectEmpty(obj) {
            var k;
            for (k in obj) {
                // even if its not own property I'd still call it non-empty
                return false;
            }
            return true;
        }

        function isDate(input) {
            return input instanceof Date || Object.prototype.toString.call(input) === '[object Date]';
        }

        function map(arr, fn) {
            var res = [], i;
            for (i = 0; i < arr.length; ++i) {
                res.push(fn(arr[i], i));
            }
            return res;
        }

        function hasOwnProp(a, b) {
            return Object.prototype.hasOwnProperty.call(a, b);
        }

        function extend(a, b) {
            for (var i in b) {
                if (hasOwnProp(b, i)) {
                    a[i] = b[i];
                }
            }

            if (hasOwnProp(b, 'toString')) {
                a.toString = b.toString;
            }

            if (hasOwnProp(b, 'valueOf')) {
                a.valueOf = b.valueOf;
            }

            return a;
        }

        function create_utc__createUTC (input, format, locale, strict) {
            return createLocalOrUTC(input, format, locale, strict, true).utc();
        }

        function defaultParsingFlags() {
            // We need to deep clone this object.
            return {
                empty           : false,
                unusedTokens    : [],
                unusedInput     : [],
                overflow        : -2,
                charsLeftOver   : 0,
                nullInput       : false,
                invalidMonth    : null,
                invalidFormat   : false,
                userInvalidated : false,
                iso             : false,
                parsedDateParts : [],
                meridiem        : null
            };
        }

        function getParsingFlags(m) {
            if (m._pf == null) {
                m._pf = defaultParsingFlags();
            }
            return m._pf;
        }

        var some;
        if (Array.prototype.some) {
            some = Array.prototype.some;
        } else {
            some = function (fun) {
                var t = Object(this);
                var len = t.length >>> 0;

                for (var i = 0; i < len; i++) {
                    if (i in t && fun.call(this, t[i], i, t)) {
                        return true;
                    }
                }

                return false;
            };
        }

        function valid__isValid(m) {
            if (m._isValid == null) {
                var flags = getParsingFlags(m);
                var parsedParts = some.call(flags.parsedDateParts, function (i) {
                    return i != null;
                });
                var isNowValid = !isNaN(m._d.getTime()) &&
                    flags.overflow < 0 &&
                    !flags.empty &&
                    !flags.invalidMonth &&
                    !flags.invalidWeekday &&
                    !flags.nullInput &&
                    !flags.invalidFormat &&
                    !flags.userInvalidated &&
                    (!flags.meridiem || (flags.meridiem && parsedParts));

                if (m._strict) {
                    isNowValid = isNowValid &&
                        flags.charsLeftOver === 0 &&
                        flags.unusedTokens.length === 0 &&
                        flags.bigHour === undefined;
                }

                if (Object.isFrozen == null || !Object.isFrozen(m)) {
                    m._isValid = isNowValid;
                }
                else {
                    return isNowValid;
                }
            }
            return m._isValid;
        }

        function valid__createInvalid (flags) {
            var m = create_utc__createUTC(NaN);
            if (flags != null) {
                extend(getParsingFlags(m), flags);
            }
            else {
                getParsingFlags(m).userInvalidated = true;
            }

            return m;
        }

        function isUndefined(input) {
            return input === void 0;
        }

        // Plugins that add properties should also add the key here (null value),
        // so we can properly clone ourselves.
        var momentProperties = utils_hooks__hooks.momentProperties = [];

        function copyConfig(to, from) {
            var i, prop, val;

            if (!isUndefined(from._isAMomentObject)) {
                to._isAMomentObject = from._isAMomentObject;
            }
            if (!isUndefined(from._i)) {
                to._i = from._i;
            }
            if (!isUndefined(from._f)) {
                to._f = from._f;
            }
            if (!isUndefined(from._l)) {
                to._l = from._l;
            }
            if (!isUndefined(from._strict)) {
                to._strict = from._strict;
            }
            if (!isUndefined(from._tzm)) {
                to._tzm = from._tzm;
            }
            if (!isUndefined(from._isUTC)) {
                to._isUTC = from._isUTC;
            }
            if (!isUndefined(from._offset)) {
                to._offset = from._offset;
            }
            if (!isUndefined(from._pf)) {
                to._pf = getParsingFlags(from);
            }
            if (!isUndefined(from._locale)) {
                to._locale = from._locale;
            }

            if (momentProperties.length > 0) {
                for (i in momentProperties) {
                    prop = momentProperties[i];
                    val = from[prop];
                    if (!isUndefined(val)) {
                        to[prop] = val;
                    }
                }
            }

            return to;
        }

        var updateInProgress = false;

        // Moment prototype object
        function Moment(config) {
            copyConfig(this, config);
            this._d = new Date(config._d != null ? config._d.getTime() : NaN);
            // Prevent infinite loop in case updateOffset creates new moment
            // objects.
            if (updateInProgress === false) {
                updateInProgress = true;
                utils_hooks__hooks.updateOffset(this);
                updateInProgress = false;
            }
        }

        function isMoment (obj) {
            return obj instanceof Moment || (obj != null && obj._isAMomentObject != null);
        }

        function absFloor (number) {
            if (number < 0) {
                // -0 -> 0
                return Math.ceil(number) || 0;
            } else {
                return Math.floor(number);
            }
        }

        function toInt(argumentForCoercion) {
            var coercedNumber = +argumentForCoercion,
                value = 0;

            if (coercedNumber !== 0 && isFinite(coercedNumber)) {
                value = absFloor(coercedNumber);
            }

            return value;
        }

        // compare two arrays, return the number of differences
        function compareArrays(array1, array2, dontConvert) {
            var len = Math.min(array1.length, array2.length),
                lengthDiff = Math.abs(array1.length - array2.length),
                diffs = 0,
                i;
            for (i = 0; i < len; i++) {
                if ((dontConvert && array1[i] !== array2[i]) ||
                    (!dontConvert && toInt(array1[i]) !== toInt(array2[i]))) {
                    diffs++;
                }
            }
            return diffs + lengthDiff;
        }

        function warn(msg) {
            if (utils_hooks__hooks.suppressDeprecationWarnings === false &&
                (typeof console !==  'undefined') && console.warn) {
                console.warn('Deprecation warning: ' + msg);
            }
        }

        function deprecate(msg, fn) {
            var firstTime = true;

            return extend(function () {
                if (utils_hooks__hooks.deprecationHandler != null) {
                    utils_hooks__hooks.deprecationHandler(null, msg);
                }
                if (firstTime) {
                    var args = [];
                    var arg;
                    for (var i = 0; i < arguments.length; i++) {
                        arg = '';
                        if (typeof arguments[i] === 'object') {
                            arg += '\n[' + i + '] ';
                            for (var key in arguments[0]) {
                                arg += key + ': ' + arguments[0][key] + ', ';
                            }
                            arg = arg.slice(0, -2); // Remove trailing comma and space
                        } else {
                            arg = arguments[i];
                        }
                        args.push(arg);
                    }
                    warn(msg + '\nArguments: ' + Array.prototype.slice.call(args).join('') + '\n' + (new Error()).stack);
                    firstTime = false;
                }
                return fn.apply(this, arguments);
            }, fn);
        }

        var deprecations = {};

        function deprecateSimple(name, msg) {
            if (utils_hooks__hooks.deprecationHandler != null) {
                utils_hooks__hooks.deprecationHandler(name, msg);
            }
            if (!deprecations[name]) {
                warn(msg);
                deprecations[name] = true;
            }
        }

        utils_hooks__hooks.suppressDeprecationWarnings = false;
        utils_hooks__hooks.deprecationHandler = null;

        function isFunction(input) {
            return input instanceof Function || Object.prototype.toString.call(input) === '[object Function]';
        }

        function locale_set__set (config) {
            var prop, i;
            for (i in config) {
                prop = config[i];
                if (isFunction(prop)) {
                    this[i] = prop;
                } else {
                    this['_' + i] = prop;
                }
            }
            this._config = config;
            // Lenient ordinal parsing accepts just a number in addition to
            // number + (possibly) stuff coming from _ordinalParseLenient.
            this._ordinalParseLenient = new RegExp(this._ordinalParse.source + '|' + (/\d{1,2}/).source);
        }

        function mergeConfigs(parentConfig, childConfig) {
            var res = extend({}, parentConfig), prop;
            for (prop in childConfig) {
                if (hasOwnProp(childConfig, prop)) {
                    if (isObject(parentConfig[prop]) && isObject(childConfig[prop])) {
                        res[prop] = {};
                        extend(res[prop], parentConfig[prop]);
                        extend(res[prop], childConfig[prop]);
                    } else if (childConfig[prop] != null) {
                        res[prop] = childConfig[prop];
                    } else {
                        delete res[prop];
                    }
                }
            }
            for (prop in parentConfig) {
                if (hasOwnProp(parentConfig, prop) &&
                    !hasOwnProp(childConfig, prop) &&
                    isObject(parentConfig[prop])) {
                    // make sure changes to properties don't modify parent config
                    res[prop] = extend({}, res[prop]);
                }
            }
            return res;
        }

        function Locale(config) {
            if (config != null) {
                this.set(config);
            }
        }

        var keys;

        if (Object.keys) {
            keys = Object.keys;
        } else {
            keys = function (obj) {
                var i, res = [];
                for (i in obj) {
                    if (hasOwnProp(obj, i)) {
                        res.push(i);
                    }
                }
                return res;
            };
        }

        var defaultCalendar = {
            sameDay : '[Today at] LT',
            nextDay : '[Tomorrow at] LT',
            nextWeek : 'dddd [at] LT',
            lastDay : '[Yesterday at] LT',
            lastWeek : '[Last] dddd [at] LT',
            sameElse : 'L'
        };

        function locale_calendar__calendar (key, mom, now) {
            var output = this._calendar[key] || this._calendar['sameElse'];
            return isFunction(output) ? output.call(mom, now) : output;
        }

        var defaultLongDateFormat = {
            LTS  : 'h:mm:ss A',
            LT   : 'h:mm A',
            L    : 'MM/DD/YYYY',
            LL   : 'MMMM D, YYYY',
            LLL  : 'MMMM D, YYYY h:mm A',
            LLLL : 'dddd, MMMM D, YYYY h:mm A'
        };

        function longDateFormat (key) {
            var format = this._longDateFormat[key],
                formatUpper = this._longDateFormat[key.toUpperCase()];

            if (format || !formatUpper) {
                return format;
            }

            this._longDateFormat[key] = formatUpper.replace(/MMMM|MM|DD|dddd/g, function (val) {
                return val.slice(1);
            });

            return this._longDateFormat[key];
        }

        var defaultInvalidDate = 'Invalid date';

        function invalidDate () {
            return this._invalidDate;
        }

        var defaultOrdinal = '%d';
        var defaultOrdinalParse = /\d{1,2}/;

        function ordinal (number) {
            return this._ordinal.replace('%d', number);
        }

        var defaultRelativeTime = {
            future : 'in %s',
            past   : '%s ago',
            s  : 'a few seconds',
            m  : 'a minute',
            mm : '%d minutes',
            h  : 'an hour',
            hh : '%d hours',
            d  : 'a day',
            dd : '%d days',
            M  : 'a month',
            MM : '%d months',
            y  : 'a year',
            yy : '%d years'
        };

        function relative__relativeTime (number, withoutSuffix, string, isFuture) {
            var output = this._relativeTime[string];
            return (isFunction(output)) ?
                output(number, withoutSuffix, string, isFuture) :
                output.replace(/%d/i, number);
        }

        function pastFuture (diff, output) {
            var format = this._relativeTime[diff > 0 ? 'future' : 'past'];
            return isFunction(format) ? format(output) : format.replace(/%s/i, output);
        }

        var aliases = {};

        function addUnitAlias (unit, shorthand) {
            var lowerCase = unit.toLowerCase();
            aliases[lowerCase] = aliases[lowerCase + 's'] = aliases[shorthand] = unit;
        }

        function normalizeUnits(units) {
            return typeof units === 'string' ? aliases[units] || aliases[units.toLowerCase()] : undefined;
        }

        function normalizeObjectUnits(inputObject) {
            var normalizedInput = {},
                normalizedProp,
                prop;

            for (prop in inputObject) {
                if (hasOwnProp(inputObject, prop)) {
                    normalizedProp = normalizeUnits(prop);
                    if (normalizedProp) {
                        normalizedInput[normalizedProp] = inputObject[prop];
                    }
                }
            }

            return normalizedInput;
        }

        var priorities = {};

        function addUnitPriority(unit, priority) {
            priorities[unit] = priority;
        }

        function getPrioritizedUnits(unitsObj) {
            var units = [];
            for (var u in unitsObj) {
                units.push({unit: u, priority: priorities[u]});
            }
            units.sort(function (a, b) {
                return a.priority - b.priority;
            });
            return units;
        }

        function makeGetSet (unit, keepTime) {
            return function (value) {
                if (value != null) {
                    get_set__set(this, unit, value);
                    utils_hooks__hooks.updateOffset(this, keepTime);
                    return this;
                } else {
                    return get_set__get(this, unit);
                }
            };
        }

        function get_set__get (mom, unit) {
            return mom.isValid() ?
                mom._d['get' + (mom._isUTC ? 'UTC' : '') + unit]() : NaN;
        }

        function get_set__set (mom, unit, value) {
            if (mom.isValid()) {
                mom._d['set' + (mom._isUTC ? 'UTC' : '') + unit](value);
            }
        }

        // MOMENTS

        function stringGet (units) {
            units = normalizeUnits(units);
            if (isFunction(this[units])) {
                return this[units]();
            }
            return this;
        }


        function stringSet (units, value) {
            if (typeof units === 'object') {
                units = normalizeObjectUnits(units);
                var prioritized = getPrioritizedUnits(units);
                for (var i = 0; i < prioritized.length; i++) {
                    this[prioritized[i].unit](units[prioritized[i].unit]);
                }
            } else {
                units = normalizeUnits(units);
                if (isFunction(this[units])) {
                    return this[units](value);
                }
            }
            return this;
        }

        function zeroFill(number, targetLength, forceSign) {
            var absNumber = '' + Math.abs(number),
                zerosToFill = targetLength - absNumber.length,
                sign = number >= 0;
            return (sign ? (forceSign ? '+' : '') : '-') +
                Math.pow(10, Math.max(0, zerosToFill)).toString().substr(1) + absNumber;
        }

        var formattingTokens = /(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g;

        var localFormattingTokens = /(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g;

        var formatFunctions = {};

        var formatTokenFunctions = {};

        // token:    'M'
        // padded:   ['MM', 2]
        // ordinal:  'Mo'
        // callback: function () { this.month() + 1 }
        function addFormatToken (token, padded, ordinal, callback) {
            var func = callback;
            if (typeof callback === 'string') {
                func = function () {
                    return this[callback]();
                };
            }
            if (token) {
                formatTokenFunctions[token] = func;
            }
            if (padded) {
                formatTokenFunctions[padded[0]] = function () {
                    return zeroFill(func.apply(this, arguments), padded[1], padded[2]);
                };
            }
            if (ordinal) {
                formatTokenFunctions[ordinal] = function () {
                    return this.localeData().ordinal(func.apply(this, arguments), token);
                };
            }
        }

        function removeFormattingTokens(input) {
            if (input.match(/\[[\s\S]/)) {
                return input.replace(/^\[|\]$/g, '');
            }
            return input.replace(/\\/g, '');
        }

        function makeFormatFunction(format) {
            var array = format.match(formattingTokens), i, length;

            for (i = 0, length = array.length; i < length; i++) {
                if (formatTokenFunctions[array[i]]) {
                    array[i] = formatTokenFunctions[array[i]];
                } else {
                    array[i] = removeFormattingTokens(array[i]);
                }
            }

            return function (mom) {
                var output = '', i;
                for (i = 0; i < length; i++) {
                    output += array[i] instanceof Function ? array[i].call(mom, format) : array[i];
                }
                return output;
            };
        }

        // format date using native date object
        function formatMoment(m, format) {
            if (!m.isValid()) {
                return m.localeData().invalidDate();
            }

            format = expandFormat(format, m.localeData());
            formatFunctions[format] = formatFunctions[format] || makeFormatFunction(format);

            return formatFunctions[format](m);
        }

        function expandFormat(format, locale) {
            var i = 5;

            function replaceLongDateFormatTokens(input) {
                return locale.longDateFormat(input) || input;
            }

            localFormattingTokens.lastIndex = 0;
            while (i >= 0 && localFormattingTokens.test(format)) {
                format = format.replace(localFormattingTokens, replaceLongDateFormatTokens);
                localFormattingTokens.lastIndex = 0;
                i -= 1;
            }

            return format;
        }

        var match1         = /\d/;            //       0 - 9
        var match2         = /\d\d/;          //      00 - 99
        var match3         = /\d{3}/;         //     000 - 999
        var match4         = /\d{4}/;         //    0000 - 9999
        var match6         = /[+-]?\d{6}/;    // -999999 - 999999
        var match1to2      = /\d\d?/;         //       0 - 99
        var match3to4      = /\d\d\d\d?/;     //     999 - 9999
        var match5to6      = /\d\d\d\d\d\d?/; //   99999 - 999999
        var match1to3      = /\d{1,3}/;       //       0 - 999
        var match1to4      = /\d{1,4}/;       //       0 - 9999
        var match1to6      = /[+-]?\d{1,6}/;  // -999999 - 999999

        var matchUnsigned  = /\d+/;           //       0 - inf
        var matchSigned    = /[+-]?\d+/;      //    -inf - inf

        var matchOffset    = /Z|[+-]\d\d:?\d\d/gi; // +00:00 -00:00 +0000 -0000 or Z
        var matchShortOffset = /Z|[+-]\d\d(?::?\d\d)?/gi; // +00 -00 +00:00 -00:00 +0000 -0000 or Z

        var matchTimestamp = /[+-]?\d+(\.\d{1,3})?/; // 123456789 123456789.123

        // any word (or two) characters or numbers including two/three word month in arabic.
        // includes scottish gaelic two word and hyphenated months
        var matchWord = /[0-9]*['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+|[\u0600-\u06FF\/]+(\s*?[\u0600-\u06FF]+){1,2}/i;


        var regexes = {};

        function addRegexToken (token, regex, strictRegex) {
            regexes[token] = isFunction(regex) ? regex : function (isStrict, localeData) {
                return (isStrict && strictRegex) ? strictRegex : regex;
            };
        }

        function getParseRegexForToken (token, config) {
            if (!hasOwnProp(regexes, token)) {
                return new RegExp(unescapeFormat(token));
            }

            return regexes[token](config._strict, config._locale);
        }

        // Code from http://stackoverflow.com/questions/3561493/is-there-a-regexp-escape-function-in-javascript
        function unescapeFormat(s) {
            return regexEscape(s.replace('\\', '').replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g, function (matched, p1, p2, p3, p4) {
                return p1 || p2 || p3 || p4;
            }));
        }

        function regexEscape(s) {
            return s.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
        }

        var tokens = {};

        function addParseToken (token, callback) {
            var i, func = callback;
            if (typeof token === 'string') {
                token = [token];
            }
            if (typeof callback === 'number') {
                func = function (input, array) {
                    array[callback] = toInt(input);
                };
            }
            for (i = 0; i < token.length; i++) {
                tokens[token[i]] = func;
            }
        }

        function addWeekParseToken (token, callback) {
            addParseToken(token, function (input, array, config, token) {
                config._w = config._w || {};
                callback(input, config._w, config, token);
            });
        }

        function addTimeToArrayFromToken(token, input, config) {
            if (input != null && hasOwnProp(tokens, token)) {
                tokens[token](input, config._a, config, token);
            }
        }

        var YEAR = 0;
        var MONTH = 1;
        var DATE = 2;
        var HOUR = 3;
        var MINUTE = 4;
        var SECOND = 5;
        var MILLISECOND = 6;
        var WEEK = 7;
        var WEEKDAY = 8;

        var indexOf;

        if (Array.prototype.indexOf) {
            indexOf = Array.prototype.indexOf;
        } else {
            indexOf = function (o) {
                // I know
                var i;
                for (i = 0; i < this.length; ++i) {
                    if (this[i] === o) {
                        return i;
                    }
                }
                return -1;
            };
        }

        function daysInMonth(year, month) {
            return new Date(Date.UTC(year, month + 1, 0)).getUTCDate();
        }

        // FORMATTING

        addFormatToken('M', ['MM', 2], 'Mo', function () {
            return this.month() + 1;
        });

        addFormatToken('MMM', 0, 0, function (format) {
            return this.localeData().monthsShort(this, format);
        });

        addFormatToken('MMMM', 0, 0, function (format) {
            return this.localeData().months(this, format);
        });

        // ALIASES

        addUnitAlias('month', 'M');

        // PRIORITY

        addUnitPriority('month', 8);

        // PARSING

        addRegexToken('M',    match1to2);
        addRegexToken('MM',   match1to2, match2);
        addRegexToken('MMM',  function (isStrict, locale) {
            return locale.monthsShortRegex(isStrict);
        });
        addRegexToken('MMMM', function (isStrict, locale) {
            return locale.monthsRegex(isStrict);
        });

        addParseToken(['M', 'MM'], function (input, array) {
            array[MONTH] = toInt(input) - 1;
        });

        addParseToken(['MMM', 'MMMM'], function (input, array, config, token) {
            var month = config._locale.monthsParse(input, token, config._strict);
            // if we didn't find a month name, mark the date as invalid.
            if (month != null) {
                array[MONTH] = month;
            } else {
                getParsingFlags(config).invalidMonth = input;
            }
        });

        // LOCALES

        var MONTHS_IN_FORMAT = /D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/;
        var defaultLocaleMonths = 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_');
        function localeMonths (m, format) {
            if (!m) {
                return this._months;
            }
            return isArray(this._months) ? this._months[m.month()] :
                this._months[(this._months.isFormat || MONTHS_IN_FORMAT).test(format) ? 'format' : 'standalone'][m.month()];
        }

        var defaultLocaleMonthsShort = 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_');
        function localeMonthsShort (m, format) {
            if (!m) {
                return this._monthsShort;
            }
            return isArray(this._monthsShort) ? this._monthsShort[m.month()] :
                this._monthsShort[MONTHS_IN_FORMAT.test(format) ? 'format' : 'standalone'][m.month()];
        }

        function units_month__handleStrictParse(monthName, format, strict) {
            var i, ii, mom, llc = monthName.toLocaleLowerCase();
            if (!this._monthsParse) {
                // this is not used
                this._monthsParse = [];
                this._longMonthsParse = [];
                this._shortMonthsParse = [];
                for (i = 0; i < 12; ++i) {
                    mom = create_utc__createUTC([2000, i]);
                    this._shortMonthsParse[i] = this.monthsShort(mom, '').toLocaleLowerCase();
                    this._longMonthsParse[i] = this.months(mom, '').toLocaleLowerCase();
                }
            }

            if (strict) {
                if (format === 'MMM') {
                    ii = indexOf.call(this._shortMonthsParse, llc);
                    return ii !== -1 ? ii : null;
                } else {
                    ii = indexOf.call(this._longMonthsParse, llc);
                    return ii !== -1 ? ii : null;
                }
            } else {
                if (format === 'MMM') {
                    ii = indexOf.call(this._shortMonthsParse, llc);
                    if (ii !== -1) {
                        return ii;
                    }
                    ii = indexOf.call(this._longMonthsParse, llc);
                    return ii !== -1 ? ii : null;
                } else {
                    ii = indexOf.call(this._longMonthsParse, llc);
                    if (ii !== -1) {
                        return ii;
                    }
                    ii = indexOf.call(this._shortMonthsParse, llc);
                    return ii !== -1 ? ii : null;
                }
            }
        }

        function localeMonthsParse (monthName, format, strict) {
            var i, mom, regex;

            if (this._monthsParseExact) {
                return units_month__handleStrictParse.call(this, monthName, format, strict);
            }

            if (!this._monthsParse) {
                this._monthsParse = [];
                this._longMonthsParse = [];
                this._shortMonthsParse = [];
            }

            // TODO: add sorting
            // Sorting makes sure if one month (or abbr) is a prefix of another
            // see sorting in computeMonthsParse
            for (i = 0; i < 12; i++) {
                // make the regex if we don't have it already
                mom = create_utc__createUTC([2000, i]);
                if (strict && !this._longMonthsParse[i]) {
                    this._longMonthsParse[i] = new RegExp('^' + this.months(mom, '').replace('.', '') + '$', 'i');
                    this._shortMonthsParse[i] = new RegExp('^' + this.monthsShort(mom, '').replace('.', '') + '$', 'i');
                }
                if (!strict && !this._monthsParse[i]) {
                    regex = '^' + this.months(mom, '') + '|^' + this.monthsShort(mom, '');
                    this._monthsParse[i] = new RegExp(regex.replace('.', ''), 'i');
                }
                // test the regex
                if (strict && format === 'MMMM' && this._longMonthsParse[i].test(monthName)) {
                    return i;
                } else if (strict && format === 'MMM' && this._shortMonthsParse[i].test(monthName)) {
                    return i;
                } else if (!strict && this._monthsParse[i].test(monthName)) {
                    return i;
                }
            }
        }

        // MOMENTS

        function setMonth (mom, value) {
            var dayOfMonth;

            if (!mom.isValid()) {
                // No op
                return mom;
            }

            if (typeof value === 'string') {
                if (/^\d+$/.test(value)) {
                    value = toInt(value);
                } else {
                    value = mom.localeData().monthsParse(value);
                    // TODO: Another silent failure?
                    if (typeof value !== 'number') {
                        return mom;
                    }
                }
            }

            dayOfMonth = Math.min(mom.date(), daysInMonth(mom.year(), value));
            mom._d['set' + (mom._isUTC ? 'UTC' : '') + 'Month'](value, dayOfMonth);
            return mom;
        }

        function getSetMonth (value) {
            if (value != null) {
                setMonth(this, value);
                utils_hooks__hooks.updateOffset(this, true);
                return this;
            } else {
                return get_set__get(this, 'Month');
            }
        }

        function getDaysInMonth () {
            return daysInMonth(this.year(), this.month());
        }

        var defaultMonthsShortRegex = matchWord;
        function monthsShortRegex (isStrict) {
            if (this._monthsParseExact) {
                if (!hasOwnProp(this, '_monthsRegex')) {
                    computeMonthsParse.call(this);
                }
                if (isStrict) {
                    return this._monthsShortStrictRegex;
                } else {
                    return this._monthsShortRegex;
                }
            } else {
                if (!hasOwnProp(this, '_monthsShortRegex')) {
                    this._monthsShortRegex = defaultMonthsShortRegex;
                }
                return this._monthsShortStrictRegex && isStrict ?
                    this._monthsShortStrictRegex : this._monthsShortRegex;
            }
        }

        var defaultMonthsRegex = matchWord;
        function monthsRegex (isStrict) {
            if (this._monthsParseExact) {
                if (!hasOwnProp(this, '_monthsRegex')) {
                    computeMonthsParse.call(this);
                }
                if (isStrict) {
                    return this._monthsStrictRegex;
                } else {
                    return this._monthsRegex;
                }
            } else {
                if (!hasOwnProp(this, '_monthsRegex')) {
                    this._monthsRegex = defaultMonthsRegex;
                }
                return this._monthsStrictRegex && isStrict ?
                    this._monthsStrictRegex : this._monthsRegex;
            }
        }

        function computeMonthsParse () {
            function cmpLenRev(a, b) {
                return b.length - a.length;
            }

            var shortPieces = [], longPieces = [], mixedPieces = [],
                i, mom;
            for (i = 0; i < 12; i++) {
                // make the regex if we don't have it already
                mom = create_utc__createUTC([2000, i]);
                shortPieces.push(this.monthsShort(mom, ''));
                longPieces.push(this.months(mom, ''));
                mixedPieces.push(this.months(mom, ''));
                mixedPieces.push(this.monthsShort(mom, ''));
            }
            // Sorting makes sure if one month (or abbr) is a prefix of another it
            // will match the longer piece.
            shortPieces.sort(cmpLenRev);
            longPieces.sort(cmpLenRev);
            mixedPieces.sort(cmpLenRev);
            for (i = 0; i < 12; i++) {
                shortPieces[i] = regexEscape(shortPieces[i]);
                longPieces[i] = regexEscape(longPieces[i]);
            }
            for (i = 0; i < 24; i++) {
                mixedPieces[i] = regexEscape(mixedPieces[i]);
            }

            this._monthsRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
            this._monthsShortRegex = this._monthsRegex;
            this._monthsStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');
            this._monthsShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');
        }

        // FORMATTING

        addFormatToken('Y', 0, 0, function () {
            var y = this.year();
            return y <= 9999 ? '' + y : '+' + y;
        });

        addFormatToken(0, ['YY', 2], 0, function () {
            return this.year() % 100;
        });

        addFormatToken(0, ['YYYY',   4],       0, 'year');
        addFormatToken(0, ['YYYYY',  5],       0, 'year');
        addFormatToken(0, ['YYYYYY', 6, true], 0, 'year');

        // ALIASES

        addUnitAlias('year', 'y');

        // PRIORITIES

        addUnitPriority('year', 1);

        // PARSING

        addRegexToken('Y',      matchSigned);
        addRegexToken('YY',     match1to2, match2);
        addRegexToken('YYYY',   match1to4, match4);
        addRegexToken('YYYYY',  match1to6, match6);
        addRegexToken('YYYYYY', match1to6, match6);

        addParseToken(['YYYYY', 'YYYYYY'], YEAR);
        addParseToken('YYYY', function (input, array) {
            array[YEAR] = input.length === 2 ? utils_hooks__hooks.parseTwoDigitYear(input) : toInt(input);
        });
        addParseToken('YY', function (input, array) {
            array[YEAR] = utils_hooks__hooks.parseTwoDigitYear(input);
        });
        addParseToken('Y', function (input, array) {
            array[YEAR] = parseInt(input, 10);
        });

        // HELPERS

        function daysInYear(year) {
            return isLeapYear(year) ? 366 : 365;
        }

        function isLeapYear(year) {
            return (year % 4 === 0 && year % 100 !== 0) || year % 400 === 0;
        }

        // HOOKS

        utils_hooks__hooks.parseTwoDigitYear = function (input) {
            return toInt(input) + (toInt(input) > 68 ? 1900 : 2000);
        };

        // MOMENTS

        var getSetYear = makeGetSet('FullYear', true);

        function getIsLeapYear () {
            return isLeapYear(this.year());
        }

        function createDate (y, m, d, h, M, s, ms) {
            //can't just apply() to create a date:
            //http://stackoverflow.com/questions/181348/instantiating-a-javascript-object-by-calling-prototype-constructor-apply
            var date = new Date(y, m, d, h, M, s, ms);

            //the date constructor remaps years 0-99 to 1900-1999
            if (y < 100 && y >= 0 && isFinite(date.getFullYear())) {
                date.setFullYear(y);
            }
            return date;
        }

        function createUTCDate (y) {
            var date = new Date(Date.UTC.apply(null, arguments));

            //the Date.UTC function remaps years 0-99 to 1900-1999
            if (y < 100 && y >= 0 && isFinite(date.getUTCFullYear())) {
                date.setUTCFullYear(y);
            }
            return date;
        }

        // start-of-first-week - start-of-year
        function firstWeekOffset(year, dow, doy) {
            var // first-week day -- which january is always in the first week (4 for iso, 1 for other)
                fwd = 7 + dow - doy,
            // first-week day local weekday -- which local weekday is fwd
                fwdlw = (7 + createUTCDate(year, 0, fwd).getUTCDay() - dow) % 7;

            return -fwdlw + fwd - 1;
        }

        //http://en.wikipedia.org/wiki/ISO_week_date#Calculating_a_date_given_the_year.2C_week_number_and_weekday
        function dayOfYearFromWeeks(year, week, weekday, dow, doy) {
            var localWeekday = (7 + weekday - dow) % 7,
                weekOffset = firstWeekOffset(year, dow, doy),
                dayOfYear = 1 + 7 * (week - 1) + localWeekday + weekOffset,
                resYear, resDayOfYear;

            if (dayOfYear <= 0) {
                resYear = year - 1;
                resDayOfYear = daysInYear(resYear) + dayOfYear;
            } else if (dayOfYear > daysInYear(year)) {
                resYear = year + 1;
                resDayOfYear = dayOfYear - daysInYear(year);
            } else {
                resYear = year;
                resDayOfYear = dayOfYear;
            }

            return {
                year: resYear,
                dayOfYear: resDayOfYear
            };
        }

        function weekOfYear(mom, dow, doy) {
            var weekOffset = firstWeekOffset(mom.year(), dow, doy),
                week = Math.floor((mom.dayOfYear() - weekOffset - 1) / 7) + 1,
                resWeek, resYear;

            if (week < 1) {
                resYear = mom.year() - 1;
                resWeek = week + weeksInYear(resYear, dow, doy);
            } else if (week > weeksInYear(mom.year(), dow, doy)) {
                resWeek = week - weeksInYear(mom.year(), dow, doy);
                resYear = mom.year() + 1;
            } else {
                resYear = mom.year();
                resWeek = week;
            }

            return {
                week: resWeek,
                year: resYear
            };
        }

        function weeksInYear(year, dow, doy) {
            var weekOffset = firstWeekOffset(year, dow, doy),
                weekOffsetNext = firstWeekOffset(year + 1, dow, doy);
            return (daysInYear(year) - weekOffset + weekOffsetNext) / 7;
        }

        // FORMATTING

        addFormatToken('w', ['ww', 2], 'wo', 'week');
        addFormatToken('W', ['WW', 2], 'Wo', 'isoWeek');

        // ALIASES

        addUnitAlias('week', 'w');
        addUnitAlias('isoWeek', 'W');

        // PRIORITIES

        addUnitPriority('week', 5);
        addUnitPriority('isoWeek', 5);

        // PARSING

        addRegexToken('w',  match1to2);
        addRegexToken('ww', match1to2, match2);
        addRegexToken('W',  match1to2);
        addRegexToken('WW', match1to2, match2);

        addWeekParseToken(['w', 'ww', 'W', 'WW'], function (input, week, config, token) {
            week[token.substr(0, 1)] = toInt(input);
        });

        // HELPERS

        // LOCALES

        function localeWeek (mom) {
            return weekOfYear(mom, this._week.dow, this._week.doy).week;
        }

        var defaultLocaleWeek = {
            dow : 0, // Sunday is the first day of the week.
            doy : 6  // The week that contains Jan 1st is the first week of the year.
        };

        function localeFirstDayOfWeek () {
            return this._week.dow;
        }

        function localeFirstDayOfYear () {
            return this._week.doy;
        }

        // MOMENTS

        function getSetWeek (input) {
            var week = this.localeData().week(this);
            return input == null ? week : this.add((input - week) * 7, 'd');
        }

        function getSetISOWeek (input) {
            var week = weekOfYear(this, 1, 4).week;
            return input == null ? week : this.add((input - week) * 7, 'd');
        }

        // FORMATTING

        addFormatToken('d', 0, 'do', 'day');

        addFormatToken('dd', 0, 0, function (format) {
            return this.localeData().weekdaysMin(this, format);
        });

        addFormatToken('ddd', 0, 0, function (format) {
            return this.localeData().weekdaysShort(this, format);
        });

        addFormatToken('dddd', 0, 0, function (format) {
            return this.localeData().weekdays(this, format);
        });

        addFormatToken('e', 0, 0, 'weekday');
        addFormatToken('E', 0, 0, 'isoWeekday');

        // ALIASES

        addUnitAlias('day', 'd');
        addUnitAlias('weekday', 'e');
        addUnitAlias('isoWeekday', 'E');

        // PRIORITY
        addUnitPriority('day', 11);
        addUnitPriority('weekday', 11);
        addUnitPriority('isoWeekday', 11);

        // PARSING

        addRegexToken('d',    match1to2);
        addRegexToken('e',    match1to2);
        addRegexToken('E',    match1to2);
        addRegexToken('dd',   function (isStrict, locale) {
            return locale.weekdaysMinRegex(isStrict);
        });
        addRegexToken('ddd',   function (isStrict, locale) {
            return locale.weekdaysShortRegex(isStrict);
        });
        addRegexToken('dddd',   function (isStrict, locale) {
            return locale.weekdaysRegex(isStrict);
        });

        addWeekParseToken(['dd', 'ddd', 'dddd'], function (input, week, config, token) {
            var weekday = config._locale.weekdaysParse(input, token, config._strict);
            // if we didn't get a weekday name, mark the date as invalid
            if (weekday != null) {
                week.d = weekday;
            } else {
                getParsingFlags(config).invalidWeekday = input;
            }
        });

        addWeekParseToken(['d', 'e', 'E'], function (input, week, config, token) {
            week[token] = toInt(input);
        });

        // HELPERS

        function parseWeekday(input, locale) {
            if (typeof input !== 'string') {
                return input;
            }

            if (!isNaN(input)) {
                return parseInt(input, 10);
            }

            input = locale.weekdaysParse(input);
            if (typeof input === 'number') {
                return input;
            }

            return null;
        }

        function parseIsoWeekday(input, locale) {
            if (typeof input === 'string') {
                return locale.weekdaysParse(input) % 7 || 7;
            }
            return isNaN(input) ? null : input;
        }

        // LOCALES

        var defaultLocaleWeekdays = 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_');
        function localeWeekdays (m, format) {
            if (!m) {
                return this._weekdays;
            }
            return isArray(this._weekdays) ? this._weekdays[m.day()] :
                this._weekdays[this._weekdays.isFormat.test(format) ? 'format' : 'standalone'][m.day()];
        }

        var defaultLocaleWeekdaysShort = 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_');
        function localeWeekdaysShort (m) {
            return (m) ? this._weekdaysShort[m.day()] : this._weekdaysShort;
        }

        var defaultLocaleWeekdaysMin = 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_');
        function localeWeekdaysMin (m) {
            return (m) ? this._weekdaysMin[m.day()] : this._weekdaysMin;
        }

        function day_of_week__handleStrictParse(weekdayName, format, strict) {
            var i, ii, mom, llc = weekdayName.toLocaleLowerCase();
            if (!this._weekdaysParse) {
                this._weekdaysParse = [];
                this._shortWeekdaysParse = [];
                this._minWeekdaysParse = [];

                for (i = 0; i < 7; ++i) {
                    mom = create_utc__createUTC([2000, 1]).day(i);
                    this._minWeekdaysParse[i] = this.weekdaysMin(mom, '').toLocaleLowerCase();
                    this._shortWeekdaysParse[i] = this.weekdaysShort(mom, '').toLocaleLowerCase();
                    this._weekdaysParse[i] = this.weekdays(mom, '').toLocaleLowerCase();
                }
            }

            if (strict) {
                if (format === 'dddd') {
                    ii = indexOf.call(this._weekdaysParse, llc);
                    return ii !== -1 ? ii : null;
                } else if (format === 'ddd') {
                    ii = indexOf.call(this._shortWeekdaysParse, llc);
                    return ii !== -1 ? ii : null;
                } else {
                    ii = indexOf.call(this._minWeekdaysParse, llc);
                    return ii !== -1 ? ii : null;
                }
            } else {
                if (format === 'dddd') {
                    ii = indexOf.call(this._weekdaysParse, llc);
                    if (ii !== -1) {
                        return ii;
                    }
                    ii = indexOf.call(this._shortWeekdaysParse, llc);
                    if (ii !== -1) {
                        return ii;
                    }
                    ii = indexOf.call(this._minWeekdaysParse, llc);
                    return ii !== -1 ? ii : null;
                } else if (format === 'ddd') {
                    ii = indexOf.call(this._shortWeekdaysParse, llc);
                    if (ii !== -1) {
                        return ii;
                    }
                    ii = indexOf.call(this._weekdaysParse, llc);
                    if (ii !== -1) {
                        return ii;
                    }
                    ii = indexOf.call(this._minWeekdaysParse, llc);
                    return ii !== -1 ? ii : null;
                } else {
                    ii = indexOf.call(this._minWeekdaysParse, llc);
                    if (ii !== -1) {
                        return ii;
                    }
                    ii = indexOf.call(this._weekdaysParse, llc);
                    if (ii !== -1) {
                        return ii;
                    }
                    ii = indexOf.call(this._shortWeekdaysParse, llc);
                    return ii !== -1 ? ii : null;
                }
            }
        }

        function localeWeekdaysParse (weekdayName, format, strict) {
            var i, mom, regex;

            if (this._weekdaysParseExact) {
                return day_of_week__handleStrictParse.call(this, weekdayName, format, strict);
            }

            if (!this._weekdaysParse) {
                this._weekdaysParse = [];
                this._minWeekdaysParse = [];
                this._shortWeekdaysParse = [];
                this._fullWeekdaysParse = [];
            }

            for (i = 0; i < 7; i++) {
                // make the regex if we don't have it already

                mom = create_utc__createUTC([2000, 1]).day(i);
                if (strict && !this._fullWeekdaysParse[i]) {
                    this._fullWeekdaysParse[i] = new RegExp('^' + this.weekdays(mom, '').replace('.', '\.?') + '$', 'i');
                    this._shortWeekdaysParse[i] = new RegExp('^' + this.weekdaysShort(mom, '').replace('.', '\.?') + '$', 'i');
                    this._minWeekdaysParse[i] = new RegExp('^' + this.weekdaysMin(mom, '').replace('.', '\.?') + '$', 'i');
                }
                if (!this._weekdaysParse[i]) {
                    regex = '^' + this.weekdays(mom, '') + '|^' + this.weekdaysShort(mom, '') + '|^' + this.weekdaysMin(mom, '');
                    this._weekdaysParse[i] = new RegExp(regex.replace('.', ''), 'i');
                }
                // test the regex
                if (strict && format === 'dddd' && this._fullWeekdaysParse[i].test(weekdayName)) {
                    return i;
                } else if (strict && format === 'ddd' && this._shortWeekdaysParse[i].test(weekdayName)) {
                    return i;
                } else if (strict && format === 'dd' && this._minWeekdaysParse[i].test(weekdayName)) {
                    return i;
                } else if (!strict && this._weekdaysParse[i].test(weekdayName)) {
                    return i;
                }
            }
        }

        // MOMENTS

        function getSetDayOfWeek (input) {
            if (!this.isValid()) {
                return input != null ? this : NaN;
            }
            var day = this._isUTC ? this._d.getUTCDay() : this._d.getDay();
            if (input != null) {
                input = parseWeekday(input, this.localeData());
                return this.add(input - day, 'd');
            } else {
                return day;
            }
        }

        function getSetLocaleDayOfWeek (input) {
            if (!this.isValid()) {
                return input != null ? this : NaN;
            }
            var weekday = (this.day() + 7 - this.localeData()._week.dow) % 7;
            return input == null ? weekday : this.add(input - weekday, 'd');
        }

        function getSetISODayOfWeek (input) {
            if (!this.isValid()) {
                return input != null ? this : NaN;
            }

            // behaves the same as moment#day except
            // as a getter, returns 7 instead of 0 (1-7 range instead of 0-6)
            // as a setter, sunday should belong to the previous week.

            if (input != null) {
                var weekday = parseIsoWeekday(input, this.localeData());
                return this.day(this.day() % 7 ? weekday : weekday - 7);
            } else {
                return this.day() || 7;
            }
        }

        var defaultWeekdaysRegex = matchWord;
        function weekdaysRegex (isStrict) {
            if (this._weekdaysParseExact) {
                if (!hasOwnProp(this, '_weekdaysRegex')) {
                    computeWeekdaysParse.call(this);
                }
                if (isStrict) {
                    return this._weekdaysStrictRegex;
                } else {
                    return this._weekdaysRegex;
                }
            } else {
                if (!hasOwnProp(this, '_weekdaysRegex')) {
                    this._weekdaysRegex = defaultWeekdaysRegex;
                }
                return this._weekdaysStrictRegex && isStrict ?
                    this._weekdaysStrictRegex : this._weekdaysRegex;
            }
        }

        var defaultWeekdaysShortRegex = matchWord;
        function weekdaysShortRegex (isStrict) {
            if (this._weekdaysParseExact) {
                if (!hasOwnProp(this, '_weekdaysRegex')) {
                    computeWeekdaysParse.call(this);
                }
                if (isStrict) {
                    return this._weekdaysShortStrictRegex;
                } else {
                    return this._weekdaysShortRegex;
                }
            } else {
                if (!hasOwnProp(this, '_weekdaysShortRegex')) {
                    this._weekdaysShortRegex = defaultWeekdaysShortRegex;
                }
                return this._weekdaysShortStrictRegex && isStrict ?
                    this._weekdaysShortStrictRegex : this._weekdaysShortRegex;
            }
        }

        var defaultWeekdaysMinRegex = matchWord;
        function weekdaysMinRegex (isStrict) {
            if (this._weekdaysParseExact) {
                if (!hasOwnProp(this, '_weekdaysRegex')) {
                    computeWeekdaysParse.call(this);
                }
                if (isStrict) {
                    return this._weekdaysMinStrictRegex;
                } else {
                    return this._weekdaysMinRegex;
                }
            } else {
                if (!hasOwnProp(this, '_weekdaysMinRegex')) {
                    this._weekdaysMinRegex = defaultWeekdaysMinRegex;
                }
                return this._weekdaysMinStrictRegex && isStrict ?
                    this._weekdaysMinStrictRegex : this._weekdaysMinRegex;
            }
        }


        function computeWeekdaysParse () {
            function cmpLenRev(a, b) {
                return b.length - a.length;
            }

            var minPieces = [], shortPieces = [], longPieces = [], mixedPieces = [],
                i, mom, minp, shortp, longp;
            for (i = 0; i < 7; i++) {
                // make the regex if we don't have it already
                mom = create_utc__createUTC([2000, 1]).day(i);
                minp = this.weekdaysMin(mom, '');
                shortp = this.weekdaysShort(mom, '');
                longp = this.weekdays(mom, '');
                minPieces.push(minp);
                shortPieces.push(shortp);
                longPieces.push(longp);
                mixedPieces.push(minp);
                mixedPieces.push(shortp);
                mixedPieces.push(longp);
            }
            // Sorting makes sure if one weekday (or abbr) is a prefix of another it
            // will match the longer piece.
            minPieces.sort(cmpLenRev);
            shortPieces.sort(cmpLenRev);
            longPieces.sort(cmpLenRev);
            mixedPieces.sort(cmpLenRev);
            for (i = 0; i < 7; i++) {
                shortPieces[i] = regexEscape(shortPieces[i]);
                longPieces[i] = regexEscape(longPieces[i]);
                mixedPieces[i] = regexEscape(mixedPieces[i]);
            }

            this._weekdaysRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
            this._weekdaysShortRegex = this._weekdaysRegex;
            this._weekdaysMinRegex = this._weekdaysRegex;

            this._weekdaysStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');
            this._weekdaysShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');
            this._weekdaysMinStrictRegex = new RegExp('^(' + minPieces.join('|') + ')', 'i');
        }

        // FORMATTING

        function hFormat() {
            return this.hours() % 12 || 12;
        }

        function kFormat() {
            return this.hours() || 24;
        }

        addFormatToken('H', ['HH', 2], 0, 'hour');
        addFormatToken('h', ['hh', 2], 0, hFormat);
        addFormatToken('k', ['kk', 2], 0, kFormat);

        addFormatToken('hmm', 0, 0, function () {
            return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2);
        });

        addFormatToken('hmmss', 0, 0, function () {
            return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2) +
                zeroFill(this.seconds(), 2);
        });

        addFormatToken('Hmm', 0, 0, function () {
            return '' + this.hours() + zeroFill(this.minutes(), 2);
        });

        addFormatToken('Hmmss', 0, 0, function () {
            return '' + this.hours() + zeroFill(this.minutes(), 2) +
                zeroFill(this.seconds(), 2);
        });

        function meridiem (token, lowercase) {
            addFormatToken(token, 0, 0, function () {
                return this.localeData().meridiem(this.hours(), this.minutes(), lowercase);
            });
        }

        meridiem('a', true);
        meridiem('A', false);

        // ALIASES

        addUnitAlias('hour', 'h');

        // PRIORITY
        addUnitPriority('hour', 13);

        // PARSING

        function matchMeridiem (isStrict, locale) {
            return locale._meridiemParse;
        }

        addRegexToken('a',  matchMeridiem);
        addRegexToken('A',  matchMeridiem);
        addRegexToken('H',  match1to2);
        addRegexToken('h',  match1to2);
        addRegexToken('HH', match1to2, match2);
        addRegexToken('hh', match1to2, match2);

        addRegexToken('hmm', match3to4);
        addRegexToken('hmmss', match5to6);
        addRegexToken('Hmm', match3to4);
        addRegexToken('Hmmss', match5to6);

        addParseToken(['H', 'HH'], HOUR);
        addParseToken(['a', 'A'], function (input, array, config) {
            config._isPm = config._locale.isPM(input);
            config._meridiem = input;
        });
        addParseToken(['h', 'hh'], function (input, array, config) {
            array[HOUR] = toInt(input);
            getParsingFlags(config).bigHour = true;
        });
        addParseToken('hmm', function (input, array, config) {
            var pos = input.length - 2;
            array[HOUR] = toInt(input.substr(0, pos));
            array[MINUTE] = toInt(input.substr(pos));
            getParsingFlags(config).bigHour = true;
        });
        addParseToken('hmmss', function (input, array, config) {
            var pos1 = input.length - 4;
            var pos2 = input.length - 2;
            array[HOUR] = toInt(input.substr(0, pos1));
            array[MINUTE] = toInt(input.substr(pos1, 2));
            array[SECOND] = toInt(input.substr(pos2));
            getParsingFlags(config).bigHour = true;
        });
        addParseToken('Hmm', function (input, array, config) {
            var pos = input.length - 2;
            array[HOUR] = toInt(input.substr(0, pos));
            array[MINUTE] = toInt(input.substr(pos));
        });
        addParseToken('Hmmss', function (input, array, config) {
            var pos1 = input.length - 4;
            var pos2 = input.length - 2;
            array[HOUR] = toInt(input.substr(0, pos1));
            array[MINUTE] = toInt(input.substr(pos1, 2));
            array[SECOND] = toInt(input.substr(pos2));
        });

        // LOCALES

        function localeIsPM (input) {
            // IE8 Quirks Mode & IE7 Standards Mode do not allow accessing strings like arrays
            // Using charAt should be more compatible.
            return ((input + '').toLowerCase().charAt(0) === 'p');
        }

        var defaultLocaleMeridiemParse = /[ap]\.?m?\.?/i;
        function localeMeridiem (hours, minutes, isLower) {
            if (hours > 11) {
                return isLower ? 'pm' : 'PM';
            } else {
                return isLower ? 'am' : 'AM';
            }
        }


        // MOMENTS

        // Setting the hour should keep the time, because the user explicitly
        // specified which hour he wants. So trying to maintain the same hour (in
        // a new timezone) makes sense. Adding/subtracting hours does not follow
        // this rule.
        var getSetHour = makeGetSet('Hours', true);

        var baseConfig = {
            calendar: defaultCalendar,
            longDateFormat: defaultLongDateFormat,
            invalidDate: defaultInvalidDate,
            ordinal: defaultOrdinal,
            ordinalParse: defaultOrdinalParse,
            relativeTime: defaultRelativeTime,

            months: defaultLocaleMonths,
            monthsShort: defaultLocaleMonthsShort,

            week: defaultLocaleWeek,

            weekdays: defaultLocaleWeekdays,
            weekdaysMin: defaultLocaleWeekdaysMin,
            weekdaysShort: defaultLocaleWeekdaysShort,

            meridiemParse: defaultLocaleMeridiemParse
        };

        // internal storage for locale config files
        var locales = {};
        var globalLocale;

        function normalizeLocale(key) {
            return key ? key.toLowerCase().replace('_', '-') : key;
        }

        // pick the locale from the array
        // try ['en-au', 'en-gb'] as 'en-au', 'en-gb', 'en', as in move through the list trying each
        // substring from most specific to least, but move to the next array item if it's a more specific variant than the current root
        function chooseLocale(names) {
            var i = 0, j, next, locale, split;

            while (i < names.length) {
                split = normalizeLocale(names[i]).split('-');
                j = split.length;
                next = normalizeLocale(names[i + 1]);
                next = next ? next.split('-') : null;
                while (j > 0) {
                    locale = loadLocale(split.slice(0, j).join('-'));
                    if (locale) {
                        return locale;
                    }
                    if (next && next.length >= j && compareArrays(split, next, true) >= j - 1) {
                        //the next array item is better than a shallower substring of this one
                        break;
                    }
                    j--;
                }
                i++;
            }
            return null;
        }

        function loadLocale(name) {
            var oldLocale = null;
            // TODO: Find a better way to register and load all the locales in Node
            if (!locales[name] && (typeof module !== 'undefined') &&
                module && module.exports) {
                try {
                    oldLocale = globalLocale._abbr;
                    require('./locale/' + name);
                    // because defineLocale currently also sets the global locale, we
                    // want to undo that for lazy loaded locales
                    locale_locales__getSetGlobalLocale(oldLocale);
                } catch (e) { }
            }
            return locales[name];
        }

        // This function will load locale and then set the global locale.  If
        // no arguments are passed in, it will simply return the current global
        // locale key.
        function locale_locales__getSetGlobalLocale (key, values) {
            var data;
            if (key) {
                if (isUndefined(values)) {
                    data = locale_locales__getLocale(key);
                }
                else {
                    data = defineLocale(key, values);
                }

                if (data) {
                    // moment.duration._locale = moment._locale = data;
                    globalLocale = data;
                }
            }

            return globalLocale._abbr;
        }

        function defineLocale (name, config) {
            if (config !== null) {
                var parentConfig = baseConfig;
                config.abbr = name;
                if (locales[name] != null) {
                    deprecateSimple('defineLocaleOverride',
                        'use moment.updateLocale(localeName, config) to change ' +
                        'an existing locale. moment.defineLocale(localeName, ' +
                        'config) should only be used for creating a new locale ' +
                        'See http://momentjs.com/guides/#/warnings/define-locale/ for more info.');
                    parentConfig = locales[name]._config;
                } else if (config.parentLocale != null) {
                    if (locales[config.parentLocale] != null) {
                        parentConfig = locales[config.parentLocale]._config;
                    } else {
                        // treat as if there is no base config
                        deprecateSimple('parentLocaleUndefined',
                            'specified parentLocale is not defined yet. See http://momentjs.com/guides/#/warnings/parent-locale/');
                    }
                }
                locales[name] = new Locale(mergeConfigs(parentConfig, config));

                // backwards compat for now: also set the locale
                locale_locales__getSetGlobalLocale(name);

                return locales[name];
            } else {
                // useful for testing
                delete locales[name];
                return null;
            }
        }

        function updateLocale(name, config) {
            if (config != null) {
                var locale, parentConfig = baseConfig;
                // MERGE
                if (locales[name] != null) {
                    parentConfig = locales[name]._config;
                }
                config = mergeConfigs(parentConfig, config);
                locale = new Locale(config);
                locale.parentLocale = locales[name];
                locales[name] = locale;

                // backwards compat for now: also set the locale
                locale_locales__getSetGlobalLocale(name);
            } else {
                // pass null for config to unupdate, useful for tests
                if (locales[name] != null) {
                    if (locales[name].parentLocale != null) {
                        locales[name] = locales[name].parentLocale;
                    } else if (locales[name] != null) {
                        delete locales[name];
                    }
                }
            }
            return locales[name];
        }

        // returns locale data
        function locale_locales__getLocale (key) {
            var locale;

            if (key && key._locale && key._locale._abbr) {
                key = key._locale._abbr;
            }

            if (!key) {
                return globalLocale;
            }

            if (!isArray(key)) {
                //short-circuit everything else
                locale = loadLocale(key);
                if (locale) {
                    return locale;
                }
                key = [key];
            }

            return chooseLocale(key);
        }

        function locale_locales__listLocales() {
            return keys(locales);
        }

        function checkOverflow (m) {
            var overflow;
            var a = m._a;

            if (a && getParsingFlags(m).overflow === -2) {
                overflow =
                    a[MONTH]       < 0 || a[MONTH]       > 11  ? MONTH :
                        a[DATE]        < 1 || a[DATE]        > daysInMonth(a[YEAR], a[MONTH]) ? DATE :
                            a[HOUR]        < 0 || a[HOUR]        > 24 || (a[HOUR] === 24 && (a[MINUTE] !== 0 || a[SECOND] !== 0 || a[MILLISECOND] !== 0)) ? HOUR :
                                a[MINUTE]      < 0 || a[MINUTE]      > 59  ? MINUTE :
                                    a[SECOND]      < 0 || a[SECOND]      > 59  ? SECOND :
                                        a[MILLISECOND] < 0 || a[MILLISECOND] > 999 ? MILLISECOND :
                                            -1;

                if (getParsingFlags(m)._overflowDayOfYear && (overflow < YEAR || overflow > DATE)) {
                    overflow = DATE;
                }
                if (getParsingFlags(m)._overflowWeeks && overflow === -1) {
                    overflow = WEEK;
                }
                if (getParsingFlags(m)._overflowWeekday && overflow === -1) {
                    overflow = WEEKDAY;
                }

                getParsingFlags(m).overflow = overflow;
            }

            return m;
        }

        // iso 8601 regex
        // 0000-00-00 0000-W00 or 0000-W00-0 + T + 00 or 00:00 or 00:00:00 or 00:00:00.000 + +00:00 or +0000 or +00)
        var extendedIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?/;
        var basicIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?/;

        var tzRegex = /Z|[+-]\d\d(?::?\d\d)?/;

        var isoDates = [
            ['YYYYYY-MM-DD', /[+-]\d{6}-\d\d-\d\d/],
            ['YYYY-MM-DD', /\d{4}-\d\d-\d\d/],
            ['GGGG-[W]WW-E', /\d{4}-W\d\d-\d/],
            ['GGGG-[W]WW', /\d{4}-W\d\d/, false],
            ['YYYY-DDD', /\d{4}-\d{3}/],
            ['YYYY-MM', /\d{4}-\d\d/, false],
            ['YYYYYYMMDD', /[+-]\d{10}/],
            ['YYYYMMDD', /\d{8}/],
            // YYYYMM is NOT allowed by the standard
            ['GGGG[W]WWE', /\d{4}W\d{3}/],
            ['GGGG[W]WW', /\d{4}W\d{2}/, false],
            ['YYYYDDD', /\d{7}/]
        ];

        // iso time formats and regexes
        var isoTimes = [
            ['HH:mm:ss.SSSS', /\d\d:\d\d:\d\d\.\d+/],
            ['HH:mm:ss,SSSS', /\d\d:\d\d:\d\d,\d+/],
            ['HH:mm:ss', /\d\d:\d\d:\d\d/],
            ['HH:mm', /\d\d:\d\d/],
            ['HHmmss.SSSS', /\d\d\d\d\d\d\.\d+/],
            ['HHmmss,SSSS', /\d\d\d\d\d\d,\d+/],
            ['HHmmss', /\d\d\d\d\d\d/],
            ['HHmm', /\d\d\d\d/],
            ['HH', /\d\d/]
        ];

        var aspNetJsonRegex = /^\/?Date\((\-?\d+)/i;

        // date from iso format
        function configFromISO(config) {
            var i, l,
                string = config._i,
                match = extendedIsoRegex.exec(string) || basicIsoRegex.exec(string),
                allowTime, dateFormat, timeFormat, tzFormat;

            if (match) {
                getParsingFlags(config).iso = true;

                for (i = 0, l = isoDates.length; i < l; i++) {
                    if (isoDates[i][1].exec(match[1])) {
                        dateFormat = isoDates[i][0];
                        allowTime = isoDates[i][2] !== false;
                        break;
                    }
                }
                if (dateFormat == null) {
                    config._isValid = false;
                    return;
                }
                if (match[3]) {
                    for (i = 0, l = isoTimes.length; i < l; i++) {
                        if (isoTimes[i][1].exec(match[3])) {
                            // match[2] should be 'T' or space
                            timeFormat = (match[2] || ' ') + isoTimes[i][0];
                            break;
                        }
                    }
                    if (timeFormat == null) {
                        config._isValid = false;
                        return;
                    }
                }
                if (!allowTime && timeFormat != null) {
                    config._isValid = false;
                    return;
                }
                if (match[4]) {
                    if (tzRegex.exec(match[4])) {
                        tzFormat = 'Z';
                    } else {
                        config._isValid = false;
                        return;
                    }
                }
                config._f = dateFormat + (timeFormat || '') + (tzFormat || '');
                configFromStringAndFormat(config);
            } else {
                config._isValid = false;
            }
        }

        // date from iso format or fallback
        function configFromString(config) {
            var matched = aspNetJsonRegex.exec(config._i);

            if (matched !== null) {
                config._d = new Date(+matched[1]);
                return;
            }

            configFromISO(config);
            if (config._isValid === false) {
                delete config._isValid;
                utils_hooks__hooks.createFromInputFallback(config);
            }
        }

        utils_hooks__hooks.createFromInputFallback = deprecate(
            'value provided is not in a recognized ISO format. moment construction falls back to js Date(), ' +
            'which is not reliable across all browsers and versions. Non ISO date formats are ' +
            'discouraged and will be removed in an upcoming major release. Please refer to ' +
            'http://momentjs.com/guides/#/warnings/js-date/ for more info.',
            function (config) {
                config._d = new Date(config._i + (config._useUTC ? ' UTC' : ''));
            }
        );

        // Pick the first defined of two or three arguments.
        function defaults(a, b, c) {
            if (a != null) {
                return a;
            }
            if (b != null) {
                return b;
            }
            return c;
        }

        function currentDateArray(config) {
            // hooks is actually the exported moment object
            var nowValue = new Date(utils_hooks__hooks.now());
            if (config._useUTC) {
                return [nowValue.getUTCFullYear(), nowValue.getUTCMonth(), nowValue.getUTCDate()];
            }
            return [nowValue.getFullYear(), nowValue.getMonth(), nowValue.getDate()];
        }

        // convert an array to a date.
        // the array should mirror the parameters below
        // note: all values past the year are optional and will default to the lowest possible value.
        // [year, month, day , hour, minute, second, millisecond]
        function configFromArray (config) {
            var i, date, input = [], currentDate, yearToUse;

            if (config._d) {
                return;
            }

            currentDate = currentDateArray(config);

            //compute day of the year from weeks and weekdays
            if (config._w && config._a[DATE] == null && config._a[MONTH] == null) {
                dayOfYearFromWeekInfo(config);
            }

            //if the day of the year is set, figure out what it is
            if (config._dayOfYear) {
                yearToUse = defaults(config._a[YEAR], currentDate[YEAR]);

                if (config._dayOfYear > daysInYear(yearToUse)) {
                    getParsingFlags(config)._overflowDayOfYear = true;
                }

                date = createUTCDate(yearToUse, 0, config._dayOfYear);
                config._a[MONTH] = date.getUTCMonth();
                config._a[DATE] = date.getUTCDate();
            }

            // Default to current date.
            // * if no year, month, day of month are given, default to today
            // * if day of month is given, default month and year
            // * if month is given, default only year
            // * if year is given, don't default anything
            for (i = 0; i < 3 && config._a[i] == null; ++i) {
                config._a[i] = input[i] = currentDate[i];
            }

            // Zero out whatever was not defaulted, including time
            for (; i < 7; i++) {
                config._a[i] = input[i] = (config._a[i] == null) ? (i === 2 ? 1 : 0) : config._a[i];
            }

            // Check for 24:00:00.000
            if (config._a[HOUR] === 24 &&
                config._a[MINUTE] === 0 &&
                config._a[SECOND] === 0 &&
                config._a[MILLISECOND] === 0) {
                config._nextDay = true;
                config._a[HOUR] = 0;
            }

            config._d = (config._useUTC ? createUTCDate : createDate).apply(null, input);
            // Apply timezone offset from input. The actual utcOffset can be changed
            // with parseZone.
            if (config._tzm != null) {
                config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);
            }

            if (config._nextDay) {
                config._a[HOUR] = 24;
            }
        }

        function dayOfYearFromWeekInfo(config) {
            var w, weekYear, week, weekday, dow, doy, temp, weekdayOverflow;

            w = config._w;
            if (w.GG != null || w.W != null || w.E != null) {
                dow = 1;
                doy = 4;

                // TODO: We need to take the current isoWeekYear, but that depends on
                // how we interpret now (local, utc, fixed offset). So create
                // a now version of current config (take local/utc/offset flags, and
                // create now).
                weekYear = defaults(w.GG, config._a[YEAR], weekOfYear(local__createLocal(), 1, 4).year);
                week = defaults(w.W, 1);
                weekday = defaults(w.E, 1);
                if (weekday < 1 || weekday > 7) {
                    weekdayOverflow = true;
                }
            } else {
                dow = config._locale._week.dow;
                doy = config._locale._week.doy;

                weekYear = defaults(w.gg, config._a[YEAR], weekOfYear(local__createLocal(), dow, doy).year);
                week = defaults(w.w, 1);

                if (w.d != null) {
                    // weekday -- low day numbers are considered next week
                    weekday = w.d;
                    if (weekday < 0 || weekday > 6) {
                        weekdayOverflow = true;
                    }
                } else if (w.e != null) {
                    // local weekday -- counting starts from begining of week
                    weekday = w.e + dow;
                    if (w.e < 0 || w.e > 6) {
                        weekdayOverflow = true;
                    }
                } else {
                    // default to begining of week
                    weekday = dow;
                }
            }
            if (week < 1 || week > weeksInYear(weekYear, dow, doy)) {
                getParsingFlags(config)._overflowWeeks = true;
            } else if (weekdayOverflow != null) {
                getParsingFlags(config)._overflowWeekday = true;
            } else {
                temp = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy);
                config._a[YEAR] = temp.year;
                config._dayOfYear = temp.dayOfYear;
            }
        }

        // constant that refers to the ISO standard
        utils_hooks__hooks.ISO_8601 = function () {};

        // date from string and format string
        function configFromStringAndFormat(config) {
            // TODO: Move this to another part of the creation flow to prevent circular deps
            if (config._f === utils_hooks__hooks.ISO_8601) {
                configFromISO(config);
                return;
            }

            config._a = [];
            getParsingFlags(config).empty = true;

            // This array is used to make a Date, either with `new Date` or `Date.UTC`
            var string = '' + config._i,
                i, parsedInput, tokens, token, skipped,
                stringLength = string.length,
                totalParsedInputLength = 0;

            tokens = expandFormat(config._f, config._locale).match(formattingTokens) || [];

            for (i = 0; i < tokens.length; i++) {
                token = tokens[i];
                parsedInput = (string.match(getParseRegexForToken(token, config)) || [])[0];
                // console.log('token', token, 'parsedInput', parsedInput,
                //         'regex', getParseRegexForToken(token, config));
                if (parsedInput) {
                    skipped = string.substr(0, string.indexOf(parsedInput));
                    if (skipped.length > 0) {
                        getParsingFlags(config).unusedInput.push(skipped);
                    }
                    string = string.slice(string.indexOf(parsedInput) + parsedInput.length);
                    totalParsedInputLength += parsedInput.length;
                }
                // don't parse if it's not a known token
                if (formatTokenFunctions[token]) {
                    if (parsedInput) {
                        getParsingFlags(config).empty = false;
                    }
                    else {
                        getParsingFlags(config).unusedTokens.push(token);
                    }
                    addTimeToArrayFromToken(token, parsedInput, config);
                }
                else if (config._strict && !parsedInput) {
                    getParsingFlags(config).unusedTokens.push(token);
                }
            }

            // add remaining unparsed input length to the string
            getParsingFlags(config).charsLeftOver = stringLength - totalParsedInputLength;
            if (string.length > 0) {
                getParsingFlags(config).unusedInput.push(string);
            }

            // clear _12h flag if hour is <= 12
            if (config._a[HOUR] <= 12 &&
                getParsingFlags(config).bigHour === true &&
                config._a[HOUR] > 0) {
                getParsingFlags(config).bigHour = undefined;
            }

            getParsingFlags(config).parsedDateParts = config._a.slice(0);
            getParsingFlags(config).meridiem = config._meridiem;
            // handle meridiem
            config._a[HOUR] = meridiemFixWrap(config._locale, config._a[HOUR], config._meridiem);

            configFromArray(config);
            checkOverflow(config);
        }


        function meridiemFixWrap (locale, hour, meridiem) {
            var isPm;

            if (meridiem == null) {
                // nothing to do
                return hour;
            }
            if (locale.meridiemHour != null) {
                return locale.meridiemHour(hour, meridiem);
            } else if (locale.isPM != null) {
                // Fallback
                isPm = locale.isPM(meridiem);
                if (isPm && hour < 12) {
                    hour += 12;
                }
                if (!isPm && hour === 12) {
                    hour = 0;
                }
                return hour;
            } else {
                // this is not supposed to happen
                return hour;
            }
        }

        // date from string and array of format strings
        function configFromStringAndArray(config) {
            var tempConfig,
                bestMoment,

                scoreToBeat,
                i,
                currentScore;

            if (config._f.length === 0) {
                getParsingFlags(config).invalidFormat = true;
                config._d = new Date(NaN);
                return;
            }

            for (i = 0; i < config._f.length; i++) {
                currentScore = 0;
                tempConfig = copyConfig({}, config);
                if (config._useUTC != null) {
                    tempConfig._useUTC = config._useUTC;
                }
                tempConfig._f = config._f[i];
                configFromStringAndFormat(tempConfig);

                if (!valid__isValid(tempConfig)) {
                    continue;
                }

                // if there is any input that was not parsed add a penalty for that format
                currentScore += getParsingFlags(tempConfig).charsLeftOver;

                //or tokens
                currentScore += getParsingFlags(tempConfig).unusedTokens.length * 10;

                getParsingFlags(tempConfig).score = currentScore;

                if (scoreToBeat == null || currentScore < scoreToBeat) {
                    scoreToBeat = currentScore;
                    bestMoment = tempConfig;
                }
            }

            extend(config, bestMoment || tempConfig);
        }

        function configFromObject(config) {
            if (config._d) {
                return;
            }

            var i = normalizeObjectUnits(config._i);
            config._a = map([i.year, i.month, i.day || i.date, i.hour, i.minute, i.second, i.millisecond], function (obj) {
                return obj && parseInt(obj, 10);
            });

            configFromArray(config);
        }

        function createFromConfig (config) {
            var res = new Moment(checkOverflow(prepareConfig(config)));
            if (res._nextDay) {
                // Adding is smart enough around DST
                res.add(1, 'd');
                res._nextDay = undefined;
            }

            return res;
        }

        function prepareConfig (config) {
            var input = config._i,
                format = config._f;

            config._locale = config._locale || locale_locales__getLocale(config._l);

            if (input === null || (format === undefined && input === '')) {
                return valid__createInvalid({nullInput: true});
            }

            if (typeof input === 'string') {
                config._i = input = config._locale.preparse(input);
            }

            if (isMoment(input)) {
                return new Moment(checkOverflow(input));
            } else if (isArray(format)) {
                configFromStringAndArray(config);
            } else if (isDate(input)) {
                config._d = input;
            } else if (format) {
                configFromStringAndFormat(config);
            }  else {
                configFromInput(config);
            }

            if (!valid__isValid(config)) {
                config._d = null;
            }

            return config;
        }

        function configFromInput(config) {
            var input = config._i;
            if (input === undefined) {
                config._d = new Date(utils_hooks__hooks.now());
            } else if (isDate(input)) {
                config._d = new Date(input.valueOf());
            } else if (typeof input === 'string') {
                configFromString(config);
            } else if (isArray(input)) {
                config._a = map(input.slice(0), function (obj) {
                    return parseInt(obj, 10);
                });
                configFromArray(config);
            } else if (typeof(input) === 'object') {
                configFromObject(config);
            } else if (typeof(input) === 'number') {
                // from milliseconds
                config._d = new Date(input);
            } else {
                utils_hooks__hooks.createFromInputFallback(config);
            }
        }

        function createLocalOrUTC (input, format, locale, strict, isUTC) {
            var c = {};

            if (typeof(locale) === 'boolean') {
                strict = locale;
                locale = undefined;
            }

            if ((isObject(input) && isObjectEmpty(input)) ||
                (isArray(input) && input.length === 0)) {
                input = undefined;
            }
            // object construction must be done this way.
            // https://github.com/moment/moment/issues/1423
            c._isAMomentObject = true;
            c._useUTC = c._isUTC = isUTC;
            c._l = locale;
            c._i = input;
            c._f = format;
            c._strict = strict;

            return createFromConfig(c);
        }

        function local__createLocal (input, format, locale, strict) {
            return createLocalOrUTC(input, format, locale, strict, false);
        }

        var prototypeMin = deprecate(
            'moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/',
            function () {
                var other = local__createLocal.apply(null, arguments);
                if (this.isValid() && other.isValid()) {
                    return other < this ? this : other;
                } else {
                    return valid__createInvalid();
                }
            }
        );

        var prototypeMax = deprecate(
            'moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/',
            function () {
                var other = local__createLocal.apply(null, arguments);
                if (this.isValid() && other.isValid()) {
                    return other > this ? this : other;
                } else {
                    return valid__createInvalid();
                }
            }
        );

        // Pick a moment m from moments so that m[fn](other) is true for all
        // other. This relies on the function fn to be transitive.
        //
        // moments should either be an array of moment objects or an array, whose
        // first element is an array of moment objects.
        function pickBy(fn, moments) {
            var res, i;
            if (moments.length === 1 && isArray(moments[0])) {
                moments = moments[0];
            }
            if (!moments.length) {
                return local__createLocal();
            }
            res = moments[0];
            for (i = 1; i < moments.length; ++i) {
                if (!moments[i].isValid() || moments[i][fn](res)) {
                    res = moments[i];
                }
            }
            return res;
        }

        // TODO: Use [].sort instead?
        function min () {
            var args = [].slice.call(arguments, 0);

            return pickBy('isBefore', args);
        }

        function max () {
            var args = [].slice.call(arguments, 0);

            return pickBy('isAfter', args);
        }

        var now = function () {
            return Date.now ? Date.now() : +(new Date());
        };

        function Duration (duration) {
            var normalizedInput = normalizeObjectUnits(duration),
                years = normalizedInput.year || 0,
                quarters = normalizedInput.quarter || 0,
                months = normalizedInput.month || 0,
                weeks = normalizedInput.week || 0,
                days = normalizedInput.day || 0,
                hours = normalizedInput.hour || 0,
                minutes = normalizedInput.minute || 0,
                seconds = normalizedInput.second || 0,
                milliseconds = normalizedInput.millisecond || 0;

            // representation for dateAddRemove
            this._milliseconds = +milliseconds +
                seconds * 1e3 + // 1000
                minutes * 6e4 + // 1000 * 60
                hours * 1000 * 60 * 60; //using 1000 * 60 * 60 instead of 36e5 to avoid floating point rounding errors https://github.com/moment/moment/issues/2978
            // Because of dateAddRemove treats 24 hours as different from a
            // day when working around DST, we need to store them separately
            this._days = +days +
                weeks * 7;
            // It is impossible translate months into days without knowing
            // which months you are are talking about, so we have to store
            // it separately.
            this._months = +months +
                quarters * 3 +
                years * 12;

            this._data = {};

            this._locale = locale_locales__getLocale();

            this._bubble();
        }

        function isDuration (obj) {
            return obj instanceof Duration;
        }

        function absRound (number) {
            if (number < 0) {
                return Math.round(-1 * number) * -1;
            } else {
                return Math.round(number);
            }
        }

        // FORMATTING

        function offset (token, separator) {
            addFormatToken(token, 0, 0, function () {
                var offset = this.utcOffset();
                var sign = '+';
                if (offset < 0) {
                    offset = -offset;
                    sign = '-';
                }
                return sign + zeroFill(~~(offset / 60), 2) + separator + zeroFill(~~(offset) % 60, 2);
            });
        }

        offset('Z', ':');
        offset('ZZ', '');

        // PARSING

        addRegexToken('Z',  matchShortOffset);
        addRegexToken('ZZ', matchShortOffset);
        addParseToken(['Z', 'ZZ'], function (input, array, config) {
            config._useUTC = true;
            config._tzm = offsetFromString(matchShortOffset, input);
        });

        // HELPERS

        // timezone chunker
        // '+10:00' > ['10',  '00']
        // '-1530'  > ['-15', '30']
        var chunkOffset = /([\+\-]|\d\d)/gi;

        function offsetFromString(matcher, string) {
            var matches = ((string || '').match(matcher) || []);
            var chunk   = matches[matches.length - 1] || [];
            var parts   = (chunk + '').match(chunkOffset) || ['-', 0, 0];
            var minutes = +(parts[1] * 60) + toInt(parts[2]);

            return parts[0] === '+' ? minutes : -minutes;
        }

        // Return a moment from input, that is local/utc/zone equivalent to model.
        function cloneWithOffset(input, model) {
            var res, diff;
            if (model._isUTC) {
                res = model.clone();
                diff = (isMoment(input) || isDate(input) ? input.valueOf() : local__createLocal(input).valueOf()) - res.valueOf();
                // Use low-level api, because this fn is low-level api.
                res._d.setTime(res._d.valueOf() + diff);
                utils_hooks__hooks.updateOffset(res, false);
                return res;
            } else {
                return local__createLocal(input).local();
            }
        }

        function getDateOffset (m) {
            // On Firefox.24 Date#getTimezoneOffset returns a floating point.
            // https://github.com/moment/moment/pull/1871
            return -Math.round(m._d.getTimezoneOffset() / 15) * 15;
        }

        // HOOKS

        // This function will be called whenever a moment is mutated.
        // It is intended to keep the offset in sync with the timezone.
        utils_hooks__hooks.updateOffset = function () {};

        // MOMENTS

        // keepLocalTime = true means only change the timezone, without
        // affecting the local hour. So 5:31:26 +0300 --[utcOffset(2, true)]-->
        // 5:31:26 +0200 It is possible that 5:31:26 doesn't exist with offset
        // +0200, so we adjust the time as needed, to be valid.
        //
        // Keeping the time actually adds/subtracts (one hour)
        // from the actual represented time. That is why we call updateOffset
        // a second time. In case it wants us to change the offset again
        // _changeInProgress == true case, then we have to adjust, because
        // there is no such time in the given timezone.
        function getSetOffset (input, keepLocalTime) {
            var offset = this._offset || 0,
                localAdjust;
            if (!this.isValid()) {
                return input != null ? this : NaN;
            }
            if (input != null) {
                if (typeof input === 'string') {
                    input = offsetFromString(matchShortOffset, input);
                } else if (Math.abs(input) < 16) {
                    input = input * 60;
                }
                if (!this._isUTC && keepLocalTime) {
                    localAdjust = getDateOffset(this);
                }
                this._offset = input;
                this._isUTC = true;
                if (localAdjust != null) {
                    this.add(localAdjust, 'm');
                }
                if (offset !== input) {
                    if (!keepLocalTime || this._changeInProgress) {
                        add_subtract__addSubtract(this, create__createDuration(input - offset, 'm'), 1, false);
                    } else if (!this._changeInProgress) {
                        this._changeInProgress = true;
                        utils_hooks__hooks.updateOffset(this, true);
                        this._changeInProgress = null;
                    }
                }
                return this;
            } else {
                return this._isUTC ? offset : getDateOffset(this);
            }
        }

        function getSetZone (input, keepLocalTime) {
            if (input != null) {
                if (typeof input !== 'string') {
                    input = -input;
                }

                this.utcOffset(input, keepLocalTime);

                return this;
            } else {
                return -this.utcOffset();
            }
        }

        function setOffsetToUTC (keepLocalTime) {
            return this.utcOffset(0, keepLocalTime);
        }

        function setOffsetToLocal (keepLocalTime) {
            if (this._isUTC) {
                this.utcOffset(0, keepLocalTime);
                this._isUTC = false;

                if (keepLocalTime) {
                    this.subtract(getDateOffset(this), 'm');
                }
            }
            return this;
        }

        function setOffsetToParsedOffset () {
            if (this._tzm) {
                this.utcOffset(this._tzm);
            } else if (typeof this._i === 'string') {
                var tZone = offsetFromString(matchOffset, this._i);

                if (tZone === 0) {
                    this.utcOffset(0, true);
                } else {
                    this.utcOffset(offsetFromString(matchOffset, this._i));
                }
            }
            return this;
        }

        function hasAlignedHourOffset (input) {
            if (!this.isValid()) {
                return false;
            }
            input = input ? local__createLocal(input).utcOffset() : 0;

            return (this.utcOffset() - input) % 60 === 0;
        }

        function isDaylightSavingTime () {
            return (
                this.utcOffset() > this.clone().month(0).utcOffset() ||
                this.utcOffset() > this.clone().month(5).utcOffset()
            );
        }

        function isDaylightSavingTimeShifted () {
            if (!isUndefined(this._isDSTShifted)) {
                return this._isDSTShifted;
            }

            var c = {};

            copyConfig(c, this);
            c = prepareConfig(c);

            if (c._a) {
                var other = c._isUTC ? create_utc__createUTC(c._a) : local__createLocal(c._a);
                this._isDSTShifted = this.isValid() &&
                    compareArrays(c._a, other.toArray()) > 0;
            } else {
                this._isDSTShifted = false;
            }

            return this._isDSTShifted;
        }

        function isLocal () {
            return this.isValid() ? !this._isUTC : false;
        }

        function isUtcOffset () {
            return this.isValid() ? this._isUTC : false;
        }

        function isUtc () {
            return this.isValid() ? this._isUTC && this._offset === 0 : false;
        }

        // ASP.NET json date format regex
        var aspNetRegex = /^(\-)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)(\.\d*)?)?$/;

        // from http://docs.closure-library.googlecode.com/git/closure_goog_date_date.js.source.html
        // somewhat more in line with 4.4.3.2 2004 spec, but allows decimal anywhere
        // and further modified to allow for strings containing both week and day
        var isoRegex = /^(-)?P(?:(-?[0-9,.]*)Y)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)W)?(?:(-?[0-9,.]*)D)?(?:T(?:(-?[0-9,.]*)H)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)S)?)?$/;

        function create__createDuration (input, key) {
            var duration = input,
            // matching against regexp is expensive, do it on demand
                match = null,
                sign,
                ret,
                diffRes;

            if (isDuration(input)) {
                duration = {
                    ms : input._milliseconds,
                    d  : input._days,
                    M  : input._months
                };
            } else if (typeof input === 'number') {
                duration = {};
                if (key) {
                    duration[key] = input;
                } else {
                    duration.milliseconds = input;
                }
            } else if (!!(match = aspNetRegex.exec(input))) {
                sign = (match[1] === '-') ? -1 : 1;
                duration = {
                    y  : 0,
                    d  : toInt(match[DATE])                         * sign,
                    h  : toInt(match[HOUR])                         * sign,
                    m  : toInt(match[MINUTE])                       * sign,
                    s  : toInt(match[SECOND])                       * sign,
                    ms : toInt(absRound(match[MILLISECOND] * 1000)) * sign // the millisecond decimal point is included in the match
                };
            } else if (!!(match = isoRegex.exec(input))) {
                sign = (match[1] === '-') ? -1 : 1;
                duration = {
                    y : parseIso(match[2], sign),
                    M : parseIso(match[3], sign),
                    w : parseIso(match[4], sign),
                    d : parseIso(match[5], sign),
                    h : parseIso(match[6], sign),
                    m : parseIso(match[7], sign),
                    s : parseIso(match[8], sign)
                };
            } else if (duration == null) {// checks for null or undefined
                duration = {};
            } else if (typeof duration === 'object' && ('from' in duration || 'to' in duration)) {
                diffRes = momentsDifference(local__createLocal(duration.from), local__createLocal(duration.to));

                duration = {};
                duration.ms = diffRes.milliseconds;
                duration.M = diffRes.months;
            }

            ret = new Duration(duration);

            if (isDuration(input) && hasOwnProp(input, '_locale')) {
                ret._locale = input._locale;
            }

            return ret;
        }

        create__createDuration.fn = Duration.prototype;

        function parseIso (inp, sign) {
            // We'd normally use ~~inp for this, but unfortunately it also
            // converts floats to ints.
            // inp may be undefined, so careful calling replace on it.
            var res = inp && parseFloat(inp.replace(',', '.'));
            // apply sign while we're at it
            return (isNaN(res) ? 0 : res) * sign;
        }

        function positiveMomentsDifference(base, other) {
            var res = {milliseconds: 0, months: 0};

            res.months = other.month() - base.month() +
                (other.year() - base.year()) * 12;
            if (base.clone().add(res.months, 'M').isAfter(other)) {
                --res.months;
            }

            res.milliseconds = +other - +(base.clone().add(res.months, 'M'));

            return res;
        }

        function momentsDifference(base, other) {
            var res;
            if (!(base.isValid() && other.isValid())) {
                return {milliseconds: 0, months: 0};
            }

            other = cloneWithOffset(other, base);
            if (base.isBefore(other)) {
                res = positiveMomentsDifference(base, other);
            } else {
                res = positiveMomentsDifference(other, base);
                res.milliseconds = -res.milliseconds;
                res.months = -res.months;
            }

            return res;
        }

        // TODO: remove 'name' arg after deprecation is removed
        function createAdder(direction, name) {
            return function (val, period) {
                var dur, tmp;
                //invert the arguments, but complain about it
                if (period !== null && !isNaN(+period)) {
                    deprecateSimple(name, 'moment().' + name  + '(period, number) is deprecated. Please use moment().' + name + '(number, period). ' +
                        'See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.');
                    tmp = val; val = period; period = tmp;
                }

                val = typeof val === 'string' ? +val : val;
                dur = create__createDuration(val, period);
                add_subtract__addSubtract(this, dur, direction);
                return this;
            };
        }

        function add_subtract__addSubtract (mom, duration, isAdding, updateOffset) {
            var milliseconds = duration._milliseconds,
                days = absRound(duration._days),
                months = absRound(duration._months);

            if (!mom.isValid()) {
                // No op
                return;
            }

            updateOffset = updateOffset == null ? true : updateOffset;

            if (milliseconds) {
                mom._d.setTime(mom._d.valueOf() + milliseconds * isAdding);
            }
            if (days) {
                get_set__set(mom, 'Date', get_set__get(mom, 'Date') + days * isAdding);
            }
            if (months) {
                setMonth(mom, get_set__get(mom, 'Month') + months * isAdding);
            }
            if (updateOffset) {
                utils_hooks__hooks.updateOffset(mom, days || months);
            }
        }

        var add_subtract__add      = createAdder(1, 'add');
        var add_subtract__subtract = createAdder(-1, 'subtract');

        function getCalendarFormat(myMoment, now) {
            var diff = myMoment.diff(now, 'days', true);
            return diff < -6 ? 'sameElse' :
                diff < -1 ? 'lastWeek' :
                    diff < 0 ? 'lastDay' :
                        diff < 1 ? 'sameDay' :
                            diff < 2 ? 'nextDay' :
                                diff < 7 ? 'nextWeek' : 'sameElse';
        }

        function moment_calendar__calendar (time, formats) {
            // We want to compare the start of today, vs this.
            // Getting start-of-today depends on whether we're local/utc/offset or not.
            var now = time || local__createLocal(),
                sod = cloneWithOffset(now, this).startOf('day'),
                format = utils_hooks__hooks.calendarFormat(this, sod) || 'sameElse';

            var output = formats && (isFunction(formats[format]) ? formats[format].call(this, now) : formats[format]);

            return this.format(output || this.localeData().calendar(format, this, local__createLocal(now)));
        }

        function clone () {
            return new Moment(this);
        }

        function isAfter (input, units) {
            var localInput = isMoment(input) ? input : local__createLocal(input);
            if (!(this.isValid() && localInput.isValid())) {
                return false;
            }
            units = normalizeUnits(!isUndefined(units) ? units : 'millisecond');
            if (units === 'millisecond') {
                return this.valueOf() > localInput.valueOf();
            } else {
                return localInput.valueOf() < this.clone().startOf(units).valueOf();
            }
        }

        function isBefore (input, units) {
            var localInput = isMoment(input) ? input : local__createLocal(input);
            if (!(this.isValid() && localInput.isValid())) {
                return false;
            }
            units = normalizeUnits(!isUndefined(units) ? units : 'millisecond');
            if (units === 'millisecond') {
                return this.valueOf() < localInput.valueOf();
            } else {
                return this.clone().endOf(units).valueOf() < localInput.valueOf();
            }
        }

        function isBetween (from, to, units, inclusivity) {
            inclusivity = inclusivity || '()';
            return (inclusivity[0] === '(' ? this.isAfter(from, units) : !this.isBefore(from, units)) &&
                (inclusivity[1] === ')' ? this.isBefore(to, units) : !this.isAfter(to, units));
        }

        function isSame (input, units) {
            var localInput = isMoment(input) ? input : local__createLocal(input),
                inputMs;
            if (!(this.isValid() && localInput.isValid())) {
                return false;
            }
            units = normalizeUnits(units || 'millisecond');
            if (units === 'millisecond') {
                return this.valueOf() === localInput.valueOf();
            } else {
                inputMs = localInput.valueOf();
                return this.clone().startOf(units).valueOf() <= inputMs && inputMs <= this.clone().endOf(units).valueOf();
            }
        }

        function isSameOrAfter (input, units) {
            return this.isSame(input, units) || this.isAfter(input,units);
        }

        function isSameOrBefore (input, units) {
            return this.isSame(input, units) || this.isBefore(input,units);
        }

        function diff (input, units, asFloat) {
            var that,
                zoneDelta,
                delta, output;

            if (!this.isValid()) {
                return NaN;
            }

            that = cloneWithOffset(input, this);

            if (!that.isValid()) {
                return NaN;
            }

            zoneDelta = (that.utcOffset() - this.utcOffset()) * 6e4;

            units = normalizeUnits(units);

            if (units === 'year' || units === 'month' || units === 'quarter') {
                output = monthDiff(this, that);
                if (units === 'quarter') {
                    output = output / 3;
                } else if (units === 'year') {
                    output = output / 12;
                }
            } else {
                delta = this - that;
                output = units === 'second' ? delta / 1e3 : // 1000
                    units === 'minute' ? delta / 6e4 : // 1000 * 60
                        units === 'hour' ? delta / 36e5 : // 1000 * 60 * 60
                            units === 'day' ? (delta - zoneDelta) / 864e5 : // 1000 * 60 * 60 * 24, negate dst
                                units === 'week' ? (delta - zoneDelta) / 6048e5 : // 1000 * 60 * 60 * 24 * 7, negate dst
                                    delta;
            }
            return asFloat ? output : absFloor(output);
        }

        function monthDiff (a, b) {
            // difference in months
            var wholeMonthDiff = ((b.year() - a.year()) * 12) + (b.month() - a.month()),
            // b is in (anchor - 1 month, anchor + 1 month)
                anchor = a.clone().add(wholeMonthDiff, 'months'),
                anchor2, adjust;

            if (b - anchor < 0) {
                anchor2 = a.clone().add(wholeMonthDiff - 1, 'months');
                // linear across the month
                adjust = (b - anchor) / (anchor - anchor2);
            } else {
                anchor2 = a.clone().add(wholeMonthDiff + 1, 'months');
                // linear across the month
                adjust = (b - anchor) / (anchor2 - anchor);
            }

            //check for negative zero, return zero if negative zero
            return -(wholeMonthDiff + adjust) || 0;
        }

        utils_hooks__hooks.defaultFormat = 'YYYY-MM-DDTHH:mm:ssZ';
        utils_hooks__hooks.defaultFormatUtc = 'YYYY-MM-DDTHH:mm:ss[Z]';

        function toString () {
            return this.clone().locale('en').format('ddd MMM DD YYYY HH:mm:ss [GMT]ZZ');
        }

        function moment_format__toISOString () {
            var m = this.clone().utc();
            if (0 < m.year() && m.year() <= 9999) {
                if (isFunction(Date.prototype.toISOString)) {
                    // native implementation is ~50x faster, use it when we can
                    return this.toDate().toISOString();
                } else {
                    return formatMoment(m, 'YYYY-MM-DD[T]HH:mm:ss.SSS[Z]');
                }
            } else {
                return formatMoment(m, 'YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]');
            }
        }

        function format (inputString) {
            if (!inputString) {
                inputString = this.isUtc() ? utils_hooks__hooks.defaultFormatUtc : utils_hooks__hooks.defaultFormat;
            }
            var output = formatMoment(this, inputString);
            return this.localeData().postformat(output);
        }

        function from (time, withoutSuffix) {
            if (this.isValid() &&
                ((isMoment(time) && time.isValid()) ||
                local__createLocal(time).isValid())) {
                return create__createDuration({to: this, from: time}).locale(this.locale()).humanize(!withoutSuffix);
            } else {
                return this.localeData().invalidDate();
            }
        }

        function fromNow (withoutSuffix) {
            return this.from(local__createLocal(), withoutSuffix);
        }

        function to (time, withoutSuffix) {
            if (this.isValid() &&
                ((isMoment(time) && time.isValid()) ||
                local__createLocal(time).isValid())) {
                return create__createDuration({from: this, to: time}).locale(this.locale()).humanize(!withoutSuffix);
            } else {
                return this.localeData().invalidDate();
            }
        }

        function toNow (withoutSuffix) {
            return this.to(local__createLocal(), withoutSuffix);
        }

        // If passed a locale key, it will set the locale for this
        // instance.  Otherwise, it will return the locale configuration
        // variables for this instance.
        function locale (key) {
            var newLocaleData;

            if (key === undefined) {
                return this._locale._abbr;
            } else {
                newLocaleData = locale_locales__getLocale(key);
                if (newLocaleData != null) {
                    this._locale = newLocaleData;
                }
                return this;
            }
        }

        var lang = deprecate(
            'moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.',
            function (key) {
                if (key === undefined) {
                    return this.localeData();
                } else {
                    return this.locale(key);
                }
            }
        );

        function localeData () {
            return this._locale;
        }

        function startOf (units) {
            units = normalizeUnits(units);
            // the following switch intentionally omits break keywords
            // to utilize falling through the cases.
            switch (units) {
                case 'year':
                    this.month(0);
                /* falls through */
                case 'quarter':
                case 'month':
                    this.date(1);
                /* falls through */
                case 'week':
                case 'isoWeek':
                case 'day':
                case 'date':
                    this.hours(0);
                /* falls through */
                case 'hour':
                    this.minutes(0);
                /* falls through */
                case 'minute':
                    this.seconds(0);
                /* falls through */
                case 'second':
                    this.milliseconds(0);
            }

            // weeks are a special case
            if (units === 'week') {
                this.weekday(0);
            }
            if (units === 'isoWeek') {
                this.isoWeekday(1);
            }

            // quarters are also special
            if (units === 'quarter') {
                this.month(Math.floor(this.month() / 3) * 3);
            }

            return this;
        }

        function endOf (units) {
            units = normalizeUnits(units);
            if (units === undefined || units === 'millisecond') {
                return this;
            }

            // 'date' is an alias for 'day', so it should be considered as such.
            if (units === 'date') {
                units = 'day';
            }

            return this.startOf(units).add(1, (units === 'isoWeek' ? 'week' : units)).subtract(1, 'ms');
        }

        function to_type__valueOf () {
            return this._d.valueOf() - ((this._offset || 0) * 60000);
        }

        function unix () {
            return Math.floor(this.valueOf() / 1000);
        }

        function toDate () {
            return new Date(this.valueOf());
        }

        function toArray () {
            var m = this;
            return [m.year(), m.month(), m.date(), m.hour(), m.minute(), m.second(), m.millisecond()];
        }

        function toObject () {
            var m = this;
            return {
                years: m.year(),
                months: m.month(),
                date: m.date(),
                hours: m.hours(),
                minutes: m.minutes(),
                seconds: m.seconds(),
                milliseconds: m.milliseconds()
            };
        }

        function toJSON () {
            // new Date(NaN).toJSON() === null
            return this.isValid() ? this.toISOString() : null;
        }

        function moment_valid__isValid () {
            return valid__isValid(this);
        }

        function parsingFlags () {
            return extend({}, getParsingFlags(this));
        }

        function invalidAt () {
            return getParsingFlags(this).overflow;
        }

        function creationData() {
            return {
                input: this._i,
                format: this._f,
                locale: this._locale,
                isUTC: this._isUTC,
                strict: this._strict
            };
        }

        // FORMATTING

        addFormatToken(0, ['gg', 2], 0, function () {
            return this.weekYear() % 100;
        });

        addFormatToken(0, ['GG', 2], 0, function () {
            return this.isoWeekYear() % 100;
        });

        function addWeekYearFormatToken (token, getter) {
            addFormatToken(0, [token, token.length], 0, getter);
        }

        addWeekYearFormatToken('gggg',     'weekYear');
        addWeekYearFormatToken('ggggg',    'weekYear');
        addWeekYearFormatToken('GGGG',  'isoWeekYear');
        addWeekYearFormatToken('GGGGG', 'isoWeekYear');

        // ALIASES

        addUnitAlias('weekYear', 'gg');
        addUnitAlias('isoWeekYear', 'GG');

        // PRIORITY

        addUnitPriority('weekYear', 1);
        addUnitPriority('isoWeekYear', 1);


        // PARSING

        addRegexToken('G',      matchSigned);
        addRegexToken('g',      matchSigned);
        addRegexToken('GG',     match1to2, match2);
        addRegexToken('gg',     match1to2, match2);
        addRegexToken('GGGG',   match1to4, match4);
        addRegexToken('gggg',   match1to4, match4);
        addRegexToken('GGGGG',  match1to6, match6);
        addRegexToken('ggggg',  match1to6, match6);

        addWeekParseToken(['gggg', 'ggggg', 'GGGG', 'GGGGG'], function (input, week, config, token) {
            week[token.substr(0, 2)] = toInt(input);
        });

        addWeekParseToken(['gg', 'GG'], function (input, week, config, token) {
            week[token] = utils_hooks__hooks.parseTwoDigitYear(input);
        });

        // MOMENTS

        function getSetWeekYear (input) {
            return getSetWeekYearHelper.call(this,
                input,
                this.week(),
                this.weekday(),
                this.localeData()._week.dow,
                this.localeData()._week.doy);
        }

        function getSetISOWeekYear (input) {
            return getSetWeekYearHelper.call(this,
                input, this.isoWeek(), this.isoWeekday(), 1, 4);
        }

        function getISOWeeksInYear () {
            return weeksInYear(this.year(), 1, 4);
        }

        function getWeeksInYear () {
            var weekInfo = this.localeData()._week;
            return weeksInYear(this.year(), weekInfo.dow, weekInfo.doy);
        }

        function getSetWeekYearHelper(input, week, weekday, dow, doy) {
            var weeksTarget;
            if (input == null) {
                return weekOfYear(this, dow, doy).year;
            } else {
                weeksTarget = weeksInYear(input, dow, doy);
                if (week > weeksTarget) {
                    week = weeksTarget;
                }
                return setWeekAll.call(this, input, week, weekday, dow, doy);
            }
        }

        function setWeekAll(weekYear, week, weekday, dow, doy) {
            var dayOfYearData = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy),
                date = createUTCDate(dayOfYearData.year, 0, dayOfYearData.dayOfYear);

            this.year(date.getUTCFullYear());
            this.month(date.getUTCMonth());
            this.date(date.getUTCDate());
            return this;
        }

        // FORMATTING

        addFormatToken('Q', 0, 'Qo', 'quarter');

        // ALIASES

        addUnitAlias('quarter', 'Q');

        // PRIORITY

        addUnitPriority('quarter', 7);

        // PARSING

        addRegexToken('Q', match1);
        addParseToken('Q', function (input, array) {
            array[MONTH] = (toInt(input) - 1) * 3;
        });

        // MOMENTS

        function getSetQuarter (input) {
            return input == null ? Math.ceil((this.month() + 1) / 3) : this.month((input - 1) * 3 + this.month() % 3);
        }

        // FORMATTING

        addFormatToken('D', ['DD', 2], 'Do', 'date');

        // ALIASES

        addUnitAlias('date', 'D');

        // PRIOROITY
        addUnitPriority('date', 9);

        // PARSING

        addRegexToken('D',  match1to2);
        addRegexToken('DD', match1to2, match2);
        addRegexToken('Do', function (isStrict, locale) {
            return isStrict ? locale._ordinalParse : locale._ordinalParseLenient;
        });

        addParseToken(['D', 'DD'], DATE);
        addParseToken('Do', function (input, array) {
            array[DATE] = toInt(input.match(match1to2)[0], 10);
        });

        // MOMENTS

        var getSetDayOfMonth = makeGetSet('Date', true);

        // FORMATTING

        addFormatToken('DDD', ['DDDD', 3], 'DDDo', 'dayOfYear');

        // ALIASES

        addUnitAlias('dayOfYear', 'DDD');

        // PRIORITY
        addUnitPriority('dayOfYear', 4);

        // PARSING

        addRegexToken('DDD',  match1to3);
        addRegexToken('DDDD', match3);
        addParseToken(['DDD', 'DDDD'], function (input, array, config) {
            config._dayOfYear = toInt(input);
        });

        // HELPERS

        // MOMENTS

        function getSetDayOfYear (input) {
            var dayOfYear = Math.round((this.clone().startOf('day') - this.clone().startOf('year')) / 864e5) + 1;
            return input == null ? dayOfYear : this.add((input - dayOfYear), 'd');
        }

        // FORMATTING

        addFormatToken('m', ['mm', 2], 0, 'minute');

        // ALIASES

        addUnitAlias('minute', 'm');

        // PRIORITY

        addUnitPriority('minute', 14);

        // PARSING

        addRegexToken('m',  match1to2);
        addRegexToken('mm', match1to2, match2);
        addParseToken(['m', 'mm'], MINUTE);

        // MOMENTS

        var getSetMinute = makeGetSet('Minutes', false);

        // FORMATTING

        addFormatToken('s', ['ss', 2], 0, 'second');

        // ALIASES

        addUnitAlias('second', 's');

        // PRIORITY

        addUnitPriority('second', 15);

        // PARSING

        addRegexToken('s',  match1to2);
        addRegexToken('ss', match1to2, match2);
        addParseToken(['s', 'ss'], SECOND);

        // MOMENTS

        var getSetSecond = makeGetSet('Seconds', false);

        // FORMATTING

        addFormatToken('S', 0, 0, function () {
            return ~~(this.millisecond() / 100);
        });

        addFormatToken(0, ['SS', 2], 0, function () {
            return ~~(this.millisecond() / 10);
        });

        addFormatToken(0, ['SSS', 3], 0, 'millisecond');
        addFormatToken(0, ['SSSS', 4], 0, function () {
            return this.millisecond() * 10;
        });
        addFormatToken(0, ['SSSSS', 5], 0, function () {
            return this.millisecond() * 100;
        });
        addFormatToken(0, ['SSSSSS', 6], 0, function () {
            return this.millisecond() * 1000;
        });
        addFormatToken(0, ['SSSSSSS', 7], 0, function () {
            return this.millisecond() * 10000;
        });
        addFormatToken(0, ['SSSSSSSS', 8], 0, function () {
            return this.millisecond() * 100000;
        });
        addFormatToken(0, ['SSSSSSSSS', 9], 0, function () {
            return this.millisecond() * 1000000;
        });


        // ALIASES

        addUnitAlias('millisecond', 'ms');

        // PRIORITY

        addUnitPriority('millisecond', 16);

        // PARSING

        addRegexToken('S',    match1to3, match1);
        addRegexToken('SS',   match1to3, match2);
        addRegexToken('SSS',  match1to3, match3);

        var token;
        for (token = 'SSSS'; token.length <= 9; token += 'S') {
            addRegexToken(token, matchUnsigned);
        }

        function parseMs(input, array) {
            array[MILLISECOND] = toInt(('0.' + input) * 1000);
        }

        for (token = 'S'; token.length <= 9; token += 'S') {
            addParseToken(token, parseMs);
        }
        // MOMENTS

        var getSetMillisecond = makeGetSet('Milliseconds', false);

        // FORMATTING

        addFormatToken('z',  0, 0, 'zoneAbbr');
        addFormatToken('zz', 0, 0, 'zoneName');

        // MOMENTS

        function getZoneAbbr () {
            return this._isUTC ? 'UTC' : '';
        }

        function getZoneName () {
            return this._isUTC ? 'Coordinated Universal Time' : '';
        }

        var momentPrototype__proto = Moment.prototype;

        momentPrototype__proto.add               = add_subtract__add;
        momentPrototype__proto.calendar          = moment_calendar__calendar;
        momentPrototype__proto.clone             = clone;
        momentPrototype__proto.diff              = diff;
        momentPrototype__proto.endOf             = endOf;
        momentPrototype__proto.format            = format;
        momentPrototype__proto.from              = from;
        momentPrototype__proto.fromNow           = fromNow;
        momentPrototype__proto.to                = to;
        momentPrototype__proto.toNow             = toNow;
        momentPrototype__proto.get               = stringGet;
        momentPrototype__proto.invalidAt         = invalidAt;
        momentPrototype__proto.isAfter           = isAfter;
        momentPrototype__proto.isBefore          = isBefore;
        momentPrototype__proto.isBetween         = isBetween;
        momentPrototype__proto.isSame            = isSame;
        momentPrototype__proto.isSameOrAfter     = isSameOrAfter;
        momentPrototype__proto.isSameOrBefore    = isSameOrBefore;
        momentPrototype__proto.isValid           = moment_valid__isValid;
        momentPrototype__proto.lang              = lang;
        momentPrototype__proto.locale            = locale;
        momentPrototype__proto.localeData        = localeData;
        momentPrototype__proto.max               = prototypeMax;
        momentPrototype__proto.min               = prototypeMin;
        momentPrototype__proto.parsingFlags      = parsingFlags;
        momentPrototype__proto.set               = stringSet;
        momentPrototype__proto.startOf           = startOf;
        momentPrototype__proto.subtract          = add_subtract__subtract;
        momentPrototype__proto.toArray           = toArray;
        momentPrototype__proto.toObject          = toObject;
        momentPrototype__proto.toDate            = toDate;
        momentPrototype__proto.toISOString       = moment_format__toISOString;
        momentPrototype__proto.toJSON            = toJSON;
        momentPrototype__proto.toString          = toString;
        momentPrototype__proto.unix              = unix;
        momentPrototype__proto.valueOf           = to_type__valueOf;
        momentPrototype__proto.creationData      = creationData;

        // Year
        momentPrototype__proto.year       = getSetYear;
        momentPrototype__proto.isLeapYear = getIsLeapYear;

        // Week Year
        momentPrototype__proto.weekYear    = getSetWeekYear;
        momentPrototype__proto.isoWeekYear = getSetISOWeekYear;

        // Quarter
        momentPrototype__proto.quarter = momentPrototype__proto.quarters = getSetQuarter;

        // Month
        momentPrototype__proto.month       = getSetMonth;
        momentPrototype__proto.daysInMonth = getDaysInMonth;

        // Week
        momentPrototype__proto.week           = momentPrototype__proto.weeks        = getSetWeek;
        momentPrototype__proto.isoWeek        = momentPrototype__proto.isoWeeks     = getSetISOWeek;
        momentPrototype__proto.weeksInYear    = getWeeksInYear;
        momentPrototype__proto.isoWeeksInYear = getISOWeeksInYear;

        // Day
        momentPrototype__proto.date       = getSetDayOfMonth;
        momentPrototype__proto.day        = momentPrototype__proto.days             = getSetDayOfWeek;
        momentPrototype__proto.weekday    = getSetLocaleDayOfWeek;
        momentPrototype__proto.isoWeekday = getSetISODayOfWeek;
        momentPrototype__proto.dayOfYear  = getSetDayOfYear;

        // Hour
        momentPrototype__proto.hour = momentPrototype__proto.hours = getSetHour;

        // Minute
        momentPrototype__proto.minute = momentPrototype__proto.minutes = getSetMinute;

        // Second
        momentPrototype__proto.second = momentPrototype__proto.seconds = getSetSecond;

        // Millisecond
        momentPrototype__proto.millisecond = momentPrototype__proto.milliseconds = getSetMillisecond;

        // Offset
        momentPrototype__proto.utcOffset            = getSetOffset;
        momentPrototype__proto.utc                  = setOffsetToUTC;
        momentPrototype__proto.local                = setOffsetToLocal;
        momentPrototype__proto.parseZone            = setOffsetToParsedOffset;
        momentPrototype__proto.hasAlignedHourOffset = hasAlignedHourOffset;
        momentPrototype__proto.isDST                = isDaylightSavingTime;
        momentPrototype__proto.isLocal              = isLocal;
        momentPrototype__proto.isUtcOffset          = isUtcOffset;
        momentPrototype__proto.isUtc                = isUtc;
        momentPrototype__proto.isUTC                = isUtc;

        // Timezone
        momentPrototype__proto.zoneAbbr = getZoneAbbr;
        momentPrototype__proto.zoneName = getZoneName;

        // Deprecations
        momentPrototype__proto.dates  = deprecate('dates accessor is deprecated. Use date instead.', getSetDayOfMonth);
        momentPrototype__proto.months = deprecate('months accessor is deprecated. Use month instead', getSetMonth);
        momentPrototype__proto.years  = deprecate('years accessor is deprecated. Use year instead', getSetYear);
        momentPrototype__proto.zone   = deprecate('moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/', getSetZone);
        momentPrototype__proto.isDSTShifted = deprecate('isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information', isDaylightSavingTimeShifted);

        var momentPrototype = momentPrototype__proto;

        function moment__createUnix (input) {
            return local__createLocal(input * 1000);
        }

        function moment__createInZone () {
            return local__createLocal.apply(null, arguments).parseZone();
        }

        function preParsePostFormat (string) {
            return string;
        }

        var prototype__proto = Locale.prototype;

        prototype__proto.calendar        = locale_calendar__calendar;
        prototype__proto.longDateFormat  = longDateFormat;
        prototype__proto.invalidDate     = invalidDate;
        prototype__proto.ordinal         = ordinal;
        prototype__proto.preparse        = preParsePostFormat;
        prototype__proto.postformat      = preParsePostFormat;
        prototype__proto.relativeTime    = relative__relativeTime;
        prototype__proto.pastFuture      = pastFuture;
        prototype__proto.set             = locale_set__set;

        // Month
        prototype__proto.months            =        localeMonths;
        prototype__proto.monthsShort       =        localeMonthsShort;
        prototype__proto.monthsParse       =        localeMonthsParse;
        prototype__proto.monthsRegex       = monthsRegex;
        prototype__proto.monthsShortRegex  = monthsShortRegex;

        // Week
        prototype__proto.week = localeWeek;
        prototype__proto.firstDayOfYear = localeFirstDayOfYear;
        prototype__proto.firstDayOfWeek = localeFirstDayOfWeek;

        // Day of Week
        prototype__proto.weekdays       =        localeWeekdays;
        prototype__proto.weekdaysMin    =        localeWeekdaysMin;
        prototype__proto.weekdaysShort  =        localeWeekdaysShort;
        prototype__proto.weekdaysParse  =        localeWeekdaysParse;

        prototype__proto.weekdaysRegex       =        weekdaysRegex;
        prototype__proto.weekdaysShortRegex  =        weekdaysShortRegex;
        prototype__proto.weekdaysMinRegex    =        weekdaysMinRegex;

        // Hours
        prototype__proto.isPM = localeIsPM;
        prototype__proto.meridiem = localeMeridiem;

        function lists__get (format, index, field, setter) {
            var locale = locale_locales__getLocale();
            var utc = create_utc__createUTC().set(setter, index);
            return locale[field](utc, format);
        }

        function listMonthsImpl (format, index, field) {
            if (typeof format === 'number') {
                index = format;
                format = undefined;
            }

            format = format || '';

            if (index != null) {
                return lists__get(format, index, field, 'month');
            }

            var i;
            var out = [];
            for (i = 0; i < 12; i++) {
                out[i] = lists__get(format, i, field, 'month');
            }
            return out;
        }

        // ()
        // (5)
        // (fmt, 5)
        // (fmt)
        // (true)
        // (true, 5)
        // (true, fmt, 5)
        // (true, fmt)
        function listWeekdaysImpl (localeSorted, format, index, field) {
            if (typeof localeSorted === 'boolean') {
                if (typeof format === 'number') {
                    index = format;
                    format = undefined;
                }

                format = format || '';
            } else {
                format = localeSorted;
                index = format;
                localeSorted = false;

                if (typeof format === 'number') {
                    index = format;
                    format = undefined;
                }

                format = format || '';
            }

            var locale = locale_locales__getLocale(),
                shift = localeSorted ? locale._week.dow : 0;

            if (index != null) {
                return lists__get(format, (index + shift) % 7, field, 'day');
            }

            var i;
            var out = [];
            for (i = 0; i < 7; i++) {
                out[i] = lists__get(format, (i + shift) % 7, field, 'day');
            }
            return out;
        }

        function lists__listMonths (format, index) {
            return listMonthsImpl(format, index, 'months');
        }

        function lists__listMonthsShort (format, index) {
            return listMonthsImpl(format, index, 'monthsShort');
        }

        function lists__listWeekdays (localeSorted, format, index) {
            return listWeekdaysImpl(localeSorted, format, index, 'weekdays');
        }

        function lists__listWeekdaysShort (localeSorted, format, index) {
            return listWeekdaysImpl(localeSorted, format, index, 'weekdaysShort');
        }

        function lists__listWeekdaysMin (localeSorted, format, index) {
            return listWeekdaysImpl(localeSorted, format, index, 'weekdaysMin');
        }

        locale_locales__getSetGlobalLocale('en', {
            ordinalParse: /\d{1,2}(th|st|nd|rd)/,
            ordinal : function (number) {
                var b = number % 10,
                    output = (toInt(number % 100 / 10) === 1) ? 'th' :
                        (b === 1) ? 'st' :
                            (b === 2) ? 'nd' :
                                (b === 3) ? 'rd' : 'th';
                return number + output;
            }
        });

        // Side effect imports
        utils_hooks__hooks.lang = deprecate('moment.lang is deprecated. Use moment.locale instead.', locale_locales__getSetGlobalLocale);
        utils_hooks__hooks.langData = deprecate('moment.langData is deprecated. Use moment.localeData instead.', locale_locales__getLocale);

        var mathAbs = Math.abs;

        function duration_abs__abs () {
            var data           = this._data;

            this._milliseconds = mathAbs(this._milliseconds);
            this._days         = mathAbs(this._days);
            this._months       = mathAbs(this._months);

            data.milliseconds  = mathAbs(data.milliseconds);
            data.seconds       = mathAbs(data.seconds);
            data.minutes       = mathAbs(data.minutes);
            data.hours         = mathAbs(data.hours);
            data.months        = mathAbs(data.months);
            data.years         = mathAbs(data.years);

            return this;
        }

        function duration_add_subtract__addSubtract (duration, input, value, direction) {
            var other = create__createDuration(input, value);

            duration._milliseconds += direction * other._milliseconds;
            duration._days         += direction * other._days;
            duration._months       += direction * other._months;

            return duration._bubble();
        }

        // supports only 2.0-style add(1, 's') or add(duration)
        function duration_add_subtract__add (input, value) {
            return duration_add_subtract__addSubtract(this, input, value, 1);
        }

        // supports only 2.0-style subtract(1, 's') or subtract(duration)
        function duration_add_subtract__subtract (input, value) {
            return duration_add_subtract__addSubtract(this, input, value, -1);
        }

        function absCeil (number) {
            if (number < 0) {
                return Math.floor(number);
            } else {
                return Math.ceil(number);
            }
        }

        function bubble () {
            var milliseconds = this._milliseconds;
            var days         = this._days;
            var months       = this._months;
            var data         = this._data;
            var seconds, minutes, hours, years, monthsFromDays;

            // if we have a mix of positive and negative values, bubble down first
            // check: https://github.com/moment/moment/issues/2166
            if (!((milliseconds >= 0 && days >= 0 && months >= 0) ||
                (milliseconds <= 0 && days <= 0 && months <= 0))) {
                milliseconds += absCeil(monthsToDays(months) + days) * 864e5;
                days = 0;
                months = 0;
            }

            // The following code bubbles up values, see the tests for
            // examples of what that means.
            data.milliseconds = milliseconds % 1000;

            seconds           = absFloor(milliseconds / 1000);
            data.seconds      = seconds % 60;

            minutes           = absFloor(seconds / 60);
            data.minutes      = minutes % 60;

            hours             = absFloor(minutes / 60);
            data.hours        = hours % 24;

            days += absFloor(hours / 24);

            // convert days to months
            monthsFromDays = absFloor(daysToMonths(days));
            months += monthsFromDays;
            days -= absCeil(monthsToDays(monthsFromDays));

            // 12 months -> 1 year
            years = absFloor(months / 12);
            months %= 12;

            data.days   = days;
            data.months = months;
            data.years  = years;

            return this;
        }

        function daysToMonths (days) {
            // 400 years have 146097 days (taking into account leap year rules)
            // 400 years have 12 months === 4800
            return days * 4800 / 146097;
        }

        function monthsToDays (months) {
            // the reverse of daysToMonths
            return months * 146097 / 4800;
        }

        function as (units) {
            var days;
            var months;
            var milliseconds = this._milliseconds;

            units = normalizeUnits(units);

            if (units === 'month' || units === 'year') {
                days   = this._days   + milliseconds / 864e5;
                months = this._months + daysToMonths(days);
                return units === 'month' ? months : months / 12;
            } else {
                // handle milliseconds separately because of floating point math errors (issue #1867)
                days = this._days + Math.round(monthsToDays(this._months));
                switch (units) {
                    case 'week'   : return days / 7     + milliseconds / 6048e5;
                    case 'day'    : return days         + milliseconds / 864e5;
                    case 'hour'   : return days * 24    + milliseconds / 36e5;
                    case 'minute' : return days * 1440  + milliseconds / 6e4;
                    case 'second' : return days * 86400 + milliseconds / 1000;
                    // Math.floor prevents floating point math errors here
                    case 'millisecond': return Math.floor(days * 864e5) + milliseconds;
                    default: throw new Error('Unknown unit ' + units);
                }
            }
        }

        // TODO: Use this.as('ms')?
        function duration_as__valueOf () {
            return (
                this._milliseconds +
                this._days * 864e5 +
                (this._months % 12) * 2592e6 +
                toInt(this._months / 12) * 31536e6
            );
        }

        function makeAs (alias) {
            return function () {
                return this.as(alias);
            };
        }

        var asMilliseconds = makeAs('ms');
        var asSeconds      = makeAs('s');
        var asMinutes      = makeAs('m');
        var asHours        = makeAs('h');
        var asDays         = makeAs('d');
        var asWeeks        = makeAs('w');
        var asMonths       = makeAs('M');
        var asYears        = makeAs('y');

        function duration_get__get (units) {
            units = normalizeUnits(units);
            return this[units + 's']();
        }

        function makeGetter(name) {
            return function () {
                return this._data[name];
            };
        }

        var milliseconds = makeGetter('milliseconds');
        var seconds      = makeGetter('seconds');
        var minutes      = makeGetter('minutes');
        var hours        = makeGetter('hours');
        var days         = makeGetter('days');
        var months       = makeGetter('months');
        var years        = makeGetter('years');

        function weeks () {
            return absFloor(this.days() / 7);
        }

        var round = Math.round;
        var thresholds = {
            s: 45,  // seconds to minute
            m: 45,  // minutes to hour
            h: 22,  // hours to day
            d: 26,  // days to month
            M: 11   // months to year
        };

        // helper function for moment.fn.from, moment.fn.fromNow, and moment.duration.fn.humanize
        function substituteTimeAgo(string, number, withoutSuffix, isFuture, locale) {
            return locale.relativeTime(number || 1, !!withoutSuffix, string, isFuture);
        }

        function duration_humanize__relativeTime (posNegDuration, withoutSuffix, locale) {
            var duration = create__createDuration(posNegDuration).abs();
            var seconds  = round(duration.as('s'));
            var minutes  = round(duration.as('m'));
            var hours    = round(duration.as('h'));
            var days     = round(duration.as('d'));
            var months   = round(duration.as('M'));
            var years    = round(duration.as('y'));

            var a = seconds < thresholds.s && ['s', seconds]  ||
                minutes <= 1           && ['m']           ||
                minutes < thresholds.m && ['mm', minutes] ||
                hours   <= 1           && ['h']           ||
                hours   < thresholds.h && ['hh', hours]   ||
                days    <= 1           && ['d']           ||
                days    < thresholds.d && ['dd', days]    ||
                months  <= 1           && ['M']           ||
                months  < thresholds.M && ['MM', months]  ||
                years   <= 1           && ['y']           || ['yy', years];

            a[2] = withoutSuffix;
            a[3] = +posNegDuration > 0;
            a[4] = locale;
            return substituteTimeAgo.apply(null, a);
        }

        // This function allows you to set the rounding function for relative time strings
        function duration_humanize__getSetRelativeTimeRounding (roundingFunction) {
            if (roundingFunction === undefined) {
                return round;
            }
            if (typeof(roundingFunction) === 'function') {
                round = roundingFunction;
                return true;
            }
            return false;
        }

        // This function allows you to set a threshold for relative time strings
        function duration_humanize__getSetRelativeTimeThreshold (threshold, limit) {
            if (thresholds[threshold] === undefined) {
                return false;
            }
            if (limit === undefined) {
                return thresholds[threshold];
            }
            thresholds[threshold] = limit;
            return true;
        }

        function humanize (withSuffix) {
            var locale = this.localeData();
            var output = duration_humanize__relativeTime(this, !withSuffix, locale);

            if (withSuffix) {
                output = locale.pastFuture(+this, output);
            }

            return locale.postformat(output);
        }

        var iso_string__abs = Math.abs;

        function iso_string__toISOString() {
            // for ISO strings we do not use the normal bubbling rules:
            //  * milliseconds bubble up until they become hours
            //  * days do not bubble at all
            //  * months bubble up until they become years
            // This is because there is no context-free conversion between hours and days
            // (think of clock changes)
            // and also not between days and months (28-31 days per month)
            var seconds = iso_string__abs(this._milliseconds) / 1000;
            var days         = iso_string__abs(this._days);
            var months       = iso_string__abs(this._months);
            var minutes, hours, years;

            // 3600 seconds -> 60 minutes -> 1 hour
            minutes           = absFloor(seconds / 60);
            hours             = absFloor(minutes / 60);
            seconds %= 60;
            minutes %= 60;

            // 12 months -> 1 year
            years  = absFloor(months / 12);
            months %= 12;


            // inspired by https://github.com/dordille/moment-isoduration/blob/master/moment.isoduration.js
            var Y = years;
            var M = months;
            var D = days;
            var h = hours;
            var m = minutes;
            var s = seconds;
            var total = this.asSeconds();

            if (!total) {
                // this is the same as C#'s (Noda) and python (isodate)...
                // but not other JS (goog.date)
                return 'P0D';
            }

            return (total < 0 ? '-' : '') +
                'P' +
                (Y ? Y + 'Y' : '') +
                (M ? M + 'M' : '') +
                (D ? D + 'D' : '') +
                ((h || m || s) ? 'T' : '') +
                (h ? h + 'H' : '') +
                (m ? m + 'M' : '') +
                (s ? s + 'S' : '');
        }

        var duration_prototype__proto = Duration.prototype;

        duration_prototype__proto.abs            = duration_abs__abs;
        duration_prototype__proto.add            = duration_add_subtract__add;
        duration_prototype__proto.subtract       = duration_add_subtract__subtract;
        duration_prototype__proto.as             = as;
        duration_prototype__proto.asMilliseconds = asMilliseconds;
        duration_prototype__proto.asSeconds      = asSeconds;
        duration_prototype__proto.asMinutes      = asMinutes;
        duration_prototype__proto.asHours        = asHours;
        duration_prototype__proto.asDays         = asDays;
        duration_prototype__proto.asWeeks        = asWeeks;
        duration_prototype__proto.asMonths       = asMonths;
        duration_prototype__proto.asYears        = asYears;
        duration_prototype__proto.valueOf        = duration_as__valueOf;
        duration_prototype__proto._bubble        = bubble;
        duration_prototype__proto.get            = duration_get__get;
        duration_prototype__proto.milliseconds   = milliseconds;
        duration_prototype__proto.seconds        = seconds;
        duration_prototype__proto.minutes        = minutes;
        duration_prototype__proto.hours          = hours;
        duration_prototype__proto.days           = days;
        duration_prototype__proto.weeks          = weeks;
        duration_prototype__proto.months         = months;
        duration_prototype__proto.years          = years;
        duration_prototype__proto.humanize       = humanize;
        duration_prototype__proto.toISOString    = iso_string__toISOString;
        duration_prototype__proto.toString       = iso_string__toISOString;
        duration_prototype__proto.toJSON         = iso_string__toISOString;
        duration_prototype__proto.locale         = locale;
        duration_prototype__proto.localeData     = localeData;

        // Deprecations
        duration_prototype__proto.toIsoString = deprecate('toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)', iso_string__toISOString);
        duration_prototype__proto.lang = lang;

        // Side effect imports

        // FORMATTING

        addFormatToken('X', 0, 0, 'unix');
        addFormatToken('x', 0, 0, 'valueOf');

        // PARSING

        addRegexToken('x', matchSigned);
        addRegexToken('X', matchTimestamp);
        addParseToken('X', function (input, array, config) {
            config._d = new Date(parseFloat(input, 10) * 1000);
        });
        addParseToken('x', function (input, array, config) {
            config._d = new Date(toInt(input));
        });

        // Side effect imports


        utils_hooks__hooks.version = '2.15.1';

        setHookCallback(local__createLocal);

        utils_hooks__hooks.fn                    = momentPrototype;
        utils_hooks__hooks.min                   = min;
        utils_hooks__hooks.max                   = max;
        utils_hooks__hooks.now                   = now;
        utils_hooks__hooks.utc                   = create_utc__createUTC;
        utils_hooks__hooks.unix                  = moment__createUnix;
        utils_hooks__hooks.months                = lists__listMonths;
        utils_hooks__hooks.isDate                = isDate;
        utils_hooks__hooks.locale                = locale_locales__getSetGlobalLocale;
        utils_hooks__hooks.invalid               = valid__createInvalid;
        utils_hooks__hooks.duration              = create__createDuration;
        utils_hooks__hooks.isMoment              = isMoment;
        utils_hooks__hooks.weekdays              = lists__listWeekdays;
        utils_hooks__hooks.parseZone             = moment__createInZone;
        utils_hooks__hooks.localeData            = locale_locales__getLocale;
        utils_hooks__hooks.isDuration            = isDuration;
        utils_hooks__hooks.monthsShort           = lists__listMonthsShort;
        utils_hooks__hooks.weekdaysMin           = lists__listWeekdaysMin;
        utils_hooks__hooks.defineLocale          = defineLocale;
        utils_hooks__hooks.updateLocale          = updateLocale;
        utils_hooks__hooks.locales               = locale_locales__listLocales;
        utils_hooks__hooks.weekdaysShort         = lists__listWeekdaysShort;
        utils_hooks__hooks.normalizeUnits        = normalizeUnits;
        utils_hooks__hooks.relativeTimeRounding = duration_humanize__getSetRelativeTimeRounding;
        utils_hooks__hooks.relativeTimeThreshold = duration_humanize__getSetRelativeTimeThreshold;
        utils_hooks__hooks.calendarFormat        = getCalendarFormat;
        utils_hooks__hooks.prototype             = momentPrototype;

        var _moment = utils_hooks__hooks;

        return _moment;

    }));
},{}],7:[function(require,module,exports){
    /**
     * @namespace Chart
     */
    var Chart = require(27)();

    require(26)(Chart);
    require(22)(Chart);
    require(25)(Chart);
    require(21)(Chart);
    require(23)(Chart);
    require(24)(Chart);
    require(28)(Chart);
    require(32)(Chart);
    require(30)(Chart);
    require(31)(Chart);
    require(33)(Chart);
    require(29)(Chart);
    require(34)(Chart);

    require(35)(Chart);
    require(36)(Chart);
    require(37)(Chart);
    require(38)(Chart);

    require(41)(Chart);
    require(39)(Chart);
    require(40)(Chart);
    require(42)(Chart);
    require(43)(Chart);
    require(44)(Chart);

// Controllers must be loaded after elements
// See Chart.core.datasetController.dataElementType
    require(15)(Chart);
    require(16)(Chart);
    require(17)(Chart);
    require(18)(Chart);
    require(19)(Chart);
    require(20)(Chart);

    require(8)(Chart);
    require(9)(Chart);
    require(10)(Chart);
    require(11)(Chart);
    require(12)(Chart);
    require(13)(Chart);
    require(14)(Chart);

    window.Chart = module.exports = Chart;

},{"10":10,"11":11,"12":12,"13":13,"14":14,"15":15,"16":16,"17":17,"18":18,"19":19,"20":20,"21":21,"22":22,"23":23,"24":24,"25":25,"26":26,"27":27,"28":28,"29":29,"30":30,"31":31,"32":32,"33":33,"34":34,"35":35,"36":36,"37":37,"38":38,"39":39,"40":40,"41":41,"42":42,"43":43,"44":44,"8":8,"9":9}],8:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        Chart.Bar = function(context, config) {
            config.type = 'bar';

            return new Chart(context, config);
        };

    };

},{}],9:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        Chart.Bubble = function(context, config) {
            config.type = 'bubble';
            return new Chart(context, config);
        };

    };

},{}],10:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        Chart.Doughnut = function(context, config) {
            config.type = 'doughnut';

            return new Chart(context, config);
        };

    };

},{}],11:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        Chart.Line = function(context, config) {
            config.type = 'line';

            return new Chart(context, config);
        };

    };

},{}],12:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        Chart.PolarArea = function(context, config) {
            config.type = 'polarArea';

            return new Chart(context, config);
        };

    };

},{}],13:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        Chart.Radar = function(context, config) {
            config.options = Chart.helpers.configMerge({aspectRatio: 1}, config.options);
            config.type = 'radar';

            return new Chart(context, config);
        };

    };

},{}],14:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var defaultConfig = {
            hover: {
                mode: 'single'
            },

            scales: {
                xAxes: [{
                    type: 'linear', // scatter should not use a category axis
                    position: 'bottom',
                    id: 'x-axis-1' // need an ID so datasets can reference the scale
                }],
                yAxes: [{
                    type: 'linear',
                    position: 'left',
                    id: 'y-axis-1'
                }]
            },

            tooltips: {
                callbacks: {
                    title: function() {
                        // Title doesn't make sense for scatter since we format the data as a point
                        return '';
                    },
                    label: function(tooltipItem) {
                        return '(' + tooltipItem.xLabel + ', ' + tooltipItem.yLabel + ')';
                    }
                }
            }
        };

        // Register the default config for this type
        Chart.defaults.scatter = defaultConfig;

        // Scatter charts use line controllers
        Chart.controllers.scatter = Chart.controllers.line;

        Chart.Scatter = function(context, config) {
            config.type = 'scatter';
            return new Chart(context, config);
        };

    };

},{}],15:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;

        Chart.defaults.bar = {
            hover: {
                mode: 'label'
            },

            scales: {
                xAxes: [{
                    type: 'category',

                    // Specific to Bar Controller
                    categoryPercentage: 0.8,
                    barPercentage: 0.9,

                    // grid line settings
                    gridLines: {
                        offsetGridLines: true
                    }
                }],
                yAxes: [{
                    type: 'linear'
                }]
            }
        };

        Chart.controllers.bar = Chart.DatasetController.extend({

            dataElementType: Chart.elements.Rectangle,

            initialize: function(chart, datasetIndex) {
                Chart.DatasetController.prototype.initialize.call(this, chart, datasetIndex);

                // Use this to indicate that this is a bar dataset.
                this.getMeta().bar = true;
            },

            // Get the number of datasets that display bars. We use this to correctly calculate the bar width
            getBarCount: function() {
                var me = this;
                var barCount = 0;
                helpers.each(me.chart.data.datasets, function(dataset, datasetIndex) {
                    var meta = me.chart.getDatasetMeta(datasetIndex);
                    if (meta.bar && me.chart.isDatasetVisible(datasetIndex)) {
                        ++barCount;
                    }
                }, me);
                return barCount;
            },

            update: function(reset) {
                var me = this;
                helpers.each(me.getMeta().data, function(rectangle, index) {
                    me.updateElement(rectangle, index, reset);
                }, me);
            },

            updateElement: function(rectangle, index, reset) {
                var me = this;
                var meta = me.getMeta();
                var xScale = me.getScaleForId(meta.xAxisID);
                var yScale = me.getScaleForId(meta.yAxisID);
                var scaleBase = yScale.getBasePixel();
                var rectangleElementOptions = me.chart.options.elements.rectangle;
                var custom = rectangle.custom || {};
                var dataset = me.getDataset();

                helpers.extend(rectangle, {
                    // Utility
                    _xScale: xScale,
                    _yScale: yScale,
                    _datasetIndex: me.index,
                    _index: index,

                    // Desired view properties
                    _model: {
                        x: me.calculateBarX(index, me.index),
                        y: reset ? scaleBase : me.calculateBarY(index, me.index),

                        // Tooltip
                        label: me.chart.data.labels[index],
                        datasetLabel: dataset.label,

                        // Appearance
                        base: reset ? scaleBase : me.calculateBarBase(me.index, index),
                        width: me.calculateBarWidth(index),
                        backgroundColor: custom.backgroundColor ? custom.backgroundColor : helpers.getValueAtIndexOrDefault(dataset.backgroundColor, index, rectangleElementOptions.backgroundColor),
                        borderSkipped: custom.borderSkipped ? custom.borderSkipped : rectangleElementOptions.borderSkipped,
                        borderColor: custom.borderColor ? custom.borderColor : helpers.getValueAtIndexOrDefault(dataset.borderColor, index, rectangleElementOptions.borderColor),
                        borderWidth: custom.borderWidth ? custom.borderWidth : helpers.getValueAtIndexOrDefault(dataset.borderWidth, index, rectangleElementOptions.borderWidth)
                    }
                });
                rectangle.pivot();
            },

            calculateBarBase: function(datasetIndex, index) {
                var me = this;
                var meta = me.getMeta();
                var yScale = me.getScaleForId(meta.yAxisID);
                var base = 0;

                if (yScale.options.stacked) {
                    var chart = me.chart;
                    var datasets = chart.data.datasets;
                    var value = Number(datasets[datasetIndex].data[index]);

                    for (var i = 0; i < datasetIndex; i++) {
                        var currentDs = datasets[i];
                        var currentDsMeta = chart.getDatasetMeta(i);
                        if (currentDsMeta.bar && currentDsMeta.yAxisID === yScale.id && chart.isDatasetVisible(i)) {
                            var currentVal = Number(currentDs.data[index]);
                            base += value < 0 ? Math.min(currentVal, 0) : Math.max(currentVal, 0);
                        }
                    }

                    return yScale.getPixelForValue(base);
                }

                return yScale.getBasePixel();
            },

            getRuler: function(index) {
                var me = this;
                var meta = me.getMeta();
                var xScale = me.getScaleForId(meta.xAxisID);
                var datasetCount = me.getBarCount();

                var tickWidth;

                if (xScale.options.type === 'category') {
                    tickWidth = xScale.getPixelForTick(index + 1) - xScale.getPixelForTick(index);
                } else {
                    // Average width
                    tickWidth = xScale.width / xScale.ticks.length;
                }
                var categoryWidth = tickWidth * xScale.options.categoryPercentage;
                var categorySpacing = (tickWidth - (tickWidth * xScale.options.categoryPercentage)) / 2;
                var fullBarWidth = categoryWidth / datasetCount;

                if (xScale.ticks.length !== me.chart.data.labels.length) {
                    var perc = xScale.ticks.length / me.chart.data.labels.length;
                    fullBarWidth = fullBarWidth * perc;
                }

                var barWidth = fullBarWidth * xScale.options.barPercentage;
                var barSpacing = fullBarWidth - (fullBarWidth * xScale.options.barPercentage);

                return {
                    datasetCount: datasetCount,
                    tickWidth: tickWidth,
                    categoryWidth: categoryWidth,
                    categorySpacing: categorySpacing,
                    fullBarWidth: fullBarWidth,
                    barWidth: barWidth,
                    barSpacing: barSpacing
                };
            },

            calculateBarWidth: function(index) {
                var xScale = this.getScaleForId(this.getMeta().xAxisID);
                if (xScale.options.barThickness) {
                    return xScale.options.barThickness;
                }
                var ruler = this.getRuler(index);
                return xScale.options.stacked ? ruler.categoryWidth : ruler.barWidth;
            },

            // Get bar index from the given dataset index accounting for the fact that not all bars are visible
            getBarIndex: function(datasetIndex) {
                var barIndex = 0;
                var meta, j;

                for (j = 0; j < datasetIndex; ++j) {
                    meta = this.chart.getDatasetMeta(j);
                    if (meta.bar && this.chart.isDatasetVisible(j)) {
                        ++barIndex;
                    }
                }

                return barIndex;
            },

            calculateBarX: function(index, datasetIndex) {
                var me = this;
                var meta = me.getMeta();
                var xScale = me.getScaleForId(meta.xAxisID);
                var barIndex = me.getBarIndex(datasetIndex);

                var ruler = me.getRuler(index);
                var leftTick = xScale.getPixelForValue(null, index, datasetIndex, me.chart.isCombo);
                leftTick -= me.chart.isCombo ? (ruler.tickWidth / 2) : 0;

                if (xScale.options.stacked) {
                    return leftTick + (ruler.categoryWidth / 2) + ruler.categorySpacing;
                }

                return leftTick +
                    (ruler.barWidth / 2) +
                    ruler.categorySpacing +
                    (ruler.barWidth * barIndex) +
                    (ruler.barSpacing / 2) +
                    (ruler.barSpacing * barIndex);
            },

            calculateBarY: function(index, datasetIndex) {
                var me = this;
                var meta = me.getMeta();
                var yScale = me.getScaleForId(meta.yAxisID);
                var value = Number(me.getDataset().data[index]);

                if (yScale.options.stacked) {

                    var sumPos = 0,
                        sumNeg = 0;

                    for (var i = 0; i < datasetIndex; i++) {
                        var ds = me.chart.data.datasets[i];
                        var dsMeta = me.chart.getDatasetMeta(i);
                        if (dsMeta.bar && dsMeta.yAxisID === yScale.id && me.chart.isDatasetVisible(i)) {
                            var stackedVal = Number(ds.data[index]);
                            if (stackedVal < 0) {
                                sumNeg += stackedVal || 0;
                            } else {
                                sumPos += stackedVal || 0;
                            }
                        }
                    }

                    if (value < 0) {
                        return yScale.getPixelForValue(sumNeg + value);
                    }
                    return yScale.getPixelForValue(sumPos + value);
                }

                return yScale.getPixelForValue(value);
            },

            draw: function(ease) {
                var me = this;
                var easingDecimal = ease || 1;
                helpers.each(me.getMeta().data, function(rectangle, index) {
                    var d = me.getDataset().data[index];
                    if (d !== null && d !== undefined && !isNaN(d)) {
                        rectangle.transition(easingDecimal).draw();
                    }
                }, me);
            },

            setHoverStyle: function(rectangle) {
                var dataset = this.chart.data.datasets[rectangle._datasetIndex];
                var index = rectangle._index;

                var custom = rectangle.custom || {};
                var model = rectangle._model;
                model.backgroundColor = custom.hoverBackgroundColor ? custom.hoverBackgroundColor : helpers.getValueAtIndexOrDefault(dataset.hoverBackgroundColor, index, helpers.getHoverColor(model.backgroundColor));
                model.borderColor = custom.hoverBorderColor ? custom.hoverBorderColor : helpers.getValueAtIndexOrDefault(dataset.hoverBorderColor, index, helpers.getHoverColor(model.borderColor));
                model.borderWidth = custom.hoverBorderWidth ? custom.hoverBorderWidth : helpers.getValueAtIndexOrDefault(dataset.hoverBorderWidth, index, model.borderWidth);
            },

            removeHoverStyle: function(rectangle) {
                var dataset = this.chart.data.datasets[rectangle._datasetIndex];
                var index = rectangle._index;
                var custom = rectangle.custom || {};
                var model = rectangle._model;
                var rectangleElementOptions = this.chart.options.elements.rectangle;

                model.backgroundColor = custom.backgroundColor ? custom.backgroundColor : helpers.getValueAtIndexOrDefault(dataset.backgroundColor, index, rectangleElementOptions.backgroundColor);
                model.borderColor = custom.borderColor ? custom.borderColor : helpers.getValueAtIndexOrDefault(dataset.borderColor, index, rectangleElementOptions.borderColor);
                model.borderWidth = custom.borderWidth ? custom.borderWidth : helpers.getValueAtIndexOrDefault(dataset.borderWidth, index, rectangleElementOptions.borderWidth);
            }

        });


        // including horizontalBar in the bar file, instead of a file of its own
        // it extends bar (like pie extends doughnut)
        Chart.defaults.horizontalBar = {
            hover: {
                mode: 'label'
            },

            scales: {
                xAxes: [{
                    type: 'linear',
                    position: 'bottom'
                }],
                yAxes: [{
                    position: 'left',
                    type: 'category',

                    // Specific to Horizontal Bar Controller
                    categoryPercentage: 0.8,
                    barPercentage: 0.9,

                    // grid line settings
                    gridLines: {
                        offsetGridLines: true
                    }
                }]
            },
            elements: {
                rectangle: {
                    borderSkipped: 'left'
                }
            },
            tooltips: {
                callbacks: {
                    title: function(tooltipItems, data) {
                        // Pick first xLabel for now
                        var title = '';

                        if (tooltipItems.length > 0) {
                            if (tooltipItems[0].yLabel) {
                                title = tooltipItems[0].yLabel;
                            } else if (data.labels.length > 0 && tooltipItems[0].index < data.labels.length) {
                                title = data.labels[tooltipItems[0].index];
                            }
                        }

                        return title;
                    },
                    label: function(tooltipItem, data) {
                        var datasetLabel = data.datasets[tooltipItem.datasetIndex].label || '';
                        return datasetLabel + ': ' + tooltipItem.xLabel;
                    }
                }
            }
        };

        Chart.controllers.horizontalBar = Chart.controllers.bar.extend({
            updateElement: function(rectangle, index, reset) {
                var me = this;
                var meta = me.getMeta();
                var xScale = me.getScaleForId(meta.xAxisID);
                var yScale = me.getScaleForId(meta.yAxisID);
                var scaleBase = xScale.getBasePixel();
                var custom = rectangle.custom || {};
                var dataset = me.getDataset();
                var rectangleElementOptions = me.chart.options.elements.rectangle;

                helpers.extend(rectangle, {
                    // Utility
                    _xScale: xScale,
                    _yScale: yScale,
                    _datasetIndex: me.index,
                    _index: index,

                    // Desired view properties
                    _model: {
                        x: reset ? scaleBase : me.calculateBarX(index, me.index),
                        y: me.calculateBarY(index, me.index),

                        // Tooltip
                        label: me.chart.data.labels[index],
                        datasetLabel: dataset.label,

                        // Appearance
                        base: reset ? scaleBase : me.calculateBarBase(me.index, index),
                        height: me.calculateBarHeight(index),
                        backgroundColor: custom.backgroundColor ? custom.backgroundColor : helpers.getValueAtIndexOrDefault(dataset.backgroundColor, index, rectangleElementOptions.backgroundColor),
                        borderSkipped: custom.borderSkipped ? custom.borderSkipped : rectangleElementOptions.borderSkipped,
                        borderColor: custom.borderColor ? custom.borderColor : helpers.getValueAtIndexOrDefault(dataset.borderColor, index, rectangleElementOptions.borderColor),
                        borderWidth: custom.borderWidth ? custom.borderWidth : helpers.getValueAtIndexOrDefault(dataset.borderWidth, index, rectangleElementOptions.borderWidth)
                    },

                    draw: function() {
                        var ctx = this._chart.ctx;
                        var vm = this._view;

                        var halfHeight = vm.height / 2,
                            topY = vm.y - halfHeight,
                            bottomY = vm.y + halfHeight,
                            right = vm.base - (vm.base - vm.x),
                            halfStroke = vm.borderWidth / 2;

                        // Canvas doesn't allow us to stroke inside the width so we can
                        // adjust the sizes to fit if we're setting a stroke on the line
                        if (vm.borderWidth) {
                            topY += halfStroke;
                            bottomY -= halfStroke;
                            right += halfStroke;
                        }

                        ctx.beginPath();

                        ctx.fillStyle = vm.backgroundColor;
                        ctx.strokeStyle = vm.borderColor;
                        ctx.lineWidth = vm.borderWidth;

                        // Corner points, from bottom-left to bottom-right clockwise
                        // | 1 2 |
                        // | 0 3 |
                        var corners = [
                            [vm.base, bottomY],
                            [vm.base, topY],
                            [right, topY],
                            [right, bottomY]
                        ];

                        // Find first (starting) corner with fallback to 'bottom'
                        var borders = ['bottom', 'left', 'top', 'right'];
                        var startCorner = borders.indexOf(vm.borderSkipped, 0);
                        if (startCorner === -1) {
                            startCorner = 0;
                        }

                        function cornerAt(cornerIndex) {
                            return corners[(startCorner + cornerIndex) % 4];
                        }

                        // Draw rectangle from 'startCorner'
                        ctx.moveTo.apply(ctx, cornerAt(0));
                        for (var i = 1; i < 4; i++) {
                            ctx.lineTo.apply(ctx, cornerAt(i));
                        }

                        ctx.fill();
                        if (vm.borderWidth) {
                            ctx.stroke();
                        }
                    },

                    inRange: function(mouseX, mouseY) {
                        var vm = this._view;
                        var inRange = false;

                        if (vm) {
                            if (vm.x < vm.base) {
                                inRange = (mouseY >= vm.y - vm.height / 2 && mouseY <= vm.y + vm.height / 2) && (mouseX >= vm.x && mouseX <= vm.base);
                            } else {
                                inRange = (mouseY >= vm.y - vm.height / 2 && mouseY <= vm.y + vm.height / 2) && (mouseX >= vm.base && mouseX <= vm.x);
                            }
                        }

                        return inRange;
                    }
                });

                rectangle.pivot();
            },

            calculateBarBase: function(datasetIndex, index) {
                var me = this;
                var meta = me.getMeta();
                var xScale = me.getScaleForId(meta.xAxisID);
                var base = 0;

                if (xScale.options.stacked) {
                    var chart = me.chart;
                    var datasets = chart.data.datasets;
                    var value = Number(datasets[datasetIndex].data[index]);

                    for (var i = 0; i < datasetIndex; i++) {
                        var currentDs = datasets[i];
                        var currentDsMeta = chart.getDatasetMeta(i);
                        if (currentDsMeta.bar && currentDsMeta.xAxisID === xScale.id && chart.isDatasetVisible(i)) {
                            var currentVal = Number(currentDs.data[index]);
                            base += value < 0 ? Math.min(currentVal, 0) : Math.max(currentVal, 0);
                        }
                    }

                    return xScale.getPixelForValue(base);
                }

                return xScale.getBasePixel();
            },

            getRuler: function(index) {
                var me = this;
                var meta = me.getMeta();
                var yScale = me.getScaleForId(meta.yAxisID);
                var datasetCount = me.getBarCount();

                var tickHeight;
                if (yScale.options.type === 'category') {
                    tickHeight = yScale.getPixelForTick(index + 1) - yScale.getPixelForTick(index);
                } else {
                    // Average width
                    tickHeight = yScale.width / yScale.ticks.length;
                }
                var categoryHeight = tickHeight * yScale.options.categoryPercentage;
                var categorySpacing = (tickHeight - (tickHeight * yScale.options.categoryPercentage)) / 2;
                var fullBarHeight = categoryHeight / datasetCount;

                if (yScale.ticks.length !== me.chart.data.labels.length) {
                    var perc = yScale.ticks.length / me.chart.data.labels.length;
                    fullBarHeight = fullBarHeight * perc;
                }

                var barHeight = fullBarHeight * yScale.options.barPercentage;
                var barSpacing = fullBarHeight - (fullBarHeight * yScale.options.barPercentage);

                return {
                    datasetCount: datasetCount,
                    tickHeight: tickHeight,
                    categoryHeight: categoryHeight,
                    categorySpacing: categorySpacing,
                    fullBarHeight: fullBarHeight,
                    barHeight: barHeight,
                    barSpacing: barSpacing
                };
            },

            calculateBarHeight: function(index) {
                var me = this;
                var yScale = me.getScaleForId(me.getMeta().yAxisID);
                if (yScale.options.barThickness) {
                    return yScale.options.barThickness;
                }
                var ruler = me.getRuler(index);
                return yScale.options.stacked ? ruler.categoryHeight : ruler.barHeight;
            },

            calculateBarX: function(index, datasetIndex) {
                var me = this;
                var meta = me.getMeta();
                var xScale = me.getScaleForId(meta.xAxisID);
                var value = Number(me.getDataset().data[index]);

                if (xScale.options.stacked) {

                    var sumPos = 0,
                        sumNeg = 0;

                    for (var i = 0; i < datasetIndex; i++) {
                        var ds = me.chart.data.datasets[i];
                        var dsMeta = me.chart.getDatasetMeta(i);
                        if (dsMeta.bar && dsMeta.xAxisID === xScale.id && me.chart.isDatasetVisible(i)) {
                            var stackedVal = Number(ds.data[index]);
                            if (stackedVal < 0) {
                                sumNeg += stackedVal || 0;
                            } else {
                                sumPos += stackedVal || 0;
                            }
                        }
                    }

                    if (value < 0) {
                        return xScale.getPixelForValue(sumNeg + value);
                    }
                    return xScale.getPixelForValue(sumPos + value);
                }

                return xScale.getPixelForValue(value);
            },

            calculateBarY: function(index, datasetIndex) {
                var me = this;
                var meta = me.getMeta();
                var yScale = me.getScaleForId(meta.yAxisID);
                var barIndex = me.getBarIndex(datasetIndex);

                var ruler = me.getRuler(index);
                var topTick = yScale.getPixelForValue(null, index, datasetIndex, me.chart.isCombo);
                topTick -= me.chart.isCombo ? (ruler.tickHeight / 2) : 0;

                if (yScale.options.stacked) {
                    return topTick + (ruler.categoryHeight / 2) + ruler.categorySpacing;
                }

                return topTick +
                    (ruler.barHeight / 2) +
                    ruler.categorySpacing +
                    (ruler.barHeight * barIndex) +
                    (ruler.barSpacing / 2) +
                    (ruler.barSpacing * barIndex);
            }
        });
    };

},{}],16:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;

        Chart.defaults.bubble = {
            hover: {
                mode: 'single'
            },

            scales: {
                xAxes: [{
                    type: 'linear', // bubble should probably use a linear scale by default
                    position: 'bottom',
                    id: 'x-axis-0' // need an ID so datasets can reference the scale
                }],
                yAxes: [{
                    type: 'linear',
                    position: 'left',
                    id: 'y-axis-0'
                }]
            },

            tooltips: {
                callbacks: {
                    title: function() {
                        // Title doesn't make sense for scatter since we format the data as a point
                        return '';
                    },
                    label: function(tooltipItem, data) {
                        var datasetLabel = data.datasets[tooltipItem.datasetIndex].label || '';
                        var dataPoint = data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];
                        return datasetLabel + ': (' + dataPoint.x + ', ' + dataPoint.y + ', ' + dataPoint.r + ')';
                    }
                }
            }
        };

        Chart.controllers.bubble = Chart.DatasetController.extend({

            dataElementType: Chart.elements.Point,

            update: function(reset) {
                var me = this;
                var meta = me.getMeta();
                var points = meta.data;

                // Update Points
                helpers.each(points, function(point, index) {
                    me.updateElement(point, index, reset);
                });
            },

            updateElement: function(point, index, reset) {
                var me = this;
                var meta = me.getMeta();
                var xScale = me.getScaleForId(meta.xAxisID);
                var yScale = me.getScaleForId(meta.yAxisID);

                var custom = point.custom || {};
                var dataset = me.getDataset();
                var data = dataset.data[index];
                var pointElementOptions = me.chart.options.elements.point;
                var dsIndex = me.index;

                helpers.extend(point, {
                    // Utility
                    _xScale: xScale,
                    _yScale: yScale,
                    _datasetIndex: dsIndex,
                    _index: index,

                    // Desired view properties
                    _model: {
                        x: reset ? xScale.getPixelForDecimal(0.5) : xScale.getPixelForValue(typeof data === 'object' ? data : NaN, index, dsIndex, me.chart.isCombo),
                        y: reset ? yScale.getBasePixel() : yScale.getPixelForValue(data, index, dsIndex),
                        // Appearance
                        radius: reset ? 0 : custom.radius ? custom.radius : me.getRadius(data),

                        // Tooltip
                        hitRadius: custom.hitRadius ? custom.hitRadius : helpers.getValueAtIndexOrDefault(dataset.hitRadius, index, pointElementOptions.hitRadius)
                    }
                });

                // Trick to reset the styles of the point
                Chart.DatasetController.prototype.removeHoverStyle.call(me, point, pointElementOptions);

                var model = point._model;
                model.skip = custom.skip ? custom.skip : (isNaN(model.x) || isNaN(model.y));

                point.pivot();
            },

            getRadius: function(value) {
                return value.r || this.chart.options.elements.point.radius;
            },

            setHoverStyle: function(point) {
                var me = this;
                Chart.DatasetController.prototype.setHoverStyle.call(me, point);

                // Radius
                var dataset = me.chart.data.datasets[point._datasetIndex];
                var index = point._index;
                var custom = point.custom || {};
                var model = point._model;
                model.radius = custom.hoverRadius ? custom.hoverRadius : (helpers.getValueAtIndexOrDefault(dataset.hoverRadius, index, me.chart.options.elements.point.hoverRadius)) + me.getRadius(dataset.data[index]);
            },

            removeHoverStyle: function(point) {
                var me = this;
                Chart.DatasetController.prototype.removeHoverStyle.call(me, point, me.chart.options.elements.point);

                var dataVal = me.chart.data.datasets[point._datasetIndex].data[point._index];
                var custom = point.custom || {};
                var model = point._model;

                model.radius = custom.radius ? custom.radius : me.getRadius(dataVal);
            }
        });
    };

},{}],17:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers,
            defaults = Chart.defaults;

        defaults.doughnut = {
            animation: {
                // Boolean - Whether we animate the rotation of the Doughnut
                animateRotate: true,
                // Boolean - Whether we animate scaling the Doughnut from the centre
                animateScale: false
            },
            aspectRatio: 1,
            hover: {
                mode: 'single'
            },
            legendCallback: function(chart) {
                var text = [];
                text.push('<ul class="' + chart.id + '-legend">');

                var data = chart.data;
                var datasets = data.datasets;
                var labels = data.labels;

                if (datasets.length) {
                    for (var i = 0; i < datasets[0].data.length; ++i) {
                        text.push('<li><span style="background-color:' + datasets[0].backgroundColor[i] + '"></span>');
                        if (labels[i]) {
                            text.push(labels[i]);
                        }
                        text.push('</li>');
                    }
                }

                text.push('</ul>');
                return text.join('');
            },
            legend: {
                labels: {
                    generateLabels: function(chart) {
                        var data = chart.data;
                        if (data.labels.length && data.datasets.length) {
                            return data.labels.map(function(label, i) {
                                var meta = chart.getDatasetMeta(0);
                                var ds = data.datasets[0];
                                var arc = meta.data[i];
                                var custom = arc && arc.custom || {};
                                var getValueAtIndexOrDefault = helpers.getValueAtIndexOrDefault;
                                var arcOpts = chart.options.elements.arc;
                                var fill = custom.backgroundColor ? custom.backgroundColor : getValueAtIndexOrDefault(ds.backgroundColor, i, arcOpts.backgroundColor);
                                var stroke = custom.borderColor ? custom.borderColor : getValueAtIndexOrDefault(ds.borderColor, i, arcOpts.borderColor);
                                var bw = custom.borderWidth ? custom.borderWidth : getValueAtIndexOrDefault(ds.borderWidth, i, arcOpts.borderWidth);

                                return {
                                    text: label,
                                    fillStyle: fill,
                                    strokeStyle: stroke,
                                    lineWidth: bw,
                                    hidden: isNaN(ds.data[i]) || meta.data[i].hidden,

                                    // Extra data used for toggling the correct item
                                    index: i
                                };
                            });
                        }
                        return [];
                    }
                },

                onClick: function(e, legendItem) {
                    var index = legendItem.index;
                    var chart = this.chart;
                    var i, ilen, meta;

                    for (i = 0, ilen = (chart.data.datasets || []).length; i < ilen; ++i) {
                        meta = chart.getDatasetMeta(i);
                        // toggle visibility of index if exists
                        if (meta.data[index]) {
                            meta.data[index].hidden = !meta.data[index].hidden;
                        }
                    }

                    chart.update();
                }
            },

            // The percentage of the chart that we cut out of the middle.
            cutoutPercentage: 50,

            // The rotation of the chart, where the first data arc begins.
            rotation: Math.PI * -0.5,

            // The total circumference of the chart.
            circumference: Math.PI * 2.0,

            // Need to override these to give a nice default
            tooltips: {
                callbacks: {
                    title: function() {
                        return '';
                    },
                    label: function(tooltipItem, data) {
                        return data.labels[tooltipItem.index] + ': ' + data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];
                    }
                }
            }
        };

        defaults.pie = helpers.clone(defaults.doughnut);
        helpers.extend(defaults.pie, {
            cutoutPercentage: 0
        });


        Chart.controllers.doughnut = Chart.controllers.pie = Chart.DatasetController.extend({

            dataElementType: Chart.elements.Arc,

            linkScales: helpers.noop,

            // Get index of the dataset in relation to the visible datasets. This allows determining the inner and outer radius correctly
            getRingIndex: function(datasetIndex) {
                var ringIndex = 0;

                for (var j = 0; j < datasetIndex; ++j) {
                    if (this.chart.isDatasetVisible(j)) {
                        ++ringIndex;
                    }
                }

                return ringIndex;
            },

            update: function(reset) {
                var me = this;
                var chart = me.chart,
                    chartArea = chart.chartArea,
                    opts = chart.options,
                    arcOpts = opts.elements.arc,
                    availableWidth = chartArea.right - chartArea.left - arcOpts.borderWidth,
                    availableHeight = chartArea.bottom - chartArea.top - arcOpts.borderWidth,
                    minSize = Math.min(availableWidth, availableHeight),
                    offset = {
                        x: 0,
                        y: 0
                    },
                    meta = me.getMeta(),
                    cutoutPercentage = opts.cutoutPercentage,
                    circumference = opts.circumference;

                // If the chart's circumference isn't a full circle, calculate minSize as a ratio of the width/height of the arc
                if (circumference < Math.PI * 2.0) {
                    var startAngle = opts.rotation % (Math.PI * 2.0);
                    startAngle += Math.PI * 2.0 * (startAngle >= Math.PI ? -1 : startAngle < -Math.PI ? 1 : 0);
                    var endAngle = startAngle + circumference;
                    var start = {x: Math.cos(startAngle), y: Math.sin(startAngle)};
                    var end = {x: Math.cos(endAngle), y: Math.sin(endAngle)};
                    var contains0 = (startAngle <= 0 && 0 <= endAngle) || (startAngle <= Math.PI * 2.0 && Math.PI * 2.0 <= endAngle);
                    var contains90 = (startAngle <= Math.PI * 0.5 && Math.PI * 0.5 <= endAngle) || (startAngle <= Math.PI * 2.5 && Math.PI * 2.5 <= endAngle);
                    var contains180 = (startAngle <= -Math.PI && -Math.PI <= endAngle) || (startAngle <= Math.PI && Math.PI <= endAngle);
                    var contains270 = (startAngle <= -Math.PI * 0.5 && -Math.PI * 0.5 <= endAngle) || (startAngle <= Math.PI * 1.5 && Math.PI * 1.5 <= endAngle);
                    var cutout = cutoutPercentage / 100.0;
                    var min = {x: contains180 ? -1 : Math.min(start.x * (start.x < 0 ? 1 : cutout), end.x * (end.x < 0 ? 1 : cutout)), y: contains270 ? -1 : Math.min(start.y * (start.y < 0 ? 1 : cutout), end.y * (end.y < 0 ? 1 : cutout))};
                    var max = {x: contains0 ? 1 : Math.max(start.x * (start.x > 0 ? 1 : cutout), end.x * (end.x > 0 ? 1 : cutout)), y: contains90 ? 1 : Math.max(start.y * (start.y > 0 ? 1 : cutout), end.y * (end.y > 0 ? 1 : cutout))};
                    var size = {width: (max.x - min.x) * 0.5, height: (max.y - min.y) * 0.5};
                    minSize = Math.min(availableWidth / size.width, availableHeight / size.height);
                    offset = {x: (max.x + min.x) * -0.5, y: (max.y + min.y) * -0.5};
                }

                chart.borderWidth = me.getMaxBorderWidth(meta.data);
                chart.outerRadius = Math.max((minSize - chart.borderWidth) / 2, 0);
                chart.innerRadius = Math.max(cutoutPercentage ? (chart.outerRadius / 100) * (cutoutPercentage) : 1, 0);
                chart.radiusLength = (chart.outerRadius - chart.innerRadius) / chart.getVisibleDatasetCount();
                chart.offsetX = offset.x * chart.outerRadius;
                chart.offsetY = offset.y * chart.outerRadius;

                meta.total = me.calculateTotal();

                me.outerRadius = chart.outerRadius - (chart.radiusLength * me.getRingIndex(me.index));
                me.innerRadius = me.outerRadius - chart.radiusLength;

                helpers.each(meta.data, function(arc, index) {
                    me.updateElement(arc, index, reset);
                });
            },

            updateElement: function(arc, index, reset) {
                var me = this;
                var chart = me.chart,
                    chartArea = chart.chartArea,
                    opts = chart.options,
                    animationOpts = opts.animation,
                    centerX = (chartArea.left + chartArea.right) / 2,
                    centerY = (chartArea.top + chartArea.bottom) / 2,
                    startAngle = opts.rotation, // non reset case handled later
                    endAngle = opts.rotation, // non reset case handled later
                    dataset = me.getDataset(),
                    circumference = reset && animationOpts.animateRotate ? 0 : arc.hidden ? 0 : me.calculateCircumference(dataset.data[index]) * (opts.circumference / (2.0 * Math.PI)),
                    innerRadius = reset && animationOpts.animateScale ? 0 : me.innerRadius,
                    outerRadius = reset && animationOpts.animateScale ? 0 : me.outerRadius,
                    valueAtIndexOrDefault = helpers.getValueAtIndexOrDefault;

                helpers.extend(arc, {
                    // Utility
                    _datasetIndex: me.index,
                    _index: index,

                    // Desired view properties
                    _model: {
                        x: centerX + chart.offsetX,
                        y: centerY + chart.offsetY,
                        startAngle: startAngle,
                        endAngle: endAngle,
                        circumference: circumference,
                        outerRadius: outerRadius,
                        innerRadius: innerRadius,
                        label: valueAtIndexOrDefault(dataset.label, index, chart.data.labels[index])
                    }
                });

                var model = arc._model;
                // Resets the visual styles
                this.removeHoverStyle(arc);

                // Set correct angles if not resetting
                if (!reset || !animationOpts.animateRotate) {
                    if (index === 0) {
                        model.startAngle = opts.rotation;
                    } else {
                        model.startAngle = me.getMeta().data[index - 1]._model.endAngle;
                    }

                    model.endAngle = model.startAngle + model.circumference;
                }

                arc.pivot();
            },

            removeHoverStyle: function(arc) {
                Chart.DatasetController.prototype.removeHoverStyle.call(this, arc, this.chart.options.elements.arc);
            },

            calculateTotal: function() {
                var dataset = this.getDataset();
                var meta = this.getMeta();
                var total = 0;
                var value;

                helpers.each(meta.data, function(element, index) {
                    value = dataset.data[index];
                    if (!isNaN(value) && !element.hidden) {
                        total += Math.abs(value);
                    }
                });

                /* if (total === 0) {
                 total = NaN;
                 }*/

                return total;
            },

            calculateCircumference: function(value) {
                var total = this.getMeta().total;
                if (total > 0 && !isNaN(value)) {
                    return (Math.PI * 2.0) * (value / total);
                }
                return 0;
            },

            // gets the max border or hover width to properly scale pie charts
            getMaxBorderWidth: function(elements) {
                var max = 0,
                    index = this.index,
                    length = elements.length,
                    borderWidth,
                    hoverWidth;

                for (var i = 0; i < length; i++) {
                    borderWidth = elements[i]._model ? elements[i]._model.borderWidth : 0;
                    hoverWidth = elements[i]._chart ? elements[i]._chart.config.data.datasets[index].hoverBorderWidth : 0;

                    max = borderWidth > max ? borderWidth : max;
                    max = hoverWidth > max ? hoverWidth : max;
                }
                return max;
            }
        });
    };

},{}],18:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;

        Chart.defaults.line = {
            showLines: true,
            spanGaps: false,

            hover: {
                mode: 'label'
            },

            scales: {
                xAxes: [{
                    type: 'category',
                    id: 'x-axis-0'
                }],
                yAxes: [{
                    type: 'linear',
                    id: 'y-axis-0'
                }]
            }
        };

        function lineEnabled(dataset, options) {
            return helpers.getValueOrDefault(dataset.showLine, options.showLines);
        }

        Chart.controllers.line = Chart.DatasetController.extend({

            datasetElementType: Chart.elements.Line,

            dataElementType: Chart.elements.Point,

            addElementAndReset: function(index) {
                var me = this;
                var options = me.chart.options;
                var meta = me.getMeta();

                Chart.DatasetController.prototype.addElementAndReset.call(me, index);

                // Make sure bezier control points are updated
                if (lineEnabled(me.getDataset(), options) && meta.dataset._model.tension !== 0) {
                    me.updateBezierControlPoints();
                }
            },

            update: function(reset) {
                var me = this;
                var meta = me.getMeta();
                var line = meta.dataset;
                var points = meta.data || [];
                var options = me.chart.options;
                var lineElementOptions = options.elements.line;
                var scale = me.getScaleForId(meta.yAxisID);
                var i, ilen, custom;
                var dataset = me.getDataset();
                var showLine = lineEnabled(dataset, options);

                // Update Line
                if (showLine) {
                    custom = line.custom || {};

                    // Compatibility: If the properties are defined with only the old name, use those values
                    if ((dataset.tension !== undefined) && (dataset.lineTension === undefined)) {
                        dataset.lineTension = dataset.tension;
                    }

                    // Utility
                    line._scale = scale;
                    line._datasetIndex = me.index;
                    // Data
                    line._children = points;
                    // Model
                    line._model = {
                        // Appearance
                        // The default behavior of lines is to break at null values, according
                        // to https://github.com/chartjs/Chart.js/issues/2435#issuecomment-216718158
                        // This option gives linse the ability to span gaps
                        spanGaps: dataset.spanGaps ? dataset.spanGaps : options.spanGaps,
                        tension: custom.tension ? custom.tension : helpers.getValueOrDefault(dataset.lineTension, lineElementOptions.tension),
                        backgroundColor: custom.backgroundColor ? custom.backgroundColor : (dataset.backgroundColor || lineElementOptions.backgroundColor),
                        borderWidth: custom.borderWidth ? custom.borderWidth : (dataset.borderWidth || lineElementOptions.borderWidth),
                        borderColor: custom.borderColor ? custom.borderColor : (dataset.borderColor || lineElementOptions.borderColor),
                        borderCapStyle: custom.borderCapStyle ? custom.borderCapStyle : (dataset.borderCapStyle || lineElementOptions.borderCapStyle),
                        borderDash: custom.borderDash ? custom.borderDash : (dataset.borderDash || lineElementOptions.borderDash),
                        borderDashOffset: custom.borderDashOffset ? custom.borderDashOffset : (dataset.borderDashOffset || lineElementOptions.borderDashOffset),
                        borderJoinStyle: custom.borderJoinStyle ? custom.borderJoinStyle : (dataset.borderJoinStyle || lineElementOptions.borderJoinStyle),
                        fill: custom.fill ? custom.fill : (dataset.fill !== undefined ? dataset.fill : lineElementOptions.fill),
                        steppedLine: custom.steppedLine ? custom.steppedLine : helpers.getValueOrDefault(dataset.steppedLine, lineElementOptions.stepped),
                        cubicInterpolationMode: custom.cubicInterpolationMode ? custom.cubicInterpolationMode : helpers.getValueOrDefault(dataset.cubicInterpolationMode, lineElementOptions.cubicInterpolationMode),
                        // Scale
                        scaleTop: scale.top,
                        scaleBottom: scale.bottom,
                        scaleZero: scale.getBasePixel()
                    };

                    line.pivot();
                }

                // Update Points
                for (i=0, ilen=points.length; i<ilen; ++i) {
                    me.updateElement(points[i], i, reset);
                }

                if (showLine && line._model.tension !== 0) {
                    me.updateBezierControlPoints();
                }

                // Now pivot the point for animation
                for (i=0, ilen=points.length; i<ilen; ++i) {
                    points[i].pivot();
                }
            },

            getPointBackgroundColor: function(point, index) {
                var backgroundColor = this.chart.options.elements.point.backgroundColor;
                var dataset = this.getDataset();
                var custom = point.custom || {};

                if (custom.backgroundColor) {
                    backgroundColor = custom.backgroundColor;
                } else if (dataset.pointBackgroundColor) {
                    backgroundColor = helpers.getValueAtIndexOrDefault(dataset.pointBackgroundColor, index, backgroundColor);
                } else if (dataset.backgroundColor) {
                    backgroundColor = dataset.backgroundColor;
                }

                return backgroundColor;
            },

            getPointBorderColor: function(point, index) {
                var borderColor = this.chart.options.elements.point.borderColor;
                var dataset = this.getDataset();
                var custom = point.custom || {};

                if (custom.borderColor) {
                    borderColor = custom.borderColor;
                } else if (dataset.pointBorderColor) {
                    borderColor = helpers.getValueAtIndexOrDefault(dataset.pointBorderColor, index, borderColor);
                } else if (dataset.borderColor) {
                    borderColor = dataset.borderColor;
                }

                return borderColor;
            },

            getPointBorderWidth: function(point, index) {
                var borderWidth = this.chart.options.elements.point.borderWidth;
                var dataset = this.getDataset();
                var custom = point.custom || {};

                if (custom.borderWidth) {
                    borderWidth = custom.borderWidth;
                } else if (dataset.pointBorderWidth) {
                    borderWidth = helpers.getValueAtIndexOrDefault(dataset.pointBorderWidth, index, borderWidth);
                } else if (dataset.borderWidth) {
                    borderWidth = dataset.borderWidth;
                }

                return borderWidth;
            },

            updateElement: function(point, index, reset) {
                var me = this;
                var meta = me.getMeta();
                var custom = point.custom || {};
                var dataset = me.getDataset();
                var datasetIndex = me.index;
                var value = dataset.data[index];
                var yScale = me.getScaleForId(meta.yAxisID);
                var xScale = me.getScaleForId(meta.xAxisID);
                var pointOptions = me.chart.options.elements.point;
                var x, y;
                var labels = me.chart.data.labels || [];
                var includeOffset = (labels.length === 1 || dataset.data.length === 1) || me.chart.isCombo;

                // Compatibility: If the properties are defined with only the old name, use those values
                if ((dataset.radius !== undefined) && (dataset.pointRadius === undefined)) {
                    dataset.pointRadius = dataset.radius;
                }
                if ((dataset.hitRadius !== undefined) && (dataset.pointHitRadius === undefined)) {
                    dataset.pointHitRadius = dataset.hitRadius;
                }

                x = xScale.getPixelForValue(typeof value === 'object' ? value : NaN, index, datasetIndex, includeOffset);
                y = reset ? yScale.getBasePixel() : me.calculatePointY(value, index, datasetIndex);

                // Utility
                point._xScale = xScale;
                point._yScale = yScale;
                point._datasetIndex = datasetIndex;
                point._index = index;

                // Desired view properties
                point._model = {
                    x: x,
                    y: y,
                    skip: custom.skip || isNaN(x) || isNaN(y),
                    // Appearance
                    radius: custom.radius || helpers.getValueAtIndexOrDefault(dataset.pointRadius, index, pointOptions.radius),
                    pointStyle: custom.pointStyle || helpers.getValueAtIndexOrDefault(dataset.pointStyle, index, pointOptions.pointStyle),
                    backgroundColor: me.getPointBackgroundColor(point, index),
                    borderColor: me.getPointBorderColor(point, index),
                    borderWidth: me.getPointBorderWidth(point, index),
                    tension: meta.dataset._model ? meta.dataset._model.tension : 0,
                    steppedLine: meta.dataset._model ? meta.dataset._model.steppedLine : false,
                    // Tooltip
                    hitRadius: custom.hitRadius || helpers.getValueAtIndexOrDefault(dataset.pointHitRadius, index, pointOptions.hitRadius)
                };
            },

            calculatePointY: function(value, index, datasetIndex) {
                var me = this;
                var chart = me.chart;
                var meta = me.getMeta();
                var yScale = me.getScaleForId(meta.yAxisID);
                var sumPos = 0;
                var sumNeg = 0;
                var i, ds, dsMeta;

                if (yScale.options.stacked) {
                    for (i = 0; i < datasetIndex; i++) {
                        ds = chart.data.datasets[i];
                        dsMeta = chart.getDatasetMeta(i);
                        if (dsMeta.type === 'line' && dsMeta.yAxisID === yScale.id && chart.isDatasetVisible(i)) {
                            var stackedRightValue = Number(yScale.getRightValue(ds.data[index]));
                            if (stackedRightValue < 0) {
                                sumNeg += stackedRightValue || 0;
                            } else {
                                sumPos += stackedRightValue || 0;
                            }
                        }
                    }

                    var rightValue = Number(yScale.getRightValue(value));
                    if (rightValue < 0) {
                        return yScale.getPixelForValue(sumNeg + rightValue);
                    }
                    return yScale.getPixelForValue(sumPos + rightValue);
                }

                return yScale.getPixelForValue(value);
            },

            updateBezierControlPoints: function() {
                var me = this;
                var meta = me.getMeta();
                var area = me.chart.chartArea;
                var points = (meta.data || []);
                var i, ilen, point, model, controlPoints;

                // Only consider points that are drawn in case the spanGaps option is used
                if (meta.dataset._model.spanGaps) {
                    points = points.filter(function(pt) {
                        return !pt._model.skip;
                    });
                }

                function capControlPoint(pt, min, max) {
                    return Math.max(Math.min(pt, max), min);
                }

                if (meta.dataset._model.cubicInterpolationMode === 'monotone') {
                    helpers.splineCurveMonotone(points);
                } else {
                    for (i = 0, ilen = points.length; i < ilen; ++i) {
                        point = points[i];
                        model = point._model;
                        controlPoints = helpers.splineCurve(
                            helpers.previousItem(points, i)._model,
                            model,
                            helpers.nextItem(points, i)._model,
                            meta.dataset._model.tension
                        );
                        model.controlPointPreviousX = controlPoints.previous.x;
                        model.controlPointPreviousY = controlPoints.previous.y;
                        model.controlPointNextX = controlPoints.next.x;
                        model.controlPointNextY = controlPoints.next.y;
                    }
                }

                if (me.chart.options.elements.line.capBezierPoints) {
                    for (i = 0, ilen = points.length; i < ilen; ++i) {
                        model = points[i]._model;
                        model.controlPointPreviousX = capControlPoint(model.controlPointPreviousX, area.left, area.right);
                        model.controlPointPreviousY = capControlPoint(model.controlPointPreviousY, area.top, area.bottom);
                        model.controlPointNextX = capControlPoint(model.controlPointNextX, area.left, area.right);
                        model.controlPointNextY = capControlPoint(model.controlPointNextY, area.top, area.bottom);
                    }
                }
            },

            draw: function(ease) {
                var me = this;
                var meta = me.getMeta();
                var points = meta.data || [];
                var easingDecimal = ease || 1;
                var i, ilen;

                // Transition Point Locations
                for (i=0, ilen=points.length; i<ilen; ++i) {
                    points[i].transition(easingDecimal);
                }

                // Transition and Draw the line
                if (lineEnabled(me.getDataset(), me.chart.options)) {
                    meta.dataset.transition(easingDecimal).draw();
                }

                // Draw the points
                for (i=0, ilen=points.length; i<ilen; ++i) {
                    points[i].draw();
                }
            },

            setHoverStyle: function(point) {
                // Point
                var dataset = this.chart.data.datasets[point._datasetIndex];
                var index = point._index;
                var custom = point.custom || {};
                var model = point._model;

                model.radius = custom.hoverRadius || helpers.getValueAtIndexOrDefault(dataset.pointHoverRadius, index, this.chart.options.elements.point.hoverRadius);
                model.backgroundColor = custom.hoverBackgroundColor || helpers.getValueAtIndexOrDefault(dataset.pointHoverBackgroundColor, index, helpers.getHoverColor(model.backgroundColor));
                model.borderColor = custom.hoverBorderColor || helpers.getValueAtIndexOrDefault(dataset.pointHoverBorderColor, index, helpers.getHoverColor(model.borderColor));
                model.borderWidth = custom.hoverBorderWidth || helpers.getValueAtIndexOrDefault(dataset.pointHoverBorderWidth, index, model.borderWidth);
            },

            removeHoverStyle: function(point) {
                var me = this;
                var dataset = me.chart.data.datasets[point._datasetIndex];
                var index = point._index;
                var custom = point.custom || {};
                var model = point._model;

                // Compatibility: If the properties are defined with only the old name, use those values
                if ((dataset.radius !== undefined) && (dataset.pointRadius === undefined)) {
                    dataset.pointRadius = dataset.radius;
                }

                model.radius = custom.radius || helpers.getValueAtIndexOrDefault(dataset.pointRadius, index, me.chart.options.elements.point.radius);
                model.backgroundColor = me.getPointBackgroundColor(point, index);
                model.borderColor = me.getPointBorderColor(point, index);
                model.borderWidth = me.getPointBorderWidth(point, index);
            }
        });
    };

},{}],19:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;

        Chart.defaults.polarArea = {

            scale: {
                type: 'radialLinear',
                lineArc: true, // so that lines are circular
                ticks: {
                    beginAtZero: true
                }
            },

            // Boolean - Whether to animate the rotation of the chart
            animation: {
                animateRotate: true,
                animateScale: true
            },

            startAngle: -0.5 * Math.PI,
            aspectRatio: 1,
            legendCallback: function(chart) {
                var text = [];
                text.push('<ul class="' + chart.id + '-legend">');

                var data = chart.data;
                var datasets = data.datasets;
                var labels = data.labels;

                if (datasets.length) {
                    for (var i = 0; i < datasets[0].data.length; ++i) {
                        text.push('<li><span style="background-color:' + datasets[0].backgroundColor[i] + '">');
                        if (labels[i]) {
                            text.push(labels[i]);
                        }
                        text.push('</span></li>');
                    }
                }

                text.push('</ul>');
                return text.join('');
            },
            legend: {
                labels: {
                    generateLabels: function(chart) {
                        var data = chart.data;
                        if (data.labels.length && data.datasets.length) {
                            return data.labels.map(function(label, i) {
                                var meta = chart.getDatasetMeta(0);
                                var ds = data.datasets[0];
                                var arc = meta.data[i];
                                var custom = arc.custom || {};
                                var getValueAtIndexOrDefault = helpers.getValueAtIndexOrDefault;
                                var arcOpts = chart.options.elements.arc;
                                var fill = custom.backgroundColor ? custom.backgroundColor : getValueAtIndexOrDefault(ds.backgroundColor, i, arcOpts.backgroundColor);
                                var stroke = custom.borderColor ? custom.borderColor : getValueAtIndexOrDefault(ds.borderColor, i, arcOpts.borderColor);
                                var bw = custom.borderWidth ? custom.borderWidth : getValueAtIndexOrDefault(ds.borderWidth, i, arcOpts.borderWidth);

                                return {
                                    text: label,
                                    fillStyle: fill,
                                    strokeStyle: stroke,
                                    lineWidth: bw,
                                    hidden: isNaN(ds.data[i]) || meta.data[i].hidden,

                                    // Extra data used for toggling the correct item
                                    index: i
                                };
                            });
                        }
                        return [];
                    }
                },

                onClick: function(e, legendItem) {
                    var index = legendItem.index;
                    var chart = this.chart;
                    var i, ilen, meta;

                    for (i = 0, ilen = (chart.data.datasets || []).length; i < ilen; ++i) {
                        meta = chart.getDatasetMeta(i);
                        meta.data[index].hidden = !meta.data[index].hidden;
                    }

                    chart.update();
                }
            },

            // Need to override these to give a nice default
            tooltips: {
                callbacks: {
                    title: function() {
                        return '';
                    },
                    label: function(tooltipItem, data) {
                        return data.labels[tooltipItem.index] + ': ' + tooltipItem.yLabel;
                    }
                }
            }
        };

        Chart.controllers.polarArea = Chart.DatasetController.extend({

            dataElementType: Chart.elements.Arc,

            linkScales: helpers.noop,

            update: function(reset) {
                var me = this;
                var chart = me.chart;
                var chartArea = chart.chartArea;
                var meta = me.getMeta();
                var opts = chart.options;
                var arcOpts = opts.elements.arc;
                var minSize = Math.min(chartArea.right - chartArea.left, chartArea.bottom - chartArea.top);
                chart.outerRadius = Math.max((minSize - arcOpts.borderWidth / 2) / 2, 0);
                chart.innerRadius = Math.max(opts.cutoutPercentage ? (chart.outerRadius / 100) * (opts.cutoutPercentage) : 1, 0);
                chart.radiusLength = (chart.outerRadius - chart.innerRadius) / chart.getVisibleDatasetCount();

                me.outerRadius = chart.outerRadius - (chart.radiusLength * me.index);
                me.innerRadius = me.outerRadius - chart.radiusLength;

                meta.count = me.countVisibleElements();

                helpers.each(meta.data, function(arc, index) {
                    me.updateElement(arc, index, reset);
                });
            },

            updateElement: function(arc, index, reset) {
                var me = this;
                var chart = me.chart;
                var dataset = me.getDataset();
                var opts = chart.options;
                var animationOpts = opts.animation;
                var scale = chart.scale;
                var getValueAtIndexOrDefault = helpers.getValueAtIndexOrDefault;
                var labels = chart.data.labels;

                var circumference = me.calculateCircumference(dataset.data[index]);
                var centerX = scale.xCenter;
                var centerY = scale.yCenter;

                // If there is NaN data before us, we need to calculate the starting angle correctly.
                // We could be way more efficient here, but its unlikely that the polar area chart will have a lot of data
                var visibleCount = 0;
                var meta = me.getMeta();
                for (var i = 0; i < index; ++i) {
                    if (!isNaN(dataset.data[i]) && !meta.data[i].hidden) {
                        ++visibleCount;
                    }
                }

                // var negHalfPI = -0.5 * Math.PI;
                var datasetStartAngle = opts.startAngle;
                var distance = arc.hidden ? 0 : scale.getDistanceFromCenterForValue(dataset.data[index]);
                var startAngle = datasetStartAngle + (circumference * visibleCount);
                var endAngle = startAngle + (arc.hidden ? 0 : circumference);

                var resetRadius = animationOpts.animateScale ? 0 : scale.getDistanceFromCenterForValue(dataset.data[index]);

                helpers.extend(arc, {
                    // Utility
                    _datasetIndex: me.index,
                    _index: index,
                    _scale: scale,

                    // Desired view properties
                    _model: {
                        x: centerX,
                        y: centerY,
                        innerRadius: 0,
                        outerRadius: reset ? resetRadius : distance,
                        startAngle: reset && animationOpts.animateRotate ? datasetStartAngle : startAngle,
                        endAngle: reset && animationOpts.animateRotate ? datasetStartAngle : endAngle,
                        label: getValueAtIndexOrDefault(labels, index, labels[index])
                    }
                });

                // Apply border and fill style
                me.removeHoverStyle(arc);

                arc.pivot();
            },

            removeHoverStyle: function(arc) {
                Chart.DatasetController.prototype.removeHoverStyle.call(this, arc, this.chart.options.elements.arc);
            },

            countVisibleElements: function() {
                var dataset = this.getDataset();
                var meta = this.getMeta();
                var count = 0;

                helpers.each(meta.data, function(element, index) {
                    if (!isNaN(dataset.data[index]) && !element.hidden) {
                        count++;
                    }
                });

                return count;
            },

            calculateCircumference: function(value) {
                var count = this.getMeta().count;
                if (count > 0 && !isNaN(value)) {
                    return (2 * Math.PI) / count;
                }
                return 0;
            }
        });
    };

},{}],20:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;

        Chart.defaults.radar = {
            scale: {
                type: 'radialLinear'
            },
            elements: {
                line: {
                    tension: 0 // no bezier in radar
                }
            }
        };

        Chart.controllers.radar = Chart.DatasetController.extend({

            datasetElementType: Chart.elements.Line,

            dataElementType: Chart.elements.Point,

            linkScales: helpers.noop,

            addElementAndReset: function(index) {
                Chart.DatasetController.prototype.addElementAndReset.call(this, index);

                // Make sure bezier control points are updated
                this.updateBezierControlPoints();
            },

            update: function(reset) {
                var me = this;
                var meta = me.getMeta();
                var line = meta.dataset;
                var points = meta.data;
                var custom = line.custom || {};
                var dataset = me.getDataset();
                var lineElementOptions = me.chart.options.elements.line;
                var scale = me.chart.scale;

                // Compatibility: If the properties are defined with only the old name, use those values
                if ((dataset.tension !== undefined) && (dataset.lineTension === undefined)) {
                    dataset.lineTension = dataset.tension;
                }

                helpers.extend(meta.dataset, {
                    // Utility
                    _datasetIndex: me.index,
                    // Data
                    _children: points,
                    _loop: true,
                    // Model
                    _model: {
                        // Appearance
                        tension: custom.tension ? custom.tension : helpers.getValueOrDefault(dataset.lineTension, lineElementOptions.tension),
                        backgroundColor: custom.backgroundColor ? custom.backgroundColor : (dataset.backgroundColor || lineElementOptions.backgroundColor),
                        borderWidth: custom.borderWidth ? custom.borderWidth : (dataset.borderWidth || lineElementOptions.borderWidth),
                        borderColor: custom.borderColor ? custom.borderColor : (dataset.borderColor || lineElementOptions.borderColor),
                        fill: custom.fill ? custom.fill : (dataset.fill !== undefined ? dataset.fill : lineElementOptions.fill),
                        borderCapStyle: custom.borderCapStyle ? custom.borderCapStyle : (dataset.borderCapStyle || lineElementOptions.borderCapStyle),
                        borderDash: custom.borderDash ? custom.borderDash : (dataset.borderDash || lineElementOptions.borderDash),
                        borderDashOffset: custom.borderDashOffset ? custom.borderDashOffset : (dataset.borderDashOffset || lineElementOptions.borderDashOffset),
                        borderJoinStyle: custom.borderJoinStyle ? custom.borderJoinStyle : (dataset.borderJoinStyle || lineElementOptions.borderJoinStyle),

                        // Scale
                        scaleTop: scale.top,
                        scaleBottom: scale.bottom,
                        scaleZero: scale.getBasePosition()
                    }
                });

                meta.dataset.pivot();

                // Update Points
                helpers.each(points, function(point, index) {
                    me.updateElement(point, index, reset);
                }, me);


                // Update bezier control points
                me.updateBezierControlPoints();
            },
            updateElement: function(point, index, reset) {
                var me = this;
                var custom = point.custom || {};
                var dataset = me.getDataset();
                var scale = me.chart.scale;
                var pointElementOptions = me.chart.options.elements.point;
                var pointPosition = scale.getPointPositionForValue(index, dataset.data[index]);

                helpers.extend(point, {
                    // Utility
                    _datasetIndex: me.index,
                    _index: index,
                    _scale: scale,

                    // Desired view properties
                    _model: {
                        x: reset ? scale.xCenter : pointPosition.x, // value not used in dataset scale, but we want a consistent API between scales
                        y: reset ? scale.yCenter : pointPosition.y,

                        // Appearance
                        tension: custom.tension ? custom.tension : helpers.getValueOrDefault(dataset.tension, me.chart.options.elements.line.tension),
                        radius: custom.radius ? custom.radius : helpers.getValueAtIndexOrDefault(dataset.pointRadius, index, pointElementOptions.radius),
                        backgroundColor: custom.backgroundColor ? custom.backgroundColor : helpers.getValueAtIndexOrDefault(dataset.pointBackgroundColor, index, pointElementOptions.backgroundColor),
                        borderColor: custom.borderColor ? custom.borderColor : helpers.getValueAtIndexOrDefault(dataset.pointBorderColor, index, pointElementOptions.borderColor),
                        borderWidth: custom.borderWidth ? custom.borderWidth : helpers.getValueAtIndexOrDefault(dataset.pointBorderWidth, index, pointElementOptions.borderWidth),
                        pointStyle: custom.pointStyle ? custom.pointStyle : helpers.getValueAtIndexOrDefault(dataset.pointStyle, index, pointElementOptions.pointStyle),

                        // Tooltip
                        hitRadius: custom.hitRadius ? custom.hitRadius : helpers.getValueAtIndexOrDefault(dataset.hitRadius, index, pointElementOptions.hitRadius)
                    }
                });

                point._model.skip = custom.skip ? custom.skip : (isNaN(point._model.x) || isNaN(point._model.y));
            },
            updateBezierControlPoints: function() {
                var chartArea = this.chart.chartArea;
                var meta = this.getMeta();

                helpers.each(meta.data, function(point, index) {
                    var model = point._model;
                    var controlPoints = helpers.splineCurve(
                        helpers.previousItem(meta.data, index, true)._model,
                        model,
                        helpers.nextItem(meta.data, index, true)._model,
                        model.tension
                    );

                    // Prevent the bezier going outside of the bounds of the graph
                    model.controlPointPreviousX = Math.max(Math.min(controlPoints.previous.x, chartArea.right), chartArea.left);
                    model.controlPointPreviousY = Math.max(Math.min(controlPoints.previous.y, chartArea.bottom), chartArea.top);

                    model.controlPointNextX = Math.max(Math.min(controlPoints.next.x, chartArea.right), chartArea.left);
                    model.controlPointNextY = Math.max(Math.min(controlPoints.next.y, chartArea.bottom), chartArea.top);

                    // Now pivot the point for animation
                    point.pivot();
                });
            },

            draw: function(ease) {
                var meta = this.getMeta();
                var easingDecimal = ease || 1;

                // Transition Point Locations
                helpers.each(meta.data, function(point) {
                    point.transition(easingDecimal);
                });

                // Transition and Draw the line
                meta.dataset.transition(easingDecimal).draw();

                // Draw the points
                helpers.each(meta.data, function(point) {
                    point.draw();
                });
            },

            setHoverStyle: function(point) {
                // Point
                var dataset = this.chart.data.datasets[point._datasetIndex];
                var custom = point.custom || {};
                var index = point._index;
                var model = point._model;

                model.radius = custom.hoverRadius ? custom.hoverRadius : helpers.getValueAtIndexOrDefault(dataset.pointHoverRadius, index, this.chart.options.elements.point.hoverRadius);
                model.backgroundColor = custom.hoverBackgroundColor ? custom.hoverBackgroundColor : helpers.getValueAtIndexOrDefault(dataset.pointHoverBackgroundColor, index, helpers.getHoverColor(model.backgroundColor));
                model.borderColor = custom.hoverBorderColor ? custom.hoverBorderColor : helpers.getValueAtIndexOrDefault(dataset.pointHoverBorderColor, index, helpers.getHoverColor(model.borderColor));
                model.borderWidth = custom.hoverBorderWidth ? custom.hoverBorderWidth : helpers.getValueAtIndexOrDefault(dataset.pointHoverBorderWidth, index, model.borderWidth);
            },

            removeHoverStyle: function(point) {
                var dataset = this.chart.data.datasets[point._datasetIndex];
                var custom = point.custom || {};
                var index = point._index;
                var model = point._model;
                var pointElementOptions = this.chart.options.elements.point;

                model.radius = custom.radius ? custom.radius : helpers.getValueAtIndexOrDefault(dataset.radius, index, pointElementOptions.radius);
                model.backgroundColor = custom.backgroundColor ? custom.backgroundColor : helpers.getValueAtIndexOrDefault(dataset.pointBackgroundColor, index, pointElementOptions.backgroundColor);
                model.borderColor = custom.borderColor ? custom.borderColor : helpers.getValueAtIndexOrDefault(dataset.pointBorderColor, index, pointElementOptions.borderColor);
                model.borderWidth = custom.borderWidth ? custom.borderWidth : helpers.getValueAtIndexOrDefault(dataset.pointBorderWidth, index, pointElementOptions.borderWidth);
            }
        });
    };

},{}],21:[function(require,module,exports){
    /* global window: false */
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;

        Chart.defaults.global.animation = {
            duration: 1000,
            easing: 'easeOutQuart',
            onProgress: helpers.noop,
            onComplete: helpers.noop
        };

        Chart.Animation = Chart.Element.extend({
            currentStep: null, // the current animation step
            numSteps: 60, // default number of steps
            easing: '', // the easing to use for this animation
            render: null, // render function used by the animation service

            onAnimationProgress: null, // user specified callback to fire on each step of the animation
            onAnimationComplete: null // user specified callback to fire when the animation finishes
        });

        Chart.animationService = {
            frameDuration: 17,
            animations: [],
            dropFrames: 0,
            request: null,
            addAnimation: function(chartInstance, animationObject, duration, lazy) {
                var me = this;

                if (!lazy) {
                    chartInstance.animating = true;
                }

                for (var index = 0; index < me.animations.length; ++index) {
                    if (me.animations[index].chartInstance === chartInstance) {
                        // replacing an in progress animation
                        me.animations[index].animationObject = animationObject;
                        return;
                    }
                }

                me.animations.push({
                    chartInstance: chartInstance,
                    animationObject: animationObject
                });

                // If there are no animations queued, manually kickstart a digest, for lack of a better word
                if (me.animations.length === 1) {
                    me.requestAnimationFrame();
                }
            },
            // Cancel the animation for a given chart instance
            cancelAnimation: function(chartInstance) {
                var index = helpers.findIndex(this.animations, function(animationWrapper) {
                    return animationWrapper.chartInstance === chartInstance;
                });

                if (index !== -1) {
                    this.animations.splice(index, 1);
                    chartInstance.animating = false;
                }
            },
            requestAnimationFrame: function() {
                var me = this;
                if (me.request === null) {
                    // Skip animation frame requests until the active one is executed.
                    // This can happen when processing mouse events, e.g. 'mousemove'
                    // and 'mouseout' events will trigger multiple renders.
                    me.request = helpers.requestAnimFrame.call(window, function() {
                        me.request = null;
                        me.startDigest();
                    });
                }
            },
            startDigest: function() {
                var me = this;

                var startTime = Date.now();
                var framesToDrop = 0;

                if (me.dropFrames > 1) {
                    framesToDrop = Math.floor(me.dropFrames);
                    me.dropFrames = me.dropFrames % 1;
                }

                var i = 0;
                while (i < me.animations.length) {
                    if (me.animations[i].animationObject.currentStep === null) {
                        me.animations[i].animationObject.currentStep = 0;
                    }

                    me.animations[i].animationObject.currentStep += 1 + framesToDrop;

                    if (me.animations[i].animationObject.currentStep > me.animations[i].animationObject.numSteps) {
                        me.animations[i].animationObject.currentStep = me.animations[i].animationObject.numSteps;
                    }

                    me.animations[i].animationObject.render(me.animations[i].chartInstance, me.animations[i].animationObject);
                    if (me.animations[i].animationObject.onAnimationProgress && me.animations[i].animationObject.onAnimationProgress.call) {
                        me.animations[i].animationObject.onAnimationProgress.call(me.animations[i].chartInstance, me.animations[i]);
                    }

                    if (me.animations[i].animationObject.currentStep === me.animations[i].animationObject.numSteps) {
                        if (me.animations[i].animationObject.onAnimationComplete && me.animations[i].animationObject.onAnimationComplete.call) {
                            me.animations[i].animationObject.onAnimationComplete.call(me.animations[i].chartInstance, me.animations[i]);
                        }

                        // executed the last frame. Remove the animation.
                        me.animations[i].chartInstance.animating = false;

                        me.animations.splice(i, 1);
                    } else {
                        ++i;
                    }
                }

                var endTime = Date.now();
                var dropFrames = (endTime - startTime) / me.frameDuration;

                me.dropFrames += dropFrames;

                // Do we have more stuff to animate?
                if (me.animations.length > 0) {
                    me.requestAnimationFrame();
                }
            }
        };
    };

},{}],22:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {
        // Global Chart canvas helpers object for drawing items to canvas
        var helpers = Chart.canvasHelpers = {};

        helpers.drawPoint = function(ctx, pointStyle, radius, x, y) {
            var type, edgeLength, xOffset, yOffset, height, size;

            if (typeof pointStyle === 'object') {
                type = pointStyle.toString();
                if (type === '[object HTMLImageElement]' || type === '[object HTMLCanvasElement]') {
                    ctx.drawImage(pointStyle, x - pointStyle.width / 2, y - pointStyle.height / 2);
                    return;
                }
            }

            if (isNaN(radius) || radius <= 0) {
                return;
            }

            switch (pointStyle) {
                // Default includes circle
                default:
                    ctx.beginPath();
                    ctx.arc(x, y, radius, 0, Math.PI * 2);
                    ctx.closePath();
                    ctx.fill();
                    break;
                case 'triangle':
                    ctx.beginPath();
                    edgeLength = 3 * radius / Math.sqrt(3);
                    height = edgeLength * Math.sqrt(3) / 2;
                    ctx.moveTo(x - edgeLength / 2, y + height / 3);
                    ctx.lineTo(x + edgeLength / 2, y + height / 3);
                    ctx.lineTo(x, y - 2 * height / 3);
                    ctx.closePath();
                    ctx.fill();
                    break;
                case 'rect':
                    size = 1 / Math.SQRT2 * radius;
                    ctx.beginPath();
                    ctx.fillRect(x - size, y - size, 2 * size, 2 * size);
                    ctx.strokeRect(x - size, y - size, 2 * size, 2 * size);
                    break;
                case 'rectRot':
                    size = 1 / Math.SQRT2 * radius;
                    ctx.beginPath();
                    ctx.moveTo(x - size, y);
                    ctx.lineTo(x, y + size);
                    ctx.lineTo(x + size, y);
                    ctx.lineTo(x, y - size);
                    ctx.closePath();
                    ctx.fill();
                    break;
                case 'cross':
                    ctx.beginPath();
                    ctx.moveTo(x, y + radius);
                    ctx.lineTo(x, y - radius);
                    ctx.moveTo(x - radius, y);
                    ctx.lineTo(x + radius, y);
                    ctx.closePath();
                    break;
                case 'crossRot':
                    ctx.beginPath();
                    xOffset = Math.cos(Math.PI / 4) * radius;
                    yOffset = Math.sin(Math.PI / 4) * radius;
                    ctx.moveTo(x - xOffset, y - yOffset);
                    ctx.lineTo(x + xOffset, y + yOffset);
                    ctx.moveTo(x - xOffset, y + yOffset);
                    ctx.lineTo(x + xOffset, y - yOffset);
                    ctx.closePath();
                    break;
                case 'star':
                    ctx.beginPath();
                    ctx.moveTo(x, y + radius);
                    ctx.lineTo(x, y - radius);
                    ctx.moveTo(x - radius, y);
                    ctx.lineTo(x + radius, y);
                    xOffset = Math.cos(Math.PI / 4) * radius;
                    yOffset = Math.sin(Math.PI / 4) * radius;
                    ctx.moveTo(x - xOffset, y - yOffset);
                    ctx.lineTo(x + xOffset, y + yOffset);
                    ctx.moveTo(x - xOffset, y + yOffset);
                    ctx.lineTo(x + xOffset, y - yOffset);
                    ctx.closePath();
                    break;
                case 'line':
                    ctx.beginPath();
                    ctx.moveTo(x - radius, y);
                    ctx.lineTo(x + radius, y);
                    ctx.closePath();
                    break;
                case 'dash':
                    ctx.beginPath();
                    ctx.moveTo(x, y);
                    ctx.lineTo(x + radius, y);
                    ctx.closePath();
                    break;
            }

            ctx.stroke();
        };
    };

},{}],23:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;
        // Create a dictionary of chart types, to allow for extension of existing types
        Chart.types = {};

        // Store a reference to each instance - allowing us to globally resize chart instances on window resize.
        // Destroy method on the chart will remove the instance of the chart from this reference.
        Chart.instances = {};

        // Controllers available for dataset visualization eg. bar, line, slice, etc.
        Chart.controllers = {};

        /**
         * @class Chart.Controller
         * The main controller of a chart.
         */
        Chart.Controller = function(instance) {

            this.chart = instance;
            this.config = instance.config;
            this.options = this.config.options = helpers.configMerge(Chart.defaults.global, Chart.defaults[this.config.type], this.config.options || {});
            this.id = helpers.uid();

            Object.defineProperty(this, 'data', {
                get: function() {
                    return this.config.data;
                }
            });

            // Add the chart instance to the global namespace
            Chart.instances[this.id] = this;

            if (this.options.responsive) {
                // Silent resize before chart draws
                this.resize(true);
            }

            this.initialize();

            return this;
        };

        helpers.extend(Chart.Controller.prototype, /** @lends Chart.Controller */ {

            initialize: function() {
                var me = this;
                // Before init plugin notification
                Chart.plugins.notify('beforeInit', [me]);

                me.bindEvents();

                // Make sure controllers are built first so that each dataset is bound to an axis before the scales
                // are built
                me.ensureScalesHaveIDs();
                me.buildOrUpdateControllers();
                me.buildScales();
                me.updateLayout();
                me.resetElements();
                me.initToolTip();
                me.update();

                // After init plugin notification
                Chart.plugins.notify('afterInit', [me]);

                return me;
            },

            clear: function() {
                helpers.clear(this.chart);
                return this;
            },

            stop: function() {
                // Stops any current animation loop occuring
                Chart.animationService.cancelAnimation(this);
                return this;
            },

            resize: function(silent) {
                var me = this;
                var chart = me.chart;
                var canvas = chart.canvas;
                var newWidth = helpers.getMaximumWidth(canvas);
                var aspectRatio = chart.aspectRatio;
                var newHeight = (me.options.maintainAspectRatio && isNaN(aspectRatio) === false && isFinite(aspectRatio) && aspectRatio !== 0) ? newWidth / aspectRatio : helpers.getMaximumHeight(canvas);

                var sizeChanged = chart.width !== newWidth || chart.height !== newHeight;

                if (!sizeChanged) {
                    return me;
                }

                canvas.width = chart.width = newWidth;
                canvas.height = chart.height = newHeight;

                helpers.retinaScale(chart);

                // Notify any plugins about the resize
                var newSize = {width: newWidth, height: newHeight};
                Chart.plugins.notify('resize', [me, newSize]);

                // Notify of resize
                if (me.options.onResize) {
                    me.options.onResize(me, newSize);
                }

                if (!silent) {
                    me.stop();
                    me.update(me.options.responsiveAnimationDuration);
                }

                return me;
            },

            ensureScalesHaveIDs: function() {
                var options = this.options;
                var scalesOptions = options.scales || {};
                var scaleOptions = options.scale;

                helpers.each(scalesOptions.xAxes, function(xAxisOptions, index) {
                    xAxisOptions.id = xAxisOptions.id || ('x-axis-' + index);
                });

                helpers.each(scalesOptions.yAxes, function(yAxisOptions, index) {
                    yAxisOptions.id = yAxisOptions.id || ('y-axis-' + index);
                });

                if (scaleOptions) {
                    scaleOptions.id = scaleOptions.id || 'scale';
                }
            },

            /**
             * Builds a map of scale ID to scale object for future lookup.
             */
            buildScales: function() {
                var me = this;
                var options = me.options;
                var scales = me.scales = {};
                var items = [];

                if (options.scales) {
                    items = items.concat(
                        (options.scales.xAxes || []).map(function(xAxisOptions) {
                            return {options: xAxisOptions, dtype: 'category'};
                        }),
                        (options.scales.yAxes || []).map(function(yAxisOptions) {
                            return {options: yAxisOptions, dtype: 'linear'};
                        })
                    );
                }

                if (options.scale) {
                    items.push({options: options.scale, dtype: 'radialLinear', isDefault: true});
                }

                helpers.each(items, function(item) {
                    var scaleOptions = item.options;
                    var scaleType = helpers.getValueOrDefault(scaleOptions.type, item.dtype);
                    var scaleClass = Chart.scaleService.getScaleConstructor(scaleType);
                    if (!scaleClass) {
                        return;
                    }

                    var scale = new scaleClass({
                        id: scaleOptions.id,
                        options: scaleOptions,
                        ctx: me.chart.ctx,
                        chart: me
                    });

                    scales[scale.id] = scale;

                    // TODO(SB): I think we should be able to remove this custom case (options.scale)
                    // and consider it as a regular scale part of the "scales"" map only! This would
                    // make the logic easier and remove some useless? custom code.
                    if (item.isDefault) {
                        me.scale = scale;
                    }
                });

                Chart.scaleService.addScalesToLayout(this);
            },

            updateLayout: function() {
                Chart.layoutService.update(this, this.chart.width, this.chart.height);
            },

            buildOrUpdateControllers: function() {
                var me = this;
                var types = [];
                var newControllers = [];

                helpers.each(me.data.datasets, function(dataset, datasetIndex) {
                    var meta = me.getDatasetMeta(datasetIndex);
                    if (!meta.type) {
                        meta.type = dataset.type || me.config.type;
                    }

                    types.push(meta.type);

                    if (meta.controller) {
                        meta.controller.updateIndex(datasetIndex);
                    } else {
                        meta.controller = new Chart.controllers[meta.type](me, datasetIndex);
                        newControllers.push(meta.controller);
                    }
                }, me);

                if (types.length > 1) {
                    for (var i = 1; i < types.length; i++) {
                        if (types[i] !== types[i - 1]) {
                            me.isCombo = true;
                            break;
                        }
                    }
                }

                return newControllers;
            },

            resetElements: function() {
                var me = this;
                helpers.each(me.data.datasets, function(dataset, datasetIndex) {
                    me.getDatasetMeta(datasetIndex).controller.reset();
                }, me);
            },

            update: function(animationDuration, lazy) {
                var me = this;
                Chart.plugins.notify('beforeUpdate', [me]);

                // In case the entire data object changed
                me.tooltip._data = me.data;

                // Make sure dataset controllers are updated and new controllers are reset
                var newControllers = me.buildOrUpdateControllers();

                // Make sure all dataset controllers have correct meta data counts
                helpers.each(me.data.datasets, function(dataset, datasetIndex) {
                    me.getDatasetMeta(datasetIndex).controller.buildOrUpdateElements();
                }, me);

                Chart.layoutService.update(me, me.chart.width, me.chart.height);

                // Apply changes to the dataets that require the scales to have been calculated i.e BorderColor chages
                Chart.plugins.notify('afterScaleUpdate', [me]);

                // Can only reset the new controllers after the scales have been updated
                helpers.each(newControllers, function(controller) {
                    controller.reset();
                });

                me.updateDatasets();

                // Do this before render so that any plugins that need final scale updates can use it
                Chart.plugins.notify('afterUpdate', [me]);

                me.render(animationDuration, lazy);
            },

            /**
             * @method beforeDatasetsUpdate
             * @description Called before all datasets are updated. If a plugin returns false,
             * the datasets update will be cancelled until another chart update is triggered.
             * @param {Object} instance the chart instance being updated.
             * @returns {Boolean} false to cancel the datasets update.
             * @memberof Chart.PluginBase
             * @since version 2.1.5
             * @instance
             */

            /**
             * @method afterDatasetsUpdate
             * @description Called after all datasets have been updated. Note that this
             * extension will not be called if the datasets update has been cancelled.
             * @param {Object} instance the chart instance being updated.
             * @memberof Chart.PluginBase
             * @since version 2.1.5
             * @instance
             */

            /**
             * Updates all datasets unless a plugin returns false to the beforeDatasetsUpdate
             * extension, in which case no datasets will be updated and the afterDatasetsUpdate
             * notification will be skipped.
             * @protected
             * @instance
             */
            updateDatasets: function() {
                var me = this;
                var i, ilen;

                if (Chart.plugins.notify('beforeDatasetsUpdate', [me])) {
                    for (i = 0, ilen = me.data.datasets.length; i < ilen; ++i) {
                        me.getDatasetMeta(i).controller.update();
                    }

                    Chart.plugins.notify('afterDatasetsUpdate', [me]);
                }
            },

            render: function(duration, lazy) {
                var me = this;
                Chart.plugins.notify('beforeRender', [me]);

                var animationOptions = me.options.animation;
                if (animationOptions && ((typeof duration !== 'undefined' && duration !== 0) || (typeof duration === 'undefined' && animationOptions.duration !== 0))) {
                    var animation = new Chart.Animation();
                    animation.numSteps = (duration || animationOptions.duration) / 16.66; // 60 fps
                    animation.easing = animationOptions.easing;

                    // render function
                    animation.render = function(chartInstance, animationObject) {
                        var easingFunction = helpers.easingEffects[animationObject.easing];
                        var stepDecimal = animationObject.currentStep / animationObject.numSteps;
                        var easeDecimal = easingFunction(stepDecimal);

                        chartInstance.draw(easeDecimal, stepDecimal, animationObject.currentStep);
                    };

                    // user events
                    animation.onAnimationProgress = animationOptions.onProgress;
                    animation.onAnimationComplete = animationOptions.onComplete;

                    Chart.animationService.addAnimation(me, animation, duration, lazy);
                } else {
                    me.draw();
                    if (animationOptions && animationOptions.onComplete && animationOptions.onComplete.call) {
                        animationOptions.onComplete.call(me);
                    }
                }
                return me;
            },

            draw: function(ease) {
                var me = this;
                var easingDecimal = ease || 1;
                me.clear();

                Chart.plugins.notify('beforeDraw', [me, easingDecimal]);

                // Draw all the scales
                helpers.each(me.boxes, function(box) {
                    box.draw(me.chartArea);
                }, me);
                if (me.scale) {
                    me.scale.draw();
                }

                Chart.plugins.notify('beforeDatasetsDraw', [me, easingDecimal]);

                // Draw each dataset via its respective controller (reversed to support proper line stacking)
                helpers.each(me.data.datasets, function(dataset, datasetIndex) {
                    if (me.isDatasetVisible(datasetIndex)) {
                        me.getDatasetMeta(datasetIndex).controller.draw(ease);
                    }
                }, me, true);

                Chart.plugins.notify('afterDatasetsDraw', [me, easingDecimal]);

                // Finally draw the tooltip
                me.tooltip.transition(easingDecimal).draw();

                Chart.plugins.notify('afterDraw', [me, easingDecimal]);
            },

            // Get the single element that was clicked on
            // @return : An object containing the dataset index and element index of the matching element. Also contains the rectangle that was draw
            getElementAtEvent: function(e) {
                var me = this;
                var eventPosition = helpers.getRelativePosition(e, me.chart);
                var elementsArray = [];

                helpers.each(me.data.datasets, function(dataset, datasetIndex) {
                    if (me.isDatasetVisible(datasetIndex)) {
                        var meta = me.getDatasetMeta(datasetIndex);
                        helpers.each(meta.data, function(element) {
                            if (element.inRange(eventPosition.x, eventPosition.y)) {
                                elementsArray.push(element);
                                return elementsArray;
                            }
                        });
                    }
                });

                return elementsArray.slice(0, 1);
            },

            getElementsAtEvent: function(e) {
                var me = this;
                var eventPosition = helpers.getRelativePosition(e, me.chart);
                var elementsArray = [];

                var found = function() {
                    if (me.data.datasets) {
                        for (var i = 0; i < me.data.datasets.length; i++) {
                            var meta = me.getDatasetMeta(i);
                            if (me.isDatasetVisible(i)) {
                                for (var j = 0; j < meta.data.length; j++) {
                                    if (meta.data[j].inRange(eventPosition.x, eventPosition.y)) {
                                        return meta.data[j];
                                    }
                                }
                            }
                        }
                    }
                }.call(me);

                if (!found) {
                    return elementsArray;
                }

                helpers.each(me.data.datasets, function(dataset, datasetIndex) {
                    if (me.isDatasetVisible(datasetIndex)) {
                        var meta = me.getDatasetMeta(datasetIndex),
                            element = meta.data[found._index];
                        if (element && !element._view.skip) {
                            elementsArray.push(element);
                        }
                    }
                }, me);

                return elementsArray;
            },

            getElementsAtXAxis: function(e) {
                var me = this;
                var eventPosition = helpers.getRelativePosition(e, me.chart);
                var elementsArray = [];

                var found = function() {
                    if (me.data.datasets) {
                        for (var i = 0; i < me.data.datasets.length; i++) {
                            var meta = me.getDatasetMeta(i);
                            if (me.isDatasetVisible(i)) {
                                for (var j = 0; j < meta.data.length; j++) {
                                    if (meta.data[j].inLabelRange(eventPosition.x, eventPosition.y)) {
                                        return meta.data[j];
                                    }
                                }
                            }
                        }
                    }
                }.call(me);

                if (!found) {
                    return elementsArray;
                }

                helpers.each(me.data.datasets, function(dataset, datasetIndex) {
                    if (me.isDatasetVisible(datasetIndex)) {
                        var meta = me.getDatasetMeta(datasetIndex);
                        var index = helpers.findIndex(meta.data, function(it) {
                            return found._model.x === it._model.x;
                        });
                        if (index !== -1 && !meta.data[index]._view.skip) {
                            elementsArray.push(meta.data[index]);
                        }
                    }
                }, me);

                return elementsArray;
            },

            getElementsAtEventForMode: function(e, mode) {
                var me = this;
                switch (mode) {
                    case 'single':
                        return me.getElementAtEvent(e);
                    case 'label':
                        return me.getElementsAtEvent(e);
                    case 'dataset':
                        return me.getDatasetAtEvent(e);
                    case 'x-axis':
                        return me.getElementsAtXAxis(e);
                    default:
                        return e;
                }
            },

            getDatasetAtEvent: function(e) {
                var elementsArray = this.getElementAtEvent(e);

                if (elementsArray.length > 0) {
                    elementsArray = this.getDatasetMeta(elementsArray[0]._datasetIndex).data;
                }

                return elementsArray;
            },

            getDatasetMeta: function(datasetIndex) {
                var me = this;
                var dataset = me.data.datasets[datasetIndex];
                if (!dataset._meta) {
                    dataset._meta = {};
                }

                var meta = dataset._meta[me.id];
                if (!meta) {
                    meta = dataset._meta[me.id] = {
                        type: null,
                        data: [],
                        dataset: null,
                        controller: null,
                        hidden: null,			// See isDatasetVisible() comment
                        xAxisID: null,
                        yAxisID: null
                    };
                }

                return meta;
            },

            getVisibleDatasetCount: function() {
                var count = 0;
                for (var i = 0, ilen = this.data.datasets.length; i<ilen; ++i) {
                    if (this.isDatasetVisible(i)) {
                        count++;
                    }
                }
                return count;
            },

            isDatasetVisible: function(datasetIndex) {
                var meta = this.getDatasetMeta(datasetIndex);

                // meta.hidden is a per chart dataset hidden flag override with 3 states: if true or false,
                // the dataset.hidden value is ignored, else if null, the dataset hidden state is returned.
                return typeof meta.hidden === 'boolean'? !meta.hidden : !this.data.datasets[datasetIndex].hidden;
            },

            generateLegend: function() {
                return this.options.legendCallback(this);
            },

            destroy: function() {
                var me = this;
                me.stop();
                me.clear();
                helpers.unbindEvents(me, me.events);
                helpers.removeResizeListener(me.chart.canvas.parentNode);

                // Reset canvas height/width attributes
                var canvas = me.chart.canvas;
                canvas.width = me.chart.width;
                canvas.height = me.chart.height;

                // if we scaled the canvas in response to a devicePixelRatio !== 1, we need to undo that transform here
                if (me.chart.originalDevicePixelRatio !== undefined) {
                    me.chart.ctx.scale(1 / me.chart.originalDevicePixelRatio, 1 / me.chart.originalDevicePixelRatio);
                }

                // Reset to the old style since it may have been changed by the device pixel ratio changes
                canvas.style.width = me.chart.originalCanvasStyleWidth;
                canvas.style.height = me.chart.originalCanvasStyleHeight;

                Chart.plugins.notify('destroy', [me]);

                delete Chart.instances[me.id];
            },

            toBase64Image: function() {
                return this.chart.canvas.toDataURL.apply(this.chart.canvas, arguments);
            },

            initToolTip: function() {
                var me = this;
                me.tooltip = new Chart.Tooltip({
                    _chart: me.chart,
                    _chartInstance: me,
                    _data: me.data,
                    _options: me.options.tooltips
                }, me);
            },

            bindEvents: function() {
                var me = this;
                helpers.bindEvents(me, me.options.events, function(evt) {
                    me.eventHandler(evt);
                });
            },

            updateHoverStyle: function(elements, mode, enabled) {
                var method = enabled? 'setHoverStyle' : 'removeHoverStyle';
                var element, i, ilen;

                switch (mode) {
                    case 'single':
                        elements = [elements[0]];
                        break;
                    case 'label':
                    case 'dataset':
                    case 'x-axis':
                        // elements = elements;
                        break;
                    default:
                        // unsupported mode
                        return;
                }

                for (i=0, ilen=elements.length; i<ilen; ++i) {
                    element = elements[i];
                    if (element) {
                        this.getDatasetMeta(element._datasetIndex).controller[method](element);
                    }
                }
            },

            eventHandler: function(e) {
                var me = this;
                var tooltip = me.tooltip;
                var options = me.options || {};
                var hoverOptions = options.hover;
                var tooltipsOptions = options.tooltips;

                me.lastActive = me.lastActive || [];
                me.lastTooltipActive = me.lastTooltipActive || [];

                // Find Active Elements for hover and tooltips
                if (e.type === 'mouseout') {
                    me.active = [];
                    me.tooltipActive = [];
                } else {
                    me.active = me.getElementsAtEventForMode(e, hoverOptions.mode);
                    me.tooltipActive = me.getElementsAtEventForMode(e, tooltipsOptions.mode);
                }

                // On Hover hook
                if (hoverOptions.onHover) {
                    hoverOptions.onHover.call(me, me.active);
                }

                if (me.legend && me.legend.handleEvent) {
                    me.legend.handleEvent(e);
                }

                if (e.type === 'mouseup' || e.type === 'click') {
                    if (options.onClick) {
                        options.onClick.call(me, e, me.active);
                    }
                }

                // Remove styling for last active (even if it may still be active)
                if (me.lastActive.length) {
                    me.updateHoverStyle(me.lastActive, hoverOptions.mode, false);
                }

                // Built in hover styling
                if (me.active.length && hoverOptions.mode) {
                    me.updateHoverStyle(me.active, hoverOptions.mode, true);
                }

                // Built in Tooltips
                if (tooltipsOptions.enabled || tooltipsOptions.custom) {
                    tooltip.initialize();
                    tooltip._active = me.tooltipActive;
                    tooltip.update(true);
                }

                // Hover animations
                tooltip.pivot();

                if (!me.animating) {
                    // If entering, leaving, or changing elements, animate the change via pivot
                    if (!helpers.arrayEquals(me.active, me.lastActive) ||
                        !helpers.arrayEquals(me.tooltipActive, me.lastTooltipActive)) {

                        me.stop();

                        if (tooltipsOptions.enabled || tooltipsOptions.custom) {
                            tooltip.update(true);
                        }

                        // We only need to render at this point. Updating will cause scales to be
                        // recomputed generating flicker & using more memory than necessary.
                        me.render(hoverOptions.animationDuration, true);
                    }
                }

                // Remember Last Actives
                me.lastActive = me.active;
                me.lastTooltipActive = me.tooltipActive;
                return me;
            }
        });
    };

},{}],24:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;
        var noop = helpers.noop;

        // Base class for all dataset controllers (line, bar, etc)
        Chart.DatasetController = function(chart, datasetIndex) {
            this.initialize(chart, datasetIndex);
        };

        helpers.extend(Chart.DatasetController.prototype, {

            /**
             * Element type used to generate a meta dataset (e.g. Chart.element.Line).
             * @type {Chart.core.element}
             */
            datasetElementType: null,

            /**
             * Element type used to generate a meta data (e.g. Chart.element.Point).
             * @type {Chart.core.element}
             */
            dataElementType: null,

            initialize: function(chart, datasetIndex) {
                var me = this;
                me.chart = chart;
                me.index = datasetIndex;
                me.linkScales();
                me.addElements();
            },

            updateIndex: function(datasetIndex) {
                this.index = datasetIndex;
            },

            linkScales: function() {
                var me = this;
                var meta = me.getMeta();
                var dataset = me.getDataset();

                if (meta.xAxisID === null) {
                    meta.xAxisID = dataset.xAxisID || me.chart.options.scales.xAxes[0].id;
                }
                if (meta.yAxisID === null) {
                    meta.yAxisID = dataset.yAxisID || me.chart.options.scales.yAxes[0].id;
                }
            },

            getDataset: function() {
                return this.chart.data.datasets[this.index];
            },

            getMeta: function() {
                return this.chart.getDatasetMeta(this.index);
            },

            getScaleForId: function(scaleID) {
                return this.chart.scales[scaleID];
            },

            reset: function() {
                this.update(true);
            },

            createMetaDataset: function() {
                var me = this;
                var type = me.datasetElementType;
                return type && new type({
                        _chart: me.chart.chart,
                        _datasetIndex: me.index
                    });
            },

            createMetaData: function(index) {
                var me = this;
                var type = me.dataElementType;
                return type && new type({
                        _chart: me.chart.chart,
                        _datasetIndex: me.index,
                        _index: index
                    });
            },

            addElements: function() {
                var me = this;
                var meta = me.getMeta();
                var data = me.getDataset().data || [];
                var metaData = meta.data;
                var i, ilen;

                for (i=0, ilen=data.length; i<ilen; ++i) {
                    metaData[i] = metaData[i] || me.createMetaData(meta, i);
                }

                meta.dataset = meta.dataset || me.createMetaDataset();
            },

            addElementAndReset: function(index) {
                var me = this;
                var element = me.createMetaData(index);
                me.getMeta().data.splice(index, 0, element);
                me.updateElement(element, index, true);
            },

            buildOrUpdateElements: function() {
                // Handle the number of data points changing
                var meta = this.getMeta(),
                    md = meta.data,
                    numData = this.getDataset().data.length,
                    numMetaData = md.length;

                // Make sure that we handle number of datapoints changing
                if (numData < numMetaData) {
                    // Remove excess bars for data points that have been removed
                    md.splice(numData, numMetaData - numData);
                } else if (numData > numMetaData) {
                    // Add new elements
                    for (var index = numMetaData; index < numData; ++index) {
                        this.addElementAndReset(index);
                    }
                }
            },

            update: noop,

            draw: function(ease) {
                var easingDecimal = ease || 1;
                helpers.each(this.getMeta().data, function(element) {
                    element.transition(easingDecimal).draw();
                });
            },

            removeHoverStyle: function(element, elementOpts) {
                var dataset = this.chart.data.datasets[element._datasetIndex],
                    index = element._index,
                    custom = element.custom || {},
                    valueOrDefault = helpers.getValueAtIndexOrDefault,
                    model = element._model;

                model.backgroundColor = custom.backgroundColor ? custom.backgroundColor : valueOrDefault(dataset.backgroundColor, index, elementOpts.backgroundColor);
                model.borderColor = custom.borderColor ? custom.borderColor : valueOrDefault(dataset.borderColor, index, elementOpts.borderColor);
                model.borderWidth = custom.borderWidth ? custom.borderWidth : valueOrDefault(dataset.borderWidth, index, elementOpts.borderWidth);
            },

            setHoverStyle: function(element) {
                var dataset = this.chart.data.datasets[element._datasetIndex],
                    index = element._index,
                    custom = element.custom || {},
                    valueOrDefault = helpers.getValueAtIndexOrDefault,
                    getHoverColor = helpers.getHoverColor,
                    model = element._model;

                model.backgroundColor = custom.hoverBackgroundColor ? custom.hoverBackgroundColor : valueOrDefault(dataset.hoverBackgroundColor, index, getHoverColor(model.backgroundColor));
                model.borderColor = custom.hoverBorderColor ? custom.hoverBorderColor : valueOrDefault(dataset.hoverBorderColor, index, getHoverColor(model.borderColor));
                model.borderWidth = custom.hoverBorderWidth ? custom.hoverBorderWidth : valueOrDefault(dataset.hoverBorderWidth, index, model.borderWidth);
            }

        });

        Chart.DatasetController.extend = helpers.inherits;
    };

},{}],25:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;

        Chart.elements = {};

        Chart.Element = function(configuration) {
            helpers.extend(this, configuration);
            this.initialize.apply(this, arguments);
        };

        helpers.extend(Chart.Element.prototype, {

            initialize: function() {
                this.hidden = false;
            },

            pivot: function() {
                var me = this;
                if (!me._view) {
                    me._view = helpers.clone(me._model);
                }
                me._start = helpers.clone(me._view);
                return me;
            },

            transition: function(ease) {
                var me = this;

                if (!me._view) {
                    me._view = helpers.clone(me._model);
                }

                // No animation -> No Transition
                if (ease === 1) {
                    me._view = me._model;
                    me._start = null;
                    return me;
                }

                if (!me._start) {
                    me.pivot();
                }

                helpers.each(me._model, function(value, key) {

                    if (key[0] === '_') {
                        // Only non-underscored properties
                        // Init if doesn't exist
                    } else if (!me._view.hasOwnProperty(key)) {
                        if (typeof value === 'number' && !isNaN(me._view[key])) {
                            me._view[key] = value * ease;
                        } else {
                            me._view[key] = value;
                        }
                        // No unnecessary computations
                    } else if (value === me._view[key]) {
                        // It's the same! Woohoo!
                        // Color transitions if possible
                    } else if (typeof value === 'string') {
                        try {
                            var color = helpers.color(me._model[key]).mix(helpers.color(me._start[key]), ease);
                            me._view[key] = color.rgbString();
                        } catch (err) {
                            me._view[key] = value;
                        }
                        // Number transitions
                    } else if (typeof value === 'number') {
                        var startVal = me._start[key] !== undefined && isNaN(me._start[key]) === false ? me._start[key] : 0;
                        me._view[key] = ((me._model[key] - startVal) * ease) + startVal;
                        // Everything else
                    } else {
                        me._view[key] = value;
                    }
                }, me);

                return me;
            },

            tooltipPosition: function() {
                return {
                    x: this._model.x,
                    y: this._model.y
                };
            },

            hasValue: function() {
                return helpers.isNumber(this._model.x) && helpers.isNumber(this._model.y);
            }
        });

        Chart.Element.extend = helpers.inherits;

    };

},{}],26:[function(require,module,exports){
    /* global window: false */
    /* global document: false */
    'use strict';

    var color = require(2);

    module.exports = function(Chart) {
        // Global Chart helpers object for utility methods and classes
        var helpers = Chart.helpers = {};

        // -- Basic js utility methods
        helpers.each = function(loopable, callback, self, reverse) {
            // Check to see if null or undefined firstly.
            var i, len;
            if (helpers.isArray(loopable)) {
                len = loopable.length;
                if (reverse) {
                    for (i = len - 1; i >= 0; i--) {
                        callback.call(self, loopable[i], i);
                    }
                } else {
                    for (i = 0; i < len; i++) {
                        callback.call(self, loopable[i], i);
                    }
                }
            } else if (typeof loopable === 'object') {
                var keys = Object.keys(loopable);
                len = keys.length;
                for (i = 0; i < len; i++) {
                    callback.call(self, loopable[keys[i]], keys[i]);
                }
            }
        };
        helpers.clone = function(obj) {
            var objClone = {};
            helpers.each(obj, function(value, key) {
                if (helpers.isArray(value)) {
                    objClone[key] = value.slice(0);
                } else if (typeof value === 'object' && value !== null) {
                    objClone[key] = helpers.clone(value);
                } else {
                    objClone[key] = value;
                }
            });
            return objClone;
        };
        helpers.extend = function(base) {
            var setFn = function(value, key) {
                base[key] = value;
            };
            for (var i = 1, ilen = arguments.length; i < ilen; i++) {
                helpers.each(arguments[i], setFn);
            }
            return base;
        };
        // Need a special merge function to chart configs since they are now grouped
        helpers.configMerge = function(_base) {
            var base = helpers.clone(_base);
            helpers.each(Array.prototype.slice.call(arguments, 1), function(extension) {
                helpers.each(extension, function(value, key) {
                    if (key === 'scales') {
                        // Scale config merging is complex. Add out own function here for that
                        base[key] = helpers.scaleMerge(base.hasOwnProperty(key) ? base[key] : {}, value);

                    } else if (key === 'scale') {
                        // Used in polar area & radar charts since there is only one scale
                        base[key] = helpers.configMerge(base.hasOwnProperty(key) ? base[key] : {}, Chart.scaleService.getScaleDefaults(value.type), value);
                    } else if (base.hasOwnProperty(key) && helpers.isArray(base[key]) && helpers.isArray(value)) {
                        // In this case we have an array of objects replacing another array. Rather than doing a strict replace,
                        // merge. This allows easy scale option merging
                        var baseArray = base[key];

                        helpers.each(value, function(valueObj, index) {

                            if (index < baseArray.length) {
                                if (typeof baseArray[index] === 'object' && baseArray[index] !== null && typeof valueObj === 'object' && valueObj !== null) {
                                    // Two objects are coming together. Do a merge of them.
                                    baseArray[index] = helpers.configMerge(baseArray[index], valueObj);
                                } else {
                                    // Just overwrite in this case since there is nothing to merge
                                    baseArray[index] = valueObj;
                                }
                            } else {
                                baseArray.push(valueObj); // nothing to merge
                            }
                        });

                    } else if (base.hasOwnProperty(key) && typeof base[key] === 'object' && base[key] !== null && typeof value === 'object') {
                        // If we are overwriting an object with an object, do a merge of the properties.
                        base[key] = helpers.configMerge(base[key], value);

                    } else {
                        // can just overwrite the value in this case
                        base[key] = value;
                    }
                });
            });

            return base;
        };
        helpers.scaleMerge = function(_base, extension) {
            var base = helpers.clone(_base);

            helpers.each(extension, function(value, key) {
                if (key === 'xAxes' || key === 'yAxes') {
                    // These properties are arrays of items
                    if (base.hasOwnProperty(key)) {
                        helpers.each(value, function(valueObj, index) {
                            var axisType = helpers.getValueOrDefault(valueObj.type, key === 'xAxes' ? 'category' : 'linear');
                            var axisDefaults = Chart.scaleService.getScaleDefaults(axisType);
                            if (index >= base[key].length || !base[key][index].type) {
                                base[key].push(helpers.configMerge(axisDefaults, valueObj));
                            } else if (valueObj.type && valueObj.type !== base[key][index].type) {
                                // Type changed. Bring in the new defaults before we bring in valueObj so that valueObj can override the correct scale defaults
                                base[key][index] = helpers.configMerge(base[key][index], axisDefaults, valueObj);
                            } else {
                                // Type is the same
                                base[key][index] = helpers.configMerge(base[key][index], valueObj);
                            }
                        });
                    } else {
                        base[key] = [];
                        helpers.each(value, function(valueObj) {
                            var axisType = helpers.getValueOrDefault(valueObj.type, key === 'xAxes' ? 'category' : 'linear');
                            base[key].push(helpers.configMerge(Chart.scaleService.getScaleDefaults(axisType), valueObj));
                        });
                    }
                } else if (base.hasOwnProperty(key) && typeof base[key] === 'object' && base[key] !== null && typeof value === 'object') {
                    // If we are overwriting an object with an object, do a merge of the properties.
                    base[key] = helpers.configMerge(base[key], value);

                } else {
                    // can just overwrite the value in this case
                    base[key] = value;
                }
            });

            return base;
        };
        helpers.getValueAtIndexOrDefault = function(value, index, defaultValue) {
            if (value === undefined || value === null) {
                return defaultValue;
            }

            if (helpers.isArray(value)) {
                return index < value.length ? value[index] : defaultValue;
            }

            return value;
        };
        helpers.getValueOrDefault = function(value, defaultValue) {
            return value === undefined ? defaultValue : value;
        };
        helpers.indexOf = Array.prototype.indexOf?
            function(array, item) {
                return array.indexOf(item);
            }:
            function(array, item) {
                for (var i = 0, ilen = array.length; i < ilen; ++i) {
                    if (array[i] === item) {
                        return i;
                    }
                }
                return -1;
            };
        helpers.where = function(collection, filterCallback) {
            if (helpers.isArray(collection) && Array.prototype.filter) {
                return collection.filter(filterCallback);
            }
            var filtered = [];

            helpers.each(collection, function(item) {
                if (filterCallback(item)) {
                    filtered.push(item);
                }
            });

            return filtered;
        };
        helpers.findIndex = Array.prototype.findIndex?
            function(array, callback, scope) {
                return array.findIndex(callback, scope);
            } :
            function(array, callback, scope) {
                scope = scope === undefined? array : scope;
                for (var i = 0, ilen = array.length; i < ilen; ++i) {
                    if (callback.call(scope, array[i], i, array)) {
                        return i;
                    }
                }
                return -1;
            };
        helpers.findNextWhere = function(arrayToSearch, filterCallback, startIndex) {
            // Default to start of the array
            if (startIndex === undefined || startIndex === null) {
                startIndex = -1;
            }
            for (var i = startIndex + 1; i < arrayToSearch.length; i++) {
                var currentItem = arrayToSearch[i];
                if (filterCallback(currentItem)) {
                    return currentItem;
                }
            }
        };
        helpers.findPreviousWhere = function(arrayToSearch, filterCallback, startIndex) {
            // Default to end of the array
            if (startIndex === undefined || startIndex === null) {
                startIndex = arrayToSearch.length;
            }
            for (var i = startIndex - 1; i >= 0; i--) {
                var currentItem = arrayToSearch[i];
                if (filterCallback(currentItem)) {
                    return currentItem;
                }
            }
        };
        helpers.inherits = function(extensions) {
            // Basic javascript inheritance based on the model created in Backbone.js
            var me = this;
            var ChartElement = (extensions && extensions.hasOwnProperty('constructor')) ? extensions.constructor : function() {
                return me.apply(this, arguments);
            };

            var Surrogate = function() {
                this.constructor = ChartElement;
            };
            Surrogate.prototype = me.prototype;
            ChartElement.prototype = new Surrogate();

            ChartElement.extend = helpers.inherits;

            if (extensions) {
                helpers.extend(ChartElement.prototype, extensions);
            }

            ChartElement.__super__ = me.prototype;

            return ChartElement;
        };
        helpers.noop = function() {};
        helpers.uid = (function() {
            var id = 0;
            return function() {
                return id++;
            };
        }());
        // -- Math methods
        helpers.isNumber = function(n) {
            return !isNaN(parseFloat(n)) && isFinite(n);
        };
        helpers.almostEquals = function(x, y, epsilon) {
            return Math.abs(x - y) < epsilon;
        };
        helpers.max = function(array) {
            return array.reduce(function(max, value) {
                if (!isNaN(value)) {
                    return Math.max(max, value);
                }
                return max;
            }, Number.NEGATIVE_INFINITY);
        };
        helpers.min = function(array) {
            return array.reduce(function(min, value) {
                if (!isNaN(value)) {
                    return Math.min(min, value);
                }
                return min;
            }, Number.POSITIVE_INFINITY);
        };
        helpers.sign = Math.sign?
            function(x) {
                return Math.sign(x);
            } :
            function(x) {
                x = +x; // convert to a number
                if (x === 0 || isNaN(x)) {
                    return x;
                }
                return x > 0 ? 1 : -1;
            };
        helpers.log10 = Math.log10?
            function(x) {
                return Math.log10(x);
            } :
            function(x) {
                return Math.log(x) / Math.LN10;
            };
        helpers.toRadians = function(degrees) {
            return degrees * (Math.PI / 180);
        };
        helpers.toDegrees = function(radians) {
            return radians * (180 / Math.PI);
        };
        // Gets the angle from vertical upright to the point about a centre.
        helpers.getAngleFromPoint = function(centrePoint, anglePoint) {
            var distanceFromXCenter = anglePoint.x - centrePoint.x,
                distanceFromYCenter = anglePoint.y - centrePoint.y,
                radialDistanceFromCenter = Math.sqrt(distanceFromXCenter * distanceFromXCenter + distanceFromYCenter * distanceFromYCenter);

            var angle = Math.atan2(distanceFromYCenter, distanceFromXCenter);

            if (angle < (-0.5 * Math.PI)) {
                angle += 2.0 * Math.PI; // make sure the returned angle is in the range of (-PI/2, 3PI/2]
            }

            return {
                angle: angle,
                distance: radialDistanceFromCenter
            };
        };
        helpers.aliasPixel = function(pixelWidth) {
            return (pixelWidth % 2 === 0) ? 0 : 0.5;
        };
        helpers.splineCurve = function(firstPoint, middlePoint, afterPoint, t) {
            // Props to Rob Spencer at scaled innovation for his post on splining between points
            // http://scaledinnovation.com/analytics/splines/aboutSplines.html

            // This function must also respect "skipped" points

            var previous = firstPoint.skip ? middlePoint : firstPoint,
                current = middlePoint,
                next = afterPoint.skip ? middlePoint : afterPoint;

            var d01 = Math.sqrt(Math.pow(current.x - previous.x, 2) + Math.pow(current.y - previous.y, 2));
            var d12 = Math.sqrt(Math.pow(next.x - current.x, 2) + Math.pow(next.y - current.y, 2));

            var s01 = d01 / (d01 + d12);
            var s12 = d12 / (d01 + d12);

            // If all points are the same, s01 & s02 will be inf
            s01 = isNaN(s01) ? 0 : s01;
            s12 = isNaN(s12) ? 0 : s12;

            var fa = t * s01; // scaling factor for triangle Ta
            var fb = t * s12;

            return {
                previous: {
                    x: current.x - fa * (next.x - previous.x),
                    y: current.y - fa * (next.y - previous.y)
                },
                next: {
                    x: current.x + fb * (next.x - previous.x),
                    y: current.y + fb * (next.y - previous.y)
                }
            };
        };
        helpers.EPSILON = Number.EPSILON || 1e-14;
        helpers.splineCurveMonotone = function(points) {
            // This function calculates Bézier control points in a similar way than |splineCurve|,
            // but preserves monotonicity of the provided data and ensures no local extremums are added
            // between the dataset discrete points due to the interpolation.
            // See : https://en.wikipedia.org/wiki/Monotone_cubic_interpolation

            var pointsWithTangents = (points || []).map(function(point) {
                return {
                    model: point._model,
                    deltaK: 0,
                    mK: 0
                };
            });

            // Calculate slopes (deltaK) and initialize tangents (mK)
            var pointsLen = pointsWithTangents.length;
            var i, pointBefore, pointCurrent, pointAfter;
            for (i = 0; i < pointsLen; ++i) {
                pointCurrent = pointsWithTangents[i];
                if (pointCurrent.model.skip) {
                    continue;
                }

                pointBefore = i > 0 ? pointsWithTangents[i - 1] : null;
                pointAfter = i < pointsLen - 1 ? pointsWithTangents[i + 1] : null;
                if (pointAfter && !pointAfter.model.skip) {
                    pointCurrent.deltaK = (pointAfter.model.y - pointCurrent.model.y) / (pointAfter.model.x - pointCurrent.model.x);
                }

                if (!pointBefore || pointBefore.model.skip) {
                    pointCurrent.mK = pointCurrent.deltaK;
                } else if (!pointAfter || pointAfter.model.skip) {
                    pointCurrent.mK = pointBefore.deltaK;
                } else if (this.sign(pointBefore.deltaK) !== this.sign(pointCurrent.deltaK)) {
                    pointCurrent.mK = 0;
                } else {
                    pointCurrent.mK = (pointBefore.deltaK + pointCurrent.deltaK) / 2;
                }
            }

            // Adjust tangents to ensure monotonic properties
            var alphaK, betaK, tauK, squaredMagnitude;
            for (i = 0; i < pointsLen - 1; ++i) {
                pointCurrent = pointsWithTangents[i];
                pointAfter = pointsWithTangents[i + 1];
                if (pointCurrent.model.skip || pointAfter.model.skip) {
                    continue;
                }

                if (helpers.almostEquals(pointCurrent.deltaK, 0, this.EPSILON)) {
                    pointCurrent.mK = pointAfter.mK = 0;
                    continue;
                }

                alphaK = pointCurrent.mK / pointCurrent.deltaK;
                betaK = pointAfter.mK / pointCurrent.deltaK;
                squaredMagnitude = Math.pow(alphaK, 2) + Math.pow(betaK, 2);
                if (squaredMagnitude <= 9) {
                    continue;
                }

                tauK = 3 / Math.sqrt(squaredMagnitude);
                pointCurrent.mK = alphaK * tauK * pointCurrent.deltaK;
                pointAfter.mK = betaK * tauK * pointCurrent.deltaK;
            }

            // Compute control points
            var deltaX;
            for (i = 0; i < pointsLen; ++i) {
                pointCurrent = pointsWithTangents[i];
                if (pointCurrent.model.skip) {
                    continue;
                }

                pointBefore = i > 0 ? pointsWithTangents[i - 1] : null;
                pointAfter = i < pointsLen - 1 ? pointsWithTangents[i + 1] : null;
                if (pointBefore && !pointBefore.model.skip) {
                    deltaX = (pointCurrent.model.x - pointBefore.model.x) / 3;
                    pointCurrent.model.controlPointPreviousX = pointCurrent.model.x - deltaX;
                    pointCurrent.model.controlPointPreviousY = pointCurrent.model.y - deltaX * pointCurrent.mK;
                }
                if (pointAfter && !pointAfter.model.skip) {
                    deltaX = (pointAfter.model.x - pointCurrent.model.x) / 3;
                    pointCurrent.model.controlPointNextX = pointCurrent.model.x + deltaX;
                    pointCurrent.model.controlPointNextY = pointCurrent.model.y + deltaX * pointCurrent.mK;
                }
            }
        };
        helpers.nextItem = function(collection, index, loop) {
            if (loop) {
                return index >= collection.length - 1 ? collection[0] : collection[index + 1];
            }
            return index >= collection.length - 1 ? collection[collection.length - 1] : collection[index + 1];
        };
        helpers.previousItem = function(collection, index, loop) {
            if (loop) {
                return index <= 0 ? collection[collection.length - 1] : collection[index - 1];
            }
            return index <= 0 ? collection[0] : collection[index - 1];
        };
        // Implementation of the nice number algorithm used in determining where axis labels will go
        helpers.niceNum = function(range, round) {
            var exponent = Math.floor(helpers.log10(range));
            var fraction = range / Math.pow(10, exponent);
            var niceFraction;

            if (round) {
                if (fraction < 1.5) {
                    niceFraction = 1;
                } else if (fraction < 3) {
                    niceFraction = 2;
                } else if (fraction < 7) {
                    niceFraction = 5;
                } else {
                    niceFraction = 10;
                }
            } else if (fraction <= 1.0) {
                niceFraction = 1;
            } else if (fraction <= 2) {
                niceFraction = 2;
            } else if (fraction <= 5) {
                niceFraction = 5;
            } else {
                niceFraction = 10;
            }

            return niceFraction * Math.pow(10, exponent);
        };
        // Easing functions adapted from Robert Penner's easing equations
        // http://www.robertpenner.com/easing/
        var easingEffects = helpers.easingEffects = {
            linear: function(t) {
                return t;
            },
            easeInQuad: function(t) {
                return t * t;
            },
            easeOutQuad: function(t) {
                return -1 * t * (t - 2);
            },
            easeInOutQuad: function(t) {
                if ((t /= 1 / 2) < 1) {
                    return 1 / 2 * t * t;
                }
                return -1 / 2 * ((--t) * (t - 2) - 1);
            },
            easeInCubic: function(t) {
                return t * t * t;
            },
            easeOutCubic: function(t) {
                return 1 * ((t = t / 1 - 1) * t * t + 1);
            },
            easeInOutCubic: function(t) {
                if ((t /= 1 / 2) < 1) {
                    return 1 / 2 * t * t * t;
                }
                return 1 / 2 * ((t -= 2) * t * t + 2);
            },
            easeInQuart: function(t) {
                return t * t * t * t;
            },
            easeOutQuart: function(t) {
                return -1 * ((t = t / 1 - 1) * t * t * t - 1);
            },
            easeInOutQuart: function(t) {
                if ((t /= 1 / 2) < 1) {
                    return 1 / 2 * t * t * t * t;
                }
                return -1 / 2 * ((t -= 2) * t * t * t - 2);
            },
            easeInQuint: function(t) {
                return 1 * (t /= 1) * t * t * t * t;
            },
            easeOutQuint: function(t) {
                return 1 * ((t = t / 1 - 1) * t * t * t * t + 1);
            },
            easeInOutQuint: function(t) {
                if ((t /= 1 / 2) < 1) {
                    return 1 / 2 * t * t * t * t * t;
                }
                return 1 / 2 * ((t -= 2) * t * t * t * t + 2);
            },
            easeInSine: function(t) {
                return -1 * Math.cos(t / 1 * (Math.PI / 2)) + 1;
            },
            easeOutSine: function(t) {
                return 1 * Math.sin(t / 1 * (Math.PI / 2));
            },
            easeInOutSine: function(t) {
                return -1 / 2 * (Math.cos(Math.PI * t / 1) - 1);
            },
            easeInExpo: function(t) {
                return (t === 0) ? 1 : 1 * Math.pow(2, 10 * (t / 1 - 1));
            },
            easeOutExpo: function(t) {
                return (t === 1) ? 1 : 1 * (-Math.pow(2, -10 * t / 1) + 1);
            },
            easeInOutExpo: function(t) {
                if (t === 0) {
                    return 0;
                }
                if (t === 1) {
                    return 1;
                }
                if ((t /= 1 / 2) < 1) {
                    return 1 / 2 * Math.pow(2, 10 * (t - 1));
                }
                return 1 / 2 * (-Math.pow(2, -10 * --t) + 2);
            },
            easeInCirc: function(t) {
                if (t >= 1) {
                    return t;
                }
                return -1 * (Math.sqrt(1 - (t /= 1) * t) - 1);
            },
            easeOutCirc: function(t) {
                return 1 * Math.sqrt(1 - (t = t / 1 - 1) * t);
            },
            easeInOutCirc: function(t) {
                if ((t /= 1 / 2) < 1) {
                    return -1 / 2 * (Math.sqrt(1 - t * t) - 1);
                }
                return 1 / 2 * (Math.sqrt(1 - (t -= 2) * t) + 1);
            },
            easeInElastic: function(t) {
                var s = 1.70158;
                var p = 0;
                var a = 1;
                if (t === 0) {
                    return 0;
                }
                if ((t /= 1) === 1) {
                    return 1;
                }
                if (!p) {
                    p = 1 * 0.3;
                }
                if (a < Math.abs(1)) {
                    a = 1;
                    s = p / 4;
                } else {
                    s = p / (2 * Math.PI) * Math.asin(1 / a);
                }
                return -(a * Math.pow(2, 10 * (t -= 1)) * Math.sin((t * 1 - s) * (2 * Math.PI) / p));
            },
            easeOutElastic: function(t) {
                var s = 1.70158;
                var p = 0;
                var a = 1;
                if (t === 0) {
                    return 0;
                }
                if ((t /= 1) === 1) {
                    return 1;
                }
                if (!p) {
                    p = 1 * 0.3;
                }
                if (a < Math.abs(1)) {
                    a = 1;
                    s = p / 4;
                } else {
                    s = p / (2 * Math.PI) * Math.asin(1 / a);
                }
                return a * Math.pow(2, -10 * t) * Math.sin((t * 1 - s) * (2 * Math.PI) / p) + 1;
            },
            easeInOutElastic: function(t) {
                var s = 1.70158;
                var p = 0;
                var a = 1;
                if (t === 0) {
                    return 0;
                }
                if ((t /= 1 / 2) === 2) {
                    return 1;
                }
                if (!p) {
                    p = 1 * (0.3 * 1.5);
                }
                if (a < Math.abs(1)) {
                    a = 1;
                    s = p / 4;
                } else {
                    s = p / (2 * Math.PI) * Math.asin(1 / a);
                }
                if (t < 1) {
                    return -0.5 * (a * Math.pow(2, 10 * (t -= 1)) * Math.sin((t * 1 - s) * (2 * Math.PI) / p));
                }
                return a * Math.pow(2, -10 * (t -= 1)) * Math.sin((t * 1 - s) * (2 * Math.PI) / p) * 0.5 + 1;
            },
            easeInBack: function(t) {
                var s = 1.70158;
                return 1 * (t /= 1) * t * ((s + 1) * t - s);
            },
            easeOutBack: function(t) {
                var s = 1.70158;
                return 1 * ((t = t / 1 - 1) * t * ((s + 1) * t + s) + 1);
            },
            easeInOutBack: function(t) {
                var s = 1.70158;
                if ((t /= 1 / 2) < 1) {
                    return 1 / 2 * (t * t * (((s *= (1.525)) + 1) * t - s));
                }
                return 1 / 2 * ((t -= 2) * t * (((s *= (1.525)) + 1) * t + s) + 2);
            },
            easeInBounce: function(t) {
                return 1 - easingEffects.easeOutBounce(1 - t);
            },
            easeOutBounce: function(t) {
                if ((t /= 1) < (1 / 2.75)) {
                    return 1 * (7.5625 * t * t);
                } else if (t < (2 / 2.75)) {
                    return 1 * (7.5625 * (t -= (1.5 / 2.75)) * t + 0.75);
                } else if (t < (2.5 / 2.75)) {
                    return 1 * (7.5625 * (t -= (2.25 / 2.75)) * t + 0.9375);
                }
                return 1 * (7.5625 * (t -= (2.625 / 2.75)) * t + 0.984375);
            },
            easeInOutBounce: function(t) {
                if (t < 1 / 2) {
                    return easingEffects.easeInBounce(t * 2) * 0.5;
                }
                return easingEffects.easeOutBounce(t * 2 - 1) * 0.5 + 1 * 0.5;
            }
        };
        // Request animation polyfill - http://www.paulirish.com/2011/requestanimationframe-for-smart-animating/
        helpers.requestAnimFrame = (function() {
            return window.requestAnimationFrame ||
                window.webkitRequestAnimationFrame ||
                window.mozRequestAnimationFrame ||
                window.oRequestAnimationFrame ||
                window.msRequestAnimationFrame ||
                function(callback) {
                    return window.setTimeout(callback, 1000 / 60);
                };
        }());
        helpers.cancelAnimFrame = (function() {
            return window.cancelAnimationFrame ||
                window.webkitCancelAnimationFrame ||
                window.mozCancelAnimationFrame ||
                window.oCancelAnimationFrame ||
                window.msCancelAnimationFrame ||
                function(callback) {
                    return window.clearTimeout(callback, 1000 / 60);
                };
        }());
        // -- DOM methods
        helpers.getRelativePosition = function(evt, chart) {
            var mouseX, mouseY;
            var e = evt.originalEvent || evt,
                canvas = evt.currentTarget || evt.srcElement,
                boundingRect = canvas.getBoundingClientRect();

            var touches = e.touches;
            if (touches && touches.length > 0) {
                mouseX = touches[0].clientX;
                mouseY = touches[0].clientY;

            } else {
                mouseX = e.clientX;
                mouseY = e.clientY;
            }

            // Scale mouse coordinates into canvas coordinates
            // by following the pattern laid out by 'jerryj' in the comments of
            // http://www.html5canvastutorials.com/advanced/html5-canvas-mouse-coordinates/
            var paddingLeft = parseFloat(helpers.getStyle(canvas, 'padding-left'));
            var paddingTop = parseFloat(helpers.getStyle(canvas, 'padding-top'));
            var paddingRight = parseFloat(helpers.getStyle(canvas, 'padding-right'));
            var paddingBottom = parseFloat(helpers.getStyle(canvas, 'padding-bottom'));
            var width = boundingRect.right - boundingRect.left - paddingLeft - paddingRight;
            var height = boundingRect.bottom - boundingRect.top - paddingTop - paddingBottom;

            // We divide by the current device pixel ratio, because the canvas is scaled up by that amount in each direction. However
            // the backend model is in unscaled coordinates. Since we are going to deal with our model coordinates, we go back here
            mouseX = Math.round((mouseX - boundingRect.left - paddingLeft) / (width) * canvas.width / chart.currentDevicePixelRatio);
            mouseY = Math.round((mouseY - boundingRect.top - paddingTop) / (height) * canvas.height / chart.currentDevicePixelRatio);

            return {
                x: mouseX,
                y: mouseY
            };

        };
        helpers.addEvent = function(node, eventType, method) {
            if (node.addEventListener) {
                node.addEventListener(eventType, method);
            } else if (node.attachEvent) {
                node.attachEvent('on' + eventType, method);
            } else {
                node['on' + eventType] = method;
            }
        };
        helpers.removeEvent = function(node, eventType, handler) {
            if (node.removeEventListener) {
                node.removeEventListener(eventType, handler, false);
            } else if (node.detachEvent) {
                node.detachEvent('on' + eventType, handler);
            } else {
                node['on' + eventType] = helpers.noop;
            }
        };
        helpers.bindEvents = function(chartInstance, arrayOfEvents, handler) {
            // Create the events object if it's not already present
            var events = chartInstance.events = chartInstance.events || {};

            helpers.each(arrayOfEvents, function(eventName) {
                events[eventName] = function() {
                    handler.apply(chartInstance, arguments);
                };
                helpers.addEvent(chartInstance.chart.canvas, eventName, events[eventName]);
            });
        };
        helpers.unbindEvents = function(chartInstance, arrayOfEvents) {
            var canvas = chartInstance.chart.canvas;
            helpers.each(arrayOfEvents, function(handler, eventName) {
                helpers.removeEvent(canvas, eventName, handler);
            });
        };

        // Private helper function to convert max-width/max-height values that may be percentages into a number
        function parseMaxStyle(styleValue, node, parentProperty) {
            var valueInPixels;
            if (typeof(styleValue) === 'string') {
                valueInPixels = parseInt(styleValue, 10);

                if (styleValue.indexOf('%') !== -1) {
                    // percentage * size in dimension
                    valueInPixels = valueInPixels / 100 * node.parentNode[parentProperty];
                }
            } else {
                valueInPixels = styleValue;
            }

            return valueInPixels;
        }

        /**
         * Returns if the given value contains an effective constraint.
         * @private
         */
        function isConstrainedValue(value) {
            return value !== undefined && value !== null && value !== 'none';
        }

        // Private helper to get a constraint dimension
        // @param domNode : the node to check the constraint on
        // @param maxStyle : the style that defines the maximum for the direction we are using (maxWidth / maxHeight)
        // @param percentageProperty : property of parent to use when calculating width as a percentage
        // @see http://www.nathanaeljones.com/blog/2013/reading-max-width-cross-browser
        function getConstraintDimension(domNode, maxStyle, percentageProperty) {
            var view = document.defaultView;
            var parentNode = domNode.parentNode;
            var constrainedNode = view.getComputedStyle(domNode)[maxStyle];
            var constrainedContainer = view.getComputedStyle(parentNode)[maxStyle];
            var hasCNode = isConstrainedValue(constrainedNode);
            var hasCContainer = isConstrainedValue(constrainedContainer);
            var infinity = Number.POSITIVE_INFINITY;

            if (hasCNode || hasCContainer) {
                return Math.min(
                    hasCNode? parseMaxStyle(constrainedNode, domNode, percentageProperty) : infinity,
                    hasCContainer? parseMaxStyle(constrainedContainer, parentNode, percentageProperty) : infinity);
            }

            return 'none';
        }
        // returns Number or undefined if no constraint
        helpers.getConstraintWidth = function(domNode) {
            return getConstraintDimension(domNode, 'max-width', 'clientWidth');
        };
        // returns Number or undefined if no constraint
        helpers.getConstraintHeight = function(domNode) {
            return getConstraintDimension(domNode, 'max-height', 'clientHeight');
        };
        helpers.getMaximumWidth = function(domNode) {
            var container = domNode.parentNode;
            var paddingLeft = parseInt(helpers.getStyle(container, 'padding-left'), 10);
            var paddingRight = parseInt(helpers.getStyle(container, 'padding-right'), 10);
            var w = container.clientWidth - paddingLeft - paddingRight;
            var cw = helpers.getConstraintWidth(domNode);
            return isNaN(cw)? w : Math.min(w, cw);
        };
        helpers.getMaximumHeight = function(domNode) {
            var container = domNode.parentNode;
            var paddingTop = parseInt(helpers.getStyle(container, 'padding-top'), 10);
            var paddingBottom = parseInt(helpers.getStyle(container, 'padding-bottom'), 10);
            var h = container.clientHeight - paddingTop - paddingBottom;
            var ch = helpers.getConstraintHeight(domNode);
            return isNaN(ch)? h : Math.min(h, ch);
        };
        helpers.getStyle = function(el, property) {
            return el.currentStyle ?
                el.currentStyle[property] :
                document.defaultView.getComputedStyle(el, null).getPropertyValue(property);
        };
        helpers.retinaScale = function(chart) {
            var ctx = chart.ctx;
            var canvas = chart.canvas;
            var width = canvas.width;
            var height = canvas.height;
            var pixelRatio = chart.currentDevicePixelRatio = window.devicePixelRatio || 1;

            if (pixelRatio !== 1) {
                canvas.height = height * pixelRatio;
                canvas.width = width * pixelRatio;
                ctx.scale(pixelRatio, pixelRatio);

                // Store the device pixel ratio so that we can go backwards in `destroy`.
                // The devicePixelRatio changes with zoom, so there are no guarantees that it is the same
                // when destroy is called
                chart.originalDevicePixelRatio = chart.originalDevicePixelRatio || pixelRatio;
            }

            canvas.style.width = width + 'px';
            canvas.style.height = height + 'px';
        };
        // -- Canvas methods
        helpers.clear = function(chart) {
            chart.ctx.clearRect(0, 0, chart.width, chart.height);
        };
        helpers.fontString = function(pixelSize, fontStyle, fontFamily) {
            return fontStyle + ' ' + pixelSize + 'px ' + fontFamily;
        };
        helpers.longestText = function(ctx, font, arrayOfThings, cache) {
            cache = cache || {};
            var data = cache.data = cache.data || {};
            var gc = cache.garbageCollect = cache.garbageCollect || [];

            if (cache.font !== font) {
                data = cache.data = {};
                gc = cache.garbageCollect = [];
                cache.font = font;
            }

            ctx.font = font;
            var longest = 0;
            helpers.each(arrayOfThings, function(thing) {
                // Undefined strings and arrays should not be measured
                if (thing !== undefined && thing !== null && helpers.isArray(thing) !== true) {
                    longest = helpers.measureText(ctx, data, gc, longest, thing);
                } else if (helpers.isArray(thing)) {
                    // if it is an array lets measure each element
                    // to do maybe simplify this function a bit so we can do this more recursively?
                    helpers.each(thing, function(nestedThing) {
                        // Undefined strings and arrays should not be measured
                        if (nestedThing !== undefined && nestedThing !== null && !helpers.isArray(nestedThing)) {
                            longest = helpers.measureText(ctx, data, gc, longest, nestedThing);
                        }
                    });
                }
            });

            var gcLen = gc.length / 2;
            if (gcLen > arrayOfThings.length) {
                for (var i = 0; i < gcLen; i++) {
                    delete data[gc[i]];
                }
                gc.splice(0, gcLen);
            }
            return longest;
        };
        helpers.measureText = function(ctx, data, gc, longest, string) {
            var textWidth = data[string];
            if (!textWidth) {
                textWidth = data[string] = ctx.measureText(string).width;
                gc.push(string);
            }
            if (textWidth > longest) {
                longest = textWidth;
            }
            return longest;
        };
        helpers.numberOfLabelLines = function(arrayOfThings) {
            var numberOfLines = 1;
            helpers.each(arrayOfThings, function(thing) {
                if (helpers.isArray(thing)) {
                    if (thing.length > numberOfLines) {
                        numberOfLines = thing.length;
                    }
                }
            });
            return numberOfLines;
        };
        helpers.drawRoundedRectangle = function(ctx, x, y, width, height, radius) {
            ctx.beginPath();
            ctx.moveTo(x + radius, y);
            ctx.lineTo(x + width - radius, y);
            ctx.quadraticCurveTo(x + width, y, x + width, y + radius);
            ctx.lineTo(x + width, y + height - radius);
            ctx.quadraticCurveTo(x + width, y + height, x + width - radius, y + height);
            ctx.lineTo(x + radius, y + height);
            ctx.quadraticCurveTo(x, y + height, x, y + height - radius);
            ctx.lineTo(x, y + radius);
            ctx.quadraticCurveTo(x, y, x + radius, y);
            ctx.closePath();
        };
        helpers.color = function(c) {
            if (!color) {
                console.error('Color.js not found!');
                return c;
            }

            /* global CanvasGradient */
            if (c instanceof CanvasGradient) {
                return color(Chart.defaults.global.defaultColor);
            }

            return color(c);
        };
        helpers.addResizeListener = function(node, callback) {
            // Hide an iframe before the node
            var hiddenIframe = document.createElement('iframe');
            var hiddenIframeClass = 'chartjs-hidden-iframe';

            if (hiddenIframe.classlist) {
                // can use classlist
                hiddenIframe.classlist.add(hiddenIframeClass);
            } else {
                hiddenIframe.setAttribute('class', hiddenIframeClass);
            }

            // Set the style
            hiddenIframe.tabIndex = -1;
            var style = hiddenIframe.style;
            style.width = '100%';
            style.display = 'block';
            style.border = 0;
            style.height = 0;
            style.margin = 0;
            style.position = 'absolute';
            style.left = 0;
            style.right = 0;
            style.top = 0;
            style.bottom = 0;

            // Insert the iframe so that contentWindow is available
            node.insertBefore(hiddenIframe, node.firstChild);

            (hiddenIframe.contentWindow || hiddenIframe).onresize = function() {
                if (callback) {
                    return callback();
                }
            };
        };
        helpers.removeResizeListener = function(node) {
            var hiddenIframe = node.querySelector('.chartjs-hidden-iframe');

            // Remove the resize detect iframe
            if (hiddenIframe) {
                hiddenIframe.parentNode.removeChild(hiddenIframe);
            }
        };
        helpers.isArray = Array.isArray?
            function(obj) {
                return Array.isArray(obj);
            } :
            function(obj) {
                return Object.prototype.toString.call(obj) === '[object Array]';
            };
        // ! @see http://stackoverflow.com/a/14853974
        helpers.arrayEquals = function(a0, a1) {
            var i, ilen, v0, v1;

            if (!a0 || !a1 || a0.length !== a1.length) {
                return false;
            }

            for (i = 0, ilen=a0.length; i < ilen; ++i) {
                v0 = a0[i];
                v1 = a1[i];

                if (v0 instanceof Array && v1 instanceof Array) {
                    if (!helpers.arrayEquals(v0, v1)) {
                        return false;
                    }
                } else if (v0 !== v1) {
                    // NOTE: two different object instances will never be equal: {x:20} != {x:20}
                    return false;
                }
            }

            return true;
        };
        helpers.callCallback = function(fn, args, _tArg) {
            if (fn && typeof fn.call === 'function') {
                fn.apply(_tArg, args);
            }
        };
        helpers.getHoverColor = function(colorValue) {
            /* global CanvasPattern */
            return (colorValue instanceof CanvasPattern) ?
                colorValue :
                helpers.color(colorValue).saturate(0.5).darken(0.1).rgbString();
        };
    };

},{"2":2}],27:[function(require,module,exports){
    'use strict';

    module.exports = function() {

        // Occupy the global variable of Chart, and create a simple base class
        var Chart = function(context, config) {
            var me = this;
            var helpers = Chart.helpers;
            me.config = config || {
                    data: {
                        datasets: []
                    }
                };

            // Support a jQuery'd canvas element
            if (context.length && context[0].getContext) {
                context = context[0];
            }

            // Support a canvas domnode
            if (context.getContext) {
                context = context.getContext('2d');
            }

            me.ctx = context;
            me.canvas = context.canvas;

            context.canvas.style.display = context.canvas.style.display || 'block';

            // Figure out what the size of the chart will be.
            // If the canvas has a specified width and height, we use those else
            // we look to see if the canvas node has a CSS width and height.
            // If there is still no height, fill the parent container
            me.width = context.canvas.width || parseInt(helpers.getStyle(context.canvas, 'width'), 10) || helpers.getMaximumWidth(context.canvas);
            me.height = context.canvas.height || parseInt(helpers.getStyle(context.canvas, 'height'), 10) || helpers.getMaximumHeight(context.canvas);

            me.aspectRatio = me.width / me.height;

            if (isNaN(me.aspectRatio) || isFinite(me.aspectRatio) === false) {
                // If the canvas has no size, try and figure out what the aspect ratio will be.
                // Some charts prefer square canvases (pie, radar, etc). If that is specified, use that
                // else use the canvas default ratio of 2
                me.aspectRatio = config.aspectRatio !== undefined ? config.aspectRatio : 2;
            }

            // Store the original style of the element so we can set it back
            me.originalCanvasStyleWidth = context.canvas.style.width;
            me.originalCanvasStyleHeight = context.canvas.style.height;

            // High pixel density displays - multiply the size of the canvas height/width by the device pixel ratio, then scale.
            helpers.retinaScale(me);
            me.controller = new Chart.Controller(me);

            // Always bind this so that if the responsive state changes we still work
            helpers.addResizeListener(context.canvas.parentNode, function() {
                if (me.controller && me.controller.config.options.responsive) {
                    me.controller.resize();
                }
            });

            return me.controller ? me.controller : me;

        };

        // Globally expose the defaults to allow for user updating/changing
        Chart.defaults = {
            global: {
                responsive: true,
                responsiveAnimationDuration: 0,
                maintainAspectRatio: true,
                events: ['mousemove', 'mouseout', 'click', 'touchstart', 'touchmove'],
                hover: {
                    onHover: null,
                    mode: 'single',
                    animationDuration: 400
                },
                onClick: null,
                defaultColor: 'rgba(0,0,0,0.1)',
                defaultFontColor: '#666',
                defaultFontFamily: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",
                defaultFontSize: 12,
                defaultFontStyle: 'normal',
                showLines: true,

                // Element defaults defined in element extensions
                elements: {},

                // Legend callback string
                legendCallback: function(chart) {
                    var text = [];
                    text.push('<ul class="' + chart.id + '-legend">');
                    for (var i = 0; i < chart.data.datasets.length; i++) {
                        text.push('<li><span style="background-color:' + chart.data.datasets[i].backgroundColor + '"></span>');
                        if (chart.data.datasets[i].label) {
                            text.push(chart.data.datasets[i].label);
                        }
                        text.push('</li>');
                    }
                    text.push('</ul>');

                    return text.join('');
                }
            }
        };

        Chart.Chart = Chart;

        return Chart;

    };

},{}],28:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;

        // The layout service is very self explanatory.  It's responsible for the layout within a chart.
        // Scales, Legends and Plugins all rely on the layout service and can easily register to be placed anywhere they need
        // It is this service's responsibility of carrying out that layout.
        Chart.layoutService = {
            defaults: {},

            // Register a box to a chartInstance. A box is simply a reference to an object that requires layout. eg. Scales, Legend, Plugins.
            addBox: function(chartInstance, box) {
                if (!chartInstance.boxes) {
                    chartInstance.boxes = [];
                }
                chartInstance.boxes.push(box);
            },

            removeBox: function(chartInstance, box) {
                if (!chartInstance.boxes) {
                    return;
                }
                chartInstance.boxes.splice(chartInstance.boxes.indexOf(box), 1);
            },

            // The most important function
            update: function(chartInstance, width, height) {

                if (!chartInstance) {
                    return;
                }

                var xPadding = 0;
                var yPadding = 0;

                var leftBoxes = helpers.where(chartInstance.boxes, function(box) {
                    return box.options.position === 'left';
                });
                var rightBoxes = helpers.where(chartInstance.boxes, function(box) {
                    return box.options.position === 'right';
                });
                var topBoxes = helpers.where(chartInstance.boxes, function(box) {
                    return box.options.position === 'top';
                });
                var bottomBoxes = helpers.where(chartInstance.boxes, function(box) {
                    return box.options.position === 'bottom';
                });

                // Boxes that overlay the chartarea such as the radialLinear scale
                var chartAreaBoxes = helpers.where(chartInstance.boxes, function(box) {
                    return box.options.position === 'chartArea';
                });

                // Ensure that full width boxes are at the very top / bottom
                topBoxes.sort(function(a, b) {
                    return (b.options.fullWidth ? 1 : 0) - (a.options.fullWidth ? 1 : 0);
                });
                bottomBoxes.sort(function(a, b) {
                    return (a.options.fullWidth ? 1 : 0) - (b.options.fullWidth ? 1 : 0);
                });

                // Essentially we now have any number of boxes on each of the 4 sides.
                // Our canvas looks like the following.
                // The areas L1 and L2 are the left axes. R1 is the right axis, T1 is the top axis and
                // B1 is the bottom axis
                // There are also 4 quadrant-like locations (left to right instead of clockwise) reserved for chart overlays
                // These locations are single-box locations only, when trying to register a chartArea location that is already taken,
                // an error will be thrown.
                //
                // |----------------------------------------------------|
                // |                  T1 (Full Width)                   |
                // |----------------------------------------------------|
                // |    |    |                 T2                  |    |
                // |    |----|-------------------------------------|----|
                // |    |    | C1 |                           | C2 |    |
                // |    |    |----|                           |----|    |
                // |    |    |                                     |    |
                // | L1 | L2 |           ChartArea (C0)            | R1 |
                // |    |    |                                     |    |
                // |    |    |----|                           |----|    |
                // |    |    | C3 |                           | C4 |    |
                // |    |----|-------------------------------------|----|
                // |    |    |                 B1                  |    |
                // |----------------------------------------------------|
                // |                  B2 (Full Width)                   |
                // |----------------------------------------------------|
                //
                // What we do to find the best sizing, we do the following
                // 1. Determine the minimum size of the chart area.
                // 2. Split the remaining width equally between each vertical axis
                // 3. Split the remaining height equally between each horizontal axis
                // 4. Give each layout the maximum size it can be. The layout will return it's minimum size
                // 5. Adjust the sizes of each axis based on it's minimum reported size.
                // 6. Refit each axis
                // 7. Position each axis in the final location
                // 8. Tell the chart the final location of the chart area
                // 9. Tell any axes that overlay the chart area the positions of the chart area

                // Step 1
                var chartWidth = width - (2 * xPadding);
                var chartHeight = height - (2 * yPadding);
                var chartAreaWidth = chartWidth / 2; // min 50%
                var chartAreaHeight = chartHeight / 2; // min 50%

                // Step 2
                var verticalBoxWidth = (width - chartAreaWidth) / (leftBoxes.length + rightBoxes.length);

                // Step 3
                var horizontalBoxHeight = (height - chartAreaHeight) / (topBoxes.length + bottomBoxes.length);

                // Step 4
                var maxChartAreaWidth = chartWidth;
                var maxChartAreaHeight = chartHeight;
                var minBoxSizes = [];

                function getMinimumBoxSize(box) {
                    var minSize;
                    var isHorizontal = box.isHorizontal();

                    if (isHorizontal) {
                        minSize = box.update(box.options.fullWidth ? chartWidth : maxChartAreaWidth, horizontalBoxHeight);
                        maxChartAreaHeight -= minSize.height;
                    } else {
                        minSize = box.update(verticalBoxWidth, chartAreaHeight);
                        maxChartAreaWidth -= minSize.width;
                    }

                    minBoxSizes.push({
                        horizontal: isHorizontal,
                        minSize: minSize,
                        box: box
                    });
                }

                helpers.each(leftBoxes.concat(rightBoxes, topBoxes, bottomBoxes), getMinimumBoxSize);

                // At this point, maxChartAreaHeight and maxChartAreaWidth are the size the chart area could
                // be if the axes are drawn at their minimum sizes.

                // Steps 5 & 6
                var totalLeftBoxesWidth = xPadding;
                var totalRightBoxesWidth = xPadding;
                var totalTopBoxesHeight = yPadding;
                var totalBottomBoxesHeight = yPadding;

                // Function to fit a box
                function fitBox(box) {
                    var minBoxSize = helpers.findNextWhere(minBoxSizes, function(minBox) {
                        return minBox.box === box;
                    });

                    if (minBoxSize) {
                        if (box.isHorizontal()) {
                            var scaleMargin = {
                                left: totalLeftBoxesWidth,
                                right: totalRightBoxesWidth,
                                top: 0,
                                bottom: 0
                            };

                            // Don't use min size here because of label rotation. When the labels are rotated, their rotation highly depends
                            // on the margin. Sometimes they need to increase in size slightly
                            box.update(box.options.fullWidth ? chartWidth : maxChartAreaWidth, chartHeight / 2, scaleMargin);
                        } else {
                            box.update(minBoxSize.minSize.width, maxChartAreaHeight);
                        }
                    }
                }

                // Update, and calculate the left and right margins for the horizontal boxes
                helpers.each(leftBoxes.concat(rightBoxes), fitBox);

                helpers.each(leftBoxes, function(box) {
                    totalLeftBoxesWidth += box.width;
                });

                helpers.each(rightBoxes, function(box) {
                    totalRightBoxesWidth += box.width;
                });

                // Set the Left and Right margins for the horizontal boxes
                helpers.each(topBoxes.concat(bottomBoxes), fitBox);

                // Figure out how much margin is on the top and bottom of the vertical boxes
                helpers.each(topBoxes, function(box) {
                    totalTopBoxesHeight += box.height;
                });

                helpers.each(bottomBoxes, function(box) {
                    totalBottomBoxesHeight += box.height;
                });

                function finalFitVerticalBox(box) {
                    var minBoxSize = helpers.findNextWhere(minBoxSizes, function(minSize) {
                        return minSize.box === box;
                    });

                    var scaleMargin = {
                        left: 0,
                        right: 0,
                        top: totalTopBoxesHeight,
                        bottom: totalBottomBoxesHeight
                    };

                    if (minBoxSize) {
                        box.update(minBoxSize.minSize.width, maxChartAreaHeight, scaleMargin);
                    }
                }

                // Let the left layout know the final margin
                helpers.each(leftBoxes.concat(rightBoxes), finalFitVerticalBox);

                // Recalculate because the size of each layout might have changed slightly due to the margins (label rotation for instance)
                totalLeftBoxesWidth = xPadding;
                totalRightBoxesWidth = xPadding;
                totalTopBoxesHeight = yPadding;
                totalBottomBoxesHeight = yPadding;

                helpers.each(leftBoxes, function(box) {
                    totalLeftBoxesWidth += box.width;
                });

                helpers.each(rightBoxes, function(box) {
                    totalRightBoxesWidth += box.width;
                });

                helpers.each(topBoxes, function(box) {
                    totalTopBoxesHeight += box.height;
                });
                helpers.each(bottomBoxes, function(box) {
                    totalBottomBoxesHeight += box.height;
                });

                // Figure out if our chart area changed. This would occur if the dataset layout label rotation
                // changed due to the application of the margins in step 6. Since we can only get bigger, this is safe to do
                // without calling `fit` again
                var newMaxChartAreaHeight = height - totalTopBoxesHeight - totalBottomBoxesHeight;
                var newMaxChartAreaWidth = width - totalLeftBoxesWidth - totalRightBoxesWidth;

                if (newMaxChartAreaWidth !== maxChartAreaWidth || newMaxChartAreaHeight !== maxChartAreaHeight) {
                    helpers.each(leftBoxes, function(box) {
                        box.height = newMaxChartAreaHeight;
                    });

                    helpers.each(rightBoxes, function(box) {
                        box.height = newMaxChartAreaHeight;
                    });

                    helpers.each(topBoxes, function(box) {
                        if (!box.options.fullWidth) {
                            box.width = newMaxChartAreaWidth;
                        }
                    });

                    helpers.each(bottomBoxes, function(box) {
                        if (!box.options.fullWidth) {
                            box.width = newMaxChartAreaWidth;
                        }
                    });

                    maxChartAreaHeight = newMaxChartAreaHeight;
                    maxChartAreaWidth = newMaxChartAreaWidth;
                }

                // Step 7 - Position the boxes
                var left = xPadding;
                var top = yPadding;

                function placeBox(box) {
                    if (box.isHorizontal()) {
                        box.left = box.options.fullWidth ? xPadding : totalLeftBoxesWidth;
                        box.right = box.options.fullWidth ? width - xPadding : totalLeftBoxesWidth + maxChartAreaWidth;
                        box.top = top;
                        box.bottom = top + box.height;

                        // Move to next point
                        top = box.bottom;

                    } else {

                        box.left = left;
                        box.right = left + box.width;
                        box.top = totalTopBoxesHeight;
                        box.bottom = totalTopBoxesHeight + maxChartAreaHeight;

                        // Move to next point
                        left = box.right;
                    }
                }

                helpers.each(leftBoxes.concat(topBoxes), placeBox);

                // Account for chart width and height
                left += maxChartAreaWidth;
                top += maxChartAreaHeight;

                helpers.each(rightBoxes, placeBox);
                helpers.each(bottomBoxes, placeBox);

                // Step 8
                chartInstance.chartArea = {
                    left: totalLeftBoxesWidth,
                    top: totalTopBoxesHeight,
                    right: totalLeftBoxesWidth + maxChartAreaWidth,
                    bottom: totalTopBoxesHeight + maxChartAreaHeight
                };

                // Step 9
                helpers.each(chartAreaBoxes, function(box) {
                    box.left = chartInstance.chartArea.left;
                    box.top = chartInstance.chartArea.top;
                    box.right = chartInstance.chartArea.right;
                    box.bottom = chartInstance.chartArea.bottom;

                    box.update(maxChartAreaWidth, maxChartAreaHeight);
                });
            }
        };
    };

},{}],29:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;
        var noop = helpers.noop;

        Chart.defaults.global.legend = {

            display: true,
            position: 'top',
            fullWidth: true, // marks that this box should take the full width of the canvas (pushing down other boxes)
            reverse: false,

            // a callback that will handle
            onClick: function(e, legendItem) {
                var index = legendItem.datasetIndex;
                var ci = this.chart;
                var meta = ci.getDatasetMeta(index);

                // See controller.isDatasetVisible comment
                meta.hidden = meta.hidden === null? !ci.data.datasets[index].hidden : null;

                // We hid a dataset ... rerender the chart
                ci.update();
            },

            onHover: null,

            labels: {
                boxWidth: 40,
                padding: 10,
                // Generates labels shown in the legend
                // Valid properties to return:
                // text : text to display
                // fillStyle : fill of coloured box
                // strokeStyle: stroke of coloured box
                // hidden : if this legend item refers to a hidden item
                // lineCap : cap style for line
                // lineDash
                // lineDashOffset :
                // lineJoin :
                // lineWidth :
                generateLabels: function(chart) {
                    var data = chart.data;
                    return helpers.isArray(data.datasets) ? data.datasets.map(function(dataset, i) {
                        return {
                            text: dataset.label,
                            fillStyle: (!helpers.isArray(dataset.backgroundColor) ? dataset.backgroundColor : dataset.backgroundColor[0]),
                            hidden: !chart.isDatasetVisible(i),
                            lineCap: dataset.borderCapStyle,
                            lineDash: dataset.borderDash,
                            lineDashOffset: dataset.borderDashOffset,
                            lineJoin: dataset.borderJoinStyle,
                            lineWidth: dataset.borderWidth,
                            strokeStyle: dataset.borderColor,
                            pointStyle: dataset.pointStyle,

                            // Below is extra data used for toggling the datasets
                            datasetIndex: i
                        };
                    }, this) : [];
                }
            }
        };

        Chart.Legend = Chart.Element.extend({

            initialize: function(config) {
                helpers.extend(this, config);

                // Contains hit boxes for each dataset (in dataset order)
                this.legendHitBoxes = [];

                // Are we in doughnut mode which has a different data type
                this.doughnutMode = false;
            },

            // These methods are ordered by lifecyle. Utilities then follow.
            // Any function defined here is inherited by all legend types.
            // Any function can be extended by the legend type

            beforeUpdate: noop,
            update: function(maxWidth, maxHeight, margins) {
                var me = this;

                // Update Lifecycle - Probably don't want to ever extend or overwrite this function ;)
                me.beforeUpdate();

                // Absorb the master measurements
                me.maxWidth = maxWidth;
                me.maxHeight = maxHeight;
                me.margins = margins;

                // Dimensions
                me.beforeSetDimensions();
                me.setDimensions();
                me.afterSetDimensions();
                // Labels
                me.beforeBuildLabels();
                me.buildLabels();
                me.afterBuildLabels();

                // Fit
                me.beforeFit();
                me.fit();
                me.afterFit();
                //
                me.afterUpdate();

                return me.minSize;
            },
            afterUpdate: noop,

            //

            beforeSetDimensions: noop,
            setDimensions: function() {
                var me = this;
                // Set the unconstrained dimension before label rotation
                if (me.isHorizontal()) {
                    // Reset position before calculating rotation
                    me.width = me.maxWidth;
                    me.left = 0;
                    me.right = me.width;
                } else {
                    me.height = me.maxHeight;

                    // Reset position before calculating rotation
                    me.top = 0;
                    me.bottom = me.height;
                }

                // Reset padding
                me.paddingLeft = 0;
                me.paddingTop = 0;
                me.paddingRight = 0;
                me.paddingBottom = 0;

                // Reset minSize
                me.minSize = {
                    width: 0,
                    height: 0
                };
            },
            afterSetDimensions: noop,

            //

            beforeBuildLabels: noop,
            buildLabels: function() {
                var me = this;
                me.legendItems = me.options.labels.generateLabels.call(me, me.chart);
                if (me.options.reverse) {
                    me.legendItems.reverse();
                }
            },
            afterBuildLabels: noop,

            //

            beforeFit: noop,
            fit: function() {
                var me = this;
                var opts = me.options;
                var labelOpts = opts.labels;
                var display = opts.display;

                var ctx = me.ctx;

                var globalDefault = Chart.defaults.global,
                    itemOrDefault = helpers.getValueOrDefault,
                    fontSize = itemOrDefault(labelOpts.fontSize, globalDefault.defaultFontSize),
                    fontStyle = itemOrDefault(labelOpts.fontStyle, globalDefault.defaultFontStyle),
                    fontFamily = itemOrDefault(labelOpts.fontFamily, globalDefault.defaultFontFamily),
                    labelFont = helpers.fontString(fontSize, fontStyle, fontFamily);

                // Reset hit boxes
                var hitboxes = me.legendHitBoxes = [];

                var minSize = me.minSize;
                var isHorizontal = me.isHorizontal();

                if (isHorizontal) {
                    minSize.width = me.maxWidth; // fill all the width
                    minSize.height = display ? 10 : 0;
                } else {
                    minSize.width = display ? 10 : 0;
                    minSize.height = me.maxHeight; // fill all the height
                }

                // Increase sizes here
                if (display) {
                    ctx.font = labelFont;

                    if (isHorizontal) {
                        // Labels

                        // Width of each line of legend boxes. Labels wrap onto multiple lines when there are too many to fit on one
                        var lineWidths = me.lineWidths = [0];
                        var totalHeight = me.legendItems.length ? fontSize + (labelOpts.padding) : 0;

                        ctx.textAlign = 'left';
                        ctx.textBaseline = 'top';

                        helpers.each(me.legendItems, function(legendItem, i) {
                            var boxWidth = labelOpts.usePointStyle ?
                            fontSize * Math.sqrt(2) :
                                labelOpts.boxWidth;

                            var width = boxWidth + (fontSize / 2) + ctx.measureText(legendItem.text).width;
                            if (lineWidths[lineWidths.length - 1] + width + labelOpts.padding >= me.width) {
                                totalHeight += fontSize + (labelOpts.padding);
                                lineWidths[lineWidths.length] = me.left;
                            }

                            // Store the hitbox width and height here. Final position will be updated in `draw`
                            hitboxes[i] = {
                                left: 0,
                                top: 0,
                                width: width,
                                height: fontSize
                            };

                            lineWidths[lineWidths.length - 1] += width + labelOpts.padding;
                        });

                        minSize.height += totalHeight;

                    } else {
                        var vPadding = labelOpts.padding;
                        var columnWidths = me.columnWidths = [];
                        var totalWidth = labelOpts.padding;
                        var currentColWidth = 0;
                        var currentColHeight = 0;
                        var itemHeight = fontSize + vPadding;

                        helpers.each(me.legendItems, function(legendItem, i) {
                            // If usePointStyle is set, multiple boxWidth by 2 since it represents
                            // the radius and not truly the width
                            var boxWidth = labelOpts.usePointStyle ? 2 * labelOpts.boxWidth : labelOpts.boxWidth;

                            var itemWidth = boxWidth + (fontSize / 2) + ctx.measureText(legendItem.text).width;

                            // If too tall, go to new column
                            if (currentColHeight + itemHeight > minSize.height) {
                                totalWidth += currentColWidth + labelOpts.padding;
                                columnWidths.push(currentColWidth); // previous column width

                                currentColWidth = 0;
                                currentColHeight = 0;
                            }

                            // Get max width
                            currentColWidth = Math.max(currentColWidth, itemWidth);
                            currentColHeight += itemHeight;

                            // Store the hitbox width and height here. Final position will be updated in `draw`
                            hitboxes[i] = {
                                left: 0,
                                top: 0,
                                width: itemWidth,
                                height: fontSize
                            };
                        });

                        totalWidth += currentColWidth;
                        columnWidths.push(currentColWidth);
                        minSize.width += totalWidth;
                    }
                }

                me.width = minSize.width;
                me.height = minSize.height;
            },
            afterFit: noop,

            // Shared Methods
            isHorizontal: function() {
                return this.options.position === 'top' || this.options.position === 'bottom';
            },

            // Actualy draw the legend on the canvas
            draw: function() {
                var me = this;
                var opts = me.options;
                var labelOpts = opts.labels;
                var globalDefault = Chart.defaults.global,
                    lineDefault = globalDefault.elements.line,
                    legendWidth = me.width,
                    lineWidths = me.lineWidths;

                if (opts.display) {
                    var ctx = me.ctx,
                        cursor,
                        itemOrDefault = helpers.getValueOrDefault,
                        fontColor = itemOrDefault(labelOpts.fontColor, globalDefault.defaultFontColor),
                        fontSize = itemOrDefault(labelOpts.fontSize, globalDefault.defaultFontSize),
                        fontStyle = itemOrDefault(labelOpts.fontStyle, globalDefault.defaultFontStyle),
                        fontFamily = itemOrDefault(labelOpts.fontFamily, globalDefault.defaultFontFamily),
                        labelFont = helpers.fontString(fontSize, fontStyle, fontFamily);

                    // Canvas setup
                    ctx.textAlign = 'left';
                    ctx.textBaseline = 'top';
                    ctx.lineWidth = 0.5;
                    ctx.strokeStyle = fontColor; // for strikethrough effect
                    ctx.fillStyle = fontColor; // render in correct colour
                    ctx.font = labelFont;

                    var boxWidth = labelOpts.boxWidth,
                        hitboxes = me.legendHitBoxes;

                    // current position
                    var drawLegendBox = function(x, y, legendItem) {
                        if (isNaN(boxWidth) || boxWidth <= 0) {
                            return;
                        }

                        // Set the ctx for the box
                        ctx.save();

                        ctx.fillStyle = itemOrDefault(legendItem.fillStyle, globalDefault.defaultColor);
                        ctx.lineCap = itemOrDefault(legendItem.lineCap, lineDefault.borderCapStyle);
                        ctx.lineDashOffset = itemOrDefault(legendItem.lineDashOffset, lineDefault.borderDashOffset);
                        ctx.lineJoin = itemOrDefault(legendItem.lineJoin, lineDefault.borderJoinStyle);
                        ctx.lineWidth = itemOrDefault(legendItem.lineWidth, lineDefault.borderWidth);
                        ctx.strokeStyle = itemOrDefault(legendItem.strokeStyle, globalDefault.defaultColor);
                        var isLineWidthZero = (itemOrDefault(legendItem.lineWidth, lineDefault.borderWidth) === 0);

                        if (ctx.setLineDash) {
                            // IE 9 and 10 do not support line dash
                            ctx.setLineDash(itemOrDefault(legendItem.lineDash, lineDefault.borderDash));
                        }

                        if (opts.labels && opts.labels.usePointStyle) {
                            // Recalulate x and y for drawPoint() because its expecting
                            // x and y to be center of figure (instead of top left)
                            var radius = fontSize * Math.SQRT2 / 2;
                            var offSet = radius / Math.SQRT2;
                            var centerX = x + offSet;
                            var centerY = y + offSet;

                            // Draw pointStyle as legend symbol
                            Chart.canvasHelpers.drawPoint(ctx, legendItem.pointStyle, radius, centerX, centerY);
                        } else {
                            // Draw box as legend symbol
                            if (!isLineWidthZero) {
                                ctx.strokeRect(x, y, boxWidth, fontSize);
                            }
                            ctx.fillRect(x, y, boxWidth, fontSize);
                        }

                        ctx.restore();
                    };
                    var fillText = function(x, y, legendItem, textWidth) {
                        ctx.fillText(legendItem.text, boxWidth + (fontSize / 2) + x, y);

                        if (legendItem.hidden) {
                            // Strikethrough the text if hidden
                            ctx.beginPath();
                            ctx.lineWidth = 2;
                            ctx.moveTo(boxWidth + (fontSize / 2) + x, y + (fontSize / 2));
                            ctx.lineTo(boxWidth + (fontSize / 2) + x + textWidth, y + (fontSize / 2));
                            ctx.stroke();
                        }
                    };

                    // Horizontal
                    var isHorizontal = me.isHorizontal();
                    if (isHorizontal) {
                        cursor = {
                            x: me.left + ((legendWidth - lineWidths[0]) / 2),
                            y: me.top + labelOpts.padding,
                            line: 0
                        };
                    } else {
                        cursor = {
                            x: me.left + labelOpts.padding,
                            y: me.top + labelOpts.padding,
                            line: 0
                        };
                    }

                    var itemHeight = fontSize + labelOpts.padding;
                    helpers.each(me.legendItems, function(legendItem, i) {
                        var textWidth = ctx.measureText(legendItem.text).width,
                            width = labelOpts.usePointStyle ?
                            fontSize + (fontSize / 2) + textWidth :
                            boxWidth + (fontSize / 2) + textWidth,
                            x = cursor.x,
                            y = cursor.y;

                        if (isHorizontal) {
                            if (x + width >= legendWidth) {
                                y = cursor.y += itemHeight;
                                cursor.line++;
                                x = cursor.x = me.left + ((legendWidth - lineWidths[cursor.line]) / 2);
                            }
                        } else if (y + itemHeight > me.bottom) {
                            x = cursor.x = x + me.columnWidths[cursor.line] + labelOpts.padding;
                            y = cursor.y = me.top;
                            cursor.line++;
                        }

                        drawLegendBox(x, y, legendItem);

                        hitboxes[i].left = x;
                        hitboxes[i].top = y;

                        // Fill the actual label
                        fillText(x, y, legendItem, textWidth);

                        if (isHorizontal) {
                            cursor.x += width + (labelOpts.padding);
                        } else {
                            cursor.y += itemHeight;
                        }

                    });
                }
            },

            // Handle an event
            handleEvent: function(e) {
                var me = this;
                var opts = me.options;
                var type = e.type === 'mouseup' ? 'click' : e.type;

                if (type === 'mousemove') {
                    if (!opts.onHover) {
                        return;
                    }
                } else if (type === 'click') {
                    if (!opts.onClick) {
                        return;
                    }
                } else {
                    return;
                }

                var position = helpers.getRelativePosition(e, me.chart.chart),
                    x = position.x,
                    y = position.y;

                if (x >= me.left && x <= me.right && y >= me.top && y <= me.bottom) {
                    // See if we are touching one of the dataset boxes
                    var lh = me.legendHitBoxes;
                    for (var i = 0; i < lh.length; ++i) {
                        var hitBox = lh[i];

                        if (x >= hitBox.left && x <= hitBox.left + hitBox.width && y >= hitBox.top && y <= hitBox.top + hitBox.height) {
                            // Touching an element
                            if (type === 'click') {
                                opts.onClick.call(me, e, me.legendItems[i]);
                                break;
                            } else if (type === 'mousemove') {
                                opts.onHover.call(me, e, me.legendItems[i]);
                                break;
                            }
                        }
                    }
                }
            }
        });

        // Register the legend plugin
        Chart.plugins.register({
            beforeInit: function(chartInstance) {
                var opts = chartInstance.options;
                var legendOpts = opts.legend;

                if (legendOpts) {
                    chartInstance.legend = new Chart.Legend({
                        ctx: chartInstance.chart.ctx,
                        options: legendOpts,
                        chart: chartInstance
                    });

                    Chart.layoutService.addBox(chartInstance, chartInstance.legend);
                }
            }
        });
    };

},{}],30:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var noop = Chart.helpers.noop;

        /**
         * The plugin service singleton
         * @namespace Chart.plugins
         * @since 2.1.0
         */
        Chart.plugins = {
            _plugins: [],

            /**
             * Registers the given plugin(s) if not already registered.
             * @param {Array|Object} plugins plugin instance(s).
             */
            register: function(plugins) {
                var p = this._plugins;
                ([]).concat(plugins).forEach(function(plugin) {
                    if (p.indexOf(plugin) === -1) {
                        p.push(plugin);
                    }
                });
            },

            /**
             * Unregisters the given plugin(s) only if registered.
             * @param {Array|Object} plugins plugin instance(s).
             */
            unregister: function(plugins) {
                var p = this._plugins;
                ([]).concat(plugins).forEach(function(plugin) {
                    var idx = p.indexOf(plugin);
                    if (idx !== -1) {
                        p.splice(idx, 1);
                    }
                });
            },

            /**
             * Remove all registered p^lugins.
             * @since 2.1.5
             */
            clear: function() {
                this._plugins = [];
            },

            /**
             * Returns the number of registered plugins?
             * @returns {Number}
             * @since 2.1.5
             */
            count: function() {
                return this._plugins.length;
            },

            /**
             * Returns all registered plugin intances.
             * @returns {Array} array of plugin objects.
             * @since 2.1.5
             */
            getAll: function() {
                return this._plugins;
            },

            /**
             * Calls registered plugins on the specified extension, with the given args. This
             * method immediately returns as soon as a plugin explicitly returns false. The
             * returned value can be used, for instance, to interrupt the current action.
             * @param {String} extension the name of the plugin method to call (e.g. 'beforeUpdate').
             * @param {Array} [args] extra arguments to apply to the extension call.
             * @returns {Boolean} false if any of the plugins return false, else returns true.
             */
            notify: function(extension, args) {
                var plugins = this._plugins;
                var ilen = plugins.length;
                var i, plugin;

                for (i=0; i<ilen; ++i) {
                    plugin = plugins[i];
                    if (typeof plugin[extension] === 'function') {
                        if (plugin[extension].apply(plugin, args || []) === false) {
                            return false;
                        }
                    }
                }

                return true;
            }
        };

        /**
         * Plugin extension methods.
         * @interface Chart.PluginBase
         * @since 2.1.0
         */
        Chart.PluginBase = Chart.Element.extend({
            // Called at start of chart init
            beforeInit: noop,

            // Called at end of chart init
            afterInit: noop,

            // Called at start of update
            beforeUpdate: noop,

            // Called at end of update
            afterUpdate: noop,

            // Called at start of draw
            beforeDraw: noop,

            // Called at end of draw
            afterDraw: noop,

            // Called during destroy
            destroy: noop
        });

        /**
         * Provided for backward compatibility, use Chart.plugins instead
         * @namespace Chart.pluginService
         * @deprecated since version 2.1.5
         * @todo remove me at version 3
         */
        Chart.pluginService = Chart.plugins;
    };

},{}],31:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;

        Chart.defaults.scale = {
            display: true,
            position: 'left',

            // grid line settings
            gridLines: {
                display: true,
                color: 'rgba(0, 0, 0, 0.1)',
                lineWidth: 1,
                drawBorder: true,
                drawOnChartArea: true,
                drawTicks: true,
                tickMarkLength: 10,
                zeroLineWidth: 1,
                zeroLineColor: 'rgba(0,0,0,0.25)',
                offsetGridLines: false,
                borderDash: [],
                borderDashOffset: 0.0
            },

            // scale label
            scaleLabel: {
                // actual label
                labelString: '',

                // display property
                display: false
            },

            // label settings
            ticks: {
                beginAtZero: false,
                minRotation: 0,
                maxRotation: 50,
                mirror: false,
                padding: 10,
                reverse: false,
                display: true,
                autoSkip: true,
                autoSkipPadding: 0,
                labelOffset: 0,
                // We pass through arrays to be rendered as multiline labels, we convert Others to strings here.
                callback: function(value) {
                    return helpers.isArray(value) ? value : '' + value;
                }
            }
        };

        Chart.Scale = Chart.Element.extend({

            // These methods are ordered by lifecyle. Utilities then follow.
            // Any function defined here is inherited by all scale types.
            // Any function can be extended by the scale type

            beforeUpdate: function() {
                helpers.callCallback(this.options.beforeUpdate, [this]);
            },
            update: function(maxWidth, maxHeight, margins) {
                var me = this;

                // Update Lifecycle - Probably don't want to ever extend or overwrite this function ;)
                me.beforeUpdate();

                // Absorb the master measurements
                me.maxWidth = maxWidth;
                me.maxHeight = maxHeight;
                me.margins = helpers.extend({
                    left: 0,
                    right: 0,
                    top: 0,
                    bottom: 0
                }, margins);

                // Dimensions
                me.beforeSetDimensions();
                me.setDimensions();
                me.afterSetDimensions();

                // Data min/max
                me.beforeDataLimits();
                me.determineDataLimits();
                me.afterDataLimits();

                // Ticks
                me.beforeBuildTicks();
                me.buildTicks();
                me.afterBuildTicks();

                me.beforeTickToLabelConversion();
                me.convertTicksToLabels();
                me.afterTickToLabelConversion();

                // Tick Rotation
                me.beforeCalculateTickRotation();
                me.calculateTickRotation();
                me.afterCalculateTickRotation();
                // Fit
                me.beforeFit();
                me.fit();
                me.afterFit();
                //
                me.afterUpdate();

                return me.minSize;

            },
            afterUpdate: function() {
                helpers.callCallback(this.options.afterUpdate, [this]);
            },

            //

            beforeSetDimensions: function() {
                helpers.callCallback(this.options.beforeSetDimensions, [this]);
            },
            setDimensions: function() {
                var me = this;
                // Set the unconstrained dimension before label rotation
                if (me.isHorizontal()) {
                    // Reset position before calculating rotation
                    me.width = me.maxWidth;
                    me.left = 0;
                    me.right = me.width;
                } else {
                    me.height = me.maxHeight;

                    // Reset position before calculating rotation
                    me.top = 0;
                    me.bottom = me.height;
                }

                // Reset padding
                me.paddingLeft = 0;
                me.paddingTop = 0;
                me.paddingRight = 0;
                me.paddingBottom = 0;
            },
            afterSetDimensions: function() {
                helpers.callCallback(this.options.afterSetDimensions, [this]);
            },

            // Data limits
            beforeDataLimits: function() {
                helpers.callCallback(this.options.beforeDataLimits, [this]);
            },
            determineDataLimits: helpers.noop,
            afterDataLimits: function() {
                helpers.callCallback(this.options.afterDataLimits, [this]);
            },

            //
            beforeBuildTicks: function() {
                helpers.callCallback(this.options.beforeBuildTicks, [this]);
            },
            buildTicks: helpers.noop,
            afterBuildTicks: function() {
                helpers.callCallback(this.options.afterBuildTicks, [this]);
            },

            beforeTickToLabelConversion: function() {
                helpers.callCallback(this.options.beforeTickToLabelConversion, [this]);
            },
            convertTicksToLabels: function() {
                var me = this;
                // Convert ticks to strings
                me.ticks = me.ticks.map(function(numericalTick, index, ticks) {
                        if (me.options.ticks.userCallback) {
                            return me.options.ticks.userCallback(numericalTick, index, ticks);
                        }
                        return me.options.ticks.callback(numericalTick, index, ticks);
                    },
                    me);
            },
            afterTickToLabelConversion: function() {
                helpers.callCallback(this.options.afterTickToLabelConversion, [this]);
            },

            //

            beforeCalculateTickRotation: function() {
                helpers.callCallback(this.options.beforeCalculateTickRotation, [this]);
            },
            calculateTickRotation: function() {
                var me = this;
                var context = me.ctx;
                var globalDefaults = Chart.defaults.global;
                var optionTicks = me.options.ticks;

                // Get the width of each grid by calculating the difference
                // between x offsets between 0 and 1.
                var tickFontSize = helpers.getValueOrDefault(optionTicks.fontSize, globalDefaults.defaultFontSize);
                var tickFontStyle = helpers.getValueOrDefault(optionTicks.fontStyle, globalDefaults.defaultFontStyle);
                var tickFontFamily = helpers.getValueOrDefault(optionTicks.fontFamily, globalDefaults.defaultFontFamily);
                var tickLabelFont = helpers.fontString(tickFontSize, tickFontStyle, tickFontFamily);
                context.font = tickLabelFont;

                var firstWidth = context.measureText(me.ticks[0]).width;
                var lastWidth = context.measureText(me.ticks[me.ticks.length - 1]).width;
                var firstRotated;

                me.labelRotation = optionTicks.minRotation || 0;
                me.paddingRight = 0;
                me.paddingLeft = 0;

                if (me.options.display) {
                    if (me.isHorizontal()) {
                        me.paddingRight = lastWidth / 2 + 3;
                        me.paddingLeft = firstWidth / 2 + 3;

                        if (!me.longestTextCache) {
                            me.longestTextCache = {};
                        }
                        var originalLabelWidth = helpers.longestText(context, tickLabelFont, me.ticks, me.longestTextCache);
                        var labelWidth = originalLabelWidth;
                        var cosRotation;
                        var sinRotation;

                        // Allow 3 pixels x2 padding either side for label readability
                        // only the index matters for a dataset scale, but we want a consistent interface between scales
                        var tickWidth = me.getPixelForTick(1) - me.getPixelForTick(0) - 6;

                        // Max label rotation can be set or default to 90 - also act as a loop counter
                        while (labelWidth > tickWidth && me.labelRotation < optionTicks.maxRotation) {
                            cosRotation = Math.cos(helpers.toRadians(me.labelRotation));
                            sinRotation = Math.sin(helpers.toRadians(me.labelRotation));

                            firstRotated = cosRotation * firstWidth;

                            // We're right aligning the text now.
                            if (firstRotated + tickFontSize / 2 > me.yLabelWidth) {
                                me.paddingLeft = firstRotated + tickFontSize / 2;
                            }

                            me.paddingRight = tickFontSize / 2;

                            if (sinRotation * originalLabelWidth > me.maxHeight) {
                                // go back one step
                                me.labelRotation--;
                                break;
                            }

                            me.labelRotation++;
                            labelWidth = cosRotation * originalLabelWidth;
                        }
                    }
                }

                if (me.margins) {
                    me.paddingLeft = Math.max(me.paddingLeft - me.margins.left, 0);
                    me.paddingRight = Math.max(me.paddingRight - me.margins.right, 0);
                }
            },
            afterCalculateTickRotation: function() {
                helpers.callCallback(this.options.afterCalculateTickRotation, [this]);
            },

            //

            beforeFit: function() {
                helpers.callCallback(this.options.beforeFit, [this]);
            },
            fit: function() {
                var me = this;
                // Reset
                var minSize = me.minSize = {
                    width: 0,
                    height: 0
                };

                var opts = me.options;
                var globalDefaults = Chart.defaults.global;
                var tickOpts = opts.ticks;
                var scaleLabelOpts = opts.scaleLabel;
                var gridLineOpts = opts.gridLines;
                var display = opts.display;
                var isHorizontal = me.isHorizontal();

                var tickFontSize = helpers.getValueOrDefault(tickOpts.fontSize, globalDefaults.defaultFontSize);
                var tickFontStyle = helpers.getValueOrDefault(tickOpts.fontStyle, globalDefaults.defaultFontStyle);
                var tickFontFamily = helpers.getValueOrDefault(tickOpts.fontFamily, globalDefaults.defaultFontFamily);
                var tickLabelFont = helpers.fontString(tickFontSize, tickFontStyle, tickFontFamily);

                var scaleLabelFontSize = helpers.getValueOrDefault(scaleLabelOpts.fontSize, globalDefaults.defaultFontSize);

                var tickMarkLength = opts.gridLines.tickMarkLength;

                // Width
                if (isHorizontal) {
                    // subtract the margins to line up with the chartArea if we are a full width scale
                    minSize.width = me.isFullWidth() ? me.maxWidth - me.margins.left - me.margins.right : me.maxWidth;
                } else {
                    minSize.width = display && gridLineOpts.drawTicks ? tickMarkLength : 0;
                }

                // height
                if (isHorizontal) {
                    minSize.height = display && gridLineOpts.drawTicks ? tickMarkLength : 0;
                } else {
                    minSize.height = me.maxHeight; // fill all the height
                }

                // Are we showing a title for the scale?
                if (scaleLabelOpts.display && display) {
                    if (isHorizontal) {
                        minSize.height += (scaleLabelFontSize * 1.5);
                    } else {
                        minSize.width += (scaleLabelFontSize * 1.5);
                    }
                }

                if (tickOpts.display && display) {
                    // Don't bother fitting the ticks if we are not showing them
                    if (!me.longestTextCache) {
                        me.longestTextCache = {};
                    }

                    var largestTextWidth = helpers.longestText(me.ctx, tickLabelFont, me.ticks, me.longestTextCache);
                    var tallestLabelHeightInLines = helpers.numberOfLabelLines(me.ticks);
                    var lineSpace = tickFontSize * 0.5;

                    if (isHorizontal) {
                        // A horizontal axis is more constrained by the height.
                        me.longestLabelWidth = largestTextWidth;

                        // TODO - improve this calculation
                        var labelHeight = (Math.sin(helpers.toRadians(me.labelRotation)) * me.longestLabelWidth) + (tickFontSize * tallestLabelHeightInLines) + (lineSpace * tallestLabelHeightInLines);

                        minSize.height = Math.min(me.maxHeight, minSize.height + labelHeight);
                        me.ctx.font = tickLabelFont;

                        var firstLabelWidth = me.ctx.measureText(me.ticks[0]).width;
                        var lastLabelWidth = me.ctx.measureText(me.ticks[me.ticks.length - 1]).width;

                        // Ensure that our ticks are always inside the canvas. When rotated, ticks are right aligned which means that the right padding is dominated
                        // by the font height
                        var cosRotation = Math.cos(helpers.toRadians(me.labelRotation));
                        var sinRotation = Math.sin(helpers.toRadians(me.labelRotation));
                        me.paddingLeft = me.labelRotation !== 0 ? (cosRotation * firstLabelWidth) + 3 : firstLabelWidth / 2 + 3; // add 3 px to move away from canvas edges
                        me.paddingRight = me.labelRotation !== 0 ? (sinRotation * (tickFontSize / 2)) + 3 : lastLabelWidth / 2 + 3; // when rotated
                    } else {
                        // A vertical axis is more constrained by the width. Labels are the dominant factor here, so get that length first
                        var maxLabelWidth = me.maxWidth - minSize.width;

                        // Account for padding
                        var mirror = tickOpts.mirror;
                        if (!mirror) {
                            largestTextWidth += me.options.ticks.padding;
                        } else {
                            // If mirrored text is on the inside so don't expand
                            largestTextWidth = 0;
                        }

                        if (largestTextWidth < maxLabelWidth) {
                            // We don't need all the room
                            minSize.width += largestTextWidth;
                        } else {
                            // Expand to max size
                            minSize.width = me.maxWidth;
                        }

                        me.paddingTop = tickFontSize / 2;
                        me.paddingBottom = tickFontSize / 2;
                    }
                }

                if (me.margins) {
                    me.paddingLeft = Math.max(me.paddingLeft - me.margins.left, 0);
                    me.paddingTop = Math.max(me.paddingTop - me.margins.top, 0);
                    me.paddingRight = Math.max(me.paddingRight - me.margins.right, 0);
                    me.paddingBottom = Math.max(me.paddingBottom - me.margins.bottom, 0);
                }

                me.width = minSize.width;
                me.height = minSize.height;

            },
            afterFit: function() {
                helpers.callCallback(this.options.afterFit, [this]);
            },

            // Shared Methods
            isHorizontal: function() {
                return this.options.position === 'top' || this.options.position === 'bottom';
            },
            isFullWidth: function() {
                return (this.options.fullWidth);
            },

            // Get the correct value. NaN bad inputs, If the value type is object get the x or y based on whether we are horizontal or not
            getRightValue: function(rawValue) {
                // Null and undefined values first
                if (rawValue === null || typeof(rawValue) === 'undefined') {
                    return NaN;
                }
                // isNaN(object) returns true, so make sure NaN is checking for a number
                if (typeof(rawValue) === 'number' && isNaN(rawValue)) {
                    return NaN;
                }
                // If it is in fact an object, dive in one more level
                if (typeof(rawValue) === 'object') {
                    if ((rawValue instanceof Date) || (rawValue.isValid)) {
                        return rawValue;
                    }
                    return this.getRightValue(this.isHorizontal() ? rawValue.x : rawValue.y);
                }

                // Value is good, return it
                return rawValue;
            },

            // Used to get the value to display in the tooltip for the data at the given index
            // function getLabelForIndex(index, datasetIndex)
            getLabelForIndex: helpers.noop,

            // Used to get data value locations.  Value can either be an index or a numerical value
            getPixelForValue: helpers.noop,

            // Used to get the data value from a given pixel. This is the inverse of getPixelForValue
            getValueForPixel: helpers.noop,

            // Used for tick location, should
            getPixelForTick: function(index, includeOffset) {
                var me = this;
                if (me.isHorizontal()) {
                    var innerWidth = me.width - (me.paddingLeft + me.paddingRight);
                    var tickWidth = innerWidth / Math.max((me.ticks.length - ((me.options.gridLines.offsetGridLines) ? 0 : 1)), 1);
                    var pixel = (tickWidth * index) + me.paddingLeft;

                    if (includeOffset) {
                        pixel += tickWidth / 2;
                    }

                    var finalVal = me.left + Math.round(pixel);
                    finalVal += me.isFullWidth() ? me.margins.left : 0;
                    return finalVal;
                }
                var innerHeight = me.height - (me.paddingTop + me.paddingBottom);
                return me.top + (index * (innerHeight / (me.ticks.length - 1)));
            },

            // Utility for getting the pixel location of a percentage of scale
            getPixelForDecimal: function(decimal /* , includeOffset*/) {
                var me = this;
                if (me.isHorizontal()) {
                    var innerWidth = me.width - (me.paddingLeft + me.paddingRight);
                    var valueOffset = (innerWidth * decimal) + me.paddingLeft;

                    var finalVal = me.left + Math.round(valueOffset);
                    finalVal += me.isFullWidth() ? me.margins.left : 0;
                    return finalVal;
                }
                return me.top + (decimal * me.height);
            },

            getBasePixel: function() {
                var me = this;
                var min = me.min;
                var max = me.max;

                return me.getPixelForValue(
                    me.beginAtZero? 0:
                        min < 0 && max < 0? max :
                            min > 0 && max > 0? min :
                                0);
            },

            // Actualy draw the scale on the canvas
            // @param {rectangle} chartArea : the area of the chart to draw full grid lines on
            draw: function(chartArea) {
                var me = this;
                var options = me.options;
                if (!options.display) {
                    return;
                }

                var context = me.ctx;
                var globalDefaults = Chart.defaults.global;
                var optionTicks = options.ticks;
                var gridLines = options.gridLines;
                var scaleLabel = options.scaleLabel;

                var isRotated = me.labelRotation !== 0;
                var skipRatio;
                var useAutoskipper = optionTicks.autoSkip;
                var isHorizontal = me.isHorizontal();

                // figure out the maximum number of gridlines to show
                var maxTicks;
                if (optionTicks.maxTicksLimit) {
                    maxTicks = optionTicks.maxTicksLimit;
                }

                var tickFontColor = helpers.getValueOrDefault(optionTicks.fontColor, globalDefaults.defaultFontColor);
                var tickFontSize = helpers.getValueOrDefault(optionTicks.fontSize, globalDefaults.defaultFontSize);
                var tickFontStyle = helpers.getValueOrDefault(optionTicks.fontStyle, globalDefaults.defaultFontStyle);
                var tickFontFamily = helpers.getValueOrDefault(optionTicks.fontFamily, globalDefaults.defaultFontFamily);
                var tickLabelFont = helpers.fontString(tickFontSize, tickFontStyle, tickFontFamily);
                var tl = gridLines.tickMarkLength;
                var borderDash = helpers.getValueOrDefault(gridLines.borderDash, globalDefaults.borderDash);
                var borderDashOffset = helpers.getValueOrDefault(gridLines.borderDashOffset, globalDefaults.borderDashOffset);

                var scaleLabelFontColor = helpers.getValueOrDefault(scaleLabel.fontColor, globalDefaults.defaultFontColor);
                var scaleLabelFontSize = helpers.getValueOrDefault(scaleLabel.fontSize, globalDefaults.defaultFontSize);
                var scaleLabelFontStyle = helpers.getValueOrDefault(scaleLabel.fontStyle, globalDefaults.defaultFontStyle);
                var scaleLabelFontFamily = helpers.getValueOrDefault(scaleLabel.fontFamily, globalDefaults.defaultFontFamily);
                var scaleLabelFont = helpers.fontString(scaleLabelFontSize, scaleLabelFontStyle, scaleLabelFontFamily);

                var labelRotationRadians = helpers.toRadians(me.labelRotation);
                var cosRotation = Math.cos(labelRotationRadians);
                var longestRotatedLabel = me.longestLabelWidth * cosRotation;

                // Make sure we draw text in the correct color and font
                context.fillStyle = tickFontColor;

                var itemsToDraw = [];

                if (isHorizontal) {
                    skipRatio = false;

                    // Only calculate the skip ratio with the half width of longestRotateLabel if we got an actual rotation
                    // See #2584
                    if (isRotated) {
                        longestRotatedLabel /= 2;
                    }

                    if ((longestRotatedLabel + optionTicks.autoSkipPadding) * me.ticks.length > (me.width - (me.paddingLeft + me.paddingRight))) {
                        skipRatio = 1 + Math.floor(((longestRotatedLabel + optionTicks.autoSkipPadding) * me.ticks.length) / (me.width - (me.paddingLeft + me.paddingRight)));
                    }

                    // if they defined a max number of optionTicks,
                    // increase skipRatio until that number is met
                    if (maxTicks && me.ticks.length > maxTicks) {
                        while (!skipRatio || me.ticks.length / (skipRatio || 1) > maxTicks) {
                            if (!skipRatio) {
                                skipRatio = 1;
                            }
                            skipRatio += 1;
                        }
                    }

                    if (!useAutoskipper) {
                        skipRatio = false;
                    }
                }


                var xTickStart = options.position === 'right' ? me.left : me.right - tl;
                var xTickEnd = options.position === 'right' ? me.left + tl : me.right;
                var yTickStart = options.position === 'bottom' ? me.top : me.bottom - tl;
                var yTickEnd = options.position === 'bottom' ? me.top + tl : me.bottom;

                helpers.each(me.ticks, function(label, index) {
                    // If the callback returned a null or undefined value, do not draw this line
                    if (label === undefined || label === null) {
                        return;
                    }

                    var isLastTick = me.ticks.length === index + 1;

                    // Since we always show the last tick,we need may need to hide the last shown one before
                    var shouldSkip = (skipRatio > 1 && index % skipRatio > 0) || (index % skipRatio === 0 && index + skipRatio >= me.ticks.length);
                    if (shouldSkip && !isLastTick || (label === undefined || label === null)) {
                        return;
                    }

                    var lineWidth, lineColor;
                    if (index === (typeof me.zeroLineIndex !== 'undefined' ? me.zeroLineIndex : 0)) {
                        // Draw the first index specially
                        lineWidth = gridLines.zeroLineWidth;
                        lineColor = gridLines.zeroLineColor;
                    } else {
                        lineWidth = helpers.getValueAtIndexOrDefault(gridLines.lineWidth, index);
                        lineColor = helpers.getValueAtIndexOrDefault(gridLines.color, index);
                    }

                    // Common properties
                    var tx1, ty1, tx2, ty2, x1, y1, x2, y2, labelX, labelY;
                    var textAlign = 'middle';
                    var textBaseline = 'middle';

                    if (isHorizontal) {
                        if (!isRotated) {
                            textBaseline = options.position === 'top' ? 'bottom' : 'top';
                        }

                        textAlign = isRotated ? 'right' : 'center';

                        var xLineValue = me.getPixelForTick(index) + helpers.aliasPixel(lineWidth); // xvalues for grid lines
                        labelX = me.getPixelForTick(index, gridLines.offsetGridLines) + optionTicks.labelOffset; // x values for optionTicks (need to consider offsetLabel option)
                        labelY = (isRotated) ? me.top + 12 : options.position === 'top' ? me.bottom - tl : me.top + tl;

                        tx1 = tx2 = x1 = x2 = xLineValue;
                        ty1 = yTickStart;
                        ty2 = yTickEnd;
                        y1 = chartArea.top;
                        y2 = chartArea.bottom;
                    } else {
                        if (options.position === 'left') {
                            if (optionTicks.mirror) {
                                labelX = me.right + optionTicks.padding;
                                textAlign = 'left';
                            } else {
                                labelX = me.right - optionTicks.padding;
                                textAlign = 'right';
                            }
                            // right side
                        } else if (optionTicks.mirror) {
                            labelX = me.left - optionTicks.padding;
                            textAlign = 'right';
                        } else {
                            labelX = me.left + optionTicks.padding;
                            textAlign = 'left';
                        }

                        var yLineValue = me.getPixelForTick(index); // xvalues for grid lines
                        yLineValue += helpers.aliasPixel(lineWidth);
                        labelY = me.getPixelForTick(index, gridLines.offsetGridLines);

                        tx1 = xTickStart;
                        tx2 = xTickEnd;
                        x1 = chartArea.left;
                        x2 = chartArea.right;
                        ty1 = ty2 = y1 = y2 = yLineValue;
                    }

                    itemsToDraw.push({
                        tx1: tx1,
                        ty1: ty1,
                        tx2: tx2,
                        ty2: ty2,
                        x1: x1,
                        y1: y1,
                        x2: x2,
                        y2: y2,
                        labelX: labelX,
                        labelY: labelY,
                        glWidth: lineWidth,
                        glColor: lineColor,
                        glBorderDash: borderDash,
                        glBorderDashOffset: borderDashOffset,
                        rotation: -1 * labelRotationRadians,
                        label: label,
                        textBaseline: textBaseline,
                        textAlign: textAlign
                    });
                });

                // Draw all of the tick labels, tick marks, and grid lines at the correct places
                helpers.each(itemsToDraw, function(itemToDraw) {
                    if (gridLines.display) {
                        context.save();
                        context.lineWidth = itemToDraw.glWidth;
                        context.strokeStyle = itemToDraw.glColor;
                        if (context.setLineDash) {
                            context.setLineDash(itemToDraw.glBorderDash);
                            context.lineDashOffset = itemToDraw.glBorderDashOffset;
                        }

                        context.beginPath();

                        if (gridLines.drawTicks) {
                            context.moveTo(itemToDraw.tx1, itemToDraw.ty1);
                            context.lineTo(itemToDraw.tx2, itemToDraw.ty2);
                        }

                        if (gridLines.drawOnChartArea) {
                            context.moveTo(itemToDraw.x1, itemToDraw.y1);
                            context.lineTo(itemToDraw.x2, itemToDraw.y2);
                        }

                        context.stroke();
                        context.restore();
                    }

                    if (optionTicks.display) {
                        context.save();
                        context.translate(itemToDraw.labelX, itemToDraw.labelY);
                        context.rotate(itemToDraw.rotation);
                        context.font = tickLabelFont;
                        context.textBaseline = itemToDraw.textBaseline;
                        context.textAlign = itemToDraw.textAlign;

                        var label = itemToDraw.label;
                        if (helpers.isArray(label)) {
                            for (var i = 0, y = -(label.length - 1)*tickFontSize*0.75; i < label.length; ++i) {
                                // We just make sure the multiline element is a string here..
                                context.fillText('' + label[i], 0, y);
                                // apply same lineSpacing as calculated @ L#320
                                y += (tickFontSize * 1.5);
                            }
                        } else {
                            context.fillText(label, 0, 0);
                        }
                        context.restore();
                    }
                });

                if (scaleLabel.display) {
                    // Draw the scale label
                    var scaleLabelX;
                    var scaleLabelY;
                    var rotation = 0;

                    if (isHorizontal) {
                        scaleLabelX = me.left + ((me.right - me.left) / 2); // midpoint of the width
                        scaleLabelY = options.position === 'bottom' ? me.bottom - (scaleLabelFontSize / 2) : me.top + (scaleLabelFontSize / 2);
                    } else {
                        var isLeft = options.position === 'left';
                        scaleLabelX = isLeft ? me.left + (scaleLabelFontSize / 2) : me.right - (scaleLabelFontSize / 2);
                        scaleLabelY = me.top + ((me.bottom - me.top) / 2);
                        rotation = isLeft ? -0.5 * Math.PI : 0.5 * Math.PI;
                    }

                    context.save();
                    context.translate(scaleLabelX, scaleLabelY);
                    context.rotate(rotation);
                    context.textAlign = 'center';
                    context.textBaseline = 'middle';
                    context.fillStyle = scaleLabelFontColor; // render in correct colour
                    context.font = scaleLabelFont;
                    context.fillText(scaleLabel.labelString, 0, 0);
                    context.restore();
                }

                if (gridLines.drawBorder) {
                    // Draw the line at the edge of the axis
                    context.lineWidth = helpers.getValueAtIndexOrDefault(gridLines.lineWidth, 0);
                    context.strokeStyle = helpers.getValueAtIndexOrDefault(gridLines.color, 0);
                    var x1 = me.left,
                        x2 = me.right,
                        y1 = me.top,
                        y2 = me.bottom;

                    var aliasPixel = helpers.aliasPixel(context.lineWidth);
                    if (isHorizontal) {
                        y1 = y2 = options.position === 'top' ? me.bottom : me.top;
                        y1 += aliasPixel;
                        y2 += aliasPixel;
                    } else {
                        x1 = x2 = options.position === 'left' ? me.right : me.left;
                        x1 += aliasPixel;
                        x2 += aliasPixel;
                    }

                    context.beginPath();
                    context.moveTo(x1, y1);
                    context.lineTo(x2, y2);
                    context.stroke();
                }
            }
        });
    };

},{}],32:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;

        Chart.scaleService = {
            // Scale registration object. Extensions can register new scale types (such as log or DB scales) and then
            // use the new chart options to grab the correct scale
            constructors: {},
            // Use a registration function so that we can move to an ES6 map when we no longer need to support
            // old browsers

            // Scale config defaults
            defaults: {},
            registerScaleType: function(type, scaleConstructor, defaults) {
                this.constructors[type] = scaleConstructor;
                this.defaults[type] = helpers.clone(defaults);
            },
            getScaleConstructor: function(type) {
                return this.constructors.hasOwnProperty(type) ? this.constructors[type] : undefined;
            },
            getScaleDefaults: function(type) {
                // Return the scale defaults merged with the global settings so that we always use the latest ones
                return this.defaults.hasOwnProperty(type) ? helpers.scaleMerge(Chart.defaults.scale, this.defaults[type]) : {};
            },
            updateScaleDefaults: function(type, additions) {
                var defaults = this.defaults;
                if (defaults.hasOwnProperty(type)) {
                    defaults[type] = helpers.extend(defaults[type], additions);
                }
            },
            addScalesToLayout: function(chartInstance) {
                // Adds each scale to the chart.boxes array to be sized accordingly
                helpers.each(chartInstance.scales, function(scale) {
                    Chart.layoutService.addBox(chartInstance, scale);
                });
            }
        };
    };

},{}],33:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;

        Chart.defaults.global.title = {
            display: false,
            position: 'top',
            fullWidth: true, // marks that this box should take the full width of the canvas (pushing down other boxes)

            fontStyle: 'bold',
            padding: 10,

            // actual title
            text: ''
        };

        var noop = helpers.noop;
        Chart.Title = Chart.Element.extend({

            initialize: function(config) {
                var me = this;
                helpers.extend(me, config);
                me.options = helpers.configMerge(Chart.defaults.global.title, config.options);

                // Contains hit boxes for each dataset (in dataset order)
                me.legendHitBoxes = [];
            },

            // These methods are ordered by lifecyle. Utilities then follow.

            beforeUpdate: function() {
                var chartOpts = this.chart.options;
                if (chartOpts && chartOpts.title) {
                    this.options = helpers.configMerge(Chart.defaults.global.title, chartOpts.title);
                }
            },
            update: function(maxWidth, maxHeight, margins) {
                var me = this;

                // Update Lifecycle - Probably don't want to ever extend or overwrite this function ;)
                me.beforeUpdate();

                // Absorb the master measurements
                me.maxWidth = maxWidth;
                me.maxHeight = maxHeight;
                me.margins = margins;

                // Dimensions
                me.beforeSetDimensions();
                me.setDimensions();
                me.afterSetDimensions();
                // Labels
                me.beforeBuildLabels();
                me.buildLabels();
                me.afterBuildLabels();

                // Fit
                me.beforeFit();
                me.fit();
                me.afterFit();
                //
                me.afterUpdate();

                return me.minSize;

            },
            afterUpdate: noop,

            //

            beforeSetDimensions: noop,
            setDimensions: function() {
                var me = this;
                // Set the unconstrained dimension before label rotation
                if (me.isHorizontal()) {
                    // Reset position before calculating rotation
                    me.width = me.maxWidth;
                    me.left = 0;
                    me.right = me.width;
                } else {
                    me.height = me.maxHeight;

                    // Reset position before calculating rotation
                    me.top = 0;
                    me.bottom = me.height;
                }

                // Reset padding
                me.paddingLeft = 0;
                me.paddingTop = 0;
                me.paddingRight = 0;
                me.paddingBottom = 0;

                // Reset minSize
                me.minSize = {
                    width: 0,
                    height: 0
                };
            },
            afterSetDimensions: noop,

            //

            beforeBuildLabels: noop,
            buildLabels: noop,
            afterBuildLabels: noop,

            //

            beforeFit: noop,
            fit: function() {
                var me = this,
                    valueOrDefault = helpers.getValueOrDefault,
                    opts = me.options,
                    globalDefaults = Chart.defaults.global,
                    display = opts.display,
                    fontSize = valueOrDefault(opts.fontSize, globalDefaults.defaultFontSize),
                    minSize = me.minSize;

                if (me.isHorizontal()) {
                    minSize.width = me.maxWidth; // fill all the width
                    minSize.height = display ? fontSize + (opts.padding * 2) : 0;
                } else {
                    minSize.width = display ? fontSize + (opts.padding * 2) : 0;
                    minSize.height = me.maxHeight; // fill all the height
                }

                me.width = minSize.width;
                me.height = minSize.height;

            },
            afterFit: noop,

            // Shared Methods
            isHorizontal: function() {
                var pos = this.options.position;
                return pos === 'top' || pos === 'bottom';
            },

            // Actualy draw the title block on the canvas
            draw: function() {
                var me = this,
                    ctx = me.ctx,
                    valueOrDefault = helpers.getValueOrDefault,
                    opts = me.options,
                    globalDefaults = Chart.defaults.global;

                if (opts.display) {
                    var fontSize = valueOrDefault(opts.fontSize, globalDefaults.defaultFontSize),
                        fontStyle = valueOrDefault(opts.fontStyle, globalDefaults.defaultFontStyle),
                        fontFamily = valueOrDefault(opts.fontFamily, globalDefaults.defaultFontFamily),
                        titleFont = helpers.fontString(fontSize, fontStyle, fontFamily),
                        rotation = 0,
                        titleX,
                        titleY,
                        top = me.top,
                        left = me.left,
                        bottom = me.bottom,
                        right = me.right;

                    ctx.fillStyle = valueOrDefault(opts.fontColor, globalDefaults.defaultFontColor); // render in correct colour
                    ctx.font = titleFont;

                    // Horizontal
                    if (me.isHorizontal()) {
                        titleX = left + ((right - left) / 2); // midpoint of the width
                        titleY = top + ((bottom - top) / 2); // midpoint of the height
                    } else {
                        titleX = opts.position === 'left' ? left + (fontSize / 2) : right - (fontSize / 2);
                        titleY = top + ((bottom - top) / 2);
                        rotation = Math.PI * (opts.position === 'left' ? -0.5 : 0.5);
                    }

                    ctx.save();
                    ctx.translate(titleX, titleY);
                    ctx.rotate(rotation);
                    ctx.textAlign = 'center';
                    ctx.textBaseline = 'middle';
                    ctx.fillText(opts.text, 0, 0);
                    ctx.restore();
                }
            }
        });

        // Register the title plugin
        Chart.plugins.register({
            beforeInit: function(chartInstance) {
                var opts = chartInstance.options;
                var titleOpts = opts.title;

                if (titleOpts) {
                    chartInstance.titleBlock = new Chart.Title({
                        ctx: chartInstance.chart.ctx,
                        options: titleOpts,
                        chart: chartInstance
                    });

                    Chart.layoutService.addBox(chartInstance, chartInstance.titleBlock);
                }
            }
        });
    };

},{}],34:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;

        Chart.defaults.global.tooltips = {
            enabled: true,
            custom: null,
            mode: 'single',
            backgroundColor: 'rgba(0,0,0,0.8)',
            titleFontStyle: 'bold',
            titleSpacing: 2,
            titleMarginBottom: 6,
            titleFontColor: '#fff',
            titleAlign: 'left',
            bodySpacing: 2,
            bodyFontColor: '#fff',
            bodyAlign: 'left',
            footerFontStyle: 'bold',
            footerSpacing: 2,
            footerMarginTop: 6,
            footerFontColor: '#fff',
            footerAlign: 'left',
            yPadding: 6,
            xPadding: 6,
            yAlign: 'center',
            xAlign: 'center',
            caretSize: 5,
            cornerRadius: 6,
            multiKeyBackground: '#fff',
            callbacks: {
                // Args are: (tooltipItems, data)
                beforeTitle: helpers.noop,
                title: function(tooltipItems, data) {
                    // Pick first xLabel for now
                    var title = '';
                    var labels = data.labels;
                    var labelCount = labels ? labels.length : 0;

                    if (tooltipItems.length > 0) {
                        var item = tooltipItems[0];

                        if (item.xLabel) {
                            title = item.xLabel;
                        } else if (labelCount > 0 && item.index < labelCount) {
                            title = labels[item.index];
                        }
                    }

                    return title;
                },
                afterTitle: helpers.noop,

                // Args are: (tooltipItems, data)
                beforeBody: helpers.noop,

                // Args are: (tooltipItem, data)
                beforeLabel: helpers.noop,
                label: function(tooltipItem, data) {
                    var datasetLabel = data.datasets[tooltipItem.datasetIndex].label || '';
                    return datasetLabel + ': ' + tooltipItem.yLabel;
                },
                labelColor: function(tooltipItem, chartInstance) {
                    var meta = chartInstance.getDatasetMeta(tooltipItem.datasetIndex);
                    var activeElement = meta.data[tooltipItem.index];
                    var view = activeElement._view;
                    return {
                        borderColor: view.borderColor,
                        backgroundColor: view.backgroundColor
                    };
                },
                afterLabel: helpers.noop,

                // Args are: (tooltipItems, data)
                afterBody: helpers.noop,

                // Args are: (tooltipItems, data)
                beforeFooter: helpers.noop,
                footer: helpers.noop,
                afterFooter: helpers.noop
            }
        };

        // Helper to push or concat based on if the 2nd parameter is an array or not
        function pushOrConcat(base, toPush) {
            if (toPush) {
                if (helpers.isArray(toPush)) {
                    // base = base.concat(toPush);
                    Array.prototype.push.apply(base, toPush);
                } else {
                    base.push(toPush);
                }
            }

            return base;
        }

        function getAveragePosition(elements) {
            if (!elements.length) {
                return false;
            }

            var i, len;
            var xPositions = [];
            var yPositions = [];

            for (i = 0, len = elements.length; i < len; ++i) {
                var el = elements[i];
                if (el && el.hasValue()) {
                    var pos = el.tooltipPosition();
                    xPositions.push(pos.x);
                    yPositions.push(pos.y);
                }
            }

            var x = 0,
                y = 0;
            for (i = 0; i < xPositions.length; ++i) {
                if (xPositions[i]) {
                    x += xPositions[i];
                    y += yPositions[i];
                }
            }

            return {
                x: Math.round(x / xPositions.length),
                y: Math.round(y / xPositions.length)
            };
        }

        // Private helper to create a tooltip iteam model
        // @param element : the chart element (point, arc, bar) to create the tooltip item for
        // @return : new tooltip item
        function createTooltipItem(element) {
            var xScale = element._xScale;
            var yScale = element._yScale || element._scale; // handle radar || polarArea charts
            var index = element._index,
                datasetIndex = element._datasetIndex;

            return {
                xLabel: xScale ? xScale.getLabelForIndex(index, datasetIndex) : '',
                yLabel: yScale ? yScale.getLabelForIndex(index, datasetIndex) : '',
                index: index,
                datasetIndex: datasetIndex
            };
        }

        Chart.Tooltip = Chart.Element.extend({
            initialize: function() {
                var me = this;
                var globalDefaults = Chart.defaults.global;
                var tooltipOpts = me._options;
                var getValueOrDefault = helpers.getValueOrDefault;

                helpers.extend(me, {
                    _model: {
                        // Positioning
                        xPadding: tooltipOpts.xPadding,
                        yPadding: tooltipOpts.yPadding,
                        xAlign: tooltipOpts.xAlign,
                        yAlign: tooltipOpts.yAlign,

                        // Body
                        bodyFontColor: tooltipOpts.bodyFontColor,
                        _bodyFontFamily: getValueOrDefault(tooltipOpts.bodyFontFamily, globalDefaults.defaultFontFamily),
                        _bodyFontStyle: getValueOrDefault(tooltipOpts.bodyFontStyle, globalDefaults.defaultFontStyle),
                        _bodyAlign: tooltipOpts.bodyAlign,
                        bodyFontSize: getValueOrDefault(tooltipOpts.bodyFontSize, globalDefaults.defaultFontSize),
                        bodySpacing: tooltipOpts.bodySpacing,

                        // Title
                        titleFontColor: tooltipOpts.titleFontColor,
                        _titleFontFamily: getValueOrDefault(tooltipOpts.titleFontFamily, globalDefaults.defaultFontFamily),
                        _titleFontStyle: getValueOrDefault(tooltipOpts.titleFontStyle, globalDefaults.defaultFontStyle),
                        titleFontSize: getValueOrDefault(tooltipOpts.titleFontSize, globalDefaults.defaultFontSize),
                        _titleAlign: tooltipOpts.titleAlign,
                        titleSpacing: tooltipOpts.titleSpacing,
                        titleMarginBottom: tooltipOpts.titleMarginBottom,

                        // Footer
                        footerFontColor: tooltipOpts.footerFontColor,
                        _footerFontFamily: getValueOrDefault(tooltipOpts.footerFontFamily, globalDefaults.defaultFontFamily),
                        _footerFontStyle: getValueOrDefault(tooltipOpts.footerFontStyle, globalDefaults.defaultFontStyle),
                        footerFontSize: getValueOrDefault(tooltipOpts.footerFontSize, globalDefaults.defaultFontSize),
                        _footerAlign: tooltipOpts.footerAlign,
                        footerSpacing: tooltipOpts.footerSpacing,
                        footerMarginTop: tooltipOpts.footerMarginTop,

                        // Appearance
                        caretSize: tooltipOpts.caretSize,
                        cornerRadius: tooltipOpts.cornerRadius,
                        backgroundColor: tooltipOpts.backgroundColor,
                        opacity: 0,
                        legendColorBackground: tooltipOpts.multiKeyBackground
                    }
                });
            },

            // Get the title
            // Args are: (tooltipItem, data)
            getTitle: function() {
                var me = this;
                var opts = me._options;
                var callbacks = opts.callbacks;

                var beforeTitle = callbacks.beforeTitle.apply(me, arguments),
                    title = callbacks.title.apply(me, arguments),
                    afterTitle = callbacks.afterTitle.apply(me, arguments);

                var lines = [];
                lines = pushOrConcat(lines, beforeTitle);
                lines = pushOrConcat(lines, title);
                lines = pushOrConcat(lines, afterTitle);

                return lines;
            },

            // Args are: (tooltipItem, data)
            getBeforeBody: function() {
                var lines = this._options.callbacks.beforeBody.apply(this, arguments);
                return helpers.isArray(lines) ? lines : lines !== undefined ? [lines] : [];
            },

            // Args are: (tooltipItem, data)
            getBody: function(tooltipItems, data) {
                var me = this;
                var callbacks = me._options.callbacks;
                var bodyItems = [];

                helpers.each(tooltipItems, function(tooltipItem) {
                    var bodyItem = {
                        before: [],
                        lines: [],
                        after: []
                    };
                    pushOrConcat(bodyItem.before, callbacks.beforeLabel.call(me, tooltipItem, data));
                    pushOrConcat(bodyItem.lines, callbacks.label.call(me, tooltipItem, data));
                    pushOrConcat(bodyItem.after, callbacks.afterLabel.call(me, tooltipItem, data));

                    bodyItems.push(bodyItem);
                });

                return bodyItems;
            },

            // Args are: (tooltipItem, data)
            getAfterBody: function() {
                var lines = this._options.callbacks.afterBody.apply(this, arguments);
                return helpers.isArray(lines) ? lines : lines !== undefined ? [lines] : [];
            },

            // Get the footer and beforeFooter and afterFooter lines
            // Args are: (tooltipItem, data)
            getFooter: function() {
                var me = this;
                var callbacks = me._options.callbacks;

                var beforeFooter = callbacks.beforeFooter.apply(me, arguments);
                var footer = callbacks.footer.apply(me, arguments);
                var afterFooter = callbacks.afterFooter.apply(me, arguments);

                var lines = [];
                lines = pushOrConcat(lines, beforeFooter);
                lines = pushOrConcat(lines, footer);
                lines = pushOrConcat(lines, afterFooter);

                return lines;
            },

            update: function(changed) {
                var me = this;
                var opts = me._options;
                var model = me._model;
                var active = me._active;

                var data = me._data;
                var chartInstance = me._chartInstance;

                var i, len;

                if (active.length) {
                    model.opacity = 1;

                    var labelColors = [],
                        tooltipPosition = getAveragePosition(active);

                    var tooltipItems = [];
                    for (i = 0, len = active.length; i < len; ++i) {
                        tooltipItems.push(createTooltipItem(active[i]));
                    }

                    // If the user provided a sorting function, use it to modify the tooltip items
                    if (opts.itemSort) {
                        tooltipItems = tooltipItems.sort(function(a, b) {
                            return opts.itemSort(a, b, data);
                        });
                    }

                    // If there is more than one item, show color items
                    if (active.length > 1) {
                        helpers.each(tooltipItems, function(tooltipItem) {
                            labelColors.push(opts.callbacks.labelColor.call(me, tooltipItem, chartInstance));
                        });
                    }

                    // Build the Text Lines
                    helpers.extend(model, {
                        title: me.getTitle(tooltipItems, data),
                        beforeBody: me.getBeforeBody(tooltipItems, data),
                        body: me.getBody(tooltipItems, data),
                        afterBody: me.getAfterBody(tooltipItems, data),
                        footer: me.getFooter(tooltipItems, data),
                        x: Math.round(tooltipPosition.x),
                        y: Math.round(tooltipPosition.y),
                        caretPadding: helpers.getValueOrDefault(tooltipPosition.padding, 2),
                        labelColors: labelColors
                    });

                    // We need to determine alignment of
                    var tooltipSize = me.getTooltipSize(model);
                    me.determineAlignment(tooltipSize); // Smart Tooltip placement to stay on the canvas

                    helpers.extend(model, me.getBackgroundPoint(model, tooltipSize));
                } else {
                    me._model.opacity = 0;
                }

                if (changed && opts.custom) {
                    opts.custom.call(me, model);
                }

                return me;
            },
            getTooltipSize: function(vm) {
                var ctx = this._chart.ctx;

                var size = {
                    height: vm.yPadding * 2, // Tooltip Padding
                    width: 0
                };

                // Count of all lines in the body
                var body = vm.body;
                var combinedBodyLength = body.reduce(function(count, bodyItem) {
                    return count + bodyItem.before.length + bodyItem.lines.length + bodyItem.after.length;
                }, 0);
                combinedBodyLength += vm.beforeBody.length + vm.afterBody.length;

                var titleLineCount = vm.title.length;
                var footerLineCount = vm.footer.length;
                var titleFontSize = vm.titleFontSize,
                    bodyFontSize = vm.bodyFontSize,
                    footerFontSize = vm.footerFontSize;

                size.height += titleLineCount * titleFontSize; // Title Lines
                size.height += (titleLineCount - 1) * vm.titleSpacing; // Title Line Spacing
                size.height += titleLineCount ? vm.titleMarginBottom : 0; // Title's bottom Margin
                size.height += combinedBodyLength * bodyFontSize; // Body Lines
                size.height += combinedBodyLength ? (combinedBodyLength - 1) * vm.bodySpacing : 0; // Body Line Spacing
                size.height += footerLineCount ? vm.footerMarginTop : 0; // Footer Margin
                size.height += footerLineCount * (footerFontSize); // Footer Lines
                size.height += footerLineCount ? (footerLineCount - 1) * vm.footerSpacing : 0; // Footer Line Spacing

                // Title width
                var widthPadding = 0;
                var maxLineWidth = function(line) {
                    size.width = Math.max(size.width, ctx.measureText(line).width + widthPadding);
                };

                ctx.font = helpers.fontString(titleFontSize, vm._titleFontStyle, vm._titleFontFamily);
                helpers.each(vm.title, maxLineWidth);

                // Body width
                ctx.font = helpers.fontString(bodyFontSize, vm._bodyFontStyle, vm._bodyFontFamily);
                helpers.each(vm.beforeBody.concat(vm.afterBody), maxLineWidth);

                // Body lines may include some extra width due to the color box
                widthPadding = body.length > 1 ? (bodyFontSize + 2) : 0;
                helpers.each(body, function(bodyItem) {
                    helpers.each(bodyItem.before, maxLineWidth);
                    helpers.each(bodyItem.lines, maxLineWidth);
                    helpers.each(bodyItem.after, maxLineWidth);
                });

                // Reset back to 0
                widthPadding = 0;

                // Footer width
                ctx.font = helpers.fontString(footerFontSize, vm._footerFontStyle, vm._footerFontFamily);
                helpers.each(vm.footer, maxLineWidth);

                // Add padding
                size.width += 2 * vm.xPadding;

                return size;
            },
            determineAlignment: function(size) {
                var me = this;
                var model = me._model;
                var chart = me._chart;
                var chartArea = me._chartInstance.chartArea;

                if (model.y < size.height) {
                    model.yAlign = 'top';
                } else if (model.y > (chart.height - size.height)) {
                    model.yAlign = 'bottom';
                }

                var lf, rf; // functions to determine left, right alignment
                var olf, orf; // functions to determine if left/right alignment causes tooltip to go outside chart
                var yf; // function to get the y alignment if the tooltip goes outside of the left or right edges
                var midX = (chartArea.left + chartArea.right) / 2;
                var midY = (chartArea.top + chartArea.bottom) / 2;

                if (model.yAlign === 'center') {
                    lf = function(x) {
                        return x <= midX;
                    };
                    rf = function(x) {
                        return x > midX;
                    };
                } else {
                    lf = function(x) {
                        return x <= (size.width / 2);
                    };
                    rf = function(x) {
                        return x >= (chart.width - (size.width / 2));
                    };
                }

                olf = function(x) {
                    return x + size.width > chart.width;
                };
                orf = function(x) {
                    return x - size.width < 0;
                };
                yf = function(y) {
                    return y <= midY ? 'top' : 'bottom';
                };

                if (lf(model.x)) {
                    model.xAlign = 'left';

                    // Is tooltip too wide and goes over the right side of the chart.?
                    if (olf(model.x)) {
                        model.xAlign = 'center';
                        model.yAlign = yf(model.y);
                    }
                } else if (rf(model.x)) {
                    model.xAlign = 'right';

                    // Is tooltip too wide and goes outside left edge of canvas?
                    if (orf(model.x)) {
                        model.xAlign = 'center';
                        model.yAlign = yf(model.y);
                    }
                }
            },
            getBackgroundPoint: function(vm, size) {
                // Background Position
                var pt = {
                    x: vm.x,
                    y: vm.y
                };

                var caretSize = vm.caretSize,
                    caretPadding = vm.caretPadding,
                    cornerRadius = vm.cornerRadius,
                    xAlign = vm.xAlign,
                    yAlign = vm.yAlign,
                    paddingAndSize = caretSize + caretPadding,
                    radiusAndPadding = cornerRadius + caretPadding;

                if (xAlign === 'right') {
                    pt.x -= size.width;
                } else if (xAlign === 'center') {
                    pt.x -= (size.width / 2);
                }

                if (yAlign === 'top') {
                    pt.y += paddingAndSize;
                } else if (yAlign === 'bottom') {
                    pt.y -= size.height + paddingAndSize;
                } else {
                    pt.y -= (size.height / 2);
                }

                if (yAlign === 'center') {
                    if (xAlign === 'left') {
                        pt.x += paddingAndSize;
                    } else if (xAlign === 'right') {
                        pt.x -= paddingAndSize;
                    }
                } else if (xAlign === 'left') {
                    pt.x -= radiusAndPadding;
                } else if (xAlign === 'right') {
                    pt.x += radiusAndPadding;
                }

                return pt;
            },
            drawCaret: function(tooltipPoint, size, opacity) {
                var vm = this._view;
                var ctx = this._chart.ctx;
                var x1, x2, x3;
                var y1, y2, y3;
                var caretSize = vm.caretSize;
                var cornerRadius = vm.cornerRadius;
                var xAlign = vm.xAlign,
                    yAlign = vm.yAlign;
                var ptX = tooltipPoint.x,
                    ptY = tooltipPoint.y;
                var width = size.width,
                    height = size.height;

                if (yAlign === 'center') {
                    // Left or right side
                    if (xAlign === 'left') {
                        x1 = ptX;
                        x2 = x1 - caretSize;
                        x3 = x1;
                    } else {
                        x1 = ptX + width;
                        x2 = x1 + caretSize;
                        x3 = x1;
                    }

                    y2 = ptY + (height / 2);
                    y1 = y2 - caretSize;
                    y3 = y2 + caretSize;
                } else {
                    if (xAlign === 'left') {
                        x1 = ptX + cornerRadius;
                        x2 = x1 + caretSize;
                        x3 = x2 + caretSize;
                    } else if (xAlign === 'right') {
                        x1 = ptX + width - cornerRadius;
                        x2 = x1 - caretSize;
                        x3 = x2 - caretSize;
                    } else {
                        x2 = ptX + (width / 2);
                        x1 = x2 - caretSize;
                        x3 = x2 + caretSize;
                    }

                    if (yAlign === 'top') {
                        y1 = ptY;
                        y2 = y1 - caretSize;
                        y3 = y1;
                    } else {
                        y1 = ptY + height;
                        y2 = y1 + caretSize;
                        y3 = y1;
                    }
                }

                var bgColor = helpers.color(vm.backgroundColor);
                ctx.fillStyle = bgColor.alpha(opacity * bgColor.alpha()).rgbString();
                ctx.beginPath();
                ctx.moveTo(x1, y1);
                ctx.lineTo(x2, y2);
                ctx.lineTo(x3, y3);
                ctx.closePath();
                ctx.fill();
            },
            drawTitle: function(pt, vm, ctx, opacity) {
                var title = vm.title;

                if (title.length) {
                    ctx.textAlign = vm._titleAlign;
                    ctx.textBaseline = 'top';

                    var titleFontSize = vm.titleFontSize,
                        titleSpacing = vm.titleSpacing;

                    var titleFontColor = helpers.color(vm.titleFontColor);
                    ctx.fillStyle = titleFontColor.alpha(opacity * titleFontColor.alpha()).rgbString();
                    ctx.font = helpers.fontString(titleFontSize, vm._titleFontStyle, vm._titleFontFamily);

                    var i, len;
                    for (i = 0, len = title.length; i < len; ++i) {
                        ctx.fillText(title[i], pt.x, pt.y);
                        pt.y += titleFontSize + titleSpacing; // Line Height and spacing

                        if (i + 1 === title.length) {
                            pt.y += vm.titleMarginBottom - titleSpacing; // If Last, add margin, remove spacing
                        }
                    }
                }
            },
            drawBody: function(pt, vm, ctx, opacity) {
                var bodyFontSize = vm.bodyFontSize;
                var bodySpacing = vm.bodySpacing;
                var body = vm.body;

                ctx.textAlign = vm._bodyAlign;
                ctx.textBaseline = 'top';

                var bodyFontColor = helpers.color(vm.bodyFontColor);
                var textColor = bodyFontColor.alpha(opacity * bodyFontColor.alpha()).rgbString();
                ctx.fillStyle = textColor;
                ctx.font = helpers.fontString(bodyFontSize, vm._bodyFontStyle, vm._bodyFontFamily);

                // Before Body
                var xLinePadding = 0;
                var fillLineOfText = function(line) {
                    ctx.fillText(line, pt.x + xLinePadding, pt.y);
                    pt.y += bodyFontSize + bodySpacing;
                };

                // Before body lines
                helpers.each(vm.beforeBody, fillLineOfText);

                var drawColorBoxes = body.length > 1;
                xLinePadding = drawColorBoxes ? (bodyFontSize + 2) : 0;

                // Draw body lines now
                helpers.each(body, function(bodyItem, i) {
                    helpers.each(bodyItem.before, fillLineOfText);

                    helpers.each(bodyItem.lines, function(line) {
                        // Draw Legend-like boxes if needed
                        if (drawColorBoxes) {
                            // Fill a white rect so that colours merge nicely if the opacity is < 1
                            ctx.fillStyle = helpers.color(vm.legendColorBackground).alpha(opacity).rgbaString();
                            ctx.fillRect(pt.x, pt.y, bodyFontSize, bodyFontSize);

                            // Border
                            ctx.strokeStyle = helpers.color(vm.labelColors[i].borderColor).alpha(opacity).rgbaString();
                            ctx.strokeRect(pt.x, pt.y, bodyFontSize, bodyFontSize);

                            // Inner square
                            ctx.fillStyle = helpers.color(vm.labelColors[i].backgroundColor).alpha(opacity).rgbaString();
                            ctx.fillRect(pt.x + 1, pt.y + 1, bodyFontSize - 2, bodyFontSize - 2);

                            ctx.fillStyle = textColor;
                        }

                        fillLineOfText(line);
                    });

                    helpers.each(bodyItem.after, fillLineOfText);
                });

                // Reset back to 0 for after body
                xLinePadding = 0;

                // After body lines
                helpers.each(vm.afterBody, fillLineOfText);
                pt.y -= bodySpacing; // Remove last body spacing
            },
            drawFooter: function(pt, vm, ctx, opacity) {
                var footer = vm.footer;

                if (footer.length) {
                    pt.y += vm.footerMarginTop;

                    ctx.textAlign = vm._footerAlign;
                    ctx.textBaseline = 'top';

                    var footerFontColor = helpers.color(vm.footerFontColor);
                    ctx.fillStyle = footerFontColor.alpha(opacity * footerFontColor.alpha()).rgbString();
                    ctx.font = helpers.fontString(vm.footerFontSize, vm._footerFontStyle, vm._footerFontFamily);

                    helpers.each(footer, function(line) {
                        ctx.fillText(line, pt.x, pt.y);
                        pt.y += vm.footerFontSize + vm.footerSpacing;
                    });
                }
            },
            draw: function() {
                var ctx = this._chart.ctx;
                var vm = this._view;

                if (vm.opacity === 0) {
                    return;
                }

                var tooltipSize = this.getTooltipSize(vm);
                var pt = {
                    x: vm.x,
                    y: vm.y
                };

                // IE11/Edge does not like very small opacities, so snap to 0
                var opacity = Math.abs(vm.opacity < 1e-3) ? 0 : vm.opacity;

                if (this._options.enabled) {
                    // Draw Background
                    var bgColor = helpers.color(vm.backgroundColor);
                    ctx.fillStyle = bgColor.alpha(opacity * bgColor.alpha()).rgbString();
                    helpers.drawRoundedRectangle(ctx, pt.x, pt.y, tooltipSize.width, tooltipSize.height, vm.cornerRadius);
                    ctx.fill();

                    // Draw Caret
                    this.drawCaret(pt, tooltipSize, opacity);

                    // Draw Title, Body, and Footer
                    pt.x += vm.xPadding;
                    pt.y += vm.yPadding;

                    // Titles
                    this.drawTitle(pt, vm, ctx, opacity);

                    // Body
                    this.drawBody(pt, vm, ctx, opacity);

                    // Footer
                    this.drawFooter(pt, vm, ctx, opacity);
                }
            }
        });
    };

},{}],35:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers,
            globalOpts = Chart.defaults.global;

        globalOpts.elements.arc = {
            backgroundColor: globalOpts.defaultColor,
            borderColor: '#fff',
            borderWidth: 2
        };

        Chart.elements.Arc = Chart.Element.extend({
            inLabelRange: function(mouseX) {
                var vm = this._view;

                if (vm) {
                    return (Math.pow(mouseX - vm.x, 2) < Math.pow(vm.radius + vm.hoverRadius, 2));
                }
                return false;
            },
            inRange: function(chartX, chartY) {
                var vm = this._view;

                if (vm) {
                    var pointRelativePosition = helpers.getAngleFromPoint(vm, {
                            x: chartX,
                            y: chartY
                        }),
                        angle = pointRelativePosition.angle,
                        distance = pointRelativePosition.distance;

                    // Sanitise angle range
                    var startAngle = vm.startAngle;
                    var endAngle = vm.endAngle;
                    while (endAngle < startAngle) {
                        endAngle += 2.0 * Math.PI;
                    }
                    while (angle > endAngle) {
                        angle -= 2.0 * Math.PI;
                    }
                    while (angle < startAngle) {
                        angle += 2.0 * Math.PI;
                    }

                    // Check if within the range of the open/close angle
                    var betweenAngles = (angle >= startAngle && angle <= endAngle),
                        withinRadius = (distance >= vm.innerRadius && distance <= vm.outerRadius);

                    return (betweenAngles && withinRadius);
                }
                return false;
            },
            tooltipPosition: function() {
                var vm = this._view;

                var centreAngle = vm.startAngle + ((vm.endAngle - vm.startAngle) / 2),
                    rangeFromCentre = (vm.outerRadius - vm.innerRadius) / 2 + vm.innerRadius;
                return {
                    x: vm.x + (Math.cos(centreAngle) * rangeFromCentre),
                    y: vm.y + (Math.sin(centreAngle) * rangeFromCentre)
                };
            },
            draw: function() {

                var ctx = this._chart.ctx,
                    vm = this._view,
                    sA = vm.startAngle,
                    eA = vm.endAngle;

                ctx.beginPath();

                ctx.arc(vm.x, vm.y, vm.outerRadius, sA, eA);
                ctx.arc(vm.x, vm.y, vm.innerRadius, eA, sA, true);

                ctx.closePath();
                ctx.strokeStyle = vm.borderColor;
                ctx.lineWidth = vm.borderWidth;

                ctx.fillStyle = vm.backgroundColor;

                ctx.fill();
                ctx.lineJoin = 'bevel';

                if (vm.borderWidth) {
                    ctx.stroke();
                }
            }
        });
    };

},{}],36:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;
        var globalDefaults = Chart.defaults.global;

        Chart.defaults.global.elements.line = {
            tension: 0.4,
            backgroundColor: globalDefaults.defaultColor,
            borderWidth: 3,
            borderColor: globalDefaults.defaultColor,
            borderCapStyle: 'butt',
            borderDash: [],
            borderDashOffset: 0.0,
            borderJoinStyle: 'miter',
            capBezierPoints: true,
            fill: true // do we fill in the area between the line and its base axis
        };

        Chart.elements.Line = Chart.Element.extend({
            draw: function() {
                var me = this;
                var vm = me._view;
                var spanGaps = vm.spanGaps;
                var scaleZero = vm.scaleZero;
                var loop = me._loop;

                var ctx = me._chart.ctx;
                ctx.save();

                // Helper function to draw a line to a point
                function lineToPoint(previousPoint, point) {
                    var pointVM = point._view;
                    if (point._view.steppedLine === true) {
                        ctx.lineTo(pointVM.x, previousPoint._view.y);
                        ctx.lineTo(pointVM.x, pointVM.y);
                    } else if (point._view.tension === 0) {
                        ctx.lineTo(pointVM.x, pointVM.y);
                    } else {
                        ctx.bezierCurveTo(
                            previousPoint._view.controlPointNextX,
                            previousPoint._view.controlPointNextY,
                            pointVM.controlPointPreviousX,
                            pointVM.controlPointPreviousY,
                            pointVM.x,
                            pointVM.y
                        );
                    }
                }

                var points = me._children.slice(); // clone array
                var lastDrawnIndex = -1;

                // If we are looping, adding the first point again
                if (loop && points.length) {
                    points.push(points[0]);
                }

                var index, current, previous, currentVM;

                // Fill Line
                if (points.length && vm.fill) {
                    ctx.beginPath();

                    for (index = 0; index < points.length; ++index) {
                        current = points[index];
                        previous = helpers.previousItem(points, index);
                        currentVM = current._view;

                        // First point moves to it's starting position no matter what
                        if (index === 0) {
                            if (loop) {
                                ctx.moveTo(scaleZero.x, scaleZero.y);
                            } else {
                                ctx.moveTo(currentVM.x, scaleZero);
                            }

                            if (!currentVM.skip) {
                                lastDrawnIndex = index;
                                ctx.lineTo(currentVM.x, currentVM.y);
                            }
                        } else {
                            previous = lastDrawnIndex === -1 ? previous : points[lastDrawnIndex];

                            if (currentVM.skip) {
                                // Only do this if this is the first point that is skipped
                                if (!spanGaps && lastDrawnIndex === (index - 1)) {
                                    if (loop) {
                                        ctx.lineTo(scaleZero.x, scaleZero.y);
                                    } else {
                                        ctx.lineTo(previous._view.x, scaleZero);
                                    }
                                }
                            } else {
                                if (lastDrawnIndex !== (index - 1)) {
                                    // There was a gap and this is the first point after the gap. If we've never drawn a point, this is a special case.
                                    // If the first data point is NaN, then there is no real gap to skip
                                    if (spanGaps && lastDrawnIndex !== -1) {
                                        // We are spanning the gap, so simple draw a line to this point
                                        lineToPoint(previous, current);
                                    } else if (loop) {
                                        ctx.lineTo(currentVM.x, currentVM.y);
                                    } else {
                                        ctx.lineTo(currentVM.x, scaleZero);
                                        ctx.lineTo(currentVM.x, currentVM.y);
                                    }
                                } else {
                                    // Line to next point
                                    lineToPoint(previous, current);
                                }
                                lastDrawnIndex = index;
                            }
                        }
                    }

                    if (!loop && lastDrawnIndex !== -1) {
                        ctx.lineTo(points[lastDrawnIndex]._view.x, scaleZero);
                    }

                    ctx.fillStyle = vm.backgroundColor || globalDefaults.defaultColor;
                    ctx.closePath();
                    ctx.fill();
                }

                // Stroke Line Options
                var globalOptionLineElements = globalDefaults.elements.line;
                ctx.lineCap = vm.borderCapStyle || globalOptionLineElements.borderCapStyle;

                // IE 9 and 10 do not support line dash
                if (ctx.setLineDash) {
                    ctx.setLineDash(vm.borderDash || globalOptionLineElements.borderDash);
                }

                ctx.lineDashOffset = vm.borderDashOffset || globalOptionLineElements.borderDashOffset;
                ctx.lineJoin = vm.borderJoinStyle || globalOptionLineElements.borderJoinStyle;
                ctx.lineWidth = vm.borderWidth || globalOptionLineElements.borderWidth;
                ctx.strokeStyle = vm.borderColor || globalDefaults.defaultColor;

                // Stroke Line
                ctx.beginPath();
                lastDrawnIndex = -1;

                for (index = 0; index < points.length; ++index) {
                    current = points[index];
                    previous = helpers.previousItem(points, index);
                    currentVM = current._view;

                    // First point moves to it's starting position no matter what
                    if (index === 0) {
                        if (!currentVM.skip) {
                            ctx.moveTo(currentVM.x, currentVM.y);
                            lastDrawnIndex = index;
                        }
                    } else {
                        previous = lastDrawnIndex === -1 ? previous : points[lastDrawnIndex];

                        if (!currentVM.skip) {
                            if ((lastDrawnIndex !== (index - 1) && !spanGaps) || lastDrawnIndex === -1) {
                                // There was a gap and this is the first point after the gap
                                ctx.moveTo(currentVM.x, currentVM.y);
                            } else {
                                // Line to next point
                                lineToPoint(previous, current);
                            }
                            lastDrawnIndex = index;
                        }
                    }
                }

                ctx.stroke();
                ctx.restore();
            }
        });
    };

},{}],37:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers,
            globalOpts = Chart.defaults.global,
            defaultColor = globalOpts.defaultColor;

        globalOpts.elements.point = {
            radius: 3,
            pointStyle: 'circle',
            backgroundColor: defaultColor,
            borderWidth: 1,
            borderColor: defaultColor,
            // Hover
            hitRadius: 1,
            hoverRadius: 4,
            hoverBorderWidth: 1
        };

        Chart.elements.Point = Chart.Element.extend({
            inRange: function(mouseX, mouseY) {
                var vm = this._view;
                return vm ? ((Math.pow(mouseX - vm.x, 2) + Math.pow(mouseY - vm.y, 2)) < Math.pow(vm.hitRadius + vm.radius, 2)) : false;
            },
            inLabelRange: function(mouseX) {
                var vm = this._view;
                return vm ? (Math.pow(mouseX - vm.x, 2) < Math.pow(vm.radius + vm.hitRadius, 2)) : false;
            },
            tooltipPosition: function() {
                var vm = this._view;
                return {
                    x: vm.x,
                    y: vm.y,
                    padding: vm.radius + vm.borderWidth
                };
            },
            draw: function() {
                var vm = this._view;
                var ctx = this._chart.ctx;
                var pointStyle = vm.pointStyle;
                var radius = vm.radius;
                var x = vm.x;
                var y = vm.y;

                if (vm.skip) {
                    return;
                }

                ctx.strokeStyle = vm.borderColor || defaultColor;
                ctx.lineWidth = helpers.getValueOrDefault(vm.borderWidth, globalOpts.elements.point.borderWidth);
                ctx.fillStyle = vm.backgroundColor || defaultColor;

                Chart.canvasHelpers.drawPoint(ctx, pointStyle, radius, x, y);
            }
        });
    };

},{}],38:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var globalOpts = Chart.defaults.global;

        globalOpts.elements.rectangle = {
            backgroundColor: globalOpts.defaultColor,
            borderWidth: 0,
            borderColor: globalOpts.defaultColor,
            borderSkipped: 'bottom'
        };

        Chart.elements.Rectangle = Chart.Element.extend({
            draw: function() {
                var ctx = this._chart.ctx;
                var vm = this._view;

                var halfWidth = vm.width / 2,
                    leftX = vm.x - halfWidth,
                    rightX = vm.x + halfWidth,
                    top = vm.base - (vm.base - vm.y),
                    halfStroke = vm.borderWidth / 2;

                // Canvas doesn't allow us to stroke inside the width so we can
                // adjust the sizes to fit if we're setting a stroke on the line
                if (vm.borderWidth) {
                    leftX += halfStroke;
                    rightX -= halfStroke;
                    top += halfStroke;
                }

                ctx.beginPath();
                ctx.fillStyle = vm.backgroundColor;
                ctx.strokeStyle = vm.borderColor;
                ctx.lineWidth = vm.borderWidth;

                // Corner points, from bottom-left to bottom-right clockwise
                // | 1 2 |
                // | 0 3 |
                var corners = [
                    [leftX, vm.base],
                    [leftX, top],
                    [rightX, top],
                    [rightX, vm.base]
                ];

                // Find first (starting) corner with fallback to 'bottom'
                var borders = ['bottom', 'left', 'top', 'right'];
                var startCorner = borders.indexOf(vm.borderSkipped, 0);
                if (startCorner === -1) {
                    startCorner = 0;
                }

                function cornerAt(index) {
                    return corners[(startCorner + index) % 4];
                }

                // Draw rectangle from 'startCorner'
                ctx.moveTo.apply(ctx, cornerAt(0));
                for (var i = 1; i < 4; i++) {
                    ctx.lineTo.apply(ctx, cornerAt(i));
                }

                ctx.fill();
                if (vm.borderWidth) {
                    ctx.stroke();
                }
            },
            height: function() {
                var vm = this._view;
                return vm.base - vm.y;
            },
            inRange: function(mouseX, mouseY) {
                var vm = this._view;
                return vm ?
                    (vm.y < vm.base ?
                    (mouseX >= vm.x - vm.width / 2 && mouseX <= vm.x + vm.width / 2) && (mouseY >= vm.y && mouseY <= vm.base) :
                    (mouseX >= vm.x - vm.width / 2 && mouseX <= vm.x + vm.width / 2) && (mouseY >= vm.base && mouseY <= vm.y)) :
                    false;
            },
            inLabelRange: function(mouseX) {
                var vm = this._view;
                return vm ? (mouseX >= vm.x - vm.width / 2 && mouseX <= vm.x + vm.width / 2) : false;
            },
            tooltipPosition: function() {
                var vm = this._view;
                return {
                    x: vm.x,
                    y: vm.y
                };
            }
        });

    };

},{}],39:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;
        // Default config for a category scale
        var defaultConfig = {
            position: 'bottom'
        };

        var DatasetScale = Chart.Scale.extend({
            /**
             * Internal function to get the correct labels. If data.xLabels or data.yLabels are defined, use tose
             * else fall back to data.labels
             * @private
             */
            getLabels: function() {
                var data = this.chart.data;
                return (this.isHorizontal() ? data.xLabels : data.yLabels) || data.labels;
            },
            // Implement this so that
            determineDataLimits: function() {
                var me = this;
                var labels = me.getLabels();
                me.minIndex = 0;
                me.maxIndex = labels.length - 1;
                var findIndex;

                if (me.options.ticks.min !== undefined) {
                    // user specified min value
                    findIndex = helpers.indexOf(labels, me.options.ticks.min);
                    me.minIndex = findIndex !== -1 ? findIndex : me.minIndex;
                }

                if (me.options.ticks.max !== undefined) {
                    // user specified max value
                    findIndex = helpers.indexOf(labels, me.options.ticks.max);
                    me.maxIndex = findIndex !== -1 ? findIndex : me.maxIndex;
                }

                me.min = labels[me.minIndex];
                me.max = labels[me.maxIndex];
            },

            buildTicks: function() {
                var me = this;
                var labels = me.getLabels();
                // If we are viewing some subset of labels, slice the original array
                me.ticks = (me.minIndex === 0 && me.maxIndex === labels.length - 1) ? labels : labels.slice(me.minIndex, me.maxIndex + 1);
            },

            getLabelForIndex: function(index, datasetIndex) {
                var me = this;
                var data = me.chart.data;
                var isHorizontal = me.isHorizontal();

                if ((data.xLabels && isHorizontal) || (data.yLabels && !isHorizontal)) {
                    return me.getRightValue(data.datasets[datasetIndex].data[index]);
                }
                return me.ticks[index];
            },

            // Used to get data value locations.  Value can either be an index or a numerical value
            getPixelForValue: function(value, index, datasetIndex, includeOffset) {
                var me = this;
                // 1 is added because we need the length but we have the indexes
                var offsetAmt = Math.max((me.maxIndex + 1 - me.minIndex - ((me.options.gridLines.offsetGridLines) ? 0 : 1)), 1);

                if (value !== undefined && isNaN(index)) {
                    var labels = me.getLabels();
                    var idx = labels.indexOf(value);
                    index = idx !== -1 ? idx : index;
                }

                if (me.isHorizontal()) {
                    var innerWidth = me.width - (me.paddingLeft + me.paddingRight);
                    var valueWidth = innerWidth / offsetAmt;
                    var widthOffset = (valueWidth * (index - me.minIndex)) + me.paddingLeft;

                    if (me.options.gridLines.offsetGridLines && includeOffset || me.maxIndex === me.minIndex && includeOffset) {
                        widthOffset += (valueWidth / 2);
                    }

                    return me.left + Math.round(widthOffset);
                }
                var innerHeight = me.height - (me.paddingTop + me.paddingBottom);
                var valueHeight = innerHeight / offsetAmt;
                var heightOffset = (valueHeight * (index - me.minIndex)) + me.paddingTop;

                if (me.options.gridLines.offsetGridLines && includeOffset) {
                    heightOffset += (valueHeight / 2);
                }

                return me.top + Math.round(heightOffset);
            },
            getPixelForTick: function(index, includeOffset) {
                return this.getPixelForValue(this.ticks[index], index + this.minIndex, null, includeOffset);
            },
            getValueForPixel: function(pixel) {
                var me = this;
                var value;
                var offsetAmt = Math.max((me.ticks.length - ((me.options.gridLines.offsetGridLines) ? 0 : 1)), 1);
                var horz = me.isHorizontal();
                var innerDimension = horz ? me.width - (me.paddingLeft + me.paddingRight) : me.height - (me.paddingTop + me.paddingBottom);
                var valueDimension = innerDimension / offsetAmt;

                pixel -= horz ? me.left : me.top;

                if (me.options.gridLines.offsetGridLines) {
                    pixel -= (valueDimension / 2);
                }
                pixel -= horz ? me.paddingLeft : me.paddingTop;

                if (pixel <= 0) {
                    value = 0;
                } else {
                    value = Math.round(pixel / valueDimension);
                }

                return value;
            },
            getBasePixel: function() {
                return this.bottom;
            }
        });

        Chart.scaleService.registerScaleType('category', DatasetScale, defaultConfig);

    };

},{}],40:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;

        var defaultConfig = {
            position: 'left',
            ticks: {
                callback: function(tickValue, index, ticks) {
                    // If we have lots of ticks, don't use the ones
                    var delta = ticks.length > 3 ? ticks[2] - ticks[1] : ticks[1] - ticks[0];

                    // If we have a number like 2.5 as the delta, figure out how many decimal places we need
                    if (Math.abs(delta) > 1) {
                        if (tickValue !== Math.floor(tickValue)) {
                            // not an integer
                            delta = tickValue - Math.floor(tickValue);
                        }
                    }

                    var logDelta = helpers.log10(Math.abs(delta));
                    var tickString = '';

                    if (tickValue !== 0) {
                        var numDecimal = -1 * Math.floor(logDelta);
                        numDecimal = Math.max(Math.min(numDecimal, 20), 0); // toFixed has a max of 20 decimal places
                        tickString = tickValue.toFixed(numDecimal);
                    } else {
                        tickString = '0'; // never show decimal places for 0
                    }

                    return tickString;
                }
            }
        };

        var LinearScale = Chart.LinearScaleBase.extend({
            determineDataLimits: function() {
                var me = this;
                var opts = me.options;
                var chart = me.chart;
                var data = chart.data;
                var datasets = data.datasets;
                var isHorizontal = me.isHorizontal();

                function IDMatches(meta) {
                    return isHorizontal ? meta.xAxisID === me.id : meta.yAxisID === me.id;
                }

                // First Calculate the range
                me.min = null;
                me.max = null;

                if (opts.stacked) {
                    var valuesPerType = {};

                    helpers.each(datasets, function(dataset, datasetIndex) {
                        var meta = chart.getDatasetMeta(datasetIndex);
                        if (valuesPerType[meta.type] === undefined) {
                            valuesPerType[meta.type] = {
                                positiveValues: [],
                                negativeValues: []
                            };
                        }

                        // Store these per type
                        var positiveValues = valuesPerType[meta.type].positiveValues;
                        var negativeValues = valuesPerType[meta.type].negativeValues;

                        if (chart.isDatasetVisible(datasetIndex) && IDMatches(meta)) {
                            helpers.each(dataset.data, function(rawValue, index) {
                                var value = +me.getRightValue(rawValue);
                                if (isNaN(value) || meta.data[index].hidden) {
                                    return;
                                }

                                positiveValues[index] = positiveValues[index] || 0;
                                negativeValues[index] = negativeValues[index] || 0;

                                if (opts.relativePoints) {
                                    positiveValues[index] = 100;
                                } else if (value < 0) {
                                    negativeValues[index] += value;
                                } else {
                                    positiveValues[index] += value;
                                }
                            });
                        }
                    });

                    helpers.each(valuesPerType, function(valuesForType) {
                        var values = valuesForType.positiveValues.concat(valuesForType.negativeValues);
                        var minVal = helpers.min(values);
                        var maxVal = helpers.max(values);
                        me.min = me.min === null ? minVal : Math.min(me.min, minVal);
                        me.max = me.max === null ? maxVal : Math.max(me.max, maxVal);
                    });

                } else {
                    helpers.each(datasets, function(dataset, datasetIndex) {
                        var meta = chart.getDatasetMeta(datasetIndex);
                        if (chart.isDatasetVisible(datasetIndex) && IDMatches(meta)) {
                            helpers.each(dataset.data, function(rawValue, index) {
                                var value = +me.getRightValue(rawValue);
                                if (isNaN(value) || meta.data[index].hidden) {
                                    return;
                                }

                                if (me.min === null) {
                                    me.min = value;
                                } else if (value < me.min) {
                                    me.min = value;
                                }

                                if (me.max === null) {
                                    me.max = value;
                                } else if (value > me.max) {
                                    me.max = value;
                                }
                            });
                        }
                    });
                }

                // Common base implementation to handle ticks.min, ticks.max, ticks.beginAtZero
                this.handleTickRangeOptions();
            },
            getTickLimit: function() {
                var maxTicks;
                var me = this;
                var tickOpts = me.options.ticks;

                if (me.isHorizontal()) {
                    maxTicks = Math.min(tickOpts.maxTicksLimit ? tickOpts.maxTicksLimit : 11, Math.ceil(me.width / 50));
                } else {
                    // The factor of 2 used to scale the font size has been experimentally determined.
                    var tickFontSize = helpers.getValueOrDefault(tickOpts.fontSize, Chart.defaults.global.defaultFontSize);
                    maxTicks = Math.min(tickOpts.maxTicksLimit ? tickOpts.maxTicksLimit : 11, Math.ceil(me.height / (2 * tickFontSize)));
                }

                return maxTicks;
            },
            // Called after the ticks are built. We need
            handleDirectionalChanges: function() {
                if (!this.isHorizontal()) {
                    // We are in a vertical orientation. The top value is the highest. So reverse the array
                    this.ticks.reverse();
                }
            },
            getLabelForIndex: function(index, datasetIndex) {
                return +this.getRightValue(this.chart.data.datasets[datasetIndex].data[index]);
            },
            // Utils
            getPixelForValue: function(value) {
                // This must be called after fit has been run so that
                // this.left, this.top, this.right, and this.bottom have been defined
                var me = this;
                var paddingLeft = me.paddingLeft;
                var paddingBottom = me.paddingBottom;
                var start = me.start;

                var rightValue = +me.getRightValue(value);
                var pixel;
                var innerDimension;
                var range = me.end - start;

                if (me.isHorizontal()) {
                    innerDimension = me.width - (paddingLeft + me.paddingRight);
                    pixel = me.left + (innerDimension / range * (rightValue - start));
                    return Math.round(pixel + paddingLeft);
                }
                innerDimension = me.height - (me.paddingTop + paddingBottom);
                pixel = (me.bottom - paddingBottom) - (innerDimension / range * (rightValue - start));
                return Math.round(pixel);
            },
            getValueForPixel: function(pixel) {
                var me = this;
                var isHorizontal = me.isHorizontal();
                var paddingLeft = me.paddingLeft;
                var paddingBottom = me.paddingBottom;
                var innerDimension = isHorizontal ? me.width - (paddingLeft + me.paddingRight) : me.height - (me.paddingTop + paddingBottom);
                var offset = (isHorizontal ? pixel - me.left - paddingLeft : me.bottom - paddingBottom - pixel) / innerDimension;
                return me.start + ((me.end - me.start) * offset);
            },
            getPixelForTick: function(index) {
                return this.getPixelForValue(this.ticksAsNumbers[index]);
            }
        });
        Chart.scaleService.registerScaleType('linear', LinearScale, defaultConfig);

    };

},{}],41:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers,
            noop = helpers.noop;

        Chart.LinearScaleBase = Chart.Scale.extend({
            handleTickRangeOptions: function() {
                var me = this;
                var opts = me.options;
                var tickOpts = opts.ticks;

                // If we are forcing it to begin at 0, but 0 will already be rendered on the chart,
                // do nothing since that would make the chart weird. If the user really wants a weird chart
                // axis, they can manually override it
                if (tickOpts.beginAtZero) {
                    var minSign = helpers.sign(me.min);
                    var maxSign = helpers.sign(me.max);

                    if (minSign < 0 && maxSign < 0) {
                        // move the top up to 0
                        me.max = 0;
                    } else if (minSign > 0 && maxSign > 0) {
                        // move the botttom down to 0
                        me.min = 0;
                    }
                }

                if (tickOpts.min !== undefined) {
                    me.min = tickOpts.min;
                } else if (tickOpts.suggestedMin !== undefined) {
                    me.min = Math.min(me.min, tickOpts.suggestedMin);
                }

                if (tickOpts.max !== undefined) {
                    me.max = tickOpts.max;
                } else if (tickOpts.suggestedMax !== undefined) {
                    me.max = Math.max(me.max, tickOpts.suggestedMax);
                }

                if (me.min === me.max) {
                    me.max++;

                    if (!tickOpts.beginAtZero) {
                        me.min--;
                    }
                }
            },
            getTickLimit: noop,
            handleDirectionalChanges: noop,

            buildTicks: function() {
                var me = this;
                var opts = me.options;
                var ticks = me.ticks = [];
                var tickOpts = opts.ticks;
                var getValueOrDefault = helpers.getValueOrDefault;

                // Figure out what the max number of ticks we can support it is based on the size of
                // the axis area. For now, we say that the minimum tick spacing in pixels must be 50
                // We also limit the maximum number of ticks to 11 which gives a nice 10 squares on
                // the graph

                var maxTicks = me.getTickLimit();

                // Make sure we always have at least 2 ticks
                maxTicks = Math.max(2, maxTicks);

                // To get a "nice" value for the tick spacing, we will use the appropriately named
                // "nice number" algorithm. See http://stackoverflow.com/questions/8506881/nice-label-algorithm-for-charts-with-minimum-ticks
                // for details.

                var spacing;
                var fixedStepSizeSet = (tickOpts.fixedStepSize && tickOpts.fixedStepSize > 0) || (tickOpts.stepSize && tickOpts.stepSize > 0);
                if (fixedStepSizeSet) {
                    spacing = getValueOrDefault(tickOpts.fixedStepSize, tickOpts.stepSize);
                } else {
                    var niceRange = helpers.niceNum(me.max - me.min, false);
                    spacing = helpers.niceNum(niceRange / (maxTicks - 1), true);
                }
                var niceMin = Math.floor(me.min / spacing) * spacing;
                var niceMax = Math.ceil(me.max / spacing) * spacing;
                var numSpaces = (niceMax - niceMin) / spacing;

                // If very close to our rounded value, use it.
                if (helpers.almostEquals(numSpaces, Math.round(numSpaces), spacing / 1000)) {
                    numSpaces = Math.round(numSpaces);
                } else {
                    numSpaces = Math.ceil(numSpaces);
                }

                // Put the values into the ticks array
                ticks.push(tickOpts.min !== undefined ? tickOpts.min : niceMin);
                for (var j = 1; j < numSpaces; ++j) {
                    ticks.push(niceMin + (j * spacing));
                }
                ticks.push(tickOpts.max !== undefined ? tickOpts.max : niceMax);

                me.handleDirectionalChanges();

                // At this point, we need to update our max and min given the tick values since we have expanded the
                // range of the scale
                me.max = helpers.max(ticks);
                me.min = helpers.min(ticks);

                if (tickOpts.reverse) {
                    ticks.reverse();

                    me.start = me.max;
                    me.end = me.min;
                } else {
                    me.start = me.min;
                    me.end = me.max;
                }
            },
            convertTicksToLabels: function() {
                var me = this;
                me.ticksAsNumbers = me.ticks.slice();
                me.zeroLineIndex = me.ticks.indexOf(0);

                Chart.Scale.prototype.convertTicksToLabels.call(me);
            }
        });
    };

},{}],42:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;

        var defaultConfig = {
            position: 'left',

            // label settings
            ticks: {
                callback: function(value, index, arr) {
                    var remain = value / (Math.pow(10, Math.floor(helpers.log10(value))));

                    if (value === 0) {
                        return '0';
                    } else if (remain === 1 || remain === 2 || remain === 5 || index === 0 || index === arr.length - 1) {
                        return value.toExponential();
                    }
                    return '';
                }
            }
        };

        var LogarithmicScale = Chart.Scale.extend({
            determineDataLimits: function() {
                var me = this;
                var opts = me.options;
                var tickOpts = opts.ticks;
                var chart = me.chart;
                var data = chart.data;
                var datasets = data.datasets;
                var getValueOrDefault = helpers.getValueOrDefault;
                var isHorizontal = me.isHorizontal();
                function IDMatches(meta) {
                    return isHorizontal ? meta.xAxisID === me.id : meta.yAxisID === me.id;
                }

                // Calculate Range
                me.min = null;
                me.max = null;
                me.minNotZero = null;

                if (opts.stacked) {
                    var valuesPerType = {};

                    helpers.each(datasets, function(dataset, datasetIndex) {
                        var meta = chart.getDatasetMeta(datasetIndex);
                        if (chart.isDatasetVisible(datasetIndex) && IDMatches(meta)) {
                            if (valuesPerType[meta.type] === undefined) {
                                valuesPerType[meta.type] = [];
                            }

                            helpers.each(dataset.data, function(rawValue, index) {
                                var values = valuesPerType[meta.type];
                                var value = +me.getRightValue(rawValue);
                                if (isNaN(value) || meta.data[index].hidden) {
                                    return;
                                }

                                values[index] = values[index] || 0;

                                if (opts.relativePoints) {
                                    values[index] = 100;
                                } else {
                                    // Don't need to split positive and negative since the log scale can't handle a 0 crossing
                                    values[index] += value;
                                }
                            });
                        }
                    });

                    helpers.each(valuesPerType, function(valuesForType) {
                        var minVal = helpers.min(valuesForType);
                        var maxVal = helpers.max(valuesForType);
                        me.min = me.min === null ? minVal : Math.min(me.min, minVal);
                        me.max = me.max === null ? maxVal : Math.max(me.max, maxVal);
                    });

                } else {
                    helpers.each(datasets, function(dataset, datasetIndex) {
                        var meta = chart.getDatasetMeta(datasetIndex);
                        if (chart.isDatasetVisible(datasetIndex) && IDMatches(meta)) {
                            helpers.each(dataset.data, function(rawValue, index) {
                                var value = +me.getRightValue(rawValue);
                                if (isNaN(value) || meta.data[index].hidden) {
                                    return;
                                }

                                if (me.min === null) {
                                    me.min = value;
                                } else if (value < me.min) {
                                    me.min = value;
                                }

                                if (me.max === null) {
                                    me.max = value;
                                } else if (value > me.max) {
                                    me.max = value;
                                }

                                if (value !== 0 && (me.minNotZero === null || value < me.minNotZero)) {
                                    me.minNotZero = value;
                                }
                            });
                        }
                    });
                }

                me.min = getValueOrDefault(tickOpts.min, me.min);
                me.max = getValueOrDefault(tickOpts.max, me.max);

                if (me.min === me.max) {
                    if (me.min !== 0 && me.min !== null) {
                        me.min = Math.pow(10, Math.floor(helpers.log10(me.min)) - 1);
                        me.max = Math.pow(10, Math.floor(helpers.log10(me.max)) + 1);
                    } else {
                        me.min = 1;
                        me.max = 10;
                    }
                }
            },
            buildTicks: function() {
                var me = this;
                var opts = me.options;
                var tickOpts = opts.ticks;
                var getValueOrDefault = helpers.getValueOrDefault;

                // Reset the ticks array. Later on, we will draw a grid line at these positions
                // The array simply contains the numerical value of the spots where ticks will be
                var ticks = me.ticks = [];

                // Figure out what the max number of ticks we can support it is based on the size of
                // the axis area. For now, we say that the minimum tick spacing in pixels must be 50
                // We also limit the maximum number of ticks to 11 which gives a nice 10 squares on
                // the graph

                var tickVal = getValueOrDefault(tickOpts.min, Math.pow(10, Math.floor(helpers.log10(me.min))));

                while (tickVal < me.max) {
                    ticks.push(tickVal);

                    var exp;
                    var significand;

                    if (tickVal === 0) {
                        exp = Math.floor(helpers.log10(me.minNotZero));
                        significand = Math.round(me.minNotZero / Math.pow(10, exp));
                    } else {
                        exp = Math.floor(helpers.log10(tickVal));
                        significand = Math.floor(tickVal / Math.pow(10, exp)) + 1;
                    }

                    if (significand === 10) {
                        significand = 1;
                        ++exp;
                    }

                    tickVal = significand * Math.pow(10, exp);
                }

                var lastTick = getValueOrDefault(tickOpts.max, tickVal);
                ticks.push(lastTick);

                if (!me.isHorizontal()) {
                    // We are in a vertical orientation. The top value is the highest. So reverse the array
                    ticks.reverse();
                }

                // At this point, we need to update our max and min given the tick values since we have expanded the
                // range of the scale
                me.max = helpers.max(ticks);
                me.min = helpers.min(ticks);

                if (tickOpts.reverse) {
                    ticks.reverse();

                    me.start = me.max;
                    me.end = me.min;
                } else {
                    me.start = me.min;
                    me.end = me.max;
                }
            },
            convertTicksToLabels: function() {
                this.tickValues = this.ticks.slice();

                Chart.Scale.prototype.convertTicksToLabels.call(this);
            },
            // Get the correct tooltip label
            getLabelForIndex: function(index, datasetIndex) {
                return +this.getRightValue(this.chart.data.datasets[datasetIndex].data[index]);
            },
            getPixelForTick: function(index) {
                return this.getPixelForValue(this.tickValues[index]);
            },
            getPixelForValue: function(value) {
                var me = this;
                var innerDimension;
                var pixel;

                var start = me.start;
                var newVal = +me.getRightValue(value);
                var range;
                var paddingTop = me.paddingTop;
                var paddingBottom = me.paddingBottom;
                var paddingLeft = me.paddingLeft;
                var opts = me.options;
                var tickOpts = opts.ticks;

                if (me.isHorizontal()) {
                    range = helpers.log10(me.end) - helpers.log10(start); // todo: if start === 0
                    if (newVal === 0) {
                        pixel = me.left + paddingLeft;
                    } else {
                        innerDimension = me.width - (paddingLeft + me.paddingRight);
                        pixel = me.left + (innerDimension / range * (helpers.log10(newVal) - helpers.log10(start)));
                        pixel += paddingLeft;
                    }
                } else {
                    // Bottom - top since pixels increase downard on a screen
                    innerDimension = me.height - (paddingTop + paddingBottom);
                    if (start === 0 && !tickOpts.reverse) {
                        range = helpers.log10(me.end) - helpers.log10(me.minNotZero);
                        if (newVal === start) {
                            pixel = me.bottom - paddingBottom;
                        } else if (newVal === me.minNotZero) {
                            pixel = me.bottom - paddingBottom - innerDimension * 0.02;
                        } else {
                            pixel = me.bottom - paddingBottom - innerDimension * 0.02 - (innerDimension * 0.98/ range * (helpers.log10(newVal)-helpers.log10(me.minNotZero)));
                        }
                    } else if (me.end === 0 && tickOpts.reverse) {
                        range = helpers.log10(me.start) - helpers.log10(me.minNotZero);
                        if (newVal === me.end) {
                            pixel = me.top + paddingTop;
                        } else if (newVal === me.minNotZero) {
                            pixel = me.top + paddingTop + innerDimension * 0.02;
                        } else {
                            pixel = me.top + paddingTop + innerDimension * 0.02 + (innerDimension * 0.98/ range * (helpers.log10(newVal)-helpers.log10(me.minNotZero)));
                        }
                    } else {
                        range = helpers.log10(me.end) - helpers.log10(start);
                        innerDimension = me.height - (paddingTop + paddingBottom);
                        pixel = (me.bottom - paddingBottom) - (innerDimension / range * (helpers.log10(newVal) - helpers.log10(start)));
                    }
                }
                return pixel;
            },
            getValueForPixel: function(pixel) {
                var me = this;
                var range = helpers.log10(me.end) - helpers.log10(me.start);
                var value, innerDimension;

                if (me.isHorizontal()) {
                    innerDimension = me.width - (me.paddingLeft + me.paddingRight);
                    value = me.start * Math.pow(10, (pixel - me.left - me.paddingLeft) * range / innerDimension);
                } else {  // todo: if start === 0
                    innerDimension = me.height - (me.paddingTop + me.paddingBottom);
                    value = Math.pow(10, (me.bottom - me.paddingBottom - pixel) * range / innerDimension) / me.start;
                }
                return value;
            }
        });
        Chart.scaleService.registerScaleType('logarithmic', LogarithmicScale, defaultConfig);

    };

},{}],43:[function(require,module,exports){
    'use strict';

    module.exports = function(Chart) {

        var helpers = Chart.helpers;
        var globalDefaults = Chart.defaults.global;

        var defaultConfig = {
            display: true,

            // Boolean - Whether to animate scaling the chart from the centre
            animate: true,
            lineArc: false,
            position: 'chartArea',

            angleLines: {
                display: true,
                color: 'rgba(0, 0, 0, 0.1)',
                lineWidth: 1
            },

            // label settings
            ticks: {
                // Boolean - Show a backdrop to the scale label
                showLabelBackdrop: true,

                // String - The colour of the label backdrop
                backdropColor: 'rgba(255,255,255,0.75)',

                // Number - The backdrop padding above & below the label in pixels
                backdropPaddingY: 2,

                // Number - The backdrop padding to the side of the label in pixels
                backdropPaddingX: 2
            },

            pointLabels: {
                // Number - Point label font size in pixels
                fontSize: 10,

                // Function - Used to convert point labels
                callback: function(label) {
                    return label;
                }
            }
        };

        var LinearRadialScale = Chart.LinearScaleBase.extend({
            getValueCount: function() {
                return this.chart.data.labels.length;
            },
            setDimensions: function() {
                var me = this;
                var opts = me.options;
                var tickOpts = opts.ticks;
                // Set the unconstrained dimension before label rotation
                me.width = me.maxWidth;
                me.height = me.maxHeight;
                me.xCenter = Math.round(me.width / 2);
                me.yCenter = Math.round(me.height / 2);

                var minSize = helpers.min([me.height, me.width]);
                var tickFontSize = helpers.getValueOrDefault(tickOpts.fontSize, globalDefaults.defaultFontSize);
                me.drawingArea = opts.display ? (minSize / 2) - (tickFontSize / 2 + tickOpts.backdropPaddingY) : (minSize / 2);
            },
            determineDataLimits: function() {
                var me = this;
                var chart = me.chart;
                me.min = null;
                me.max = null;


                helpers.each(chart.data.datasets, function(dataset, datasetIndex) {
                    if (chart.isDatasetVisible(datasetIndex)) {
                        var meta = chart.getDatasetMeta(datasetIndex);

                        helpers.each(dataset.data, function(rawValue, index) {
                            var value = +me.getRightValue(rawValue);
                            if (isNaN(value) || meta.data[index].hidden) {
                                return;
                            }

                            if (me.min === null) {
                                me.min = value;
                            } else if (value < me.min) {
                                me.min = value;
                            }

                            if (me.max === null) {
                                me.max = value;
                            } else if (value > me.max) {
                                me.max = value;
                            }
                        });
                    }
                });

                // Common base implementation to handle ticks.min, ticks.max, ticks.beginAtZero
                me.handleTickRangeOptions();
            },
            getTickLimit: function() {
                var tickOpts = this.options.ticks;
                var tickFontSize = helpers.getValueOrDefault(tickOpts.fontSize, globalDefaults.defaultFontSize);
                return Math.min(tickOpts.maxTicksLimit ? tickOpts.maxTicksLimit : 11, Math.ceil(this.drawingArea / (1.5 * tickFontSize)));
            },
            convertTicksToLabels: function() {
                var me = this;
                Chart.LinearScaleBase.prototype.convertTicksToLabels.call(me);

                // Point labels
                me.pointLabels = me.chart.data.labels.map(me.options.pointLabels.callback, me);
            },
            getLabelForIndex: function(index, datasetIndex) {
                return +this.getRightValue(this.chart.data.datasets[datasetIndex].data[index]);
            },
            fit: function() {
                /*
                 * Right, this is really confusing and there is a lot of maths going on here
                 * The gist of the problem is here: https://gist.github.com/nnnick/696cc9c55f4b0beb8fe9
                 *
                 * Reaction: https://dl.dropboxusercontent.com/u/34601363/toomuchscience.gif
                 *
                 * Solution:
                 *
                 * We assume the radius of the polygon is half the size of the canvas at first
                 * at each index we check if the text overlaps.
                 *
                 * Where it does, we store that angle and that index.
                 *
                 * After finding the largest index and angle we calculate how much we need to remove
                 * from the shape radius to move the point inwards by that x.
                 *
                 * We average the left and right distances to get the maximum shape radius that can fit in the box
                 * along with labels.
                 *
                 * Once we have that, we can find the centre point for the chart, by taking the x text protrusion
                 * on each side, removing that from the size, halving it and adding the left x protrusion width.
                 *
                 * This will mean we have a shape fitted to the canvas, as large as it can be with the labels
                 * and position it in the most space efficient manner
                 *
                 * https://dl.dropboxusercontent.com/u/34601363/yeahscience.gif
                 */

                var pointLabels = this.options.pointLabels;
                var pointLabelFontSize = helpers.getValueOrDefault(pointLabels.fontSize, globalDefaults.defaultFontSize);
                var pointLabeFontStyle = helpers.getValueOrDefault(pointLabels.fontStyle, globalDefaults.defaultFontStyle);
                var pointLabeFontFamily = helpers.getValueOrDefault(pointLabels.fontFamily, globalDefaults.defaultFontFamily);
                var pointLabeFont = helpers.fontString(pointLabelFontSize, pointLabeFontStyle, pointLabeFontFamily);

                // Get maximum radius of the polygon. Either half the height (minus the text width) or half the width.
                // Use this to calculate the offset + change. - Make sure L/R protrusion is at least 0 to stop issues with centre points
                var largestPossibleRadius = helpers.min([(this.height / 2 - pointLabelFontSize - 5), this.width / 2]),
                    pointPosition,
                    i,
                    textWidth,
                    halfTextWidth,
                    furthestRight = this.width,
                    furthestRightIndex,
                    furthestRightAngle,
                    furthestLeft = 0,
                    furthestLeftIndex,
                    furthestLeftAngle,
                    xProtrusionLeft,
                    xProtrusionRight,
                    radiusReductionRight,
                    radiusReductionLeft;
                this.ctx.font = pointLabeFont;

                for (i = 0; i < this.getValueCount(); i++) {
                    // 5px to space the text slightly out - similar to what we do in the draw function.
                    pointPosition = this.getPointPosition(i, largestPossibleRadius);
                    textWidth = this.ctx.measureText(this.pointLabels[i] ? this.pointLabels[i] : '').width + 5;

                    // Add quarter circle to make degree 0 mean top of circle
                    var angleRadians = this.getIndexAngle(i) + (Math.PI / 2);
                    var angle = (angleRadians * 360 / (2 * Math.PI)) % 360;

                    if (angle === 0 || angle === 180) {
                        // At angle 0 and 180, we're at exactly the top/bottom
                        // of the radar chart, so text will be aligned centrally, so we'll half it and compare
                        // w/left and right text sizes
                        halfTextWidth = textWidth / 2;
                        if (pointPosition.x + halfTextWidth > furthestRight) {
                            furthestRight = pointPosition.x + halfTextWidth;
                            furthestRightIndex = i;
                        }
                        if (pointPosition.x - halfTextWidth < furthestLeft) {
                            furthestLeft = pointPosition.x - halfTextWidth;
                            furthestLeftIndex = i;
                        }
                    } else if (angle < 180) {
                        // Less than half the values means we'll left align the text
                        if (pointPosition.x + textWidth > furthestRight) {
                            furthestRight = pointPosition.x + textWidth;
                            furthestRightIndex = i;
                        }
                        // More than half the values means we'll right align the text
                    } else if (pointPosition.x - textWidth < furthestLeft) {
                        furthestLeft = pointPosition.x - textWidth;
                        furthestLeftIndex = i;
                    }
                }

                xProtrusionLeft = furthestLeft;
                xProtrusionRight = Math.ceil(furthestRight - this.width);

                furthestRightAngle = this.getIndexAngle(furthestRightIndex);
                furthestLeftAngle = this.getIndexAngle(furthestLeftIndex);

                radiusReductionRight = xProtrusionRight / Math.sin(furthestRightAngle + Math.PI / 2);
                radiusReductionLeft = xProtrusionLeft / Math.sin(furthestLeftAngle + Math.PI / 2);

                // Ensure we actually need to reduce the size of the chart
                radiusReductionRight = (helpers.isNumber(radiusReductionRight)) ? radiusReductionRight : 0;
                radiusReductionLeft = (helpers.isNumber(radiusReductionLeft)) ? radiusReductionLeft : 0;

                this.drawingArea = Math.round(largestPossibleRadius - (radiusReductionLeft + radiusReductionRight) / 2);
                this.setCenterPoint(radiusReductionLeft, radiusReductionRight);
            },
            setCenterPoint: function(leftMovement, rightMovement) {
                var me = this;
                var maxRight = me.width - rightMovement - me.drawingArea,
                    maxLeft = leftMovement + me.drawingArea;

                me.xCenter = Math.round(((maxLeft + maxRight) / 2) + me.left);
                // Always vertically in the centre as the text height doesn't change
                me.yCenter = Math.round((me.height / 2) + me.top);
            },

            getIndexAngle: function(index) {
                var angleMultiplier = (Math.PI * 2) / this.getValueCount();
                var startAngle = this.chart.options && this.chart.options.startAngle ?
                    this.chart.options.startAngle :
                    0;

                var startAngleRadians = startAngle * Math.PI * 2 / 360;

                // Start from the top instead of right, so remove a quarter of the circle
                return index * angleMultiplier - (Math.PI / 2) + startAngleRadians;
            },
            getDistanceFromCenterForValue: function(value) {
                var me = this;

                if (value === null) {
                    return 0; // null always in center
                }

                // Take into account half font size + the yPadding of the top value
                var scalingFactor = me.drawingArea / (me.max - me.min);
                if (me.options.reverse) {
                    return (me.max - value) * scalingFactor;
                }
                return (value - me.min) * scalingFactor;
            },
            getPointPosition: function(index, distanceFromCenter) {
                var me = this;
                var thisAngle = me.getIndexAngle(index);
                return {
                    x: Math.round(Math.cos(thisAngle) * distanceFromCenter) + me.xCenter,
                    y: Math.round(Math.sin(thisAngle) * distanceFromCenter) + me.yCenter
                };
            },
            getPointPositionForValue: function(index, value) {
                return this.getPointPosition(index, this.getDistanceFromCenterForValue(value));
            },

            getBasePosition: function() {
                var me = this;
                var min = me.min;
                var max = me.max;

                return me.getPointPositionForValue(0,
                    me.beginAtZero? 0:
                        min < 0 && max < 0? max :
                            min > 0 && max > 0? min :
                                0);
            },

            draw: function() {
                var me = this;
                var opts = me.options;
                var gridLineOpts = opts.gridLines;
                var tickOpts = opts.ticks;
                var angleLineOpts = opts.angleLines;
                var pointLabelOpts = opts.pointLabels;
                var getValueOrDefault = helpers.getValueOrDefault;

                if (opts.display) {
                    var ctx = me.ctx;

                    // Tick Font
                    var tickFontSize = getValueOrDefault(tickOpts.fontSize, globalDefaults.defaultFontSize);
                    var tickFontStyle = getValueOrDefault(tickOpts.fontStyle, globalDefaults.defaultFontStyle);
                    var tickFontFamily = getValueOrDefault(tickOpts.fontFamily, globalDefaults.defaultFontFamily);
                    var tickLabelFont = helpers.fontString(tickFontSize, tickFontStyle, tickFontFamily);

                    helpers.each(me.ticks, function(label, index) {
                        // Don't draw a centre value (if it is minimum)
                        if (index > 0 || opts.reverse) {
                            var yCenterOffset = me.getDistanceFromCenterForValue(me.ticksAsNumbers[index]);
                            var yHeight = me.yCenter - yCenterOffset;

                            // Draw circular lines around the scale
                            if (gridLineOpts.display && index !== 0) {
                                ctx.strokeStyle = helpers.getValueAtIndexOrDefault(gridLineOpts.color, index - 1);
                                ctx.lineWidth = helpers.getValueAtIndexOrDefault(gridLineOpts.lineWidth, index - 1);

                                if (opts.lineArc) {
                                    // Draw circular arcs between the points
                                    ctx.beginPath();
                                    ctx.arc(me.xCenter, me.yCenter, yCenterOffset, 0, Math.PI * 2);
                                    ctx.closePath();
                                    ctx.stroke();
                                } else {
                                    // Draw straight lines connecting each index
                                    ctx.beginPath();
                                    for (var i = 0; i < me.getValueCount(); i++) {
                                        var pointPosition = me.getPointPosition(i, yCenterOffset);
                                        if (i === 0) {
                                            ctx.moveTo(pointPosition.x, pointPosition.y);
                                        } else {
                                            ctx.lineTo(pointPosition.x, pointPosition.y);
                                        }
                                    }
                                    ctx.closePath();
                                    ctx.stroke();
                                }
                            }

                            if (tickOpts.display) {
                                var tickFontColor = getValueOrDefault(tickOpts.fontColor, globalDefaults.defaultFontColor);
                                ctx.font = tickLabelFont;

                                if (tickOpts.showLabelBackdrop) {
                                    var labelWidth = ctx.measureText(label).width;
                                    ctx.fillStyle = tickOpts.backdropColor;
                                    ctx.fillRect(
                                        me.xCenter - labelWidth / 2 - tickOpts.backdropPaddingX,
                                        yHeight - tickFontSize / 2 - tickOpts.backdropPaddingY,
                                        labelWidth + tickOpts.backdropPaddingX * 2,
                                        tickFontSize + tickOpts.backdropPaddingY * 2
                                    );
                                }

                                ctx.textAlign = 'center';
                                ctx.textBaseline = 'middle';
                                ctx.fillStyle = tickFontColor;
                                ctx.fillText(label, me.xCenter, yHeight);
                            }
                        }
                    });

                    if (!opts.lineArc) {
                        ctx.lineWidth = angleLineOpts.lineWidth;
                        ctx.strokeStyle = angleLineOpts.color;

                        var outerDistance = me.getDistanceFromCenterForValue(opts.reverse ? me.min : me.max);

                        // Point Label Font
                        var pointLabelFontSize = getValueOrDefault(pointLabelOpts.fontSize, globalDefaults.defaultFontSize);
                        var pointLabeFontStyle = getValueOrDefault(pointLabelOpts.fontStyle, globalDefaults.defaultFontStyle);
                        var pointLabeFontFamily = getValueOrDefault(pointLabelOpts.fontFamily, globalDefaults.defaultFontFamily);
                        var pointLabeFont = helpers.fontString(pointLabelFontSize, pointLabeFontStyle, pointLabeFontFamily);

                        for (var i = me.getValueCount() - 1; i >= 0; i--) {
                            if (angleLineOpts.display) {
                                var outerPosition = me.getPointPosition(i, outerDistance);
                                ctx.beginPath();
                                ctx.moveTo(me.xCenter, me.yCenter);
                                ctx.lineTo(outerPosition.x, outerPosition.y);
                                ctx.stroke();
                                ctx.closePath();
                            }
                            // Extra 3px out for some label spacing
                            var pointLabelPosition = me.getPointPosition(i, outerDistance + 5);

                            // Keep this in loop since we may support array properties here
                            var pointLabelFontColor = getValueOrDefault(pointLabelOpts.fontColor, globalDefaults.defaultFontColor);
                            ctx.font = pointLabeFont;
                            ctx.fillStyle = pointLabelFontColor;

                            var pointLabels = me.pointLabels;

                            // Add quarter circle to make degree 0 mean top of circle
                            var angleRadians = this.getIndexAngle(i) + (Math.PI / 2);
                            var angle = (angleRadians * 360 / (2 * Math.PI)) % 360;

                            if (angle === 0 || angle === 180) {
                                ctx.textAlign = 'center';
                            } else if (angle < 180) {
                                ctx.textAlign = 'left';
                            } else {
                                ctx.textAlign = 'right';
                            }

                            // Set the correct text baseline based on outer positioning
                            if (angle === 90 || angle === 270) {
                                ctx.textBaseline = 'middle';
                            } else if (angle > 270 || angle < 90) {
                                ctx.textBaseline = 'bottom';
                            } else {
                                ctx.textBaseline = 'top';
                            }

                            ctx.fillText(pointLabels[i] ? pointLabels[i] : '', pointLabelPosition.x, pointLabelPosition.y);
                        }
                    }
                }
            }
        });
        Chart.scaleService.registerScaleType('radialLinear', LinearRadialScale, defaultConfig);

    };

},{}],44:[function(require,module,exports){
    /* global window: false */
    'use strict';

    var moment = require(6);
    moment = typeof(moment) === 'function' ? moment : window.moment;

    module.exports = function(Chart) {

        var helpers = Chart.helpers;
        var time = {
            units: [{
                name: 'millisecond',
                steps: [1, 2, 5, 10, 20, 50, 100, 250, 500]
            }, {
                name: 'second',
                steps: [1, 2, 5, 10, 30]
            }, {
                name: 'minute',
                steps: [1, 2, 5, 10, 30]
            }, {
                name: 'hour',
                steps: [1, 2, 3, 6, 12]
            }, {
                name: 'day',
                steps: [1, 2, 5]
            }, {
                name: 'week',
                maxStep: 4
            }, {
                name: 'month',
                maxStep: 3
            }, {
                name: 'quarter',
                maxStep: 4
            }, {
                name: 'year',
                maxStep: false
            }]
        };

        var defaultConfig = {
            position: 'bottom',

            time: {
                parser: false, // false == a pattern string from http://momentjs.com/docs/#/parsing/string-format/ or a custom callback that converts its argument to a moment
                format: false, // DEPRECATED false == date objects, moment object, callback or a pattern string from http://momentjs.com/docs/#/parsing/string-format/
                unit: false, // false == automatic or override with week, month, year, etc.
                round: false, // none, or override with week, month, year, etc.
                displayFormat: false, // DEPRECATED
                isoWeekday: false, // override week start day - see http://momentjs.com/docs/#/get-set/iso-weekday/
                minUnit: 'millisecond',

                // defaults to unit's corresponding unitFormat below or override using pattern string from http://momentjs.com/docs/#/displaying/format/
                displayFormats: {
                    millisecond: 'h:mm:ss.SSS a', // 11:20:01.123 AM,
                    second: 'h:mm:ss a', // 11:20:01 AM
                    minute: 'h:mm:ss a', // 11:20:01 AM
                    hour: 'MMM D, hA', // Sept 4, 5PM
                    day: 'll', // Sep 4 2015
                    week: 'll', // Week 46, or maybe "[W]WW - YYYY" ?
                    month: 'MMM YYYY', // Sept 2015
                    quarter: '[Q]Q - YYYY', // Q3
                    year: 'YYYY' // 2015
                }
            },
            ticks: {
                autoSkip: false
            }
        };

        var TimeScale = Chart.Scale.extend({
            initialize: function() {
                if (!moment) {
                    throw new Error('Chart.js - Moment.js could not be found! You must include it before Chart.js to use the time scale. Download at https://momentjs.com');
                }

                Chart.Scale.prototype.initialize.call(this);
            },
            getLabelMoment: function(datasetIndex, index) {
                if (datasetIndex === null || index === null) {
                    return null;
                }

                if (typeof this.labelMoments[datasetIndex] !== 'undefined') {
                    return this.labelMoments[datasetIndex][index];
                }

                return null;
            },
            getLabelDiff: function(datasetIndex, index) {
                var me = this;
                if (datasetIndex === null || index === null) {
                    return null;
                }

                if (me.labelDiffs === undefined) {
                    me.buildLabelDiffs();
                }

                if (typeof me.labelDiffs[datasetIndex] !== 'undefined') {
                    return me.labelDiffs[datasetIndex][index];
                }

                return null;
            },
            getMomentStartOf: function(tick) {
                var me = this;
                if (me.options.time.unit === 'week' && me.options.time.isoWeekday !== false) {
                    return tick.clone().startOf('isoWeek').isoWeekday(me.options.time.isoWeekday);
                }
                return tick.clone().startOf(me.tickUnit);
            },
            determineDataLimits: function() {
                var me = this;
                me.labelMoments = [];

                // Only parse these once. If the dataset does not have data as x,y pairs, we will use
                // these
                var scaleLabelMoments = [];
                if (me.chart.data.labels && me.chart.data.labels.length > 0) {
                    helpers.each(me.chart.data.labels, function(label) {
                        var labelMoment = me.parseTime(label);

                        if (labelMoment.isValid()) {
                            if (me.options.time.round) {
                                labelMoment.startOf(me.options.time.round);
                            }
                            scaleLabelMoments.push(labelMoment);
                        }
                    }, me);

                    me.firstTick = moment.min.call(me, scaleLabelMoments);
                    me.lastTick = moment.max.call(me, scaleLabelMoments);
                } else {
                    me.firstTick = null;
                    me.lastTick = null;
                }

                helpers.each(me.chart.data.datasets, function(dataset, datasetIndex) {
                    var momentsForDataset = [];
                    var datasetVisible = me.chart.isDatasetVisible(datasetIndex);

                    if (typeof dataset.data[0] === 'object' && dataset.data[0] !== null) {
                        helpers.each(dataset.data, function(value) {
                            var labelMoment = me.parseTime(me.getRightValue(value));

                            if (labelMoment.isValid()) {
                                if (me.options.time.round) {
                                    labelMoment.startOf(me.options.time.round);
                                }
                                momentsForDataset.push(labelMoment);

                                if (datasetVisible) {
                                    // May have gone outside the scale ranges, make sure we keep the first and last ticks updated
                                    me.firstTick = me.firstTick !== null ? moment.min(me.firstTick, labelMoment) : labelMoment;
                                    me.lastTick = me.lastTick !== null ? moment.max(me.lastTick, labelMoment) : labelMoment;
                                }
                            }
                        }, me);
                    } else {
                        // We have no labels. Use the ones from the scale
                        momentsForDataset = scaleLabelMoments;
                    }

                    me.labelMoments.push(momentsForDataset);
                }, me);

                // Set these after we've done all the data
                if (me.options.time.min) {
                    me.firstTick = me.parseTime(me.options.time.min);
                }

                if (me.options.time.max) {
                    me.lastTick = me.parseTime(me.options.time.max);
                }

                // We will modify these, so clone for later
                me.firstTick = (me.firstTick || moment()).clone();
                me.lastTick = (me.lastTick || moment()).clone();
            },
            buildLabelDiffs: function() {
                var me = this;
                me.labelDiffs = [];
                var scaleLabelDiffs = [];
                // Parse common labels once
                if (me.chart.data.labels && me.chart.data.labels.length > 0) {
                    helpers.each(me.chart.data.labels, function(label) {
                        var labelMoment = me.parseTime(label);

                        if (labelMoment.isValid()) {
                            if (me.options.time.round) {
                                labelMoment.startOf(me.options.time.round);
                            }
                            scaleLabelDiffs.push(labelMoment.diff(me.firstTick, me.tickUnit, true));
                        }
                    }, me);
                }

                helpers.each(me.chart.data.datasets, function(dataset) {
                    var diffsForDataset = [];

                    if (typeof dataset.data[0] === 'object' && dataset.data[0] !== null) {
                        helpers.each(dataset.data, function(value) {
                            var labelMoment = me.parseTime(me.getRightValue(value));

                            if (labelMoment.isValid()) {
                                if (me.options.time.round) {
                                    labelMoment.startOf(me.options.time.round);
                                }
                                diffsForDataset.push(labelMoment.diff(me.firstTick, me.tickUnit, true));
                            }
                        }, me);
                    } else {
                        // We have no labels. Use common ones
                        diffsForDataset = scaleLabelDiffs;
                    }

                    me.labelDiffs.push(diffsForDataset);
                }, me);
            },
            buildTicks: function() {
                var me = this;

                me.ctx.save();
                var tickFontSize = helpers.getValueOrDefault(me.options.ticks.fontSize, Chart.defaults.global.defaultFontSize);
                var tickFontStyle = helpers.getValueOrDefault(me.options.ticks.fontStyle, Chart.defaults.global.defaultFontStyle);
                var tickFontFamily = helpers.getValueOrDefault(me.options.ticks.fontFamily, Chart.defaults.global.defaultFontFamily);
                var tickLabelFont = helpers.fontString(tickFontSize, tickFontStyle, tickFontFamily);
                me.ctx.font = tickLabelFont;

                me.ticks = [];
                me.unitScale = 1; // How much we scale the unit by, ie 2 means 2x unit per step
                me.scaleSizeInUnits = 0; // How large the scale is in the base unit (seconds, minutes, etc)

                // Set unit override if applicable
                if (me.options.time.unit) {
                    me.tickUnit = me.options.time.unit || 'day';
                    me.displayFormat = me.options.time.displayFormats[me.tickUnit];
                    me.scaleSizeInUnits = me.lastTick.diff(me.firstTick, me.tickUnit, true);
                    me.unitScale = helpers.getValueOrDefault(me.options.time.unitStepSize, 1);
                } else {
                    // Determine the smallest needed unit of the time
                    var innerWidth = me.isHorizontal() ? me.width - (me.paddingLeft + me.paddingRight) : me.height - (me.paddingTop + me.paddingBottom);

                    // Crude approximation of what the label length might be
                    var tempFirstLabel = me.tickFormatFunction(me.firstTick, 0, []);
                    var tickLabelWidth = me.ctx.measureText(tempFirstLabel).width;
                    var cosRotation = Math.cos(helpers.toRadians(me.options.ticks.maxRotation));
                    var sinRotation = Math.sin(helpers.toRadians(me.options.ticks.maxRotation));
                    tickLabelWidth = (tickLabelWidth * cosRotation) + (tickFontSize * sinRotation);
                    var labelCapacity = innerWidth / (tickLabelWidth);

                    // Start as small as possible
                    me.tickUnit = me.options.time.minUnit;
                    me.scaleSizeInUnits = me.lastTick.diff(me.firstTick, me.tickUnit, true);
                    me.displayFormat = me.options.time.displayFormats[me.tickUnit];

                    var unitDefinitionIndex = 0;
                    var unitDefinition = time.units[unitDefinitionIndex];

                    // While we aren't ideal and we don't have units left
                    while (unitDefinitionIndex < time.units.length) {
                        // Can we scale this unit. If `false` we can scale infinitely
                        me.unitScale = 1;

                        if (helpers.isArray(unitDefinition.steps) && Math.ceil(me.scaleSizeInUnits / labelCapacity) < helpers.max(unitDefinition.steps)) {
                            // Use one of the prefedined steps
                            for (var idx = 0; idx < unitDefinition.steps.length; ++idx) {
                                if (unitDefinition.steps[idx] >= Math.ceil(me.scaleSizeInUnits / labelCapacity)) {
                                    me.unitScale = helpers.getValueOrDefault(me.options.time.unitStepSize, unitDefinition.steps[idx]);
                                    break;
                                }
                            }

                            break;
                        } else if ((unitDefinition.maxStep === false) || (Math.ceil(me.scaleSizeInUnits / labelCapacity) < unitDefinition.maxStep)) {
                            // We have a max step. Scale this unit
                            me.unitScale = helpers.getValueOrDefault(me.options.time.unitStepSize, Math.ceil(me.scaleSizeInUnits / labelCapacity));
                            break;
                        } else {
                            // Move to the next unit up
                            ++unitDefinitionIndex;
                            unitDefinition = time.units[unitDefinitionIndex];

                            me.tickUnit = unitDefinition.name;
                            var leadingUnitBuffer = me.firstTick.diff(me.getMomentStartOf(me.firstTick), me.tickUnit, true);
                            var trailingUnitBuffer = me.getMomentStartOf(me.lastTick.clone().add(1, me.tickUnit)).diff(me.lastTick, me.tickUnit, true);
                            me.scaleSizeInUnits = me.lastTick.diff(me.firstTick, me.tickUnit, true) + leadingUnitBuffer + trailingUnitBuffer;
                            me.displayFormat = me.options.time.displayFormats[unitDefinition.name];
                        }
                    }
                }

                var roundedStart;

                // Only round the first tick if we have no hard minimum
                if (!me.options.time.min) {
                    me.firstTick = me.getMomentStartOf(me.firstTick);
                    roundedStart = me.firstTick;
                } else {
                    roundedStart = me.getMomentStartOf(me.firstTick);
                }

                // Only round the last tick if we have no hard maximum
                if (!me.options.time.max) {
                    var roundedEnd = me.getMomentStartOf(me.lastTick);
                    var delta = roundedEnd.diff(me.lastTick, me.tickUnit, true);
                    if (delta < 0) {
                        // Do not use end of because we need me to be in the next time unit
                        me.lastTick = me.getMomentStartOf(me.lastTick.add(1, me.tickUnit));
                    } else if (delta >= 0) {
                        me.lastTick = roundedEnd;
                    }

                    me.scaleSizeInUnits = me.lastTick.diff(me.firstTick, me.tickUnit, true);
                }

                // Tick displayFormat override
                if (me.options.time.displayFormat) {
                    me.displayFormat = me.options.time.displayFormat;
                }

                // first tick. will have been rounded correctly if options.time.min is not specified
                me.ticks.push(me.firstTick.clone());

                // For every unit in between the first and last moment, create a moment and add it to the ticks tick
                for (var i = 1; i <= me.scaleSizeInUnits; ++i) {
                    var newTick = roundedStart.clone().add(i, me.tickUnit);

                    // Are we greater than the max time
                    if (me.options.time.max && newTick.diff(me.lastTick, me.tickUnit, true) >= 0) {
                        break;
                    }

                    if (i % me.unitScale === 0) {
                        me.ticks.push(newTick);
                    }
                }

                // Always show the right tick
                var diff = me.ticks[me.ticks.length - 1].diff(me.lastTick, me.tickUnit);
                if (diff !== 0 || me.scaleSizeInUnits === 0) {
                    // this is a weird case. If the <max> option is the same as the end option, we can't just diff the times because the tick was created from the roundedStart
                    // but the last tick was not rounded.
                    if (me.options.time.max) {
                        me.ticks.push(me.lastTick.clone());
                        me.scaleSizeInUnits = me.lastTick.diff(me.ticks[0], me.tickUnit, true);
                    } else {
                        me.ticks.push(me.lastTick.clone());
                        me.scaleSizeInUnits = me.lastTick.diff(me.firstTick, me.tickUnit, true);
                    }
                }

                me.ctx.restore();

                // Invalidate label diffs cache
                me.labelDiffs = undefined;
            },
            // Get tooltip label
            getLabelForIndex: function(index, datasetIndex) {
                var me = this;
                var label = me.chart.data.labels && index < me.chart.data.labels.length ? me.chart.data.labels[index] : '';

                if (typeof me.chart.data.datasets[datasetIndex].data[0] === 'object') {
                    label = me.getRightValue(me.chart.data.datasets[datasetIndex].data[index]);
                }

                // Format nicely
                if (me.options.time.tooltipFormat) {
                    label = me.parseTime(label).format(me.options.time.tooltipFormat);
                }

                return label;
            },
            // Function to format an individual tick mark
            tickFormatFunction: function(tick, index, ticks) {
                var formattedTick = tick.format(this.displayFormat);
                var tickOpts = this.options.ticks;
                var callback = helpers.getValueOrDefault(tickOpts.callback, tickOpts.userCallback);

                if (callback) {
                    return callback(formattedTick, index, ticks);
                }
                return formattedTick;
            },
            convertTicksToLabels: function() {
                var me = this;
                me.tickMoments = me.ticks;
                me.ticks = me.ticks.map(me.tickFormatFunction, me);
            },
            getPixelForValue: function(value, index, datasetIndex) {
                var me = this;
                var offset = null;
                if (index !== undefined && datasetIndex !== undefined) {
                    offset = me.getLabelDiff(datasetIndex, index);
                }

                if (offset === null) {
                    if (!value || !value.isValid) {
                        // not already a moment object
                        value = me.parseTime(me.getRightValue(value));
                    }
                    if (value && value.isValid && value.isValid()) {
                        offset = value.diff(me.firstTick, me.tickUnit, true);
                    }
                }

                if (offset !== null) {
                    var decimal = offset !== 0 ? offset / me.scaleSizeInUnits : offset;

                    if (me.isHorizontal()) {
                        var innerWidth = me.width - (me.paddingLeft + me.paddingRight);
                        var valueOffset = (innerWidth * decimal) + me.paddingLeft;

                        return me.left + Math.round(valueOffset);
                    }
                    var innerHeight = me.height - (me.paddingTop + me.paddingBottom);
                    var heightOffset = (innerHeight * decimal) + me.paddingTop;

                    return me.top + Math.round(heightOffset);
                }
            },
            getPixelForTick: function(index) {
                return this.getPixelForValue(this.tickMoments[index], null, null);
            },
            getValueForPixel: function(pixel) {
                var me = this;
                var innerDimension = me.isHorizontal() ? me.width - (me.paddingLeft + me.paddingRight) : me.height - (me.paddingTop + me.paddingBottom);
                var offset = (pixel - (me.isHorizontal() ? me.left + me.paddingLeft : me.top + me.paddingTop)) / innerDimension;
                offset *= me.scaleSizeInUnits;
                return me.firstTick.clone().add(moment.duration(offset, me.tickUnit).asSeconds(), 'seconds');
            },
            parseTime: function(label) {
                var me = this;
                if (typeof me.options.time.parser === 'string') {
                    return moment(label, me.options.time.parser);
                }
                if (typeof me.options.time.parser === 'function') {
                    return me.options.time.parser(label);
                }
                // Date objects
                if (typeof label.getMonth === 'function' || typeof label === 'number') {
                    return moment(label);
                }
                // Moment support
                if (label.isValid && label.isValid()) {
                    return label;
                }
                // Custom parsing (return an instance of moment)
                if (typeof me.options.time.format !== 'string' && me.options.time.format.call) {
                    console.warn('options.time.format is deprecated and replaced by options.time.parser. See http://nnnick.github.io/Chart.js/docs-v2/#scales-time-scale');
                    return me.options.time.format(label);
                }
                // Moment format parsing
                return moment(label, me.options.time.format);
            }
        });
        Chart.scaleService.registerScaleType('time', TimeScale, defaultConfig);

    };

},{"6":6}]},{},[7])(7)
});
var process = process || {env: {NODE_ENV: "development"}};
/**
 * @namespace
 */
var ALA = {};

/**
 * @class
 * @memberOf ALA
 */
ALA.ChartConstants = {
    highlightColor: '#FF0000',
    colors: [
        "#000000", "#FFFF00", "#1CE6FF", "#FF34FF", "#FF4A46", "#008941", "#006FA6", "#A30059",
        "#FFDBE5", "#7A4900", "#0000A6", "#63FFAC", "#B79762", "#004D43", "#8FB0FF", "#997D87",
        "#5A0007", "#809693", "#FEFFE6", "#1B4400", "#4FC601", "#3B5DFF", "#4A3B53", "#FF2F80",
        "#61615A", "#BA0900", "#6B7900", "#00C2A0", "#FFAA92", "#FF90C9", "#B903AA", "#D16100",
        "#DDEFFF", "#000035", "#7B4F4B", "#A1C299", "#300018", "#0AA6D8", "#013349", "#00846F",
        "#372101", "#FFB500", "#C2FFED", "#A079BF", "#CC0744", "#C0B9B2", "#C2FF99", "#001E09",
        "#00489C", "#6F0062", "#0CBD66", "#EEC3FF", "#456D75", "#B77B68", "#7A87A1", "#788D66",
        "#885578", "#FAD09F", "#FF8A9A", "#D157A0", "#BEC459", "#456648", "#0086ED", "#886F4C",

        "#34362D", "#B4A8BD", "#00A6AA", "#452C2C", "#636375", "#A3C8C9", "#FF913F", "#938A81",
        "#575329", "#00FECF", "#B05B6F", "#8CD0FF", "#3B9700", "#04F757", "#C8A1A1", "#1E6E00",
        "#7900D7", "#A77500", "#6367A9", "#A05837", "#6B002C", "#772600", "#D790FF", "#9B9700",
        "#549E79", "#FFF69F", "#201625", "#72418F", "#BC23FF", "#99ADC0", "#3A2465", "#922329",
        "#5B4534", "#FDE8DC", "#404E55", "#0089A3", "#CB7E98", "#A4E804", "#324E72", "#6A3A4C",
        "#83AB58", "#001C1E", "#D1F7CE", "#004B28", "#C8D0F6", "#A3A489", "#806C66", "#222800",
        "#BF5650", "#E83000", "#66796D", "#DA007C", "#FF1A59", "#8ADBB4", "#1E0200", "#5B4E51",
        "#C895C5", "#320033", "#FF6832", "#66E1D3", "#CFCDAC", "#D0AC94", "#7ED379", "#012C58",

        "#7A7BFF", "#D68E01", "#353339", "#78AFA1", "#FEB2C6", "#75797C", "#837393", "#943A4D",
        "#B5F4FF", "#D2DCD5", "#9556BD", "#6A714A", "#001325", "#02525F", "#0AA3F7", "#E98176",
        "#DBD5DD", "#5EBCD1", "#3D4F44", "#7E6405", "#02684E", "#962B75", "#8D8546", "#9695C5",
        "#E773CE", "#D86A78", "#3E89BE", "#CA834E", "#518A87", "#5B113C", "#55813B", "#E704C4",
        "#00005F", "#A97399", "#4B8160", "#59738A", "#FF5DA7", "#F7C9BF", "#643127", "#513A01",
        "#6B94AA", "#51A058", "#A45B02", "#1D1702", "#E20027", "#E7AB63", "#4C6001", "#9C6966",
        "#64547B", "#97979E", "#006A66", "#391406", "#F4D749", "#0045D2", "#006C31", "#DDB6D0",
        "#7C6571", "#9FB2A4", "#00D891", "#15A08A", "#BC65E9", "#FFFFFE", "#C6DC99", "#203B3C",

        "#671190", "#6B3A64", "#F5E1FF", "#FFA0F2", "#CCAA35", "#374527", "#8BB400", "#797868",
        "#C6005A", "#3B000A", "#C86240", "#29607C", "#402334", "#7D5A44", "#CCB87C", "#B88183",
        "#AA5199", "#B5D6C3", "#A38469", "#9F94F0", "#A74571", "#B894A6", "#71BB8C", "#00B433",
        "#789EC9", "#6D80BA", "#953F00", "#5EFF03", "#E4FFFC", "#1BE177", "#BCB1E5", "#76912F",
        "#003109", "#0060CD", "#D20096", "#895563", "#29201D", "#5B3213", "#A76F42", "#89412E",
        "#1A3A2A", "#494B5A", "#A88C85", "#F4ABAA", "#A3F3AB", "#00C6C8", "#EA8B66", "#958A9F",
        "#BDC9D2", "#9FA064", "#BE4700", "#658188", "#83A485", "#453C23", "#47675D", "#3A3F00",
        "#061203", "#DFFB71", "#868E7E", "#98D058", "#6C8F7D", "#D7BFC2", "#3C3E6E", "#D83D66",

        "#2F5D9B", "#6C5E46", "#D25B88", "#5B656C", "#00B57F", "#545C46", "#866097", "#365D25",
        "#252F99", "#00CCFF", "#674E60", "#FC009C", "#92896B"
    ],
    legendTemplate: "<ul style=\"list-style-type:none;\" class=\"ala-<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<segments.length; i++){%><li><span style=\"background-color:<%=segments[i].fillColor%>\"></span><%if(segments[i].label){%><%=segments[i].label%><%}%></li><%}%></ul>"
};

/**
 * Entry point for creating charts based on biocache webservices.
 *
 * <p/>
 * <b>chartOptions</b>
 * <ul>
 * <li><code>biocacheServiceUrl</code> URL for biocache web services endpoint</li>
 * <li><code>biocacheWebappUrl</code> URL for biocache front end endpoint</li>
 * <li><code>query</code> URL for biocache front end endpoint</li>
 * <li><code>queryContext</code> URL for biocache front end endpoint</li>
 * <li><code>facetQueries</code> URL for biocache front end endpoint</li>
 * <li><code>charts</code> The charts configuration which includes a list of charts to render</li>
 *</ul>
 *
 * @param chartsDivId the ID of the div to populate with charts.
 * @param chartOptions
 * @constructor
 */
ALA.BiocacheCharts = function (chartsDivId, chartOptions) {

    var _facets = [];

    var getColor = function (keySeries, chartConfig, data) {
        var segmentColor = ALA.ChartConstants.colors[(keySeries + 1) % (ALA.ChartConstants.colors.length - 1)];

        //data item colour for pie/doughnut charts
        if (chartConfig.chartType == 'pie' || chartConfig.chartType == 'doughnut') {
            segmentColor = [];
            $.each(data, function (key, result) {
                if (result.label == null) result.label = "";
                if (!(chartConfig.hideEmptyValues && result.label == "")/* && result["count"] > 0*/) {
                    segmentColor.push(ALA.ChartConstants.colors[(key + 1) % (ALA.ChartConstants.colors.length - 1)]);
                }
            })
        }

        return segmentColor;
    };

    /**
     * create datastructure for a chart
     *
     * includes non-datastructure value maxValue in the returned value
     * includes non-datastructure mapping labelToFq in the returned value
     *
     * @param data
     * @param chartConfig
     * @param facet
     * @returns {{labels: Array, datasets: Array, maxValue: undefined, labelToFq: Map}}
     */
    var createDatastructure = function(data, chartConfig, facet) {
        //workaround for bug where valueFacet is undefined and valueType != count
        var type = (chartConfig.valueType && chartConfig.valueFacet) ? chartConfig.valueType : 'count';

        var datastructure = {
            labels: [],
            datasets: [],
            maxValue: undefined,
            labelToFq: {}
        };

        $.each(data, function (keySeries, resultSeries) {
            //series colour
            var segmentColor = getColor(keySeries, chartConfig, resultSeries.data);
            //use a different color for single series charts
            var overrideColor = data.length == 1 && chartConfig.chartType != 'pie' && chartConfig.chartType != 'doughnut';
            if (overrideColor) segmentColor = "#97BBCD";

            datastructure.datasets[keySeries] = {
                label: chartConfig.title,
                backgroundColor: transparentColors(segmentColor,50),
                data: []
            };

            //set additional colors for bar horizontal-bar
            if ($.inArray(chartConfig.chartType, ['bar', 'horizontal-bar', 'horizontalBar']) >= 0) {
                datastructure.datasets[keySeries].borderColor = transparentColors(segmentColor, 85);
                datastructure.datasets[keySeries].hoverBackgroundColor = transparentColors(segmentColor, 100);
                datastructure.datasets[keySeries].hoverBorderColor = transparentColors(segmentColor, 85);
                datastructure.datasets[keySeries].borderWidth = 1;
            }

            if (chartConfig.facet != resultSeries.label) datastructure.datasets[keySeries].label = resultSeries.label

            $.each(resultSeries.data, function (key, result) {

                if (result.label == null) result.label = "";
                if (!(chartConfig.hideEmptyValues && result.label == "")/* && result["count"] > 0*/) {
                    var prettifiedLabel = result.label.substring(0, 80);
                    if (result.label.trim() == "") {
                        prettifiedLabel = chartConfig.emptyValueMsg ? chartConfig.emptyValueMsg : 'Not available';
                    }

                    if (datastructure.labels.length < data[0].data.length) datastructure.labels.push(prettifiedLabel);
                    datastructure.datasets[keySeries].data.push(result[type]);

                    if (!datastructure.maxValue || datastructure.maxValue < result[type]) datastructure.maxValue = result[type];

                    datastructure.labelToFq[prettifiedLabel] = (result.fq) ? result.fq : facet + ":" + result.label;
                }
            });
        });

        return datastructure;
    };

    /**
     * updates values in an existing datastructure
     *
     * @param datastructure
     * @param data
     * @param chartConfig
     * @returns {*}
     */
    var updateDatastructure = function(datastructure, data, chartConfig) {
        //workaround for bug where valueFacet is undefined and valueType != count
        var type = (chartConfig.valueType && chartConfig.valueFacet) ? chartConfig.valueType : 'count';

        $.each(data, function (keySeries, resultSeries) {
            var labelFound = new Array(datastructure.labels.length);

            $.each(resultSeries.data, function (key, result) {

                if (result.label == null) result.label = "";
                if (!(chartConfig.hideEmptyValues && result.label == "")/* && result["count"] > 0*/) {
                    var prettifiedLabel = result.label.substring(0, 80);
                    if (result.label.trim() == "") {
                        prettifiedLabel = chartConfig.emptyValueMsg ? chartConfig.emptyValueMsg : 'Not available';
                    }

                    //find existing entry
                    for (var i = 0; i < datastructure.labels.length; i++) {
                        if (datastructure.labels[i] == prettifiedLabel) {
                            labelFound[i] = true;

                            datastructure.datasets[keySeries].data[i] = result[type];

                            i = datastructure.labels.length;
                        }
                    }
                }
            });
            for (var i = 0; i < datastructure.labels.length; i++) {
                if (!labelFound[i]) {
                    datastructure.datasets[keySeries].data[i] = 0;
                }
            }
        });

        return datastructure;
    };

    /**
     * Constructor for charts.
     *
     * @param facet
     * @param chartConfig
     * @param redraw
     * @constructor
     */
    var createChart = function (facet, chartConfig, redraw){

        var divId = (redraw) ? chartConfig.divId : createCanvasAndLegend(facet, chartConfig.title, chartConfig);

        if (chartConfig && !chartConfig.hideOnce) {
            if (chartConfig.sliderEnabled) {
                $('#' + divId).find('#controlsMapTab').show()
            } else {
                $('#' + divId).find('#controlsMapTab').hide()
            }

            wsCallAndRender(chartConfig, chartOptions.query, facet, chartOptions.facetQueries, chartOptions.queryContext, chartConfig.filter, divId, function (data) {

                if (!chartConfig.slider) {
                    getMinMax(chartConfig, chartConfig.sliderFacet, function(minMax) {
                        var options = {
                            parent: $('#' + divId),
                            range: minMax,
                            date: facetLookup(chartConfig.sliderFacet).dataType == 'tdate',
                            callback: function (value) {
                                if (facetLookup(chartConfig.sliderFacet).dataType == 'tdate') {
                                    var d1 = new Date(value[0]).toISOString();
                                    var d2 = new Date(value[1]).toISOString();
                                    chartConfig.sliderFq = '&fq=' + encodeURIComponent(chartConfig.sliderFacet + ':[' + d1 + ' TO ' + d2 + ']');
                                } else {
                                    chartConfig.sliderFq = '&fq=' + chartConfig.sliderFacet + ':[' + value[0] + '%20TO%20' + value[1] + ']';
                                }
                                createChart(facet, chartConfig, true)
                            }
                        };
                        chartConfig.slider = new RegionTimeControls(options);
                    });
                }

                var datastructure;

                //prepare Chart.js data structure
                if (!chartConfig.sliderFq) {

                    //compile results from WS call
                    datastructure = createDatastructure(data, chartConfig, facet)

                    chartConfig.maxValue = datastructure.maxValue;
                    chartConfig.datastructure = datastructure;
                } else {
                    datastructure = updateDatastructure(chartConfig.datastructure, data, chartConfig);
                }

                var labelToFq = datastructure.labelToFq;

                var $canvas = $('#' + divId).find('canvas');

                if (datastructure.datasets[0].data.length > 0) {
                    chartConfig.chart = drawChart(datastructure, labelToFq, $canvas, chartConfig, divId);
                } else {
                    $canvas.parent().append($("<label>"+chartOptions.chartNoDataLabel+"</label>").addClass('chart-no-data-label'));

                    $canvas.parent().find('.chart-canvas').detach();
                    $canvas.parent().find('.chart-legend').detach();
                }
            });
        } else {
            delete chartConfig.hideOnce;
        }
    };

    /**
     * Estimate no. of characters in labels for horizontal- / bar / line charts that will prevent initial characters running
     * off left / bottom of canvas area
     *
     * @param chart
     * @param chartType
     */
    var getChartLabelMaxLen = function(chart, chartType) {
        //allow up to 45% for legend; more than 50% means it gets trimmed
        if (chartType == 'horizontalBar') {
            var maxPx = chart.chart.width * 0.45; 
        } else if (chartType == 'bar' || chartType == 'line') {
            var maxPx = chart.chart.height * 0.45;
        }
        var fontSizePx = chart.options.defaultFontSize; //might need to get pixel size out of chart.legend.ctx.font string

        var chars = (maxPx / fontSizePx)*2; // more accurate would be to take the actual label text and append it
                                            // char by char to a div of the right width until the div grows in height
                                            // but that seems a little over the top
        return chars;
    }

    /**
     * Estimate space needed (px) that will accommodate a list of labels
     *
     * @param chart
     */
    var getChartLabelSpace = function(chart) {
        var noSeries = chart.data.labels.length;
        var fontSizePx = chart.options.defaultFontSize; //might need to get pixel size out of chart.legend.ctx.font string
        return noSeries * fontSizePx * 1.5;
    }

    /**
     * Adjust horizontal- / bar / line charts by trimming labels and resizing as needed
     * Driven by optional charts.json bool settings "growToFit" and "trimLabels"
     *
     * @param datastructure
     * @param chartType
     * @param chartConfig
     * @param chart
     * @param divId
     */
    var adjustChartLabelsAndSize = function(datastructure, chartType, chartConfig, chart, divId) {
        if (chartType == 'horizontalBar' || chartType == 'bar' || chartType == 'line') {
            if (chartConfig.trimLabels) {
                var maxLen = getChartLabelMaxLen(chart, chartType);
                for (var i = 0; i < datastructure.labels.length; i++) {
                    if (datastructure.labels[i].length > maxLen)
                        datastructure.labels[i] = datastructure.labels[i].substring(0, maxLen - 3) + '...';
                }
            }
            if (chartConfig.growToFit) {
                var reSize = getChartLabelSpace(chart);
                if (chartType == 'horizontalBar') {
                    if ($('#' + divId).height() < reSize) {
                        chart.options.maintainAspectRatio = false;
                        $('#' + divId).height(reSize);
                        chart.resize();
                    }
                } else if (chartType == 'bar' || chartType == 'line') {
                    if ($('#' + divId).width() < reSize) {
                        chart.options.maintainAspectRatio = false;
                        chart.scales["x-axis-0"].options.ticks.autoSkip = false;
                        chart.scales["x-axis-0"].options.ticks.stepSize = 1;
                        $('#' + divId).width(reSize);
                        chart.resize();
                    }
                }
            }
            //update current chart data
            chart.data = datastructure;
            chart.update();
        }
        return 0;
    }
    
    var drawChart = function (datastructure, labelToFq, $canvas, chartConfig, divId) {
        var chart;
        // remain compatible with older config
        var chartType = (chartConfig.chartType == 'horizontal-bar') ? 'horizontalBar' : chartConfig.chartType;
        
        if (chartConfig.chart) {
            adjustChartLabelsAndSize(datastructure, chartType, chartConfig, chartConfig.chart, divId);
            //update current chart data
            chartConfig.chart.data = datastructure;
            chartConfig.chart.update();
            chart = chartConfig.chart;
        } else {
            var ctx = $canvas.get(0).getContext("2d");

            
            var scales = getScales(chartType, chartConfig.maxValue, chartConfig.logarithmic);

            chart = new Chart(ctx, {
                type: chartType,
                data: datastructure,
                options: {
                    responsive: true,
                    scales: scales,
                    legend: {
                        display: false
                    }
                }
            });

            if (chartType == 'pie' || chartType == 'doughnut' || chartConfig.seriesEnabled) {
                $('#' + divId).find('.chart-legend').get(0).innerHTML = chart.generateLegend();
            }
            
            adjustChartLabelsAndSize(datastructure, chartType, chartConfig, chart, divId);

            $canvas.click(
                function (evt) {
                    var activePoints = chart.getElementsAtEvent(evt);
                    var chartLabels = Object.keys(labelToFq);
                    var selectedKey = chartLabels[activePoints[0]._index];
                    var url = chartOptions.biocacheWebappUrl + "/occurrences/search?q=" + chartOptions.query + "&fq=" + labelToFq[selectedKey]
                        + (chartOptions.qualityProfile ? "&qualityProfile=" + chartOptions.qualityProfile : "");
                    window.location.href = url;
                }
            );
        }

        return chart;
    };

    var getScales = function (chartType, maxValue, logarithmic) {
        var scales = {};
        if (logarithmic) {
            if (chartType == 'bar' || chartType == 'line') {
                scales = {
                    yAxes: [{
                        type: 'logarithmic',
                        ticks: {
                            //fixed chart maximum even when slider changes
                            max: maxValue
                        }
                    }]
                }
            } else if (chartType == 'horizontalBar') {
                scales = {
                    xAxes: [{
                        type: 'logarithmic',
                        ticks: {
                            //fixed chart maximum even when slider changes
                            max: maxValue
                        }
                    }]
                }
            }
        } else {
            if (chartType == 'bar' || chartType == 'line') {
                scales = {
                    yAxes: [{
                        ticks: {
                            //fixed chart maximum even when slider changes
                            max: maxValue
                        }
                    }]
                }
            } else if (chartType == 'horizontalBar') {
                scales = {
                    xAxes: [{
                        ticks: {
                            //fixed chart maximum even when slider changes
                            max: maxValue
                        }
                    }]
                }
            }
        }

        return scales;
    };

    /**
     * Function that wraps the WS call to retrieve data for a chart
     *
     * @param chartConfig
     * @param query
     * @param facet
     * @param facetQueries
     * @param queryContext
     * @param additionalFilter
     * @param divId
     * @param dataCallback the callback function to use if data available
     */
    var wsCallAndRender = function(chartConfig, query, facet, facetQueries, queryContext, additionalFilter, divId, dataCallback){

        if(query == "" || query == undefined) {
            query = "*:*";
        }

        //when there is a sliderFacet, exclude sliderFacet unknowns
        if (chartConfig.sliderEnabled) query += "&fq=" + encodeURIComponent(chartConfig.sliderFacet + ":*");

        var valueParam = "";
        if (chartConfig.valueType && chartConfig.valueType.length > 0 && chartConfig.valueType != "count" && chartConfig.valueFacet) {
            valueParam = "&stats=" + chartConfig.valueFacet;
        }

        var xranges = (chartConfig.valueRanges && chartConfig.valueRanges.length>0) ? "&xranges=" + formatRange(facet, chartConfig.valueRanges) : "";
        var seriesRanges = (chartConfig.seriesRanges && chartConfig.seriesRanges.length>0) ? "&seriesranges=" + formatRange(chartConfig.seriesFacet, chartConfig.seriesRanges) : "";
        var series = (chartConfig.seriesEnabled && chartConfig.seriesFacet && chartConfig.seriesFacet.length>0) ? "&series=" + chartConfig.seriesFacet : "";
        var seriesFq = "";
        if (chartConfig.seriesEnabled && chartConfig.seriesFq && chartConfig.seriesFq.length > 0) {
            seriesFq = "&fq="
            $.each(chartConfig.seriesFq, function (key, value) {
                if (seriesFq.length > 4) seriesFq += "%20OR%20";
                seriesFq += '(' + encodeURIComponent(value) + ')';
            });
        }

        if (!chartConfig.sliderFq) chartConfig.sliderFq = '';

        var includeOther = (chartConfig.includeOther) ? "&xother=" + chartConfig.includeOther : "";
        var includeOtherSeries = (chartConfig.includeOtherSeries) ? "&seriesother=" + chartConfig.includeOtherSeries : "";
        var includeMissing = (chartConfig.hideEmptyValues) ? "&xmissing=" + (!chartConfig.hideEmptyValues) : "";

        var x = (facet) ? "&x=" + facet : "";

        //default search service
        var queryUrl = chartOptions.biocacheServiceUrl + "/chart.json?q=" + query +
            x + xranges +"&qc=" + queryContext + valueParam + chartConfig.sliderFq + seriesRanges + series + seriesFq +
            includeOther + includeOtherSeries + includeMissing + (chartOptions.qualityProfile ? "&qualityProfile=" + chartOptions.qualityProfile : "");

        if(additionalFilter) {
            queryUrl = queryUrl + '&' + additionalFilter;
        }

        //console.log(queryUrl);

        if (divId) $('#' + divId).find('.chart-loading').show();

        $.ajax({
            url: queryUrl,
            type: 'GET',
            error: function(xhr, status, error) {
                alert("error");
            },
            success: function(data) {
                dataCallback(data.data);
            },
            error: function(data) {
                //return no data instead of error
                dataCallback([]);
            },
            complete: function() {
                if (divId) $('#' + divId).find('.chart-loading').hide();
            }
        });
    };

    var formatRange = function(facet, range) {
        if (facetLookup(facet).dataType == 'tdate') {
            var newRange = [];
            $.each(range.split(','), function (key, value) {
                newRange.push(new Date(Date.parse(value)).toISOString());
            });
            return newRange.join(',');
        } else {
            return range;
        }
    }

    function transparentColors(_c0, p) {
        if (_c0 instanceof Array) {
            var c = [];
            $.each(_c0, function (key, c0) {
                c.push(singleTransparentColors(c0, p))
            });
            return c;
        } else {
            return singleTransparentColors(_c0, p);
        }
    }

    function singleTransparentColors(c0, p) {
        return "rgba(" + parseInt(c0.slice(1,3),16) + "," + parseInt(c0.slice(3,5),16) + "," + parseInt(c0.slice(5,7),16) + "," + (p/100.0) + ")";
    }

    function blendColors(_c0, c1, p) {
        if (_c0 instanceof Array) {
            var c = [];
            $.each(_c0, function (key, c0) {
                c.push(singleBlendColors(c0, c1, p))
            });
            return c;
        } else {
            return singleBlendColors(_c0, c1, p);
        }
    }

    function singleBlendColors(c0, c1, p) {
        var f=parseInt(c0.slice(1),16),t=parseInt(c1.slice(1),16),R1=f>>16,G1=f>>8&0x00FF,B1=f&0x0000FF,R2=t>>16,G2=t>>8&0x00FF,B2=t&0x0000FF;
        return "#"+(0x1000000+(Math.round((R2-R1)*p)+R1)*0x10000+(Math.round((G2-G1)*p)+G1)*0x100+(Math.round((B2-B1)*p)+B1)).toString(16).slice(1);
    }

    var chartCounter = 0;

    /**
     * Create the canvas and legend elements.
     *
     * @param facet
     * @param title
     * @param chartConfig
     * @returns {string}
     */
    var createCanvasAndLegend = function(facet, title, chartConfig){
        //console.log("createCanvasAndLegend",title,chartConfig.divId);
        var divId = facet + '-chart-' + chartCounter;
        var divIdWithoutCounter = facet + '-chart';
        var $topDiv;
        var checked = "";
        var exists = false;
        if (chartConfig && chartConfig.divId && $('#' + chartConfig.divId).size() > 0) {
            //console.log("div exists");
            //top div already exists, replace contents
            divId = chartConfig.divId;
            $topDiv = $('#' + divId);
            $topDiv.empty();
            checked = "checked";
            exists = true;
        } else {
            //console.log("div NOT exists");
            chartConfig.divId = divId;
            chartCounter++;
            $topDiv = $('<div/>').addClass('chart').addClass(divIdWithoutCounter).attr('id', divId);
        }

        if (chartConfig.large) {
            $topDiv.width('100%');
        }

        var $title = $('<h3/>').addClass('chart-title').html(title);
        var $canvas = $('<canvas/>').addClass('chart-canvas');
        var $legend = $('<div/>').addClass('chart-legend').addClass('ala-doughnut-legend');

        var $progress = $('<label>loading...</label>').addClass('chart-loading');

        if (chartOptions.chartControls) {
            var $delete = $('<button>delete</button>').addClass('btn').addClass('btn-xs').addClass('btn-mini').addClass('btn-danger').click(deleteChart);
            var $edit = $('<button>edit</button>').addClass('btn').addClass('btn-xs').addClass('btn-mini').click(editChart);
            var $showHide = $('<input type="checkbox" name="show-hide-chart" class="bootToggle" ' + checked + '>').change(toggleChart);
            $topDiv.append($title).append($delete).append($edit).append($showHide);
        } else {
            $topDiv.append($title);
        }

        //slider controls
        $topDiv.append($('<ul class="nav nav-tabs" id="controlsMapTab">\
                <div id="timeControls" class="text-center"> \
                    <div id="timeButtons">\
                        <span class="timeControl link" id="playButton" title="Play" alt="Play"></span>\
                        <span class="timeControl link" id="pauseButton" title="Pause play" alt="Pause play"></span>\
                        <span class="timeControl link" id="stopButton" title="Stop" alt="Stop"></span>\
                        <span class="timeControl link" id="resetButton" title="Reset" alt="Reset"></span>\
                        <input class="timeControl link" id="stepSize" title="Step size" alt="Step size">\
                    </div>\
                    <div id="timeSlider">\
                        <div id="timeRange"><span id="timeFrom"></span> - <span id="timeTo"></span></div>\
                    </div>\
                </div>\
            </ul>').hide());

        if (chartConfig && !chartConfig.hideOnce) {
            $topDiv.append($canvas).append($legend).append($progress);
        }

        if (!exists) {
            $('#' + chartsDivId).append($topDiv);
        }

        $topDiv.find('.bootToggle').bootstrapToggle({
            on: 'hide',
            off: 'show',
            size: 'mini',
            onstyle: 'default'
        });

        return divId;
    };

    function deleteChart(event) {
        if (confirm("Are you sure you want to delete this chart?")) {
            var divId = $(event.target).closest('.chart').attr('id');
            for (var key in chartOptions.charts) {
                if (chartOptions.charts[key].divId == divId) {
                    delete chartOptions.charts[key];
                }
            }

            if (chartOptions.chartControlsCallback) {
                chartOptions.chartControlsCallback(chartOptions);
            }

            $(event.target).parent().detach();
        }
    }

    function toggleChart(event) {
        //console.log("toggleChart",$(event.target),$(event.target).is(":checked"));
        if ($(event.target).is(":checked")) {
            showChart(event);
        } else {
            hideChart(event);
        }
    }

    function hideChart(event) {
        var chart = $(event.target).closest('.chart');
        chart.children('.chart-canvas').hide()
        chart.children('.chart-legend').hide()
        chart.children('.chart-no-data-label').hide()
        chart.find('#controlsMapTab').hide()
    }

    function showChart(event) {
        var chart = $(event.target).closest('.chart');

        if (chart.children('.chart-canvas').size() == 0 && chart.children('.chart-canvas').size() == 0) {
            //create chart
            //console.log("create chart");
            var divId = chart.attr('id');
            for (var key in chartOptions.charts) {
                if (chartOptions.charts[key].divId == divId) {
                    createChart(chartOptions.charts[key].facet, chartOptions.charts[key]);
                }
            }
        } else {
            //console.log("just show chart");
            chart.children('.chart-canvas').show()
            chart.children('.chart-legend').show()
            chart.children('.chart-no-data-label').show()

            var divId = chart.attr('id');
            for (var key in chartOptions.charts) {
                if (chartOptions.charts[key].divId == divId && chartOptions.charts[key].sliderEnabled) {
                    $('#' + divId).find('#controlsMapTab').show()
                }
            }
        }
    }

    function editChart(event) {
        var chart = $(event.target).closest('.chart');

        //toggle
        if (chart.children('.chart-add').size() == 0) {
            hideChart(event);

            var divId = $(event.target).closest('.chart').attr('id');
            for (var key in chartOptions.charts) {
                if (chartOptions.charts[key].divId == divId) {
                    createControl($(event.target).closest('.chart'), true, chartOptions.charts[key], chartConfig);
                }

            }
        } else {
            showChart(event);
            chart.children('.chart-add').detach();
        }
    }

    var createTextInput = function(label, clas, value, hint) {
        return $('<div/>').addClass('chart-add-group').
            append($('<label>' + label + '</label>').addClass('chart-add-label').append(createHintIcon(hint))).
            append($('<input/>').addClass('chart-add-' + clas).val(value));
    };

    var createSelectInput = function(label, clas, values, defaultValue, hint) {
        var select = $('<select/>').addClass('chart-add-' + clas);
        $(values).each(function (key, value) {
            select.append($("<option/>").attr('value', value).text(value));
        });
        select.val(defaultValue);

        return $('<div/>').addClass('chart-add-group').
            append($('<label>' + label + '</label>').addClass('chart-add-label').append(createHintIcon(hint))).
            append(select);
    };

    var createCheckboxInput = function (label, clas, value, hint) {
        return $('<div/>').addClass('chart-add-group').
            append($('<label>' + label + '</label>').addClass('chart-add-label').append(createHintIcon(hint))).
            append($('<input/>').addClass('chart-add-' + clas).attr('type', 'checkbox').prop('checked', value));
    };

    var createHintIcon = function(hint) {
        return $('<i/>').addClass('fa fa-question-circle hint').attr('title', hint);
    };

    /**
     * Create controls for creating/editing a chart
     *
     * @param parent
     * @param editchart
     * @param defaults
     * @param chartConfig
     */
    var createControl = function(parent, editchart, defaults) {
        var control = $('<div/>').addClass('chart-add');

        var title = createTextInput('Title', 'title',
            (defaults && defaults.title) ? defaults.title : 'My chart', 'Text will appear above the chart');

        var valueType = createSelectInput('Value', 'value-type', [ 'count', 'sum', 'max', 'min', 'mean', 'missing', 'stddev' ],
            (defaults && defaults.valueType) ? defaults.valueType : 'count', 'Secondary axis "value", default is record count');

        var seriesEnabled = createCheckboxInput('Series enabled', 'series-enabled',
            (defaults && defaults.seriesEnabled) ? defaults.seriesEnabled : false, 'Include additional data series on the chart.');

        var sliderEnabled = createCheckboxInput('Slider enabled', 'slider-enabled',
            (defaults && defaults.sliderEnabled) ? defaults.sliderEnabled : false, 'Add a slider to change the 3rd axis (usually date)');

        var seriesRanges = createTextInput('Series ranges', 'series-ranges',
            (defaults && defaults.seriesRanges) ? defaults.seriesRanges : '', 'Enter comma delimited list to group selected series values. The list should begin with the min value and end with the max value. e.g. "0,0.2,1" will produce the groups "0 to 0.2", "0.2 to 1".');

        var valueRanges = createTextInput('Facet ranges', 'value-ranges',
            (defaults && defaults.valueRanges) ? defaults.valueRanges : '', 'Enter comma delimited list to group selected facet values. The list should begin with the min value and end with the max value. e.g. "0,0.2,1" will produce the groups "0 to 0.2", "0.2 to 1".');

        var chartType = createSelectInput('Chart type', 'chart-type', [ 'bar', 'horizontalBar', 'doughnut', 'pie', 'line' ],
            (defaults && defaults.chartType) ? defaults.chartType : 'bar', 'chart type is self explanatory');

        var emptyValueMsg = createTextInput('Empty value message', 'empty-value-msg',
            (defaults && defaults.emptyValueMsg) ? defaults.emptyValueMsg : 'Unknown', 'This text will appear when no value is present in the data');

        var hideEmptyValues = createCheckboxInput('Hide empty values', 'hide-empty-values',
            (defaults && defaults.hideEmptyValues !== undefined) ? defaults.hideEmptyValues : true, 'empty value will be removed from chart');

        var includeOther = createCheckboxInput('Include "Other".', 'include-other',
            (defaults && defaults.includeOther) ? defaults.includeOther : false, 'Charts have a limit on the number of facets that will be displayed. Including "Other" will group all the excluded facets together.');

        var includeOtherSeries = createCheckboxInput('Include "Other" for the series.', 'include-other-series',
            (defaults && defaults.includeOtherSeries) ? defaults.includeOtherSeries : false, 'Charts have a limit on the number of series that will be displayed. Including "Other" will group all the excluded series together.');

        var largeChart = createCheckboxInput('Large chart', 'large',
            (defaults && defaults.large) ? defaults.large : false, 'Chart will take up the full width of the surrounding block');

        var logarithmic = createCheckboxInput('Logarithmic', 'logarithmic',
            (defaults && defaults.logarithmic) ? defaults.logarithmic : false, 'Value axis will show logarithmic scale - use for large range of values in data');

        var facet = createSelectInput('Facet', 'facet', [] , '', 'Choose a facet field for the first axis of the chart - see the filter column for facets that have values in your data');
        var valueFacet = createSelectInput('Value facet', 'value-facet', [] , '', 'Choose a facet field for the secondary axis of the chart - values are computed using the "Value" type chosen');
        var seriesFacet = createSelectInput('Series facet', 'series-facet', [] , '', 'Choose a facet field for the "series" axis of the chart');
        var sliderFacet = createSelectInput('Slider facet', 'slider-facet', [] , '', 'Choose a facet field for the "slider" axis of the chart');
        $(_facets).each(function (key, value) {
            if (value.indexed) {
                var displayValue = (value.description) ? value.description : value.name;
                facet.find('select').append($("<option/>").attr('value', value.name).text(displayValue));
                seriesFacet.find('select').append($("<option/>").attr('value', value.name).text(displayValue));

                if (value.dataType == 'int' || value.dataType == 'double' || value.dataType == 'long' ||
                    value.dataType == 'tint' || value.dataType == 'tdouble' || value.dataType == 'tlong') {
                    valueFacet.find('select').append($("<option/>").attr('value', value.name).text(displayValue));
                }

                if (value.dataType == 'int' || value.dataType == 'double' || value.dataType == 'tdate') {
                    sliderFacet.find('select').append($("<option/>").attr('value', value.name).text(displayValue));
                }
            }
        });
        if (defaults && defaults.facet) facet.find('select').val(defaults.facet);
        if (defaults && defaults.valueFacet) valueFacet.find('select').val(defaults.valueFacet);
        if (defaults && defaults.seriesFacet) seriesFacet.find('select').val(defaults.seriesFacet);
        if (defaults && defaults.sliderFacet) sliderFacet.find('select').val(defaults.sliderFacet);

        var seriesFq = createSelectInput('Series facet', 'series-fq', [] , '', 'Restrict which series values to include.');

        var button;
        if (editchart) {
            button = $('<div/>').
            append($('<button>Apply changes</button>').addClass('chart-add-button').addClass('btn').addClass('btn-xs').addClass('btn-mini').click(applyChartChanges)).
            //toggle edit controls
            append($('<button>Cancel</button>').addClass('chart-add-cancel').addClass('btn').addClass('btn-xs').addClass('btn-mini').click(editChart));
        } else {
            button = $('<button>Add new chart</button>').addClass('chart-add-button').addClass('btn').click(addChart);
        }

        control.append(title);
        control.append(chartType);
        control.append(largeChart);
        control.append(facet);
        control.append(valueRanges);
        control.append(valueType);
        control.append(valueFacet);
        control.append(button);
        control.append(hideEmptyValues);
        control.append(emptyValueMsg);
        control.append(includeOther);
        control.append(logarithmic);
        control.append(sliderEnabled);
        control.append(sliderFacet);
        control.append(seriesEnabled);
        control.append(seriesFacet);
        control.append(seriesRanges);
        control.append(seriesFq);
        control.append(includeOtherSeries);
        control.append(button);

        parent.append(control);

        applyControlBehaviour(control, defaults);
    };

    /**
     * Show/hide chart control items depending on chartConfig and control changes.
     *
     * @param control
     * @param chartConfig
     */
    var applyControlBehaviour = function (control, chartConfig) {

        control.find('.chart-add-chart-type').change(function (evt) {
            var show = control.find('.chart-add-chart-type').val() != 'pie' && control.find('.chart-add-chart-type').val() != 'doughnut';
            controlVisible(control, ['logarithmic', 'slider-facet', 'series-enabled', 'series-facet', 'series-ranges', 'include-other-series'], show);
            if (show) {
                //show controls that are enabled and apply to charts that are not pie or doughnut
                control.find('.chart-add-slider-enabled').change();
                control.find('.chart-add-value-type').change();
                control.find('.chart-add-series-facet').change();
                control.find('.chart-add-series-enabled').change();
            }
        });
        control.find('.chart-add-chart-type').change();

        control.find('.chart-add-series-enabled').change(function (evt) {
            var show = control.find('.chart-add-series-enabled').prop('checked');
            controlVisible(control, ['series-facet', 'series-ranges', 'series-fq', 'include-other-series'], show);
            if (show) {
                control.find('.chart-add-series-facet').change();
            }
        });
        control.find('.chart-add-series-enabled').change();

        control.find('.chart-add-slider-enabled').change(function (evt) {
            controlVisible(control, ['slider-facet'], control.find('.chart-add-slider-enabled').prop('checked'));
        });
        control.find('.chart-add-slider-enabled').change();

        control.find('.chart-add-hide-empty-values').change(function (evt) {
            controlVisible(control, ['empty-value-msg'], !control.find('.chart-add-hide-empty-values').prop('checked'));
        });
        control.find('.chart-add-hide-empty-values').change();

        control.find('.chart-add-value-type').change(function (evt) {
            controlVisible(control, ['value-facet'], control.find('.chart-add-value-type').val() != 'count');
        });
        control.find('.chart-add-value-type').change();

        control.find('.chart-add-facet').change(function (evt) {
            var show = $.inArray(facetLookup(control.find('.chart-add-facet').val()).dataType, ['long', 'tlong', 'int', 'tint', 'double', 'tdouble', 'date', 'tdate']) >= 0;
            controlVisible(control, ['value-ranges'], show);
            if (show) {
                getMinMax(chartConfig, control.find('.chart-add-facet').val(), function (minMax) {
                    if (facetLookup(control.find('.chart-add-facet').val()).dataType == 'tdate') {
                        var d1 = new Date(minMax[0]).toISOString().slice(0,10);
                        var d2 = new Date(minMax[1]).toISOString().slice(0,10);
                        var label = d1 + ' to ' + d2;
                        control.find('.chart-add-value-ranges').attr("placeholder", label);
                        control.find('.chart-add-value-ranges').attr("title", label);
                    } else {
                        control.find('.chart-add-value-ranges').attr("placeholder", minMax[0] + ' to ' + minMax[1]);
                        control.find('.chart-add-value-ranges').attr("title", minMax[0] + ' to ' + minMax[1]);
                    }
                });
            } else {
                control.find('.chart-add-value-ranges').val('');
            }
        });
        control.find('.chart-add-facet').change();

        control.find('.chart-add-series-facet').change(function (evt) {
            if (control.find('.chart-add-series-enabled').prop('checked')) {
                var show = $.inArray(facetLookup(control.find('.chart-add-series-facet').val()).dataType, ['long', 'tlong', 'int', 'tint', 'double', 'tdouble', 'date', 'tdate']) >= 0;
                controlVisible(control, ['series-ranges'], show);
                controlVisible(control, ['series-fq', 'include-other-series'], !show);
                if (show) {
                    var select = control.find('.chart-add-series-fq').multiselect('destroy');
                    select.empty();
                    control.find('.chart-add-series-fq').val('');

                    getMinMax(chartConfig, control.find('.chart-add-series-facet').val(), function (minMax) {
                        if (facetLookup(control.find('.chart-add-series-facet').val()).dataType == 'tdate') {
                            var d1 = new Date(minMax[0]).toISOString().slice(0,10);
                            var d2 = new Date(minMax[1]).toISOString().slice(0,10);
                            var label = d1 + ' to ' + d2;
                            control.find('.chart-add-series-ranges').attr("placeholder", label);
                            control.find('.chart-add-series-ranges').attr("title", label);
                        } else {
                            control.find('.chart-add-series-ranges').attr("placeholder", minMax[0] + ' to ' + minMax[1]);
                            control.find('.chart-add-series-ranges').attr("title", minMax[0] + ' to ' + minMax[1]);
                        }
                    });
                } else {
                    control.find('.chart-add-series-ranges').val('');

                    getFacetValues(chartOptions.query, chartOptions.facetQueries, chartOptions.queryContext, chartConfig.filter,
                        control.find('.chart-add-series-facet').val(), function (list) {
                            //rebuild select
                            var select = control.find('.chart-add-series-fq').multiselect('destroy');
                            select.empty();
                            select.attr('multiple', true);
                            $.each(list, function (key, value) {
                                //hide empty label item because we cannot OR with fqs like -facet:*
                                if (value.count > 0 && value.label && value.label.length > 0) {
                                    var item = $("<option/>").attr('value', value.fq).text(value.label);
                                    if ($.inArray(value.fq, chartConfig.seriesFq) >= 0) item.attr('selected', true);
                                    select.append(item);
                                }
                            });
                            select.multiselect({
                                maxHeight: 300,
                                numberDisplayed: 1
                            });

                        });
                }
            } else {
                controlVisible(control, ['series-ranges', 'series-fq', 'include-other-series'], false);
            }
        });
        control.find('.chart-add-series-facet').change();
    };

    var getFacetValues = function(query, facetQueries, queryContext, additionalFilter, facet, callback) {

        //default search service
        var queryUrl = chartOptions.biocacheServiceUrl + "/occurrences/search.json?q=" + query + "&qc=" + queryContext +
            "&pageSize=0&flimit=100&facet=true"+"&facets=" + facet + (chartOptions.qualityProfile ? "&qualityProfile=" + chartOptions.qualityProfile : "");

        if(additionalFilter) {
            queryUrl = queryUrl + '&' + additionalFilter;
        }

        $.ajax({
            url: queryUrl,
            type: 'GET',
            error: function(xhr, status, error) {
                alert("error");
            },
            success: function(data) {
                callback(data.facetResults[0].fieldResult);
            },
            error: function(data) {
                //return no data instead of error
                callback([]);
            }
        });
    };

    /**
     * Set the visibility of a chart control.
     *
     * @param control
     * @param list
     * @param visible
     */
    var controlVisible = function (control, list, visible) {
        $.each (list, function (key, value) {
            var g = control.find('.chart-add-' + value).closest('.chart-add-group');
            if (visible) g.show();
            else g.hide();
        })
    };

    /**
     * Get a facet definition. This is sourced from biocache-service /index/fields.
     *
     * @param facet
     * @returns {*}
     */
    var facetLookup = function (facet) {
        for (var key in _facets) {
            if (_facets[key].name == facet) {
                return _facets[key];
            }
        }
        return {};
    };

    /**
     * Add a new chart.
     *
     * @param event
     */
    var addChart = function(event) {
        var options = getChartConfig($(event.target).closest('.chart-add'));

        createChart(options.facet, options);

        //save with a unique name
        var i = 0;
        while (chartOptions.charts[i + '*' + options.facet] !== undefined) i++;
        chartOptions.charts[i + '*' + options.facet] = options;

        if (chartOptions.chartControlsCallback) {
            chartOptions.chartControlsCallback(chartOptions);
        }
    };

    /**
     * Update config of an existing chart.
     *
     * @param event
     */
    var applyChartChanges = function(event) {
        var divId = $(event.target).closest('.chart').attr('id');
        var $topDiv = $('#' + divId);
        for (var key in chartOptions.charts) {
            if (chartOptions.charts[key].divId == divId) {
                var options = getChartConfig($topDiv);

                options.divId = divId;

                chartOptions.charts[key] = options;

                if (chartOptions.chartControlsCallback) {
                    chartOptions.chartControlsCallback(chartOptions);
                }

                //create new chart
                createChart(options.facet, options);
            }
        }
    };

    /**
     * Get chart config from chart controls.
     *
     * @param $topDiv
     * @returns {{title: *, facet: *, valueFacet: *, valueType: *, chartType: *, emptyValueMsg: *, hideEmptyValues: *, seriesEnabled: *, sliderEnabled: *, valueRanges: *, seriesFacet: *, seriesRanges: *, sliderFacet: *, logarithmic: *}}
     */
    var getChartConfig = function ($topDiv) {
        return  {
            title: $topDiv.find('.chart-add-title').val(),
            large: $topDiv.find('.chart-add-large').prop('checked'),
            facet: $topDiv.find('.chart-add-facet').val(),
            valueFacet: $topDiv.find('.chart-add-value-facet').val(),
            valueType: $topDiv.find('.chart-add-value-type').val(),
            chartType: $topDiv.find('.chart-add-chart-type').val(),
            emptyValueMsg: $topDiv.find('.chart-add-empty-value-msg').val(),
            hideEmptyValues: $topDiv.find('.chart-add-hide-empty-values').prop('checked'),
            seriesEnabled: $topDiv.find('.chart-add-series-enabled').prop('checked'),
            sliderEnabled: $topDiv.find('.chart-add-slider-enabled').prop('checked'),
            valueRanges: $topDiv.find('.chart-add-value-ranges').val(),
            seriesFacet: $topDiv.find('.chart-add-series-facet').val(),
            seriesRanges: $topDiv.find('.chart-add-series-ranges').val(),
            sliderFacet: $topDiv.find('.chart-add-slider-facet').val(),
            logarithmic: $topDiv.find('.chart-add-logarithmic').prop('checked'),
            seriesFq: $topDiv.find('.chart-add-series-fq').val(),
            includeOtherSeries: $topDiv.find('.chart-add-include-other-series').prop('checked'),
            includeOther: $topDiv.find('.chart-add-include-other').prop('checked')
        };
    };

    /**
     * Get the min and max values for a facet.
     *
     * @param chartConfig
     * @param facet
     * @param successCallback executes when a min/max is found with input array [min, max]
     * @param failureCallback executes when there is no data in the query.
     */
    var getMinMax = function(chartConfig, facet, successCallback, failureCallback) {

        if (facet) {
            //setup chart config to fetch min/max of facet
            var config = jQuery.extend(true, {}, chartConfig);
            config.valueType = 'max';
            config.valueFacet = facet;
            config.facet = null;
            config.seriesEnabled = false;
            config.sliderFq = '';
            config.valueRanges = [];

            wsCallAndRender(config, chartOptions.query, config.facet, chartOptions.facetQueries, chartOptions.queryContext, config.filter, config.divId, function (data) {
                if (data.length > 0 && data[0].data.length > 0) {
                    successCallback([data[0].data[0]['min'], data[0].data[0]['max']]);
                } else if (failureCallback) {
                    failureCallback();
                }
            });
        } else {
            if (failureCallback) failureCallback();
        }
    };

    /**
     * Toggle visibility of add chart controls.
     *
     * @param event
     */
    var toggleAddControls = function(event) {
        // $(event.target).parent().find('#chartControls').children('.chart-add:first').toggle();
        $(event.target).parent().children('.chart-add:first').toggle();
    };

    //init facets before controls
    $.ajax({
        url: chartOptions.biocacheServiceUrl + '/index/fields.json',
        type: 'GET',
        error: function(xhr, status, error) {
            console.log('unable to get index/fields')
        },
        success: function(data) {
            _facets = data.sort(function(o1, o2) {
                var name1 = ((o1.description)?o1.description: o1.name).toLowerCase();
                var name2 = ((o2.description)?o2.description: o2.name).toLowerCase();
                return (name1 < name2) ? -1 : (name1 > name2) ? 1 : 0;
            });

            //console.log('init chart controls');

            if (chartOptions.chartControls) {
                var ctrl = $('<div/>').append($('<button>Toggle Chart Controls</button>').addClass('chart-controls-toggle').addClass('btn').click(toggleAddControls))
                $('#' + chartsDivId).prepend(ctrl);
                createControl( ctrl, false, {}, {});
                //$('#' + chartsDivId).parent().prepend(btn); // place outside the row-fluid div so charts don't get moved/nudged

                //hide controls
                ctrl.children('.chart-add:first').toggle();
            }
        }
    });

    //create the charts
    $.each(chartOptions.charts, function(facet, chartConfig){
        //support charts where facet is defined in chartConfig
        if (chartConfig.facet === undefined) {
            createChart(facet, chartConfig)
        } else {
            createChart(chartConfig.facet, chartConfig)
        }
    });

    // activate BS tooltip (will work for dynamically generated content)
    $('body').tooltip({
        selector: '.hint'
    });
};

var process = process || {env: {NODE_ENV: "development"}};
/**
 *
 * @param config
 * @returns {{}}
 * @constructor
 */
var RegionTimeControls = function(config) {

    var timeSlider;
    var CONTROL_STATES = {
        PLAYING: 0,
        PAUSED: 1,
        STOPPED: 2
    };
    var state = CONTROL_STATES.STOPPED;
    var from;
    var to;
    var maxValue;
    var minValue;
    var refreshInterval;
    var playTimeRange;
    var isDate;

    var callback;
    var _config;

    var formatDate = function (data) {
        return new Date(data).toISOString().slice(0, 10);
    }

    var init = function(config) {
        callback = config.callback;
        _config = config;

        minValue = from = config.range[0];
        maxValue = to = config.range[1];

        isDate = config.date;

        updateTimeRange(config.range)

        //default step size is 1/10 of range
        if (isDate) {
            var diffDays = (maxValue - minValue) / (1000.0*60*60*24);
            if (diffDays < 30*5) {
                config.parent.find('#stepSize').val(Math.ceil(diffDays/10) + 'days')
            } else if(diffDays <= 365*5) {
                config.parent.find('#stepSize').val(Math.ceil(diffDays/300) + 'months')
            } else {
                config.parent.find('#stepSize').val(Math.ceil(diffDays/3650) + 'years')
            }
        } else {
            config.parent.find('#stepSize').val((maxValue - minValue) / 10.0);
        }

        var sliderOptions = {
            tooltip: "hide",
            min: minValue,
            max: maxValue,
            range: true,
            value: [from, to]
        };
        if (isDate) {
            sliderOptions.formatter = formatDate
        }

        timeSlider = config.parent.find('#timeSlider')
            .slider(sliderOptions).on('slideStop', function(event, ui) {
                callback(timeSlider.getValue())
                updateTimeRange(timeSlider.getValue())
            }).on('slide', function(event, ui) {
                updateTimeRange(timeSlider.getValue())
            }).data('slider');

        initializeTimeControlsEvents();
    };


    var initializeTimeControlsEvents = function() {
        // Initialize play button
        _config.parent.find('#playButton').on('click', function(){
            play();
        });

        // Initialize stop button
        _config.parent.find('#stopButton').on('click', function(){
            stop();
        });

        // Initialize pause button
        _config.parent.find('#pauseButton').on('click', function(){
            pause();
        });

        // Initialize reset button
        _config.parent.find('#resetButton').on('click', function(){
            reset();
        });

    };

    var stepSize = function(current) {
        if (isDate) {
            var step = config.parent.find('#stepSize').val().trim();
            var value = parseInt(step.replace(/[^\d]/g, ''));
            var dt = moment(current);
            if (step.endsWith('d') || step.endsWith('day') || step.endsWith('days')) {
                return dt.add(value, 'days');
            } else if (step.endsWith('m') || step.endsWith('month') || step.endsWith('months')) {
                return dt.add(value, 'months');
            } else {
                return dt.add(value, 'years');
            }
        } else {
            return parseInt(config.parent.find('#stepSize').val()) + current;
        }
    };

    var increaseTimeRangeByADecade = function() {
        var step = stepSize(playTimeRange[1]);
        var incrementTo = step < maxValue ? step : maxValue;
        var incrementFrom = stepSize(playTimeRange[0]);
        if (incrementFrom < maxValue) {
            timeSlider.setValue([incrementFrom, incrementTo], false, true);
            playTimeRange = timeSlider.getValue();
            callback(timeSlider.getValue())
        } else {
            stop();
        }
    };

    var play = function() {

        switch (state) {
            case CONTROL_STATES.STOPPED:
                // Start playing from the beginning
                // Update state before updating slider values
                state = CONTROL_STATES.PLAYING;
                timeSlider.setValue([minValue, stepSize(minValue)], false, true);
                callback(timeSlider.getValue())
                break;
            case CONTROL_STATES.PAUSED:
                // Resume playing
                // Update state before updating slider values
                state = CONTROL_STATES.PLAYING;
                timeSlider.setValue([playTimeRange[0], playTimeRange[1]], false, true);
                callback(timeSlider.getValue())
                break;
        }

        // For SVG elements the addClass and removeClass jQuery method do not work
        _config.parent.find('#pauseButton').removeClass('selected').trigger('selected');
        _config.parent.find('#playButton').addClass('selected').trigger('selected');
        playTimeRange = timeSlider.getValue();
        refreshInterval = setInterval(function () {
            increaseTimeRangeByADecade();
        }, 4000);
    };

    var stop = function() {
        clearInterval(refreshInterval);
        _config.parent.find('#pauseButton').removeClass('selected').trigger('selected');
        _config.parent.find('#playButton').removeClass('selected').trigger('selected');
        state = CONTROL_STATES.STOPPED;
    };

    var pause = function() {
        if (state === CONTROL_STATES.PLAYING) {
            _config.parent.find('#pauseButton').addClass('selected').trigger('selected');
            _config.parent.find('#playButton').removeClass('selected').trigger('selected');
            clearInterval(refreshInterval);
            state = CONTROL_STATES.PAUSED;
        }
    };

    var reset = function() {
        timeSlider.setValue([minValue, maxValue], false, true);
        stop();

        callback([minValue, maxValue]);
        updateTimeRange([minValue, maxValue]);
    };

    var updateTimeRange = function(values) {
        if (isDate) {
            _config.parent.find('#timeFrom').text(formatDate(values[0]));
            _config.parent.find('#timeTo').text(formatDate(values[1]));
        } else {
            _config.parent.find('#timeFrom').text(values[0]);
            _config.parent.find('#timeTo').text(values[1]);
        }
    };

    var _public = {

    };

    init(config);
    return _public;
};
var process = process || {env: {NODE_ENV: "development"}};
//! moment.js
//! version : 2.15.1
//! authors : Tim Wood, Iskren Chernev, Moment.js contributors
//! license : MIT
//! momentjs.com
!function(a,b){"object"==typeof exports&&"undefined"!=typeof module?module.exports=b():"function"==typeof define&&define.amd?define(b):a.moment=b()}(this,function(){"use strict";function a(){return md.apply(null,arguments)}
// This is done to register the method called with moment()
// without creating circular dependencies.
    function b(a){md=a}function c(a){return a instanceof Array||"[object Array]"===Object.prototype.toString.call(a)}function d(a){
// IE8 will treat undefined and null as object if it wasn't for
// input != null
        return null!=a&&"[object Object]"===Object.prototype.toString.call(a)}function e(a){var b;for(b in a)
// even if its not own property I'd still call it non-empty
        return!1;return!0}function f(a){return a instanceof Date||"[object Date]"===Object.prototype.toString.call(a)}function g(a,b){var c,d=[];for(c=0;c<a.length;++c)d.push(b(a[c],c));return d}function h(a,b){return Object.prototype.hasOwnProperty.call(a,b)}function i(a,b){for(var c in b)h(b,c)&&(a[c]=b[c]);return h(b,"toString")&&(a.toString=b.toString),h(b,"valueOf")&&(a.valueOf=b.valueOf),a}function j(a,b,c,d){return qb(a,b,c,d,!0).utc()}function k(){
// We need to deep clone this object.
        return{empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],meridiem:null}}function l(a){return null==a._pf&&(a._pf=k()),a._pf}function m(a){if(null==a._isValid){var b=l(a),c=nd.call(b.parsedDateParts,function(a){return null!=a}),d=!isNaN(a._d.getTime())&&b.overflow<0&&!b.empty&&!b.invalidMonth&&!b.invalidWeekday&&!b.nullInput&&!b.invalidFormat&&!b.userInvalidated&&(!b.meridiem||b.meridiem&&c);if(a._strict&&(d=d&&0===b.charsLeftOver&&0===b.unusedTokens.length&&void 0===b.bigHour),null!=Object.isFrozen&&Object.isFrozen(a))return d;a._isValid=d}return a._isValid}function n(a){var b=j(NaN);return null!=a?i(l(b),a):l(b).userInvalidated=!0,b}function o(a){return void 0===a}function p(a,b){var c,d,e;if(o(b._isAMomentObject)||(a._isAMomentObject=b._isAMomentObject),o(b._i)||(a._i=b._i),o(b._f)||(a._f=b._f),o(b._l)||(a._l=b._l),o(b._strict)||(a._strict=b._strict),o(b._tzm)||(a._tzm=b._tzm),o(b._isUTC)||(a._isUTC=b._isUTC),o(b._offset)||(a._offset=b._offset),o(b._pf)||(a._pf=l(b)),o(b._locale)||(a._locale=b._locale),od.length>0)for(c in od)d=od[c],e=b[d],o(e)||(a[d]=e);return a}
// Moment prototype object
    function q(b){p(this,b),this._d=new Date(null!=b._d?b._d.getTime():NaN),pd===!1&&(pd=!0,a.updateOffset(this),pd=!1)}function r(a){return a instanceof q||null!=a&&null!=a._isAMomentObject}function s(a){return 0>a?Math.ceil(a)||0:Math.floor(a)}function t(a){var b=+a,c=0;return 0!==b&&isFinite(b)&&(c=s(b)),c}
// compare two arrays, return the number of differences
    function u(a,b,c){var d,e=Math.min(a.length,b.length),f=Math.abs(a.length-b.length),g=0;for(d=0;e>d;d++)(c&&a[d]!==b[d]||!c&&t(a[d])!==t(b[d]))&&g++;return g+f}function v(b){a.suppressDeprecationWarnings===!1&&"undefined"!=typeof console&&console.warn&&console.warn("Deprecation warning: "+b)}function w(b,c){var d=!0;return i(function(){if(null!=a.deprecationHandler&&a.deprecationHandler(null,b),d){for(var e,f=[],g=0;g<arguments.length;g++){if(e="","object"==typeof arguments[g]){e+="\n["+g+"] ";for(var h in arguments[0])e+=h+": "+arguments[0][h]+", ";e=e.slice(0,-2)}else e=arguments[g];f.push(e)}v(b+"\nArguments: "+Array.prototype.slice.call(f).join("")+"\n"+(new Error).stack),d=!1}return c.apply(this,arguments)},c)}function x(b,c){null!=a.deprecationHandler&&a.deprecationHandler(b,c),qd[b]||(v(c),qd[b]=!0)}function y(a){return a instanceof Function||"[object Function]"===Object.prototype.toString.call(a)}function z(a){var b,c;for(c in a)b=a[c],y(b)?this[c]=b:this["_"+c]=b;this._config=a,
// Lenient ordinal parsing accepts just a number in addition to
// number + (possibly) stuff coming from _ordinalParseLenient.
        this._ordinalParseLenient=new RegExp(this._ordinalParse.source+"|"+/\d{1,2}/.source)}function A(a,b){var c,e=i({},a);for(c in b)h(b,c)&&(d(a[c])&&d(b[c])?(e[c]={},i(e[c],a[c]),i(e[c],b[c])):null!=b[c]?e[c]=b[c]:delete e[c]);for(c in a)h(a,c)&&!h(b,c)&&d(a[c])&&(
// make sure changes to properties don't modify parent config
        e[c]=i({},e[c]));return e}function B(a){null!=a&&this.set(a)}function C(a,b,c){var d=this._calendar[a]||this._calendar.sameElse;return y(d)?d.call(b,c):d}function D(a){var b=this._longDateFormat[a],c=this._longDateFormat[a.toUpperCase()];return b||!c?b:(this._longDateFormat[a]=c.replace(/MMMM|MM|DD|dddd/g,function(a){return a.slice(1)}),this._longDateFormat[a])}function E(){return this._invalidDate}function F(a){return this._ordinal.replace("%d",a)}function G(a,b,c,d){var e=this._relativeTime[c];return y(e)?e(a,b,c,d):e.replace(/%d/i,a)}function H(a,b){var c=this._relativeTime[a>0?"future":"past"];return y(c)?c(b):c.replace(/%s/i,b)}function I(a,b){var c=a.toLowerCase();zd[c]=zd[c+"s"]=zd[b]=a}function J(a){return"string"==typeof a?zd[a]||zd[a.toLowerCase()]:void 0}function K(a){var b,c,d={};for(c in a)h(a,c)&&(b=J(c),b&&(d[b]=a[c]));return d}function L(a,b){Ad[a]=b}function M(a){var b=[];for(var c in a)b.push({unit:c,priority:Ad[c]});return b.sort(function(a,b){return a.priority-b.priority}),b}function N(b,c){return function(d){return null!=d?(P(this,b,d),a.updateOffset(this,c),this):O(this,b)}}function O(a,b){return a.isValid()?a._d["get"+(a._isUTC?"UTC":"")+b]():NaN}function P(a,b,c){a.isValid()&&a._d["set"+(a._isUTC?"UTC":"")+b](c)}
// MOMENTS
    function Q(a){return a=J(a),y(this[a])?this[a]():this}function R(a,b){if("object"==typeof a){a=K(a);for(var c=M(a),d=0;d<c.length;d++)this[c[d].unit](a[c[d].unit])}else if(a=J(a),y(this[a]))return this[a](b);return this}function S(a,b,c){var d=""+Math.abs(a),e=b-d.length,f=a>=0;return(f?c?"+":"":"-")+Math.pow(10,Math.max(0,e)).toString().substr(1)+d}
// token:    'M'
// padded:   ['MM', 2]
// ordinal:  'Mo'
// callback: function () { this.month() + 1 }
    function T(a,b,c,d){var e=d;"string"==typeof d&&(e=function(){return this[d]()}),a&&(Ed[a]=e),b&&(Ed[b[0]]=function(){return S(e.apply(this,arguments),b[1],b[2])}),c&&(Ed[c]=function(){return this.localeData().ordinal(e.apply(this,arguments),a)})}function U(a){return a.match(/\[[\s\S]/)?a.replace(/^\[|\]$/g,""):a.replace(/\\/g,"")}function V(a){var b,c,d=a.match(Bd);for(b=0,c=d.length;c>b;b++)Ed[d[b]]?d[b]=Ed[d[b]]:d[b]=U(d[b]);return function(b){var e,f="";for(e=0;c>e;e++)f+=d[e]instanceof Function?d[e].call(b,a):d[e];return f}}
// format date using native date object
    function W(a,b){return a.isValid()?(b=X(b,a.localeData()),Dd[b]=Dd[b]||V(b),Dd[b](a)):a.localeData().invalidDate()}function X(a,b){function c(a){return b.longDateFormat(a)||a}var d=5;for(Cd.lastIndex=0;d>=0&&Cd.test(a);)a=a.replace(Cd,c),Cd.lastIndex=0,d-=1;return a}function Y(a,b,c){Wd[a]=y(b)?b:function(a,d){return a&&c?c:b}}function Z(a,b){return h(Wd,a)?Wd[a](b._strict,b._locale):new RegExp($(a))}
// Code from http://stackoverflow.com/questions/3561493/is-there-a-regexp-escape-function-in-javascript
    function $(a){return _(a.replace("\\","").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,function(a,b,c,d,e){return b||c||d||e}))}function _(a){return a.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}function aa(a,b){var c,d=b;for("string"==typeof a&&(a=[a]),"number"==typeof b&&(d=function(a,c){c[b]=t(a)}),c=0;c<a.length;c++)Xd[a[c]]=d}function ba(a,b){aa(a,function(a,c,d,e){d._w=d._w||{},b(a,d._w,d,e)})}function ca(a,b,c){null!=b&&h(Xd,a)&&Xd[a](b,c._a,c,a)}function da(a,b){return new Date(Date.UTC(a,b+1,0)).getUTCDate()}function ea(a,b){return a?c(this._months)?this._months[a.month()]:this._months[(this._months.isFormat||fe).test(b)?"format":"standalone"][a.month()]:this._months}function fa(a,b){return a?c(this._monthsShort)?this._monthsShort[a.month()]:this._monthsShort[fe.test(b)?"format":"standalone"][a.month()]:this._monthsShort}function ga(a,b,c){var d,e,f,g=a.toLocaleLowerCase();if(!this._monthsParse)for(
// this is not used
        this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],d=0;12>d;++d)f=j([2e3,d]),this._shortMonthsParse[d]=this.monthsShort(f,"").toLocaleLowerCase(),this._longMonthsParse[d]=this.months(f,"").toLocaleLowerCase();return c?"MMM"===b?(e=sd.call(this._shortMonthsParse,g),-1!==e?e:null):(e=sd.call(this._longMonthsParse,g),-1!==e?e:null):"MMM"===b?(e=sd.call(this._shortMonthsParse,g),-1!==e?e:(e=sd.call(this._longMonthsParse,g),-1!==e?e:null)):(e=sd.call(this._longMonthsParse,g),-1!==e?e:(e=sd.call(this._shortMonthsParse,g),-1!==e?e:null))}function ha(a,b,c){var d,e,f;if(this._monthsParseExact)return ga.call(this,a,b,c);
// TODO: add sorting
// Sorting makes sure if one month (or abbr) is a prefix of another
// see sorting in computeMonthsParse
        for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),d=0;12>d;d++){
// test the regex
            if(e=j([2e3,d]),c&&!this._longMonthsParse[d]&&(this._longMonthsParse[d]=new RegExp("^"+this.months(e,"").replace(".","")+"$","i"),this._shortMonthsParse[d]=new RegExp("^"+this.monthsShort(e,"").replace(".","")+"$","i")),c||this._monthsParse[d]||(f="^"+this.months(e,"")+"|^"+this.monthsShort(e,""),this._monthsParse[d]=new RegExp(f.replace(".",""),"i")),c&&"MMMM"===b&&this._longMonthsParse[d].test(a))return d;if(c&&"MMM"===b&&this._shortMonthsParse[d].test(a))return d;if(!c&&this._monthsParse[d].test(a))return d}}
// MOMENTS
    function ia(a,b){var c;if(!a.isValid())
// No op
        return a;if("string"==typeof b)if(/^\d+$/.test(b))b=t(b);else
// TODO: Another silent failure?
    if(b=a.localeData().monthsParse(b),"number"!=typeof b)return a;return c=Math.min(a.date(),da(a.year(),b)),a._d["set"+(a._isUTC?"UTC":"")+"Month"](b,c),a}function ja(b){return null!=b?(ia(this,b),a.updateOffset(this,!0),this):O(this,"Month")}function ka(){return da(this.year(),this.month())}function la(a){return this._monthsParseExact?(h(this,"_monthsRegex")||na.call(this),a?this._monthsShortStrictRegex:this._monthsShortRegex):(h(this,"_monthsShortRegex")||(this._monthsShortRegex=ie),this._monthsShortStrictRegex&&a?this._monthsShortStrictRegex:this._monthsShortRegex)}function ma(a){return this._monthsParseExact?(h(this,"_monthsRegex")||na.call(this),a?this._monthsStrictRegex:this._monthsRegex):(h(this,"_monthsRegex")||(this._monthsRegex=je),this._monthsStrictRegex&&a?this._monthsStrictRegex:this._monthsRegex)}function na(){function a(a,b){return b.length-a.length}var b,c,d=[],e=[],f=[];for(b=0;12>b;b++)c=j([2e3,b]),d.push(this.monthsShort(c,"")),e.push(this.months(c,"")),f.push(this.months(c,"")),f.push(this.monthsShort(c,""));for(
// Sorting makes sure if one month (or abbr) is a prefix of another it
// will match the longer piece.
        d.sort(a),e.sort(a),f.sort(a),b=0;12>b;b++)d[b]=_(d[b]),e[b]=_(e[b]);for(b=0;24>b;b++)f[b]=_(f[b]);this._monthsRegex=new RegExp("^("+f.join("|")+")","i"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp("^("+e.join("|")+")","i"),this._monthsShortStrictRegex=new RegExp("^("+d.join("|")+")","i")}
// HELPERS
    function oa(a){return pa(a)?366:365}function pa(a){return a%4===0&&a%100!==0||a%400===0}function qa(){return pa(this.year())}function ra(a,b,c,d,e,f,g){
//can't just apply() to create a date:
//http://stackoverflow.com/questions/181348/instantiating-a-javascript-object-by-calling-prototype-constructor-apply
        var h=new Date(a,b,c,d,e,f,g);
//the date constructor remaps years 0-99 to 1900-1999
        return 100>a&&a>=0&&isFinite(h.getFullYear())&&h.setFullYear(a),h}function sa(a){var b=new Date(Date.UTC.apply(null,arguments));
//the Date.UTC function remaps years 0-99 to 1900-1999
        return 100>a&&a>=0&&isFinite(b.getUTCFullYear())&&b.setUTCFullYear(a),b}
// start-of-first-week - start-of-year
    function ta(a,b,c){var// first-week day -- which january is always in the first week (4 for iso, 1 for other)
        d=7+b-c,
// first-week day local weekday -- which local weekday is fwd
        e=(7+sa(a,0,d).getUTCDay()-b)%7;return-e+d-1}
//http://en.wikipedia.org/wiki/ISO_week_date#Calculating_a_date_given_the_year.2C_week_number_and_weekday
    function ua(a,b,c,d,e){var f,g,h=(7+c-d)%7,i=ta(a,d,e),j=1+7*(b-1)+h+i;return 0>=j?(f=a-1,g=oa(f)+j):j>oa(a)?(f=a+1,g=j-oa(a)):(f=a,g=j),{year:f,dayOfYear:g}}function va(a,b,c){var d,e,f=ta(a.year(),b,c),g=Math.floor((a.dayOfYear()-f-1)/7)+1;return 1>g?(e=a.year()-1,d=g+wa(e,b,c)):g>wa(a.year(),b,c)?(d=g-wa(a.year(),b,c),e=a.year()+1):(e=a.year(),d=g),{week:d,year:e}}function wa(a,b,c){var d=ta(a,b,c),e=ta(a+1,b,c);return(oa(a)-d+e)/7}
// HELPERS
// LOCALES
    function xa(a){return va(a,this._week.dow,this._week.doy).week}function ya(){return this._week.dow}function za(){return this._week.doy}
// MOMENTS
    function Aa(a){var b=this.localeData().week(this);return null==a?b:this.add(7*(a-b),"d")}function Ba(a){var b=va(this,1,4).week;return null==a?b:this.add(7*(a-b),"d")}
// HELPERS
    function Ca(a,b){return"string"!=typeof a?a:isNaN(a)?(a=b.weekdaysParse(a),"number"==typeof a?a:null):parseInt(a,10)}function Da(a,b){return"string"==typeof a?b.weekdaysParse(a)%7||7:isNaN(a)?null:a}function Ea(a,b){return a?c(this._weekdays)?this._weekdays[a.day()]:this._weekdays[this._weekdays.isFormat.test(b)?"format":"standalone"][a.day()]:this._weekdays}function Fa(a){return a?this._weekdaysShort[a.day()]:this._weekdaysShort}function Ga(a){return a?this._weekdaysMin[a.day()]:this._weekdaysMin}function Ha(a,b,c){var d,e,f,g=a.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],d=0;7>d;++d)f=j([2e3,1]).day(d),this._minWeekdaysParse[d]=this.weekdaysMin(f,"").toLocaleLowerCase(),this._shortWeekdaysParse[d]=this.weekdaysShort(f,"").toLocaleLowerCase(),this._weekdaysParse[d]=this.weekdays(f,"").toLocaleLowerCase();return c?"dddd"===b?(e=sd.call(this._weekdaysParse,g),-1!==e?e:null):"ddd"===b?(e=sd.call(this._shortWeekdaysParse,g),-1!==e?e:null):(e=sd.call(this._minWeekdaysParse,g),-1!==e?e:null):"dddd"===b?(e=sd.call(this._weekdaysParse,g),-1!==e?e:(e=sd.call(this._shortWeekdaysParse,g),-1!==e?e:(e=sd.call(this._minWeekdaysParse,g),-1!==e?e:null))):"ddd"===b?(e=sd.call(this._shortWeekdaysParse,g),-1!==e?e:(e=sd.call(this._weekdaysParse,g),-1!==e?e:(e=sd.call(this._minWeekdaysParse,g),-1!==e?e:null))):(e=sd.call(this._minWeekdaysParse,g),-1!==e?e:(e=sd.call(this._weekdaysParse,g),-1!==e?e:(e=sd.call(this._shortWeekdaysParse,g),-1!==e?e:null)))}function Ia(a,b,c){var d,e,f;if(this._weekdaysParseExact)return Ha.call(this,a,b,c);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),d=0;7>d;d++){
// test the regex
        if(e=j([2e3,1]).day(d),c&&!this._fullWeekdaysParse[d]&&(this._fullWeekdaysParse[d]=new RegExp("^"+this.weekdays(e,"").replace(".",".?")+"$","i"),this._shortWeekdaysParse[d]=new RegExp("^"+this.weekdaysShort(e,"").replace(".",".?")+"$","i"),this._minWeekdaysParse[d]=new RegExp("^"+this.weekdaysMin(e,"").replace(".",".?")+"$","i")),this._weekdaysParse[d]||(f="^"+this.weekdays(e,"")+"|^"+this.weekdaysShort(e,"")+"|^"+this.weekdaysMin(e,""),this._weekdaysParse[d]=new RegExp(f.replace(".",""),"i")),c&&"dddd"===b&&this._fullWeekdaysParse[d].test(a))return d;if(c&&"ddd"===b&&this._shortWeekdaysParse[d].test(a))return d;if(c&&"dd"===b&&this._minWeekdaysParse[d].test(a))return d;if(!c&&this._weekdaysParse[d].test(a))return d}}
// MOMENTS
    function Ja(a){if(!this.isValid())return null!=a?this:NaN;var b=this._isUTC?this._d.getUTCDay():this._d.getDay();return null!=a?(a=Ca(a,this.localeData()),this.add(a-b,"d")):b}function Ka(a){if(!this.isValid())return null!=a?this:NaN;var b=(this.day()+7-this.localeData()._week.dow)%7;return null==a?b:this.add(a-b,"d")}function La(a){if(!this.isValid())return null!=a?this:NaN;
// behaves the same as moment#day except
// as a getter, returns 7 instead of 0 (1-7 range instead of 0-6)
// as a setter, sunday should belong to the previous week.
        if(null!=a){var b=Da(a,this.localeData());return this.day(this.day()%7?b:b-7)}return this.day()||7}function Ma(a){return this._weekdaysParseExact?(h(this,"_weekdaysRegex")||Pa.call(this),a?this._weekdaysStrictRegex:this._weekdaysRegex):(h(this,"_weekdaysRegex")||(this._weekdaysRegex=pe),this._weekdaysStrictRegex&&a?this._weekdaysStrictRegex:this._weekdaysRegex)}function Na(a){return this._weekdaysParseExact?(h(this,"_weekdaysRegex")||Pa.call(this),a?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(h(this,"_weekdaysShortRegex")||(this._weekdaysShortRegex=qe),this._weekdaysShortStrictRegex&&a?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)}function Oa(a){return this._weekdaysParseExact?(h(this,"_weekdaysRegex")||Pa.call(this),a?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(h(this,"_weekdaysMinRegex")||(this._weekdaysMinRegex=re),this._weekdaysMinStrictRegex&&a?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)}function Pa(){function a(a,b){return b.length-a.length}var b,c,d,e,f,g=[],h=[],i=[],k=[];for(b=0;7>b;b++)c=j([2e3,1]).day(b),d=this.weekdaysMin(c,""),e=this.weekdaysShort(c,""),f=this.weekdays(c,""),g.push(d),h.push(e),i.push(f),k.push(d),k.push(e),k.push(f);for(
// Sorting makes sure if one weekday (or abbr) is a prefix of another it
// will match the longer piece.
        g.sort(a),h.sort(a),i.sort(a),k.sort(a),b=0;7>b;b++)h[b]=_(h[b]),i[b]=_(i[b]),k[b]=_(k[b]);this._weekdaysRegex=new RegExp("^("+k.join("|")+")","i"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp("^("+i.join("|")+")","i"),this._weekdaysShortStrictRegex=new RegExp("^("+h.join("|")+")","i"),this._weekdaysMinStrictRegex=new RegExp("^("+g.join("|")+")","i")}
// FORMATTING
    function Qa(){return this.hours()%12||12}function Ra(){return this.hours()||24}function Sa(a,b){T(a,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),b)})}
// PARSING
    function Ta(a,b){return b._meridiemParse}
// LOCALES
    function Ua(a){
// IE8 Quirks Mode & IE7 Standards Mode do not allow accessing strings like arrays
// Using charAt should be more compatible.
        return"p"===(a+"").toLowerCase().charAt(0)}function Va(a,b,c){return a>11?c?"pm":"PM":c?"am":"AM"}function Wa(a){return a?a.toLowerCase().replace("_","-"):a}
// pick the locale from the array
// try ['en-au', 'en-gb'] as 'en-au', 'en-gb', 'en', as in move through the list trying each
// substring from most specific to least, but move to the next array item if it's a more specific variant than the current root
    function Xa(a){for(var b,c,d,e,f=0;f<a.length;){for(e=Wa(a[f]).split("-"),b=e.length,c=Wa(a[f+1]),c=c?c.split("-"):null;b>0;){if(d=Ya(e.slice(0,b).join("-")))return d;if(c&&c.length>=b&&u(e,c,!0)>=b-1)
//the next array item is better than a shallower substring of this one
        break;b--}f++}return null}function Ya(a){var b=null;
// TODO: Find a better way to register and load all the locales in Node
        if(!we[a]&&"undefined"!=typeof module&&module&&module.exports)try{b=se._abbr,require("./locale/"+a),
// because defineLocale currently also sets the global locale, we
// want to undo that for lazy loaded locales
            Za(b)}catch(c){}return we[a]}
// This function will load locale and then set the global locale.  If
// no arguments are passed in, it will simply return the current global
// locale key.
    function Za(a,b){var c;
// moment.duration._locale = moment._locale = data;
        return a&&(c=o(b)?ab(a):$a(a,b),c&&(se=c)),se._abbr}function $a(a,b){if(null!==b){var c=ve;
// treat as if there is no base config
// backwards compat for now: also set the locale
        return b.abbr=a,null!=we[a]?(x("defineLocaleOverride","use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info."),c=we[a]._config):null!=b.parentLocale&&(null!=we[b.parentLocale]?c=we[b.parentLocale]._config:x("parentLocaleUndefined","specified parentLocale is not defined yet. See http://momentjs.com/guides/#/warnings/parent-locale/")),we[a]=new B(A(c,b)),Za(a),we[a]}
// useful for testing
        return delete we[a],null}function _a(a,b){if(null!=b){var c,d=ve;
// MERGE
        null!=we[a]&&(d=we[a]._config),b=A(d,b),c=new B(b),c.parentLocale=we[a],we[a]=c,
// backwards compat for now: also set the locale
            Za(a)}else
// pass null for config to unupdate, useful for tests
        null!=we[a]&&(null!=we[a].parentLocale?we[a]=we[a].parentLocale:null!=we[a]&&delete we[a]);return we[a]}
// returns locale data
    function ab(a){var b;if(a&&a._locale&&a._locale._abbr&&(a=a._locale._abbr),!a)return se;if(!c(a)){if(b=Ya(a))return b;a=[a]}return Xa(a)}function bb(){return rd(we)}function cb(a){var b,c=a._a;return c&&-2===l(a).overflow&&(b=c[Zd]<0||c[Zd]>11?Zd:c[$d]<1||c[$d]>da(c[Yd],c[Zd])?$d:c[_d]<0||c[_d]>24||24===c[_d]&&(0!==c[ae]||0!==c[be]||0!==c[ce])?_d:c[ae]<0||c[ae]>59?ae:c[be]<0||c[be]>59?be:c[ce]<0||c[ce]>999?ce:-1,l(a)._overflowDayOfYear&&(Yd>b||b>$d)&&(b=$d),l(a)._overflowWeeks&&-1===b&&(b=de),l(a)._overflowWeekday&&-1===b&&(b=ee),l(a).overflow=b),a}
// date from iso format
    function db(a){var b,c,d,e,f,g,h=a._i,i=xe.exec(h)||ye.exec(h);if(i){for(l(a).iso=!0,b=0,c=Ae.length;c>b;b++)if(Ae[b][1].exec(i[1])){e=Ae[b][0],d=Ae[b][2]!==!1;break}if(null==e)return void(a._isValid=!1);if(i[3]){for(b=0,c=Be.length;c>b;b++)if(Be[b][1].exec(i[3])){
// match[2] should be 'T' or space
        f=(i[2]||" ")+Be[b][0];break}if(null==f)return void(a._isValid=!1)}if(!d&&null!=f)return void(a._isValid=!1);if(i[4]){if(!ze.exec(i[4]))return void(a._isValid=!1);g="Z"}a._f=e+(f||"")+(g||""),jb(a)}else a._isValid=!1}
// date from iso format or fallback
    function eb(b){var c=Ce.exec(b._i);return null!==c?void(b._d=new Date(+c[1])):(db(b),void(b._isValid===!1&&(delete b._isValid,a.createFromInputFallback(b))))}
// Pick the first defined of two or three arguments.
    function fb(a,b,c){return null!=a?a:null!=b?b:c}function gb(b){
// hooks is actually the exported moment object
        var c=new Date(a.now());return b._useUTC?[c.getUTCFullYear(),c.getUTCMonth(),c.getUTCDate()]:[c.getFullYear(),c.getMonth(),c.getDate()]}
// convert an array to a date.
// the array should mirror the parameters below
// note: all values past the year are optional and will default to the lowest possible value.
// [year, month, day , hour, minute, second, millisecond]
    function hb(a){var b,c,d,e,f=[];if(!a._d){
// Default to current date.
// * if no year, month, day of month are given, default to today
// * if day of month is given, default month and year
// * if month is given, default only year
// * if year is given, don't default anything
        for(d=gb(a),a._w&&null==a._a[$d]&&null==a._a[Zd]&&ib(a),a._dayOfYear&&(e=fb(a._a[Yd],d[Yd]),a._dayOfYear>oa(e)&&(l(a)._overflowDayOfYear=!0),c=sa(e,0,a._dayOfYear),a._a[Zd]=c.getUTCMonth(),a._a[$d]=c.getUTCDate()),b=0;3>b&&null==a._a[b];++b)a._a[b]=f[b]=d[b];
// Zero out whatever was not defaulted, including time
        for(;7>b;b++)a._a[b]=f[b]=null==a._a[b]?2===b?1:0:a._a[b];
// Check for 24:00:00.000
        24===a._a[_d]&&0===a._a[ae]&&0===a._a[be]&&0===a._a[ce]&&(a._nextDay=!0,a._a[_d]=0),a._d=(a._useUTC?sa:ra).apply(null,f),
// Apply timezone offset from input. The actual utcOffset can be changed
// with parseZone.
        null!=a._tzm&&a._d.setUTCMinutes(a._d.getUTCMinutes()-a._tzm),a._nextDay&&(a._a[_d]=24)}}function ib(a){var b,c,d,e,f,g,h,i;b=a._w,null!=b.GG||null!=b.W||null!=b.E?(f=1,g=4,c=fb(b.GG,a._a[Yd],va(rb(),1,4).year),d=fb(b.W,1),e=fb(b.E,1),(1>e||e>7)&&(i=!0)):(f=a._locale._week.dow,g=a._locale._week.doy,c=fb(b.gg,a._a[Yd],va(rb(),f,g).year),d=fb(b.w,1),null!=b.d?(e=b.d,(0>e||e>6)&&(i=!0)):null!=b.e?(e=b.e+f,(b.e<0||b.e>6)&&(i=!0)):e=f),1>d||d>wa(c,f,g)?l(a)._overflowWeeks=!0:null!=i?l(a)._overflowWeekday=!0:(h=ua(c,d,e,f,g),a._a[Yd]=h.year,a._dayOfYear=h.dayOfYear)}
// date from string and format string
    function jb(b){
// TODO: Move this to another part of the creation flow to prevent circular deps
        if(b._f===a.ISO_8601)return void db(b);b._a=[],l(b).empty=!0;
// This array is used to make a Date, either with `new Date` or `Date.UTC`
        var c,d,e,f,g,h=""+b._i,i=h.length,j=0;for(e=X(b._f,b._locale).match(Bd)||[],c=0;c<e.length;c++)f=e[c],d=(h.match(Z(f,b))||[])[0],d&&(g=h.substr(0,h.indexOf(d)),g.length>0&&l(b).unusedInput.push(g),h=h.slice(h.indexOf(d)+d.length),j+=d.length),Ed[f]?(d?l(b).empty=!1:l(b).unusedTokens.push(f),ca(f,d,b)):b._strict&&!d&&l(b).unusedTokens.push(f);
// add remaining unparsed input length to the string
        l(b).charsLeftOver=i-j,h.length>0&&l(b).unusedInput.push(h),
// clear _12h flag if hour is <= 12
        b._a[_d]<=12&&l(b).bigHour===!0&&b._a[_d]>0&&(l(b).bigHour=void 0),l(b).parsedDateParts=b._a.slice(0),l(b).meridiem=b._meridiem,
// handle meridiem
            b._a[_d]=kb(b._locale,b._a[_d],b._meridiem),hb(b),cb(b)}function kb(a,b,c){var d;
// Fallback
        return null==c?b:null!=a.meridiemHour?a.meridiemHour(b,c):null!=a.isPM?(d=a.isPM(c),d&&12>b&&(b+=12),d||12!==b||(b=0),b):b}
// date from string and array of format strings
    function lb(a){var b,c,d,e,f;if(0===a._f.length)return l(a).invalidFormat=!0,void(a._d=new Date(NaN));for(e=0;e<a._f.length;e++)f=0,b=p({},a),null!=a._useUTC&&(b._useUTC=a._useUTC),b._f=a._f[e],jb(b),m(b)&&(f+=l(b).charsLeftOver,f+=10*l(b).unusedTokens.length,l(b).score=f,(null==d||d>f)&&(d=f,c=b));i(a,c||b)}function mb(a){if(!a._d){var b=K(a._i);a._a=g([b.year,b.month,b.day||b.date,b.hour,b.minute,b.second,b.millisecond],function(a){return a&&parseInt(a,10)}),hb(a)}}function nb(a){var b=new q(cb(ob(a)));
// Adding is smart enough around DST
        return b._nextDay&&(b.add(1,"d"),b._nextDay=void 0),b}function ob(a){var b=a._i,d=a._f;return a._locale=a._locale||ab(a._l),null===b||void 0===d&&""===b?n({nullInput:!0}):("string"==typeof b&&(a._i=b=a._locale.preparse(b)),r(b)?new q(cb(b)):(c(d)?lb(a):f(b)?a._d=b:d?jb(a):pb(a),m(a)||(a._d=null),a))}function pb(b){var d=b._i;void 0===d?b._d=new Date(a.now()):f(d)?b._d=new Date(d.valueOf()):"string"==typeof d?eb(b):c(d)?(b._a=g(d.slice(0),function(a){return parseInt(a,10)}),hb(b)):"object"==typeof d?mb(b):"number"==typeof d?
// from milliseconds
        b._d=new Date(d):a.createFromInputFallback(b)}function qb(a,b,f,g,h){var i={};
// object construction must be done this way.
// https://github.com/moment/moment/issues/1423
        return"boolean"==typeof f&&(g=f,f=void 0),(d(a)&&e(a)||c(a)&&0===a.length)&&(a=void 0),i._isAMomentObject=!0,i._useUTC=i._isUTC=h,i._l=f,i._i=a,i._f=b,i._strict=g,nb(i)}function rb(a,b,c,d){return qb(a,b,c,d,!1)}
// Pick a moment m from moments so that m[fn](other) is true for all
// other. This relies on the function fn to be transitive.
//
// moments should either be an array of moment objects or an array, whose
// first element is an array of moment objects.
    function sb(a,b){var d,e;if(1===b.length&&c(b[0])&&(b=b[0]),!b.length)return rb();for(d=b[0],e=1;e<b.length;++e)b[e].isValid()&&!b[e][a](d)||(d=b[e]);return d}
// TODO: Use [].sort instead?
    function tb(){var a=[].slice.call(arguments,0);return sb("isBefore",a)}function ub(){var a=[].slice.call(arguments,0);return sb("isAfter",a)}function vb(a){var b=K(a),c=b.year||0,d=b.quarter||0,e=b.month||0,f=b.week||0,g=b.day||0,h=b.hour||0,i=b.minute||0,j=b.second||0,k=b.millisecond||0;
// representation for dateAddRemove
        this._milliseconds=+k+1e3*j+// 1000
            6e4*i+// 1000 * 60
            1e3*h*60*60,//using 1000 * 60 * 60 instead of 36e5 to avoid floating point rounding errors https://github.com/moment/moment/issues/2978
// Because of dateAddRemove treats 24 hours as different from a
// day when working around DST, we need to store them separately
            this._days=+g+7*f,
// It is impossible translate months into days without knowing
// which months you are are talking about, so we have to store
// it separately.
            this._months=+e+3*d+12*c,this._data={},this._locale=ab(),this._bubble()}function wb(a){return a instanceof vb}function xb(a){return 0>a?-1*Math.round(-1*a):Math.round(a)}
// FORMATTING
    function yb(a,b){T(a,0,0,function(){var a=this.utcOffset(),c="+";return 0>a&&(a=-a,c="-"),c+S(~~(a/60),2)+b+S(~~a%60,2)})}function zb(a,b){var c=(b||"").match(a)||[],d=c[c.length-1]||[],e=(d+"").match(Ge)||["-",0,0],f=+(60*e[1])+t(e[2]);return"+"===e[0]?f:-f}
// Return a moment from input, that is local/utc/zone equivalent to model.
    function Ab(b,c){var d,e;
// Use low-level api, because this fn is low-level api.
        return c._isUTC?(d=c.clone(),e=(r(b)||f(b)?b.valueOf():rb(b).valueOf())-d.valueOf(),d._d.setTime(d._d.valueOf()+e),a.updateOffset(d,!1),d):rb(b).local()}function Bb(a){
// On Firefox.24 Date#getTimezoneOffset returns a floating point.
// https://github.com/moment/moment/pull/1871
        return 15*-Math.round(a._d.getTimezoneOffset()/15)}
// MOMENTS
// keepLocalTime = true means only change the timezone, without
// affecting the local hour. So 5:31:26 +0300 --[utcOffset(2, true)]-->
// 5:31:26 +0200 It is possible that 5:31:26 doesn't exist with offset
// +0200, so we adjust the time as needed, to be valid.
//
// Keeping the time actually adds/subtracts (one hour)
// from the actual represented time. That is why we call updateOffset
// a second time. In case it wants us to change the offset again
// _changeInProgress == true case, then we have to adjust, because
// there is no such time in the given timezone.
    function Cb(b,c){var d,e=this._offset||0;return this.isValid()?null!=b?("string"==typeof b?b=zb(Td,b):Math.abs(b)<16&&(b=60*b),!this._isUTC&&c&&(d=Bb(this)),this._offset=b,this._isUTC=!0,null!=d&&this.add(d,"m"),e!==b&&(!c||this._changeInProgress?Sb(this,Nb(b-e,"m"),1,!1):this._changeInProgress||(this._changeInProgress=!0,a.updateOffset(this,!0),this._changeInProgress=null)),this):this._isUTC?e:Bb(this):null!=b?this:NaN}function Db(a,b){return null!=a?("string"!=typeof a&&(a=-a),this.utcOffset(a,b),this):-this.utcOffset()}function Eb(a){return this.utcOffset(0,a)}function Fb(a){return this._isUTC&&(this.utcOffset(0,a),this._isUTC=!1,a&&this.subtract(Bb(this),"m")),this}function Gb(){if(this._tzm)this.utcOffset(this._tzm);else if("string"==typeof this._i){var a=zb(Sd,this._i);0===a?this.utcOffset(0,!0):this.utcOffset(zb(Sd,this._i))}return this}function Hb(a){return this.isValid()?(a=a?rb(a).utcOffset():0,(this.utcOffset()-a)%60===0):!1}function Ib(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()}function Jb(){if(!o(this._isDSTShifted))return this._isDSTShifted;var a={};if(p(a,this),a=ob(a),a._a){var b=a._isUTC?j(a._a):rb(a._a);this._isDSTShifted=this.isValid()&&u(a._a,b.toArray())>0}else this._isDSTShifted=!1;return this._isDSTShifted}function Kb(){return this.isValid()?!this._isUTC:!1}function Lb(){return this.isValid()?this._isUTC:!1}function Mb(){return this.isValid()?this._isUTC&&0===this._offset:!1}function Nb(a,b){var c,d,e,f=a,
// matching against regexp is expensive, do it on demand
        g=null;// checks for null or undefined
        return wb(a)?f={ms:a._milliseconds,d:a._days,M:a._months}:"number"==typeof a?(f={},b?f[b]=a:f.milliseconds=a):(g=He.exec(a))?(c="-"===g[1]?-1:1,f={y:0,d:t(g[$d])*c,h:t(g[_d])*c,m:t(g[ae])*c,s:t(g[be])*c,ms:t(xb(1e3*g[ce]))*c}):(g=Ie.exec(a))?(c="-"===g[1]?-1:1,f={y:Ob(g[2],c),M:Ob(g[3],c),w:Ob(g[4],c),d:Ob(g[5],c),h:Ob(g[6],c),m:Ob(g[7],c),s:Ob(g[8],c)}):null==f?f={}:"object"==typeof f&&("from"in f||"to"in f)&&(e=Qb(rb(f.from),rb(f.to)),f={},f.ms=e.milliseconds,f.M=e.months),d=new vb(f),wb(a)&&h(a,"_locale")&&(d._locale=a._locale),d}function Ob(a,b){
// We'd normally use ~~inp for this, but unfortunately it also
// converts floats to ints.
// inp may be undefined, so careful calling replace on it.
        var c=a&&parseFloat(a.replace(",","."));
// apply sign while we're at it
        return(isNaN(c)?0:c)*b}function Pb(a,b){var c={milliseconds:0,months:0};return c.months=b.month()-a.month()+12*(b.year()-a.year()),a.clone().add(c.months,"M").isAfter(b)&&--c.months,c.milliseconds=+b-+a.clone().add(c.months,"M"),c}function Qb(a,b){var c;return a.isValid()&&b.isValid()?(b=Ab(b,a),a.isBefore(b)?c=Pb(a,b):(c=Pb(b,a),c.milliseconds=-c.milliseconds,c.months=-c.months),c):{milliseconds:0,months:0}}
// TODO: remove 'name' arg after deprecation is removed
    function Rb(a,b){return function(c,d){var e,f;
//invert the arguments, but complain about it
        return null===d||isNaN(+d)||(x(b,"moment()."+b+"(period, number) is deprecated. Please use moment()."+b+"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info."),f=c,c=d,d=f),c="string"==typeof c?+c:c,e=Nb(c,d),Sb(this,e,a),this}}function Sb(b,c,d,e){var f=c._milliseconds,g=xb(c._days),h=xb(c._months);b.isValid()&&(e=null==e?!0:e,f&&b._d.setTime(b._d.valueOf()+f*d),g&&P(b,"Date",O(b,"Date")+g*d),h&&ia(b,O(b,"Month")+h*d),e&&a.updateOffset(b,g||h))}function Tb(a,b){var c=a.diff(b,"days",!0);return-6>c?"sameElse":-1>c?"lastWeek":0>c?"lastDay":1>c?"sameDay":2>c?"nextDay":7>c?"nextWeek":"sameElse"}function Ub(b,c){
// We want to compare the start of today, vs this.
// Getting start-of-today depends on whether we're local/utc/offset or not.
        var d=b||rb(),e=Ab(d,this).startOf("day"),f=a.calendarFormat(this,e)||"sameElse",g=c&&(y(c[f])?c[f].call(this,d):c[f]);return this.format(g||this.localeData().calendar(f,this,rb(d)))}function Vb(){return new q(this)}function Wb(a,b){var c=r(a)?a:rb(a);return this.isValid()&&c.isValid()?(b=J(o(b)?"millisecond":b),"millisecond"===b?this.valueOf()>c.valueOf():c.valueOf()<this.clone().startOf(b).valueOf()):!1}function Xb(a,b){var c=r(a)?a:rb(a);return this.isValid()&&c.isValid()?(b=J(o(b)?"millisecond":b),"millisecond"===b?this.valueOf()<c.valueOf():this.clone().endOf(b).valueOf()<c.valueOf()):!1}function Yb(a,b,c,d){return d=d||"()",("("===d[0]?this.isAfter(a,c):!this.isBefore(a,c))&&(")"===d[1]?this.isBefore(b,c):!this.isAfter(b,c))}function Zb(a,b){var c,d=r(a)?a:rb(a);return this.isValid()&&d.isValid()?(b=J(b||"millisecond"),"millisecond"===b?this.valueOf()===d.valueOf():(c=d.valueOf(),this.clone().startOf(b).valueOf()<=c&&c<=this.clone().endOf(b).valueOf())):!1}function $b(a,b){return this.isSame(a,b)||this.isAfter(a,b)}function _b(a,b){return this.isSame(a,b)||this.isBefore(a,b)}function ac(a,b,c){var d,e,f,g;// 1000
// 1000 * 60
// 1000 * 60 * 60
// 1000 * 60 * 60 * 24, negate dst
// 1000 * 60 * 60 * 24 * 7, negate dst
        return this.isValid()?(d=Ab(a,this),d.isValid()?(e=6e4*(d.utcOffset()-this.utcOffset()),b=J(b),"year"===b||"month"===b||"quarter"===b?(g=bc(this,d),"quarter"===b?g/=3:"year"===b&&(g/=12)):(f=this-d,g="second"===b?f/1e3:"minute"===b?f/6e4:"hour"===b?f/36e5:"day"===b?(f-e)/864e5:"week"===b?(f-e)/6048e5:f),c?g:s(g)):NaN):NaN}function bc(a,b){
// difference in months
        var c,d,e=12*(b.year()-a.year())+(b.month()-a.month()),
// b is in (anchor - 1 month, anchor + 1 month)
            f=a.clone().add(e,"months");
//check for negative zero, return zero if negative zero
// linear across the month
// linear across the month
        return 0>b-f?(c=a.clone().add(e-1,"months"),d=(b-f)/(f-c)):(c=a.clone().add(e+1,"months"),d=(b-f)/(c-f)),-(e+d)||0}function cc(){return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")}function dc(){var a=this.clone().utc();return 0<a.year()&&a.year()<=9999?y(Date.prototype.toISOString)?this.toDate().toISOString():W(a,"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]"):W(a,"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]")}function ec(b){b||(b=this.isUtc()?a.defaultFormatUtc:a.defaultFormat);var c=W(this,b);return this.localeData().postformat(c)}function fc(a,b){return this.isValid()&&(r(a)&&a.isValid()||rb(a).isValid())?Nb({to:this,from:a}).locale(this.locale()).humanize(!b):this.localeData().invalidDate()}function gc(a){return this.from(rb(),a)}function hc(a,b){return this.isValid()&&(r(a)&&a.isValid()||rb(a).isValid())?Nb({from:this,to:a}).locale(this.locale()).humanize(!b):this.localeData().invalidDate()}function ic(a){return this.to(rb(),a)}
// If passed a locale key, it will set the locale for this
// instance.  Otherwise, it will return the locale configuration
// variables for this instance.
    function jc(a){var b;return void 0===a?this._locale._abbr:(b=ab(a),null!=b&&(this._locale=b),this)}function kc(){return this._locale}function lc(a){
// the following switch intentionally omits break keywords
// to utilize falling through the cases.
        switch(a=J(a)){case"year":this.month(0);/* falls through */
            case"quarter":case"month":this.date(1);/* falls through */
            case"week":case"isoWeek":case"day":case"date":this.hours(0);/* falls through */
            case"hour":this.minutes(0);/* falls through */
            case"minute":this.seconds(0);/* falls through */
            case"second":this.milliseconds(0)}
// weeks are a special case
// quarters are also special
        return"week"===a&&this.weekday(0),"isoWeek"===a&&this.isoWeekday(1),"quarter"===a&&this.month(3*Math.floor(this.month()/3)),this}function mc(a){
// 'date' is an alias for 'day', so it should be considered as such.
        return a=J(a),void 0===a||"millisecond"===a?this:("date"===a&&(a="day"),this.startOf(a).add(1,"isoWeek"===a?"week":a).subtract(1,"ms"))}function nc(){return this._d.valueOf()-6e4*(this._offset||0)}function oc(){return Math.floor(this.valueOf()/1e3)}function pc(){return new Date(this.valueOf())}function qc(){var a=this;return[a.year(),a.month(),a.date(),a.hour(),a.minute(),a.second(),a.millisecond()]}function rc(){var a=this;return{years:a.year(),months:a.month(),date:a.date(),hours:a.hours(),minutes:a.minutes(),seconds:a.seconds(),milliseconds:a.milliseconds()}}function sc(){
// new Date(NaN).toJSON() === null
        return this.isValid()?this.toISOString():null}function tc(){return m(this)}function uc(){return i({},l(this))}function vc(){return l(this).overflow}function wc(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}}function xc(a,b){T(0,[a,a.length],0,b)}
// MOMENTS
    function yc(a){return Cc.call(this,a,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy)}function zc(a){return Cc.call(this,a,this.isoWeek(),this.isoWeekday(),1,4)}function Ac(){return wa(this.year(),1,4)}function Bc(){var a=this.localeData()._week;return wa(this.year(),a.dow,a.doy)}function Cc(a,b,c,d,e){var f;return null==a?va(this,d,e).year:(f=wa(a,d,e),b>f&&(b=f),Dc.call(this,a,b,c,d,e))}function Dc(a,b,c,d,e){var f=ua(a,b,c,d,e),g=sa(f.year,0,f.dayOfYear);return this.year(g.getUTCFullYear()),this.month(g.getUTCMonth()),this.date(g.getUTCDate()),this}
// MOMENTS
    function Ec(a){return null==a?Math.ceil((this.month()+1)/3):this.month(3*(a-1)+this.month()%3)}
// HELPERS
// MOMENTS
    function Fc(a){var b=Math.round((this.clone().startOf("day")-this.clone().startOf("year"))/864e5)+1;return null==a?b:this.add(a-b,"d")}function Gc(a,b){b[ce]=t(1e3*("0."+a))}
// MOMENTS
    function Hc(){return this._isUTC?"UTC":""}function Ic(){return this._isUTC?"Coordinated Universal Time":""}function Jc(a){return rb(1e3*a)}function Kc(){return rb.apply(null,arguments).parseZone()}function Lc(a){return a}function Mc(a,b,c,d){var e=ab(),f=j().set(d,b);return e[c](f,a)}function Nc(a,b,c){if("number"==typeof a&&(b=a,a=void 0),a=a||"",null!=b)return Mc(a,b,c,"month");var d,e=[];for(d=0;12>d;d++)e[d]=Mc(a,d,c,"month");return e}
// ()
// (5)
// (fmt, 5)
// (fmt)
// (true)
// (true, 5)
// (true, fmt, 5)
// (true, fmt)
    function Oc(a,b,c,d){"boolean"==typeof a?("number"==typeof b&&(c=b,b=void 0),b=b||""):(b=a,c=b,a=!1,"number"==typeof b&&(c=b,b=void 0),b=b||"");var e=ab(),f=a?e._week.dow:0;if(null!=c)return Mc(b,(c+f)%7,d,"day");var g,h=[];for(g=0;7>g;g++)h[g]=Mc(b,(g+f)%7,d,"day");return h}function Pc(a,b){return Nc(a,b,"months")}function Qc(a,b){return Nc(a,b,"monthsShort")}function Rc(a,b,c){return Oc(a,b,c,"weekdays")}function Sc(a,b,c){return Oc(a,b,c,"weekdaysShort")}function Tc(a,b,c){return Oc(a,b,c,"weekdaysMin")}function Uc(){var a=this._data;return this._milliseconds=Ue(this._milliseconds),this._days=Ue(this._days),this._months=Ue(this._months),a.milliseconds=Ue(a.milliseconds),a.seconds=Ue(a.seconds),a.minutes=Ue(a.minutes),a.hours=Ue(a.hours),a.months=Ue(a.months),a.years=Ue(a.years),this}function Vc(a,b,c,d){var e=Nb(b,c);return a._milliseconds+=d*e._milliseconds,a._days+=d*e._days,a._months+=d*e._months,a._bubble()}
// supports only 2.0-style add(1, 's') or add(duration)
    function Wc(a,b){return Vc(this,a,b,1)}
// supports only 2.0-style subtract(1, 's') or subtract(duration)
    function Xc(a,b){return Vc(this,a,b,-1)}function Yc(a){return 0>a?Math.floor(a):Math.ceil(a)}function Zc(){var a,b,c,d,e,f=this._milliseconds,g=this._days,h=this._months,i=this._data;
// if we have a mix of positive and negative values, bubble down first
// check: https://github.com/moment/moment/issues/2166
// The following code bubbles up values, see the tests for
// examples of what that means.
// convert days to months
// 12 months -> 1 year
        return f>=0&&g>=0&&h>=0||0>=f&&0>=g&&0>=h||(f+=864e5*Yc(_c(h)+g),g=0,h=0),i.milliseconds=f%1e3,a=s(f/1e3),i.seconds=a%60,b=s(a/60),i.minutes=b%60,c=s(b/60),i.hours=c%24,g+=s(c/24),e=s($c(g)),h+=e,g-=Yc(_c(e)),d=s(h/12),h%=12,i.days=g,i.months=h,i.years=d,this}function $c(a){
// 400 years have 146097 days (taking into account leap year rules)
// 400 years have 12 months === 4800
        return 4800*a/146097}function _c(a){
// the reverse of daysToMonths
        return 146097*a/4800}function ad(a){var b,c,d=this._milliseconds;if(a=J(a),"month"===a||"year"===a)return b=this._days+d/864e5,c=this._months+$c(b),"month"===a?c:c/12;switch(b=this._days+Math.round(_c(this._months)),a){case"week":return b/7+d/6048e5;case"day":return b+d/864e5;case"hour":return 24*b+d/36e5;case"minute":return 1440*b+d/6e4;case"second":return 86400*b+d/1e3;
// Math.floor prevents floating point math errors here
        case"millisecond":return Math.floor(864e5*b)+d;default:throw new Error("Unknown unit "+a)}}
// TODO: Use this.as('ms')?
    function bd(){return this._milliseconds+864e5*this._days+this._months%12*2592e6+31536e6*t(this._months/12)}function cd(a){return function(){return this.as(a)}}function dd(a){return a=J(a),this[a+"s"]()}function ed(a){return function(){return this._data[a]}}function fd(){return s(this.days()/7)}
// helper function for moment.fn.from, moment.fn.fromNow, and moment.duration.fn.humanize
    function gd(a,b,c,d,e){return e.relativeTime(b||1,!!c,a,d)}function hd(a,b,c){var d=Nb(a).abs(),e=jf(d.as("s")),f=jf(d.as("m")),g=jf(d.as("h")),h=jf(d.as("d")),i=jf(d.as("M")),j=jf(d.as("y")),k=e<kf.s&&["s",e]||1>=f&&["m"]||f<kf.m&&["mm",f]||1>=g&&["h"]||g<kf.h&&["hh",g]||1>=h&&["d"]||h<kf.d&&["dd",h]||1>=i&&["M"]||i<kf.M&&["MM",i]||1>=j&&["y"]||["yy",j];return k[2]=b,k[3]=+a>0,k[4]=c,gd.apply(null,k)}
// This function allows you to set the rounding function for relative time strings
    function id(a){return void 0===a?jf:"function"==typeof a?(jf=a,!0):!1}
// This function allows you to set a threshold for relative time strings
    function jd(a,b){return void 0===kf[a]?!1:void 0===b?kf[a]:(kf[a]=b,!0)}function kd(a){var b=this.localeData(),c=hd(this,!a,b);return a&&(c=b.pastFuture(+this,c)),b.postformat(c)}function ld(){
// for ISO strings we do not use the normal bubbling rules:
//  * milliseconds bubble up until they become hours
//  * days do not bubble at all
//  * months bubble up until they become years
// This is because there is no context-free conversion between hours and days
// (think of clock changes)
// and also not between days and months (28-31 days per month)
        var a,b,c,d=lf(this._milliseconds)/1e3,e=lf(this._days),f=lf(this._months);a=s(d/60),b=s(a/60),d%=60,a%=60,c=s(f/12),f%=12;
// inspired by https://github.com/dordille/moment-isoduration/blob/master/moment.isoduration.js
        var g=c,h=f,i=e,j=b,k=a,l=d,m=this.asSeconds();return m?(0>m?"-":"")+"P"+(g?g+"Y":"")+(h?h+"M":"")+(i?i+"D":"")+(j||k||l?"T":"")+(j?j+"H":"")+(k?k+"M":"")+(l?l+"S":""):"P0D"}var md,nd;nd=Array.prototype.some?Array.prototype.some:function(a){for(var b=Object(this),c=b.length>>>0,d=0;c>d;d++)if(d in b&&a.call(this,b[d],d,b))return!0;return!1};
// Plugins that add properties should also add the key here (null value),
// so we can properly clone ourselves.
    var od=a.momentProperties=[],pd=!1,qd={};a.suppressDeprecationWarnings=!1,a.deprecationHandler=null;var rd;rd=Object.keys?Object.keys:function(a){var b,c=[];for(b in a)h(a,b)&&c.push(b);return c};var sd,td={sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},ud={LTS:"h:mm:ss A",LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"},vd="Invalid date",wd="%d",xd=/\d{1,2}/,yd={future:"in %s",past:"%s ago",s:"a few seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},zd={},Ad={},Bd=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,Cd=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,Dd={},Ed={},Fd=/\d/,Gd=/\d\d/,Hd=/\d{3}/,Id=/\d{4}/,Jd=/[+-]?\d{6}/,Kd=/\d\d?/,Ld=/\d\d\d\d?/,Md=/\d\d\d\d\d\d?/,Nd=/\d{1,3}/,Od=/\d{1,4}/,Pd=/[+-]?\d{1,6}/,Qd=/\d+/,Rd=/[+-]?\d+/,Sd=/Z|[+-]\d\d:?\d\d/gi,Td=/Z|[+-]\d\d(?::?\d\d)?/gi,Ud=/[+-]?\d+(\.\d{1,3})?/,Vd=/[0-9]*['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+|[\u0600-\u06FF\/]+(\s*?[\u0600-\u06FF]+){1,2}/i,Wd={},Xd={},Yd=0,Zd=1,$d=2,_d=3,ae=4,be=5,ce=6,de=7,ee=8;sd=Array.prototype.indexOf?Array.prototype.indexOf:function(a){
// I know
        var b;for(b=0;b<this.length;++b)if(this[b]===a)return b;return-1},T("M",["MM",2],"Mo",function(){return this.month()+1}),T("MMM",0,0,function(a){return this.localeData().monthsShort(this,a)}),T("MMMM",0,0,function(a){return this.localeData().months(this,a)}),I("month","M"),L("month",8),Y("M",Kd),Y("MM",Kd,Gd),Y("MMM",function(a,b){return b.monthsShortRegex(a)}),Y("MMMM",function(a,b){return b.monthsRegex(a)}),aa(["M","MM"],function(a,b){b[Zd]=t(a)-1}),aa(["MMM","MMMM"],function(a,b,c,d){var e=c._locale.monthsParse(a,d,c._strict);null!=e?b[Zd]=e:l(c).invalidMonth=a});
// LOCALES
    var fe=/D[oD]?(\[[^\[\]]*\]|\s+)+MMMM?/,ge="January_February_March_April_May_June_July_August_September_October_November_December".split("_"),he="Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),ie=Vd,je=Vd;
// FORMATTING
    T("Y",0,0,function(){var a=this.year();return 9999>=a?""+a:"+"+a}),T(0,["YY",2],0,function(){return this.year()%100}),T(0,["YYYY",4],0,"year"),T(0,["YYYYY",5],0,"year"),T(0,["YYYYYY",6,!0],0,"year"),
// ALIASES
        I("year","y"),
// PRIORITIES
        L("year",1),
// PARSING
        Y("Y",Rd),Y("YY",Kd,Gd),Y("YYYY",Od,Id),Y("YYYYY",Pd,Jd),Y("YYYYYY",Pd,Jd),aa(["YYYYY","YYYYYY"],Yd),aa("YYYY",function(b,c){c[Yd]=2===b.length?a.parseTwoDigitYear(b):t(b)}),aa("YY",function(b,c){c[Yd]=a.parseTwoDigitYear(b)}),aa("Y",function(a,b){b[Yd]=parseInt(a,10)}),
// HOOKS
        a.parseTwoDigitYear=function(a){return t(a)+(t(a)>68?1900:2e3)};
// MOMENTS
    var ke=N("FullYear",!0);
// FORMATTING
    T("w",["ww",2],"wo","week"),T("W",["WW",2],"Wo","isoWeek"),
// ALIASES
        I("week","w"),I("isoWeek","W"),
// PRIORITIES
        L("week",5),L("isoWeek",5),
// PARSING
        Y("w",Kd),Y("ww",Kd,Gd),Y("W",Kd),Y("WW",Kd,Gd),ba(["w","ww","W","WW"],function(a,b,c,d){b[d.substr(0,1)]=t(a)});var le={dow:0,// Sunday is the first day of the week.
        doy:6};
// FORMATTING
    T("d",0,"do","day"),T("dd",0,0,function(a){return this.localeData().weekdaysMin(this,a)}),T("ddd",0,0,function(a){return this.localeData().weekdaysShort(this,a)}),T("dddd",0,0,function(a){return this.localeData().weekdays(this,a)}),T("e",0,0,"weekday"),T("E",0,0,"isoWeekday"),
// ALIASES
        I("day","d"),I("weekday","e"),I("isoWeekday","E"),
// PRIORITY
        L("day",11),L("weekday",11),L("isoWeekday",11),
// PARSING
        Y("d",Kd),Y("e",Kd),Y("E",Kd),Y("dd",function(a,b){return b.weekdaysMinRegex(a)}),Y("ddd",function(a,b){return b.weekdaysShortRegex(a)}),Y("dddd",function(a,b){return b.weekdaysRegex(a)}),ba(["dd","ddd","dddd"],function(a,b,c,d){var e=c._locale.weekdaysParse(a,d,c._strict);
// if we didn't get a weekday name, mark the date as invalid
        null!=e?b.d=e:l(c).invalidWeekday=a}),ba(["d","e","E"],function(a,b,c,d){b[d]=t(a)});
// LOCALES
    var me="Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),ne="Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),oe="Su_Mo_Tu_We_Th_Fr_Sa".split("_"),pe=Vd,qe=Vd,re=Vd;T("H",["HH",2],0,"hour"),T("h",["hh",2],0,Qa),T("k",["kk",2],0,Ra),T("hmm",0,0,function(){return""+Qa.apply(this)+S(this.minutes(),2)}),T("hmmss",0,0,function(){return""+Qa.apply(this)+S(this.minutes(),2)+S(this.seconds(),2)}),T("Hmm",0,0,function(){return""+this.hours()+S(this.minutes(),2)}),T("Hmmss",0,0,function(){return""+this.hours()+S(this.minutes(),2)+S(this.seconds(),2)}),Sa("a",!0),Sa("A",!1),
// ALIASES
        I("hour","h"),
// PRIORITY
        L("hour",13),Y("a",Ta),Y("A",Ta),Y("H",Kd),Y("h",Kd),Y("HH",Kd,Gd),Y("hh",Kd,Gd),Y("hmm",Ld),Y("hmmss",Md),Y("Hmm",Ld),Y("Hmmss",Md),aa(["H","HH"],_d),aa(["a","A"],function(a,b,c){c._isPm=c._locale.isPM(a),c._meridiem=a}),aa(["h","hh"],function(a,b,c){b[_d]=t(a),l(c).bigHour=!0}),aa("hmm",function(a,b,c){var d=a.length-2;b[_d]=t(a.substr(0,d)),b[ae]=t(a.substr(d)),l(c).bigHour=!0}),aa("hmmss",function(a,b,c){var d=a.length-4,e=a.length-2;b[_d]=t(a.substr(0,d)),b[ae]=t(a.substr(d,2)),b[be]=t(a.substr(e)),l(c).bigHour=!0}),aa("Hmm",function(a,b,c){var d=a.length-2;b[_d]=t(a.substr(0,d)),b[ae]=t(a.substr(d))}),aa("Hmmss",function(a,b,c){var d=a.length-4,e=a.length-2;b[_d]=t(a.substr(0,d)),b[ae]=t(a.substr(d,2)),b[be]=t(a.substr(e))});var se,te=/[ap]\.?m?\.?/i,ue=N("Hours",!0),ve={calendar:td,longDateFormat:ud,invalidDate:vd,ordinal:wd,ordinalParse:xd,relativeTime:yd,months:ge,monthsShort:he,week:le,weekdays:me,weekdaysMin:oe,weekdaysShort:ne,meridiemParse:te},we={},xe=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?/,ye=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?/,ze=/Z|[+-]\d\d(?::?\d\d)?/,Ae=[["YYYYYY-MM-DD",/[+-]\d{6}-\d\d-\d\d/],["YYYY-MM-DD",/\d{4}-\d\d-\d\d/],["GGGG-[W]WW-E",/\d{4}-W\d\d-\d/],["GGGG-[W]WW",/\d{4}-W\d\d/,!1],["YYYY-DDD",/\d{4}-\d{3}/],["YYYY-MM",/\d{4}-\d\d/,!1],["YYYYYYMMDD",/[+-]\d{10}/],["YYYYMMDD",/\d{8}/],
// YYYYMM is NOT allowed by the standard
        ["GGGG[W]WWE",/\d{4}W\d{3}/],["GGGG[W]WW",/\d{4}W\d{2}/,!1],["YYYYDDD",/\d{7}/]],Be=[["HH:mm:ss.SSSS",/\d\d:\d\d:\d\d\.\d+/],["HH:mm:ss,SSSS",/\d\d:\d\d:\d\d,\d+/],["HH:mm:ss",/\d\d:\d\d:\d\d/],["HH:mm",/\d\d:\d\d/],["HHmmss.SSSS",/\d\d\d\d\d\d\.\d+/],["HHmmss,SSSS",/\d\d\d\d\d\d,\d+/],["HHmmss",/\d\d\d\d\d\d/],["HHmm",/\d\d\d\d/],["HH",/\d\d/]],Ce=/^\/?Date\((\-?\d+)/i;a.createFromInputFallback=w("value provided is not in a recognized ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non ISO date formats are discouraged and will be removed in an upcoming major release. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.",function(a){a._d=new Date(a._i+(a._useUTC?" UTC":""))}),
// constant that refers to the ISO standard
        a.ISO_8601=function(){};var De=w("moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var a=rb.apply(null,arguments);return this.isValid()&&a.isValid()?this>a?this:a:n()}),Ee=w("moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var a=rb.apply(null,arguments);return this.isValid()&&a.isValid()?a>this?this:a:n()}),Fe=function(){return Date.now?Date.now():+new Date};yb("Z",":"),yb("ZZ",""),
// PARSING
        Y("Z",Td),Y("ZZ",Td),aa(["Z","ZZ"],function(a,b,c){c._useUTC=!0,c._tzm=zb(Td,a)});
// HELPERS
// timezone chunker
// '+10:00' > ['10',  '00']
// '-1530'  > ['-15', '30']
    var Ge=/([\+\-]|\d\d)/gi;
// HOOKS
// This function will be called whenever a moment is mutated.
// It is intended to keep the offset in sync with the timezone.
    a.updateOffset=function(){};
// ASP.NET json date format regex
    var He=/^(\-)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)(\.\d*)?)?$/,Ie=/^(-)?P(?:(-?[0-9,.]*)Y)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)W)?(?:(-?[0-9,.]*)D)?(?:T(?:(-?[0-9,.]*)H)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)S)?)?$/;Nb.fn=vb.prototype;var Je=Rb(1,"add"),Ke=Rb(-1,"subtract");a.defaultFormat="YYYY-MM-DDTHH:mm:ssZ",a.defaultFormatUtc="YYYY-MM-DDTHH:mm:ss[Z]";var Le=w("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",function(a){return void 0===a?this.localeData():this.locale(a)});
// FORMATTING
    T(0,["gg",2],0,function(){return this.weekYear()%100}),T(0,["GG",2],0,function(){return this.isoWeekYear()%100}),xc("gggg","weekYear"),xc("ggggg","weekYear"),xc("GGGG","isoWeekYear"),xc("GGGGG","isoWeekYear"),
// ALIASES
        I("weekYear","gg"),I("isoWeekYear","GG"),
// PRIORITY
        L("weekYear",1),L("isoWeekYear",1),
// PARSING
        Y("G",Rd),Y("g",Rd),Y("GG",Kd,Gd),Y("gg",Kd,Gd),Y("GGGG",Od,Id),Y("gggg",Od,Id),Y("GGGGG",Pd,Jd),Y("ggggg",Pd,Jd),ba(["gggg","ggggg","GGGG","GGGGG"],function(a,b,c,d){b[d.substr(0,2)]=t(a)}),ba(["gg","GG"],function(b,c,d,e){c[e]=a.parseTwoDigitYear(b)}),
// FORMATTING
        T("Q",0,"Qo","quarter"),
// ALIASES
        I("quarter","Q"),
// PRIORITY
        L("quarter",7),
// PARSING
        Y("Q",Fd),aa("Q",function(a,b){b[Zd]=3*(t(a)-1)}),
// FORMATTING
        T("D",["DD",2],"Do","date"),
// ALIASES
        I("date","D"),
// PRIOROITY
        L("date",9),
// PARSING
        Y("D",Kd),Y("DD",Kd,Gd),Y("Do",function(a,b){return a?b._ordinalParse:b._ordinalParseLenient}),aa(["D","DD"],$d),aa("Do",function(a,b){b[$d]=t(a.match(Kd)[0],10)});
// MOMENTS
    var Me=N("Date",!0);
// FORMATTING
    T("DDD",["DDDD",3],"DDDo","dayOfYear"),
// ALIASES
        I("dayOfYear","DDD"),
// PRIORITY
        L("dayOfYear",4),
// PARSING
        Y("DDD",Nd),Y("DDDD",Hd),aa(["DDD","DDDD"],function(a,b,c){c._dayOfYear=t(a)}),
// FORMATTING
        T("m",["mm",2],0,"minute"),
// ALIASES
        I("minute","m"),
// PRIORITY
        L("minute",14),
// PARSING
        Y("m",Kd),Y("mm",Kd,Gd),aa(["m","mm"],ae);
// MOMENTS
    var Ne=N("Minutes",!1);
// FORMATTING
    T("s",["ss",2],0,"second"),
// ALIASES
        I("second","s"),
// PRIORITY
        L("second",15),
// PARSING
        Y("s",Kd),Y("ss",Kd,Gd),aa(["s","ss"],be);
// MOMENTS
    var Oe=N("Seconds",!1);
// FORMATTING
    T("S",0,0,function(){return~~(this.millisecond()/100)}),T(0,["SS",2],0,function(){return~~(this.millisecond()/10)}),T(0,["SSS",3],0,"millisecond"),T(0,["SSSS",4],0,function(){return 10*this.millisecond()}),T(0,["SSSSS",5],0,function(){return 100*this.millisecond()}),T(0,["SSSSSS",6],0,function(){return 1e3*this.millisecond()}),T(0,["SSSSSSS",7],0,function(){return 1e4*this.millisecond()}),T(0,["SSSSSSSS",8],0,function(){return 1e5*this.millisecond()}),T(0,["SSSSSSSSS",9],0,function(){return 1e6*this.millisecond()}),
// ALIASES
        I("millisecond","ms"),
// PRIORITY
        L("millisecond",16),
// PARSING
        Y("S",Nd,Fd),Y("SS",Nd,Gd),Y("SSS",Nd,Hd);var Pe;for(Pe="SSSS";Pe.length<=9;Pe+="S")Y(Pe,Qd);for(Pe="S";Pe.length<=9;Pe+="S")aa(Pe,Gc);
// MOMENTS
    var Qe=N("Milliseconds",!1);
// FORMATTING
    T("z",0,0,"zoneAbbr"),T("zz",0,0,"zoneName");var Re=q.prototype;Re.add=Je,Re.calendar=Ub,Re.clone=Vb,Re.diff=ac,Re.endOf=mc,Re.format=ec,Re.from=fc,Re.fromNow=gc,Re.to=hc,Re.toNow=ic,Re.get=Q,Re.invalidAt=vc,Re.isAfter=Wb,Re.isBefore=Xb,Re.isBetween=Yb,Re.isSame=Zb,Re.isSameOrAfter=$b,Re.isSameOrBefore=_b,Re.isValid=tc,Re.lang=Le,Re.locale=jc,Re.localeData=kc,Re.max=Ee,Re.min=De,Re.parsingFlags=uc,Re.set=R,Re.startOf=lc,Re.subtract=Ke,Re.toArray=qc,Re.toObject=rc,Re.toDate=pc,Re.toISOString=dc,Re.toJSON=sc,Re.toString=cc,Re.unix=oc,Re.valueOf=nc,Re.creationData=wc,
// Year
        Re.year=ke,Re.isLeapYear=qa,
// Week Year
        Re.weekYear=yc,Re.isoWeekYear=zc,
// Quarter
        Re.quarter=Re.quarters=Ec,
// Month
        Re.month=ja,Re.daysInMonth=ka,
// Week
        Re.week=Re.weeks=Aa,Re.isoWeek=Re.isoWeeks=Ba,Re.weeksInYear=Bc,Re.isoWeeksInYear=Ac,
// Day
        Re.date=Me,Re.day=Re.days=Ja,Re.weekday=Ka,Re.isoWeekday=La,Re.dayOfYear=Fc,
// Hour
        Re.hour=Re.hours=ue,
// Minute
        Re.minute=Re.minutes=Ne,
// Second
        Re.second=Re.seconds=Oe,
// Millisecond
        Re.millisecond=Re.milliseconds=Qe,
// Offset
        Re.utcOffset=Cb,Re.utc=Eb,Re.local=Fb,Re.parseZone=Gb,Re.hasAlignedHourOffset=Hb,Re.isDST=Ib,Re.isLocal=Kb,Re.isUtcOffset=Lb,Re.isUtc=Mb,Re.isUTC=Mb,
// Timezone
        Re.zoneAbbr=Hc,Re.zoneName=Ic,
// Deprecations
        Re.dates=w("dates accessor is deprecated. Use date instead.",Me),Re.months=w("months accessor is deprecated. Use month instead",ja),Re.years=w("years accessor is deprecated. Use year instead",ke),Re.zone=w("moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",Db),Re.isDSTShifted=w("isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",Jb);var Se=Re,Te=B.prototype;Te.calendar=C,Te.longDateFormat=D,Te.invalidDate=E,Te.ordinal=F,Te.preparse=Lc,Te.postformat=Lc,Te.relativeTime=G,Te.pastFuture=H,Te.set=z,
// Month
        Te.months=ea,Te.monthsShort=fa,Te.monthsParse=ha,Te.monthsRegex=ma,Te.monthsShortRegex=la,
// Week
        Te.week=xa,Te.firstDayOfYear=za,Te.firstDayOfWeek=ya,
// Day of Week
        Te.weekdays=Ea,Te.weekdaysMin=Ga,Te.weekdaysShort=Fa,Te.weekdaysParse=Ia,Te.weekdaysRegex=Ma,Te.weekdaysShortRegex=Na,Te.weekdaysMinRegex=Oa,
// Hours
        Te.isPM=Ua,Te.meridiem=Va,Za("en",{ordinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(a){var b=a%10,c=1===t(a%100/10)?"th":1===b?"st":2===b?"nd":3===b?"rd":"th";return a+c}}),
// Side effect imports
        a.lang=w("moment.lang is deprecated. Use moment.locale instead.",Za),a.langData=w("moment.langData is deprecated. Use moment.localeData instead.",ab);var Ue=Math.abs,Ve=cd("ms"),We=cd("s"),Xe=cd("m"),Ye=cd("h"),Ze=cd("d"),$e=cd("w"),_e=cd("M"),af=cd("y"),bf=ed("milliseconds"),cf=ed("seconds"),df=ed("minutes"),ef=ed("hours"),ff=ed("days"),gf=ed("months"),hf=ed("years"),jf=Math.round,kf={s:45,// seconds to minute
        m:45,// minutes to hour
        h:22,// hours to day
        d:26,// days to month
        M:11},lf=Math.abs,mf=vb.prototype;mf.abs=Uc,mf.add=Wc,mf.subtract=Xc,mf.as=ad,mf.asMilliseconds=Ve,mf.asSeconds=We,mf.asMinutes=Xe,mf.asHours=Ye,mf.asDays=Ze,mf.asWeeks=$e,mf.asMonths=_e,mf.asYears=af,mf.valueOf=bd,mf._bubble=Zc,mf.get=dd,mf.milliseconds=bf,mf.seconds=cf,mf.minutes=df,mf.hours=ef,mf.days=ff,mf.weeks=fd,mf.months=gf,mf.years=hf,mf.humanize=kd,mf.toISOString=ld,mf.toString=ld,mf.toJSON=ld,mf.locale=jc,mf.localeData=kc,
// Deprecations
        mf.toIsoString=w("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",ld),mf.lang=Le,
// Side effect imports
// FORMATTING
        T("X",0,0,"unix"),T("x",0,0,"valueOf"),
// PARSING
        Y("x",Rd),Y("X",Ud),aa("X",function(a,b,c){c._d=new Date(1e3*parseFloat(a,10))}),aa("x",function(a,b,c){c._d=new Date(t(a))}),
// Side effect imports
        a.version="2.15.1",b(rb),a.fn=Se,a.min=tb,a.max=ub,a.now=Fe,a.utc=j,a.unix=Jc,a.months=Pc,a.isDate=f,a.locale=Za,a.invalid=n,a.duration=Nb,a.isMoment=r,a.weekdays=Rc,a.parseZone=Kc,a.localeData=ab,a.isDuration=wb,a.monthsShort=Qc,a.weekdaysMin=Tc,a.defineLocale=$a,a.updateLocale=_a,a.locales=bb,a.weekdaysShort=Sc,a.normalizeUnits=J,a.relativeTimeRounding=id,a.relativeTimeThreshold=jd,a.calendarFormat=Tb,a.prototype=Se;var nf=a;return nf});
var process = process || {env: {NODE_ENV: "development"}};
/*
 * Replaces module charts from old resources plugin
//= encoding UTF-8
//= require bootstrap-toggle.min.js
//= require bootstrap-multiselect.js
//= require Chart.min.js
//= require ALAChart.js
//= require regionTimeControls.js
//= require moment.min.js
 */
