//# sourceMappingURL=proj4leaflet.js.map
var process=process||{env:{NODE_ENV:"development"}};
(function(c){if("function"===typeof define&&define.amd)define(["leaflet","proj4"],c);else if("object"===typeof module&&"object"===typeof module.exports){var g=require("leaflet");var a=require("proj4");module.exports=c(g,a)}else{if("undefined"===typeof window.L||"undefined"===typeof window.proj4)throw"Leaflet and proj4 must be loaded first";c(window.L,window.proj4)}})(function(c,g){c.Proj={};c.Proj._isProj4Obj=function(a){return"undefined"!==typeof a.inverse&&"undefined"!==typeof a.forward};c.Proj.ScaleDependantTransformation=
function(a){this.scaleTransforms=a};c.Proj.ScaleDependantTransformation.prototype.transform=function(a,b){return this.scaleTransforms[b].transform(a,b)};c.Proj.ScaleDependantTransformation.prototype.untransform=function(a,b){return this.scaleTransforms[b].untransform(a,b)};c.Proj.Projection=c.Class.extend({initialize:function(a,b){if(c.Proj._isProj4Obj(a))this._proj=a;else{if(b)g.defs(a,b);else if(void 0===g.defs[a]&&(b=a.split(":"),3<b.length&&(a=b[b.length-3]+":"+b[b.length-1]),void 0===g.defs[a]))throw"No projection definition for code "+
a;this._proj=g(a)}},project:function(a){a=this._proj.forward([a.lng,a.lat]);return new c.Point(a[0],a[1])},unproject:function(a,b){a=this._proj.inverse([a.x,a.y]);return new c.LatLng(a[1],a[0],b)}});c.Proj.CRS=c.Class.extend({includes:c.CRS,options:{transformation:new c.Transformation(1,0,-1,0)},initialize:function(a,b,d){if(c.Proj._isProj4Obj(a)){var e=a.srsCode;d=b||{};this.projection=new c.Proj.Projection(a)}else e=a,d=d||{},this.projection=new c.Proj.Projection(e,b);c.Util.setOptions(this,d);
this.code=e;this.transformation=this.options.transformation;this.options.origin&&(this.transformation=new c.Transformation(1,-this.options.origin[0],-1,this.options.origin[1]));if(this.options.scales)this._scales=this.options.scales;else if(this.options.resolutions)for(this._scales=[],a=this.options.resolutions.length-1;0<=a;a--)this.options.resolutions[a]&&(this._scales[a]=1/this.options.resolutions[a])},scale:function(a){var b=Math.floor(a);if(a===b)return this._scales[a];var d=this._scales[b];
return d+(this._scales[b+1]-d)*(a-b)},getSize:function(a){var b=this.options.bounds;if(b){var d=this.scale(a);a=this.transformation.transform(b.min,d);b=this.transformation.transform(b.max,d);return c.point(Math.abs(b.x-a.x),Math.abs(b.y-a.y))}d=256*Math.pow(2,a);return c.point(d,d)}});c.Proj.CRS.TMS=c.Proj.CRS.extend({options:{tileSize:256},initialize:function(a,b,d,e){if(c.Proj._isProj4Obj(a)){var f=b;d=d||{};d.origin=[f[0],f[3]];c.Proj.CRS.prototype.initialize.call(this,a,d)}else f=d,d=e||{},d.origin=
[f[0],f[3]],c.Proj.CRS.prototype.initialize.call(this,a,b,d);this.projectedBounds=f;this._sizes=this._calculateSizes()},_calculateSizes:function(){var a=[],b=this.projectedBounds,d;for(d=this._scales.length-1;0<=d;d--)if(this._scales[d]){var e=this.options.tileSize/this._scales[d];var f=Math.ceil(parseFloat((b[2]-b[0])/e).toPrecision(3))*e*this._scales[d];e=Math.ceil(parseFloat((b[3]-b[1])/e).toPrecision(3))*e*this._scales[d];a[d]=c.point(f,e)}return a},getSize:function(a){return this._sizes[a]}});
c.Proj.TileLayer={};c.Proj.TileLayer.TMS=c.TileLayer.extend({options:{continuousWorld:!0},initialize:function(a,b,d){var e=!0;if(!(b instanceof c.Proj.CRS.TMS))throw"CRS is not L.Proj.CRS.TMS.";c.TileLayer.prototype.initialize.call(this,a,d);this.options.tms=!1;this.crs=b;a=this.crs.projectedBounds;for(b=this.options.minZoom;b<this.options.maxZoom&&e;b++)e=(a[3]-a[1])/this._projectedTileSize(b),e=.001<Math.abs(e-Math.round(e));if(!e){e={};for(b=this.options.minZoom;b<this.options.maxZoom;b++)d=a[1]+
Math.ceil((a[3]-a[1])/this._projectedTileSize(b))*this._projectedTileSize(b),e[this.crs.scale(b)]=new c.Transformation(1,-a[0],-1,d);this.crs=new c.Proj.CRS.TMS(this.crs.projection._proj,a,this.crs.options);this.crs.transformation=new c.Proj.ScaleDependantTransformation(e)}},getTileUrl:function(a){var b=this._map.getZoom();b=Math.ceil((this.crs.projectedBounds[3]-this.crs.projectedBounds[1])/this._projectedTileSize(b));return c.Util.template(this._url,c.Util.extend({s:this._getSubdomain(a),z:this._getZoomForUrl(),
x:a.x,y:b-a.y-1},this.options))},_projectedTileSize:function(a){return this.options.tileSize/this.crs.scale(a)}});c.Proj.GeoJSON=c.GeoJSON.extend({initialize:function(a,b){this._callLevel=0;c.GeoJSON.prototype.initialize.call(this,null,b);a&&this.addData(a)},addData:function(a){var b;a&&(a.crs&&"name"===a.crs.type?b=new c.Proj.CRS(a.crs.properties.name):a.crs&&a.crs.type&&(b=new c.Proj.CRS(a.crs.type+":"+a.crs.properties.code)),void 0!==b&&(this.options.coordsToLatLng=function(d){d=c.point(d[0],d[1]);
return b.projection.unproject(d)}));this._callLevel++;try{c.GeoJSON.prototype.addData.call(this,a)}finally{this._callLevel--,0===this._callLevel&&delete this.options.coordsToLatLng}}});c.Proj.geoJson=function(a,b){return new c.Proj.GeoJSON(a,b)};c.Proj.ImageOverlay=c.ImageOverlay.extend({initialize:function(a,b,d){c.ImageOverlay.prototype.initialize.call(this,a,null,d);this._projBounds=b},_animateZoom:function(a){var b=c.point(this._projBounds.min.x,this._projBounds.max.y),d=c.point(this._projBounds.max.x,
this._projBounds.min.y);b=this._projectedToNewLayerPoint(b,a.zoom,a.center);d=this._projectedToNewLayerPoint(d,a.zoom,a.center).subtract(b);d=b.add(d._multiplyBy((1-1/a.scale)/2));this._image.style[c.DomUtil.TRANSFORM]=c.DomUtil.getTranslateString(d)+" scale("+this._map.getZoomScale(a.zoom)+") "},_reset:function(){var a=this._map.getZoom(),b=this._map.getPixelOrigin();a=c.bounds(this._transform(this._projBounds.min,a)._subtract(b),this._transform(this._projBounds.max,a)._subtract(b));b=a.getSize();
var d=this._image;c.DomUtil.setPosition(d,a.min);d.style.width=b.x+"px";d.style.height=b.y+"px"},_projectedToNewLayerPoint:function(a,b,d){d=this._map._getNewTopLeftPoint(d,b).add(this._map._getMapPanePos());return this._transform(a,b)._subtract(d)},_transform:function(a,b){var d=this._map.options.crs,e=d.transformation;b=d.scale(b);return e.transform(a,b)}});c.Proj.imageOverlay=function(a,b,d){return new c.Proj.ImageOverlay(a,b,d)};"undefined"!==typeof c.CRS&&(c.CRS.proj4js=function(){return function(a,
b,d,e){e=e||{};d&&(e.transformation=d);return new c.Proj.CRS(a,b,e)}}());return c.Proj});