//# sourceMappingURL=urlParamsService.js.map
var process=process||{env:{NODE_ENV:"development"}};
(function(angular){angular.module("url-params-service",["layers-service","facet-auto-complete-service","biocache-service","map-service","layout-service"]).factory("UrlParamsService",["$rootScope","$timeout","LayersService","BiocacheService","MapService","LayoutService","SessionsService","$q","ToolsService",function($rootScope,$timeout,LayersService,BiocacheService,MapService,LayoutService,SessionsService,$q,ToolsService){var _this={processUrlParams:function(params){var biocacheServiceUrl=$SH.biocacheServiceUrl;
var biocacheUrl=$SH.biocacheUrl;var ws=params.ws;var bs=params.bs;if(!ws||ws===undefined)ws=biocacheUrl;if(!bs||bs===undefined)bs=biocacheServiceUrl;var useSpeciesWMSCache="on";var tool;var s="";var qname;var qc;var qualityProfile;var disableAllQualityFilters;var disableQualityFilter=[];var wkt;var size;var opacity;var colour;var pointtype;var bb;var lat;var lon;var radius;var supportDynamic;var colourBy;var includeDistributions;var toolParameters;var geospatialKosher=null;var sbList=[];var savedsession;
var workflow;for(var key in params)if(params.hasOwnProperty(key)){var value=params[key];if("workflow"==key)workflow=value;if("wmscache"===key)useSpeciesWMSCache=value;if("tool"===key)tool=value;if("toolParameters"===key)toolParameters=value;if("species_lsid"===key)sbList.push("lsid:"+value);else if("q"===key){s=value;if(s&&s!==undefined)sbList.push(s)}else if("qname"===key)qname=value;else if("fq"===key||"qc"===key)if($.isArray(value))for(var a in value){if(value.hasOwnProperty(a))sbList.push(value[a])}else sbList.push(value);
else if("wkt"===key)wkt=value;else if("qualityProfile"===key)qualityProfile=value;else if("disableAllQualityFilters"===key)disableAllQualityFilters=value==="true";else if("disableQualityFilter"===key)if($.isArray(value))for(var a in value){if(value.hasOwnProperty(a))disableQualityFilter.push(value[a])}else disableQualityFilter.push(value);else if("psize"===key)size=parseInt(value);else if("popacity"===key)opacity=parseFloat(value);else if("pcolour"===key)colour=parseInt(value,16);else if("ptype"===
key)pointtype=value;else if("bbox"===key)bb=value;else if("lat"===key)lat=parseFloat(value);else if("lon"===key)lon=parseFloat(value);else if("radius"===key)radius=parseFloat(value);else if("ss"===key)savedsession=value.trim();else if("dynamic"===key)supportDynamic=value.toLowerCase()==="true";else if("cm"===key)colourBy=value.trim();else if("includeDistributions"===key)includeDistributions=value.toLowerCase()==="true"}if(lat!==null&&lon!==null&&radius!==null&&lat!==undefined&&lon!==undefined&&radius!==
undefined)wkt=this.createCircle(lon,lat,radius*1E3);var promises=[];if(!tool&&workflow){tool="workflow";toolParameters=JSON.stringify({workflowId:workflow})}if(sbList.length>0||s!==null&&s!==undefined&&s.length>0){var query={q:sbList,bs:bs,ws:ws};if(wkt!==undefined&&wkt!==null)query.wkt=wkt;if(qualityProfile!==undefined&&qualityProfile!==null&&qualityProfile)query.qualityProfile=qualityProfile;if(disableAllQualityFilters!==undefined&&disableAllQualityFilters!==null&&disableAllQualityFilters)query.disableAllQualityFilters=
disableAllQualityFilters;if(Array.isArray(disableQualityFilter)&&disableQualityFilter.length)query.disableQualityFilter=disableQualityFilter;promises.push(BiocacheService.queryTitle(query).then(function(response){query.name=response;if(qname!==undefined)newLayerResp.displayname=qname;return BiocacheService.newLayer(query,undefined,response).then(function(newLayerResp){if(newLayerResp==null)return $q.when(false);if(colourBy!==undefined)newLayerResp.facet=colourBy;if(pointtype!==undefined)newLayerResp.pointtype=
pointtype;if(size!==undefined)newLayerResp.size=size;if(opacity!==undefined)newLayerResp.opacity=opacity;if(colour!==undefined)newLayerResp.color=colour;return MapService.add(newLayerResp)})}))}if(bb!==undefined)MapService.zoomToExtent(bb);if(savedsession)promises.push(SessionsService.load(savedsession));$.each(this.mapMultiQuerySpeciesLayers(params,bs,ws,geospatialKosher),function(it){promises.push(it)});$.each(this.mapLayerFromParams(params),function(it){promises.push(it)});$.each(this.mapObjectFromParams(params,
bs),function(it){promises.push(it)});$q.all(promises).then(function(data){if(tool!==null&&tool!==undefined)_this.mapToolParams(tool,toolParameters);else if(bb===undefined&&savedsession==undefined)MapService.zoomToAll()})},parseSearchParams:function(url){var parser=document.createElement("a");parser.href=url;var query=parser.search.substr(1);var result={};var paramList=query.split("&");for(var i=0;i<paramList.length;i++){var param=paramList[i].split("=");if(param[0])result[param[0]]=decodeURIComponent(param[1])}return result},
mapToolParams:function(tool,toolParameters){var map={};if(tool){var parameters={};if(toolParameters)parameters=JSON.parse(toolParameters);if(tool==="phylogeneticdiversity");if(LayoutService.isPanel(tool))LayoutService.openPanel(tool,parameters,false);else if(ToolsService.isTool(tool))LayoutService.openModal("tool",{"processName":tool});else LayoutService.openModal(tool,parameters)}},mapObjectFromParams:function(params,bs){var promises=[];var pids=params["pid"]?params["pid"].trim():"";if(pids!==""){var pidList=
params["pid"].split(",");for(var index in pidList)if(pidList.hasOwnProperty(index))promises.push(LayersService.getObject(pidList[index]).then(function(resp){resp.data.layertype="area";MapService.add(resp.data,bs)}))}return promises},mapMultiQuerySpeciesLayers:function(params,bs,ws,geospatialKosher){var promises=[];var speciesLayerPattern=new RegExp("ly\\.[0-9]{1,}");for(var key in params)if(params.hasOwnProperty(key)){var match=speciesLayerPattern.test(key);if(match){var str=key.substring(key.length-
2);if(str!==".q"&&str!==".s"){var layerName=params[key];var multiLayerQuery=params[key+".q"];if(multiLayerQuery!==null&&multiLayerQuery!==undefined&&multiLayerQuery.includes(",")){var queryComponents=multiLayerQuery.split(",");multiLayerQuery=queryComponents.join(" OR ")}var fqList=[];if(geospatialKosher!==null&&geospatialKosher!==undefined)fqList.push(geospatialKosher);var multiQuery={q:multiLayerQuery,fq:fqList,bs:bs,ws:ws};(function(){var style=params[key+".s"];promises.push(BiocacheService.newLayer(multiQuery,
undefined,layerName).then(function(newLayerResp){if(newLayerResp==null)return $q.when(false);newLayerResp.color=style;MapService.add(newLayerResp)}))})()}}}return promises},mapLayerFromParams:function(params){var promises=[];var layersCSV=params["layers"]?params["layers"].trim().split(","):[];for(var i in layersCSV){var name=layersCSV[i];promises.push(LayersService.getLayersUrlLoad(name).then(function(resp){MapService.add(resp)}))}return promises},createCircle:function(longitude,latitude,radius){var belowMinus180=
false;var points=[];for(var i=0;i<360;i++){points[i]=this.computeOffset(latitude,0,radius,i);if(points[i][0]+longitude<-180)belowMinus180=true}var dist=(belowMinus180?360:0)+longitude;var s="POLYGON"+"((";for(i=0;i<360;i++)s=s+(points[i][0]+dist)+" "+points[i][1]+",";s=s+(points[0][0]+dist)+" "+points[0][1]+"))";return s},computeOffset:function(lat,lng,radius,angle){var b=radius/6378137;var c=angle*(Math.PI/180);var e=lat*(Math.PI/180);var d=Math.cos(b);b=Math.sin(b);var f=Math.sin(e);e=Math.cos(e);
var g=d*f+b*e*Math.cos(c);var x=(lng*(Math.PI/180)+Math.atan2(b*e*Math.sin(c),d-f*g))/(Math.PI/180);var y=Math.asin(g)/(Math.PI/180);return[x,y]}};return _this}])})(angular);