//# sourceMappingURL=toolsService.js.map
var process=process||{env:{NODE_ENV:"development"}};
(function(angular){angular.module("tools-service",[]).factory("ToolsService",["$injector","$q","$http","$timeout","MapService","LayersService","LoggerService","LayoutService",function($injector,$q,$http,$timeout,MapService,LayersService,LoggerService,LayoutService){var cap=$SH.layersServiceCapabilities;var viewConfig=$SH.viewConfig;var localToolServices={};var promises=[];initLocalTools();var _httpDescription=function(method,httpconfig){if(httpconfig===undefined)httpconfig={};httpconfig.service="ToolsService";
httpconfig.method=method;return httpconfig};function executeRemote(uiScope,inputs){var m={};m["input"]=inputs;m["name"]=uiScope.toolName;var url=$SH.baseUrl+"/portal/postTask?sessionId="+$SH.sessionId;$http.post(url,m,_httpDescription("executeRemote")).then(function(response){uiScope.externalTaskId=response.data.id;uiScope.statusUrl=LayersService.url()+"/tasks/status/"+response.data.id;LoggerService.log("Tool",uiScope.toolName,{"taskId":uiScope.externalTaskId});$timeout(function(){_checkStatus(uiScope)},
5E3)},function(error){if(!error.handled){var message="";if(error.headers()["content-type"].indexOf("json")>0)message=JSON.stringify(error.data);else message=error.data;bootbox.alert("Failed: "+error.status)}uiScope.status="Failed";uiScope.finished=true});return $q.when(false)}function _checkStatus(uiScope){if(uiScope.cancelled)return;return $http.get(uiScope.statusUrl+"?last="+uiScope.last,_httpDescription("checkStatus")).then(function(response){uiScope.status=response.data.message;var keys=[];var k;
for(k in response.data.history)if(response.data.history.hasOwnProperty(k))keys.push(k);keys.sort();for(k in keys){uiScope.log[keys[k]]=response.data.history[keys[k]];uiScope.logText=response.data.history[keys[k]]+"\r\n"+uiScope.logText;uiScope.last=keys[k]}if(response.data.status<2)uiScope.checkStatusTimeout=$timeout(function(){_checkStatus(uiScope)},5E3);else if(response.data.status===2){uiScope.status="cancelled";uiScope.finished=true}else if(response.data.status===3){uiScope.status="error";uiScope.finished=
true}else if(response.data.status===4)if(response.data.output===undefined){uiScope.status="error";uiScope.finished=true}else{uiScope.status="successful";uiScope.finishedData=response.data;return _executeResult(uiScope)}})}function _executeResult(uiScope){var layers=[];var nextprocess;for(k in uiScope.finishedData.output)if(uiScope.finishedData.output.hasOwnProperty(k)){var d=uiScope.finishedData.output[k];if(d.file&&d.file.match(/\.zip$/g)!=null){var filename=uiScope.toolName+" ("+(uiScope.taskId||
uiScope.externalTaskId)+").zip";uiScope.downloadUrl=LayersService.url()+"/tasks/output/"+uiScope.finishedData.id+"/"+encodeURI(filename)+"?filename="+d.file;if(uiScope.downloadImmediately&&uiScope.spec.download!==false)Util.download(uiScope.downloadUrl,d.file)}else if(d.downloadUrl){uiScope.downloadUrl=d.downloadUrl;var filename="file";var match=d.downloadUrl.match("filename=.*$");if(match&&match.length>0)filename=match[0].replace("filename=","");else{match=d.downloadUrl.match("([^/\\?]*)(\\?.*)?$");
if(match&&match.length>1)filename=match[1]}if(uiScope.downloadImmediately&&uiScope.spec.download!==false)Util.download(uiScope.downloadUrl,filename)}}var csvFile=null;var csvUrl=null;for(k in uiScope.finishedData.output)if(uiScope.finishedData.output.hasOwnProperty(k)){var d=uiScope.finishedData.output[k];if(d.openUrl)uiScope.metadataUrl=d.openUrl;else if(d.file&&d.file.match(/\.zip$/g)!=null);else if(d.file&&d.file.match(/\.html$/g)!=null)uiScope.metadataUrl=LayersService.url()+"/tasks/output/"+
uiScope.finishedData.id+"/"+d.file;else if(d.file&&d.file.match(/\.csv/g)!=null){csvUrl=LayersService.url()+"/tasks/output/"+uiScope.finishedData.id+"/"+d.file;csvFile=d.file}else if(d.file&&d.file.match(/\.tif$/g)!=null){var name=d.file.replace("/layer/","").replace(".tif","");layers.push({id:name,displaypath:$SH.geoserverUrl+"/wms?layers=ALA:"+name,type:"e",name:name,displayname:name,layer:{id:name,displaypath:$SH.geoserverUrl+"/wms?layers=ALA:"+name,type:"e",name:name,displayname:name}})}else if(d.name===
"area")if(d.file.indexOf("{")===0){var json=JSON.parse(d.file);layers.push({id:json.id,displaypath:json.wmsurl,type:"envelope",layertype:"area",q:json.q,name:json.name,area_km:json.area_km,bbox:json.bbox,wkt:json.bbox,pid:"ENVELOPE"+json.id})}else promises.push(LayersService.getObject(d.file).then(function(data){data.data.layertype="area";data.data.log=false;return MapService.add(data.data)}));else if(d.name==="species"){var q=jQuery.parseJSON(d.file);if(!q.qid)q.qid=q.q;q.opacity=60;q.scatterplotDataUrl=
uiScope.downloadUrl;q.log=false;promises.push(MapService.add(q))}else if(d.name==="nextprocess"){var nextinput=jQuery.parseJSON(d.file);nextprocess={processName:nextinput.process,overrideValues:{}};nextprocess.overrideValues[nextinput.process]={input:nextinput.input}}}if(layers.length>0)$.each(layers,function(){var layer=this;if(uiScope.metadataUrl!==null)layer.metadataUrl=uiScope.metadataUrl;layer.name=uiScope.toolName+" ("+layer.name+")";layer.log=false;promises.push(MapService.add(layer))});if(uiScope.metadataUrl!==
null)uiScope.openUrl(uiScope.metadataUrl);else if(csvUrl!==null)$http.get(csvUrl,_httpDescription("getCsv")).then(function(data){var columnOrder=uiScope.spec.output.columnOrder;if(!columnOrder)columnOrder=[];LayoutService.openModal("csv",{title:uiScope.toolName+" ("+csvFile+")",csv:data.data,columnOrder:columnOrder,info:"",filename:csvFile,display:{size:"full"}},false)});return $q.all(promises).then(function(){uiScope.finished=true;uiScope.$close();if(nextprocess)$timeout(function(){LayoutService.openModal("tool",
nextprocess,false)},0)})}function registerService(toolName,service){localToolServices[toolName]=service;cap[toolName]=service.spec}function executeLocal(uiScope,toolName,inputs){LoggerService.log("Tool",uiScope.toolName,inputs);var result=localToolServices[toolName].execute(inputs);if(result&&result.then)result.then(function(response){uiScope.finishedData=response;_executeResult(uiScope);uiScope.$close()});else uiScope.$close()}function refreshLocal(uiScope,toolName,inputs){if(typeof localToolServices[toolName].refresh===
"function")localToolServices[toolName].refresh(inputs,uiScope.spec)}function initLocalTools(){$.each(spApp.requires,function(x){var v=spApp.requires[x];if(v.match(/-service$/g)!=null&&v.match(/^tool-/g)!=null){var name=v.replace(/-.|^./g,function(match){return match.toUpperCase().replace("-","")});var tool=$injector.get(name);if(tool&&tool.spec&&tool.execute)registerService(name,tool)}})}return{init:function(toolName){if(localToolServices[toolName]&&localToolServices[toolName].init)localToolServices[toolName].init();
return $q.when($SH.layersServiceCapabilities)},isLocalTask:function(toolName){return localToolServices[toolName]!==undefined},isTool:function(toolName){return localToolServices[toolName]!==undefined||cap[toolName]!==undefined},execute:function(uiScope,toolName,inputs){if(localToolServices[toolName])return executeLocal(uiScope,toolName,inputs);else return executeRemote(uiScope,inputs)},refresh:function(uiScope,toolName,inputs){if(localToolServices[toolName])refreshLocal(uiScope,toolName,inputs)},getCap:function(toolName){return cap[toolName]},
getViewConfig:function(toolName){return viewConfig[toolName]},checkStatus:function(uiScope){_checkStatus(uiScope)},executeResult:function(uiScope){_executeResult(uiScope)}}}])})(angular);