//# sourceMappingURL=sessionsService.js.map
var process=process||{env:{NODE_ENV:"development"}};
(function(angular){angular.module("sessions-service",[]).factory("SessionsService",["$http","$rootScope","MapService","BiocacheService","LoggerService",function($http,$rootScope,MapService,BiocacheService,LoggerService){var _httpDescription=function(method,httpconfig){if(httpconfig===undefined)httpconfig={};httpconfig.service="SessionsService";httpconfig.method=method;return httpconfig};var _this={current:function(){if(MapService.leafletScope){var layers=[];for(var idx in MapService.mappedLayers){var src=
MapService.mappedLayers[idx];var leaflet=Util.deepCopy(src.leaflet);var lyr={uid:src.uid,id:src.id,visible:src.visible,layertype:src.layertype,legendurl:src.legendurl,name:src.name,type:src.type,displaypath:src.displaypath,metadata:src.metadata,bbox:src.bbox,legend:src.legend,species_list:src.species_list,url:src.url,area_km:src.area_km,pid:src.pid,wkt:src.pid===undefined?src.wkt:undefined,ws:src.ws,fq:src.fq,q:src.q,qid:src.qid,bs:src.bs,hidelegend:src.hidelegend,displayname:src.displayname,color:src.color,
colorType:src.colorType,facet:src.facet,size:src.size,opacity:src.opacity,uncertainty:src.uncertainty,contextualSelection:src.contextualSelection,contextualFilter:src.contextualFilter,facetSelectionCount:src.facetSelectionCount,facets:src.facets?$.map(src.facets,function(v){var copy=$.merge({},v);delete copy.data;if(copy._fq===undefined&&v.data&&v.data.length>0){copy._fq=[];$.map(v.data,function(d){copy._fq.push(BiocacheService.facetToFq(v.data,false))})}return copy}):undefined,index:src.index,leaflet:leaflet,
scatterplotFq:src.scatterplotFq,scatterplotDataUrl:src.scatterplotDataUrl,scatterplotUrl:src.scatterplotUrl,scatterplotUpdating:src.scatterplotUpdating,scatterplotSelection:src.scatterplotSelection,highlightWkt:src.highlightWkt,scatterplotSelectionExtents:src.scatterplotSelectionExtents,scatterplotSelectionCount:src.scatterplotSelectionCount,scatterplotLabel1:src.scatterplotLabel1,scatterplotLabel2:src.scatterplotLabel2,inAdhocQ:src.inAdhocQ,outAdhocQ:src.outAdhocQ,adhocGroup:src.adhocGroup,adhocGroupSize:src.adhocGroupSize,
adhocBBoxes:src.adhocBBoxes,isSelectedFacetsOnly:src.isSelectedFacetsOnly,isWithoutSelectedFacetsOnly:src.isWithoutSelectedFacetsOnly,metadataUrl:src.metadataUrl,geom_idx:src.geom_idx,query:src.query};layers.push(lyr)}return{layers:layers,extents:MapService.getExtents(),basemap:MapService.leafletScope.getBaseMap(),projection:$SH.projection}}else return{}},list:function(){return $http.get($SH.baseUrl+"/portal/sessions",_httpDescription("list")).then(function(response){return response.data})},save:function(data){bootbox.prompt({title:$i18n(350,
"Enter a name to save this session"),value:$i18n(351,"My session")+" "+(new Date).toLocaleString(),callback:function(name){if(name!==null){if(name.length===0)name=$i18n(403,"My saved session");data.name=name;return $http.post($SH.baseUrl+"/portal/session/"+$SH.sessionId,data,_httpDescription("save")).then(function(response){bootbox.alert("<h3>"+$i18n(404,"Session Saved")+"</h3><br/><br/>"+$i18n(405,"URL to retrived this saved session")+'<br/><br/><a target="_blank" href="'+response.data.url+'">'+
response.data.url+"</a>")},function(error){if(!error.handled)bootbox.alert("Error:"+error.data)})}}})},saveAndLogin:function(data,urlTemplate,encode,skipALALoskipALALoginUrlginUrl){return $http.post($SH.baseUrl+"/portal/sessionCache/"+$SH.sessionId+"?save=false",data,_httpDescription("saveAndLogin")).success(function(response){var url;if(response.data)url=response.data.url.replace("?","/?");else if(response.url)url=response.url.replace("?","/?");if(url)if(urlTemplate){if(encode)url=encodeURIComponent(url);
window.location.href=urlTemplate.replace("$url",url)}else if(skipALALoskipALALoginUrlginUrl)window.location.href=url;else window.location.href=$SH.loginUrl+encodeURIComponent(url)}).error(function(err){return false})},get:function(sessionId){return $http.get($SH.baseUrl+"/portal/session/"+sessionId,_httpDescription("get")).then(function(response){return response.data})},remove:function(sessionId){return $http.delete($SH.baseUrl+"/portal/session/"+sessionId,_httpDescription("delete")).then(function(response){return response.data})},
load:function(sessionId){return this.get(sessionId).then(function(data){_this._load(data,sessionId)})},_load:function(sessionData,sessionId){if(sessionData&&sessionData.extents){MapService.removeAll();$SH.projection=sessionData.projection;MapService.leafletScope.updateCRS();MapService.leafletScope.zoom(sessionData.extents);MapService.setBaseMap(sessionData.basemap);LoggerService.log("Map","Session",{sessionId:sessionId});sessionData.layers.sort(function(a,b){return a.index-b.index});var uidOffset=
MapService.uid+1;for(var i=0;i<sessionData.layers.length;i++){sessionData.layers[i].fromSave=true;sessionData.layers[i].uid+=uidOffset;sessionData.layers[i].log=false;MapService.add(sessionData.layers[i])}}}};$rootScope.$on("loadSession",function(event,data){_this._load(data)});return _this}])})(angular);