/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.analysis.layers;

import au.org.ala.spatial.analysis.layers.CalcThread;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

class ToDiskThread
extends Thread {
    private static final Logger logger = Logger.getLogger(CalcThread.class);
    String filename;
    LinkedBlockingQueue<String> toDisk;

    public ToDiskThread(String filename, LinkedBlockingQueue<String> toDisk) {
        this.filename = filename;
        this.toDisk = toDisk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FileWriter fw = null;
        try {
            fw = new FileWriter(this.filename, true);
            try {
                while (true) {
                    String s = this.toDisk.take();
                    fw.append(s + "\n");
                    fw.flush();
                }
            }
            catch (Exception e) {
                try {
                    while (this.toDisk.size() > 0) {
                        String s = this.toDisk.take();
                        fw.append(s + "\n");
                        fw.flush();
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (Exception e2) {
                        logger.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

