/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.intersect;

import au.org.ala.layers.intersect.DBFField;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;

class DBFRecord
implements Serializable {
    static final long serialVersionUID = 584190536943295242L;
    String[] record;
    int deletionflag;
    String[] fieldValues;

    public DBFRecord(ByteBuffer buffer, ArrayList<DBFField> fields, Charset charset) {
        this.deletionflag = 0xFF & buffer.get();
        this.record = new String[fields.size()];
        for (int i = 0; i < this.record.length; ++i) {
            DBFField f = fields.get(i);
            byte[] data = f.getDataBlock();
            buffer.get(data);
            try {
                switch (f.getType()) {
                    case 'C': {
                        this.record[i] = DBFField.convertToUTF8(new String(data, charset).trim());
                        break;
                    }
                    case 'N': {
                        this.record[i] = DBFField.convertToUTF8(new String(data, charset).trim());
                    }
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    DBFRecord(ByteBuffer buffer, ArrayList<DBFField> fields, Charset charset, int[] columnIdx, boolean mergeColumns) {
        this.deletionflag = 0xFF & buffer.get();
        this.record = mergeColumns ? new String[1] : new String[columnIdx.length];
        this.fieldValues = new String[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            DBFField f = fields.get(i);
            byte[] data = f.getDataBlock();
            buffer.get(data);
            try {
                switch (f.getType()) {
                    case 'C': {
                        this.fieldValues[i] = DBFField.convertToUTF8(new String(data, charset).trim());
                        break;
                    }
                    case 'N': {
                        this.fieldValues[i] = DBFField.convertToUTF8(new String(data, charset).trim());
                    }
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (int j = 0; j < columnIdx.length; ++j) {
            if (mergeColumns) {
                if (this.record[0] == null) {
                    this.record[0] = "";
                } else if (this.record[0].length() > 0) {
                    this.record[0] = this.record[0] + ", ";
                }
                this.record[0] = this.record[0] + this.fieldValues[columnIdx[j]];
                continue;
            }
            this.record[j] = this.fieldValues[columnIdx[j]];
        }
    }

    public String getValue(int column) {
        if (column < 0 || column >= this.record.length) {
            return "";
        }
        return this.record[column];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String s : this.record) {
            sb.append(s);
            sb.append(", ");
        }
        return sb.toString();
    }
}

