/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.intersect;

import au.org.ala.layers.intersect.ComplexRegion;
import au.org.ala.layers.intersect.ShapeRecords;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;

class ShapesReference
implements Serializable {
    ArrayList<Integer>[][] mask;
    int mask_dimension;
    double mask_long_multiplier;
    double mask_lat_multiplier;
    double[][] boundingbox_all;
    ShapeRecords sr;

    public ShapesReference(ShapeRecords sr_) {
        this.sr = sr_;
        this.boundingbox_all = new double[2][2];
        this.mask_dimension = (int)Math.sqrt(this.sr.getNumberOfRecords());
        if (this.mask_dimension < 3) {
            this.mask = null;
            return;
        }
        this.mask = new ArrayList[this.mask_dimension][this.mask_dimension];
        boolean first_time = true;
        for (ComplexRegion s : sr_.getRegions()) {
            double[][] bb = s.getBoundingBox();
            if (first_time || this.boundingbox_all[0][0] > bb[0][0]) {
                this.boundingbox_all[0][0] = bb[0][0];
            }
            if (first_time || this.boundingbox_all[1][0] < bb[1][0]) {
                this.boundingbox_all[1][0] = bb[1][0];
            }
            if (first_time || this.boundingbox_all[0][1] > bb[0][1]) {
                this.boundingbox_all[0][1] = bb[0][1];
            }
            if (first_time || this.boundingbox_all[1][1] < bb[1][1]) {
                this.boundingbox_all[1][1] = bb[1][1];
            }
            first_time = false;
        }
        ArrayList<ComplexRegion> sra = this.sr.getRegions();
        for (int j = 0; j < sra.size(); ++j) {
            ComplexRegion s = sra.get(j);
            int[][] map = s.getOverlapGridCells_Box(this.boundingbox_all[0][0], this.boundingbox_all[0][1], this.boundingbox_all[1][0], this.boundingbox_all[1][1], this.mask_dimension, this.mask_dimension, s.getBoundingBox(), null, false);
            for (int i = 0; i < map.length; ++i) {
                if (this.mask[map[i][0]][map[i][1]] == null) {
                    this.mask[map[i][0]][map[i][1]] = new ArrayList();
                }
                this.mask[map[i][0]][map[i][1]].add(j);
            }
        }
        this.mask_long_multiplier = (double)this.mask_dimension / (this.boundingbox_all[1][0] - this.boundingbox_all[0][0]);
        this.mask_lat_multiplier = (double)this.mask_dimension / (this.boundingbox_all[1][1] - this.boundingbox_all[0][1]);
    }

    public int intersection(double longitude, double latitude) {
        block3: {
            ArrayList<ComplexRegion> sra;
            block2: {
                sra = this.sr.getRegions();
                if (this.mask == null) break block2;
                int long1 = (int)Math.floor((longitude - this.boundingbox_all[0][0]) * this.mask_long_multiplier);
                int lat1 = (int)Math.floor((latitude - this.boundingbox_all[0][1]) * this.mask_lat_multiplier);
                if (long1 < 0 || long1 >= this.mask[0].length || lat1 < 0 || lat1 >= this.mask.length || this.mask[long1][lat1] == null) break block3;
                ArrayList<Integer> ali = this.mask[long1][lat1];
                for (int i = 0; i < ali.size(); ++i) {
                    if (!sra.get(ali.get(i)).isWithin(longitude, latitude)) continue;
                    return ali.get(i);
                }
                break block3;
            }
            for (int i = 0; i < sra.size(); ++i) {
                if (!sra.get(i).isWithin(longitude, latitude)) continue;
                return i;
            }
        }
        return -1;
    }

    public List<ImmutablePair<Integer, Double>> intersection(double longitude, double latitude, double distance) {
        List<Object> r;
        ArrayList<ComplexRegion> sra = this.sr.getRegions();
        if (this.mask != null && distance < this.mask_lat_multiplier && distance < this.mask_long_multiplier) {
            ArrayList<Integer> ali;
            HashMap<Integer, Double> hitsMap = new HashMap<Integer, Double>();
            int long1 = (int)Math.floor((longitude - distance - this.boundingbox_all[0][0]) * this.mask_long_multiplier);
            int long2 = (int)Math.floor((longitude + distance - this.boundingbox_all[0][0]) * this.mask_long_multiplier);
            int lat1 = (int)Math.floor((latitude - distance - this.boundingbox_all[0][1]) * this.mask_lat_multiplier);
            int lat2 = (int)Math.floor((latitude + distance - this.boundingbox_all[0][1]) * this.mask_lat_multiplier);
            if (long1 >= 0 && long1 < this.mask[0].length && lat1 >= 0 && lat1 < this.mask.length && this.mask[long1][lat1] != null) {
                ali = this.mask[long1][lat1];
                this.checkCells(hitsMap, sra, ali, longitude, latitude, distance);
            }
            if (long1 != long2 && long2 >= 0 && long2 < this.mask[0].length && lat1 >= 0 && lat1 < this.mask.length && this.mask[long2][lat1] != null) {
                ali = this.mask[long2][lat1];
                this.checkCells(hitsMap, sra, ali, longitude, latitude, distance);
            }
            if (lat1 != lat2 && long1 >= 0 && long1 < this.mask[0].length && lat2 >= 0 && lat2 < this.mask.length && this.mask[long1][lat2] != null) {
                ali = this.mask[long1][lat2];
                this.checkCells(hitsMap, sra, ali, longitude, latitude, distance);
            }
            if (long1 != long2 && lat1 != lat2 && long2 >= 0 && long2 < this.mask[0].length && lat2 >= 0 && lat2 < this.mask.length && this.mask[long2][lat2] != null) {
                ali = this.mask[long2][lat2];
                this.checkCells(hitsMap, sra, ali, longitude, latitude, distance);
            }
            r = hitsMap.entrySet().stream().map(e -> ImmutablePair.of(e.getKey(), e.getValue())).collect(Collectors.toList());
        } else {
            ArrayList<ImmutablePair<Integer, Double>> hits = new ArrayList<ImmutablePair<Integer, Double>>();
            for (int i = 0; i < sra.size(); ++i) {
                Double d = sra.get(i).distance(longitude, latitude, distance);
                if (d == null) continue;
                hits.add((ImmutablePair<Integer, Double>)ImmutablePair.of((Object)i, (Object)d));
            }
            r = hits;
        }
        return r;
    }

    private void checkCells(Map<Integer, Double> hitsMap, ArrayList<ComplexRegion> sra, ArrayList<Integer> ali, double longitude, double latitude, double distance) {
        for (int i = 0; i < ali.size(); ++i) {
            Double x = sra.get(ali.get(i)).distance(longitude, latitude, distance);
            if (x == null) continue;
            hitsMap.merge((int)ali.get(i), x, Math::min);
        }
    }
}

