/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.intersect;

import au.org.ala.layers.intersect.Polygon;
import au.org.ala.layers.intersect.PolygonZ;
import au.org.ala.layers.intersect.Shape;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.log4j.Logger;

class ShapeRecord
implements Serializable {
    static final long serialVersionUID = -4426292545633280160L;
    private static final Logger logger = Logger.getLogger(ShapeRecord.class);
    int recordnumber;
    int contentlength;
    Shape shape;

    public ShapeRecord(ByteBuffer bb, int shapetype, int expectedRecordNumber) {
        bb.order(ByteOrder.BIG_ENDIAN);
        this.recordnumber = bb.getInt();
        if (this.recordnumber != expectedRecordNumber + 1) {
            return;
        }
        this.contentlength = bb.getInt();
        switch (shapetype) {
            case 5: {
                this.shape = new Polygon(bb);
                break;
            }
            case 15: {
                this.shape = new PolygonZ(bb, this.contentlength);
                break;
            }
            default: {
                logger.info((Object)("unknown shape type: " + shapetype));
            }
        }
    }

    public String toString() {
        if (this.shape != null) {
            return "Record Number: " + this.recordnumber + ", Content Length: " + this.contentlength + this.shape.toString();
        }
        return "Record Number: " + this.recordnumber + ", Content Length: " + this.contentlength;
    }

    public double[] getPoints(int part) {
        return this.shape.getPoints(part);
    }

    public int getNumberOfParts() {
        return this.shape.getNumberOfParts();
    }
}

