/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.intersect;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.log4j.Logger;

class DBFField
implements Serializable {
    static final long serialVersionUID = 6130879839715559815L;
    private static final Logger logger = Logger.getLogger(DBFField.class);
    String name;
    char type;
    int displacement;
    int length;
    int decimals;
    int flags;
    byte[] data;

    static String convertToUTF8(String myString) {
        byte[] ptext = myString.getBytes(StandardCharsets.UTF_8);
        return new String(ptext, StandardCharsets.UTF_8);
    }

    public DBFField(byte firstbyte, ByteBuffer buffer, Charset charset) {
        int i;
        byte[] ba = new byte[12];
        ba[0] = firstbyte;
        for (i = 1; i < 11; ++i) {
            ba[i] = buffer.get();
        }
        try {
            this.name = DBFField.convertToUTF8(new String(ba, charset).trim().toUpperCase());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        byte[] ba2 = new byte[]{buffer.get()};
        try {
            this.type = DBFField.convertToUTF8(new String(ba2, charset).trim()).charAt(0);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.displacement = (0xFF & buffer.get()) + 256 * ((0xFF & buffer.get()) + 256 * ((0xFF & buffer.get()) + 256 * (0xFF & buffer.get())));
        this.length = 0xFF & buffer.get();
        this.data = new byte[this.length];
        this.decimals = 0xFF & buffer.get();
        this.flags = 0xFF & buffer.get();
        for (i = 0; i < 13; ++i) {
            buffer.get();
        }
    }

    void test() {
    }

    public String getName() {
        return this.name;
    }

    public char getType() {
        return this.type;
    }

    public byte[] getDataBlock() {
        return this.data;
    }

    public String toString() {
        return "name: " + this.name + " type: " + this.type + " displacement: " + this.displacement + " length: " + this.length + "\r\n";
    }
}

