/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.intersect;

import au.org.ala.layers.intersect.SimpleRegion;
import java.util.ArrayList;
import java.util.Arrays;

public class ComplexRegion
extends SimpleRegion {
    ArrayList<SimpleRegion> simpleregions = new ArrayList();
    double[][] boundingbox_all = new double[2][2];
    int value = -1;
    byte[][] mask = null;
    Object[][] maskDepth;
    int mask_height;
    int mask_width;
    double mask_long_multiplier;
    double mask_lat_multiplier;
    ArrayList<Integer> polygons = new ArrayList();

    public static SimpleRegion parseComplexRegion(String[] polygons) {
        ComplexRegion cr = new ComplexRegion();
        for (String s : polygons) {
            cr.addPolygon(ComplexRegion.parseSimpleRegion(s));
        }
        cr.useMask(-1, -1, -1);
        return cr;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value_) {
        this.value = value_;
    }

    @Override
    public double[][] getBoundingBox() {
        return this.boundingbox_all;
    }

    public void addPolygon(SimpleRegion sr) {
        this.simpleregions.add(sr);
        double[][] bb = sr.getBoundingBox();
        if (this.simpleregions.size() == 1 || this.boundingbox_all[0][0] > bb[0][0]) {
            this.boundingbox_all[0][0] = bb[0][0];
        }
        if (this.simpleregions.size() == 1 || this.boundingbox_all[1][0] < bb[1][0]) {
            this.boundingbox_all[1][0] = bb[1][0];
        }
        if (this.simpleregions.size() == 1 || this.boundingbox_all[0][1] > bb[0][1]) {
            this.boundingbox_all[0][1] = bb[0][1];
        }
        if (this.simpleregions.size() == 1 || this.boundingbox_all[1][1] < bb[1][1]) {
            this.boundingbox_all[1][1] = bb[1][1];
        }
        this.bounding_box = this.boundingbox_all;
    }

    @Override
    public boolean isWithin(double longitude, double latitude) {
        return this.isWithin(longitude, latitude, 0.0);
    }

    @Override
    public boolean isWithin(double longitude, double latitude, double distance) {
        int i;
        if (this.simpleregions.size() == 1) {
            return this.simpleregions.get(0).isWithin(longitude, latitude, distance);
        }
        if (this.boundingbox_all[0][0] - distance > longitude || this.boundingbox_all[1][0] + distance < longitude || this.boundingbox_all[0][1] - distance > latitude || this.boundingbox_all[1][1] + distance < latitude) {
            return false;
        }
        short[] countsIn = new short[this.polygons.get(this.polygons.size() - 1) + 1];
        if (this.mask != null) {
            int long1 = (int)Math.floor((longitude - this.boundingbox_all[0][0] - distance) * this.mask_long_multiplier);
            int lat1 = (int)Math.floor((latitude - this.boundingbox_all[0][1] - distance) * this.mask_lat_multiplier);
            if (long1 == this.mask[0].length) {
                --long1;
            }
            if (lat1 == this.mask.length) {
                --lat1;
            }
            if (this.mask[lat1][long1] == 2) {
                return true;
            }
            if (this.mask[lat1][long1] == 0 || this.mask[lat1][long1] == 0) {
                return false;
            }
            if (this.maskDepth != null && this.maskDepth[lat1][long1] != null) {
                int i2;
                int[] d = (int[])this.maskDepth[lat1][long1];
                for (i2 = 0; i2 < d.length; ++i2) {
                    if (!this.simpleregions.get(d[i2]).isWithin(longitude, latitude, distance)) continue;
                    int n = this.polygons.get(d[i2]);
                    countsIn[n] = (short)(countsIn[n] + 1);
                }
                for (i2 = 0; i2 < countsIn.length; ++i2) {
                    if (countsIn[i2] % 2 != 1) continue;
                    return true;
                }
            }
        }
        for (i = 0; i < this.simpleregions.size(); ++i) {
            if (!this.simpleregions.get(i).isWithin(longitude, latitude, distance)) continue;
            int n = this.polygons.get(i);
            countsIn[n] = (short)(countsIn[n] + 1);
        }
        for (i = 0; i < countsIn.length; ++i) {
            if (countsIn[i] % 2 != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public Double distance(double longitude, double latitude, double distance) {
        int i;
        if (this.simpleregions.size() == 1) {
            return this.simpleregions.get(0).distance(longitude, latitude, distance);
        }
        if (this.boundingbox_all[0][0] - distance > longitude || this.boundingbox_all[1][0] + distance < longitude || this.boundingbox_all[0][1] - distance > latitude || this.boundingbox_all[1][1] + distance < latitude) {
            return null;
        }
        short[] countsInOrNear = new short[this.polygons.get(this.polygons.size() - 1) + 1];
        short[] countsIn = new short[this.polygons.get(this.polygons.size() - 1) + 1];
        double[] distanceFrom = new double[this.polygons.get(this.polygons.size() - 1) + 1];
        for (i = 0; i < this.simpleregions.size(); ++i) {
            Double x = this.simpleregions.get(i).distance(longitude, latitude, distance);
            if (x == null) continue;
            if (countsInOrNear[this.polygons.get(i)] == 0) {
                distanceFrom[this.polygons.get((int)i).intValue()] = x;
            } else if (Math.abs(x) < Math.abs(distanceFrom[this.polygons.get(i)])) {
                distanceFrom[this.polygons.get((int)i).intValue()] = x;
            }
            int n = this.polygons.get(i);
            countsInOrNear[n] = (short)(countsInOrNear[n] + 1);
            if (x != 0.0) continue;
            int n2 = this.polygons.get(i);
            countsIn[n2] = (short)(countsIn[n2] + 1);
        }
        for (i = 0; i < countsInOrNear.length; ++i) {
            if (countsIn[i] % 2 == 1) {
                return 0.0;
            }
            if (countsInOrNear[i] <= 0) continue;
            countsInOrNear[i] = 0;
            double dist = Double.MAX_VALUE;
            Boolean onLand = null;
            for (int j = 0; j < this.simpleregions.size(); ++j) {
                Double x;
                if (this.polygons.get(j) != i || (x = this.simpleregions.get(j).distance(longitude, latitude, distance, true)) == null) continue;
                if (onLand == null) {
                    int n = i;
                    countsInOrNear[n] = (short)(countsInOrNear[n] + 1);
                    dist = Math.min(dist, Math.abs(x));
                    if (x >= 0.0) continue;
                    onLand = true;
                    continue;
                }
                if (onLand.booleanValue() && x >= 0.0) continue;
                if (onLand.booleanValue() && x >= -distance) {
                    dist = Math.min(dist, Math.abs(x));
                    onLand = false;
                    int n = i;
                    countsInOrNear[n] = (short)(countsInOrNear[n] + 1);
                    continue;
                }
                if (onLand.booleanValue()) {
                    dist = Math.min(dist, Math.abs(x));
                    onLand = false;
                    int n = i;
                    countsInOrNear[n] = (short)(countsInOrNear[n] + 1);
                    continue;
                }
                int n = i;
                countsInOrNear[n] = (short)(countsInOrNear[n] + 1);
                dist = Math.min(dist, Math.abs(x));
                if (x >= 0.0) continue;
                onLand = true;
            }
            if (Math.abs(dist) < distance) {
                countsInOrNear[i] = 1;
                distanceFrom[i] = dist;
                continue;
            }
            countsInOrNear[i] = 0;
        }
        double near = Double.MAX_VALUE;
        for (int i2 = 0; i2 < countsInOrNear.length; ++i2) {
            if (countsInOrNear[i2] % 2 != 1) continue;
            return distanceFrom[i2];
        }
        if (near < Double.MAX_VALUE) {
            return near;
        }
        return null;
    }

    public void useMask(int width, int height, int depthThreashold) {
        int j;
        int i;
        double[][] bb = this.getBoundingBox();
        int length = 0;
        for (SimpleRegion sr : this.simpleregions) {
            length += sr.getNumberOfPoints();
        }
        int w = (int)((bb[1][0] - bb[0][0]) * 3.0);
        int h = (int)((bb[1][1] - bb[0][1]) * 3.0);
        if (length > 5000) {
            w = 200;
            h = 200;
        }
        if (w > 200) {
            w = 200;
        }
        if (h > 200) {
            h = 200;
        }
        if (width == -1) {
            width = w;
        }
        if (height == -1) {
            height = h;
        }
        if (depthThreashold == -1) {
            depthThreashold = 100;
        }
        if (width < 3 || height < 3) {
            return;
        }
        this.mask_width = width;
        this.mask_height = height;
        this.mask_long_multiplier = (double)this.mask_width / (this.boundingbox_all[1][0] - this.boundingbox_all[0][0]);
        this.mask_lat_multiplier = (double)this.mask_height / (this.boundingbox_all[1][1] - this.boundingbox_all[0][1]);
        this.mask = new byte[height][width];
        ArrayList[][] md = null;
        if (this.simpleregions.size() > depthThreashold) {
            md = new ArrayList[height][width];
        }
        byte[][] shapemask = new byte[height][width];
        byte[][] shapemaskregion = new byte[height][width];
        int k = 0;
        while (k < this.simpleregions.size()) {
            int p = k;
            while (k < this.simpleregions.size() && (p == k || this.polygons.get(k - 1) == this.polygons.get(k))) {
                SimpleRegion sr = this.simpleregions.get(k);
                sr.getOverlapGridCells(this.boundingbox_all[0][0], this.boundingbox_all[0][1], this.boundingbox_all[1][0], this.boundingbox_all[1][1], width, height, shapemaskregion);
                for (i = 0; i < height; ++i) {
                    for (j = 0; j < width; ++j) {
                        if (shapemaskregion[i][j] == 1 || shapemask[i][j] == 1) {
                            shapemask[i][j] = 1;
                            if (md != null) {
                                if (md[i][j] == null) {
                                    md[i][j] = new ArrayList();
                                }
                                md[i][j].add(k);
                            }
                        } else if (shapemaskregion[i][j] == 2) {
                            shapemask[i][j] = shapemask[i][j] == 2 ? 0 : 2;
                            if (md != null) {
                                if (md[i][j] == null) {
                                    md[i][j] = new ArrayList();
                                }
                                md[i][j].add(k);
                            }
                        }
                        shapemaskregion[i][j] = 0;
                    }
                }
                ++k;
            }
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    if (shapemask[i][j] == 2 || this.mask[i][j] == 2) {
                        this.mask[i][j] = 2;
                    } else if (shapemask[i][j] == 1) {
                        this.mask[i][j] = 1;
                    }
                    shapemask[i][j] = 0;
                }
            }
        }
        if (md != null) {
            this.maskDepth = new Object[md.length][md[0].length];
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    if (md[i][j] == null || this.mask[i][j] != 1) continue;
                    int[] d = new int[md[i][j].size()];
                    for (k = 0; k < d.length; ++k) {
                        d[k] = (Integer)md[i][j].get(k);
                    }
                    this.maskDepth[i][j] = d;
                }
            }
        }
    }

    @Override
    public int[][] getOverlapGridCells(double longitude1, double latitude1, double longitude2, double latitude2, int width, int height, byte[][] three_state_map, boolean noCellsReturned) {
        boolean cellsReturned;
        int j;
        int i;
        if (three_state_map == null) {
            three_state_map = new byte[height][width];
        }
        byte[][] tmpMask = new byte[height][width];
        int k = 0;
        while (k < this.simpleregions.size()) {
            int p = k;
            while (k < this.simpleregions.size() && (p == k || this.polygons.get(k - 1).equals(this.polygons.get(k)))) {
                SimpleRegion sr = this.simpleregions.get(k);
                sr.getOverlapGridCells_Acc(longitude1, latitude1, longitude2, latitude2, width, height, tmpMask);
                ++k;
            }
            this.fillAccMask(p, k - 1, longitude1, latitude1, longitude2, latitude2, width, height, tmpMask, true);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    if (tmpMask[i][j] == 2 || three_state_map[i][j] == 2) {
                        three_state_map[i][j] = 2;
                    } else if (tmpMask[i][j] == 1) {
                        three_state_map[i][j] = 1;
                    }
                    tmpMask[i][j] = 0;
                }
            }
        }
        boolean bl = cellsReturned = !noCellsReturned;
        if (cellsReturned) {
            int[][] data = new int[width * height][2];
            int p = 0;
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    if (three_state_map[i][j] == 0) continue;
                    data[p][0] = j;
                    data[p][1] = i;
                    ++p;
                }
            }
            data = (int[][])Arrays.copyOf(data, p);
        }
        return null;
    }

    @Override
    public boolean isWithin_EPSG900913(double longitude, double latitude) {
        int i;
        short[] countsIn = new short[this.polygons.get(this.polygons.size() - 1) + 1];
        for (i = 0; i < this.simpleregions.size(); ++i) {
            if (!this.simpleregions.get(i).isWithin_EPSG900913(longitude, latitude)) continue;
            int n = this.polygons.get(i);
            countsIn[n] = (short)(countsIn[n] + 1);
        }
        for (i = 0; i < countsIn.length; ++i) {
            if (countsIn[i] % 2 != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public int[][] getOverlapGridCells_EPSG900913(double longitude1, double latitude1, double longitude2, double latitude2, int width, int height, byte[][] three_state_map, boolean noCellsReturned) {
        boolean cellsReturned;
        int j;
        int i;
        int[][] output = null;
        byte[][] mask = three_state_map;
        if (mask == null) {
            three_state_map = mask = new byte[height][width];
        }
        byte[][] tmpMask = new byte[height][width];
        int k = 0;
        while (k < this.simpleregions.size()) {
            int p = k;
            while (k < this.simpleregions.size() && (p == k || this.polygons.get(k - 1).equals(this.polygons.get(k)))) {
                SimpleRegion sr = this.simpleregions.get(k);
                sr.getOverlapGridCells_Acc_EPSG900913(longitude1, latitude1, longitude2, latitude2, width, height, tmpMask);
                ++k;
            }
            this.fillAccMask_EPSG900913(k, p - 1, longitude1, latitude1, longitude2, latitude2, width, height, tmpMask, true);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    if (tmpMask[i][j] == 2 || mask[i][j] == 2) {
                        mask[i][j] = 2;
                    } else if (tmpMask[i][j] == 1) {
                        mask[i][j] = 1;
                    }
                    tmpMask[i][j] = 0;
                }
            }
        }
        boolean bl = cellsReturned = !noCellsReturned;
        if (cellsReturned) {
            int[][] data = new int[width * height][2];
            int p = 0;
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    if (mask[i][j] == 0) continue;
                    data[p][0] = j;
                    data[p][1] = i;
                    ++p;
                }
            }
            data = (int[][])Arrays.copyOf(data, p);
            return data;
        }
        return null;
    }

    void addSet(ArrayList<SimpleRegion> simpleRegions) {
        int nextSetNumber = this.polygons.size() > 0 ? this.polygons.get(this.polygons.size() - 1) + 1 : 0;
        for (int i = 0; i < simpleRegions.size(); ++i) {
            this.addPolygon(simpleRegions.get(i));
            this.polygons.add(nextSetNumber);
        }
    }

    public int[][] fillAccMask(int startPolygon, int endPolygon, double longitude1, double latitude1, double longitude2, double latitude2, int width, int height, byte[][] three_state_map, boolean noCellsReturned) {
        boolean cellsReturned;
        double divx = (longitude2 - longitude1) / (double)width;
        double divy = (latitude2 - latitude1) / (double)height;
        int[][] data = null;
        boolean bl = cellsReturned = !noCellsReturned;
        if (cellsReturned) {
            data = new int[width * height][2];
        }
        int p = 0;
        for (int j = 0; j < three_state_map[0].length; ++j) {
            for (int i = 0; i < three_state_map.length; ++i) {
                if (three_state_map[i][j] != 1) {
                    if (j == 0 || three_state_map[i][j - 1] == 1) {
                        if (i > 0 && (three_state_map[i - 1][j] == 2 || three_state_map[i - 1][j] == 0)) {
                            three_state_map[i][j] = three_state_map[i - 1][j];
                        } else {
                            int count = 0;
                            for (int k = startPolygon; k <= endPolygon; ++k) {
                                count += this.isWithin((double)j * divx + divx / 2.0 + longitude1, (double)i * divy + divy / 2.0 + latitude1) ? 1 : 0;
                            }
                            if (count % 2 == 1) {
                                three_state_map[i][j] = 2;
                            }
                        }
                    } else {
                        three_state_map[i][j] = three_state_map[i][j - 1];
                    }
                }
                if (!cellsReturned || three_state_map[i][j] == 0) continue;
                data[p][0] = j;
                data[p][1] = i;
                ++p;
            }
        }
        if (data != null) {
            data = (int[][])Arrays.copyOf(data, p);
        }
        return data;
    }

    public int[][] fillAccMask_EPSG900913(int startPolygon, int endPolygon, double longitude1, double latitude1, double longitude2, double latitude2, int width, int height, byte[][] three_state_map, boolean noCellsReturned) {
        boolean cellsReturned;
        double divx = (longitude2 - longitude1) / (double)width;
        double divy = (latitude2 - latitude1) / (double)height;
        int[][] data = null;
        boolean bl = cellsReturned = !noCellsReturned;
        if (cellsReturned) {
            data = new int[width * height][2];
        }
        int p = 0;
        for (int j = 0; j < three_state_map[0].length; ++j) {
            for (int i = 0; i < three_state_map.length; ++i) {
                if (three_state_map[i][j] != 1) {
                    if (j == 0 || three_state_map[i][j - 1] == 1) {
                        if (i > 0 && (three_state_map[i - 1][j] == 2 || three_state_map[i - 1][j] == 0)) {
                            three_state_map[i][j] = three_state_map[i - 1][j];
                        } else {
                            int count = 0;
                            for (int k = startPolygon; k <= endPolygon; ++k) {
                                count += this.isWithin_EPSG900913((double)j * divx + divx / 2.0 + longitude1, (double)i * divy + divy / 2.0 + latitude1) ? 1 : 0;
                            }
                            if (count % 2 == 1) {
                                three_state_map[i][j] = 2;
                            }
                        }
                    } else {
                        three_state_map[i][j] = three_state_map[i][j - 1];
                    }
                }
                if (!cellsReturned || three_state_map[i][j] == 0) continue;
                data[p][0] = j;
                data[p][1] = i;
                ++p;
            }
        }
        if (data != null) {
            data = (int[][])Arrays.copyOf(data, p);
        }
        return data;
    }
}

