/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.dao;

import au.org.ala.layers.dao.LayerIntersectDAO;
import au.org.ala.layers.dao.SearchDAO;
import au.org.ala.layers.dto.GridClass;
import au.org.ala.layers.dto.IntersectionFile;
import au.org.ala.layers.dto.SearchObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import net.sf.json.JSONArray;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Service;

@Service(value="searchDao")
public class SearchDAOImpl
implements SearchDAO {
    private static final Logger logger = Logger.getLogger(SearchDAOImpl.class);
    private JdbcTemplate jdbcTemplate;
    private NamedParameterJdbcTemplate jdbcParameterTemplate;
    @Resource(name="layerIntersectDao")
    private LayerIntersectDAO layerIntersectDao;

    @Resource(name="dataSource")
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.jdbcParameterTemplate = new NamedParameterJdbcTemplate(dataSource);
    }

    @Override
    public List<SearchObject> findByCriteria(String criteria, int limit) {
        logger.info((Object)("Getting search results for query: " + criteria));
        String sql = "select pid, id, name, \"desc\" as description, fid, fieldname from searchobjects(?,?)";
        return this.addGridClassesToSearch(this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(SearchObject.class), new Object[]{"%" + criteria + "%", limit}), criteria, limit, null, null);
    }

    @Override
    public List<SearchObject> findByCriteria(String criteria, int offset, int limit) {
        return this.findByCriteria(criteria, offset, limit, new ArrayList<String>(), new ArrayList<String>());
    }

    @Override
    public List<SearchObject> findByCriteria(String criteria, int limit, List<String> includeFieldIds, List<String> excludeFieldIds) {
        return this.findByCriteria(criteria, 0, limit, includeFieldIds, excludeFieldIds);
    }

    @Override
    public List<SearchObject> findByCriteria(String criteria, int offset, int limit, List<String> includeFieldIds, List<String> excludeFieldIds) {
        logger.info((Object)("Getting search results for query: " + criteria));
        String fieldFilter = "";
        List<String> fieldIds = null;
        if (includeFieldIds != null && !includeFieldIds.isEmpty()) {
            fieldFilter = " and o.fid in ( :fieldIds ) ";
            fieldIds = includeFieldIds;
        } else if (excludeFieldIds != null && !excludeFieldIds.isEmpty()) {
            fieldFilter = " and o.fid not in ( :fieldIds ) ";
            fieldIds = excludeFieldIds;
        }
        String sql = "with o as (select o.pid as pid ,o.id as id, o.name as name, o.desc as description, o.fid as fid, f.name as fieldname from objects o inner join fields f on o.fid = f.id where o.name ilike :criteria and o.namesearch=true " + fieldFilter + ") select pid, id, name, description, fid, fieldname, (select json_agg(a.f) from (select distinct (fid || '|' || fieldname) as f from o) a) as fields, position(:nativeQ in lower(name)) as rank from o order by rank, name, pid limit :limit offset :offset";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("nativeQ", (Object)criteria);
        parameters.addValue("criteria", (Object)("%" + criteria + "%"));
        parameters.addValue("limit", (Object)limit);
        parameters.addValue("offset", (Object)offset);
        if (!fieldFilter.isEmpty()) {
            parameters.addValue("fieldIds", fieldIds);
        }
        List searchObjects = this.jdbcParameterTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(SearchObject.class));
        List additionalFields = null;
        Object fieldMatches = null;
        if (searchObjects.size() == 0 && offset > 0) {
            sql = "select distinct (f.id || '|' || f.name) as fields from objects o inner join fields f on o.fid = f.id where o.name ilike :criteria and o.namesearch=true " + fieldFilter;
            additionalFields = this.jdbcParameterTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(SearchObject.class));
        }
        List<SearchObject> result = this.addGridClassesToSearch(searchObjects, criteria, limit, includeFieldIds, excludeFieldIds);
        if (additionalFields != null && additionalFields.size() > 0 && result.size() > 0) {
            JSONArray ja = JSONArray.fromObject((Object)result.get(0).getFields());
            for (SearchObject af : additionalFields) {
                ja.add((Object)af.getFields());
            }
            String fields = ja.toString();
            for (SearchObject so : result) {
                so.setFields(fields);
            }
        }
        return result;
    }

    private List<SearchObject> addGridClassesToSearch(List<SearchObject> search, String criteria, int limit, List<String> includeFieldIds, List<String> excludeFieldIds) {
        criteria = criteria.toLowerCase();
        int vacantCount = limit - search.size();
        HashSet<String> fieldSet = new HashSet<String>();
        JSONArray initialFields = null;
        initialFields = search.size() > 0 && search.get(0).getFields() != null ? JSONArray.fromObject((Object)search.get(0).getFields()) : new JSONArray();
        if (vacantCount > 0) {
            for (Map.Entry<String, IntersectionFile> e : this.layerIntersectDao.getConfig().getIntersectionFiles().entrySet()) {
                IntersectionFile f = e.getValue();
                boolean fieldAdded = false;
                if (!"a".equalsIgnoreCase(f.getType()) || f.getClasses() == null || !e.getKey().equals(f.getFieldId()) || includeFieldIds != null && !includeFieldIds.isEmpty() && !includeFieldIds.contains(f.getFieldId()) || excludeFieldIds != null && !excludeFieldIds.isEmpty() && excludeFieldIds.contains(f.getFieldId())) continue;
                for (Map.Entry<Integer, GridClass> c : f.getClasses().entrySet()) {
                    if (c.getValue().getName().toLowerCase().indexOf(criteria) < 0) continue;
                    search.add(SearchObject.create(f.getLayerPid() + ":" + c.getKey(), f.getLayerPid() + ":" + c.getKey(), c.getValue().getName(), null, f.getFieldId(), f.getFieldName(), ""));
                    if (fieldAdded) continue;
                    fieldSet.add(f.getFieldId() + "|" + f.getFieldName());
                    fieldAdded = true;
                }
            }
            if (!fieldSet.isEmpty()) {
                initialFields.addAll(fieldSet);
                String fieldSetString = initialFields.toString();
                for (SearchObject so : search) {
                    so.setFields(fieldSetString);
                }
            }
        }
        return search;
    }
}

