/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SpatialUtil {
    private static final Logger logger = Logger.getLogger(SpatialUtil.class);
    static HashMap<Double, double[]> commonGridLatitudeArea = new HashMap();
    static double meters_per_pixel = 78271.517;
    private static int map_zoom = 21;
    private static int map_offset = 0x10000000;
    private static double map_radius = (double)map_offset / Math.PI;

    public static double calculateArea(double[][] areaarr) {
        try {
            double totalarea = 0.0;
            double[] d = areaarr[0];
            for (int f = 1; f < areaarr.length - 2; ++f) {
                totalarea += SpatialUtil.Mh(d, areaarr[f], areaarr[f + 1]);
            }
            totalarea = Math.abs(totalarea * 6378137.0 * 6378137.0);
            return totalarea / 1000.0 / 1000.0;
        }
        catch (Exception e) {
            logger.error((Object)"Error in calculateArea", (Throwable)e);
            return 0.0;
        }
    }

    private static double Mh(double[] a, double[] b, double[] c) {
        return SpatialUtil.Nh(a, b, c) * SpatialUtil.hi(a, b, c);
    }

    private static double Nh(double[] a, double[] b, double[] c) {
        double[][] poly = new double[][]{a, b, c, a};
        double[] area = new double[3];
        int i = 0;
        double j = 0.0;
        for (i = 0; i < 3; ++i) {
            area[i] = SpatialUtil.vd(poly[i], poly[i + 1]);
            j += area[i];
        }
        double f = Math.tan((j /= 2.0) / 2.0);
        for (i = 0; i < 3; ++i) {
            f *= Math.tan((j - area[i]) / 2.0);
        }
        return 4.0 * Math.atan(Math.sqrt(Math.abs(f)));
    }

    private static double hi(double[] a, double[] b, double[] c) {
        double[][] d = new double[][]{a, b, c};
        int i = 0;
        double[][] bb = new double[3][3];
        for (i = 0; i < 3; ++i) {
            double lng = d[i][0];
            double lat = d[i][1];
            double y = SpatialUtil.Uc(lat);
            double x = SpatialUtil.Uc(lng);
            bb[i][0] = Math.cos(y) * Math.cos(x);
            bb[i][1] = Math.cos(y) * Math.sin(x);
            bb[i][2] = Math.sin(y);
        }
        return bb[0][0] * bb[1][1] * bb[2][2] + bb[1][0] * bb[2][1] * bb[0][2] + bb[2][0] * bb[0][1] * bb[1][2] - bb[0][0] * bb[2][1] * bb[1][2] - bb[1][0] * bb[0][1] * bb[2][2] - bb[2][0] * bb[1][1] * bb[0][2] > 0.0 ? 1.0 : -1.0;
    }

    private static double vd(double[] a, double[] b) {
        double lng1 = a[0];
        double lat1 = a[1];
        double lng2 = b[0];
        double lat2 = b[1];
        double c = SpatialUtil.Uc(lat1);
        double d = SpatialUtil.Uc(lat2);
        return 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((c - d) / 2.0), 2.0) + Math.cos(c) * Math.cos(d) * Math.pow(Math.sin((SpatialUtil.Uc(lng1) - SpatialUtil.Uc(lng2)) / 2.0), 2.0)));
    }

    private static double Uc(double a) {
        return a * (Math.PI / 180);
    }

    public static double calculateArea(String wkt) {
        double sumarea = 0.0;
        String areaWorking = wkt;
        ArrayList<String> stringsList = new ArrayList<String>();
        if (areaWorking.startsWith("GEOMETRYCOLLECTION")) {
            areaWorking = areaWorking.replace(", ", ",");
            areaWorking = areaWorking.replace(") ", ")");
            areaWorking = areaWorking.replace(" )", ")");
            areaWorking = areaWorking.replace(" (", "(");
            areaWorking = areaWorking.replace("( ", "(");
            int p1 = areaWorking.indexOf("POLYGON", 0);
            int p2 = areaWorking.indexOf("MULTIPOLYGON", 0);
            int posStart = p1 < 0 ? p2 : (p2 < 0 ? p1 : Math.min(p1, p2));
            String endString = null;
            endString = posStart == p1 ? "))" : ")))";
            int posEnd = areaWorking.indexOf(endString, posStart);
            while (posStart > 0 && posEnd > 0) {
                if (endString.length() == 3) {
                    for (String s : areaWorking.substring(posStart, posEnd - 1).split("\\)\\),\\(\\(")) {
                        stringsList.add(s);
                    }
                } else {
                    stringsList.add(areaWorking.substring(posStart, posEnd - 1));
                }
                posStart = posEnd;
                p1 = areaWorking.indexOf("POLYGON", posStart);
                p2 = areaWorking.indexOf("MULTIPOLYGON", posStart);
                posStart = p1 < 0 ? p2 : (p2 < 0 ? p1 : Math.min(p1, p2));
                endString = posStart == p1 ? "))" : ")))";
                posEnd = areaWorking.indexOf(endString, posStart);
            }
            if (posStart >= 0) {
                stringsList.add(areaWorking.substring(posStart, areaWorking.length()));
            }
        } else if (areaWorking.startsWith("MULTIPOLYGON")) {
            for (String s : areaWorking.split("\\)\\),\\(\\(")) {
                stringsList.add(s);
            }
        } else if (areaWorking.startsWith("POLYGON")) {
            stringsList.add(areaWorking);
        }
        for (String w : stringsList) {
            if (w.contains("ENVELOPE")) continue;
            String[] areas = w.split("\\),\\(");
            double shapearea = 0.0;
            for (String area : areas) {
                area = area.replace("MULTIPOLYGON", "");
                area = area.replace("POLYGON", "");
                area = area.replace(")", "");
                area = area.replace("(", "");
                String[] areaarr = area.split(",");
                for (int i = 0; i < areaarr.length - 1; ++i) {
                    areaarr[i] = areaarr[i].trim();
                }
                boolean isWorld = true;
                for (int i = 0; i < areaarr.length - 1; ++i) {
                    String[] darea = areaarr[i].split(" ");
                    if (Double.parseDouble(darea[0]) < -174.0 && Double.parseDouble(darea[1]) < -84.0 || Double.parseDouble(darea[0]) < -174.0 && Double.parseDouble(darea[1]) > 84.0 || Double.parseDouble(darea[0]) > 174.0 && Double.parseDouble(darea[1]) > 84.0 || Double.parseDouble(darea[0]) > 174.0 && Double.parseDouble(darea[1]) < -84.0) continue;
                    isWorld = false;
                }
                if (isWorld) {
                    return 5.1E14;
                }
                double totalarea = 0.0;
                String d = areaarr[0];
                for (int f = 1; f < areaarr.length - 2; ++f) {
                    totalarea += SpatialUtil.Mh(d, areaarr[f], areaarr[f + 1]);
                }
                shapearea += totalarea * 6378137.0 * 6378137.0;
            }
            sumarea += Math.abs(shapearea);
        }
        return sumarea;
    }

    private static double Mh(String a, String b, String c) {
        return SpatialUtil.Nh(a, b, c) * SpatialUtil.hi(a, b, c);
    }

    private static double Nh(String a, String b, String c) {
        String[] poly = new String[]{a, b, c, a};
        double[] area = new double[3];
        int i = 0;
        double j = 0.0;
        for (i = 0; i < 3; ++i) {
            area[i] = SpatialUtil.vd(poly[i], poly[i + 1]);
            j += area[i];
        }
        double f = Math.tan((j /= 2.0) / 2.0);
        for (i = 0; i < 3; ++i) {
            f *= Math.tan((j - area[i]) / 2.0);
        }
        return 4.0 * Math.atan(Math.sqrt(Math.abs(f)));
    }

    private static double hi(String a, String b, String c) {
        String[] d = new String[]{a, b, c};
        int i = 0;
        double[][] bb = new double[3][3];
        for (i = 0; i < 3; ++i) {
            String[] coords = d[i].split(" ");
            double lng = Double.parseDouble(coords[0]);
            double lat = Double.parseDouble(coords[1]);
            double y = SpatialUtil.Uc(lat);
            double x = SpatialUtil.Uc(lng);
            bb[i][0] = Math.cos(y) * Math.cos(x);
            bb[i][1] = Math.cos(y) * Math.sin(x);
            bb[i][2] = Math.sin(y);
        }
        return bb[0][0] * bb[1][1] * bb[2][2] + bb[1][0] * bb[2][1] * bb[0][2] + bb[2][0] * bb[0][1] * bb[1][2] - bb[0][0] * bb[2][1] * bb[1][2] - bb[1][0] * bb[0][1] * bb[2][2] - bb[2][0] * bb[1][1] * bb[0][2] > 0.0 ? 1.0 : -1.0;
    }

    private static double vd(String a, String b) {
        String[] coords1 = a.split(" ");
        double lng1 = Double.parseDouble(coords1[0]);
        double lat1 = Double.parseDouble(coords1[1]);
        String[] coords2 = b.split(" ");
        double lng2 = Double.parseDouble(coords2[0]);
        double lat2 = Double.parseDouble(coords2[1]);
        double c = SpatialUtil.Uc(lat1);
        double d = SpatialUtil.Uc(lat2);
        return 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((c - d) / 2.0), 2.0) + Math.cos(c) * Math.cos(d) * Math.pow(Math.sin((SpatialUtil.Uc(lng1) - SpatialUtil.Uc(lng2)) / 2.0), 2.0)));
    }

    public static int convertLngToPixel(double lng) {
        return (int)Math.round((double)map_offset + map_radius * lng * Math.PI / 180.0);
    }

    public static double convertPixelToLng(int px) {
        return (double)(px - map_offset) / map_radius * 180.0 / Math.PI;
    }

    public static int convertLatToPixel(double lat) {
        return (int)Math.round((double)map_offset - map_radius * Math.log((1.0 + Math.sin(lat * Math.PI / 180.0)) / (1.0 - Math.sin(lat * Math.PI / 180.0))) / 2.0);
    }

    public static double convertPixelToLat(int px) {
        return Math.asin((Math.pow(Math.E, (double)(map_offset - px) / map_radius * 2.0) - 1.0) / (1.0 + Math.pow(Math.E, (double)(map_offset - px) / map_radius * 2.0))) * 180.0 / Math.PI;
    }

    public static double convertMetersToPixels(double meters, double latitude, int zoom) {
        return meters / (Math.cos(latitude * Math.PI / 180.0) * 2.0 * Math.PI * 6378137.0 / (256.0 * Math.pow(2.0, zoom)));
    }

    public static double convertPixelsToMeters(int pixels, double latitude, int zoom) {
        return Math.cos(latitude * Math.PI / 180.0) * 2.0 * Math.PI * 6378137.0 / (256.0 * Math.pow(2.0, zoom)) * (double)pixels;
    }

    public static double convertMetersToLng(double meters) {
        return meters / 2.0037508342789244E7 * 180.0;
    }

    public static double convertLngToMeters(double lng) {
        return lng * 2.0037508342789244E7 / 180.0;
    }

    public static double convertMetersToLat(double meters) {
        return 57.29577951308232 * (2.0 * Math.atan(Math.exp(meters / 2.0037508342789244E7 * Math.PI)) - 1.5707963267948966);
    }

    public static double convertLatToMeters(double lat) {
        return Math.log(Math.tan((lat / 180.0 * Math.PI + 1.5707963267948966) / 2.0)) * 2.0037508342789244E7 / Math.PI;
    }

    public static int planeDistance(double lat1, double lng1, double lat2, double lng2, int zoom) {
        int x1 = SpatialUtil.convertLngToPixel(lng1);
        int y1 = SpatialUtil.convertLatToPixel(lat1);
        int x2 = SpatialUtil.convertLngToPixel(lng2);
        int y2 = SpatialUtil.convertLatToPixel(lat2);
        int distance = (int)Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
        return distance >> map_zoom - zoom;
    }

    public static double cellArea(double resolution, double latitude) {
        double[] areas = commonGridLatitudeArea.get(resolution);
        if (areas == null) {
            areas = SpatialUtil.buildCommonGridLatitudeArea(resolution);
            commonGridLatitudeArea.put(resolution, areas);
        }
        return areas[(int)(Math.floor(Math.abs(latitude / resolution)) * resolution)];
    }

    static double[] buildCommonGridLatitudeArea(double resolution) {
        int parts = (int)Math.ceil(90.0 / resolution);
        double[] areas = new double[parts];
        for (int i = 0; i < parts; ++i) {
            double minx = 0.0;
            double maxx = resolution;
            double miny = resolution * (double)i;
            double maxy = miny + resolution;
            areas[i] = SpatialUtil.calculateArea(new double[][]{{minx, miny}, {minx, maxy}, {maxx, maxy}, {maxx, miny}, {minx, miny}});
        }
        return areas;
    }
}

