/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.legend;

import au.org.ala.layers.intersect.Grid;
import au.org.ala.layers.legend.Legend;
import au.org.ala.layers.legend.LegendEqualArea;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class GridLegend {
    private static final Logger logger = Logger.getLogger(GridLegend.class);

    public GridLegend(String filename, String output_name, boolean useAreaEvaluation, String[] legendNames, FileWriter cutpointFile, int scaleDown, boolean minAsTransparent) {
        Grid g = new Grid(filename);
        if (legendNames != null) {
            Arrays.sort(legendNames);
        }
        int sampleInterval = (double)g.ncols / 1000.0 * ((double)g.nrows / 1000.0) < 0.128 ? 1 : (int)((double)g.ncols / 1000.0 * ((double)g.nrows / 1000.0) / 0.128);
        float[] d = g.getGrid(sampleInterval);
        if (legendNames != null) {
            Arrays.sort(legendNames);
        }
        Arrays.sort(d);
        int firstNaN = d.length;
        int i = d.length - 1;
        while (i >= 0 && Float.isNaN(d[i])) {
            firstNaN = i--;
        }
        if (firstNaN < d.length) {
            float[] copy = new float[firstNaN];
            System.arraycopy(d, 0, copy, 0, firstNaN);
            d = copy;
        }
        d[0] = (float)g.minval;
        d[d.length - 1] = (float)g.maxval;
        Legend[] legends = new Legend[]{new LegendEqualArea()};
        int minI = 0;
        double minE = 0.0;
        boolean firstTime = true;
        for (int i2 = 0; i2 < legends.length; ++i2) {
            if (legendNames == null || Arrays.binarySearch(legendNames, legends[i2].getTypeName()) < 0) continue;
            legends[i2].generate(d);
            legends[i2].determineGroupSizes(d);
            double e2 = 0.0;
            e2 = useAreaEvaluation ? legends[i2].evaluateStdDevArea(d) : legends[i2].evaluateStdDev(d);
            try {
                new File(output_name + ".png").delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            d = null;
            g = null;
            System.gc();
            g = new Grid(filename);
            d = g.getGrid(sampleInterval);
            if (sampleInterval > 1) {
                logger.info((Object)"test output image is messed up because of >1 sample interval (large file)");
            }
            if (g.ncols > 0) {
                legends[i2].exportImage(d, g.ncols, output_name + ".png", Math.max(scaleDown, g.ncols / 50), minAsTransparent);
            } else {
                legends[i2].exportImage(d, 500, output_name + ".png", Math.max(scaleDown, 10), minAsTransparent);
            }
            legends[i2].exportLegend(output_name + "_legend.txt");
            legends[i2].exportSLD(g, output_name + ".sld", g.units, true, minAsTransparent);
            logger.info((Object)(output_name + ", " + legends[i2].getTypeName() + ": " + String.valueOf(e2)));
            if (!firstTime && !(e2 <= minE)) continue;
            minE = e2;
            minI = i2;
            firstTime = false;
        }
        try {
            if (cutpointFile != null) {
                cutpointFile.append(filename).append(",").append(legends[minI].getTypeName());
                float[] minmax = legends[minI].getMinMax();
                float[] f = legends[minI].getCutoffFloats();
                cutpointFile.append(",min,").append(String.valueOf(minmax[0]));
                cutpointFile.append(",#cutpoints,").append(String.valueOf(f.length));
                cutpointFile.append(",cutpoints");
                for (int i3 = 0; i3 < f.length; ++i3) {
                    cutpointFile.append(",").append(String.valueOf(f[i3]));
                }
                cutpointFile.append(",distribution");
                int[] a = useAreaEvaluation ? legends[minI].groupSizesArea : legends[minI].groupSizes;
                for (int i4 = 0; i4 < a.length; ++i4) {
                    cutpointFile.append(",").append(String.valueOf(a[i4]));
                }
                cutpointFile.append("\n");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            logger.info((Object)"args[0]=grid file without .grd or .gri\nargs[1]=output prefix for +_cutpoints.csv +.jpg +_legend.txt\nargs[2]=thumbnail scale down factor (optional) e.g. 1 (default), 2, 4, 8, 16 (16x16 times smaller)\nargs[3]=min as transparent (optional) e.g. 0=false (default), 1=true");
            return;
        }
        String gridfilename = args[0];
        String outputfilename = null;
        outputfilename = args.length < 2 ? args[0] : args[1];
        int scaleDown = 1;
        if (args.length >= 3) {
            scaleDown = Integer.parseInt(args[2]);
        }
        boolean minAsTransparent = false;
        if (args.length >= 4) {
            minAsTransparent = args[3].equals("1");
        }
        GridLegend.generateGridLegend(gridfilename, outputfilename, scaleDown, minAsTransparent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean generateGridLegend(String gridfilename, String outputfilename, int scaleDown, boolean minAsTransparent) {
        boolean ret = true;
        String[] legendTypes = new String[]{"Equal Area"};
        OutputStreamWriter fw = null;
        try {
            fw = new FileWriter(outputfilename + "_cutpoints.csv");
            new GridLegend(gridfilename, outputfilename, true, legendTypes, (FileWriter)fw, scaleDown, minAsTransparent);
            fw.flush();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ret = false;
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return ret;
    }
}

