/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.ingestion;

import au.org.ala.layers.dto.Layer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class ThumbnailGenerator {
    private static final Logger logger = Logger.getLogger(ThumbnailGenerator.class);
    private static final int THUMBNAIL_WIDTH = 200;
    private static final int THUMBNAIL_HEIGHT = 200;

    public static void many(List<Layer> layers, String thumbnailDir, boolean force) {
        for (Layer layer : layers) {
            if (!force && ThumbnailGenerator.hasThumbnail(layer.getName(), thumbnailDir)) continue;
            ThumbnailGenerator.one(layer, thumbnailDir);
        }
    }

    private static boolean hasThumbnail(String layerName, String thumbnailDir) {
        return new File(ThumbnailGenerator.thumbnailFileName(layerName, thumbnailDir)).exists();
    }

    private static String thumbnailFileName(String layerName, String thumbnailDir) {
        return thumbnailDir + "/ALA:" + layerName + ".jpg";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void one(Layer layer, String thumbnailDir) {
        int gwcPos;
        String geoserverUrl = layer.getDisplaypath();
        int wmsPos = geoserverUrl.indexOf("/wms");
        if (wmsPos >= 0) {
            geoserverUrl = geoserverUrl.substring(0, wmsPos);
        }
        if ((gwcPos = geoserverUrl.indexOf("/gwc")) >= 0) {
            geoserverUrl = geoserverUrl.substring(0, gwcPos);
        }
        String thumburl = geoserverUrl + "/wms/reflect?layers=ALA:" + layer.getName() + "&width=" + 200 + "&height=" + 200;
        InputStream is = null;
        ByteArrayOutputStream out = null;
        FileOutputStream fos = null;
        try {
            URL url = new URL(thumburl);
            is = url.openStream();
            BufferedInputStream in = new BufferedInputStream(is);
            out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int n = 0;
            while (-1 != (n = ((InputStream)in).read(buf))) {
                out.write(buf, 0, n);
            }
            String thumbnailFileName = ThumbnailGenerator.thumbnailFileName(layer.getName(), thumbnailDir);
            FileUtils.deleteQuietly((File)new File(thumbnailFileName));
            fos = new FileOutputStream(thumbnailFileName);
            fos.write(out.toByteArray());
            fos.flush();
        }
        catch (Exception e) {
            logger.error((Object)("failed to create thumbnail for layer: " + layer.getName() + ", thumbnailDir: " + thumbnailDir), (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

