/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.intersect;

import au.org.ala.layers.intersect.DBFField;
import java.io.FileInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.apache.log4j.Logger;

class DBFHeader
implements Serializable {
    static final long serialVersionUID = -1807390252140128281L;
    private static final Logger logger = Logger.getLogger(DBFHeader.class);
    int filetype;
    int[] lastupdate;
    int numberofrecords;
    int recordsoffset;
    int recordlength;
    int tableflags;
    ArrayList<DBFField> fields;
    boolean isvalid = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBFHeader(String filename) {
        FileInputStream fis = null;
        try {
            byte nextfsr;
            int i;
            fis = new FileInputStream(filename);
            FileChannel fc = fis.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate((int)fc.size());
            fc.read(buffer);
            buffer.flip();
            buffer.order(ByteOrder.BIG_ENDIAN);
            this.filetype = 0xFF & buffer.get();
            this.lastupdate = new int[3];
            for (i = 0; i < 3; ++i) {
                this.lastupdate[i] = 0xFF & buffer.get();
            }
            this.numberofrecords = (0xFF & buffer.get()) + 256 * ((0xFF & buffer.get()) + 256 * ((0xFF & buffer.get()) + 256 * (0xFF & buffer.get())));
            this.recordsoffset = (0xFF & buffer.get()) + 256 * (0xFF & buffer.get());
            this.recordlength = (0xFF & buffer.get()) + 256 * (0xFF & buffer.get());
            for (i = 0; i < 16; ++i) {
                buffer.get();
            }
            this.tableflags = 0xFF & buffer.get();
            buffer.get();
            buffer.get();
            buffer.get();
            this.fields = new ArrayList();
            while ((nextfsr = buffer.get()) != 13) {
                this.fields.add(new DBFField(nextfsr, buffer));
            }
            this.isvalid = true;
        }
        catch (Exception e) {
            logger.error((Object)("loading dbfheader error: " + filename + ": " + e.toString()), (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public ArrayList<DBFField> getFields() {
        return this.fields;
    }

    public int getRecordsOffset() {
        return this.recordsoffset;
    }

    public int getNumberOfRecords() {
        return this.numberofrecords;
    }

    public String[] getColumnNames() {
        String[] s = new String[this.fields.size()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = this.fields.get(i).getName();
        }
        return s;
    }

    public int getColumnIdx(String column_name) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!this.fields.get(i).getName().equalsIgnoreCase(column_name)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        if (!this.isvalid) {
            return "invalid header";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("filetype: ");
        sb.append(String.valueOf(this.filetype));
        sb.append("\r\nlastupdate: ");
        sb.append(String.valueOf(this.lastupdate[0]));
        sb.append(" ");
        sb.append(String.valueOf(this.lastupdate[1]));
        sb.append(" ");
        sb.append(String.valueOf(this.lastupdate[2]));
        sb.append("\r\nnumberofrecords: ");
        sb.append(String.valueOf(this.numberofrecords));
        sb.append("\r\nrecordsoffset: ");
        sb.append(String.valueOf(this.recordsoffset));
        sb.append("\r\nrecordlength: ");
        sb.append(String.valueOf(this.recordlength));
        sb.append("\r\ntableflags: ");
        sb.append(String.valueOf(this.tableflags));
        sb.append("\r\nnumber of fields: ");
        sb.append(String.valueOf(this.fields.size()));
        for (int i = 0; i < this.fields.size(); ++i) {
            sb.append(this.fields.get(i).toString());
        }
        return sb.toString();
    }
}

