/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.distribution;

import au.org.ala.layers.distribution.AreaThread;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class DistributionGenerator {
    private static final Logger logger = Logger.getLogger(DistributionGenerator.class);
    static int CONCURRENT_THREADS = 6;
    static String db_url = "jdbc:postgresql://localhost:5432/layersdb";
    static String db_usr = "postgres";
    static String db_pwd = "postgres";

    private static Connection getConnection() {
        Connection conn = null;
        try {
            Class.forName("org.postgresql.Driver");
            String url = db_url;
            conn = DriverManager.getConnection(url, db_usr, db_pwd);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return conn;
    }

    public static void main(String[] args) {
        logger.info((Object)"Calculates and fills empty area_km in table distributionshapes.\n\nargs[0] = threadcount, args[1] = db connection string,\n args[2] = db username,\n args[3] = password\n");
        if (args.length >= 4) {
            CONCURRENT_THREADS = Integer.parseInt(args[0]);
            db_url = args[1];
            db_usr = args[2];
            db_pwd = args[3];
        }
        long start = System.currentTimeMillis();
        while (DistributionGenerator.updateArea() > 0) {
            logger.info((Object)("time since start= " + (System.currentTimeMillis() - start) + "ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int updateArea() {
        Connection conn = null;
        try {
            int j;
            conn = DistributionGenerator.getConnection();
            String sql = "SELECT id, ST_AsText(the_geom) as wkt FROM distributionshapes WHERE area_km is null limit 100";
            if (conn == null) {
                logger.error((Object)"connection is null");
            } else {
                logger.debug((Object)"connection is not null");
            }
            Statement s1 = conn.createStatement();
            ResultSet rs1 = s1.executeQuery(sql);
            LinkedBlockingQueue<String[]> data = new LinkedBlockingQueue<String[]>();
            while (rs1.next()) {
                data.put(new String[]{rs1.getString("id"), rs1.getString("wkt")});
            }
            logger.info((Object)("next " + data.size()));
            int size = data.size();
            if (size == 0) {
                int n = 0;
                return n;
            }
            CountDownLatch cdl = new CountDownLatch(data.size());
            AreaThread[] threads = new AreaThread[CONCURRENT_THREADS];
            for (j = 0; j < CONCURRENT_THREADS; ++j) {
                threads[j] = new AreaThread(data, cdl, DistributionGenerator.getConnection().createStatement());
                threads[j].start();
            }
            cdl.await();
            for (j = 0; j < CONCURRENT_THREADS; ++j) {
                try {
                    threads[j].s.getConnection().close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                threads[j].interrupt();
            }
            int n = size;
            return n;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return 0;
    }
}

