/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.client;

import au.org.ala.layers.dao.AnalysisLayerDAO;
import au.org.ala.layers.dao.FieldDAO;
import au.org.ala.layers.dao.LayerDAO;
import au.org.ala.layers.dao.LayerIntersectDAO;
import au.org.ala.layers.dao.ObjectDAO;
import au.org.ala.layers.dao.UserDataDAO;
import au.org.ala.layers.dto.Layer;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Client {
    private static final Logger logger = Logger.getLogger(Client.class);
    static ApplicationContext gContext = null;

    public static void main(String[] args) {
        logger.info((Object)"Layers Store CLI client");
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("spring/app-config.xml");
        LayerDAO layerDao = (LayerDAO)context.getBean("layerDao");
        List<Layer> layers = layerDao.getLayers();
        logger.info((Object)("Got " + layers.size() + " layers"));
        for (Layer l : layers) {
            logger.info((Object)(" > " + l.getName()));
        }
    }

    public static void setContext(ApplicationContext context) {
        gContext = context;
    }

    static void initContext() {
        if (gContext == null) {
            BeanFactoryLocator obj = ContextSingletonBeanFactoryLocator.getInstance();
            gContext = obj != null && obj instanceof ApplicationContext && ((ApplicationContext)obj).getBean("layerDao") != null ? (ApplicationContext)obj : new ClassPathXmlApplicationContext("spring/app-config.xml");
        }
    }

    public static LayerDAO getLayerDao() {
        Client.initContext();
        return (LayerDAO)gContext.getBean("layerDao");
    }

    public static LayerIntersectDAO getLayerIntersectDao() {
        Client.initContext();
        LayerIntersectDAO lidao = (LayerIntersectDAO)gContext.getBean("layerIntersectDao");
        lidao.getConfig();
        return lidao;
    }

    public static FieldDAO getFieldDao() {
        Client.initContext();
        return (FieldDAO)gContext.getBean("fieldDao");
    }

    public static AnalysisLayerDAO getAnalysisLayerDao() {
        Client.initContext();
        return (AnalysisLayerDAO)gContext.getBean("analysislayerDao");
    }

    public static ObjectDAO getObjectDao() {
        Client.initContext();
        return (ObjectDAO)gContext.getBean("objectDao");
    }

    public static UserDataDAO getUserDataDao() {
        Client.initContext();
        return (UserDataDAO)gContext.getBean("userDataDao");
    }
}

