/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.util;

import java.io.Serializable;

public class LayerFilter
implements Serializable {
    static final long serialVersionUID = -2733856402542621244L;
    String layername = "";
    double minimum_value = 0.0;
    double maximum_value = 0.0;
    String[] ids = null;

    public LayerFilter(String layername, double min, double max) {
        this.layername = layername;
        this.minimum_value = min;
        this.maximum_value = max;
    }

    public LayerFilter(String layername, String[] ids) {
        this.layername = layername;
        this.ids = ids;
    }

    public static LayerFilter[] parseLayerFilters(String s) {
        if (s.toUpperCase().startsWith("ENVELOPE(")) {
            s = s.substring("ENVELOPE(".length(), s.length() - 1);
        }
        String[] terms = s.split(":");
        LayerFilter[] lf = new LayerFilter[terms.length];
        int i = 0;
        for (String t : terms) {
            lf[i] = LayerFilter.parseLayerFilter(t);
            ++i;
        }
        return lf;
    }

    public static LayerFilter parseLayerFilter(String s) {
        String[] tokens;
        if (s.toUpperCase().startsWith("ENVELOPE(")) {
            s = s.substring("ENVELOPE(".length(), s.length() - 1);
        }
        if ((tokens = s.split(","))[0].startsWith("el")) {
            return new LayerFilter(tokens[0], Double.parseDouble(tokens[1]), Double.parseDouble(tokens[2]));
        }
        String[] ids = new String[tokens.length - 1];
        System.arraycopy(tokens, 1, ids, 0, ids.length);
        return new LayerFilter(tokens[0], ids);
    }

    public String getLayername() {
        return this.layername;
    }

    public double getMinimum_value() {
        return this.minimum_value;
    }

    public double getMaximum_value() {
        return this.maximum_value;
    }

    public String[] getIds() {
        return this.ids;
    }

    public boolean isValid(double value) {
        double correction = 1.0E-7;
        return !Double.isNaN(value) && value + correction >= this.minimum_value && value - correction <= this.maximum_value;
    }

    public boolean isContextual() {
        return this.layername.startsWith("cl");
    }
}

