/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.util;

import au.org.ala.layers.client.Client;
import au.org.ala.layers.dao.FieldDAO;
import au.org.ala.layers.dao.LayerDAO;
import au.org.ala.layers.dao.LayerIntersectDAO;
import au.org.ala.layers.dao.ObjectDAO;
import au.org.ala.layers.dto.Field;
import au.org.ala.layers.dto.Layer;
import au.org.ala.layers.dto.Objects;
import au.org.ala.layers.intersect.Grid;
import au.org.ala.layers.intersect.IntersectConfig;
import au.org.ala.layers.util.Bil2diva;
import au.org.ala.layers.util.Diva2bil;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class AnalysisLayerUtil {
    private static final Logger logger = Logger.getLogger(AnalysisLayerUtil.class);

    public static void main(String[] args) {
        logger.info((Object)"prepare one grid file for analysis.\nargs[0] = source diva grid filename (without .gri or .grd)\nargs[1] = output diva grid filename (without .gri or .grd)\nargs[2] = resolution in decimal degrees, e.g. 0.01\nargs[3] = path to gdal\n\nprepare all grid files for analysis.\nargs[0] = 'all', prepare all layers for analysis\n\nprepare all shape or grid files for analysis.\nargs[0] = 'all', operate on all layers\nargs[1] = 'shapes' or 'grids' to operate on only grids or shapes\n\n");
        if (args == null || args.length == 0) {
            args = new String[]{"auto", "grids"};
        }
        if (args.length == 1 && (args[0].equals("auto") || args[0].equals("all"))) {
            AnalysisLayerUtil.processShapeFiles();
            AnalysisLayerUtil.processGridFiles();
        } else if (args.length == 2 && (args[0].equals("auto") || args[0].equals("all"))) {
            if (args[1].equals("shapes")) {
                AnalysisLayerUtil.processShapeFiles();
            } else {
                AnalysisLayerUtil.processGridFiles();
            }
        } else if (args.length == 4) {
            if (AnalysisLayerUtil.diva2Analysis(args[0], args[1], Double.parseDouble(args[2]), args[3], true)) {
                logger.info((Object)"successful");
            } else {
                logger.info((Object)"unsuccessful");
            }
        }
    }

    public static boolean diva2Analysis(String srcFilepath, String dstFilepath, Double resolution, String gdalPath, boolean force) {
        try {
            File sgrd = new File(srcFilepath + ".grd");
            File sgri = new File(srcFilepath + ".gri");
            File dgrd = new File(dstFilepath + ".grd");
            File dgri = new File(dstFilepath + ".gri");
            if (force || !dgrd.exists() || !dgri.exists() || dgrd.lastModified() < sgrd.lastModified() || dgri.lastModified() < sgri.lastModified()) {
                double maxy;
                Grid g = new Grid(srcFilepath);
                double minx = g.xmin == (double)((int)(g.xmin / resolution)) * resolution ? g.xmin : (double)((int)(g.xmin / resolution)) * resolution + resolution;
                double maxx = g.xmax == (double)((int)(g.xmax / resolution)) * resolution ? g.xmax : (double)((int)(g.xmax / resolution)) * resolution;
                double miny = g.ymin == (double)((int)(g.ymin / resolution)) * resolution ? g.ymin : (double)((int)(g.ymin / resolution)) * resolution + resolution;
                double d = maxy = g.ymax == (double)((int)(g.ymax / resolution)) * resolution ? g.ymax : (double)((int)(g.ymax / resolution)) * resolution;
                if (maxx < minx + 2.0 * resolution) {
                    maxx = minx + 2.0 * resolution;
                }
                if (maxy < miny + 2.0 * resolution) {
                    maxy = miny + 2.0 * resolution;
                }
                new File(new File(dstFilepath).getParent()).mkdirs();
                if (minx == g.xmin && miny == g.ymin && maxx == g.xmax && maxy == g.ymax && resolution == g.xres && resolution == g.yres) {
                    AnalysisLayerUtil.fileCopy(srcFilepath + ".gri", dstFilepath + ".gri");
                    AnalysisLayerUtil.fileCopy(srcFilepath + ".grd", dstFilepath + ".grd");
                } else {
                    File tmpBil = File.createTempFile("tmpbil", "");
                    if (!Diva2bil.diva2bil(srcFilepath, tmpBil.getPath())) {
                        return false;
                    }
                    File tmpxBil = File.createTempFile("tmpxbil", "");
                    if (!AnalysisLayerUtil.gdal_warp(gdalPath, tmpBil.getPath() + ".bil", tmpxBil.getPath() + ".bil", resolution, minx, miny, maxx, maxy, g.nodatavalue)) {
                        return false;
                    }
                    if (!Bil2diva.bil2diva(tmpxBil.getPath(), dstFilepath, "")) {
                        return false;
                    }
                    AnalysisLayerUtil.deleteFiles(new String[]{tmpBil.getPath(), tmpBil.getPath() + ".bil", tmpBil.getPath() + ".hdr", tmpxBil.getPath(), tmpxBil.getPath() + ".bil", tmpxBil.getPath() + ".hdr", tmpxBil.getPath() + ".bil.aux.xml"});
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static boolean gdal_warp(String gdalPath, String srcFilename, String dstFilename, double resolution, double minx, double miny, double maxx, double maxy, double nodatavalue) {
        Runtime runtime = Runtime.getRuntime();
        try {
            String line;
            logger.info((Object)("Got gdal_path: " + gdalPath));
            String base_command = gdalPath + File.separator + "gdalwarp -r cubicspline -te " + minx + " " + miny + " " + maxx + " " + maxy + " -dstnodata " + String.valueOf(nodatavalue) + " -tr " + resolution + " " + resolution + " -of EHdr ";
            String command = base_command + srcFilename + " " + dstFilename;
            logger.info((Object)("Exec'ing " + command));
            Process proc = runtime.exec(command);
            logger.info((Object)"Setting up output stream readers");
            InputStreamReader isr = new InputStreamReader(proc.getInputStream());
            InputStreamReader eisr = new InputStreamReader(proc.getErrorStream());
            BufferedReader br = new BufferedReader(isr);
            BufferedReader ebr = new BufferedReader(eisr);
            logger.info((Object)String.format("Output of running %s is:", command));
            while ((line = br.readLine()) != null) {
                logger.info((Object)line);
            }
            while ((line = ebr.readLine()) != null) {
                logger.info((Object)line);
            }
            int exitVal = proc.waitFor();
            logger.info((Object)exitVal);
            if (exitVal == 0) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static void deleteFiles(String[] filesToDelete) {
        for (String s : filesToDelete) {
            try {
                new File(s).delete();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fileCopy(String src, String dst) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int len;
            fis = new FileInputStream(src);
            fos = new FileOutputStream(dst);
            byte[] buf = new byte[0x100000];
            while ((len = fis.read(buf)) > 0) {
                fos.write(buf, 0, len);
            }
            fos.flush();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static void processShapeFiles() {
        LayerIntersectDAO liDao = Client.getLayerIntersectDao();
        LayerDAO layerDao = Client.getLayerDao();
        FieldDAO fieldDao = Client.getFieldDao();
        liDao.getConfig();
        List<Double> resolutions = IntersectConfig.getAnalysisResolutions();
        List<Field> fields = fieldDao.getFields();
        for (Field f : fields) {
            try {
                if (!f.isAnalysis().booleanValue() || !f.getType().equals("c")) continue;
                logger.info((Object)("processing: " + f.getId()));
                Layer l = layerDao.getLayerById(Integer.parseInt(f.getSpid()));
                File tmpShp = File.createTempFile("tmpshp", "");
                Double d = 0.01;
                StringBuilder stringBuilder = new StringBuilder();
                liDao.getConfig();
                String string = stringBuilder.append(IntersectConfig.getLayerFilesPath()).append(File.separator).append(l.getPath_orig()).toString();
                String string2 = tmpShp.getPath();
                String string3 = f.getId();
                StringBuilder stringBuilder2 = new StringBuilder();
                liDao.getConfig();
                String string4 = stringBuilder2.append(IntersectConfig.getAnalysisLayerFilesPath()).append(File.separator).append(d).append(File.separator).append(f.getId()).toString();
                liDao.getConfig();
                if (AnalysisLayerUtil.shp2Analysis(string, string2, string3, string4, d, IntersectConfig.getGdalPath(), false)) {
                    logger.info((Object)("successful for: " + f.getId() + " @ " + d));
                } else {
                    logger.info((Object)("unsuccessful for: " + f.getId() + " @ " + d));
                }
                AnalysisLayerUtil.deleteFiles(new String[]{tmpShp.getPath(), tmpShp.getPath() + ".shp", tmpShp.getPath() + ".shx", tmpShp.getPath() + ".dbf", tmpShp.getPath() + ".fix", tmpShp.getPath() + ".qix", tmpShp.getPath() + ".prj", tmpShp.getPath() + ".txt"});
            }
            catch (Exception e) {
                logger.error((Object)("Error processing: " + f.getId()), (Throwable)e);
            }
        }
    }

    private static void processGridFiles() {
        LayerIntersectDAO liDao = Client.getLayerIntersectDao();
        LayerDAO layerDao = Client.getLayerDao();
        FieldDAO fieldDao = Client.getFieldDao();
        liDao.getConfig();
        List<Double> resolutions = IntersectConfig.getAnalysisResolutions();
        List<Field> fields = fieldDao.getFields();
        for (Field f : fields) {
            try {
                int i;
                if (!f.isAnalysis().booleanValue() || !f.getType().equals("e") && !f.getType().equals("a") && !f.getType().equals("b")) continue;
                Layer l = layerDao.getLayerById(Integer.parseInt(f.getSpid()));
                StringBuilder stringBuilder = new StringBuilder();
                liDao.getConfig();
                Grid g = new Grid(stringBuilder.append(IntersectConfig.getLayerFilesPath()).append(File.separator).append(l.getPath_orig()).toString());
                double minRes = Math.min(g.xres, g.yres);
                for (i = 0; i < resolutions.size() && resolutions.get(i) != minRes; ++i) {
                    if (!(resolutions.get(i) > minRes)) continue;
                    if (i <= 0) break;
                    --i;
                    break;
                }
                while (i < resolutions.size()) {
                    if (resolutions.get(i) >= minRes) {
                        logger.info((Object)("processing: " + l.getPath_orig()));
                        StringBuilder stringBuilder2 = new StringBuilder();
                        liDao.getConfig();
                        String string = stringBuilder2.append(IntersectConfig.getLayerFilesPath()).append(File.separator).append(l.getPath_orig()).toString();
                        StringBuilder stringBuilder3 = new StringBuilder();
                        liDao.getConfig();
                        String string2 = stringBuilder3.append(IntersectConfig.getAnalysisLayerFilesPath()).append(File.separator).append(resolutions.get(i)).append(File.separator).append(f.getId()).toString();
                        liDao.getConfig();
                        if (AnalysisLayerUtil.diva2Analysis(string, string2, resolutions.get(i), IntersectConfig.getGdalPath(), false)) {
                            if (f.getType().equals("a") || f.getType().equals("b")) {
                                StringBuilder stringBuilder4 = new StringBuilder();
                                liDao.getConfig();
                                String string3 = stringBuilder4.append(IntersectConfig.getLayerFilesPath()).append(File.separator).append(l.getPath_orig()).append(".txt").toString();
                                StringBuilder stringBuilder5 = new StringBuilder();
                                liDao.getConfig();
                                AnalysisLayerUtil.copyFile(string3, stringBuilder5.append(IntersectConfig.getAnalysisLayerFilesPath()).append(File.separator).append(resolutions.get(i)).append(File.separator).append(f.getId()).append(".txt").toString());
                            }
                            logger.info((Object)("successful for: " + f.getId() + " @ " + resolutions.get(i)));
                        } else {
                            logger.info((Object)("unsuccessful for: " + f.getId() + " @ " + resolutions.get(i)));
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                logger.error((Object)("error processing: " + f.getId()), (Throwable)e);
            }
        }
    }

    public static boolean shp2Analysis(String srcOrigFilepath, String srcFilepath, String fieldId, String dstFilepath, Double resolution, String gdalPath, boolean force) {
        try {
            File sshp = new File(srcOrigFilepath + ".shp");
            File tmpShp = new File(srcFilepath + ".shp");
            File dgrd = new File(dstFilepath + ".grd");
            File dgri = new File(dstFilepath + ".gri");
            if (force || !dgrd.exists() || !dgri.exists() || dgrd.lastModified() < sshp.lastModified() || dgri.lastModified() < sshp.lastModified()) {
                double maxy;
                new File(new File(dstFilepath).getParent()).mkdirs();
                if (!tmpShp.exists() && !AnalysisLayerUtil.fieldToShapeFile(fieldId, srcFilepath)) {
                    return false;
                }
                FileDataStore store = FileDataStoreFinder.getDataStore((File)tmpShp);
                ReferencedEnvelope re = store.getFeatureSource().getBounds();
                double minx = re.getMinX() == (double)((int)(re.getMinX() / resolution)) * resolution ? re.getMinX() : (double)((int)(re.getMinX() / resolution)) * resolution + resolution;
                double maxx = re.getMaxX() == (double)((int)(re.getMaxX() / resolution)) * resolution ? re.getMaxX() : (double)((int)(re.getMaxX() / resolution)) * resolution;
                double miny = re.getMinY() == (double)((int)(re.getMinY() / resolution)) * resolution ? re.getMinY() : (double)((int)(re.getMinY() / resolution)) * resolution + resolution;
                double d = maxy = re.getMaxY() == (double)((int)(re.getMaxY() / resolution)) * resolution ? re.getMaxY() : (double)((int)(re.getMaxY() / resolution)) * resolution;
                if (maxx < minx + 2.0 * resolution) {
                    maxx = minx + 2.0 * resolution;
                }
                if (maxy < miny + 2.0 * resolution) {
                    maxy = miny + 2.0 * resolution;
                }
                File tmpBil = File.createTempFile("tmpbil", "");
                if (!AnalysisLayerUtil.gdal_rasterize(gdalPath, tmpShp.getPath(), tmpBil.getPath() + ".bil", resolution, minx, miny, maxx, maxy)) {
                    return false;
                }
                if (!Bil2diva.bil2diva(tmpBil.getPath(), dstFilepath, "")) {
                    return false;
                }
                AnalysisLayerUtil.copyFile(srcFilepath + ".txt", dstFilepath + ".txt");
                AnalysisLayerUtil.deleteFiles(new String[]{tmpBil.getPath(), tmpBil.getPath() + ".bil", tmpBil.getPath() + ".hdr"});
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean gdal_rasterize(String gdalPath, String srcFilename, String dstFilename, double resolution, double minx, double miny, double maxx, double maxy) {
        Runtime runtime = Runtime.getRuntime();
        try {
            String line;
            logger.info((Object)("Got gdal_path: " + gdalPath));
            String layername = new File(srcFilename).getName().replace(".shp", "");
            String base_command = gdalPath + File.separator + "gdal_rasterize -ot Int16 -of EHdr -te " + minx + " " + miny + " " + maxx + " " + maxy + " -l " + layername + " -a id  -tr " + resolution + " " + resolution + " ";
            String command = base_command + srcFilename + " " + dstFilename;
            logger.info((Object)("Exec'ing " + command));
            Process proc = runtime.exec(command);
            logger.info((Object)"Setting up output stream readers");
            InputStreamReader isr = new InputStreamReader(proc.getInputStream());
            InputStreamReader eisr = new InputStreamReader(proc.getErrorStream());
            BufferedReader br = new BufferedReader(isr);
            BufferedReader ebr = new BufferedReader(eisr);
            logger.info((Object)String.format("Output of running %s is:", command));
            while ((line = br.readLine()) != null) {
                logger.info((Object)line);
            }
            while ((line = ebr.readLine()) != null) {
                logger.info((Object)line);
            }
            int exitVal = proc.waitFor();
            logger.info((Object)exitVal);
            if (exitVal == 0) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean fieldToShapeFile(String fid, String path) {
        boolean ret = true;
        ShapefileDataStore newDataStore = null;
        try {
            SimpleFeatureType TYPE = DataUtilities.createType((String)"tmpshp", (String)"the_geom:MultiPolygon,id:int");
            ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put("url", new File(path + ".shp").toURI().toURL());
            params.put("create spatial index", Boolean.FALSE);
            newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
            newDataStore.createSchema(TYPE);
            newDataStore.forceSchemaCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            DefaultTransaction transaction = new DefaultTransaction("create");
            String typeName = newDataStore.getTypeNames()[0];
            ContentFeatureSource featureSource = newDataStore.getFeatureSource(typeName);
            SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
            featureStore.setTransaction((Transaction)transaction);
            ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
            SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(TYPE);
            OutputStreamWriter fw = null;
            try {
                fw = new FileWriter(path + ".txt");
                int count = 1;
                ObjectDAO objectDao = Client.getObjectDao();
                for (Objects o : objectDao.getObjectsById(fid)) {
                    String wkt = objectDao.getObjectsGeometryById(o.getPid(), "wkt");
                    WKTReader r = new WKTReader();
                    Geometry geom = r.read(wkt);
                    featureBuilder.add((Object)geom);
                    featureBuilder.add((Object)count);
                    SimpleFeature f = featureBuilder.buildFeature(String.valueOf(count));
                    features.add(f);
                    if (count > 1) {
                        fw.write("\n");
                    }
                    fw.write(count + "=" + o.getId());
                    ++count;
                }
                DefaultFeatureCollection collection = new DefaultFeatureCollection();
                collection.addAll(features);
                featureStore.setTransaction((Transaction)transaction);
                try {
                    featureStore.addFeatures((FeatureCollection)collection);
                    transaction.commit();
                }
                catch (Exception problem) {
                    transaction.rollback();
                }
                finally {
                    transaction.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                ret = false;
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (Exception e) {
                        ret = false;
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            ret = false;
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (newDataStore != null) {
                try {
                    newDataStore.dispose();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(String src, String dst) {
        BufferedReader br = null;
        OutputStreamWriter fw = null;
        try {
            int n;
            br = new BufferedReader(new FileReader(src));
            fw = new FileWriter(dst);
            char[] buffer = new char[1024];
            while ((n = br.read(buffer)) > 0) {
                fw.write(buffer, 0, n);
            }
            fw.flush();
        }
        catch (Exception e) {
            logger.error((Object)("failure to copy: " + src + " to " + dst), (Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void all() {
        AnalysisLayerUtil.processShapeFiles();
        AnalysisLayerUtil.processGridFiles();
    }
}

