/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.intersect;

import au.org.ala.layers.intersect.DBFField;
import au.org.ala.layers.intersect.DBFHeader;
import au.org.ala.layers.intersect.DBFRecord;
import java.io.FileInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.apache.log4j.Logger;

class DBFRecords
implements Serializable {
    static final long serialVersionUID = -2450196133919654852L;
    private static final Logger logger = Logger.getLogger(DBFRecords.class);
    ArrayList<DBFRecord> records = new ArrayList();
    boolean isvalid = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBFRecords(String filename, DBFHeader header) {
        FileInputStream fis = null;
        try {
            logger.info((Object)("start reading shapefile: " + filename));
            fis = new FileInputStream(filename);
            FileChannel fc = fis.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate((int)fc.size() - header.getRecordsOffset());
            fc.read(buffer, header.getRecordsOffset());
            buffer.flip();
            ArrayList<DBFField> fields = header.getFields();
            for (int i = 0; i < header.getNumberOfRecords() && buffer.hasRemaining(); ++i) {
                this.records.add(new DBFRecord(buffer, fields));
            }
            this.isvalid = true;
        }
        catch (Exception e) {
            logger.error((Object)("loading records error: " + filename + ": " + e.toString()), (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DBFRecords(String filename, DBFHeader header, int[] columnIdx, boolean mergeColumns) {
        logger.info((Object)("reading shapefile: " + filename));
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            FileChannel fc = fis.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate((int)fc.size() - header.getRecordsOffset());
            fc.read(buffer, header.getRecordsOffset());
            buffer.flip();
            ArrayList<DBFField> fields = header.getFields();
            for (int i = 0; i < header.getNumberOfRecords() && buffer.hasRemaining(); ++i) {
                this.records.add(new DBFRecord(buffer, fields, columnIdx, mergeColumns));
            }
            this.isvalid = true;
        }
        catch (Exception e) {
            logger.error((Object)("loading records error: " + filename + ": " + e.toString()), (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public String getValue(int row, int column) {
        if (row >= 0 && row < this.records.size()) {
            return this.records.get(row).getValue(column);
        }
        return "";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (DBFRecord r : this.records) {
            sb.append(r.toString());
            sb.append("\r\n");
        }
        return sb.toString();
    }
}

