/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.grid;

import au.org.ala.layers.client.Client;
import au.org.ala.layers.dto.IntersectionFile;
import au.org.ala.layers.intersect.Grid;
import au.org.ala.layers.intersect.IntersectConfig;
import au.org.ala.layers.intersect.SimpleRegion;
import au.org.ala.layers.intersect.SimpleShapeFile;
import au.org.ala.layers.util.LayerFilter;
import au.org.ala.layers.util.SpatialUtil;
import au.org.ala.layers.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class GridCutter {
    private static final Logger logger = Logger.getLogger(GridCutter.class);
    private static String layersUrl = null;

    public static String getLayersUrl() {
        return layersUrl;
    }

    public static void setLayersUrl(String layersUrl) {
        GridCutter.layersUrl = layersUrl;
    }

    public static String cut2(String[] layers, String resolution, SimpleRegion region, LayerFilter[] envelopes, String extentsFilename) {
        String[] layerTypes = new String[layers.length];
        String[] fieldIds = new String[layers.length];
        for (int i = 0; i < layers.length; ++i) {
            IntersectionFile f = Client.getLayerIntersectDao().getConfig().getIntersectionFile(layers[i]);
            fieldIds[i] = f != null ? f.getFieldId() : null;
            layerTypes[i] = Client.getFieldDao().getFieldById(layers[i]).getType();
        }
        return GridCutter.cut2(layers, resolution, region, envelopes, extentsFilename, layerTypes, fieldIds);
    }

    public static String cut2(String[] layers, String resolution, SimpleRegion region, LayerFilter[] envelopes, String extentsFilename, String[] layerTypes, String[] fieldIds) {
        byte[][] mask;
        resolution = GridCutter.confirmResolution(layers, resolution, fieldIds);
        double[][] extents = GridCutter.getLayerExtents(resolution, layers[0], layerTypes[0], fieldIds[0]);
        for (int i = 1; i < layers.length; ++i) {
            if (GridCutter.isValidExtents(extents = GridCutter.internalExtents(extents, GridCutter.getLayerExtents(resolution, layers[i], layerTypes[i], fieldIds[i])))) continue;
            return null;
        }
        if (envelopes != null && !GridCutter.isValidExtents(extents = GridCutter.internalExtents(extents, GridCutter.getLayerFilterExtents(envelopes, fieldIds)))) {
            return null;
        }
        int w = 0;
        int h = 0;
        double res = Double.parseDouble(resolution);
        if (region != null) {
            if (!GridCutter.isValidExtents(extents = GridCutter.internalExtents(extents, region.getBoundingBox()))) {
                return null;
            }
            h = (int)Math.ceil((extents[1][1] - extents[0][1]) / res);
            w = (int)Math.ceil((extents[1][0] - extents[0][0]) / res);
            mask = GridCutter.getRegionMask(res, extents, w, h, region);
        } else if (envelopes != null) {
            h = (int)Math.ceil((extents[1][1] - extents[0][1]) / res);
            w = (int)Math.ceil((extents[1][0] - extents[0][0]) / res);
            mask = GridCutter.getEnvelopeMaskAndUpdateExtents(resolution, res, extents, h, w, envelopes, layerTypes, fieldIds);
            h = (int)Math.ceil((extents[1][1] - extents[0][1]) / res);
            w = (int)Math.ceil((extents[1][0] - extents[0][0]) / res);
        } else {
            h = (int)Math.ceil((extents[1][1] - extents[0][1]) / res);
            w = (int)Math.ceil((extents[1][0] - extents[0][0]) / res);
            mask = GridCutter.getMask(res, extents, w, h);
        }
        String newPath = null;
        try {
            newPath = IntersectConfig.getAnalysisTmpLayerFilesPath() + File.separator + System.currentTimeMillis() + File.separator;
            File directory = new File(newPath);
            directory.mkdir();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        for (int i = 0; i < layers.length; ++i) {
            GridCutter.applyMask(newPath, resolution, extents, w, h, mask, layers[i], fieldIds[i]);
        }
        GridCutter.writeExtents(extentsFilename, extents, w, h);
        return newPath;
    }

    static double[][] internalExtents(double[][] e1, double[][] e2) {
        double[][] internalExtents = new double[2][2];
        internalExtents[0][0] = Math.max(e1[0][0], e2[0][0]);
        internalExtents[0][1] = Math.max(e1[0][1], e2[0][1]);
        internalExtents[1][0] = Math.min(e1[1][0], e2[1][0]);
        internalExtents[1][1] = Math.min(e1[1][1], e2[1][1]);
        return internalExtents;
    }

    static boolean isValidExtents(double[][] e) {
        return e[0][0] < e[1][0] && e[0][1] < e[1][1];
    }

    static double[][] getLayerExtents(String resolution, String layer, String layerType, String fieldId) {
        double[][] extents = new double[2][2];
        if (GridCutter.getLayerPath(resolution, layer, fieldId) == null && "c".equalsIgnoreCase(layerType)) {
            extents[0][0] = -180.0;
            extents[0][1] = -90.0;
            extents[1][0] = 180.0;
            extents[1][1] = 90.0;
        } else {
            Grid g = Grid.getGrid(GridCutter.getLayerPath(resolution, layer, fieldId));
            extents[0][0] = g.xmin;
            extents[0][1] = g.ymin;
            extents[1][0] = g.xmax;
            extents[1][1] = g.ymax;
        }
        return extents;
    }

    public static String getLayerPath(String resolution, String layer) {
        IntersectionFile f = Client.getLayerIntersectDao().getConfig().getIntersectionFile(layer);
        String field = f != null ? f.getFieldId() : null;
        return GridCutter.getLayerPath(resolution, layer, field);
    }

    public static String getLayerPath(String resolution, String layer, String field) {
        File file = new File(IntersectConfig.getAnalysisLayerFilesPath() + File.separator + resolution + File.separator + field + ".grd");
        try {
            while (!file.exists()) {
                TreeMap<Double, String> resolutionDirs = new TreeMap<Double, String>();
                for (File dir : new File(IntersectConfig.getAnalysisLayerFilesPath()).listFiles()) {
                    if (!dir.isDirectory()) continue;
                    try {
                        resolutionDirs.put(Double.parseDouble(dir.getName()), dir.getName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String newResolution = (String)resolutionDirs.higherEntry(Double.parseDouble(resolution)).getValue();
                if (!newResolution.equals(resolution)) {
                    resolution = newResolution;
                    file = new File(IntersectConfig.getAnalysisLayerFilesPath() + File.separator + resolution + File.separator + field + ".grd");
                    continue;
                }
                break;
            }
        }
        catch (Exception resolutionDirs) {
            // empty catch block
        }
        String layerPath = IntersectConfig.getAnalysisLayerFilesPath() + File.separator + resolution + File.separator + field;
        if (new File(layerPath + ".grd").exists()) {
            return layerPath;
        }
        String[] info = GridCutter.getAnalysisLayerInfo(layer);
        if (info != null) {
            return info[1];
        }
        logger.info((Object)("getLayerPath, cannot find for: " + layer + ", " + resolution));
        return null;
    }

    public static boolean existsLayerPath(String resolution, String layer, boolean do_not_lower_resolution) {
        IntersectionFile f = Client.getLayerIntersectDao().getConfig().getIntersectionFile(layer);
        String field = f != null ? f.getFieldId() : null;
        return GridCutter.existsLayerPath(resolution, layer, do_not_lower_resolution, field);
    }

    public static boolean existsLayerPath(String resolution, String layer, boolean do_not_lower_resolution, String field) {
        File file = new File(IntersectConfig.getAnalysisLayerFilesPath() + File.separator + resolution + File.separator + field + ".grd");
        try {
            while (!file.exists() && !do_not_lower_resolution) {
                TreeMap<Double, String> resolutionDirs = new TreeMap<Double, String>();
                for (File dir : new File(IntersectConfig.getAnalysisLayerFilesPath()).listFiles()) {
                    if (!dir.isDirectory()) continue;
                    try {
                        resolutionDirs.put(Double.parseDouble(dir.getName()), dir.getName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String newResolution = (String)resolutionDirs.higherEntry(Double.parseDouble(resolution)).getValue();
                if (!newResolution.equals(resolution)) {
                    resolution = newResolution;
                    file = new File(IntersectConfig.getAnalysisLayerFilesPath() + File.separator + resolution + File.separator + field + ".grd");
                    continue;
                }
                break;
            }
        }
        catch (Exception resolutionDirs) {
            // empty catch block
        }
        String layerPath = IntersectConfig.getAnalysisLayerFilesPath() + File.separator + resolution + File.separator + field;
        if (new File(layerPath + ".grd").exists()) {
            return true;
        }
        String[] info = GridCutter.getAnalysisLayerInfo(layer);
        return info != null;
    }

    static void applyMask(String dir, String resolution, double[][] extents, int w, int h, byte[][] mask, String layer, String fieldId) {
        double[] dfiltered = new double[w * h];
        Grid grid = Grid.getGrid(GridCutter.getLayerPath(resolution, layer, fieldId));
        float[] d = grid.getGrid();
        for (int i = 0; i < dfiltered.length; ++i) {
            dfiltered[i] = Double.NaN;
        }
        double res = Double.parseDouble(resolution);
        for (int i = 0; i < mask.length; ++i) {
            for (int j = 0; j < mask[0].length; ++j) {
                if (mask[i][j] <= 0) continue;
                dfiltered[j + (h - i - 1) * w] = grid.getValues3(new double[][]{{(double)j * res + extents[0][0], (double)i * res + extents[0][1]}}, 40960)[0];
            }
        }
        grid.writeGrid(dir + layer, dfiltered, extents[0][0], extents[0][1], extents[1][0], extents[1][1], res, res, h, w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeExtents(String filename, double[][] extents, int w, int h) {
        if (filename != null) {
            FileWriter fw = null;
            try {
                fw = new FileWriter(filename);
                fw.append(String.valueOf(w)).append("\n");
                fw.append(String.valueOf(h)).append("\n");
                fw.append(String.valueOf(extents[0][0])).append("\n");
                fw.append(String.valueOf(extents[0][1])).append("\n");
                fw.append(String.valueOf(extents[1][0])).append("\n");
                fw.append(String.valueOf(extents[1][1]));
                fw.flush();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    private static byte[][] getRegionMask(double res, double[][] extents, int w, int h, SimpleRegion region) {
        byte[][] mask = new byte[h][w];
        region.getOverlapGridCells(extents[0][0], extents[0][1], extents[1][0], extents[1][1], w, h, mask);
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                if (mask[i][j] <= 0) continue;
                mask[i][j] = 1;
            }
        }
        return mask;
    }

    private static byte[][] getMask(double res, double[][] extents, int w, int h) {
        byte[][] mask = new byte[h][w];
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                mask[i][j] = 1;
            }
        }
        return mask;
    }

    private static byte[][] getEnvelopeMaskAndUpdateExtents(String resolution, double res, double[][] extents, int h, int w, LayerFilter[] envelopes, String[] layerTypes, String[] fieldIds) {
        int j;
        int i;
        int i2;
        byte[][] mask = new byte[h][w];
        double[][] points = new double[h * w][2];
        for (i2 = 0; i2 < w; ++i2) {
            for (int j2 = 0; j2 < h; ++j2) {
                points[i2 + j2 * w][0] = extents[0][0] + ((double)i2 + 0.5) * res;
                points[i2 + j2 * w][1] = extents[0][1] + ((double)j2 + 0.5) * res;
            }
        }
        for (int k = 0; k < envelopes.length; ++k) {
            LayerFilter lf = envelopes[k];
            if (GridCutter.existsLayerPath(resolution, lf.getLayername(), true, fieldIds[k]) && lf.isContextual() && "c".equalsIgnoreCase(layerTypes[k])) {
                String[] ids = lf.getIds();
                SimpleRegion[] srs = new SimpleRegion[ids.length];
                for (i = 0; i < ids.length; ++i) {
                    srs[i] = SimpleShapeFile.parseWKT(GridCutter.getWkt(ids[i]));
                }
                block4: for (i = 0; i < points.length; ++i) {
                    for (j = 0; j < srs.length; ++j) {
                        if (!srs[j].isWithin(points[i][0], points[i][1])) continue;
                        byte[] byArray = mask[i / w];
                        int n = i % w;
                        byArray[n] = (byte)(byArray[n] + 1);
                        continue block4;
                    }
                }
                continue;
            }
            Grid grid = Grid.getGrid(GridCutter.getLayerPath(resolution, lf.getLayername(), fieldIds[k]));
            float[] d = grid.getValues3(points, 40960);
            for (i = 0; i < d.length; ++i) {
                if (!lf.isValid(d[i])) continue;
                byte[] byArray = mask[i / w];
                int n = i % w;
                byArray[n] = (byte)(byArray[n] + 1);
            }
        }
        for (i2 = 0; i2 < w; ++i2) {
            for (int j3 = 0; j3 < h; ++j3) {
                mask[j3][i2] = mask[j3][i2] == envelopes.length ? (byte)1 : 0;
            }
        }
        int minx = w;
        int maxx = -1;
        int miny = h;
        int maxy = -1;
        for (i = 0; i < w; ++i) {
            for (j = 0; j < h; ++j) {
                if (mask[j][i] <= 0) continue;
                if (minx > i) {
                    minx = i;
                }
                if (maxx < i) {
                    maxx = i;
                }
                if (miny > j) {
                    miny = j;
                }
                if (maxy >= j) continue;
                maxy = j;
            }
        }
        int nw = maxx - minx + 1;
        int nh = maxy - miny + 1;
        byte[][] smallerMask = new byte[nh][nw];
        for (int i3 = minx; i3 < maxx; ++i3) {
            for (int j4 = miny; j4 < maxy; ++j4) {
                smallerMask[j4 - miny][i3 - minx] = mask[j4][i3];
            }
        }
        extents[0][0] = Math.max(extents[0][0] + (double)minx * res, extents[0][0]);
        extents[1][0] = Math.min(extents[1][0] - (double)(w - maxx - 1) * res, extents[1][0]);
        extents[0][1] = Math.max(extents[0][1] + (double)(++miny) * res, extents[0][1]);
        extents[1][1] = Math.min(extents[1][1] - (double)(h - ++maxy - 1) * res, extents[1][1]);
        return smallerMask;
    }

    public static double makeEnvelope(String filename, String resolution, LayerFilter[] envelopes, long maxGridCount) {
        String[] layerTypes = new String[envelopes.length];
        String[] fieldIds = new String[envelopes.length];
        for (int i = 0; i < envelopes.length; ++i) {
            IntersectionFile f = Client.getLayerIntersectDao().getConfig().getIntersectionFile(envelopes[i].getLayername());
            fieldIds[i] = f != null ? f.getFieldId() : null;
            layerTypes[i] = Client.getFieldDao().getFieldById(envelopes[i].getLayername()).getType();
        }
        return GridCutter.makeEnvelope(filename, resolution, envelopes, maxGridCount, layerTypes, fieldIds);
    }

    public static double makeEnvelope(String filename, String resolution, LayerFilter[] envelopes, long maxGridCount, String[] layerTypes, String[] fieldIds) {
        double[][] extents = GridCutter.getLayerExtents(resolution, envelopes[0].getLayername(), layerTypes[0], fieldIds[0]);
        for (int i = 1; i < envelopes.length; ++i) {
            if (GridCutter.isValidExtents(extents = GridCutter.internalExtents(extents, GridCutter.getLayerExtents(resolution, envelopes[i].getLayername(), layerTypes[i], fieldIds[i])))) continue;
            return -1.0;
        }
        if (!GridCutter.isValidExtents(extents = GridCutter.internalExtents(extents, GridCutter.getLayerFilterExtents(envelopes, fieldIds)))) {
            return -1.0;
        }
        double res = Double.parseDouble(resolution);
        while (Math.abs(extents[0][1] - extents[1][0]) / res * (Math.abs(extents[0][0] - extents[1][0]) / res) > (double)maxGridCount * 2.0) {
            res *= 2.0;
        }
        if (res != Double.parseDouble(resolution)) {
            resolution = String.format("%f", res);
        }
        int h = (int)Math.ceil((extents[1][1] - extents[0][1]) / res);
        int w = (int)Math.ceil((extents[1][0] - extents[0][0]) / res);
        byte[][] mask = GridCutter.getEnvelopeMaskAndUpdateExtents(resolution, res, extents, h, w, envelopes, layerTypes, fieldIds);
        h = (int)Math.ceil((extents[1][1] - extents[0][1]) / res);
        if ((int)Math.ceil((extents[1][1] + res - extents[0][1]) / res) == h) {
            double[] dArray = extents[1];
            dArray[1] = dArray[1] + res;
        }
        w = (int)Math.ceil((extents[1][0] - extents[0][0]) / res);
        if ((int)Math.ceil((extents[1][0] + res - extents[0][0]) / res) == w) {
            double[] dArray = extents[1];
            dArray[0] = dArray[0] + res;
        }
        float[] values = new float[w * h];
        int pos = 0;
        double areaSqKm = 0.0;
        for (int i = h - 1; i >= 0; --i) {
            for (int j = 0; j < w; ++j) {
                if (i < mask.length && j < mask[i].length) {
                    values[pos] = mask[i][j];
                    if (mask[i][j] > 0) {
                        areaSqKm += SpatialUtil.cellArea(res, extents[0][1] + res * (double)i);
                    }
                } else {
                    values[pos] = 0.0f;
                }
                ++pos;
            }
        }
        Grid grid = new Grid(GridCutter.getLayerPath(resolution, envelopes[0].getLayername(), fieldIds[0]));
        grid.writeGrid(filename, values, extents[0][0], extents[0][1], extents[1][0], extents[1][1], res, res, h, w);
        return areaSqKm;
    }

    private static double[][] getLayerFilterExtents(LayerFilter[] envelopes, String[] layerTypes) {
        Object extents = new double[][]{{-180.0, -90.0}, {180.0, 90.0}};
        for (int i = 0; i < envelopes.length; ++i) {
            if (!"c".equalsIgnoreCase(layerTypes[i])) continue;
            String[] ids = envelopes[i].getIds();
            for (int j = 0; j < ids.length; ++j) {
                try {
                    double[][] bbox = SimpleShapeFile.parseWKT(GridCutter.getBBoxWkt(ids[j])).getBoundingBox();
                    extents = GridCutter.internalExtents(extents, bbox);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return extents;
    }

    public static boolean isValidLayerFilter(String resolution, LayerFilter[] filter) {
        String[] layerTypes = new String[filter.length];
        String[] fieldIds = new String[filter.length];
        for (int i = 0; i < filter.length; ++i) {
            IntersectionFile f = Client.getLayerIntersectDao().getConfig().getIntersectionFile(filter[i].getLayername());
            fieldIds[i] = f != null ? f.getFieldId() : null;
            layerTypes[i] = Client.getFieldDao().getFieldById(filter[i].getLayername()).getType();
        }
        return GridCutter.isValidLayerFilter(resolution, filter, layerTypes, fieldIds);
    }

    public static boolean isValidLayerFilter(String resolution, LayerFilter[] filter, String[] layerTypes, String[] fieldIds) {
        for (int i = 0; i < filter.length; ++i) {
            if (GridCutter.getLayerPath(resolution, filter[i].getLayername(), fieldIds[i]) != null || filter[i].isContextual() && layerTypes[i].equalsIgnoreCase("c")) continue;
            return false;
        }
        return true;
    }

    private static String confirmResolution(String[] layers, String resolution, String[] fieldIds) {
        try {
            TreeMap<Double, String> resolutions = new TreeMap<Double, String>();
            for (int i = 0; i < layers.length; ++i) {
                String res;
                Double d;
                int start;
                int end;
                String layer = layers[i];
                String path = GridCutter.getLayerPath(resolution, layer, fieldIds[i]);
                if (path == null || (end = path.lastIndexOf(File.separator)) <= 0 || (start = path.lastIndexOf(File.separator, end - 1)) <= 0 || !((d = Double.valueOf(Double.parseDouble(res = path.substring(start + 1, end)))) < 1.0)) continue;
                resolutions.put(d, res);
            }
            if (resolutions.size() > 0) {
                resolution = (String)resolutions.firstEntry().getValue();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return resolution;
    }

    private static String getWkt(String id) {
        if (layersUrl == null) {
            return Client.getObjectDao().getObjectsGeometryById(id, "WKT");
        }
        return Util.readUrl(layersUrl + "/shape/wkt/" + id);
    }

    private static String getBBoxWkt(String id) {
        if (layersUrl == null) {
            return Client.getObjectDao().getObjectsGeometryById(id, "WKT");
        }
        JSONParser jp = new JSONParser();
        try {
            return ((JSONObject)jp.parse(Util.readUrl(layersUrl + "/object/" + id))).get((Object)"bbox").toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String[] getAnalysisLayerInfo(String id) {
        if (layersUrl == null) {
            return Client.getLayerIntersectDao().getConfig().getAnalysisLayerInfo(id);
        }
        return IntersectConfig.getAnalysisLayerInfoV2(id);
    }
}

