/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.dao;

import au.org.ala.layers.dao.LayerIntersectDAO;
import au.org.ala.layers.dao.ObjectDAO;
import au.org.ala.layers.dto.GridClass;
import au.org.ala.layers.dto.IntersectionFile;
import au.org.ala.layers.dto.Objects;
import au.org.ala.layers.intersect.Grid;
import au.org.ala.layers.intersect.IntersectConfig;
import au.org.ala.layers.util.LayerFilter;
import au.org.ala.layers.util.SpatialConversionUtils;
import au.org.ala.layers.util.SpatialUtil;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipInputStream;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.kml.KML;
import org.geotools.kml.KMLConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.opengis.feature.simple.SimpleFeatureType;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.nativejdbc.C3P0NativeJdbcExtractor;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="objectDao")
public class ObjectDAOImpl
implements ObjectDAO,
ApplicationContextAware {
    static final String objectWmsUrl = "/wms?service=WMS&version=1.1.0&request=GetMap&layers=ALA:Objects&format=image/png&viewparams=s:<pid>";
    static final String gridPolygonSld;
    static final String gridClassSld;
    private static final String SUB_LAYERNAME = "*layername*";
    static final String gridPolygonWmsUrl = "/wms?service=WMS&version=1.1.0&request=GetMap&layers=ALA:*layername*&format=image/png&sld_body=";
    private static final String SUB_COLOUR = "0xff0000";
    private static final String SUB_MIN_MINUS_ONE = "*min_minus_one*";
    private static final String SUB_MIN = "*min*";
    private static final String SUB_MAX = "*max*";
    private static final String SUB_MAX_PLUS_ONE = "*max_plus_one*";
    private static final String KML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><kml xmlns=\"http://earth.google.com/kml/2.2\"><Document>  <name></name>  <description></description>  <Style id=\"style1\">    <LineStyle>      <color>40000000</color>      <width>3</width>    </LineStyle>    <PolyStyle>      <color>73FF0000</color>      <fill>1</fill>      <outline>1</outline>    </PolyStyle>  </Style>  <Placemark>    <name></name>    <description></description>    <styleUrl>#style1</styleUrl>";
    private static final String KML_FOOTER = "</Placemark></Document></kml>";
    private static final Logger logger;
    private JdbcTemplate jdbcTemplate;
    @Resource(name="layerIntersectDao")
    private LayerIntersectDAO layerIntersectDao;
    private ApplicationContext applicationContext;

    @Resource(name="dataSource")
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public List<Objects> getObjects() {
        logger.info((Object)"Getting a list of all objects");
        String sql = "select o.pid as pid, o.id as id, o.name as name, o.desc as description, o.fid as fid, f.name as fieldname, o.area_km as area_km from objects o, fields f where o.fid = f.id";
        List objects = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Objects.class));
        this.updateObjectWms(objects);
        return objects;
    }

    @Override
    public List<Objects> getObjectsById(String id) {
        return this.getObjectsById(id, 0, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObjectsToCSV(OutputStream output, String fid) throws Exception {
        String sql = MessageFormat.format("COPY (select o.pid as pid, o.id as id, o.name as name, o.desc as description, ST_AsText(ST_Centroid(o.the_geom)) as centroid, GeometryType(o.the_geom) as featureType from objects o where o.fid = ''{0}'') TO STDOUT WITH CSV HEADER", fid);
        DataSource ds = (DataSource)this.applicationContext.getBean("dataSource");
        Connection conn = DataSourceUtils.getConnection((DataSource)ds);
        try {
            BaseConnection baseConn = (BaseConnection)new C3P0NativeJdbcExtractor().getNativeConnection(conn);
            OutputStreamWriter csvOutput = new OutputStreamWriter(output);
            CopyManager copyManager = new CopyManager(baseConn);
            copyManager.copyOut(sql, (Writer)csvOutput);
            ((Writer)csvOutput).flush();
            conn.close();
        }
        catch (SQLException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)conn, (DataSource)ds);
        }
    }

    @Override
    public List<Objects> getObjectsById(String id, int start, int pageSize) {
        return this.getObjectsById(id, start, pageSize, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Objects> getObjectsById(String id, int start, int pageSize, String filter) {
        if (filter == null) {
            filter = "";
        }
        String upperCaseFilter = filter.toUpperCase();
        filter = "%" + filter + "%";
        logger.info((Object)("Getting object info for fid = " + id));
        String limit_offset = " limit " + (pageSize < 0 ? "all" : Integer.valueOf(pageSize)) + " offset " + start;
        String sql = "select o.pid as pid, o.id as id, o.name as name, o.desc as description, o.fid as fid, f.name as fieldname, o.bbox, o.area_km, ST_AsText(ST_Centroid(o.the_geom)) as centroid,GeometryType(o.the_geom) as featureType from objects o, fields f where o.fid = ? and o.fid = f.id and (o.name ilike ? or o.desc ilike ? ) order by o.pid " + limit_offset;
        ArrayList<Objects> objects = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Objects.class), new Object[]{id, filter, filter});
        this.updateObjectWms((List<Objects>)objects);
        if (objects == null || objects.isEmpty()) {
            objects = new ArrayList<Objects>();
            IntersectionFile f = this.layerIntersectDao.getConfig().getIntersectionFile(id);
            if (f != null && f.getClasses() != null) {
                int pos = 0;
                for (Map.Entry<Integer, GridClass> c : f.getClasses().entrySet()) {
                    block23: {
                        File file = new File(f.getFilePath() + File.separator + c.getKey() + ".wkt.index.dat");
                        if ((f.getType().equals("a") || !file.exists()) && c.getValue().getName().toUpperCase().contains(upperCaseFilter)) {
                            if (pageSize == -1 || pos >= start && pos - start < pageSize) {
                                Objects o = new Objects();
                                o.setPid(f.getLayerPid() + ":" + c.getKey());
                                o.setId(f.getLayerPid() + ":" + c.getKey());
                                o.setName(c.getValue().getName());
                                o.setFid(f.getFieldId());
                                o.setFieldname(f.getFieldName());
                                o.setBbox(c.getValue().getBbox());
                                o.setArea_km(c.getValue().getArea_km());
                                o.setWmsurl(this.getGridClassWms(f.getLayerName(), c.getValue()));
                                objects.add(o);
                            }
                            if (pageSize == -1 || ++pos < start + pageSize) continue;
                            break;
                        }
                        RandomAccessFile raf = null;
                        try {
                            raf = new RandomAccessFile(file, "r");
                            long itemSize = 28L;
                            long len = raf.length() / itemSize;
                            if (pageSize != -1 && (long)pos + len < (long)start) {
                                pos = (int)((long)pos + len);
                                break block23;
                            }
                            int i = 0;
                            if (pageSize != -1 && pos < start) {
                                i = start - pos;
                                pos += i;
                                raf.seek((long)i * itemSize);
                            }
                            while ((long)i < len) {
                                int n = raf.readInt();
                                raf.readInt();
                                float minx = raf.readFloat();
                                float miny = raf.readFloat();
                                float maxx = raf.readFloat();
                                float maxy = raf.readFloat();
                                float area = raf.readFloat();
                                if (pageSize == -1 || pos >= start && pos - start < pageSize) {
                                    Objects o = new Objects();
                                    o.setPid(f.getLayerPid() + ":" + c.getKey() + ":" + n);
                                    o.setId(f.getLayerPid() + ":" + c.getKey() + ":" + n);
                                    o.setName(c.getValue().getName());
                                    o.setFid(f.getFieldId());
                                    o.setFieldname(f.getFieldName());
                                    o.setBbox("POLYGON((" + minx + " " + miny + "," + minx + " " + maxy + "," + maxx + " " + maxy + "," + maxx + " " + miny + "," + minx + " " + miny + "))");
                                    o.setArea_km(1.0 * (double)area);
                                    o.setWmsurl(this.getGridPolygonWms(f.getLayerName(), n));
                                    objects.add(o);
                                }
                                if (pageSize != -1 && ++pos >= start + pageSize) {
                                    break;
                                }
                                ++i;
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                        finally {
                            if (raf != null) {
                                try {
                                    raf.close();
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                    }
                    if (pageSize == -1 || pos < start + pageSize) continue;
                    break;
                }
            }
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getObjectsGeometryById(String id, String geomtype) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.streamObjectsGeometryById(baos, id, geomtype);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return new String(baos.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void streamObjectsGeometryById(OutputStream os, String id, String geomtype) throws IOException {
        block60: {
            logger.info((Object)("Getting object info for id = " + id + " and geometry as " + geomtype));
            String sql = "";
            if ("kml".equals(geomtype)) {
                sql = "SELECT ST_AsKml(the_geom,15) as geometry, name, \"desc\" as description  FROM objects WHERE pid=?;";
            } else if ("wkt".equals(geomtype)) {
                sql = "SELECT ST_AsText(the_geom,15) as geometry FROM objects WHERE pid=?;";
            } else if ("geojson".equals(geomtype)) {
                sql = "SELECT ST_AsGeoJSON(the_geom,15) as geometry FROM objects WHERE pid=?;";
            } else if ("shp".equals(geomtype)) {
                sql = "SELECT ST_AsText(the_geom,15) as geometry, name, \"desc\" as description FROM objects WHERE pid=?;";
            }
            List l = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Objects.class), new Object[]{id});
            if (l.size() > 0) {
                if ("shp".equals(geomtype)) {
                    String wkt = ((Objects)l.get(0)).getGeometry();
                    File zippedShapeFile = SpatialConversionUtils.buildZippedShapeFile(wkt, id, ((Objects)l.get(0)).getName(), ((Objects)l.get(0)).getDescription());
                    FileUtils.copyFile((File)zippedShapeFile, (OutputStream)os);
                } else if ("kml".equals(geomtype)) {
                    os.write(KML_HEADER.replace("<name></name>", "<name><![CDATA[" + ((Objects)l.get(0)).getName() + "]]></name>").replace("<description></description>", "<description><![CDATA[" + ((Objects)l.get(0)).getDescription() + "]]></description>").getBytes());
                    os.write(((Objects)l.get(0)).getGeometry().getBytes());
                    os.write(KML_FOOTER.getBytes());
                } else {
                    os.write(((Objects)l.get(0)).getGeometry().getBytes());
                }
            } else if (id.length() > 0) {
                try {
                    GridClass gc;
                    String[] s = id.split(":");
                    if (s.length < 2) break block60;
                    int n = Integer.parseInt(s[1]);
                    IntersectionFile f = this.layerIntersectDao.getConfig().getIntersectionFile(s[0]);
                    if (f == null || f.getClasses() == null || (gc = f.getClasses().get(n)) == null || !"kml".equals(geomtype) && !"wkt".equals(geomtype) && !"geojson".equals(geomtype) && !"shp".equals(geomtype)) break block60;
                    File file = new File(f.getFilePath() + File.separator + s[1] + "." + geomtype + ".zip");
                    if ((f.getType().equals("a") || s.length == 2) && file.exists()) {
                        ZipInputStream zis = null;
                        try {
                            int size;
                            zis = new ZipInputStream(new FileInputStream(file));
                            zis.getNextEntry();
                            byte[] buffer = new byte[1024];
                            while ((size = zis.read(buffer)) > 0) {
                                os.write(buffer, 0, size);
                            }
                            break block60;
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            break block60;
                        }
                        finally {
                            if (zis != null) {
                                try {
                                    zis.close();
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                    }
                    BufferedInputStream bis = null;
                    InputStreamReader isr = null;
                    try {
                        String[] cells = null;
                        HashMap<String, Object> map = s.length == 2 ? null : this.getGridIndexEntry(f.getFilePath() + File.separator + s[1], s[2]);
                        String wkt = null;
                        if (map != null) {
                            cells = new String[]{s[2], String.valueOf(map.get("charoffset"))};
                            if (cells != null) {
                                int size;
                                File file2 = new File(f.getFilePath() + File.separator + s[1] + ".wkt");
                                bis = new BufferedInputStream(new FileInputStream(file2));
                                isr = new InputStreamReader(bis);
                                isr.skip(Long.parseLong(cells[1]));
                                char[] buffer = new char[1024];
                                StringBuilder sb = new StringBuilder();
                                sb.append("POLYGON");
                                int end = -1;
                                while (end < 0 && (size = isr.read(buffer)) > 0) {
                                    sb.append(buffer, 0, size);
                                    end = sb.toString().indexOf("))");
                                }
                                wkt = sb.toString().substring(0, end += 2);
                            }
                        } else {
                            wkt = gc.getBbox();
                        }
                        if (geomtype.equals("wkt")) {
                            os.write(wkt.getBytes());
                        } else {
                            WKTReader r = new WKTReader();
                            Geometry g = r.read(wkt);
                            if (geomtype.equals("kml")) {
                                os.write(KML_HEADER.getBytes());
                                Encoder encoder = new Encoder((Configuration)new KMLConfiguration());
                                encoder.setIndenting(true);
                                encoder.encode((Object)g, KML.Geometry, os);
                                os.write(KML_FOOTER.getBytes());
                            } else if (geomtype.equals("geojson")) {
                                FeatureJSON fjson = new FeatureJSON();
                                SimpleFeatureType TYPE = DataUtilities.createType((String)"class", (String)"the_geom:MultiPolygon,name:String");
                                SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(TYPE);
                                featureBuilder.add((Object)g);
                                featureBuilder.add((Object)gc.getName());
                                fjson.writeFeature(featureBuilder.buildFeature(null), os);
                            } else if (geomtype == "shp") {
                                File zippedShapeFile = SpatialConversionUtils.buildZippedShapeFile(wkt, id, gc.getName(), null);
                                FileUtils.copyFile((File)zippedShapeFile, (OutputStream)os);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    finally {
                        if (bis != null) {
                            try {
                                bis.close();
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                        if (isr != null) {
                            try {
                                isr.close();
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public Objects getObjectByPid(String pid) {
        logger.info((Object)("Getting object info for pid = " + pid));
        String sql = "select o.pid, o.id, o.name, o.desc as description, o.fid as fid, f.name as fieldname, o.bbox, o.area_km from objects o, fields f where o.pid = ? and o.fid = f.id";
        List l = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Objects.class), new Object[]{pid});
        this.updateObjectWms(l);
        if ((l == null || l.isEmpty()) && pid.length() > 0) {
            try {
                String[] s = pid.split(":");
                if (s.length >= 2) {
                    GridClass gc;
                    int n = Integer.parseInt(s[1]);
                    IntersectionFile f = this.layerIntersectDao.getConfig().getIntersectionFile(s[0]);
                    if (f != null && f.getClasses() != null && (gc = f.getClasses().get(n)) != null) {
                        Objects o = new Objects();
                        o.setPid(pid);
                        o.setId(pid);
                        o.setName(gc.getName());
                        o.setFid(f.getFieldId());
                        o.setFieldname(f.getFieldName());
                        if (f.getType().equals("a") || s.length == 2) {
                            o.setBbox(gc.getBbox());
                            o.setArea_km(gc.getArea_km());
                            o.setWmsurl(this.getGridClassWms(f.getLayerName(), gc));
                        } else {
                            HashMap<String, Object> map = this.getGridIndexEntry(f.getFilePath() + File.separator + s[1], s[2]);
                            if (!map.isEmpty()) {
                                o.setBbox("POLYGON(" + map.get("minx") + " " + map.get("miny") + "," + map.get("minx") + " " + map.get("maxy") + "," + map.get("maxx") + " " + map.get("maxy") + "," + map.get("maxx") + " " + map.get("miny") + "," + map.get("minx") + " " + map.get("miny") + ")");
                                o.setArea_km(((Float)map.get("area")).doubleValue());
                                o.setWmsurl(this.getGridPolygonWms(f.getLayerName(), Integer.parseInt(s[2])));
                            }
                        }
                        l.add(o);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (l.size() > 0) {
            return (Objects)l.get(0);
        }
        return null;
    }

    @Override
    public Objects getObjectByIdAndLocation(String fid, Double lng, Double lat) {
        logger.info((Object)("Getting object info for fid = " + fid + " at loc: (" + lng + ", " + lat + ") "));
        String sql = "select o.pid, o.id, o.name, o.desc as description, o.fid as fid, f.name as fieldname, o.bbox, o.area_km from search_objects_by_geometry_intersect(?, ST_GeomFromText('POINT(" + lng + " " + lat + ")', 4326)) o, fields f WHERE o.fid = f.id";
        ArrayList<Objects> l = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Objects.class), new Object[]{fid});
        this.updateObjectWms((List<Objects>)l);
        if (l == null || l.isEmpty()) {
            Vector v;
            l = new ArrayList<Objects>();
            IntersectionFile f = this.layerIntersectDao.getConfig().getIntersectionFile(fid);
            if (f != null && f.getClasses() != null && (v = this.layerIntersectDao.samplingFull(fid, lng, lat)) != null && v.size() > 0 && v.get(0) != null) {
                Grid g;
                Map m = (Map)v.get(0);
                int key = (int)Double.parseDouble(((String)m.get("pid")).split(":")[1]);
                GridClass gc = f.getClasses().get(key);
                if (f.getType().equals("a") || !new File(f.getFilePath() + File.separator + "polygons.grd").exists()) {
                    Objects o = new Objects();
                    o.setName(gc.getName());
                    o.setFid(f.getFieldId());
                    o.setFieldname(f.getFieldName());
                    o.setPid(f.getLayerPid() + ":" + gc.getId());
                    o.setId(f.getLayerPid() + ":" + gc.getId());
                    o.setBbox(gc.getBbox());
                    o.setArea_km(gc.getArea_km());
                    o.setWmsurl(this.getGridClassWms(f.getLayerName(), gc));
                    l.add(o);
                } else if (f.getType().equals("b") && (g = new Grid(f.getFilePath() + File.separator + "polygons")) != null) {
                    float[] vs = g.getValues(new double[][]{{lng, lat}});
                    String pid = f.getLayerPid() + ":" + gc.getId() + ":" + (int)vs[0];
                    l.add(this.getObjectByPid(pid));
                }
            }
        }
        if (l.size() > 0) {
            return (Objects)l.get(0);
        }
        return null;
    }

    @Override
    public List<Objects> getNearestObjectByIdAndLocation(String fid, int limit, Double lng, Double lat) {
        logger.info((Object)("Getting " + limit + " nearest objects in field fid = " + fid + " to loc: (" + lng + ", " + lat + ") "));
        String sql = "select fid, name, \"desc\", pid, id, ST_AsText(the_geom) as geometry, ST_DistanceSphere(ST_SETSRID(ST_Point( ? , ? ),4326), the_geom) as distance, degrees(Azimuth( ST_SETSRID(ST_Point( ? , ? ),4326), the_geom)) as degrees, area_km from objects where fid= ? order by the_geom <#> st_setsrid(st_makepoint( ? , ? ),4326) limit ? ";
        List objects = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Objects.class), new Object[]{lng, lat, lng, lat, fid, lng, lat, limit});
        this.updateObjectWms(objects);
        return objects;
    }

    @Override
    public List<Objects> getObjectByFidAndName(String fid, String name) {
        logger.info((Object)("Getting object info for fid = " + fid + " and name: (" + name + ") "));
        String sql = "select o.pid, o.id, o.name, o.desc as description, o.fid as fid, f.name as fieldname, o.bbox, o.area_km, ST_AsText(the_geom) as geometry, GeometryType(the_geom) as featureType from objects o, fields f where o.fid = ? and o.name ilike ? and o.fid = f.id";
        List objects = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Objects.class), new Object[]{fid, name});
        this.updateObjectWms(objects);
        return objects;
    }

    private String getGridPolygonWms(String layername, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        this.layerIntersectDao.getConfig();
        return stringBuilder.append(IntersectConfig.getGeoserverUrl()).append(gridPolygonWmsUrl.replace(SUB_LAYERNAME, layername)).append(this.formatSld(gridPolygonSld, layername, String.valueOf(n - 1), String.valueOf(n), String.valueOf(n), String.valueOf(n + 1))).toString();
    }

    private String getGridClassWms(String layername, GridClass gc) {
        StringBuilder stringBuilder = new StringBuilder();
        this.layerIntersectDao.getConfig();
        return stringBuilder.append(IntersectConfig.getGeoserverUrl()).append(gridPolygonWmsUrl.replace(SUB_LAYERNAME, layername)).append(this.formatSld(gridClassSld, layername, String.valueOf(gc.getMinShapeIdx() - 1), String.valueOf(gc.getMinShapeIdx()), String.valueOf(gc.getMaxShapeIdx()), String.valueOf(gc.getMaxShapeIdx() + 1))).toString();
    }

    private String formatSld(String sld, String layername, String min_minus_one, String min, String max, String max_plus_one) {
        return sld.replace(SUB_LAYERNAME, layername).replace(SUB_MIN_MINUS_ONE, min_minus_one).replace(SUB_MIN, min).replace(SUB_MAX, max).replace(SUB_MAX_PLUS_ONE, max_plus_one);
    }

    private void updateObjectWms(List<Objects> objects) {
        for (Objects o : objects) {
            String wmsurl = objectWmsUrl.replace("<pid>", o.getPid());
            if (o.getArea_km() == null) {
                logger.error((Object)"area_km cannot be null. wmsurl may be incorect.", (Throwable)new Exception("area_km is null"));
            } else if (o.getArea_km() == 0.0) {
                wmsurl = wmsurl.replace("ALA:Objects", "ALA:Points");
            }
            StringBuilder stringBuilder = new StringBuilder();
            this.layerIntersectDao.getConfig();
            o.setWmsurl(stringBuilder.append(IntersectConfig.getGeoserverUrl()).append(wmsurl).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, Object> getGridIndexEntry(String path, String objectId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(path + ".wkt.index.dat", "r");
            int s2 = Integer.parseInt(objectId);
            int recordSize = 28;
            int start = raf.readInt();
            raf.seek(recordSize * (s2 - start));
            map.put("gn", raf.readInt());
            map.put("charoffset", raf.readInt());
            map.put("minx", Float.valueOf(raf.readFloat()));
            map.put("miny", Float.valueOf(raf.readFloat()));
            map.put("maxx", Float.valueOf(raf.readFloat()));
            map.put("maxy", Float.valueOf(raf.readFloat()));
            map.put("area", Float.valueOf(raf.readFloat()));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return map;
    }

    @Override
    public List<Objects> getObjectsByIdAndArea(String id, Integer limit, String wkt) {
        String sql = "select fid, name, \"desc\", pid, id, ST_AsText(the_geom) as geometry, GeometryType(the_geom) as featureType, area_km from objects where fid= ? and ST_Within(the_geom, ST_GeomFromText( ? , 4326)) limit ? ";
        List objects = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Objects.class), new Object[]{id, wkt, limit});
        this.updateObjectWms(objects);
        return objects;
    }

    @Override
    public List<Objects> getObjectsByIdAndIntersection(String id, Integer limit, LayerFilter layerFilter) {
        String world = "POLYGON((-180 -90,-180 90,180 90,180 -90,-180 -90))";
        List<Objects> objects = this.getObjectsByIdAndArea(id, Integer.MAX_VALUE, world);
        double[][] points = new double[objects.size()][2];
        for (int i = 0; i < objects.size(); ++i) {
            try {
                String[] s = objects.get(i).getGeometry().substring("POINT(".length(), objects.get(i).getGeometry().length() - 1).split(" ");
                points[i][0] = Double.parseDouble(s[0]);
                points[i][1] = Double.parseDouble(s[1]);
                continue;
            }
            catch (Exception e) {
                points[i][0] = -2.147483648E9;
                points[i][1] = -2.147483648E9;
            }
        }
        ArrayList<String> sample = this.layerIntersectDao.sampling(new String[]{layerFilter.getLayername()}, points);
        ArrayList<Objects> matched = new ArrayList<Objects>();
        String[] sampling = sample.get(0).split("\n");
        IntersectionFile f = this.layerIntersectDao.getConfig().getIntersectionFile(layerFilter.getLayername());
        if (f != null && (f.getType().equals("a") || f.getType().equals("b"))) {
            String target = f.getClasses().get((int)layerFilter.getMinimum_value()).getName();
            for (int i = 0; i < sampling.length; ++i) {
                if (sampling[i].length() <= 0 || !sampling[i].equals(target)) continue;
                matched.add(objects.get(i));
            }
        } else {
            for (int i = 0; i < sampling.length; ++i) {
                double v;
                if (sampling[i].length() <= 0 || !((v = Double.parseDouble(sampling[i])) >= layerFilter.getMinimum_value()) || !(v <= layerFilter.getMaximum_value())) continue;
                matched.add(objects.get(i));
            }
        }
        this.updateObjectWms(matched);
        return matched;
    }

    @Override
    public List<Objects> getObjectsByIdAndIntersection(String id, Integer limit, String intersectingPid) {
        String sql = "select fid, name, \"desc\", pid, id, ST_AsText(the_geom) as geometry, GeometryType(the_geom) as featureType, area_km from objects, (select the_geom as g from Objects where pid = ? ) t where fid= ? and ST_Within(the_geom, g) limit ? ";
        List objects = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Objects.class), new Object[]{intersectingPid, id, limit});
        this.updateObjectWms(objects);
        return objects;
    }

    @Override
    public String createUserUploadedObject(String wkt, String name, String description, String userid) {
        return this.createUserUploadedObject(wkt, name, description, userid, true);
    }

    @Override
    @Transactional
    public String createUserUploadedObject(String wkt, String name, String description, String userid, boolean namesearch) {
        double area_km = SpatialUtil.calculateArea(wkt) / 1000.0 / 1000.0;
        try {
            int object_id = (Integer)this.jdbcTemplate.queryForObject("SELECT nextval('objects_id_seq'::regclass)", Integer.class);
            int metadata_id = (Integer)this.jdbcTemplate.queryForObject("SELECT nextval('uploaded_objects_metadata_id_seq'::regclass)", Integer.class);
            String sql = "INSERT INTO objects (pid, id, name, \"desc\", fid, the_geom, namesearch, bbox, area_km) values (?, ? , ?, ?, ?, ST_GeomFromText(?, 4326), ?, ST_AsText(Box2D(ST_GeomFromText(?, 4326))), ?)";
            this.jdbcTemplate.update(sql, new Object[]{object_id, metadata_id, name, description, IntersectConfig.getUploadedShapesFieldId(), wkt, namesearch, wkt, area_km});
            String sql2 = "INSERT INTO uploaded_objects_metadata (pid, id, user_id, time_last_updated) values (?, ?, ?, now())";
            this.jdbcTemplate.update(sql2, new Object[]{object_id, metadata_id, userid});
            return Integer.toString(object_id);
        }
        catch (DataAccessException ex) {
            throw new IllegalArgumentException("Error writing to database. Check validity of wkt.", ex);
        }
    }

    @Override
    @Transactional
    public boolean updateUserUploadedObject(int pid, String wkt, String name, String description, String userid) {
        if (!this.shapePidIsForUploadedShape(pid)) {
            throw new IllegalArgumentException("Supplied pid does not match an uploaded shape.");
        }
        try {
            double area_km = SpatialUtil.calculateArea(wkt) / 1000.0 / 1000.0;
            String sql = "UPDATE uploaded_objects_metadata SET user_id = ?, time_last_updated = now() WHERE pid = ?";
            this.jdbcTemplate.update(sql, new Object[]{userid, Integer.toString(pid)});
            String sql2 = "UPDATE objects SET the_geom = ST_GeomFromText(?, 4326), bbox = ST_AsText(Box2D(ST_GeomFromText(?, 4326))), name = ?, \"desc\" = ?, area_km = ? where pid = ?";
            int rowsUpdated = this.jdbcTemplate.update(sql2, new Object[]{wkt, wkt, name, description, area_km, Integer.toString(pid)});
            return rowsUpdated > 0;
        }
        catch (DataAccessException ex) {
            throw new IllegalArgumentException("Error writing to database. Check validity of wkt.", ex);
        }
    }

    @Override
    @Transactional
    public boolean deleteUserUploadedObject(int pid) {
        if (!this.shapePidIsForUploadedShape(pid)) {
            throw new IllegalArgumentException("Supplied pid does not match an uploaded shape.");
        }
        String sql = "DELETE FROM uploaded_objects_metadata WHERE pid = ?; DELETE FROM objects where pid = ?";
        int rowsAffected = this.jdbcTemplate.update(sql, new Object[]{Integer.toString(pid), Integer.toString(pid)});
        return rowsAffected > 0;
    }

    @Override
    @Async
    public void updateObjectNames() {
        String sql = "INSERT INTO obj_names (name) SELECT lower(objects.name) FROM fields, objects LEFT OUTER JOIN obj_names ON lower(objects.name)=obj_names.name WHERE obj_names.name IS NULL AND fields.namesearch = true AND fields.id = objects.fid GROUP BY lower(objects.name); UPDATE objects SET name_id=obj_names.id FROM obj_names WHERE name_id IS NULL AND lower(objects.name)=obj_names.name;";
        this.jdbcTemplate.update(sql);
    }

    private boolean shapePidIsForUploadedShape(int pid) {
        String sql = "SELECT * from uploaded_objects_metadata WHERE pid = ?";
        List queryResult = this.jdbcTemplate.queryForList(sql, new Object[]{Integer.toString(pid)});
        return queryResult != null && !queryResult.isEmpty();
    }

    @Override
    public int createPointOfInterest(String objectId, String name, String type, Double latitude, Double longitude, Double bearing, String userId, String description, Double focalLength) {
        String sql = "INSERT INTO points_of_interest (id, object_id, name, type, latitude, longitude, bearing, user_id, description, focal_length_millimetres, the_geom) VALUES (DEFAULT, ?, ?, ?, ?, ?, ?, ?, ?, ?, ST_SetSRID(ST_MakePoint(?, ?),4326))";
        this.jdbcTemplate.update(sql, new Object[]{objectId, name, type, latitude, longitude, bearing, userId, description, focalLength, longitude, latitude});
        String sql2 = "SELECT MAX(id) from points_of_interest";
        int id = (Integer)this.jdbcTemplate.queryForObject(sql2, Integer.class);
        return id;
    }

    @Override
    public boolean updatePointOfInterest(int id, String objectId, String name, String type, Double latitude, Double longitude, Double bearing, String userId, String description, Double focalLength) {
        String sql = "UPDATE points_of_interest SET object_id = ?, name = ?, type = ?, latitude = ?, longitude = ?, bearing = ?, user_id = ?, description = ?, focal_length_millimetres = ? WHERE id = ?; UPDATE points_of_interest SET the_geom = ST_SetSRID(ST_MakePoint(longitude, latitude),4326) WHERE id = ?";
        int rowsUpdated = this.jdbcTemplate.update(sql, new Object[]{objectId, name, type, latitude, longitude, bearing, userId, description, focalLength, id, id});
        return rowsUpdated > 0;
    }

    @Override
    public Map<String, Object> getPointOfInterestDetails(int id) {
        String sql = "SELECT id, object_id, name, type, latitude, longitude, bearing, user_id, description, focal_length_millimetres from points_of_interest WHERE id = ?";
        Map poiDetails = this.jdbcTemplate.queryForMap(sql, new Object[]{id});
        if (poiDetails.isEmpty()) {
            throw new IllegalArgumentException("Invalid point of interest id");
        }
        return poiDetails;
    }

    @Override
    public boolean deletePointOfInterest(int id) {
        String sql = "DELETE FROM points_of_interest WHERE id = ?;";
        int rowsAffected = this.jdbcTemplate.update(sql, new Object[]{id});
        return rowsAffected > 0;
    }

    @Override
    public List<Objects> getObjectsWithinRadius(String fid, double latitude, double longitude, double radiusKm) {
        String sql = "SELECT o.pid, o.id, o.name, o.desc AS description, o.fid AS fid, f.name AS fieldname, o.bbox, o.area_km, GeometryType(o.the_geom) as featureType FROM objects o, fields f WHERE o.fid = ? AND o.fid = f.id AND ST_DWithin(ST_GeographyFromText('POINT(" + longitude + " " + latitude + ")'), geography(the_geom), ?, true)";
        List l = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Objects.class), new Object[]{fid, radiusKm * 1000.0});
        this.updateObjectWms(l);
        return l;
    }

    @Override
    public List<Objects> getObjectsIntersectingWithGeometry(String fid, String wkt) {
        String sql = "SELECT o.pid, o.id, o.name, o.desc AS description, o.fid AS fid, f.name AS fieldname, o.bbox, o.area_km from search_objects_by_geometry_intersect(?, ST_GeomFromText(?, 4326)) o, fields f WHERE o.fid = f.id";
        List l = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Objects.class), new Object[]{fid, wkt});
        this.updateObjectWms(l);
        return l;
    }

    @Override
    public List<Objects> getObjectsIntersectingWithObject(String fid, String objectPid) {
        String sql = "SELECT o.pid, o.id, o.name, o.desc AS description, o.fid AS fid, f.name AS fieldname, o.bbox, o.area_km FROM search_objects_by_geometry_intersect(?, (SELECT the_geom FROM objects WHERE pid = ?)) o, fields f WHERE o.fid = f.id";
        List l = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Objects.class), new Object[]{fid, objectPid});
        this.updateObjectWms(l);
        return l;
    }

    @Override
    public List<Map<String, Object>> getPointsOfInterestWithinRadius(double latitude, double longitude, double radiusKm) {
        String sql = "SELECT id, object_id, name, type, latitude, longitude, bearing, user_id, description, focal_length_millimetres from points_of_interest WHERE ST_DWithin(ST_GeographyFromText('POINT(" + longitude + " " + latitude + ")'), geography(the_geom), ?,true)";
        List l = this.jdbcTemplate.queryForList(sql, new Object[]{radiusKm * 1000.0});
        return l;
    }

    @Override
    public List<Map<String, Object>> pointsOfInterestGeometryIntersect(String wkt) {
        String sql = "SELECT id, object_id, name, type, latitude, longitude, bearing, user_id, description, focal_length_millimetres from points_of_interest WHERE ST_Intersects(ST_GeomFromText(?, 4326), the_geom)";
        List l = this.jdbcTemplate.queryForList(sql, new Object[]{wkt});
        return l;
    }

    @Override
    public List<Map<String, Object>> pointsOfInterestObjectIntersect(String objectPid) {
        String sql = "SELECT id, object_id, name, type, latitude, longitude, bearing, user_id, description, focal_length_millimetres from points_of_interest WHERE ST_Intersects((SELECT the_geom FROM objects where pid = ?), the_geom)";
        List l = this.jdbcTemplate.queryForList(sql, new Object[]{objectPid});
        return l;
    }

    @Override
    public int getPointsOfInterestWithinRadiusCount(double latitude, double longitude, double radiusKm) {
        String sql = "SELECT count(*) from points_of_interest WHERE ST_DWithin(ST_GeographyFromText('POINT(" + longitude + " " + latitude + ")'), geography(the_geom), ?, true)";
        return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class, new Object[]{radiusKm * 1000.0});
    }

    @Override
    public int pointsOfInterestGeometryIntersectCount(String wkt) {
        String sql = "SELECT count(*) from points_of_interest WHERE ST_Intersects(ST_GeomFromText(?, 4326), the_geom)";
        return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class, new Object[]{wkt});
    }

    @Override
    public int pointsOfInterestObjectIntersectCount(String objectPid) {
        String sql = "SELECT count(*) from points_of_interest WHERE ST_Intersects((SELECT the_geom FROM objects where pid = ?), the_geom)";
        return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class, new Object[]{objectPid});
    }

    @Override
    public Objects intersectObject(String pid, double latitude, double longitude) {
        String sql = "SELECT o.pid, o.id, o.name, o.desc AS description, o.fid AS fid, f.name AS fieldname, o.bbox, o.area_km, GeometryType(o.the_geom) as featureType FROM objects o, fields f WHERE o.pid = ? AND o.fid = f.id AND ST_Intersects(the_geom, ST_GeomFromText('POINT(" + longitude + " " + latitude + ")', 4326))";
        List l = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Objects.class), new Object[]{pid});
        this.updateObjectWms(l);
        if (l.size() > 0) {
            return (Objects)l.get(0);
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    static {
        logger = Logger.getLogger(ObjectDAOImpl.class);
        String polygonSld = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\"><NamedLayer><Name>ALA:*layername*</Name><UserStyle><FeatureTypeStyle><Rule><RasterSymbolizer><Geometry></Geometry><ColorMap><ColorMapEntry color=\"0xff0000\" opacity=\"0\" quantity=\"*min_minus_one*\"/><ColorMapEntry color=\"0xff0000\" opacity=\"1\" quantity=\"*min*\"/><ColorMapEntry color=\"0xff0000\" opacity=\"0\" quantity=\"*max_plus_one*\"/></ColorMap></RasterSymbolizer></Rule></FeatureTypeStyle></UserStyle></NamedLayer></StyledLayerDescriptor>";
        String classSld = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\"><NamedLayer><Name>ALA:*layername*</Name><UserStyle><FeatureTypeStyle><Rule><RasterSymbolizer><Geometry></Geometry><ColorMap><ColorMapEntry color=\"0xff0000\" opacity=\"0\" quantity=\"*min_minus_one*\"/><ColorMapEntry color=\"0xff0000\" opacity=\"1\" quantity=\"*min*\"/><ColorMapEntry color=\"0xff0000\" opacity=\"1\" quantity=\"*max*\"/><ColorMapEntry color=\"0xff0000\" opacity=\"0\" quantity=\"*max_plus_one*\"/></ColorMap></RasterSymbolizer></Rule></FeatureTypeStyle></UserStyle></NamedLayer></StyledLayerDescriptor>";
        try {
            polygonSld = URLEncoder.encode(polygonSld, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            logger.fatal((Object)"Invalid polygon sld string defined in ObjectDAOImpl.");
        }
        try {
            classSld = URLEncoder.encode(classSld, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            logger.fatal((Object)"Invalid class sld string defined in ObjectDAOImpl.");
        }
        gridPolygonSld = polygonSld;
        gridClassSld = classSld;
    }
}

