/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.dao;

import au.org.ala.layers.dao.LayerPidDAO;
import au.org.ala.layers.dto.LayerPid;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service(value="layerPidDao")
public class LayerPidDAOImpl
implements LayerPidDAO {
    private static final Logger logger = Logger.getLogger(LayerPidDAOImpl.class);
    private JdbcTemplate jdbcTemplate;

    @Resource(name="dataSource")
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public List<LayerPid> getLayers() {
        logger.info((Object)"Getting a list of all enabled layerpids");
        String sql = "select * from layerpids";
        return this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(LayerPid.class));
    }

    @Override
    public LayerPid getLayerById(String id) {
        logger.info((Object)("Getting enabled layerpids info for id = " + id));
        String sql = "select * from layerpids where id = ?";
        List l = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(LayerPid.class), new Object[]{id});
        if (l.size() > 0) {
            return (LayerPid)l.get(0);
        }
        return null;
    }

    @Override
    public LayerPid getLayerByPid(String pid) {
        logger.info((Object)("Getting enabled layerpids info for pid = " + pid));
        String sql = "select * from layerpids where pid = ?";
        List l = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(LayerPid.class), new Object[]{pid});
        if (l.size() > 0) {
            return (LayerPid)l.get(0);
        }
        return null;
    }
}

