/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.tabulation;

import au.org.ala.layers.client.Client;
import au.org.ala.layers.dao.FieldDAO;
import au.org.ala.layers.dao.LayerDAO;
import au.org.ala.layers.dao.LayerIntersectDAO;
import au.org.ala.layers.dao.ObjectDAO;
import au.org.ala.layers.dto.Field;
import au.org.ala.layers.dto.IntersectionFile;
import au.org.ala.layers.dto.Layer;
import au.org.ala.layers.dto.Objects;
import au.org.ala.layers.dto.Tabulation;
import au.org.ala.layers.intersect.Grid;
import au.org.ala.layers.intersect.IntersectConfig;
import au.org.ala.layers.intersect.SimpleRegion;
import au.org.ala.layers.intersect.SimpleShapeFile;
import au.org.ala.layers.tabulation.AreaThread;
import au.org.ala.layers.tabulation.DistributionThread;
import au.org.ala.layers.tabulation.Pair;
import au.org.ala.layers.util.SpatialUtil;
import au.org.ala.spatial.analysis.layers.Records;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.springframework.jdbc.core.JdbcTemplate;

public class TabulationGenerator {
    private static final Logger logger = Logger.getLogger(TabulationGenerator.class);
    static int CONCURRENT_THREADS = 6;
    static String db_url = "jdbc:postgresql://localhost:5432/layersdb";
    static String db_usr = "postgres";
    static String db_pwd = "postgres";
    static String allFidPairsSQL = "SELECT (CASE WHEN f1.id < f2.id THEN f1.id ELSE f2.id END) as fid1, (CASE WHEN f1.id < f2.id THEN f2.id ELSE f1.id END) as fid2, (CASE WHEN f1.id < f2.id THEN f1.domain ELSE f2.domain END) as domain1, (CASE WHEN f1.id < f2.id THEN f2.domain ELSE f1.domain END) as domain2 FROM (select f3.id, l1.domain from fields f3, layers l1 where f3.intersect=true AND f3.spid='' || l1.id) f1, (select f4.id, l2.domain from fields f4, layers l2 where f4.intersect=true AND f4.spid='' || l2.id) f2 WHERE f1.id != f2.id group by fid1, fid2, domain1, domain2 order by fid1, fid2";
    static String existingTabulationssql = "SELECT fid1, fid2 from tabulation group by fid1, fid2";
    public static String fidPairsToProcessSQL = "SELECT a.fid1, a.domain1, a.fid2, a.domain2 FROM (" + allFidPairsSQL + ") a WHERE (a.fid1, a.fid2) NOT IN (" + existingTabulationssql + ") group by a.fid1, a.fid2, a.domain1, a.domain2;";
    static String runningTabulations = "SELECT * FROM pg_catalog.pg_stat_activity WHERE query like '%group by fid1, fid2, domain1, domain2%'";
    private static Records recordsOne = null;
    private static Connection connection;

    public static Connection getConnection() {
        boolean closed = false;
        try {
            if (connection != null) {
                closed = connection.isClosed();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (connection == null || closed) {
            Connection conn = null;
            try {
                Class.forName("org.postgresql.Driver");
                String url = db_url;
                conn = DriverManager.getConnection(url, db_usr, db_pwd);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to create Connection", (Throwable)e);
            }
            connection = conn;
        }
        return connection;
    }

    public static void main(String[] args) throws IOException {
        logger.info((Object)"args[0] = threadcount,\nargs[1] = db connection string,\n args[2] = db username,\n args[3] = password,\n args[4] = (optional) specify one step to run, '1' pair objects, '3' delete invalid objects, '4' area, '5' occurrences, '6' grid x grid comparisons\n args[5] = (required when args[4]=5 or 6) path to records file,");
        if (args.length >= 5) {
            CONCURRENT_THREADS = Integer.parseInt(args[0]);
            db_url = args[1];
            db_usr = args[2];
            db_pwd = args[3];
        }
        if (args.length < 5) {
            logger.info((Object)"all");
            TabulationGenerator.updatePairObjects();
            TabulationGenerator.deleteInvalidObjects();
            long start = System.currentTimeMillis();
            while (TabulationGenerator.updateArea() > 0) {
                logger.info((Object)("time since start= " + (System.currentTimeMillis() - start) + "ms"));
            }
        } else if (args[4].equals("1")) {
            logger.info((Object)"1");
            TabulationGenerator.updatePairObjects();
        } else if (args[4].equals("2")) {
            logger.info((Object)"2");
        } else if (args[4].equals("3")) {
            logger.info((Object)"3");
            TabulationGenerator.deleteInvalidObjects();
        } else if (args[4].equals("4")) {
            logger.info((Object)"4");
            long start = System.currentTimeMillis();
            while (TabulationGenerator.updateArea() > 0) {
                logger.info((Object)("time since start= " + (System.currentTimeMillis() - start) + "ms"));
            }
        } else if (args[4].equals("5")) {
            logger.info((Object)"5");
            FieldDAO fieldDao = Client.getFieldDao();
            LayerDAO layerDao = Client.getLayerDao();
            ObjectDAO objectDao = Client.getObjectDao();
            LayerIntersectDAO layerIntersectDao = Client.getLayerIntersectDao();
            logger.info((Object)("TEST: " + fieldDao.getFields()));
            logger.info((Object)("RECORDS FILE: " + args[5]));
            File f = new File(args[5]);
            if (f.exists()) {
                Records records = new Records(f.getAbsolutePath());
                TabulationGenerator.updateOccurrencesSpecies2(records, CONCURRENT_THREADS, null);
            } else {
                logger.info((Object)"Please provide a valid path to the species occurrence file");
            }
        } else if (args[4].equals("6")) {
            logger.info((Object)"6");
            FieldDAO fieldDao = Client.getFieldDao();
            LayerDAO layerDao = Client.getLayerDao();
            ObjectDAO objectDao = Client.getObjectDao();
            LayerIntersectDAO layerIntersectDao = Client.getLayerIntersectDao();
            logger.info((Object)("TEST: " + fieldDao.getFields()));
            logger.info((Object)("RECORDS FILE: " + args[5]));
            File f = new File(args[5]);
            if (f.exists()) {
                Records records = new Records(f.getAbsolutePath());
                TabulationGenerator.updatePairObjectsGridToGrid(records);
            } else {
                logger.info((Object)"Please provide a valid path to the species occurrence file");
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void all(String recordsFilePath, Connection connection) {
        TabulationGenerator.connection = connection;
        TabulationGenerator.waitForRunningTabulationsToFinish();
        TabulationGenerator.updatePairObjects();
        TabulationGenerator.deleteInvalidObjects();
        while (TabulationGenerator.updateArea() > 0) {
        }
        File f = new File(recordsFilePath);
        if (f.exists() && recordsOne == null) {
            try {
                recordsOne = new Records(f.getAbsolutePath());
            }
            catch (IOException e) {
                logger.error((Object)("failed to open records file: " + recordsFilePath), (Throwable)e);
            }
            TabulationGenerator.updateOccurrencesSpecies2(recordsOne, CONCURRENT_THREADS, null);
            TabulationGenerator.updatePairObjectsGridToGrid(recordsOne);
        } else {
            logger.info((Object)"Please provide a valid path to the species occurrence file");
        }
    }

    private static void waitForRunningTabulationsToFinish() {
        Connection conn = null;
        try {
            ResultSet rs1 = null;
            conn = TabulationGenerator.getConnection();
            String sql = runningTabulations;
            Statement s1 = conn.createStatement();
            while (rs1 == null || rs1.getFetchSize() > 0) {
                if (rs1 != null) {
                    Thread.sleep(300000L);
                }
                rs1 = s1.executeQuery(sql);
            }
        }
        catch (Exception e) {
            logger.error((Object)"error waiting for running tabulations to finish");
        }
    }

    private static void updatePairObjects() {
        Connection conn = null;
        try {
            conn = TabulationGenerator.getConnection();
            String sql = fidPairsToProcessSQL;
            Statement s2 = conn.createStatement();
            ResultSet rs2 = s2.executeQuery("select * from layers");
            HashMap<String, String> layerMap = new HashMap<String, String>();
            while (rs2.next()) {
                layerMap.put(rs2.getString("id"), rs2.getString("path_orig"));
            }
            rs2.close();
            s2.close();
            Statement s3 = conn.createStatement();
            ResultSet rs3 = s3.executeQuery("select * from fields");
            HashMap<String, String> fieldSpid = new HashMap<String, String>();
            while (rs3.next()) {
                fieldSpid.put(rs3.getString("id"), rs3.getString("spid"));
            }
            rs3.close();
            s3.close();
            Statement s1 = conn.createStatement();
            ResultSet rs1 = s1.executeQuery(sql);
            ConcurrentLinkedQueue<String> data = new ConcurrentLinkedQueue<String>();
            while (rs1.next()) {
                String layer1 = (String)fieldSpid.get(rs1.getString("fid1"));
                String layer2 = (String)fieldSpid.get(rs1.getString("fid2"));
                String path1 = (String)layerMap.get(layer1);
                String path2 = (String)layerMap.get(layer2);
                StringBuilder stringBuilder = new StringBuilder();
                Client.getLayerIntersectDao().getConfig();
                File f1 = new File(stringBuilder.append(IntersectConfig.getLayerFilesPath()).append(File.separator).append(path1).append(".shp").toString());
                StringBuilder stringBuilder2 = new StringBuilder();
                Client.getLayerIntersectDao().getConfig();
                File f2 = new File(stringBuilder2.append(IntersectConfig.getLayerFilesPath()).append(File.separator).append(path2).append(".shp").toString());
                if (!TabulationGenerator.isSameDomain(TabulationGenerator.parseDomain(rs1.getString("domain1")), TabulationGenerator.parseDomain(rs1.getString("domain2")))) continue;
                logger.info((Object)("will do tabulation on: " + rs1.getString("fid1") + ", " + rs1.getString("fid2")));
                data.add(rs1.getString("fid1") + "," + rs1.getString("fid2"));
            }
            rs1.close();
            s1.close();
            logger.info((Object)("next " + data.size()));
            int size = data.size();
            if (size == 0) {
                return;
            }
            DistributionThread[] threads = new DistributionThread[CONCURRENT_THREADS];
            for (int j = 0; j < CONCURRENT_THREADS; ++j) {
                connection = null;
                threads[j] = new DistributionThread(data);
                threads[j].start();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static String[] parseDomain(String domain) {
        if (domain == null || domain.length() == 0) {
            return null;
        }
        String[] domains = domain.split(",");
        for (int i = 0; i < domains.length; ++i) {
            domains[i] = domains[i].trim();
        }
        return domains;
    }

    public static boolean isSameDomain(String[] domain1, String[] domain2) {
        if (domain1 == null || domain2 == null) {
            return true;
        }
        for (String s1 : domain1) {
            for (String s2 : domain2) {
                if (!s1.equalsIgnoreCase(s2)) continue;
                return true;
            }
        }
        return false;
    }

    private static void updatePairObjectsGridToGrid(Records records) {
        Connection conn = null;
        try {
            conn = TabulationGenerator.getConnection();
            String sql = fidPairsToProcessSQL;
            Statement s1 = conn.createStatement();
            Statement s2 = conn.createStatement();
            ResultSet rs1 = s1.executeQuery(sql);
            while (rs1.next()) {
                String layer1 = Client.getFieldDao().getFieldById(rs1.getString("fid1")).getSpid();
                String layer2 = Client.getFieldDao().getFieldById(rs1.getString("fid2")).getSpid();
                String path1 = Client.getLayerDao().getLayerById(Integer.parseInt(layer1)).getPath_orig();
                String path2 = Client.getLayerDao().getLayerById(Integer.parseInt(layer2)).getPath_orig();
                StringBuilder stringBuilder = new StringBuilder();
                Client.getLayerIntersectDao().getConfig();
                File f1 = new File(stringBuilder.append(IntersectConfig.getLayerFilesPath()).append(File.separator).append(path1).append(".shp").toString());
                StringBuilder stringBuilder2 = new StringBuilder();
                Client.getLayerIntersectDao().getConfig();
                File f2 = new File(stringBuilder2.append(IntersectConfig.getLayerFilesPath()).append(File.separator).append(path2).append(".shp").toString());
                if (!TabulationGenerator.isSameDomain(TabulationGenerator.parseDomain(rs1.getString("domain1")), TabulationGenerator.parseDomain(rs1.getString("domain2"))) || f1.exists() && f2.exists() && f1.length() < 0x3200000L && f2.length() < 0x3200000L) continue;
                logger.info((Object)("gridToGrid: " + rs1.getString("fid1") + ", " + rs1.getString("fid2")));
                sql = TabulationGenerator.gridToGrid(rs1.getString("fid1"), rs1.getString("fid2"), records);
                s2.execute(sql);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static String gridToGrid(String fieldId1, String fieldId2, Records records) {
        return TabulationGenerator.gridToGrid(fieldId1, fieldId2, records, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String gridToGrid(String fieldId1, String fieldId2, Records records, String sqlFilePath) {
        FileWriter fw = null;
        StringBuilder sb = new StringBuilder();
        try {
            fw = sqlFilePath != null ? new FileWriter(sqlFilePath) : new FileWriter(fieldId1 + "_" + fieldId2 + ".sql");
            Client.getLayerIntersectDao().getConfig();
            List<Double> resolutions = IntersectConfig.getAnalysisResolutions();
            Double resolution = resolutions.get(0);
            resolution = Double.parseDouble(TabulationGenerator.confirmResolution(new String[]{fieldId1, fieldId2}, String.valueOf(resolution)));
            logger.info((Object)("RESOLUTION: " + resolution));
            double[][] field1Extents = TabulationGenerator.getLayerExtents(String.valueOf(resolution), fieldId1);
            logger.info((Object)("Extents for " + fieldId1 + ": " + field1Extents));
            double[][] field2Extents = TabulationGenerator.getLayerExtents(String.valueOf(resolution), fieldId2);
            logger.info((Object)("Extents for " + fieldId2 + ": " + field2Extents));
            double[][] extents = TabulationGenerator.internalExtents(field1Extents, field2Extents);
            logger.info((Object)("Internal extents: " + extents));
            if (!TabulationGenerator.isValidExtents(extents)) {
                logger.info((Object)("Warning, no overlap between grids: " + fieldId1 + " and " + fieldId2));
                String string = null;
                return string;
            }
            int width = 0;
            int height = 0;
            logger.info((Object)("resolution: " + resolution));
            height = (int)Math.ceil((extents[1][1] - extents[0][1]) / resolution);
            width = (int)Math.ceil((extents[1][0] - extents[0][0]) / resolution);
            String pth1 = TabulationGenerator.getLayerPath("" + resolution, fieldId1);
            String pth2 = TabulationGenerator.getLayerPath("" + resolution, fieldId2);
            logger.info((Object)("PATH 1: " + pth1));
            logger.info((Object)("PATH 2: " + pth2));
            Grid grid1 = new Grid(pth1);
            Grid grid2 = new Grid(pth2);
            Properties p1 = new Properties();
            p1.load(new FileReader(pth1 + ".txt"));
            Properties p2 = new Properties();
            p2.load(new FileReader(pth2 + ".txt"));
            List<Objects> objects1 = Client.getObjectDao().getObjectsById(fieldId1);
            List<Objects> objects2 = Client.getObjectDao().getObjectsById(fieldId2);
            block14: for (Map.Entry<Object, Object> entry : p1.entrySet()) {
                for (Objects o : objects1) {
                    if ((o.getId() != null || entry.getValue() != null) && (o.getId() == null || entry.getValue() == null || !o.getId().equalsIgnoreCase((String)entry.getValue()))) continue;
                    entry.setValue(o.getPid());
                    continue block14;
                }
            }
            block16: for (Map.Entry<Object, Object> entry : p2.entrySet()) {
                for (Objects o : objects2) {
                    if ((o.getId() != null || entry.getValue() != null) && (o.getId() == null || entry.getValue() == null || !o.getId().equalsIgnoreCase((String)entry.getValue()))) continue;
                    entry.setValue(o.getPid());
                    continue block16;
                }
            }
            HashMap<String, Pair> map = new HashMap<String, Pair>();
            if (records != null) {
                for (int i = 0; i < records.getRecordsSize(); ++i) {
                    int v1 = (int)grid1.getValues3(new double[][]{{records.getLongitude(i), records.getLatitude(i)}}, 0x100000)[0];
                    int v2 = (int)grid2.getValues3(new double[][]{{records.getLongitude(i), records.getLatitude(i)}}, 0x100000)[0];
                    String key = v1 + " " + v2;
                    Pair p = (Pair)map.get(key);
                    if (p == null) {
                        p = new Pair(key);
                        map.put(key, p);
                    }
                    p.species.set(records.getSpeciesNumber(i));
                    ++p.occurrences;
                }
            }
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    int v1 = (int)grid1.getValues3(new double[][]{{extents[0][0] + resolution * (double)i, extents[0][1] + resolution * (double)j}}, 40960)[0];
                    int v2 = (int)grid2.getValues3(new double[][]{{extents[0][0] + resolution * (double)i, extents[0][1] + resolution * (double)j}}, 40960)[0];
                    String key = v1 + " " + v2;
                    Pair p = (Pair)map.get(key);
                    if (p == null) {
                        p = new Pair(key);
                        map.put(key, p);
                    }
                    p.area += SpatialUtil.cellArea(resolution, extents[0][1] + resolution * (double)j) * 1000000.0;
                }
            }
            for (Map.Entry p : map.entrySet()) {
                if (p1.get(((Pair)p.getValue()).v1) == null || p2.get(((Pair)p.getValue()).v2) == null) continue;
                String sql = "INSERT INTO tabulation (fid1, fid2, pid1, pid2, area, occurrences, species) VALUES ('" + fieldId1 + "','" + fieldId2 + "','" + p1.get(((Pair)p.getValue()).v1) + "','" + p2.get(((Pair)p.getValue()).v2) + "'," + ((Pair)p.getValue()).area + "," + ((Pair)p.getValue()).occurrences + "," + ((Pair)p.getValue()).species.cardinality() + ");";
                sb.append(sql);
                fw.write(sql);
                fw.write("\n");
                fw.flush();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shpIntersection(String fieldId1, String shapeFile1, String idColumn1, String fieldId2, String shapeFile2, String idColumn2, File shpIntersectionFile, Records records, JdbcTemplate jdbcTemplate) throws IOException, ParseException {
        SimpleFeature feature1;
        SimpleShapeFile shp1 = new SimpleShapeFile(shapeFile1, idColumn1);
        SimpleShapeFile shp2 = new SimpleShapeFile(shapeFile2, idColumn2);
        HashMap<String, String> p1 = new HashMap<String, String>();
        HashMap<String, String> p2 = new HashMap<String, String>();
        HashMap<String, URL> map1 = new HashMap<String, URL>();
        map1.put("url", new File(shapeFile1).toURI().toURL());
        DataStore dataStore1 = DataStoreFinder.getDataStore(map1);
        String typeName1 = dataStore1.getTypeNames()[0];
        SimpleFeatureSource source = dataStore1.getFeatureSource(typeName1);
        FeatureIterator iterator1 = source.getFeatures().features();
        while (iterator1.hasNext()) {
            feature1 = (SimpleFeature)iterator1.next();
            p1.put(feature1.getID(), feature1.getAttribute(idColumn1).toString());
        }
        map1 = new HashMap();
        map1.put("url", new File(shapeFile1).toURI().toURL());
        dataStore1 = DataStoreFinder.getDataStore(map1);
        typeName1 = dataStore1.getTypeNames()[0];
        source = dataStore1.getFeatureSource(typeName1);
        iterator1 = source.getFeatures().features();
        while (iterator1.hasNext()) {
            feature1 = (SimpleFeature)iterator1.next();
            p2.put(feature1.getID(), feature1.getAttribute(idColumn1).toString());
        }
        HashMap<String, Pair> map = new HashMap<String, Pair>();
        if (records != null) {
            for (int i = 0; i < records.getRecordsSize(); ++i) {
                String v1 = shp1.intersect(records.getLongitude(i), records.getLatitude(i));
                String v2 = shp2.intersect(records.getLongitude(i), records.getLatitude(i));
                String key = v1 + " " + v2;
                Pair p = (Pair)map.get(key);
                if (p == null) {
                    p = new Pair(key);
                    map.put(key, p);
                }
                p.species.set(records.getSpeciesNumber(i));
                ++p.occurrences;
            }
        }
        ZipInputStream zis = null;
        try {
            String id1;
            zis = new ZipInputStream(new FileInputStream(shpIntersectionFile));
            ZipEntry ze = zis.getNextEntry();
            InputStreamReader isr = new InputStreamReader(zis);
            BufferedReader br = new BufferedReader(isr);
            while ((id1 = br.readLine()) != null) {
                String id2 = br.readLine();
                String wkt = br.readLine();
                String key = (String)p1.get(id1) + " " + (String)p2.get(id2);
                Pair p = (Pair)map.get(key);
                if (p == null) {
                    p = new Pair(key);
                    map.put(key, p);
                }
                p.area += SpatialUtil.calculateArea(wkt);
                WKTReader wktReader = new WKTReader();
                Geometry geom = wktReader.read(wkt);
                if (p.geom == null) {
                    p.geom = geom;
                    continue;
                }
                p.geom = p.geom.union(geom);
            }
            List<Objects> objects1 = Client.getObjectDao().getObjectsById(fieldId1);
            List<Objects> objects2 = Client.getObjectDao().getObjectsById(fieldId2);
            HashMap<String, String> pids1 = new HashMap<String, String>();
            HashMap<String, String> pids2 = new HashMap<String, String>();
            for (Objects o : objects1) {
                pids1.put(o.getId(), o.getPid());
            }
            for (Objects o : objects2) {
                pids2.put(o.getId(), o.getPid());
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry p : map.entrySet()) {
                if (p1.get(((Pair)p.getValue()).v1) == null || p2.get(((Pair)p.getValue()).v2) == null) continue;
                String sql = "INSERT INTO tabulation (fid1, fid2, pid1, pid2, the_geom, area, occurrences, species) VALUES ('" + fieldId1 + "','" + fieldId2 + "','" + (String)pids1.get(((Pair)p.getValue()).v1) + "','" + (String)pids2.get(((Pair)p.getValue()).v2) + "',ST_GEOMFROMTEXT('" + ((Pair)p.getValue()).geom.toText() + "', 4326)," + ((Pair)p.getValue()).area + "," + ((Pair)p.getValue()).occurrences + "," + ((Pair)p.getValue()).species.cardinality() + ");";
                jdbcTemplate.update(sql);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static String confirmResolution(String[] layers, String resolution) {
        try {
            TreeMap<Double, String> resolutions = new TreeMap<Double, String>();
            for (String layer : layers) {
                String res;
                Double d;
                int start;
                int end;
                String path = TabulationGenerator.getLayerPath(resolution, layer);
                if (path == null || (end = path.lastIndexOf(File.separator)) <= 0 || (start = path.lastIndexOf(File.separator, end - 1)) <= 0 || !((d = Double.valueOf(Double.parseDouble(res = path.substring(start + 1, end)))) < 1.0)) continue;
                resolutions.put(d, res);
            }
            if (resolutions.size() > 0) {
                resolution = (String)resolutions.firstEntry().getValue();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return resolution;
    }

    static double[][] internalExtents(double[][] e1, double[][] e2) {
        double[][] internalExtents = new double[2][2];
        internalExtents[0][0] = Math.max(e1[0][0], e2[0][0]);
        internalExtents[0][1] = Math.max(e1[0][1], e2[0][1]);
        internalExtents[1][0] = Math.min(e1[1][0], e2[1][0]);
        internalExtents[1][1] = Math.min(e1[1][1], e2[1][1]);
        return internalExtents;
    }

    static boolean isValidExtents(double[][] e) {
        return e[0][0] < e[1][0] && e[0][1] < e[1][1];
    }

    static double[][] getLayerExtents(String resolution, String layer) {
        double[][] extents = new double[2][2];
        Grid g = Grid.getGrid(TabulationGenerator.getLayerPath(resolution, layer));
        extents[0][0] = g.xmin;
        extents[0][1] = g.ymin;
        extents[1][0] = g.xmax;
        extents[1][1] = g.ymax;
        return extents;
    }

    public static String getLayerPath(String resolution, String layer) {
        Client.getLayerIntersectDao().getConfig();
        String analysisLayerDir = IntersectConfig.getAnalysisLayerFilesPath();
        String field = TabulationGenerator.getFieldId(layer);
        File file = new File(analysisLayerDir + File.separator + resolution + File.separator + field + ".grd");
        try {
            while (!file.exists()) {
                TreeMap<Double, String> resolutionDirs = new TreeMap<Double, String>();
                for (File dir : new File(analysisLayerDir).listFiles()) {
                    if (!dir.isDirectory()) continue;
                    try {
                        logger.info((Object)dir.getName());
                        resolutionDirs.put(Double.parseDouble(dir.getName()), dir.getName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String newResolution = (String)resolutionDirs.higherEntry(Double.parseDouble(resolution)).getValue();
                if (!newResolution.equals(resolution)) {
                    resolution = newResolution;
                    file = new File(analysisLayerDir + File.separator + resolution + File.separator + field + ".grd");
                    continue;
                }
                break;
            }
        }
        catch (Exception resolutionDirs) {
            // empty catch block
        }
        String layerPath = analysisLayerDir + File.separator + resolution + File.separator + field;
        if (new File(layerPath + ".grd").exists()) {
            return layerPath;
        }
        logger.info((Object)("getLayerPath, not a default layer, checking analysis output for: " + layer));
        String[] info = Client.getLayerIntersectDao().getConfig().getAnalysisLayerInfo(layer);
        if (info != null) {
            return info[1];
        }
        logger.info((Object)("getLayerPath, cannot find for: " + layer + ", " + resolution));
        return null;
    }

    public static String getFieldId(String layerShortName) {
        String field = layerShortName;
        try {
            String id = String.valueOf(Client.getLayerDao().getLayerByName(layerShortName).getId());
            for (Field f : Client.getFieldDao().getFields()) {
                if (f.getSpid() == null || !f.getSpid().equals(id)) continue;
                field = f.getId();
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return field;
    }

    private static int updateArea() {
        Connection conn = null;
        try {
            conn = TabulationGenerator.getConnection();
            String sql = "SELECT pid1, pid2, ST_AsText(the_geom) as wkt FROM tabulation WHERE pid1 is not null AND area is null  limit 100";
            if (conn == null) {
                logger.info((Object)"connection is null");
            } else {
                logger.info((Object)"connection is not null");
            }
            Statement s1 = conn.createStatement();
            ResultSet rs1 = s1.executeQuery(sql);
            ConcurrentLinkedQueue<String[]> data = new ConcurrentLinkedQueue<String[]>();
            while (rs1.next()) {
                data.add(new String[]{rs1.getString("pid1"), rs1.getString("pid2"), rs1.getString("wkt")});
            }
            logger.info((Object)("next " + data.size()));
            int size = data.size();
            if (size == 0) {
                return 0;
            }
            AreaThread[] threads = new AreaThread[CONCURRENT_THREADS];
            for (int j = 0; j < CONCURRENT_THREADS; ++j) {
                threads[j] = new AreaThread(data, TabulationGenerator.getConnection().createStatement());
                threads[j].start();
            }
            return size;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int updateOccurrencesSpecies2(Records records, int threadCount, String path) {
        FieldDAO fieldDao = Client.getFieldDao();
        LayerDAO layerDao = Client.getLayerDao();
        ObjectDAO objectDao = Client.getObjectDao();
        LayerIntersectDAO layerIntersectDao = Client.getLayerIntersectDao();
        HashSet<String> uniquePoints = new HashSet<String>();
        for (int i = 0; i < records.getRecordsSize(); ++i) {
            uniquePoints.add(records.getLongitude(i) + " " + records.getLatitude(i));
        }
        ArrayList pts = new ArrayList(uniquePoints);
        Collections.sort(pts);
        uniquePoints = null;
        double[][] points = new double[pts.size()][2];
        for (int i = 0; i < points.length; ++i) {
            String[] p = ((String)pts.get(i)).split(" ");
            points[i][0] = Double.NaN;
            points[i][1] = Double.NaN;
            try {
                points[i][0] = Double.parseDouble(p[0]);
                points[i][1] = Double.parseDouble(p[1]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int[] pointIdx = new int[records.getRecordsSize()];
        for (int i = 0; i < records.getRecordsSize(); ++i) {
            pointIdx[i] = Collections.binarySearch(pts, records.getLongitude(i) + " " + records.getLatitude(i));
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<File> files = new ArrayList<File>();
        for (Field f : fieldDao.getFields()) {
            if (!f.isIntersect().booleanValue() || path != null && new File(path + "_sample_" + f.getId()).exists()) continue;
            try {
                String fieldName = f.getSid();
                Layer l = layerDao.getLayerById(Integer.valueOf(f.getSpid()));
                StringBuilder stringBuilder = new StringBuilder();
                layerIntersectDao.getConfig();
                String filename = stringBuilder.append(IntersectConfig.getLayerFilesPath()).append(File.separator).append(l.getPath_orig()).toString();
                logger.info((Object)filename);
                File shp = new File(filename + ".shp");
                if (shp.exists()) {
                    SimpleShapeFile ssf = null;
                    if (layerIntersectDao.getConfig().getShapeFileCache() != null) {
                        ssf = layerIntersectDao.getConfig().getShapeFileCache().get(filename);
                    }
                    if (ssf == null) {
                        ssf = new SimpleShapeFile(filename, fieldName);
                    }
                    int column_idx = ssf.getColumnIdx(fieldName);
                    String[] catagories = ssf.getColumnLookup(column_idx);
                    int[] values = ssf.intersect(points, catagories, column_idx, threadCount);
                    List<Objects> objects = objectDao.getObjectsById(f.getId());
                    int[] catToPid = new int[catagories.length];
                    block32: for (int j = 0; j < objects.size(); ++j) {
                        for (int i = 0; i < catagories.length; ++i) {
                            if ((catagories[i] == null || objects.get(j).getId() == null) && catagories[i] == objects.get(j).getId()) {
                                catToPid[i] = j;
                                continue block32;
                            }
                            if (catagories[i] == null || objects.get(j).getId() == null || catagories[i].compareTo(objects.get(j).getId()) != 0) continue;
                            catToPid[i] = j;
                            continue block32;
                        }
                    }
                    OutputStreamWriter fw = null;
                    try {
                        File tmp = null;
                        tmp = path == null ? File.createTempFile(f.getId() + "_", "tabulation_generator") : new File(path + "/" + f.getId() + "_sample");
                        logger.info((Object)("**** tmp file **** > " + tmp.getPath()));
                        fields.add(f);
                        files.add(tmp);
                        fw = new FileWriter(tmp);
                        if (values != null) {
                            for (int i = 0; i < values.length; ++i) {
                                if (i > 0) {
                                    fw.append("\n");
                                }
                                if (values[i] >= 0) {
                                    fw.append(objects.get(catToPid[values[i]]).getPid());
                                    continue;
                                }
                                fw.append("n/a");
                            }
                        }
                        logger.debug((Object)("**** OK ***** > " + l.getPath_orig()));
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)("problem with sampling: " + l.getPath_orig()), (Throwable)e);
                        continue;
                    }
                    finally {
                        if (fw == null) continue;
                        try {
                            fw.close();
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                }
                StringBuilder stringBuilder2 = new StringBuilder();
                layerIntersectDao.getConfig();
                Grid g = new Grid(stringBuilder2.append(IntersectConfig.getLayerFilesPath()).append(File.separator).append(l.getPath_orig()).toString());
                if (g == null) continue;
                float[] values = g.getValues(points);
                OutputStreamWriter fw = null;
                try {
                    File tmp = null;
                    tmp = path == null ? File.createTempFile(f.getId() + "_", "tabulation_generator") : new File(path + "/" + f.getId() + "_sample");
                    logger.debug((Object)("**** tmp file **** > " + tmp.getPath()));
                    fields.add(f);
                    files.add(tmp);
                    fw = new FileWriter(tmp);
                    if (values != null) {
                        for (int i = 0; i < values.length; ++i) {
                            if (i > 0) {
                                fw.append("\n");
                            }
                            if (values[i] >= 0.0f) {
                                fw.append(String.valueOf(values[i]));
                                continue;
                            }
                            fw.append("n/a");
                        }
                    }
                    logger.debug((Object)("**** OK ***** > " + l.getPath_orig()));
                }
                catch (Exception e) {
                    logger.error((Object)("problem with sampling: " + l.getPath_orig()), (Throwable)e);
                }
                finally {
                    if (fw == null) continue;
                    try {
                        fw.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("problem with sampling: " + f.getId()), (Throwable)e);
            }
        }
        Connection conn = null;
        try {
            int i;
            conn = TabulationGenerator.getConnection();
            Statement statement = conn.createStatement();
            for (i = 0; i < fields.size(); ++i) {
                String[] s1 = TabulationGenerator.loadFile((File)files.get(i), pts.size());
                String fid1 = ((File)files.get(i)).getName().split("_")[0];
                for (int j = i + 1; j < fields.size(); ++j) {
                    String[] s2 = TabulationGenerator.loadFile((File)files.get(j), pts.size());
                    String fid2 = ((File)files.get(j)).getName().split("_")[0];
                    logger.info((Object)("|" + fid1 + "," + fid2));
                    ArrayList<String> sqlUpdates = TabulationGenerator.compare(records, pointIdx, s1, s2, fid1, fid2);
                    StringBuilder sb = new StringBuilder();
                    for (String s : sqlUpdates) {
                        sb.append(s).append(";\n");
                    }
                    statement.execute(sb.toString());
                    logger.debug((Object)sb.toString());
                }
            }
            statement.execute("UPDATE tabulation SET occurrences=0 WHERE occurrences is null;");
            statement.execute("UPDATE tabulation SET species=0 WHERE species is null;");
            if (path == null) {
                for (i = 0; i < files.size(); ++i) {
                    logger.info((Object)("FILE: " + ((File)files.get(i)).getPath()));
                    ((File)files.get(i)).delete();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] loadFile(File f, int size) {
        String[] s = new String[size];
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(f));
            int i = 0;
            while ((line = br.readLine()) != null) {
                s[i] = line;
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return s;
    }

    private static void deleteInvalidObjects() {
        Connection conn = null;
        try {
            String sql = "delete from tabulation where the_geom is not null and st_area(the_geom) = 0;";
            conn = TabulationGenerator.getConnection();
            conn.createStatement().execute(sql);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static ArrayList<String> compare(Records records, int[] pointIdx, String[] s1, String[] s2, String fid1, String fid2) {
        ArrayList<String> sqlUpdates = new ArrayList<String>();
        HashMap<String, BitSet> species = new HashMap<String, BitSet>();
        HashMap<String, Integer> occurrences = new HashMap<String, Integer>();
        HashMap<String, BitSet> speciesTotals = new HashMap<String, BitSet>();
        int countNa = 0;
        for (int i = 0; i < pointIdx.length; ++i) {
            BitSet bitset;
            String row = s1[pointIdx[i]];
            String col = s2[pointIdx[i]];
            String key = s1[pointIdx[i]] + " " + s2[pointIdx[i]];
            if (!(s1[pointIdx[i]] == null || s1[pointIdx[i]].isEmpty() || s1[pointIdx[i]].equals("n/a") || s2[pointIdx[i]] == null || s2[pointIdx[i]].isEmpty() || s2[pointIdx[i]].equals("n/a"))) {
                bitset = (BitSet)speciesTotals.get(col);
                if (bitset == null) {
                    bitset = new BitSet();
                }
                bitset.set(records.getSpeciesNumber(i));
                speciesTotals.put(col, bitset);
                bitset = (BitSet)speciesTotals.get(row);
                if (bitset == null) {
                    bitset = new BitSet();
                }
                bitset.set(records.getSpeciesNumber(i));
                speciesTotals.put(row, bitset);
                ++countNa;
            }
            if ((bitset = (BitSet)species.get(key)) == null) {
                bitset = new BitSet();
            }
            bitset.set(records.getSpeciesNumber(i));
            species.put(key, bitset);
            Integer count = (Integer)occurrences.get(key);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            occurrences.put(key, count);
        }
        for (String k : species.keySet()) {
            String[] pids = k.split(" ");
            sqlUpdates.add("UPDATE tabulation SET species = " + ((BitSet)species.get(k)).cardinality() + ", occurrences = " + occurrences.get(k) + " WHERE (pid1='" + pids[0] + "' AND pid2='" + pids[1] + "') OR (pid1='" + pids[1] + "' AND pid2='" + pids[0] + "')");
        }
        Iterator iterator = speciesTotals.keySet().iterator();
        while (iterator.hasNext()) {
            String k;
            String pid = k = (String)iterator.next();
            sqlUpdates.add("UPDATE tabulation SET speciest1 = " + ((BitSet)speciesTotals.get(k)).cardinality() + " WHERE pid1='" + pid + "' AND fid1='" + fid1 + "' AND fid2='" + fid2 + "'");
            sqlUpdates.add("UPDATE tabulation SET speciest2 = " + ((BitSet)speciesTotals.get(k)).cardinality() + " WHERE pid2='" + pid + "' AND fid1='" + fid1 + "' AND fid2='" + fid2 + "'");
        }
        return sqlUpdates;
    }

    public static List<Tabulation> calc(String fid, String wkt) {
        ArrayList<Tabulation> tabulations = new ArrayList<Tabulation>();
        IntersectionFile f = Client.getLayerIntersectDao().getConfig().getIntersectionFile(fid);
        Grid grid1 = new Grid(f.getFilePath());
        double resolution = grid1.xres;
        double[][] field1Extents = new double[2][2];
        field1Extents[0][0] = grid1.xmin;
        field1Extents[1][0] = grid1.xmax;
        field1Extents[0][1] = grid1.ymin;
        field1Extents[1][1] = grid1.ymax;
        logger.info((Object)("Extents for " + fid + ": " + field1Extents));
        SimpleRegion sr = SimpleShapeFile.parseWKT(wkt);
        double[][] field2Extents = sr.getBoundingBox();
        double[][] extents = TabulationGenerator.internalExtents(field1Extents, field2Extents);
        logger.info((Object)("Internal extents: " + extents));
        if (!TabulationGenerator.isValidExtents(extents)) {
            logger.info((Object)("Warning, no overlap between grids: " + fid));
            return tabulations;
        }
        int width = 0;
        int height = 0;
        logger.info((Object)("resolution: " + resolution));
        height = (int)Math.ceil((extents[1][1] - extents[0][1]) / resolution);
        width = (int)Math.ceil((extents[1][0] - extents[0][0]) / resolution);
        Properties p1 = new Properties();
        try {
            p1.load(new FileReader(f.getFilePath() + ".txt"));
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        HashMap<String, Pair> map = new HashMap<String, Pair>();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                if (!sr.isWithin(extents[0][0] + resolution * (double)i, extents[0][1] + resolution * (double)j)) continue;
                int v1 = (int)grid1.getValues3(new double[][]{{extents[0][0] + resolution * (double)i, extents[0][1] + resolution * (double)j}}, 0x100000)[0];
                String key = v1 + " " + v1;
                Pair p = (Pair)map.get(key);
                if (p == null) {
                    p = new Pair(key);
                    map.put(key, p);
                }
                p.area += SpatialUtil.cellArea(resolution, extents[0][1] + resolution * (double)j) * 1000000.0;
            }
        }
        for (Map.Entry p : map.entrySet()) {
            if (p1.get(((Pair)p.getValue()).v1) == null) continue;
            Tabulation t = new Tabulation();
            t.setFid1(fid);
            t.setName1(p1.getProperty(((Pair)p.getValue()).v1));
            t.setFid2("");
            t.setArea(((Pair)p.getValue()).area);
            t.setPid1(((Pair)p.getValue()).v1);
            t.setPid2("");
            tabulations.add(t);
        }
        return tabulations;
    }
}

