/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.dao;

import au.org.ala.layers.dao.LayerIntersectDAO;
import au.org.ala.layers.dao.SearchDAO;
import au.org.ala.layers.dto.GridClass;
import au.org.ala.layers.dto.IntersectionFile;
import au.org.ala.layers.dto.SearchObject;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Service;

@Service(value="searchDao")
public class SearchDAOImpl
implements SearchDAO {
    private static final Logger logger = Logger.getLogger(SearchDAOImpl.class);
    private JdbcTemplate jdbcTemplate;
    private NamedParameterJdbcTemplate jdbcParameterTemplate;
    @Resource(name="layerIntersectDao")
    private LayerIntersectDAO layerIntersectDao;

    @Resource(name="dataSource")
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.jdbcParameterTemplate = new NamedParameterJdbcTemplate(dataSource);
    }

    @Override
    public List<SearchObject> findByCriteria(String criteria, int limit) {
        logger.info((Object)("Getting search results for query: " + criteria));
        String sql = "select pid, id, name, \"desc\" as description, fid, fieldname from searchobjects(?,?)";
        return this.addGridClassesToSearch(this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(SearchObject.class), new Object[]{"%" + criteria + "%", limit}), criteria, limit, null, null);
    }

    @Override
    public List<SearchObject> findByCriteria(String criteria, int limit, List<String> includeFieldIds, List<String> excludeFieldIds) {
        logger.info((Object)("Getting search results for query: " + criteria));
        String fieldFilter = "";
        List<String> fieldIds = null;
        if (!includeFieldIds.isEmpty()) {
            fieldFilter = " and o.fid in ( :fieldIds ) ";
            fieldIds = includeFieldIds;
        } else if (!excludeFieldIds.isEmpty()) {
            fieldFilter = " and o.fid not in ( :fieldIds ) ";
            fieldIds = excludeFieldIds;
        }
        if (fieldFilter.isEmpty()) {
            String sql = "select o.pid as pid ,o.id as id, o.name as name, o.desc as description, o.fid as fid, f.name as fieldname from objects o inner join fields f on o.fid = f.id where o.name ilike ' ? ' and o.namesearch=true limit ?";
            return this.addGridClassesToSearch(this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(SearchObject.class), new Object[]{"%" + criteria + "%", limit}), criteria, limit, includeFieldIds, excludeFieldIds);
        }
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("fieldIds", fieldIds);
        parameters.addValue("searchTerm", (Object)("%" + criteria + "%"));
        parameters.addValue("limit", (Object)limit);
        String sql = "select o.pid as pid ,o.id as id, o.name as name, o.desc as description, o.fid as fid, f.name as fieldname from objects o inner join fields f on o.fid = f.id where o.name ilike :searchTerm and o.namesearch=true " + fieldFilter + " limit :limit";
        return this.addGridClassesToSearch(this.jdbcParameterTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(SearchObject.class)), criteria, limit, includeFieldIds, excludeFieldIds);
    }

    private List<SearchObject> addGridClassesToSearch(List<SearchObject> search, String criteria, int limit, List<String> includeFieldIds, List<String> excludeFieldIds) {
        int pos;
        criteria = criteria.toLowerCase();
        int maxPos = Integer.MAX_VALUE;
        for (SearchObject searchObject : search) {
            pos = searchObject.getName().toLowerCase().indexOf(criteria);
            if (pos < 0 || pos >= maxPos) continue;
            maxPos = pos;
        }
        for (Map.Entry entry : this.layerIntersectDao.getConfig().getIntersectionFiles().entrySet()) {
            IntersectionFile f = (IntersectionFile)entry.getValue();
            if (!"a".equalsIgnoreCase(f.getType()) || f.getClasses() == null || !((String)entry.getKey()).equals(f.getFieldId()) || includeFieldIds != null && !includeFieldIds.contains(f.getFieldId()) || excludeFieldIds != null && excludeFieldIds.contains(f.getFieldId())) continue;
            for (Map.Entry<Integer, GridClass> c : f.getClasses().entrySet()) {
                pos = c.getValue().getName().toLowerCase().indexOf(criteria);
                if (pos < 0 || pos > maxPos) continue;
                search.add(SearchObject.create(f.getLayerPid() + ":" + c.getKey(), f.getLayerPid() + ":" + c.getKey(), c.getValue().getName(), null, f.getFieldId(), f.getFieldName()));
            }
        }
        return search;
    }
}

