/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.util;

import au.org.ala.layers.dto.Layer;
import au.org.ala.layers.intersect.IntersectConfig;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import org.apache.log4j.Logger;

public class Util {
    private static final Logger logger = Logger.getLogger(Util.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readUrl(String feature) {
        StringBuilder content = new StringBuilder();
        HttpURLConnection conn = null;
        try {
            String line;
            URL url = new URL(feature);
            conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                content.append(line);
            }
        }
        catch (Exception e) {
            logger.error((Object)("failed to read URL: " + feature));
        }
        finally {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (Exception e) {
                    logger.error((Object)("failed to close url: " + feature), (Throwable)e);
                }
            }
        }
        return content.toString();
    }

    public static void updateDisplayPaths(List<Layer> layers) {
        if (layers == null) {
            return;
        }
        for (Layer layer : layers) {
            Util.updateDisplayPath(layer);
        }
    }

    public static void updateMetadataPaths(List<Layer> layers) {
        if (layers == null) {
            return;
        }
        for (Layer layer : layers) {
            Util.updateMetadataPath(layer);
        }
    }

    public static void updateDisplayPath(Layer layer) {
        if (layer.getDisplaypath() != null) {
            if (!layer.getDisplaypath().startsWith("/")) {
                layer.setDisplaypath(layer.getDisplaypath().replace("<COMMON_GEOSERVER_URL>", IntersectConfig.getGeoserverUrl()));
            } else {
                layer.setDisplaypath(IntersectConfig.getGeoserverUrl() + layer.getDisplaypath());
            }
        }
    }

    public static void updateMetadataPath(Layer layer) {
        if (layer.getMetadatapath() != null) {
            if (!layer.getMetadatapath().startsWith("/")) {
                layer.setMetadatapath(layer.getMetadatapath().replace("<COMMON_GEONETWORK_URL>", IntersectConfig.getGeonetworkUrl()));
            } else {
                layer.setMetadatapath(IntersectConfig.getGeonetworkUrl() + layer.getMetadatapath());
            }
        }
    }
}

