/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.util.ByteArrayBuilder;

public class Occurrences {
    private static Logger logger = Logger.getLogger(Occurrences.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOccurrences(String q, String server, String fields) throws IOException {
        int pageSize = 1000000;
        int start = 0;
        StringBuilder output = new StringBuilder();
        boolean isUserData = server.contains("spatial");
        logger.info((Object)("isUserData=" + isUserData + ", server=" + server));
        if (isUserData) {
            String url = server + "/userdata/sample?q=" + q + "&fl=" + fields;
            logger.info((Object)("getting occurrences from : " + url));
            InputStream is = null;
            try {
                int n;
                is = Occurrences.getUrlStream(url);
                ZipInputStream zis = new ZipInputStream(is);
                ZipEntry ze = zis.getNextEntry();
                ByteArrayBuilder bab = new ByteArrayBuilder();
                byte[] b = new byte[1024];
                while ((n = zis.read(b, 0, 1024)) > 0) {
                    bab.write(b, 0, n);
                }
                String csv = IOUtils.toString((byte[])bab.toByteArray(), (String)"UTF-8");
                output.append(csv);
            }
            catch (Exception e) {
                logger.error((Object)("failed to get userdata as csv for url: " + url), (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        } else {
            while (start < 300000000) {
                String url = server + "/webportal/occurrences.gz?q=" + q + "&pageSize=" + pageSize + "&start=" + start + "&fl=" + fields;
                logger.info((Object)("retrieving from biocache : " + url));
                int tryCount = 0;
                InputStream is = null;
                String csv = null;
                int maxTrys = 4;
                while (tryCount < maxTrys && csv == null) {
                    ++tryCount;
                    try {
                        is = Occurrences.getUrlStream(url);
                        csv = IOUtils.toString((InputStream)new GZIPInputStream(is));
                    }
                    catch (Exception e) {
                        logger.warn((Object)("failed try " + tryCount + " of " + maxTrys + ": " + url), (Throwable)e);
                    }
                    finally {
                        if (is == null) continue;
                        try {
                            is.close();
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
                if (csv == null) {
                    throw new IOException("failed to get records from biocache.");
                }
                output.append(csv);
                int currentCount = 0;
                int i = -1;
                while ((i = csv.indexOf("\n", i + 1)) > 0) {
                    ++currentCount;
                }
                if (currentCount != 0 && currentCount >= pageSize) continue;
                break;
            }
        }
        return output.toString();
    }

    static InputStream getUrlStream(String url) throws IOException {
        logger.debug((Object)("getting : " + url + " ... "));
        long start = System.currentTimeMillis();
        URLConnection c = new URL(url).openConnection();
        InputStream is = c.getInputStream();
        logger.debug((Object)(System.currentTimeMillis() - start + "ms"));
        return is;
    }
}

