/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.util;

import au.org.ala.layers.client.Client;
import au.org.ala.layers.dto.Field;
import au.org.ala.layers.dto.Layer;
import au.org.ala.layers.grid.GridCacheReader;
import au.org.ala.layers.intersect.IntersectConfig;
import java.io.File;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class LayerTests {
    private static Logger logger = Logger.getLogger(LayerTests.class);

    public static void main(String[] args) {
        Client.getLayerIntersectDao().getConfig().getIntersectionFile(null);
        LayerTests.TestLayers();
    }

    private static void testError(boolean expectTrue, String errorMsg) {
        if (!expectTrue) {
            logger.info((Object)("ERROR> " + errorMsg));
        }
    }

    private static void testWarning(boolean expectTrue, String errorMsg) {
        if (!expectTrue) {
            logger.info((Object)("WARN> " + errorMsg));
        }
    }

    private static void TestLayers() {
        List<Layer> layers = Client.getLayerDao().getLayersForAdmin();
        for (Layer l : layers) {
            LayerTests.TestLayer(l);
        }
    }

    private static void msg(String msg) {
        logger.info((Object)("*************> " + msg));
    }

    private static void TestLayer(Layer l) {
        String id = ", id=" + l.getId() + ", ";
        LayerTests.msg("Start testing layersdb.layers:" + id + " name:" + l.getName());
        LayerTests.testError(l.getId() != null, "layerdb.layers: record found with null id. (some tests skipped)");
        LayerTests.testError(l.getName() != null, "layersdb.layers:" + id + "missing name.");
        LayerTests.testError(l.getDisplayname() != null, "layersdb.layers:" + id + "missing displayname.");
        LayerTests.testWarning(l.getDescription() != null, "layersdb.layers:" + id + "missing description.");
        LayerTests.testError(l.getType() != null && (l.getType().equals("Environmental") || l.getType().equals("Contextual")), "layersdb.layers:" + id + "type is not 'Environmental' or 'Contextual'. (some tests skipped)");
        LayerTests.testError(l.getMaxlatitude() != null && l.getMaxlatitude() >= -90.0 && l.getMaxlatitude() <= 90.0 && (l.getMinlatitude() == null || l.getMaxlatitude() > l.getMinlatitude()), "layersdb.layers:" + id + "maxlatitude is invalid.");
        LayerTests.testError(l.getMinlatitude() != null && l.getMinlatitude() >= -90.0 && l.getMinlatitude() <= 90.0 && (l.getMaxlatitude() == null || l.getMaxlatitude() > l.getMinlatitude()), "layersdb.layers:" + id + "minlatitude is invalid.");
        LayerTests.testError(l.getMaxlongitude() != null && l.getMaxlongitude() >= -180.0 && l.getMaxlongitude() <= 180.0 && (l.getMinlongitude() == null || l.getMaxlongitude() > l.getMinlongitude()), "layersdb.layers:" + id + "maxlongitude is invalid.");
        LayerTests.testError(l.getMinlongitude() != null && l.getMinlongitude() >= -180.0 && l.getMinlongitude() <= 180.0 && (l.getMaxlongitude() == null || l.getMaxlongitude() > l.getMinlongitude()), "layersdb.layers:" + id + "minlongitude is invalid.");
        LayerTests.testError(l.getDisplaypath() != null && LayerTests.getUrlResponseCode(l.getDisplaypath()) == 400, "layersdb.layers:" + id + "computed displaypath: '" + l.getDisplaypath() + "' is invalid.");
        LayerTests.testError(l.getPath_orig() != null && LayerTests.isValidFilePrefix(l.getPath_orig()), "layersdb.layers:" + id + "path_orig does not exist. (some tests skipped)");
        if (l.getId() != null) {
            LayerTests.testError(l.getUid() != null && l.getUid().equals(String.valueOf(l.getId())), "layersdb.layers:" + id + "uid is not the same as the id.");
        }
        LayerTests.testError(l.getdomain() != null && (l.getdomain().equals("Marine") || l.getdomain().equals("Terrestrial") || l.getdomain().equals("Terrestrial,Marine") || l.getdomain().equals("Marine,Terrestrial")), "layersdb.layers:" + id + "domain must be 'Marine' or 'Terrestrial' or 'Terrestrial,Marine'");
        LayerTests.testWarning(l.getKeywords() != null && l.getKeywords().length() > 0, "layersdb.layers:" + id + "no keywords.");
        LayerTests.testError(l.getClassification1() != null && l.getClassification1().length() > 0, "layersdb.layers:" + id + "no classification1.");
        LayerTests.testWarning(l.getMetadatapath() != null && l.getMetadatapath().length() > 0, "layersdb.layers:" + id + "no metadatapath.");
        LayerTests.testWarning(l.getLicence_level() != null && l.getLicence_level().length() > 0, "layersdb.layers:" + id + "no licence level.");
        if (l.getType() != null && l.getType().equals("Environmental")) {
            LayerTests.testError(l.getScale() != null && l.getScale().length() > 0, "layersdb.layers:" + id + "missing scale.");
            LayerTests.testError(LayerTests.isDouble(l.getEnvironmentalvaluemax()) && (!LayerTests.isDouble(l.getEnvironmentalvaluemin()) || Double.parseDouble(l.getEnvironmentalvaluemin()) > Double.parseDouble(l.getEnvironmentalvaluemax())), "layersdb.layers:" + id + "invalid environmentalvaluemax.");
            LayerTests.testError(LayerTests.isDouble(l.getEnvironmentalvaluemin()) && (!LayerTests.isDouble(l.getEnvironmentalvaluemax()) || Double.parseDouble(l.getEnvironmentalvaluemin()) > Double.parseDouble(l.getEnvironmentalvaluemax())), "layersdb.layers:" + id + "invalid environmentalvaluemin.");
            LayerTests.testError(l.getEnvironmentalvalueunits() != null && l.getEnvironmentalvalueunits().length() > 0, "layersdb.layers:" + id + "missing environmentalvaluemax.");
        }
        boolean valid = false;
        Field f = null;
        try {
            f = Client.getFieldDao().getFieldById(Client.getLayerIntersectDao().getConfig().getIntersectionFile(l.getName()).getFieldId());
            valid = f != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        LayerTests.testError(valid, "layersdb.layers:" + id + "missing an associated field in the fields table");
        valid = false;
        if (f != null) {
            String r = "";
            for (Double d : IntersectConfig.getAnalysisResolutions()) {
                try {
                    if (LayerTests.isValidFilePrefix(IntersectConfig.getAnalysisLayerFilesPath() + File.separator + d + File.separator + f.getId())) {
                        valid = true;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                r = r + d + ", ";
            }
            LayerTests.testError(valid, "layersdb.layers:" + id + "error using analysis transformed grid file at ANALYSIS_LAYER_FILES_PATH: " + IntersectConfig.getAnalysisLayerFilesPath() + " for any of the ANALYSIS_RESOLUTIONS: " + r);
        }
        valid = false;
        try {
            Client.getLayerIntersectDao().getConfig();
            GridCacheReader gcr = new GridCacheReader(IntersectConfig.getGridCachePath());
            valid = gcr.getFileNames().contains(l.getName());
        }
        catch (Exception e) {
            StringBuilder stringBuilder = new StringBuilder().append("layersdb.layers:").append(id).append("initializing grid cache:");
            Client.getLayerIntersectDao().getConfig();
            logger.error((Object)stringBuilder.append(IntersectConfig.getGridCachePath()).toString(), (Throwable)e);
        }
        StringBuilder stringBuilder = new StringBuilder().append("layersdb.layers:").append(id).append("not in grid cache:");
        Client.getLayerIntersectDao().getConfig();
        LayerTests.testError(valid, stringBuilder.append(IntersectConfig.getGridCachePath()).toString());
    }

    private static boolean isValidFilePrefix(String filePrefix) {
        String path = filePrefix.substring(0, filePrefix.lastIndexOf(File.separator));
        String prefix = filePrefix.substring(path.length() + 1);
        File f = new File(IntersectConfig.getLayerFilesPath() + File.separator + path);
        if (f.exists() && f.isDirectory()) {
            for (File c : f.listFiles()) {
                if (!c.getName().startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getUrlResponseCode(String displaypath) {
        GetMethod get = null;
        try {
            HttpClient client = new HttpClient();
            get = new GetMethod(displaypath);
            int n = client.executeMethod((HttpMethod)get);
            return n;
        }
        catch (Exception e) {
            int n = -1;
            return n;
        }
        finally {
            if (get != null) {
                try {
                    get.releaseConnection();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static boolean isDouble(String s) {
        try {
            Double d = Double.parseDouble(s);
            return d != null;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

