/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.intersect;

import au.org.ala.layers.intersect.IniReader;
import au.org.ala.layers.util.SpatialUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class Grid {
    public static int maxGridsLoaded = 1;
    static ArrayList<Grid> all_grids = new ArrayList();
    final double noDataValueDefault = -3.4E38;
    public Boolean byteorderLSB = true;
    public int ncols;
    public int nrows;
    public double nodatavalue;
    public Boolean valid;
    public double[] values;
    public double xmin;
    public double xmax;
    public double ymin;
    public double ymax;
    public double xres;
    public double yres;
    public String datatype;
    public double minval;
    public double maxval;
    public String filename;
    public String units;
    public float rescale = 1.0f;
    protected Logger logger = Logger.getLogger(this.getClass());
    byte nbytes;
    float[] grid_data = null;
    private List<Grid> subgrids = null;
    private boolean subgrid = false;

    public Grid(String fname) {
        File grdfile;
        this.filename = fname;
        File grifile = new File(this.filename + ".gri");
        if (!grifile.exists()) {
            grifile = new File(this.filename + ".GRI");
        }
        if (!(grdfile = new File(this.filename + ".grd")).exists()) {
            grdfile = new File(this.filename + ".GRD");
        }
        if (grdfile.exists() && grifile.exists()) {
            this.readgrd(this.filename);
            if (this.xres == 1.0) {
                this.xres = (this.xmax - this.xmin) / (double)this.nrows;
                this.yres = (this.ymax - this.ymin) / (double)this.ncols;
            }
        } else if (grdfile.exists() && grdfile.isDirectory()) {
            File idx = new File(grdfile.getPath() + File.separator + "index.grd");
            if (!idx.exists()) {
                this.makeCollectionIndex(grdfile);
            }
            this.readgrd(grdfile.getPath() + File.separator + "index");
        } else {
            this.logger.error((Object)("cannot find GRID: " + fname));
        }
    }

    Grid(String fname, boolean keepAvailable) {
        File grdfile;
        this.filename = fname;
        File grifile = new File(this.filename + ".gri");
        if (!grifile.exists()) {
            grifile = new File(this.filename + ".GRI");
        }
        if (!(grdfile = new File(this.filename + ".grd")).exists()) {
            grdfile = new File(this.filename + ".GRD");
        }
        if (grdfile.exists() && grifile.exists()) {
            this.readgrd(this.filename);
            if (this.xres == 1.0) {
                this.xres = (this.xmax - this.xmin) / (double)this.nrows;
                this.yres = (this.ymax - this.ymin) / (double)this.ncols;
            }
        } else if (grdfile.exists() && grdfile.isDirectory()) {
            File idx = new File(grdfile.getPath() + File.separator + "index.grd");
            if (!idx.exists()) {
                this.makeCollectionIndex(grdfile);
            }
            this.readgrd(grdfile.getPath() + File.separator + "index");
        } else {
            this.logger.error((Object)("Error constructing grid from file: " + fname));
        }
        if (keepAvailable) {
            Grid.addGrid(this);
        }
    }

    public Grid() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeAvailable() {
        ArrayList<Grid> arrayList = all_grids;
        synchronized (arrayList) {
            while (all_grids.size() > 0) {
                all_grids.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addGrid(Grid g) {
        ArrayList<Grid> arrayList = all_grids;
        synchronized (arrayList) {
            for (int i = 0; i < all_grids.size(); ++i) {
                if (!g.filename.equalsIgnoreCase(Grid.all_grids.get((int)i).filename)) continue;
                return;
            }
            if (all_grids.size() == maxGridsLoaded) {
                all_grids.remove(0);
            }
            all_grids.add(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Grid getGrid(String filename) {
        ArrayList<Grid> arrayList = all_grids;
        synchronized (arrayList) {
            for (int i = 0; i < all_grids.size(); ++i) {
                if (!filename.equalsIgnoreCase(Grid.all_grids.get((int)i).filename)) continue;
                Grid g = all_grids.get(i);
                all_grids.remove(i);
                all_grids.add(g);
                return g;
            }
            return new Grid(filename, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Grid getLoadedGrid(String filename) {
        ArrayList<Grid> arrayList = all_grids;
        synchronized (arrayList) {
            for (int i = 0; i < all_grids.size(); ++i) {
                if (!filename.equalsIgnoreCase(Grid.all_grids.get((int)i).filename)) continue;
                Grid g = all_grids.get(i);
                all_grids.remove(i);
                all_grids.add(g);
                return g;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Grid getGridStandardized(String filename) {
        ArrayList<Grid> arrayList = all_grids;
        synchronized (arrayList) {
            for (int i = 0; i < all_grids.size(); ++i) {
                if (!filename.equalsIgnoreCase(Grid.all_grids.get((int)i).filename)) continue;
                Grid g = all_grids.get(i);
                all_grids.remove(i);
                all_grids.add(g);
                return g;
            }
            Grid g = new Grid(filename, true);
            float[] d = g.getGrid();
            double range = g.maxval - g.minval;
            for (int i = 0; i < d.length; ++i) {
                d[i] = (float)(((double)d[i] - g.minval) / range);
            }
            return g;
        }
    }

    private void makeCollectionIndex(File dir) {
        double xmin = 181.0;
        double xmax = -181.0;
        double ymin = 91.0;
        double ymax = -91.0;
        double minval = Double.NaN;
        double maxval = Double.NaN;
        double nodatavalue = Double.NaN;
        for (File f : dir.listFiles()) {
            if (!f.getName().toLowerCase().endsWith(".grd")) continue;
            try {
                Grid g = new Grid(f.getPath().substring(0, f.getPath().length() - 4).toString());
                if (g == null) continue;
                if (g.xmin < xmin) {
                    xmin = g.xmin;
                }
                if (g.xmax > xmax) {
                    xmax = g.xmax;
                }
                if (g.ymin < ymin) {
                    ymin = g.ymin;
                }
                if (g.ymax > ymax) {
                    ymax = g.ymax;
                }
                if (Double.isNaN(minval) || minval > g.minval) {
                    minval = g.minval;
                }
                if (Double.isNaN(maxval) || maxval < g.maxval) {
                    maxval = g.maxval;
                }
                nodatavalue = g.nodatavalue;
            }
            catch (Exception e) {
                this.logger.error((Object)("cannot add: " + f.getPath()));
            }
        }
        Grid n = new Grid();
        n.writeHeader(dir.getPath() + File.separator + "index", xmin, ymin, xmax, ymax, -1.0, -1.0, -1, -1, minval, maxval, "GRIDCOLLECTION", String.valueOf(nodatavalue));
    }

    public long getcellnumber(double x, double y) {
        if (x < this.xmin || x > this.xmax || y < this.ymin || y > this.ymax) {
            return -1L;
        }
        long col = (long)((x - this.xmin) / this.xres);
        long row = (long)this.nrows - 1L - (long)((y - this.ymin) / this.yres);
        if (col < 0L) {
            col = 0L;
        }
        if (row < 0L) {
            row = 0L;
        }
        if (col >= (long)this.ncols) {
            col = this.ncols - 1;
        }
        if (row >= (long)this.nrows) {
            row = this.nrows - 1;
        }
        return row * (long)this.ncols + col;
    }

    private void setdatatype(String s) {
        if ((s = s.toUpperCase()).equals("INT1BYTE")) {
            this.datatype = "BYTE";
        } else if (s.equals("INT2BYTES")) {
            this.datatype = "SHORT";
        } else if (s.equals("INT4BYTES")) {
            this.datatype = "INT";
        } else if (s.equals("INT8BYTES")) {
            this.datatype = "LONG";
        } else if (s.equals("FLT4BYTES")) {
            this.datatype = "FLOAT";
        } else if (s.equals("FLT8BYTES")) {
            this.datatype = "DOUBLE";
        } else if (s.equals("INT1B") || s.equals("BYTE")) {
            this.datatype = "BYTE";
        } else if (s.equals("INT1U") || s.equals("UBYTE")) {
            this.datatype = "UBYTE";
        } else if (s.equals("INT2B") || s.equals("INT16") || s.equals("INT2S")) {
            this.datatype = "SHORT";
        } else if (s.equals("INT4B")) {
            this.datatype = "INT";
        } else if (s.equals("INT8B") || s.equals("INT32")) {
            this.datatype = "LONG";
        } else if (s.equals("FLT4B") || s.equals("FLOAT32") || s.equals("FLT4S")) {
            this.datatype = "FLOAT";
        } else if (s.equals("FLT8B")) {
            this.datatype = "DOUBLE";
        } else if (s.equals("BYTE")) {
            this.datatype = "BYTE";
        } else if (s.equals("SHORT")) {
            this.datatype = "SHORT";
        } else if (s.equals("INT")) {
            this.datatype = "INT";
        } else if (s.equals("LONG")) {
            this.datatype = "LONG";
        } else if (s.equals("FLOAT")) {
            this.datatype = "FLOAT";
        } else if (s.equals("DOUBLE")) {
            this.datatype = "DOUBLE";
        } else if (s.equals("INTEGER")) {
            this.datatype = "INT";
        } else if (s.equals("SMALLINT")) {
            this.datatype = "INT";
        } else if (s.equals("SINGLE")) {
            this.datatype = "FLOAT";
        } else if (s.equals("REAL")) {
            this.datatype = "FLOAT";
        } else if (s.equals("GRIDCOLLECTION")) {
            this.datatype = s;
        } else {
            this.logger.error((Object)("GRID unknown type: " + s));
            this.datatype = "UNKNOWN";
        }
        this.nbytes = this.datatype.equals("BYTE") || this.datatype.equals("UBYTE") ? (byte)1 : (this.datatype.equals("SHORT") ? (byte)2 : (this.datatype.equals("INT") ? (byte)4 : (this.datatype.equals("LONG") ? (byte)8 : (this.datatype.equals("SINGLE") ? (byte)4 : (this.datatype.equals("DOUBLE") ? (byte)8 : (byte)0)))));
    }

    private void readgrd(String filename) {
        boolean hasSubgrids;
        IniReader ir = null;
        ir = new File(filename + ".grd").exists() ? new IniReader(filename + ".grd") : new IniReader(filename + ".GRD");
        this.setdatatype(ir.getStringValue("Data", "DataType"));
        this.maxval = (float)ir.getDoubleValue("Data", "MaxValue");
        this.minval = (float)ir.getDoubleValue("Data", "MinValue");
        this.ncols = ir.getIntegerValue("GeoReference", "Columns");
        this.nrows = ir.getIntegerValue("GeoReference", "Rows");
        this.xmin = ir.getDoubleValue("GeoReference", "MinX");
        this.ymin = ir.getDoubleValue("GeoReference", "MinY");
        this.xmax = ir.getDoubleValue("GeoReference", "MaxX");
        this.ymax = ir.getDoubleValue("GeoReference", "MaxY");
        this.xres = ir.getDoubleValue("GeoReference", "ResolutionX");
        this.yres = ir.getDoubleValue("GeoReference", "ResolutionY");
        this.nodatavalue = ir.valueExists("Data", "NoDataValue") ? ir.getDoubleValue("Data", "NoDataValue") : Double.NaN;
        String s = ir.getStringValue("Data", "ByteOrder");
        this.byteorderLSB = true;
        if (s != null && s.length() > 0 && s.equals("MSB")) {
            this.byteorderLSB = false;
        }
        this.units = ir.getStringValue("Data", "Units");
        if (this.units != null && this.units.startsWith("1/")) {
            try {
                this.rescale = 1.0f / Float.parseFloat(this.units.substring(2, this.units.indexOf(32)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.units != null && this.units.startsWith("x")) {
            try {
                this.rescale = Float.parseFloat(this.units.substring(1, this.units.indexOf(32)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.rescale != 1.0f) {
            this.units = this.units.substring(this.units.indexOf(32) + 1);
            this.maxval *= (double)this.rescale;
            this.minval *= (double)this.rescale;
        }
        if (hasSubgrids = "GRIDCOLLECTION".equals(ir.getStringValue("Data", "DataType"))) {
            this.subgrids = new ArrayList<Grid>();
            File dir = new File(filename).getParentFile();
            for (File f : dir.listFiles()) {
                if (!f.getName().toLowerCase().endsWith(".grd") || f.getName().equals("index.grd")) continue;
                try {
                    Grid g = new Grid(f.getPath().substring(0, f.getPath().length() - 4).toString());
                    if (g == null) continue;
                    g.subgrid = true;
                    this.subgrids.add(g);
                }
                catch (Exception e) {
                    this.logger.error((Object)("invalid grid file: " + f.getPath()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getGrid() {
        int maxArrayLength = 0x7FFFFFF5;
        if (this.grid_data != null) {
            return this.grid_data;
        }
        Grid loadedAlready = Grid.getLoadedGrid(this.filename);
        if (loadedAlready != null && loadedAlready.grid_data != null) {
            return loadedAlready.grid_data;
        }
        int length = this.nrows * this.ncols;
        float[] ret = new float[length];
        RandomAccessFile afile = null;
        File f2 = new File(this.filename + ".GRI");
        try {
            int len;
            afile = !f2.exists() ? new RandomAccessFile(this.filename + ".gri", "r") : new RandomAccessFile(this.filename + ".GRI", "r");
            byte[] b = new byte[(int)Math.min(afile.length(), (long)maxArrayLength)];
            int i = 0;
            int max = 0;
            while ((len = afile.read(b)) > 0) {
                ByteBuffer bb = ByteBuffer.wrap(b);
                if (this.byteorderLSB.booleanValue()) {
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                }
                if (this.datatype.equalsIgnoreCase("UBYTE")) {
                    max += len;
                    max = Math.min(max, ret.length);
                    while (i < max) {
                        ret[i] = bb.get();
                        if (ret[i] < 0.0f) {
                            int n = i;
                            ret[n] = ret[n] + 256.0f;
                        }
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("BYTE")) {
                    max += len;
                    max = Math.min(max, ret.length);
                    while (i < max) {
                        ret[i] = bb.get();
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("SHORT")) {
                    max += len / 2;
                    max = Math.min(max, ret.length);
                    while (i < max) {
                        ret[i] = bb.getShort();
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("INT")) {
                    max += len / 4;
                    max = Math.min(max, ret.length);
                    while (i < max) {
                        ret[i] = bb.getInt();
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("LONG")) {
                    max += len / 8;
                    max = Math.min(max, ret.length);
                    while (i < max) {
                        ret[i] = bb.getLong();
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("FLOAT")) {
                    max += len / 4;
                    max = Math.min(max, ret.length);
                    while (i < max) {
                        ret[i] = bb.getFloat();
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("DOUBLE")) {
                    max += len / 8;
                    max = Math.min(max, ret.length);
                    while (i < max) {
                        ret[i] = (float)bb.getDouble();
                        ++i;
                    }
                    continue;
                }
                max += len / 4;
                while (i < max) {
                    ret[i] = Float.NaN;
                    ++i;
                }
            }
            for (i = 0; i < length; ++i) {
                if (ret[i] == (float)this.nodatavalue) {
                    ret[i] = Float.NaN;
                    continue;
                }
                int n = i;
                ret[n] = ret[n] * this.rescale;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"An error has occurred - probably a file error", (Throwable)e);
        }
        finally {
            if (afile != null) {
                try {
                    afile.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        this.grid_data = ret;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getClassInfo(Map<Float, float[]> info) {
        long length = (long)this.nrows * (long)this.ncols;
        RandomAccessFile afile = null;
        File f2 = new File(this.filename + ".GRI");
        try {
            long len;
            afile = !f2.exists() ? new RandomAccessFile(this.filename + ".gri", "r") : new RandomAccessFile(this.filename + ".GRI", "r");
            byte[] b = new byte[65536];
            long i = 0L;
            long max = 0L;
            float ndv = (float)this.nodatavalue;
            while ((len = (long)afile.read(b)) > 0L) {
                float v;
                ByteBuffer bb = ByteBuffer.wrap(b);
                if (this.byteorderLSB.booleanValue()) {
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                }
                if (this.datatype.equalsIgnoreCase("UBYTE")) {
                    max += len;
                    max = Math.min(max, length);
                    while (i < max) {
                        v = bb.get();
                        if (v < 0.0f) {
                            v += 256.0f;
                        }
                        if (v != ndv) {
                            this.updatesStats(info, i, v * this.rescale);
                        }
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("BYTE")) {
                    max += len;
                    max = Math.min(max, length);
                    while (i < max) {
                        v = bb.get();
                        if (v != ndv) {
                            this.updatesStats(info, i, v * this.rescale);
                        }
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("SHORT")) {
                    max += len / 2L;
                    max = Math.min(max, length);
                    while (i < max) {
                        v = bb.getShort();
                        if (v != ndv) {
                            this.updatesStats(info, i, v * this.rescale);
                        }
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("INT")) {
                    max += len / 4L;
                    max = Math.min(max, length);
                    while (i < max) {
                        v = bb.getInt();
                        if (v != ndv) {
                            this.updatesStats(info, i, v * this.rescale);
                        }
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("LONG")) {
                    max += len / 8L;
                    max = Math.min(max, length);
                    while (i < max) {
                        v = bb.getLong();
                        if (v != ndv) {
                            this.updatesStats(info, i, v * this.rescale);
                        }
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("FLOAT")) {
                    max += len / 4L;
                    max = Math.min(max, length);
                    while (i < max) {
                        v = bb.getFloat();
                        if (v != ndv) {
                            this.updatesStats(info, i, v * this.rescale);
                        }
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("DOUBLE")) {
                    max += len / 8L;
                    max = Math.min(max, length);
                    while (i < max) {
                        v = (float)bb.getDouble();
                        if (v != ndv) {
                            this.updatesStats(info, i, v * this.rescale);
                        }
                        ++i;
                    }
                    continue;
                }
                max += len / 4L;
                while (i < max) {
                    ++i;
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"An error has occurred getting grid class stats", (Throwable)e);
        }
        finally {
            if (afile != null) {
                try {
                    afile.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceValues(Map<Integer, Integer> translation) {
        long length = (long)this.nrows * (long)this.ncols;
        Integer minv = null;
        Integer maxv = null;
        for (Integer i : translation.values()) {
            if (minv == null || i < minv) {
                minv = i;
            }
            if (maxv != null && i <= maxv) continue;
            maxv = i;
        }
        RandomAccessFile afile = null;
        RandomAccessFile out = null;
        File f2 = new File(this.filename + ".GRI");
        File newGrid = new File(this.filename + ".gri.new");
        try {
            long len;
            out = new RandomAccessFile(newGrid, "rw");
            afile = !f2.exists() ? new RandomAccessFile(this.filename + ".gri", "r") : new RandomAccessFile(this.filename + ".GRI", "r");
            byte[] b = new byte[65536];
            byte[] bout = new byte[65536];
            long i = 0L;
            long max = 0L;
            float ndv = (float)this.nodatavalue;
            while ((len = (long)afile.read(b)) > 0L) {
                float v;
                ByteBuffer bb = ByteBuffer.wrap(b);
                ByteBuffer bbout = ByteBuffer.wrap(bout);
                if (this.byteorderLSB.booleanValue()) {
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                    bbout.order(ByteOrder.LITTLE_ENDIAN);
                }
                if (this.datatype.equalsIgnoreCase("UBYTE")) {
                    throw new Exception("UBYTE translation not supported");
                }
                if (this.datatype.equalsIgnoreCase("BYTE")) {
                    throw new Exception("BYTE translation not supported");
                }
                if (this.datatype.equalsIgnoreCase("SHORT")) {
                    max += len / 2L;
                    max = Math.min(max, length);
                    while (i < max) {
                        v = bb.getShort();
                        if (v == ndv || translation.get((int)(v * this.rescale)) == null) {
                            // empty if block
                        }
                        if (v != ndv && translation.get((int)(v * this.rescale)) != null) {
                            v = translation.get((int)(v * this.rescale)).intValue();
                        }
                        bbout.putShort((short)v);
                        ++i;
                    }
                } else if (this.datatype.equalsIgnoreCase("INT")) {
                    max += len / 4L;
                    max = Math.min(max, length);
                    while (i < max) {
                        v = bb.getInt();
                        if (v != ndv && translation.get((int)(v * this.rescale)) != null) {
                            v = translation.get((int)(v * this.rescale)).intValue();
                        }
                        bbout.putInt((int)v);
                        ++i;
                    }
                } else if (this.datatype.equalsIgnoreCase("LONG")) {
                    max += len / 8L;
                    max = Math.min(max, length);
                    while (i < max) {
                        v = bb.getLong();
                        if (v != ndv && translation.get((int)(v * this.rescale)) != null) {
                            v = translation.get((int)(v * this.rescale)).intValue();
                        }
                        bbout.putLong((long)v);
                        ++i;
                    }
                } else {
                    if (this.datatype.equalsIgnoreCase("FLOAT")) {
                        throw new Exception("FLOAT translation not supported");
                    }
                    if (this.datatype.equalsIgnoreCase("DOUBLE")) {
                        throw new Exception("DOUBLE translation not supported");
                    }
                    max += len / 4L;
                    while (i < max) {
                        ++i;
                    }
                }
                out.write(bout, 0, (int)len);
            }
            this.writeHeader(this.filename + ".new", this.xmin, this.ymin, this.xmin + this.xres * (double)this.ncols, this.ymin + this.yres * (double)this.nrows, this.xres, this.yres, this.nrows, this.ncols, minv.intValue(), maxv.intValue(), this.datatype, this.nodatavalue + "");
        }
        catch (Exception e) {
            this.logger.error((Object)"An error has occurred getting grid class stats", (Throwable)e);
        }
        finally {
            if (afile != null) {
                try {
                    afile.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        try {
            if (!new File(this.filename + ".gri.old").exists()) {
                FileUtils.moveFile((File)new File(this.filename + ".gri"), (File)new File(this.filename + ".gri.old"));
            }
            if (!new File(this.filename + ".grd.old").exists()) {
                FileUtils.moveFile((File)new File(this.filename + ".grd"), (File)new File(this.filename + ".grd.old"));
            }
            FileUtils.moveFile((File)new File(this.filename + ".gri.new"), (File)new File(this.filename + ".gri"));
            FileUtils.moveFile((File)new File(this.filename + ".new.grd"), (File)new File(this.filename + ".grd"));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void updatesStats(Map<Float, float[]> info, long i, float v) {
        float[] stats = info.get(Float.valueOf(v));
        if (stats != null) {
            int row = (int)(i / (long)this.ncols);
            float lng = (float)(this.xmin + this.xres * (double)(i % (long)this.ncols));
            float lat = (float)(this.ymax - this.yres * (double)row);
            stats[0] = (float)((double)stats[0] + SpatialUtil.cellArea(this.yres, this.ymin + this.yres * (double)row));
            if (Float.isNaN(stats[1]) || stats[1] > lng) {
                stats[1] = lng;
            }
            if (Float.isNaN(stats[2]) || stats[2] > lat) {
                stats[2] = lat;
            }
            if (Float.isNaN(stats[3]) || (double)stats[3] < (double)lng + this.xres) {
                stats[3] = (float)((double)lng + this.xres);
            }
            if (Float.isNaN(stats[4]) || (double)stats[4] < (double)lat + this.yres) {
                stats[4] = (float)((double)lat + this.yres);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getGrid(int sampleEveryNthPoint) {
        int maxArrayLength = 0x7FFFFFF5;
        if (this.subgrids != null) {
            int size = 1000;
            double[][] points = new double[size * size][2];
            int pos = 0;
            for (int i = 0; i < 1000; ++i) {
                for (int j = 0; j < 1000; ++j) {
                    points[pos][0] = this.xmin + (this.xmax - this.xmin) * (double)j / (double)size;
                    points[pos][1] = this.ymax - (this.ymax - this.ymin) * (double)i / (double)size;
                    ++pos;
                }
            }
            return this.getValues3(points, 64);
        }
        int length = this.nrows / sampleEveryNthPoint * this.ncols;
        float[] ret = new float[length];
        RandomAccessFile afile = null;
        File f2 = new File(this.filename + ".GRI");
        try {
            int len;
            afile = !f2.exists() ? new RandomAccessFile(this.filename + ".gri", "r") : new RandomAccessFile(this.filename + ".GRI", "r");
            int sz = (int)Math.min(afile.length() / (long)sampleEveryNthPoint / (long)sampleEveryNthPoint, (long)maxArrayLength);
            sz += 8 - sz % 8;
            byte[] b = new byte[sz];
            long i = 0L;
            long max = 0L;
            while ((len = afile.read(b)) > 0) {
                ByteBuffer bb = ByteBuffer.wrap(b);
                if (this.byteorderLSB.booleanValue()) {
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                }
                if (this.datatype.equalsIgnoreCase("UBYTE")) {
                    max += (long)len;
                    max = Math.min(max, (long)ret.length * (long)sampleEveryNthPoint);
                    while (i < max) {
                        ret[(int)(i / (long)sampleEveryNthPoint)] = bb.get();
                        if (ret[(int)(i / (long)sampleEveryNthPoint)] < 0.0f) {
                            int n = (int)(i / (long)sampleEveryNthPoint);
                            ret[n] = ret[n] + 256.0f;
                        }
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("BYTE")) {
                    max += (long)len;
                    max = Math.min(max, (long)ret.length * (long)sampleEveryNthPoint);
                    while (i < max) {
                        ret[(int)(i / (long)sampleEveryNthPoint)] = bb.get();
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("SHORT")) {
                    max += (long)(len / 2);
                    max = Math.min(max, (long)ret.length * (long)sampleEveryNthPoint);
                    while (i < max) {
                        ret[(int)(i / (long)sampleEveryNthPoint)] = bb.getShort();
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("INT")) {
                    max += (long)(len / 4);
                    max = Math.min(max, (long)ret.length * (long)sampleEveryNthPoint);
                    while (i < max) {
                        ret[(int)(i / (long)sampleEveryNthPoint)] = bb.getInt();
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("LONG")) {
                    max += (long)(len / 8);
                    max = Math.min(max, (long)ret.length * (long)sampleEveryNthPoint);
                    while (i < max) {
                        ret[(int)(i / (long)sampleEveryNthPoint)] = bb.getLong();
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("FLOAT")) {
                    max += (long)(len / 4);
                    max = Math.min(max, (long)ret.length * (long)sampleEveryNthPoint);
                    while (i < max) {
                        ret[(int)(i / (long)sampleEveryNthPoint)] = bb.getFloat();
                        ++i;
                    }
                    continue;
                }
                if (this.datatype.equalsIgnoreCase("DOUBLE")) {
                    max += (long)(len / 8);
                    max = Math.min(max, (long)ret.length * (long)sampleEveryNthPoint);
                    while (i < max) {
                        ret[(int)(i / (long)sampleEveryNthPoint)] = (float)bb.getDouble();
                        ++i;
                    }
                    continue;
                }
                max += (long)(len / 4);
                while (i < max) {
                    ret[(int)(i / (long)sampleEveryNthPoint)] = Float.NaN;
                    ++i;
                }
            }
            for (i = 0L; i < (long)length; ++i) {
                if (ret[(int)i] == (float)this.nodatavalue) {
                    ret[(int)i] = Float.NaN;
                    continue;
                }
                int n = (int)i;
                ret[n] = ret[n] * this.rescale;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"An error has occurred - probably a file error", (Throwable)e);
        }
        finally {
            if (afile != null) {
                try {
                    afile.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        this.grid_data = ret;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeGrid(String newfilename, int[] dfiltered, double xmin, double ymin, double xmax, double ymax, double xres, double yres, int nrows, int ncols) {
        int length = dfiltered.length;
        double maxvalue = -2.147483647E9;
        double minvalue = 2.147483647E9;
        RandomAccessFile afile = null;
        try {
            afile = new RandomAccessFile(newfilename + ".gri", "rw");
            int size = 4;
            byte[] b = new byte[size * length];
            ByteBuffer bb = ByteBuffer.wrap(b);
            if (this.byteorderLSB.booleanValue()) {
                bb.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                bb.order(ByteOrder.BIG_ENDIAN);
            }
            for (int i = 0; i < length; ++i) {
                bb.putInt(dfiltered[i]);
            }
            afile.write(b);
        }
        catch (Exception e) {
            this.logger.error((Object)"error writing grid file", (Throwable)e);
        }
        finally {
            if (afile != null) {
                try {
                    afile.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        this.writeHeader(newfilename, xmin, ymin, xmin + xres * (double)ncols, ymin + yres * (double)nrows, xres, yres, nrows, ncols, minvalue, maxvalue, "INT4BYTES", "-9999");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeGrid(String newfilename, double[] dfiltered, double xmin, double ymin, double xmax, double ymax, double xres, double yres, int nrows, int ncols) {
        int length = dfiltered.length;
        double maxvalue = -1.7976931348623157E308;
        double minvalue = Double.MAX_VALUE;
        RandomAccessFile afile = null;
        try {
            afile = new RandomAccessFile(newfilename + ".gri", "rw");
            int size = 4;
            byte[] b = new byte[size * length];
            ByteBuffer bb = ByteBuffer.wrap(b);
            if (this.byteorderLSB.booleanValue()) {
                bb.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                bb.order(ByteOrder.BIG_ENDIAN);
            }
            for (int i = 0; i < length; ++i) {
                if (Double.isNaN(dfiltered[i])) {
                    bb.putFloat(-3.4E38f);
                    continue;
                }
                if (minvalue > dfiltered[i]) {
                    minvalue = dfiltered[i];
                }
                if (maxvalue < dfiltered[i]) {
                    maxvalue = dfiltered[i];
                }
                bb.putFloat((float)dfiltered[i]);
            }
            afile.write(b);
        }
        catch (Exception e) {
            this.logger.error((Object)"error writing grid file", (Throwable)e);
        }
        finally {
            if (afile != null) {
                try {
                    afile.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        this.writeHeader(newfilename, xmin, ymin, xmin + xres * (double)ncols, ymin + yres * (double)nrows, xres, yres, nrows, ncols, minvalue, maxvalue, "FLT4BYTES", String.valueOf(-3.4E38));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeGrid(String newfilename, float[] dfiltered, double xmin, double ymin, double xmax, double ymax, double xres, double yres, int nrows, int ncols) {
        int length = dfiltered.length;
        double maxvalue = -1.7976931348623157E308;
        double minvalue = Double.MAX_VALUE;
        RandomAccessFile afile = null;
        try {
            afile = new RandomAccessFile(newfilename + ".gri", "rw");
            int size = 4;
            byte[] b = new byte[size * length];
            ByteBuffer bb = ByteBuffer.wrap(b);
            if (this.byteorderLSB.booleanValue()) {
                bb.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                bb.order(ByteOrder.BIG_ENDIAN);
            }
            for (int i = 0; i < length; ++i) {
                if (Double.isNaN(dfiltered[i])) {
                    bb.putFloat(-3.4E38f);
                    continue;
                }
                if (minvalue > (double)dfiltered[i]) {
                    minvalue = dfiltered[i];
                }
                if (maxvalue < (double)dfiltered[i]) {
                    maxvalue = dfiltered[i];
                }
                bb.putFloat(dfiltered[i]);
            }
            afile.write(b);
        }
        catch (Exception e) {
            this.logger.error((Object)"error writing grid file", (Throwable)e);
        }
        finally {
            if (afile != null) {
                try {
                    afile.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        this.writeHeader(newfilename, xmin, ymin, xmin + xres * (double)ncols, ymin + yres * (double)nrows, xres, yres, nrows, ncols, minvalue, maxvalue, "FLT4BYTES", String.valueOf(-3.4E38));
    }

    public void writeHeader(String newfilename, double xmin, double ymin, double xmax, double ymax, double xres, double yres, int nrows, int ncols, double minvalue, double maxvalue) {
        this.writeHeader(newfilename, xmin, ymin, xmax, ymax, xres, yres, nrows, ncols, minvalue, maxvalue, "FLT4BYTES", String.valueOf(-3.4E38));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHeader(String newfilename, double xmin, double ymin, double xmax, double ymax, double xres, double yres, int nrows, int ncols, double minvalue, double maxvalue, String datatype, String nodata) {
        OutputStreamWriter fw = null;
        try {
            fw = new FileWriter(newfilename + ".grd");
            fw.append("[General]");
            fw.append("\r\n").append("Title=").append(newfilename);
            fw.append("\r\n").append("[GeoReference]");
            fw.append("\r\n").append("Projection=GEOGRAPHIC");
            fw.append("\r\n").append("Datum=WGS84");
            fw.append("\r\n").append("Mapunits=DEGREES");
            fw.append("\r\n").append("Columns=").append(String.valueOf(ncols));
            fw.append("\r\n").append("Rows=").append(String.valueOf(nrows));
            fw.append("\r\n").append("MinX=").append(String.format("%.2f", xmin));
            fw.append("\r\n").append("MaxX=").append(String.format("%.2f", xmax));
            fw.append("\r\n").append("MinY=").append(String.format("%.2f", ymin));
            fw.append("\r\n").append("MaxY=").append(String.format("%.2f", ymax));
            fw.append("\r\n").append("ResolutionX=").append(String.valueOf(xres));
            fw.append("\r\n").append("ResolutionY=").append(String.valueOf(yres));
            fw.append("\r\n").append("[Data]");
            fw.append("\r\n").append("DataType=" + datatype);
            fw.append("\r\n").append("MinValue=").append(String.valueOf(minvalue));
            fw.append("\r\n").append("MaxValue=").append(String.valueOf(maxvalue));
            fw.append("\r\n").append("NoDataValue=").append(nodata);
            fw.append("\r\n").append("Transparent=0");
            fw.flush();
        }
        catch (Exception e) {
            this.logger.error((Object)"error writing grid file header", (Throwable)e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public float[] getValues2(double[][] points) {
        if (points == null || points.length == 0) {
            return null;
        }
        if (this.subgrid) {
            return this.getValues3(points, Math.min(0x100000, 64 * points.length));
        }
        float[] ret = new float[points.length];
        float[] grid = this.getGrid();
        int glen = grid.length;
        int length = points.length;
        for (int i = 0; i < length; ++i) {
            int pos = (int)this.getcellnumber(points[i][0], points[i][1]);
            ret[i] = pos >= 0 && pos < glen ? grid[pos] : Float.NaN;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    float[] getGrid(double xmin, double ymin, double xmax, double ymax) {
        int width = (int)((xmax - xmin) / this.xres);
        int height = (int)((ymax - ymin) / this.yres);
        int startx = (int)((xmin - this.xmin) / this.xres);
        int endx = startx + width;
        int starty = (int)((ymin - this.ymin) / this.yres);
        int length = width * height;
        float[] ret = new float[length];
        int pos = 0;
        RandomAccessFile afile = null;
        File f2 = new File(this.filename + ".GRI");
        int size = 4;
        if (this.datatype.equals("BYTE") || this.datatype.equals("UBYTE")) {
            size = 1;
        } else if (this.datatype.equals("SHORT")) {
            size = 2;
        } else if (this.datatype.equals("INT")) {
            size = 4;
        } else if (this.datatype.equals("LONG")) {
            size = 8;
        } else if (this.datatype.equals("FLOAT")) {
            size = 4;
        } else if (this.datatype.equals("DOUBLE")) {
            size = 8;
        }
        try {
            int x;
            int i;
            afile = !f2.exists() ? new RandomAccessFile(this.filename + ".gri", "r") : new RandomAccessFile(this.filename + ".GRI", "r");
            afile.seek((long)this.ncols * (long)starty * (long)size);
            int readSize = this.ncols * height * size;
            int readLen = this.ncols * height;
            byte[] b = new byte[readSize];
            afile.read(b);
            ByteBuffer bb = ByteBuffer.wrap(b);
            if (this.byteorderLSB.booleanValue()) {
                bb.order(ByteOrder.LITTLE_ENDIAN);
            }
            if (this.datatype.equalsIgnoreCase("BYTE")) {
                for (i = 0; i < readLen; ++i) {
                    x = i % this.ncols;
                    if (x < startx || x >= endx) {
                        bb.get();
                        continue;
                    }
                    ret[pos++] = bb.get();
                }
            } else if (this.datatype.equalsIgnoreCase("UBYTE")) {
                for (i = 0; i < readLen; ++i) {
                    x = i % this.ncols;
                    if (x < startx || x >= endx) {
                        bb.get();
                        continue;
                    }
                    ret[pos] = bb.get();
                    if (ret[pos] < 0.0f) {
                        int n = pos;
                        ret[n] = ret[n] + 256.0f;
                    }
                    ++pos;
                }
            } else if (this.datatype.equalsIgnoreCase("SHORT")) {
                for (i = 0; i < readLen; ++i) {
                    x = i % this.ncols;
                    if (x < startx || x >= endx) {
                        bb.getShort();
                        continue;
                    }
                    ret[pos++] = bb.getShort();
                }
            } else if (this.datatype.equalsIgnoreCase("INT")) {
                for (i = 0; i < readLen; ++i) {
                    x = i % this.ncols;
                    if (x < startx || x >= endx) {
                        bb.getInt();
                        continue;
                    }
                    ret[pos++] = bb.getInt();
                }
            } else if (this.datatype.equalsIgnoreCase("LONG")) {
                for (i = 0; i < readLen; ++i) {
                    x = i % this.ncols;
                    if (x < startx || x >= endx) {
                        bb.getLong();
                        continue;
                    }
                    ret[pos++] = bb.getLong();
                }
            } else if (this.datatype.equalsIgnoreCase("FLOAT")) {
                for (i = 0; i < readLen; ++i) {
                    x = i % this.ncols;
                    if (x < startx || x >= endx) {
                        bb.getFloat();
                        continue;
                    }
                    ret[pos++] = bb.getFloat();
                }
            } else if (this.datatype.equalsIgnoreCase("DOUBLE")) {
                for (i = 0; i < readLen; ++i) {
                    x = i % this.ncols;
                    if (x < startx || x >= endx) {
                        bb.getDouble();
                        continue;
                    }
                    ret[pos++] = (float)bb.getDouble();
                }
            } else {
                for (i = 0; i < length; ++i) {
                    ret[i] = Float.NaN;
                }
            }
            for (i = 0; i < length; ++i) {
                if (ret[i] == (float)this.nodatavalue) {
                    ret[i] = Float.NaN;
                    continue;
                }
                int n = i;
                ret[n] = ret[n] * this.rescale;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("GRID: " + e.toString()), (Throwable)e);
        }
        finally {
            if (afile != null) {
                try {
                    afile.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        this.grid_data = ret;
        return ret;
    }

    public void printMinMax() {
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        float[] data = this.getGrid();
        int numMissing = 0;
        for (float d : data) {
            if (Float.isNaN(d)) {
                ++numMissing;
            }
            if (d < min) {
                min = d;
            }
            if (!(d > max)) continue;
            max = d;
        }
        if ((double)min != this.minval || (double)max != this.maxval) {
            this.logger.error((Object)(this.filename + " ERR header(" + this.minval + " " + this.maxval + ") actual(" + min + " " + max + ") number missing(" + numMissing + " of " + data.length + ")"));
        } else {
            this.logger.error((Object)(this.filename + " OK header(" + this.minval + " " + this.maxval + ") number missing(" + numMissing + " of " + data.length + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getValues(double[][] points) {
        if (points == null || points.length == 0) {
            return null;
        }
        Grid g = Grid.getLoadedGrid(this.filename);
        if (g != null) {
            return g.getValues2(points);
        }
        if (this.subgrids != null) {
            return this.getValues3(points, Math.min(0x100000, 64 * points.length));
        }
        float[] ret = new float[points.length];
        int length = points.length;
        RandomAccessFile afile = null;
        File f2 = new File(this.filename + ".GRI");
        try {
            ByteBuffer bb;
            int pos;
            int i;
            byte[] b;
            long size;
            afile = !f2.exists() ? new RandomAccessFile(this.filename + ".gri", "r") : new RandomAccessFile(this.filename + ".GRI", "r");
            if (this.datatype.equalsIgnoreCase("BYTE")) {
                size = 1L;
                b = new byte[(int)size];
                for (i = 0; i < length; ++i) {
                    pos = (int)this.getcellnumber(points[i][0], points[i][1]);
                    if (pos >= 0) {
                        afile.seek((long)pos * size);
                        ret[i] = afile.readByte();
                        continue;
                    }
                    ret[i] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("UBYTE")) {
                size = 1L;
                b = new byte[(int)size];
                for (i = 0; i < length; ++i) {
                    pos = (int)this.getcellnumber(points[i][0], points[i][1]);
                    if (pos >= 0) {
                        afile.seek((long)pos * size);
                        ret[i] = afile.readByte();
                        if (!(ret[i] < 0.0f)) continue;
                        int n = i;
                        ret[n] = ret[n] + 256.0f;
                        continue;
                    }
                    ret[i] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("SHORT")) {
                size = 2L;
                b = new byte[(int)size];
                for (i = 0; i < length; ++i) {
                    pos = (int)this.getcellnumber(points[i][0], points[i][1]);
                    if (pos >= 0) {
                        afile.seek((long)pos * size);
                        afile.read(b);
                        if (this.byteorderLSB.booleanValue()) {
                            ret[i] = (short)((0xFF & b[1]) << 8 | b[0] & 0xFF);
                            continue;
                        }
                        ret[i] = (short)((0xFF & b[0]) << 8 | b[1] & 0xFF);
                        continue;
                    }
                    ret[i] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("INT")) {
                size = 4L;
                b = new byte[(int)size];
                for (i = 0; i < length; ++i) {
                    pos = (int)this.getcellnumber(points[i][0], points[i][1]);
                    if (pos >= 0) {
                        afile.seek((long)pos * size);
                        afile.read(b);
                        if (this.byteorderLSB.booleanValue()) {
                            ret[i] = (0xFF & b[3]) << 24 | ((0xFF & b[2]) << 16) + ((0xFF & b[1]) << 8) + (b[0] & 0xFF);
                            continue;
                        }
                        ret[i] = (0xFF & b[0]) << 24 | ((0xFF & b[1]) << 16) + ((0xFF & b[2]) << 8) + (0xFF & b[3] & 0xFF);
                        continue;
                    }
                    ret[i] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("LONG")) {
                size = 8L;
                b = new byte[(int)size];
                for (i = 0; i < length; ++i) {
                    pos = (int)this.getcellnumber(points[i][0], points[i][1]);
                    if (pos >= 0) {
                        afile.seek((long)pos * size);
                        afile.read(b);
                        if (this.byteorderLSB.booleanValue()) {
                            ret[i] = ((long)(0xFF & b[7]) << 56) + ((long)(0xFF & b[6]) << 48) + ((long)(0xFF & b[5]) << 40) + ((long)(0xFF & b[4]) << 32) + ((long)(0xFF & b[3]) << 24) + ((long)(0xFF & b[2]) << 16) + ((long)(0xFF & b[1]) << 8) + (long)(0xFF & b[0]);
                            continue;
                        }
                        ret[i] = ((long)(0xFF & b[0]) << 56) + ((long)(0xFF & b[1]) << 48) + ((long)(0xFF & b[2]) << 40) + ((long)(0xFF & b[3]) << 32) + ((long)(0xFF & b[4]) << 24) + ((long)(0xFF & b[5]) << 16) + ((long)(0xFF & b[6]) << 8) + (long)(0xFF & b[7]);
                        continue;
                    }
                    ret[i] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("FLOAT")) {
                size = 4L;
                b = new byte[(int)size];
                for (i = 0; i < length; ++i) {
                    pos = (int)this.getcellnumber(points[i][0], points[i][1]);
                    if (pos >= 0) {
                        afile.seek((long)pos * size);
                        afile.read(b);
                        bb = ByteBuffer.wrap(b);
                        if (this.byteorderLSB.booleanValue()) {
                            bb.order(ByteOrder.LITTLE_ENDIAN);
                        }
                        ret[i] = bb.getFloat();
                        continue;
                    }
                    ret[i] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("DOUBLE")) {
                size = 8L;
                b = new byte[8];
                for (i = 0; i < length; ++i) {
                    pos = (int)this.getcellnumber(points[i][0], points[i][1]);
                    if (pos >= 0) {
                        afile.seek((long)pos * size);
                        afile.read(b);
                        bb = ByteBuffer.wrap(b);
                        if (this.byteorderLSB.booleanValue()) {
                            bb.order(ByteOrder.LITTLE_ENDIAN);
                        }
                        ret[i] = (float)bb.getDouble();
                        continue;
                    }
                    ret[i] = Float.NaN;
                }
            } else {
                this.logger.error((Object)("datatype not supported in Grid.getValues: " + this.datatype));
                for (i = 0; i < length; ++i) {
                    ret[i] = Float.NaN;
                }
            }
            for (i = 0; i < length; ++i) {
                if (ret[i] == (float)this.nodatavalue) {
                    ret[i] = Float.NaN;
                    continue;
                }
                int n = i;
                ret[n] = ret[n] * this.rescale;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"error getting grid file values", (Throwable)e);
        }
        finally {
            if (afile != null) {
                try {
                    afile.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getValues3(double[][] points, int bufferSize) {
        if (points == null || points.length == 0) {
            return null;
        }
        if (this.subgrids != null) {
            return this.getValuesSubgrids(points, bufferSize);
        }
        Grid g = Grid.getLoadedGrid(this.filename);
        if (g != null && g.grid_data != null) {
            return g.getValues2(points);
        }
        int length = points.length;
        RandomAccessFile afile = null;
        File f2 = new File(this.filename + ".GRI");
        try {
            byte[] b;
            int i;
            int size;
            afile = !f2.exists() ? new RandomAccessFile(this.filename + ".gri", "r") : new RandomAccessFile(this.filename + ".GRI", "r");
            if (!this.subgrid && afile.length() < 0x5000000L) {
                try {
                    afile.close();
                    afile = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                float[] fArray = this.getValues2(points);
                return fArray;
            }
            byte[] buffer = new byte[bufferSize];
            Long bufferOffset = afile.length();
            float[] ret = new float[points.length];
            long[][] cells = new long[points.length][2];
            for (int j = 0; j < points.length; ++j) {
                if (Double.isNaN(points[j][0]) || Double.isNaN(points[j][1])) {
                    cells[j][0] = -1L;
                    cells[j][1] = j;
                    continue;
                }
                cells[j][0] = this.getcellnumber(points[j][0], points[j][1]);
                cells[j][1] = j;
            }
            Arrays.sort(cells, new Comparator<long[]>(){

                @Override
                public int compare(long[] o1, long[] o2) {
                    if (o1[0] == o2[0]) {
                        return o1[1] > o2[1] ? 1 : -1;
                    }
                    return o1[0] > o2[0] ? 1 : -1;
                }
            });
            if (this.datatype.equalsIgnoreCase("BYTE")) {
                size = 1;
                for (i = 0; i < length; ++i) {
                    ret[(int)cells[i][1]] = i > 0 && cells[i - 1][0] == cells[i][0] ? ret[(int)cells[i - 1][1]] : (cells[i][0] >= 0L ? (float)this.getByte(afile, buffer, bufferOffset, cells[i][0] * (long)size) : Float.NaN);
                }
            } else if (this.datatype.equalsIgnoreCase("UBYTE")) {
                size = 1;
                for (i = 0; i < length; ++i) {
                    if (i > 0 && cells[i - 1][0] == cells[i][0]) {
                        ret[(int)cells[i][1]] = ret[(int)cells[i - 1][1]];
                        continue;
                    }
                    if (cells[i][0] >= 0L) {
                        ret[(int)cells[i][1]] = this.getByte(afile, buffer, bufferOffset, cells[i][0] * (long)size);
                        if (!(ret[(int)cells[i][1]] < 0.0f)) continue;
                        int n = (int)cells[i][1];
                        ret[n] = ret[n] + 256.0f;
                        continue;
                    }
                    ret[(int)cells[i][1]] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("SHORT")) {
                size = 2;
                b = new byte[size];
                for (i = 0; i < length; ++i) {
                    if (i > 0 && cells[i - 1][0] == cells[i][0]) {
                        ret[(int)cells[i][1]] = ret[(int)cells[i - 1][1]];
                        continue;
                    }
                    if (cells[i][0] >= 0L) {
                        bufferOffset = this.getBytes(afile, buffer, bufferOffset, cells[i][0] * (long)size, b);
                        if (this.byteorderLSB.booleanValue()) {
                            ret[(int)cells[i][1]] = (short)((0xFF & b[1]) << 8 | b[0] & 0xFF);
                            continue;
                        }
                        ret[(int)cells[i][1]] = (short)((0xFF & b[0]) << 8 | b[1] & 0xFF);
                        continue;
                    }
                    ret[(int)cells[i][1]] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("INT")) {
                size = 4;
                b = new byte[size];
                for (i = 0; i < length; ++i) {
                    if (i > 0 && cells[i - 1][0] == cells[i][0]) {
                        ret[(int)cells[i][1]] = ret[(int)cells[i - 1][1]];
                        continue;
                    }
                    if (cells[i][0] >= 0L) {
                        bufferOffset = this.getBytes(afile, buffer, bufferOffset, cells[i][0] * (long)size, b);
                        if (this.byteorderLSB.booleanValue()) {
                            ret[(int)cells[i][1]] = (0xFF & b[3]) << 24 | ((0xFF & b[2]) << 16) + ((0xFF & b[1]) << 8) + (b[0] & 0xFF);
                            continue;
                        }
                        ret[(int)cells[i][1]] = (0xFF & b[0]) << 24 | ((0xFF & b[1]) << 16) + ((0xFF & b[2]) << 8) + (0xFF & b[3] & 0xFF);
                        continue;
                    }
                    ret[(int)cells[i][1]] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("LONG")) {
                size = 8;
                b = new byte[size];
                for (i = 0; i < length; ++i) {
                    if (i > 0 && cells[i - 1][0] == cells[i][0]) {
                        ret[(int)cells[i][1]] = ret[(int)cells[i - 1][1]];
                        continue;
                    }
                    if (cells[i][0] >= 0L) {
                        bufferOffset = this.getBytes(afile, buffer, bufferOffset, cells[i][0] * (long)size, b);
                        if (this.byteorderLSB.booleanValue()) {
                            ret[(int)cells[i][1]] = ((long)(0xFF & b[7]) << 56) + ((long)(0xFF & b[6]) << 48) + ((long)(0xFF & b[5]) << 40) + ((long)(0xFF & b[4]) << 32) + ((long)(0xFF & b[3]) << 24) + ((long)(0xFF & b[2]) << 16) + ((long)(0xFF & b[1]) << 8) + (long)(0xFF & b[0]);
                            continue;
                        }
                        ret[(int)cells[i][1]] = ((long)(0xFF & b[0]) << 56) + ((long)(0xFF & b[1]) << 48) + ((long)(0xFF & b[2]) << 40) + ((long)(0xFF & b[3]) << 32) + ((long)(0xFF & b[4]) << 24) + ((long)(0xFF & b[5]) << 16) + ((long)(0xFF & b[6]) << 8) + (long)(0xFF & b[7]);
                        continue;
                    }
                    ret[(int)cells[i][1]] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("FLOAT")) {
                size = 4;
                b = new byte[size];
                for (i = 0; i < length; ++i) {
                    if (i > 0 && cells[i - 1][0] == cells[i][0]) {
                        ret[(int)cells[i][1]] = ret[(int)cells[i - 1][1]];
                        continue;
                    }
                    if (cells[i][0] >= 0L) {
                        bufferOffset = this.getBytes(afile, buffer, bufferOffset, cells[i][0] * (long)size, b);
                        ByteBuffer bb = ByteBuffer.wrap(b);
                        if (this.byteorderLSB.booleanValue()) {
                            bb.order(ByteOrder.LITTLE_ENDIAN);
                        }
                        ret[(int)cells[i][1]] = bb.getFloat();
                        continue;
                    }
                    ret[(int)cells[i][1]] = Float.NaN;
                }
            } else if (this.datatype.equalsIgnoreCase("DOUBLE")) {
                size = 8;
                b = new byte[8];
                for (i = 0; i < length; ++i) {
                    if (i > 0 && cells[i - 1][0] == cells[i][0]) {
                        ret[(int)cells[i][1]] = ret[(int)cells[i - 1][1]];
                        continue;
                    }
                    if (cells[i][0] >= 0L) {
                        this.getBytes(afile, buffer, bufferOffset, cells[i][0] * (long)size, b);
                        ByteBuffer bb = ByteBuffer.wrap(b);
                        if (this.byteorderLSB.booleanValue()) {
                            bb.order(ByteOrder.LITTLE_ENDIAN);
                        }
                        ret[(int)cells[i][1]] = (float)bb.getDouble();
                        continue;
                    }
                    ret[(int)cells[i][1]] = Float.NaN;
                }
            } else {
                this.logger.error((Object)("datatype not supported in Grid.getValues: " + this.datatype));
                for (i = 0; i < length; ++i) {
                    ret[i] = Float.NaN;
                }
            }
            for (i = 0; i < length; ++i) {
                if (ret[i] == (float)this.nodatavalue) {
                    ret[i] = Float.NaN;
                    continue;
                }
                int n = i;
                ret[n] = ret[n] * this.rescale;
            }
            float[] fArray = ret;
            return fArray;
        }
        catch (Exception e) {
            this.logger.error((Object)"error getting grid file values", (Throwable)e);
        }
        finally {
            if (afile != null) {
                try {
                    afile.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    private float[] getValuesSubgrids(double[][] points, int bufferSize) {
        int i;
        int[] subgrid = new int[points.length];
        int[] subgridCounts = new int[this.subgrids.size()];
        int anySubgrid = -1;
        block0: for (int i2 = 0; i2 < points.length; ++i2) {
            subgrid[i2] = -1;
            for (int j = 0; j < this.subgrids.size(); ++j) {
                Grid g = this.subgrids.get(j);
                if (!(g.xmin <= points[i2][0]) || !(g.xmax >= points[i2][0]) || !(g.ymin <= points[i2][1]) || !(g.ymax >= points[i2][1])) continue;
                subgrid[i2] = j;
                int n = j;
                subgridCounts[n] = subgridCounts[n] + 1;
                anySubgrid = j;
                continue block0;
            }
        }
        if (anySubgrid >= 0 && subgridCounts[anySubgrid] == points.length) {
            return this.subgrids.get(anySubgrid).getValues3(points, bufferSize);
        }
        float[] values = new float[points.length];
        for (i = 0; i < values.length; ++i) {
            values[i] = Float.NaN;
        }
        if (anySubgrid == -1) {
            return values;
        }
        for (i = 0; i < subgridCounts.length; ++i) {
            if (subgridCounts[i] <= 0) continue;
            double[][] newpoints = new double[subgridCounts[i]][2];
            int p = 0;
            for (int j = 0; j < points.length; ++j) {
                if (subgrid[j] != i) continue;
                newpoints[p] = points[j];
                ++p;
            }
            float[] subValues = this.subgrids.get(i).getValues3(newpoints, bufferSize);
            p = 0;
            for (int j = 0; j < points.length; ++j) {
                if (subgrid[j] != i) continue;
                values[j] = subValues[p];
                ++p;
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeMissingValues(Grid sourceOfMissingValues, boolean hideMissing) {
        float[] cells = sourceOfMissingValues.getGrid();
        float[] actual = this.getGrid();
        int length = actual.length;
        RandomAccessFile afile = null;
        File f2 = new File(this.filename + ".GRI");
        try {
            afile = !f2.exists() ? new RandomAccessFile(this.filename + ".gri", "rw") : new RandomAccessFile(this.filename + ".GRI", "rw");
            byte[] b = new byte[(int)afile.length()];
            ByteBuffer bb = ByteBuffer.wrap(b);
            if (this.byteorderLSB.booleanValue()) {
                bb.order(ByteOrder.LITTLE_ENDIAN);
            }
            afile.seek(0L);
            if (this.datatype.equalsIgnoreCase("UBYTE")) {
                for (int i = 0; i < length; ++i) {
                    if (hideMissing == Float.isNaN(cells[i])) {
                        if (this.nodatavalue >= 128.0) {
                            bb.put((byte)(this.nodatavalue - 256.0));
                            continue;
                        }
                        bb.put((byte)this.nodatavalue);
                        continue;
                    }
                    if (actual[i] >= 128.0f) {
                        bb.put((byte)(actual[i] - 256.0f));
                        continue;
                    }
                    bb.put((byte)actual[i]);
                }
            } else if (this.datatype.equalsIgnoreCase("BYTE")) {
                for (int i = 0; i < length; ++i) {
                    bb.put((byte)actual[i]);
                }
            } else if (this.datatype.equalsIgnoreCase("SHORT")) {
                for (int i = 0; i < length; ++i) {
                    if (hideMissing == Float.isNaN(cells[i])) {
                        bb.putShort((short)this.nodatavalue);
                        continue;
                    }
                    bb.putShort((short)actual[i]);
                }
            } else if (this.datatype.equalsIgnoreCase("INT")) {
                for (int i = 0; i < length; ++i) {
                    if (hideMissing == Float.isNaN(cells[i])) {
                        bb.putInt((int)this.nodatavalue);
                        continue;
                    }
                    bb.putInt((int)actual[i]);
                }
            } else if (this.datatype.equalsIgnoreCase("LONG")) {
                for (int i = 0; i < length; ++i) {
                    if (hideMissing == Float.isNaN(cells[i])) {
                        bb.putLong((long)this.nodatavalue);
                        continue;
                    }
                    bb.putLong((long)actual[i]);
                }
            } else if (this.datatype.equalsIgnoreCase("FLOAT")) {
                for (int i = 0; i < length; ++i) {
                    if (hideMissing == Float.isNaN(cells[i])) {
                        bb.putFloat((float)this.nodatavalue);
                        continue;
                    }
                    bb.putFloat(actual[i]);
                }
            } else if (this.datatype.equalsIgnoreCase("DOUBLE")) {
                for (int i = 0; i < length; ++i) {
                    if (hideMissing == Float.isNaN(cells[i])) {
                        bb.putDouble(this.nodatavalue);
                        continue;
                    }
                    bb.putDouble(actual[i]);
                }
            } else {
                this.logger.error((Object)("unsupported grid data type: " + this.datatype));
            }
            afile.write(bb.array());
        }
        catch (Exception e) {
            this.logger.error((Object)"error getting grid file values", (Throwable)e);
        }
        finally {
            if (afile != null) {
                try {
                    afile.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private byte getByte(RandomAccessFile raf, byte[] buffer, Long bufferOffset, long seekTo) throws IOException {
        long relativePos = seekTo - bufferOffset;
        if (relativePos < 0L) {
            raf.seek(seekTo);
            bufferOffset = seekTo;
            raf.read(buffer);
            return buffer[0];
        }
        if (relativePos >= 0L && relativePos < (long)buffer.length) {
            return buffer[(int)relativePos];
        }
        if (relativePos - (long)buffer.length < (long)buffer.length) {
            bufferOffset = bufferOffset + (long)buffer.length;
            raf.read(buffer);
            return buffer[(int)(relativePos - (long)buffer.length)];
        }
        raf.seek(seekTo);
        bufferOffset = seekTo;
        raf.read(buffer);
        return buffer[0];
    }

    private Long getBytes(RandomAccessFile raf, byte[] buffer, Long bufferOffset, long seekTo, byte[] dest) throws IOException {
        long relativePos = seekTo - bufferOffset;
        if (relativePos < 0L) {
            if (seekTo < 0L) {
                seekTo = 0L;
            }
            raf.seek(seekTo);
            bufferOffset = seekTo;
            raf.read(buffer);
            System.arraycopy(buffer, 0, dest, 0, dest.length);
        } else if (relativePos >= 0L && relativePos < (long)buffer.length) {
            System.arraycopy(buffer, (int)relativePos, dest, 0, dest.length);
        } else if (relativePos - (long)buffer.length < (long)buffer.length) {
            bufferOffset = bufferOffset + (long)buffer.length;
            raf.read(buffer);
            int offset = (int)(relativePos - (long)buffer.length);
            System.arraycopy(buffer, offset, dest, 0, dest.length);
        } else {
            raf.seek(seekTo);
            bufferOffset = seekTo;
            raf.read(buffer);
            System.arraycopy(buffer, 0, dest, 0, dest.length);
        }
        return bufferOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] calculatetMinMax() {
        float[] ret = new float[]{Float.MAX_VALUE, -3.4028235E38f};
        RandomAccessFile afile = null;
        try {
            File f2 = new File(this.filename + ".GRI");
            afile = !f2.exists() ? new RandomAccessFile(this.filename + ".gri", "r") : new RandomAccessFile(this.filename + ".GRI", "r");
            long length = (long)this.nrows * (long)this.ncols;
            if (this.datatype.equalsIgnoreCase("BYTE")) {
                int size = 1;
                byte[] b = new byte[size];
                for (long i = 0L; i < length; ++i) {
                    float f = afile.readByte();
                    if (f == (float)this.nodatavalue) continue;
                    ret[0] = Math.min(f * this.rescale, ret[0]);
                    ret[1] = Math.max(f * this.rescale, ret[1]);
                }
            } else if (this.datatype.equalsIgnoreCase("UBYTE")) {
                int size = 1;
                byte[] b = new byte[size];
                for (long i = 0L; i < length; ++i) {
                    float f = afile.readByte();
                    if (f < 0.0f) {
                        f += 256.0f;
                    }
                    if (f == (float)this.nodatavalue) continue;
                    ret[0] = Math.min(f * this.rescale, ret[0]);
                    ret[1] = Math.max(f * this.rescale, ret[1]);
                }
            } else if (this.datatype.equalsIgnoreCase("SHORT")) {
                int size = 2;
                byte[] b = new byte[size];
                for (long i = 0L; i < length; ++i) {
                    afile.read(b);
                    float f = this.byteorderLSB != false ? (float)((short)((0xFF & b[1]) << 8 | b[0] & 0xFF)) : (float)((short)((0xFF & b[0]) << 8 | b[1] & 0xFF));
                    if (f == (float)this.nodatavalue) continue;
                    ret[0] = Math.min(f * this.rescale, ret[0]);
                    ret[1] = Math.max(f * this.rescale, ret[1]);
                }
            } else if (this.datatype.equalsIgnoreCase("INT")) {
                int size = 4;
                byte[] b = new byte[size];
                for (long i = 0L; i < length; ++i) {
                    afile.read(b);
                    float f = this.byteorderLSB != false ? (float)((0xFF & b[3]) << 24 | ((0xFF & b[2]) << 16) + ((0xFF & b[1]) << 8) + (b[0] & 0xFF)) : (float)((0xFF & b[0]) << 24 | ((0xFF & b[1]) << 16) + ((0xFF & b[2]) << 8) + (0xFF & b[3] & 0xFF));
                    if (f == (float)this.nodatavalue) continue;
                    ret[0] = Math.min(f * this.rescale, ret[0]);
                    ret[1] = Math.max(f * this.rescale, ret[1]);
                }
            } else if (this.datatype.equalsIgnoreCase("LONG")) {
                int size = 8;
                byte[] b = new byte[size];
                for (long i = 0L; i < length; ++i) {
                    afile.read(b);
                    float f = this.byteorderLSB != false ? (float)(((long)(0xFF & b[7]) << 56) + ((long)(0xFF & b[6]) << 48) + ((long)(0xFF & b[5]) << 40) + ((long)(0xFF & b[4]) << 32) + ((long)(0xFF & b[3]) << 24) + ((long)(0xFF & b[2]) << 16) + ((long)(0xFF & b[1]) << 8) + (long)(0xFF & b[0])) : (float)(((long)(0xFF & b[0]) << 56) + ((long)(0xFF & b[1]) << 48) + ((long)(0xFF & b[2]) << 40) + ((long)(0xFF & b[3]) << 32) + ((long)(0xFF & b[4]) << 24) + ((long)(0xFF & b[5]) << 16) + ((long)(0xFF & b[6]) << 8) + (long)(0xFF & b[7]));
                    if (f == (float)this.nodatavalue) continue;
                    ret[0] = Math.min(f * this.rescale, ret[0]);
                    ret[1] = Math.max(f * this.rescale, ret[1]);
                }
            } else if (this.datatype.equalsIgnoreCase("FLOAT")) {
                int size = 4;
                byte[] b = new byte[size];
                for (long i = 0L; i < length; ++i) {
                    float f;
                    afile.read(b);
                    ByteBuffer bb = ByteBuffer.wrap(b);
                    if (this.byteorderLSB.booleanValue()) {
                        bb.order(ByteOrder.LITTLE_ENDIAN);
                    }
                    if ((f = bb.getFloat()) == (float)this.nodatavalue) continue;
                    ret[0] = Math.min(f * this.rescale, ret[0]);
                    ret[1] = Math.max(f * this.rescale, ret[1]);
                }
            } else if (this.datatype.equalsIgnoreCase("DOUBLE")) {
                int size = 8;
                byte[] b = new byte[8];
                for (long i = 0L; i < length; ++i) {
                    float f;
                    afile.read(b);
                    ByteBuffer bb = ByteBuffer.wrap(b);
                    if (this.byteorderLSB.booleanValue()) {
                        bb.order(ByteOrder.LITTLE_ENDIAN);
                    }
                    if ((f = (float)bb.getDouble()) == (float)this.nodatavalue) continue;
                    ret[0] = Math.min(f * this.rescale, ret[0]);
                    ret[1] = Math.max(f * this.rescale, ret[1]);
                }
            } else {
                this.logger.error((Object)("datatype not supported in Grid.getValues: " + this.datatype));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"error calculating min/max of a grid file", (Throwable)e);
        }
        finally {
            if (afile != null) {
                try {
                    afile.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return ret;
    }
}

