/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.intersect;

import au.org.ala.layers.intersect.DBFHeader;
import au.org.ala.layers.intersect.DBFRecords;
import java.io.Serializable;
import java.util.TreeSet;

class DBF
implements Serializable {
    static final long serialVersionUID = -1631837349804567374L;
    DBFHeader dbfheader;
    DBFRecords dbfrecords;
    boolean singleColumn;

    public DBF(String filename) {
        this.singleColumn = false;
        this.dbfheader = new DBFHeader(filename);
        this.dbfrecords = new DBFRecords(filename, this.dbfheader);
    }

    DBF(String filename, String column) {
        this.singleColumn = true;
        this.dbfheader = new DBFHeader(filename);
        String[] columns = column.split(",");
        int[] idx = new int[columns.length];
        for (int i = 0; i < idx.length; ++i) {
            idx[i] = this.dbfheader.getColumnIdx(columns[i]);
        }
        this.dbfrecords = new DBFRecords(filename, this.dbfheader, idx, true);
    }

    DBF(String filename, String[] columns) {
        this.singleColumn = false;
        this.dbfheader = new DBFHeader(filename);
        int[] idx = new int[columns.length];
        for (int i = 0; i < idx.length; ++i) {
            idx[i] = this.dbfheader.getColumnIdx(columns[i]);
        }
        this.dbfrecords = new DBFRecords(filename, this.dbfheader, idx, false);
    }

    public int getColumnIdx(String column_name) {
        return this.dbfheader.getColumnIdx(column_name);
    }

    public String[] getColumnNames() {
        return this.dbfheader.getColumnNames();
    }

    public String getValue(int row, int column) {
        if (this.singleColumn) {
            return this.dbfrecords.getValue(row, 0);
        }
        return this.dbfrecords.getValue(row, column);
    }

    public String[] getColumnLookup(int column) {
        TreeSet<String> ts = new TreeSet<String>();
        int len = this.dbfheader.getNumberOfRecords();
        for (int i = 0; i < len; ++i) {
            ts.add(this.getValue(i, column));
        }
        String[] sa = new String[ts.size()];
        ts.toArray(sa);
        return sa;
    }

    public String[] getColumnMultipleValues(int column) {
        TreeSet<String> ts = new TreeSet<String>();
        TreeSet<String> dup = new TreeSet<String>();
        int len = this.dbfheader.getNumberOfRecords();
        for (int i = 0; i < len; ++i) {
            String v = this.getValue(i, column);
            if (ts.contains(v)) {
                dup.add(v);
                continue;
            }
            ts.add(v);
        }
        String[] sa = new String[dup.size()];
        dup.toArray(sa);
        return sa;
    }
}

