/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.grid;

import au.org.ala.layers.dto.GridClass;
import au.org.ala.layers.grid.Envelope;
import au.org.ala.layers.intersect.Grid;
import au.org.ala.layers.util.SpatialUtil;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.kml.KML;
import org.geotools.kml.KMLConfiguration;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GridClassBuilder {
    public static final int[] colours = new int[]{0x3366CC, 14432530, 0xFF9900, 1087000, 0x990099, 39366, 0xDD4477, 0x66AA00, 12070446, 3236757, 0x994499, 0x22AA99, 0xAAAA11, 0x6633CC, 15102720, 9111303, 6623335, 3314274, 5600422, 3882668, 12022562, 1496608, 12129155, 16004510, 10246453, 11125779, 2783117, 6720796, 12493843, 809250, 7615505};
    private static final Logger logger = Logger.getLogger(GridClassBuilder.class);

    public static void main(String[] args) {
        logger.info((Object)"args[0]=diva grid input file (do not include .grd or .gri)\n\n");
        if (args.length > 0) {
            try {
                File f = new File(args[0] + ".classes.json");
                if (f.exists()) {
                    f.delete();
                }
                if ((f = new File(args[0])).exists() && f.isDirectory()) {
                    File[] fs = f.listFiles();
                    for (int i = 0; i < fs.length; ++i) {
                        if (!fs[i].isFile()) continue;
                        fs[i].delete();
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                GridClassBuilder.buildFromGrid(args[0]);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<Integer, GridClass> buildFromGrid(String filePath) throws IOException {
        Set klist;
        File wktDir = new File(filePath);
        wktDir.mkdirs();
        int[] wktMap = null;
        ArrayList<Integer> maxValues = new ArrayList<Integer>();
        ArrayList<String> labels = new ArrayList<String>();
        HashMap<Integer, GridClass> classes = new HashMap<Integer, GridClass>();
        Properties p = new Properties();
        p.load(new FileReader(filePath + ".txt"));
        boolean mergeProperties = false;
        HashMap groupedKeys = new HashMap();
        HashMap<Integer, Integer> translateKeys = new HashMap<Integer, Integer>();
        HashMap<Object, Integer> translateValues = new HashMap<Object, Integer>();
        ArrayList<Integer> keys = new ArrayList<Integer>();
        for (String key : p.stringPropertyNames()) {
            try {
                int k = Integer.parseInt(key);
                keys.add(k);
                String value = p.getProperty(key);
                klist = (HashSet<Integer>)groupedKeys.get(value);
                if (klist == null) {
                    klist = new HashSet<Integer>();
                } else {
                    mergeProperties = true;
                }
                klist.add(k);
                groupedKeys.put(value, klist);
                if (!translateValues.containsKey(value)) {
                    translateValues.put(value, translateValues.size() + 1);
                }
                translateKeys.put(k, (Integer)translateValues.get(value));
            }
            catch (NumberFormatException e) {
                logger.info((Object)("Excluding shape key '" + key + "'"));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        Collections.sort(keys);
        Grid g = new Grid(filePath);
        boolean generateWkt = false;
        if (mergeProperties) {
            g.replaceValues(translateKeys);
            if (!new File(filePath + ".txt.old").exists()) {
                FileUtils.moveFile((File)new File(filePath + ".txt"), (File)new File(filePath + ".txt.old"));
            }
            StringBuilder sb = new StringBuilder();
            for (String value : translateValues.keySet()) {
                sb.append(translateValues.get(value)).append("=").append(value).append('\n');
            }
            FileUtils.writeStringToFile((File)new File(filePath + ".txt"), (String)sb.toString());
            return GridClassBuilder.buildFromGrid(filePath);
        }
        if (generateWkt) {
            for (String name : groupedKeys.keySet()) {
                try {
                    klist = (Set)groupedKeys.get(name);
                    String key = ((Integer)klist.iterator().next()).toString();
                    int k = Integer.parseInt(key);
                    GridClass gc = new GridClass();
                    gc.setName(name);
                    gc.setId(k);
                    if (klist.size() == 1) {
                        klist = null;
                    }
                    logger.info((Object)("getting wkt for " + filePath + " > " + key));
                    Map wktIndexed = Envelope.getGridSingleLayerEnvelopeAsWktIndexed(filePath + "," + key + "," + key, klist, wktMap);
                    File zipFile = new File(filePath + File.separator + key + ".wkt.zip");
                    ZipOutputStream zos = null;
                    try {
                        zos = new ZipOutputStream(new FileOutputStream(zipFile));
                        zos.putNextEntry(new ZipEntry(key + ".wkt"));
                        zos.write(((String)wktIndexed.get("wkt")).getBytes());
                        zos.flush();
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    finally {
                        if (zos != null) {
                            try {
                                zos.close();
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    FilterOutputStream bos = null;
                    try {
                        bos = new BufferedOutputStream(new FileOutputStream(filePath + File.separator + key + ".wkt"));
                        bos.write(((String)wktIndexed.get("wkt")).getBytes());
                        ((BufferedOutputStream)bos).flush();
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    finally {
                        if (bos != null) {
                            try {
                                bos.close();
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    logger.info((Object)"wkt written to file");
                    gc.setArea_km(SpatialUtil.calculateArea((String)wktIndexed.get("wkt")) / 1000.0 / 1000.0);
                    wktMap = (int[])wktIndexed.get("map");
                    OutputStreamWriter fw = null;
                    try {
                        fw = new FileWriter(filePath + File.separator + key + ".wkt.index");
                        fw.append((String)wktIndexed.get("index"));
                        fw.flush();
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    finally {
                        if (fw != null) {
                            try {
                                fw.close();
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    int minPolygonNumber = 0;
                    int maxPolygonNumber = 0;
                    RandomAccessFile raf = null;
                    try {
                        raf = new RandomAccessFile(filePath + File.separator + key + ".wkt.index.dat", "rw");
                        String[] index = ((String)wktIndexed.get("index")).split("\n");
                        for (int i = 0; i < index.length; ++i) {
                            if (index[i].length() <= 1) continue;
                            String[] cells = index[i].split(",");
                            int polygonNumber = Integer.parseInt(cells[0]);
                            raf.writeInt(polygonNumber);
                            int polygonStart = Integer.parseInt(cells[1]);
                            raf.writeInt(polygonStart);
                            if (i == 0) {
                                minPolygonNumber = polygonNumber;
                                continue;
                            }
                            if (i != index.length - 1) continue;
                            maxPolygonNumber = polygonNumber;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    finally {
                        if (raf != null) {
                            try {
                                raf.close();
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    maxValues.add(gc.getMaxShapeIdx());
                    labels.add(name.replace("\"", "'"));
                    gc.setMinShapeIdx(minPolygonNumber);
                    gc.setMaxShapeIdx(maxPolygonNumber);
                    logger.info((Object)("getting multipolygon for " + filePath + " > " + key));
                    MultiPolygon mp = Envelope.getGridEnvelopeAsMultiPolygon(filePath + "," + key + "," + key);
                    gc.setBbox(mp.getEnvelope().toText().replace(" (", "(").replace(", ", ","));
                    classes.put(k, gc);
                    try {
                        zos = null;
                        try {
                            zos = new ZipOutputStream(new FileOutputStream(filePath + File.separator + key + ".kml.zip"));
                            zos.putNextEntry(new ZipEntry(key + ".kml"));
                            Encoder encoder = new Encoder((Configuration)new KMLConfiguration());
                            encoder.setIndenting(true);
                            encoder.encode((Object)mp, KML.Geometry, (OutputStream)zos);
                            zos.flush();
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                        finally {
                            if (zos != null) {
                                try {
                                    zos.close();
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                        logger.info((Object)"kml written to file");
                        SimpleFeatureType TYPE = DataUtilities.createType((String)"class", (String)"the_geom:MultiPolygon,id:Integer,name:String");
                        FeatureJSON fjson = new FeatureJSON();
                        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(TYPE);
                        SimpleFeature sf = featureBuilder.buildFeature(null);
                        zos = null;
                        try {
                            zos = new ZipOutputStream(new FileOutputStream(filePath + File.separator + key + ".geojson.zip"));
                            zos.putNextEntry(new ZipEntry(key + ".geojson"));
                            featureBuilder.add((Object)mp);
                            featureBuilder.add((Object)k);
                            featureBuilder.add((Object)name);
                            fjson.writeFeature(sf, (OutputStream)zos);
                            zos.flush();
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                        finally {
                            if (zos != null) {
                                try {
                                    zos.close();
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                        logger.info((Object)"geojson written to file");
                        File newFile = new File(filePath + File.separator + key + ".shp");
                        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
                        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                        params.put("url", newFile.toURI().toURL());
                        params.put("create spatial index", Boolean.FALSE);
                        ShapefileDataStore newDataStore = null;
                        try {
                            newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
                            newDataStore.createSchema(TYPE);
                            newDataStore.forceSchemaCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                            DefaultTransaction transaction = new DefaultTransaction("create");
                            String typeName = newDataStore.getTypeNames()[0];
                            ContentFeatureSource featureSource = newDataStore.getFeatureSource(typeName);
                            SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
                            featureStore.setTransaction((Transaction)transaction);
                            ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
                            DefaultFeatureCollection collection = new DefaultFeatureCollection();
                            collection.addAll(features);
                            featureStore.setTransaction((Transaction)transaction);
                            features.add(sf);
                            featureStore.addFeatures((FeatureCollection)collection);
                            transaction.commit();
                            transaction.close();
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                        finally {
                            if (newDataStore != null) {
                                try {
                                    newDataStore.dispose();
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                        zos = null;
                        try {
                            String[] exts;
                            zos = new ZipOutputStream(new FileOutputStream(filePath + File.separator + key + ".shp.zip"));
                            for (String ext : exts = new String[]{".dbf", ".shp", ".shx", ".prj"}) {
                                zos.putNextEntry(new ZipEntry(key + ext));
                                FileInputStream fis = null;
                                try {
                                    int size;
                                    fis = new FileInputStream(filePath + File.separator + key + ext);
                                    byte[] buffer = new byte[1024];
                                    while ((size = fis.read(buffer)) > 0) {
                                        zos.write(buffer, 0, size);
                                    }
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage(), (Throwable)e);
                                }
                                finally {
                                    if (fis != null) {
                                        try {
                                            fis.close();
                                        }
                                        catch (Exception e) {
                                            logger.error((Object)e.getMessage(), (Throwable)e);
                                        }
                                    }
                                }
                                new File(filePath + File.separator + key + ext).delete();
                            }
                            zos.flush();
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                        finally {
                            if (zos != null) {
                                try {
                                    zos.close();
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                        logger.info((Object)"shape file written to zip");
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            g.writeGrid(filePath + File.separator + "polygons", wktMap, g.xmin, g.ymin, g.xmax, g.ymax, g.xres, g.yres, g.nrows, g.ncols);
            GridClassBuilder.copyHeaderAsInt(filePath + ".grd", filePath + File.separator + "polygons.grd");
        } else {
            int j;
            HashMap<Float, float[]> info = new HashMap<Float, float[]>();
            for (j = 0; j < keys.size(); ++j) {
                info.put(Float.valueOf(((Integer)keys.get(j)).floatValue()), new float[]{0.0f, Float.NaN, Float.NaN, Float.NaN, Float.NaN});
            }
            g.getClassInfo(info);
            for (j = 0; j < keys.size(); ++j) {
                int k = (Integer)keys.get(j);
                String key = String.valueOf(k);
                String name = p.getProperty(key);
                GridClass gc = new GridClass();
                gc.setName(name);
                gc.setId(k);
                maxValues.add(Integer.valueOf(key));
                labels.add(name.replace("\"", "'"));
                gc.setMinShapeIdx(Integer.valueOf(key));
                gc.setMaxShapeIdx(Integer.valueOf(key));
                float[] stats = (float[])info.get(Float.valueOf(((Integer)keys.get(j)).floatValue()));
                if (!(stats[0] > 0.0f)) continue;
                gc.setBbox("POLYGON((" + stats[1] + " " + stats[2] + "," + stats[1] + " " + stats[4] + "," + stats[3] + " " + stats[4] + "," + stats[3] + " " + stats[2] + "," + stats[1] + " " + stats[2] + "))");
                gc.setArea_km(Double.valueOf(stats[0]));
                classes.put(k, gc);
            }
        }
        GridClassBuilder.exportSLD(filePath + File.separator + "polygons.sld", new File(filePath + ".txt").getName(), maxValues, labels);
        GridClassBuilder.writeProjectionFile(filePath + File.separator + "polygons.prj");
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue(new File(filePath + ".classes.json"), classes);
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void exportSLD(String filename, String name, ArrayList<Integer> maxValues, ArrayList<String> labels) {
        StringBuffer sld = new StringBuffer();
        sld.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sld.append("<sld:StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\" xmlns:sld=\"http://www.opengis.net/sld\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:gml=\"http://www.opengis.net/gml\" version=\"1.0.0\">");
        sld.append("<sld:NamedLayer>");
        sld.append("<sld:Name>raster</sld:Name>");
        sld.append(" <sld:UserStyle>");
        sld.append("<sld:Name>raster</sld:Name>");
        sld.append("<sld:Title>A very simple color map</sld:Title>");
        sld.append("<sld:Abstract>A very basic color map</sld:Abstract>");
        sld.append("<sld:FeatureTypeStyle>");
        sld.append(" <sld:Name>name</sld:Name>");
        sld.append("<sld:FeatureTypeName>Feature</sld:FeatureTypeName>");
        sld.append(" <sld:Rule>");
        sld.append("   <sld:RasterSymbolizer>");
        sld.append(" <sld:Geometry>");
        sld.append(" <ogc:PropertyName>geom</ogc:PropertyName>");
        sld.append(" </sld:Geometry>");
        sld.append(" <sld:ChannelSelection>");
        sld.append(" <sld:GrayChannel>");
        sld.append("   <sld:SourceChannelName>1</sld:SourceChannelName>");
        sld.append(" </sld:GrayChannel>");
        sld.append(" </sld:ChannelSelection>");
        sld.append(" <sld:ColorMap type=\"intervals\">");
        ArrayList<String> sortedLabels = new ArrayList<String>(labels);
        Collections.sort(sortedLabels);
        sld.append("\n<sld:ColorMapEntry color=\"#ffffff\" opacity=\"0\" quantity=\"1\"/>\n");
        for (int j = 0; j < sortedLabels.size(); ++j) {
            int i;
            for (i = 0; i < labels.size() && !labels.get(i).equals(sortedLabels.get(j)); ++i) {
            }
            sld.append("<sld:ColorMapEntry color=\"#" + GridClassBuilder.getHexColour(colours[i % colours.length]) + "\" quantity=\"" + (maxValues.get(i) + 1) + ".0\" label=\"" + labels.get(i) + "\" opacity=\"1\"/>\r\n");
        }
        sld.append("</sld:ColorMap></sld:RasterSymbolizer></sld:Rule></sld:FeatureTypeStyle></sld:UserStyle></sld:NamedLayer></sld:StyledLayerDescriptor>");
        FileWriter fw = null;
        try {
            fw = new FileWriter(filename);
            fw.append(sld.toString());
            fw.flush();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    static String getHexColour(int colour) {
        String s = Integer.toHexString(colour);
        while (s.length() > 6) {
            s = s.substring(1);
        }
        while (s.length() < 6) {
            s = "0" + s;
        }
        return s;
    }

    private static void writeProjectionFile(String filename) {
        FileWriter spWriter = null;
        try {
            spWriter = new FileWriter(filename);
            StringBuffer sbProjection = new StringBuffer();
            sbProjection.append("GEOGCS[\"WGS 84\", ").append("\n");
            sbProjection.append("    DATUM[\"WGS_1984\", ").append("\n");
            sbProjection.append("        SPHEROID[\"WGS 84\",6378137,298.257223563, ").append("\n");
            sbProjection.append("            AUTHORITY[\"EPSG\",\"7030\"]], ").append("\n");
            sbProjection.append("        AUTHORITY[\"EPSG\",\"6326\"]], ").append("\n");
            sbProjection.append("    PRIMEM[\"Greenwich\",0, ").append("\n");
            sbProjection.append("        AUTHORITY[\"EPSG\",\"8901\"]], ").append("\n");
            sbProjection.append("    UNIT[\"degree\",0.01745329251994328, ").append("\n");
            sbProjection.append("        AUTHORITY[\"EPSG\",\"9122\"]], ").append("\n");
            sbProjection.append("    AUTHORITY[\"EPSG\",\"4326\"]] ").append("\n");
            spWriter.append(sbProjection.toString());
            spWriter.flush();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (spWriter != null) {
                try {
                    spWriter.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyHeaderAsInt(String src, String dst) {
        BufferedReader br = null;
        OutputStreamWriter fw = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(src));
            fw = new FileWriter(dst);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("DataType=")) {
                    fw.write("DataType=INT\n");
                    continue;
                }
                fw.write(line);
                fw.write("\n");
            }
            fw.flush();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

