/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.dao;

import au.org.ala.layers.dao.LayerIntersectDAO;
import au.org.ala.layers.dao.UserDataDAO;
import au.org.ala.layers.dto.IntersectionFile;
import au.org.ala.layers.dto.Ud_header;
import au.org.ala.layers.intersect.SimpleRegion;
import au.org.ala.layers.intersect.SimpleShapeFile;
import au.org.ala.layers.legend.Facet;
import au.org.ala.layers.legend.QueryField;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service(value="userDataDao")
public class UserDataDAOImpl
implements UserDataDAO {
    private static final Logger logger = Logger.getLogger(UserDataDAOImpl.class);
    private JdbcTemplate jdbcTemplate;
    @Resource(name="layerIntersectDao")
    private LayerIntersectDAO layerIntersectDao;

    @Resource(name="dataSource")
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public Ud_header put(String user_id, String record_type, String description, String metadata, String data_path, String analysis_id) {
        String sql_insert = "INSERT INTO ud_header (user_id,record_type,description,metadata,data_path,analysis_id,upload_dt)  VALUES (?,?,?,?,?,?,?);";
        Date upload_dt = new Date(System.currentTimeMillis());
        int rows = this.jdbcTemplate.update(sql_insert, new Object[]{user_id, record_type, description, metadata, data_path, analysis_id, upload_dt});
        if (rows > 0) {
            String sql_select = "SELECT * FROM ud_header WHERE user_id = ? AND upload_dt = ?";
            Ud_header ud_header = (Ud_header)this.jdbcTemplate.queryForObject(sql_select, (RowMapper)new BeanPropertyRowMapper(Ud_header.class), new Object[]{user_id, upload_dt});
            return ud_header;
        }
        return null;
    }

    @Override
    public Ud_header get(Long ud_header_id) {
        String sql_select = "SELECT * FROM ud_header WHERE ud_header_id = ? ;";
        Ud_header ud_header = (Ud_header)this.jdbcTemplate.queryForObject(sql_select, (RowMapper)new BeanPropertyRowMapper(Ud_header.class), new Object[]{ud_header_id});
        return ud_header;
    }

    @Override
    public String[] getStringArray(String header_id, String ref) {
        try {
            return (String[])this.get(header_id, ref, "StringArray");
        }
        catch (Exception e) {
            logger.error((Object)"failed to get StringArray", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean[] getBooleanArray(String header_id, String ref) {
        try {
            return (boolean[])this.get(header_id, ref, "BooleanArray");
        }
        catch (Exception e) {
            logger.error((Object)"failed to get BooleanArray", (Throwable)e);
            return null;
        }
    }

    @Override
    public double[][] getDoublesArray(String header_id, String ref) {
        try {
            return (double[][])this.get(header_id, ref, "DoublesArray");
        }
        catch (Exception e) {
            logger.error((Object)"failed to get DoublesArray", (Throwable)e);
            return null;
        }
    }

    Object get(String header_id, String ref, String data_type) {
        Long id = Long.parseLong(header_id.split(":")[0]);
        String facet_id = header_id.contains(":") ? " " + header_id.split(":")[1] : "";
        String sql = "SELECT * FROM ud_data_x WHERE ud_header_id = ? AND ref = ? AND data_type = ?;";
        try {
            Map o = this.jdbcTemplate.queryForMap(sql, new Object[]{id, ref + facet_id, data_type});
            if (o != null) {
                try {
                    ByteArrayInputStream bytes = new ByteArrayInputStream((byte[])o.get("data"));
                    ObjectInputStream obj = new ObjectInputStream(bytes);
                    return obj.readObject();
                }
                catch (Exception e) {
                    logger.error((Object)("failed to get " + data_type + " for " + header_id + ", " + ref), (Throwable)e);
                }
            }
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean setStringArray(String header_id, String ref, String[] data) {
        return this.set(header_id, ref, "StringArray", data);
    }

    @Override
    public boolean setBooleanArray(String header_id, String ref, boolean[] data) {
        return this.set(header_id, ref, "BooleanArray", data);
    }

    @Override
    public boolean setDoublesArray(String header_id, String ref, double[][] data) {
        return this.set(header_id, ref, "DoublesArray", data);
    }

    private boolean set(String header_id, String ref, String data_type, Object o) {
        Long id = Long.parseLong(header_id.split(":")[0]);
        String facet_id = header_id.contains(":") ? " " + header_id.split(":")[1] : "";
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ObjectOutputStream obj = new ObjectOutputStream(bytes);
            obj.writeObject(o);
            obj.flush();
            try {
                String sql_delete = "DELETE FROM ud_data_x WHERE ud_header_id = ? AND ref = ? AND data_type = ?;";
                int deleted = this.jdbcTemplate.update(sql_delete, new Object[]{id, ref + facet_id, data_type});
                String sql_insert = "INSERT INTO ud_data_x (ud_header_id,ref,data_type, data)  VALUES ( ?, ?, ?, ?);";
                int inserted = this.jdbcTemplate.update(sql_insert, new Object[]{id, ref + facet_id, data_type, bytes.toByteArray()});
                return inserted > 0;
            }
            catch (Exception e) {
                logger.error((Object)("failed to set ud_data_x for " + header_id + ", " + ref), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)("failed to write bytes for: " + header_id + ", " + ref), (Throwable)e);
        }
        return false;
    }

    @Override
    public List<Ud_header> list(String user_id) {
        String sql = "SELECT * FROM Ud_header WHERE user_id = ?";
        List ud_headers = (List)this.jdbcTemplate.queryForObject(sql, (RowMapper)new BeanPropertyRowMapper(Ud_header.class), new Object[]{user_id});
        return ud_headers;
    }

    @Override
    public boolean setDoubleArray(String header_id, String ref, double[] data) {
        return this.set(header_id, ref, "DoubleArray", data);
    }

    @Override
    public boolean setQueryField(String ud_header_id, String ref, QueryField qf) {
        return this.set(ud_header_id, ref, "QueryField", qf);
    }

    @Override
    public double[] getDoubleArray(String header_id, String ref) {
        try {
            if (header_id.contains(":")) {
                boolean[] valid = this.getBooleanArray(header_id.split(":")[0], header_id.split(":")[1]);
                int count_valid = 0;
                for (boolean b : valid) {
                    if (!b) continue;
                    ++count_valid;
                }
                double[] allpoints = (double[])this.get(header_id.split(":")[0], ref, "DoubleArray");
                double[] points = new double[count_valid * 2];
                int pos = 0;
                for (int i = 0; i < allpoints.length; i += 2) {
                    if (!valid[i / 2]) continue;
                    points[pos] = allpoints[i];
                    points[pos + 1] = allpoints[i + 1];
                    pos += 2;
                }
                return points;
            }
            return (double[])this.get(header_id, ref, "DoubleArray");
        }
        catch (Exception e) {
            logger.error((Object)"failed to get DoubleArray", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryField getQueryField(String header_id, String ref) {
        String id = header_id.split(":")[0];
        String facet = header_id.contains(":") ? header_id.split(":")[1] : "";
        QueryField qf = null;
        try {
            qf = (QueryField)this.get(header_id, ref, "QueryField");
        }
        catch (Exception e) {
            logger.error((Object)"failed to get QueryField", (Throwable)e);
        }
        if (qf == null) {
            if (facet.length() > 0) {
                boolean[] valid = this.getBooleanArray(header_id.split(":")[0], header_id.split(":")[1]);
                QueryField qfSource = this.getQueryField(id, ref);
                QueryField qfFacet = new QueryField();
                qfFacet.setDisplayName(qfSource.getDisplayName());
                qfFacet.setName(qfSource.getName());
                try {
                    for (int i = 0; i < valid.length; ++i) {
                        if (!valid[i]) continue;
                        qfFacet.add(qfSource.getAsString(i));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("invalid QueryField for id: " + header_id + " ref: " + ref + " does the ref exist for intersection?"), (Throwable)e);
                }
                qfFacet.store();
                this.setQueryField(header_id, ref, qf);
                return qfFacet;
            }
            double[] flatPoints = this.getDoubleArray(header_id, "points");
            double[][] points = new double[flatPoints.length / 2][2];
            int pos = 0;
            for (int i = 0; i < points.length; ++i) {
                points[pos][0] = flatPoints[i * 2];
                points[pos][1] = flatPoints[i * 2 + 1];
                ++pos;
            }
            ArrayList<String> s = this.layerIntersectDao.sampling(new String[]{ref}, points);
            String[] a = ((String)s.get(0)).split("\n");
            qf = new QueryField(ref);
            for (int i = 0; i < a.length; ++i) {
                qf.add(a[i]);
            }
            qf.store();
            IntersectionFile f = this.layerIntersectDao.getConfig().getIntersectionFile(ref);
            if (f != null) {
                qf.setDisplayName(f.getFieldName());
            }
            this.setQueryField(header_id, ref, qf);
        }
        return qf;
    }

    @Override
    public boolean setMetadata(long header_id, Map data) {
        String sql_insert = "UPDATE ud_header SET metadata = ? WHERE ud_header_id = ? ;";
        Date upload_dt = new Date(System.currentTimeMillis());
        int rows = this.jdbcTemplate.update(sql_insert, new Object[]{JSONObject.fromObject((Object)data).toString(), header_id});
        return rows == 1;
    }

    @Override
    public Map getMetadata(long header_id) {
        ObjectMapper om = new ObjectMapper();
        try {
            return (Map)om.readValue(this.get(header_id).getMetadata(), Map.class);
        }
        catch (IOException e) {
            logger.error((Object)("error getting metadata for header_id: " + header_id), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<String> listData(String ud_header_id, String data_type) {
        List l;
        String sql;
        String facet_id;
        Long id = Long.parseLong(ud_header_id.split(":")[0]);
        String string = facet_id = ud_header_id.contains(":") ? ud_header_id.split(":")[1] : "";
        if (facet_id.length() > 0) {
            sql = "SELECT ref FROM ud_data_x WHERE ud_header_id = ? AND data_type = ? AND ref like ? ;";
            l = this.jdbcTemplate.queryForList(sql, new Object[]{id, data_type, "% " + facet_id});
        } else {
            sql = "SELECT ref FROM ud_data_x WHERE ud_header_id = ? AND data_type = ? AND ref not like '% %' ; ";
            l = this.jdbcTemplate.queryForList(sql, new Object[]{id, data_type});
        }
        ArrayList<String> refs = new ArrayList<String>();
        for (Map m : l) {
            refs.add(((String)m.get("ref")).replace(" " + facet_id, ""));
        }
        return refs;
    }

    @Override
    public Ud_header facet(String id, List<String> new_facets, String new_wkt) {
        SimpleRegion sr = null;
        double[] points = null;
        String ud_header_id = id.split(":")[0];
        String existing_facet = id.contains(":") ? id.split(":")[1] : null;
        ArrayList<Facet> facets = new ArrayList<Facet>();
        for (int i = 0; i < new_facets.size(); ++i) {
            facets.add(Facet.parseFacet(new_facets.get(i)));
        }
        ArrayList facetFields = new ArrayList();
        for (int k = 0; k < facets.size(); ++k) {
            Facet f = (Facet)facets.get(k);
            String[] fields = f.getFields();
            ArrayList<QueryField> qf = new ArrayList<QueryField>();
            for (int j = 0; j < fields.length; ++j) {
                qf.add(this.getQueryField(ud_header_id, fields[j]));
            }
            facetFields.add(qf);
        }
        if (new_wkt != null) {
            sr = SimpleShapeFile.parseWKT(new_wkt);
        }
        points = this.getDoubleArray(ud_header_id, "points");
        boolean[] existing_valid = null;
        if (existing_facet != null) {
            existing_valid = this.getBooleanArray(ud_header_id, existing_facet);
        }
        boolean[] valid = new boolean[points.length / 2];
        int count = 0;
        for (int i = 0; i < valid.length; ++i) {
            int sum = 0;
            for (int j = 0; j < facets.size(); ++j) {
                if (!((Facet)facets.get(j)).isValid((List)facetFields.get(j), i)) continue;
                ++sum;
            }
            boolean valid_sr = sr == null || sr.isWithin(points[i * 2], points[i * 2 + 1]);
            boolean valid_existing = existing_valid == null || existing_valid[i];
            boolean bl = valid[i] = sum == facets.size() && valid_sr && valid_existing;
            if (!valid[i]) continue;
            ++count;
        }
        String next_facet_id = String.valueOf(System.currentTimeMillis());
        this.setBooleanArray(ud_header_id, next_facet_id, valid);
        List<String> refs = this.listData(ud_header_id, "QueryField");
        for (int i = 0; i < refs.size(); ++i) {
            this.getQueryField(ud_header_id + ":" + next_facet_id, refs.get(i));
        }
        Ud_header ret = this.get(Long.valueOf(ud_header_id));
        ret.setFacet_id(next_facet_id);
        String metadata = ret.getMetadata();
        JSONObject jo = JSONObject.fromObject((Object)metadata);
        jo.put((Object)"number_of_records", (Object)count);
        ret.setMetadata(jo.toString());
        return ret;
    }

    @Override
    public String getSampleZip(String id, String fields) {
        int i;
        ArrayList<QueryField> qfs = new ArrayList<QueryField>();
        List<String> in = this.listData(id, "QueryField");
        if (in != null) {
            Collections.sort(in, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1.startsWith("__f") && o2.startsWith("__f")) {
                        int i1 = Integer.MAX_VALUE;
                        int i2 = Integer.MAX_VALUE;
                        try {
                            i1 = Integer.parseInt(o1.substring(3));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            i2 = Integer.parseInt(o2.substring(3));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return i1 - i2;
                    }
                    if (o1.startsWith("__f")) {
                        return -1;
                    }
                    if (o2.startsWith("__f")) {
                        return 1;
                    }
                    return o1.compareTo(o2);
                }
            });
            for (int i2 = 0; i2 < in.size(); ++i2) {
                if (!in.get(i2).startsWith("__f")) continue;
                qfs.add(this.getQueryField(id, in.get(i2)));
            }
        }
        if (fields != null) {
            String[] fs = fields.split(",");
            for (i = 0; i < fs.length; ++i) {
                qfs.add(this.getQueryField(id, fs[i]));
            }
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < qfs.size(); ++i) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(((QueryField)qfs.get(i)).getDisplayName());
        }
        double[] points = this.getDoubleArray(id, "points");
        int size = points.length / 2;
        for (int i3 = 0; i3 < size; ++i3) {
            sb.append("\r\n");
            for (int j = 0; j < qfs.size(); ++j) {
                QueryField q = (QueryField)qfs.get(j);
                String s = "";
                try {
                    s = q.getAsString(i3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (j > 0) {
                    sb.append(",");
                }
                if (s == null) continue;
                sb.append("\"").append(s.replace("\"", "\"\"")).append("\"");
            }
        }
        return sb.toString();
    }
}

