/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.layers.dao;

import au.org.ala.layers.dao.LayerDAO;
import au.org.ala.layers.dto.Layer;
import au.org.ala.layers.util.Util;
import java.sql.Connection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.stereotype.Service;

@Service(value="layerDao")
public class LayerDAOImpl
implements LayerDAO {
    private static final Logger logger = Logger.getLogger(LayerDAOImpl.class);
    private JdbcTemplate jdbcTemplate;
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private SimpleJdbcInsert insertLayer;
    private Connection connection;
    private DataSource dataSource;

    @Resource(name="dataSource")
    public void setDataSource(DataSource dataSource) {
        logger.info((Object)"setting data source in layers-store.layersDao");
        if (dataSource != null) {
            logger.info((Object)"dataSource is NOT null");
            logger.info((Object)dataSource.toString());
        } else {
            logger.info((Object)"dataSource is null");
        }
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate);
        this.insertLayer = new SimpleJdbcInsert(dataSource).withTableName("layers").usingGeneratedKeyColumns(new String[]{"id"});
    }

    @Override
    public List<Layer> getLayers() {
        logger.info((Object)"Getting a list of all enabled layers");
        String sql = "select * from layers where enabled=true";
        List l = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Layer.class));
        Util.updateDisplayPaths(l);
        Util.updateMetadataPaths(l);
        return l;
    }

    @Override
    public Layer getLayerById(int id) {
        return this.getLayerById(id, true);
    }

    @Override
    public Layer getLayerById(int id, boolean enabledLayersOnly) {
        logger.info((Object)("Getting enabled layer info for id = " + id));
        String sql = "select * from layers where id = ? ";
        if (enabledLayersOnly) {
            sql = sql + " and enabled=true";
        }
        List l = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Layer.class), new Object[]{id});
        Util.updateDisplayPaths(l);
        Util.updateMetadataPaths(l);
        if (l.size() > 0) {
            return (Layer)l.get(0);
        }
        return null;
    }

    @Override
    public Layer getLayerByName(String name) {
        return this.getLayerByName(name, true);
    }

    @Override
    public Layer getLayerByName(String name, boolean enabledLayersOnly) {
        logger.info((Object)("Getting enabled layer info for name = " + name));
        String sql = "select * from layers where name = ? ";
        if (enabledLayersOnly) {
            sql = sql + " and enabled=true";
        }
        List l = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Layer.class), new Object[]{name});
        Util.updateDisplayPaths(l);
        Util.updateMetadataPaths(l);
        logger.info((Object)("Searching for " + name + ": Found " + l.size() + " records. "));
        if (l.size() > 0) {
            return (Layer)l.get(0);
        }
        return null;
    }

    @Override
    public Layer getLayerByDisplayName(String name) {
        logger.info((Object)("Getting enabled layer info for name = " + name));
        String sql = "select * from layers where enabled=true and displayname = ?";
        List l = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Layer.class), new Object[]{name});
        Util.updateDisplayPaths(l);
        Util.updateMetadataPaths(l);
        if (l.size() > 0) {
            return (Layer)l.get(0);
        }
        return null;
    }

    @Override
    public List<Layer> getLayersByEnvironment() {
        String type = "Environmental";
        logger.info((Object)"Getting a list of all enabled environmental layers");
        String sql = "select * from layers where enabled=true and type = ?";
        List l = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Layer.class), new Object[]{type});
        Util.updateDisplayPaths(l);
        Util.updateMetadataPaths(l);
        return l;
    }

    @Override
    public List<Layer> getLayersByContextual() {
        String type = "Contextual";
        logger.info((Object)"Getting a list of all enabled Contextual layers");
        String sql = "select * from layers where enabled=true and type = ?";
        List l = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Layer.class), new Object[]{type});
        Util.updateDisplayPaths(l);
        Util.updateMetadataPaths(l);
        return l;
    }

    @Override
    public List<Layer> getLayersByCriteria(String keywords) {
        logger.info((Object)("Getting a list of all enabled layers by criteria: " + keywords));
        String sql = "";
        sql = sql + "select * from layers where ";
        sql = sql + " enabled=true AND ( ";
        sql = sql + "lower(keywords) like ? ";
        sql = sql + " or lower(displayname) like ? ";
        sql = sql + " or lower(name) like ? ";
        sql = sql + " or lower(domain) like ? ";
        sql = sql + ") order by displayname ";
        keywords = "%" + keywords.toLowerCase() + "%";
        List list = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Layer.class), new Object[]{keywords, keywords, keywords, keywords});
        LinkedHashSet setItems = new LinkedHashSet(list);
        list.clear();
        list.addAll(setItems);
        Util.updateDisplayPaths(list);
        Util.updateMetadataPaths(list);
        return list;
    }

    @Override
    public Layer getLayerByIdForAdmin(int id) {
        logger.info((Object)("Getting enabled layer info for id = " + id));
        String sql = "select * from layers where id = ?";
        List l = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Layer.class), new Object[]{id});
        Util.updateDisplayPaths(l);
        Util.updateMetadataPaths(l);
        if (l.size() > 0) {
            return (Layer)l.get(0);
        }
        return null;
    }

    @Override
    public Layer getLayerByNameForAdmin(String name) {
        logger.info((Object)("Getting enabled layer info for name = " + name));
        String sql = "select * from layers where name = ?";
        List l = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Layer.class), new Object[]{name});
        Util.updateDisplayPaths(l);
        Util.updateMetadataPaths(l);
        if (l.size() > 0) {
            return (Layer)l.get(0);
        }
        return null;
    }

    @Override
    public List<Layer> getLayersForAdmin() {
        logger.info((Object)"Getting a list of all layers");
        String sql = "select * from layers";
        List l = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(Layer.class));
        Util.updateDisplayPaths(l);
        Util.updateMetadataPaths(l);
        return l;
    }

    @Override
    public void addLayer(Layer layer) {
        logger.info((Object)("Add new layer metadta for " + layer.getName()));
        Map<String, Object> parameters = layer.toMap();
        parameters.remove("uid");
        parameters.remove("id");
        this.insertLayer.execute(parameters);
        Layer newLayer = this.getLayerByName(layer.getName(), false);
        if (layer.getId() > 0L && this.getLayerById(layer.getId().intValue()) == null) {
            this.jdbcTemplate.update("UPDATE layers SET id=" + layer.getId() + " WHERE id=" + newLayer.getId());
            newLayer = this.getLayerByName(layer.getName(), false);
        }
        layer.setId(newLayer.getId());
    }

    @Override
    public void updateLayer(Layer layer) {
        logger.info((Object)("Updating layer metadata for " + layer.getName()));
        String sql = "update layers set citation_date=:citation_date, classification1=:classification1, classification2=:classification2, datalang=:datalang, description=:description, displayname=:displayname, displaypath=:displaypath, enabled=:enabled, domain=:domain, environmentalvaluemax=:environmentalvaluemax, environmentalvaluemin=:environmentalvaluemin, environmentalvalueunits=:environmentalvalueunits, extents=:extents, keywords=:keywords, licence_link=:licence_link, licence_notes=:licence_notes, licence_level=:licence_level, lookuptablepath=:lookuptablepath, maxlatitude=:maxlatitude, maxlongitude=:maxlongitude, mddatest=:mddatest, mdhrlv=:mdhrlv, metadatapath=:metadatapath, minlatitude=:minlatitude, minlongitude=:minlongitude, name=:name, notes=:notes, path=:path, path_1km=:path_1km, path_250m=:path_250m, path_orig=:path_orig, pid=:pid, respparty_role=:respparty_role, scale=:scale, source=:source, source_link=:source_link, type=:type, uid=:uid where id=:id";
        this.namedParameterJdbcTemplate.update(sql, layer.toMap());
    }

    @Override
    public Connection getConnection() {
        if (this.connection == null) {
            try {
                this.connection = this.dataSource.getConnection();
            }
            catch (Exception e) {
                logger.error((Object)"failed to get datasource connection", (Throwable)e);
            }
        }
        return this.connection;
    }

    @Override
    public void delete(String layerId) {
        this.jdbcTemplate.update("delete from layers where id=" + Integer.parseInt(layerId));
    }
}

