/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.images.util;

import au.org.ala.images.util.ByteSinkFactory;
import com.google.common.io.ByteSink;
import com.google.common.io.MoreFiles;
import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileByteSinkFactory
implements ByteSinkFactory {
    public static final Logger log = LoggerFactory.getLogger(FileByteSinkFactory.class);
    final File parentDir;
    final boolean cleanParentDir;

    public FileByteSinkFactory(File parentDir) {
        this(parentDir, true);
    }

    public FileByteSinkFactory(File parentDir, boolean cleanParentDir) {
        this.parentDir = parentDir;
        this.cleanParentDir = cleanParentDir;
    }

    @Override
    public void prepare() throws IOException {
        if (this.parentDir.exists() && this.cleanParentDir) {
            FileUtils.deleteDirectory((File)this.parentDir);
        }
        this.parentDir.mkdirs();
    }

    @Override
    public ByteSink getByteSinkForNames(String ... names) {
        Path path = Paths.get(this.parentDir.getAbsolutePath(), names);
        File parent = path.getParent().toFile();
        if (!parent.exists() && !parent.mkdirs()) {
            log.error("Unable to create directories for {}", (Object)path);
        }
        return MoreFiles.asByteSink((Path)path, (OpenOption[])new OpenOption[0]);
    }
}

