/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.images.tiling;

import au.org.ala.images.util.ByteSinkFactory;
import com.google.common.io.ByteSink;
import java.io.IOException;

public interface TilerSink {
    public LevelSink getLevelSink(int var1);

    public static class PathBasedTilerSink
    implements TilerSink {
        private final ByteSinkFactory byteSinkFactory;

        public PathBasedTilerSink(ByteSinkFactory byteSinkFactory) throws IOException {
            this.byteSinkFactory = byteSinkFactory;
            this.byteSinkFactory.prepare();
        }

        @Override
        public LevelSink getLevelSink(int level) {
            return new LevelSink(level);
        }

        public class LevelSink
        implements au.org.ala.images.tiling.TilerSink$LevelSink {
            private final int level;

            LevelSink(int level) {
                this.level = level;
            }

            @Override
            public ColumnSink getColumnSink(int col, int stripIndex, int _maxColsPerStrip) {
                return new ColumnSink(col, stripIndex, _maxColsPerStrip);
            }

            public class ColumnSink
            implements au.org.ala.images.tiling.TilerSink$ColumnSink {
                private final int col;
                private final int stripIndex;
                private final int maxColsPerStrip;

                ColumnSink(int col, int stripIndex, int maxColsPerStrip) {
                    this.col = col;
                    this.stripIndex = stripIndex;
                    this.maxColsPerStrip = maxColsPerStrip;
                }

                @Override
                public ByteSink getTileSink(int row) {
                    return PathBasedTilerSink.this.byteSinkFactory.getByteSinkForNames(Integer.toString(LevelSink.this.level), Integer.toString(this.col + this.stripIndex * this.maxColsPerStrip), row + ".png");
                }
            }
        }
    }

    public static interface ColumnSink {
        public ByteSink getTileSink(int var1);
    }

    public static interface LevelSink {
        public ColumnSink getColumnSink(int var1, int var2, int var3);
    }
}

