/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.images.metadata;

import au.org.ala.images.metadata.AbstractMetadataParser;
import au.org.ala.images.metadata.ImageMetadataExtractor;
import au.org.ala.images.metadata.MP3MetadataParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataExtractor {
    public static final Logger log = LoggerFactory.getLogger(MetadataExtractor.class);
    private static List<AbstractMetadataParser> _REGISTRY = new ArrayList<AbstractMetadataParser>();

    private static void register(AbstractMetadataParser parser) {
        _REGISTRY.add(parser);
    }

    public Map<String, String> readMetadata(File file) throws IOException {
        return this.readMetadata(FileUtils.readFileToByteArray((File)file), file.getName());
    }

    public Map<String, String> readMetadata(byte[] bytes, String filename) {
        String contentType;
        HashMap<String, String> map = new HashMap<String, String>();
        if (bytes != null && bytes.length > 0 && StringUtils.isNotEmpty((String)(contentType = this.detectContentType(bytes, filename)))) {
            for (AbstractMetadataParser p : _REGISTRY) {
                Matcher m = p.getContentTypePattern().matcher(contentType);
                if (!m.matches()) continue;
                p.extractMetadata(bytes, map);
                break;
            }
        }
        return map;
    }

    /*
     * Exception decompiling
     */
    public String detectContentType(byte[] bytes, String filename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        MetadataExtractor.register(new ImageMetadataExtractor());
        MetadataExtractor.register(new MP3MetadataParser());
    }
}

