/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.images.metadata;

import au.org.ala.images.metadata.AbstractMetadataParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.mp3.Mp3Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class MP3MetadataParser
extends AbstractMetadataParser {
    public static final Logger log = LoggerFactory.getLogger(MP3MetadataParser.class);

    @Override
    public Pattern getContentTypePattern() {
        return Pattern.compile("^audio/mp3$|^audio/mpeg$");
    }

    @Override
    public void extractMetadata(byte[] bytes, Map<String, String> md) {
        try {
            String[] metadataNames;
            ByteArrayInputStream input = new ByteArrayInputStream(bytes);
            DefaultHandler handler = new DefaultHandler();
            Metadata metadata = new Metadata();
            Mp3Parser parser = new Mp3Parser();
            ParseContext parseCtx = new ParseContext();
            parser.parse((InputStream)input, (ContentHandler)handler, metadata, parseCtx);
            ((InputStream)input).close();
            for (String name : metadataNames = metadata.names()) {
                md.put(name, metadata.get(name));
            }
        }
        catch (Exception e) {
            log.error("Exception extracting MP3 metadata", (Throwable)e);
        }
    }
}

